package com.stonecrusher.print;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;
import static org.vandeseer.easytable.settings.VerticalAlignment.BOTTOM;
import static org.vandeseer.easytable.settings.VerticalAlignment.MIDDLE;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.struts2.ServletActionContext;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.ProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetTaxPercentageByTaxId;
import com.stonecrusher.utils.NumberToWordsConverter;


public class BillPrintOnly extends ActionSupport implements SessionAware {

	/**
	 * 
	 */
	private static final long serialVersionUID = -1414976236123269184L;
	/**
	 * 
	 */

	private String nameOfBank;
	private String bankingName;
	private String nameOfBranch;
	private String accountNumber;
	private String ifscCode;

	private HttpSession session;
	private SessionMap<String, Object> sessionMap;
	private BillInformationDAO billInfoDAO = null;
	private List<BillProductInfoDAO> productInfoList = null;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private String billNumber;
	private String size;
	private String lang;

	private String billType;
	private String royalty;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
	private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
	private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

	private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
	private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
	private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
	private static final float PADDING10 = 10f;
	private static final float PADDING20 = 20f;
	private static final float PADDING30 = 30f;
	private static final float PADDING40 = 40f;
	private static final float PADDING50 = 50f;

	public void printBillOnly() throws Exception {
		String vehicleNumber = "";
		String tripFrom = "";
		String tripTo = "";
		String vehicleMake = "";
		String driverName = "";
		String driverMobileNumber = "";
		String custNameMarathi = "";
		String custAddMarathi = "";
		String billTime = "";
		boolean isBillNumberFound = false;
		String custGSTNo = "";
		String custPinCodeNumber = "";
		String shortName = "";
		float totalDiscAmt = 0.0f;
		float totalTaxableAmount = 0.0F;
		String account1CreditDebitId = "";
		String account2CreditDebitId = "";
		
		
		
		// System.out.println("Bill Number : "+billNumber);
		String noOfTrips = "1";
		DecimalFormat df = new DecimalFormat("##.##");
		Connection connection = null;
		PreparedStatement preparedStatement = null;
		ResultSet resultSet = null;

		String crusherId = (String) this.getSessionMap().get("crusherId");
		String crusherCode = (String) this.getSessionMap().get("crusherCode");

		String crushernameenglish = (String) this.getSessionMap().get("crushernameenglish");
		String companyDetailsDisplay = (String) this.getSessionMap().get("companyDetailsDisplayInThermalBillPrint");

		/*
		 * HashMap <String,String> crusherDetails = (HashMap<String, String>)
		 * this.getSessionMap().get("crusherdetails"); String crusherName =
		 * crusherDetails.get("crusher_name");
		 */
		String sql = "";
		String db = "crushererpsoft";
		String billDateTime = "";
		try {

			billInfoDAO = new BillInformationDAO();
			productInfoList = new ArrayList<BillProductInfoDAO>();

			connection = GetDBConnection.getDBConnection(db);
			
			 String tableBillInfo;
     		
     		
     		
     		
     		if(!this.getBillType().equals("TAX-INVOICE"))
 			{
     			sql = "select " 
    			        + "DATE_FORMAT(bill_date,'%d-%M-%Y')," 
    					+ "bill_time," 
    			        + "payment_type," 
    			        + "bill_type,"
    					+ "customer_id," 
    			        + "customer_name," 
    					+ "transportation_charges," 
    			        + "comments," 
    					+ "bill_total_amount,"
    					+ "bill_amount_received," 
    					+ "billed_by," 
    					+ "chalan_number,"
    					+ "account1_credit_debit_id,"
    					+ "account2_credit_debit_id " 
    					+ "FROM " 
    					+ "crusher_bill_info_master "
    					+ "WHERE " 
    					+ "bill_number = ? " 
    					+ "AND " 
    					+ "bill_type = ? " 
    					+ "AND " 
    					+ "crusher_id = ? " 
    					+ "AND "
    					+ "crusher_code = ?";
     			
 			}else {
 				
 				sql = "select " 
 				        + "DATE_FORMAT(bill_date,'%d-%M-%Y')," 
 						+ "bill_time," 
 				        + "payment_type," 
 				        + "bill_type,"
 						+ "customer_id," 
 				        + "customer_name," 
 						+ "transportation_charges," 
 				        + "comments," 
 						+ "bill_total_amount,"
 						+ "bill_amount_received," 
 						+ "billed_by," 
 						+ "chalan_number "
 						+ "FROM " 
 						+ "crusher_bill_info_master "
 						+ "WHERE " 
 						+ "bill_number = ? " 
 						+ "AND " 
 						+ "bill_type = ? " 
 						+ "AND " 
 						+ "crusher_id = ? " 
 						+ "AND "
 						+ "crusher_code = ?";
 				
 			}

			

			preparedStatement = connection.prepareStatement(sql);
			preparedStatement.setString(1, this.getBillNumber());
			preparedStatement.setString(2, this.getBillType());
			preparedStatement.setString(3, crusherId);
			preparedStatement.setString(4, crusherCode);

			resultSet = preparedStatement.executeQuery();

			resultSet.last();
			int rowCount = resultSet.getRow();
			resultSet.beforeFirst();

			if (rowCount > 0) {

				isBillNumberFound = true;
				while (resultSet.next()) {
					billInfoDAO.setBillDate(resultSet.getString(1));
					billDateTime = resultSet.getString(1) + " " + resultSet.getString(2);
					billTime = resultSet.getString(2);
					billInfoDAO.setBillNumber(getBillNumber());
					billInfoDAO.setPaymentType(resultSet.getString(3));
					billInfoDAO.setBillType(resultSet.getString(4));
					billInfoDAO.setCustId(resultSet.getString(5));
					billInfoDAO.setCustomerName(resultSet.getString(6));
					billInfoDAO.setTransportCharge(resultSet.getFloat(7));
					billInfoDAO.setComments(resultSet.getString(8));
					billInfoDAO.setTotalBillAmount(resultSet.getString(9));
					billInfoDAO.setTotalAmountPaid(resultSet.getString(10));
					billInfoDAO.setBilledBy(resultSet.getString(11));
					billInfoDAO.setChalanNumber(resultSet.getString(12));
					float totalAmtPaid = Float.parseFloat(resultSet.getString(10));
					float totalBillAmt = Float.parseFloat(resultSet.getString(9));

					float balanceAmount = totalAmtPaid - totalBillAmt;

					billInfoDAO.setTotalAmountBalance("" + balanceAmount);
					
					if(!this.getBillType().equals("TAX-INVOICE"))
		 			{
					account1CreditDebitId = resultSet.getString(13);
					account2CreditDebitId = resultSet.getString(14);
		 			}   

				}

				if (resultSet != null) {
					resultSet.close();
					resultSet = null;
				}
				if (preparedStatement != null) {
					preparedStatement.close();
					preparedStatement = null;

				}
				
				
				
				 String tableTripInfo;
		     		
				 if(this.getBillType().equals("TAX-INVOICE"))
		 			{
		     			tableTripInfo = "crusher_vehicle_trip_master ";
		 			}else {
		 				tableTripInfo = "crusher_vehicle_trip_master ";
		 			}
		     		
		     		

				sql = "SELECT " + "vt.trip_entry_id," + "DATE_FORMAT(vt.trip_date,'%d-%m-%Y')," + "vt.vehicle_id,"
						+ "vd.vehicle_make," + "vd.vehicle_registration_number," + "vt.customer_id,"
						+ "vt.customer_name," + "vt.product_name," + "vt.product_quantity," + "vt.vehicle_km_start,"
						+ "vt.vehicle_km_end," + "vt.trip_total_km," + "vt.trip_start_from," + "vt.trip_end_to,"
						+ "vt.total_trip_count," + "vt.trip_driver_name," + "vt.trip_driver_mobile_number " + "FROM "
						+ tableTripInfo +"as vt " + "INNER JOIN " + "crusher_vehicle_details_master as vd "
						+ "ON " + "vd.vehicle_id = vt.vehicle_id " + "WHERE " + "vt.bill_number = ? " + "AND "
						+ "vt.bill_type = ? " + "AND " + "vt.crusher_id = ? " + "AND " + "vt.crusher_code = ?" + "AND "
						+ "vd.crusher_id = ? " + "AND " + "vd.crusher_code = ?";

				preparedStatement = connection.prepareStatement(sql);

				preparedStatement.setString(1, this.getBillNumber());
				preparedStatement.setString(2, billInfoDAO.getBillType());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				preparedStatement.setString(5, crusherId);
				preparedStatement.setString(6, crusherCode);

				resultSet = preparedStatement.executeQuery();

				if (resultSet.next()) {
					vehicleMake = resultSet.getString(4);
					vehicleNumber = resultSet.getString(5);
					tripFrom = resultSet.getString(13);
					tripTo = resultSet.getString(14);
					noOfTrips = resultSet.getString(15);

					driverName = resultSet.getString(16);

					driverMobileNumber = resultSet.getString(17);
				}

				if (resultSet != null) {
					resultSet.close();
					resultSet = null;
				}
				if (preparedStatement != null) {
					preparedStatement.close();
					preparedStatement = null;

				}

				sql = "SELECT " + "customer_id," + "customer_name," + "cust_name_marathi," + "billing_address,"
						+ "billing_address_marathi," + "pincode_number," + "gst_number " + "FROM "
						+ "crusher_customer_master " + "WHERE " + "customer_id = ? " + "AND " + "crusher_id = ? "
						+ "AND " + "crusher_code = ?";

				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, billInfoDAO.getCustId());
				preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);

				resultSet = preparedStatement.executeQuery();

				if (resultSet.next()) {

					billInfoDAO.setCustomerAddress(resultSet.getString(4));
					custNameMarathi = resultSet.getString(3);
					custAddMarathi = resultSet.getString(5);
					custPinCodeNumber = resultSet.getString(6);
					custGSTNo = resultSet.getString(7);
				} else {
					billInfoDAO.setCustomerAddress("");
				}

				if (resultSet != null) {
					resultSet.close();
					resultSet = null;
				}
				if (preparedStatement != null) {
					preparedStatement.close();
					preparedStatement = null;

				}
				
				String tableProductInfo;
	     		
				if(this.getBillType().equals("TAX-INVOICE"))
	 			{
	     			tableProductInfo = "crusher_bill_product_info ";
	 			}else {
	 				tableProductInfo = "crusher_bill_product_info ";
	 			}
	     		
	     		
	     		
				sql = "SELECT " 
				        + "product_name," 
						+ "product_name_marathi," 
				        + "sales_unit," 
						+ "tax_percentage,"
						+ "sales_rate," 
						+ "sale_quantity," 
						+ "discount_percentage," 
						+ "total_discount_amount,"
						+ "product_sale_amount_before_discount," 
						+ "product_sale_amount_after_discount,"
						+ "product_gross_amount," 
						+ "product_igst," 
						+ "product_cgst_amount," 
						+ "product_sgst_amount,"
						+ "royalty,"
						+ "transport_charge " 
						+ "FROM " 
						+ tableProductInfo 
						+ "where bill_number = ? " 
						+ "AND "
						+ "bill_type = ? " 
						+ "AND " 
						+ "crusher_id = ? " 
						+ "AND " 
						+ "crusher_code = ?";

				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, this.getBillNumber());
				preparedStatement.setString(2, this.getBillInfoDAO().getBillType());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);

				resultSet = preparedStatement.executeQuery();

				while (resultSet.next()) {
					String getHSNCode = "SELECT hsn_sac_code FROM "
							+ "crusher_product_master WHERE product_name_eng = ? " + "AND " + "crusher_id = ? " + "AND "
							+ "crusher_code = ?";

					PreparedStatement getHSNCodePSMT = connection.prepareStatement(getHSNCode);

					getHSNCodePSMT.setString(1, resultSet.getString(1));
					getHSNCodePSMT.setString(2, crusherId);
					getHSNCodePSMT.setString(3, crusherCode);

					ResultSet getHSNRs = getHSNCodePSMT.executeQuery();
					String hsnCode = "";
					if (getHSNRs.next()) {
						hsnCode = getHSNRs.getString(1);
					} else {
						hsnCode = "NA";
					}

					if (getHSNRs != null) {
						getHSNRs.close();
						getHSNRs = null;
					}

					if (getHSNCodePSMT != null) {
						getHSNCodePSMT.close();
						getHSNCodePSMT = null;
					}

					BillProductInfoDAO billProductInfoDAO = new BillProductInfoDAO();
					billProductInfoDAO.setProductName(resultSet.getString(1));
					billProductInfoDAO.setProductNameMarathi(resultSet.getString(2));
					billProductInfoDAO.setSalesUnit(resultSet.getString(3));
					
					
					 shortName = GetListResource.GetUnitShortEnglishName().get(resultSet.getString(3));
							
							
					billProductInfoDAO.setTaxId(resultSet.getString(4));
					billProductInfoDAO.setTaxPercentage("" + GetTaxPercentageByTaxId
							.getTaxPercentageById(resultSet.getString(4), connection, this.getSessionMap()));
					billProductInfoDAO.setSalesRate(resultSet.getFloat(5));
					billProductInfoDAO.setQuantity(resultSet.getFloat(6));
					billProductInfoDAO.setDiscountPecentage(resultSet.getFloat(7));
					billProductInfoDAO.setDiscountRupees(resultSet.getFloat(8));
					billProductInfoDAO.setAmount(resultSet.getFloat(9));
					billProductInfoDAO.setAmountAfterDiscount(resultSet.getFloat(10));
					billProductInfoDAO.setGrossAmount(resultSet.getFloat(11));
					billProductInfoDAO.setIgst(resultSet.getFloat(12));
					billProductInfoDAO.setCgst(resultSet.getFloat(13));
					billProductInfoDAO.setSgst(resultSet.getFloat(14));
					billProductInfoDAO.setProductHSNCode(hsnCode);
					billProductInfoDAO.setRoyalty(resultSet.getFloat(15));
					billProductInfoDAO.setTransportCharges(resultSet.getFloat(16));
					
					this.setRoyalty(resultSet.getString(15));
					totalDiscAmt = totalDiscAmt + resultSet.getFloat(8);
					

					productInfoList.add(billProductInfoDAO);

				}
				
				if (resultSet != null) {
					resultSet.close();
					resultSet = null;
				}
				
				       
				String getCashOnlineAmtCode = "SELECT payment_type,"
						+ "amount "
						+ " FROM "
						+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
						+ "crusher_code = ?";

				PreparedStatement getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

				getCashOnlineAmtPSMT.setString(1, account1CreditDebitId);
				getCashOnlineAmtPSMT.setString(2, crusherId);
				getCashOnlineAmtPSMT.setString(3, crusherCode);

				ResultSet getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
				if (getCashOnlineAmtRs.next()) {
					billInfoDAO.setAcc1PaymentType(getCashOnlineAmtRs.getString(1));
					billInfoDAO.setAcc1Amount(getCashOnlineAmtRs.getString(2));
				} else {
					billInfoDAO.setAcc1PaymentType("NA");
					billInfoDAO.setAcc1Amount("0");
					
				}

				if (getCashOnlineAmtRs != null) {
					getCashOnlineAmtRs.close();
					getCashOnlineAmtRs = null;
				}

				if (getCashOnlineAmtPSMT != null) {
					getCashOnlineAmtPSMT.close();
					getCashOnlineAmtPSMT = null;
				}
				
				
				
				 getCashOnlineAmtCode = "SELECT payment_type,"
						+ "amount "
						+ " FROM "
						+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
						+ "crusher_code = ?";

				 getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

				getCashOnlineAmtPSMT.setString(1, account2CreditDebitId);
				getCashOnlineAmtPSMT.setString(2, crusherId);
				getCashOnlineAmtPSMT.setString(3, crusherCode);

				 getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
				if (getCashOnlineAmtRs.next()) {
					billInfoDAO.setAcc2PaymentType(getCashOnlineAmtRs.getString(1));
					billInfoDAO.setAcc2Amount(getCashOnlineAmtRs.getString(2));
				} else {
					billInfoDAO.setAcc2PaymentType("NA");
					billInfoDAO.setAcc2Amount("0");
					
				}

				if (getCashOnlineAmtRs != null) {
					getCashOnlineAmtRs.close();
					getCashOnlineAmtRs = null;
				}

				if (getCashOnlineAmtPSMT != null) {
					getCashOnlineAmtPSMT.close();
					getCashOnlineAmtPSMT = null;
				}

				
				
			}

			if (isBillNumberFound) {

				this.setNameOfBank((String) this.getSessionMap().get("name_of_bank"));
				this.setBankingName((String) this.getSessionMap().get("banking_name"));
				this.setNameOfBranch((String) this.getSessionMap().get("name_of_branch"));
				this.setAccountNumber((String) this.getSessionMap().get("account_number"));
				this.setIfscCode((String) this.getSessionMap().get("ifsc_code"));

				String crushercustcarenumber = (String) this.getSessionMap().get("crushercustcarenumber");
				String crushergstnumber = (String) this.getSessionMap().get("crushergstnumber");

				float floatTotalAmount = 0.0F;
				float floatTotalDiscount = 0.0F;
				float floatTotalAmtAfterDiscount = 0.0F;

				int listSize = productInfoList.size();
				float paperHightSize = 0.0f;
				paperHightSize = (listSize * 30) + 320;
				
				float totalRoyaltyAmount = 0.0f;
				float totalTrAmount = 0.0f;
				

				for (BillProductInfoDAO infoDAO : productInfoList) {
					// System.out.print("Amount after discount :
					// "+infoDAO.getProductTotalDiscount());
					floatTotalAmount = floatTotalAmount + infoDAO.getAmount();
					floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
					floatTotalDiscount = floatTotalDiscount + (infoDAO.getQuantity() * infoDAO.getDiscountRupees());
					totalRoyaltyAmount = totalRoyaltyAmount + infoDAO.getRoyalty();
					totalTrAmount = totalTrAmount + infoDAO.getTransportCharges();

				}

				/*
				 * System.out.println("Total Amount : "+floatTotalAmount);
				 * System.out.println("Total Discount : "+floatTotalDiscount);
				 * System.out.println("Total amount Payble : "+floatTotalAmtAfterDiscount);
				 */

				String address = (String) this.getSessionMap().get("crusheronelineaddress");
				  String emailId = (String) this.getSessionMap().get("dcemailaddress");
					
				String contactPersonName = "";
				String contactMobile = "";
				float totalMaterialCost = 0.0F;

				response = ServletActionContext.getResponse();

				request = ServletActionContext.getRequest();

				String path = request.getSession().getServletContext().getRealPath("/images/");

				
				
				  PDImageXObject pdLeftLogoImage = null;
				  PDImageXObject pdRightLogoImage = null;
                  PDImageXObject pdOwnerSignImage = null;
				  PDImageXObject pdCompanyStampImage = null;
					
				  
				  
				if (this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A4")
						&& billInfoDAO.getBillType().equals("TAX-INVOICE"))
				{

					PDDocument document = new PDDocument();
					PDPage page = null;
					page = new PDPage(PDRectangle.A4);

					document.addPage(page);
					
					
					 if(this.getSessionMap().get("left_logo_image_array") != null)
					 {
						 byte[] leftLogoBytes = (byte[]) this.getSessionMap().get("left_logo_image_array");
						
						 if (leftLogoBytes != null) 
						 {
						     String leftLogoFilePath = path + "/left_logo_temp.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(leftLogoFilePath))
						     {
						         fos.write(leftLogoBytes); 
						     }					      
						
						     pdLeftLogoImage = PDImageXObject.createFromFile(leftLogoFilePath, document); 
						 }
					 }
					 
					 if(this.getSessionMap().get("right_logo_image_array") != null)
					 {
					  byte[] rightLogoBytes = (byte[]) this.getSessionMap().get("right_logo_image_array");
						 if (rightLogoBytes != null) {
						     String rightLogoFilePath = path + "/right_logo_temp.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(rightLogoFilePath)) {
						         fos.write(rightLogoBytes); 
						     }

						      
						
						     pdRightLogoImage = PDImageXObject.createFromFile(rightLogoFilePath, document); 
						 }
					 }
						 
						 
					 if(this.getSessionMap().get("owner_sign_image_array") != null)
					 {
						 byte[] signImageBytes = (byte[]) this.getSessionMap().get("owner_sign_image_array");
						 if (signImageBytes != null) {
						     String signImageFilePath = path + "/owner_sign_image.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(signImageFilePath)) {
						         fos.write(signImageBytes); 
						     }
	
						      
						
						     pdOwnerSignImage = PDImageXObject.createFromFile(signImageFilePath, document); 
						 }
					 }
					 
					 if(this.getSessionMap().get("company_stamp_image_array") != null)
					 {
						 byte[] stampImageBytes = (byte[]) this.getSessionMap().get("company_stamp_image_array");
						 if (stampImageBytes != null) {
						     String stampImageFilePath = path + "/company_stamp_image.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(stampImageFilePath)) {
						         fos.write(stampImageBytes); 
						     }
	
						      
						
						     pdCompanyStampImage = PDImageXObject.createFromFile(stampImageFilePath, document); 
						 }
					 
					 }
					 
					 
					PDPageContentStream contentStream = new PDPageContentStream(document, page);

					String imagePath = request.getSession().getServletContext().getRealPath("/images/");

					Table header;
					Table billNumberTable;
					Table customerDetails;
					Table productDetails;
					Table totalAmountDetails;
					/* Table vehicleDetailsTable; */
					Table bottomInfo;
					Table signature;

					TableBuilder tableHeaderBuilder = Table.builder().addColumnsOfWidth(530).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					// System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
					Row taxInvoice = Row.builder()
							.add(TextCell.builder().text("TAX-INVOICE").horizontalAlignment(CENTER).borderWidth(0)
									.lineSpacing(0.5F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(12)
							.horizontalAlignment(CENTER).build();

					Row headerName = Row.builder()
							.add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER).borderWidth(0)
									.lineSpacing(0.5F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(15)
							.horizontalAlignment(CENTER).build();

					Row addressRow = Row.builder()
							.add(TextCell.builder().text(address).borderWidthBottom(0.5F).horizontalAlignment(CENTER)
									.build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(8)
							.horizontalAlignment(CENTER).build();

					Row contactRow = Row.builder()
							.add(TextCell.builder().text("Contact: " + contactPersonName + " - " + contactMobile + "  Customer Care No : " + crushercustcarenumber +",  Email Id :"+emailId)
									.borderWidthBottom(1F).horizontalAlignment(CENTER).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(8)
							.horizontalAlignment(CENTER).build();

					Row gstRow = Row.builder()
							.add(TextCell.builder().text("GST N0 : "+ crushergstnumber).borderWidthBottom(0.5F).horizontalAlignment(CENTER)
									.build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							.horizontalAlignment(CENTER).build();

					tableHeaderBuilder.addRow(taxInvoice);
					tableHeaderBuilder.addRow(headerName);
					tableHeaderBuilder.addRow(addressRow);
					tableHeaderBuilder.addRow(contactRow);
					tableHeaderBuilder.addRow(gstRow);

					header = tableHeaderBuilder.build();

					TableBuilder billNumberDate = Table.builder().addColumnsOfWidth(134, 130, 130, 130).font(HELVETICA)
							.borderWidth(1).borderColor(Color.BLACK);

					Row billNumberDateRow1 = Row.builder()
							.add(TextCell.builder().text("Invoice Number").horizontalAlignment(LEFT).borderWidth(0.5F)
									.fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getBillNumber()).horizontalAlignment(LEFT)
									.fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Invoice Date").horizontalAlignment(RIGHT).borderWidth(0.5F)
									.fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getBillDate()).horizontalAlignment(LEFT)
									.fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.horizontalAlignment(CENTER).build();

					Row billNumberDateRow2 = Row.builder()
							.add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).borderWidth(0.5F)
									.fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getPaymentType()).horizontalAlignment(LEFT)
									.borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text("Buyer Order Number").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8)
									.lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.horizontalAlignment(CENTER).build();
					Row billNumberDateRow3 = Row.builder()
							.add(TextCell.builder().text("State: Maharatshtra ").horizontalAlignment(LEFT)
									.borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
							.add(TextCell.builder().text("Code : 27").horizontalAlignment(LEFT).borderWidth(0.5F)
									.fontSize(10).lineSpacing(1F).build())
							.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("").horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							.horizontalAlignment(CENTER).build();

					billNumberDate.addRow(billNumberDateRow1);
					billNumberDate.addRow(billNumberDateRow2);
					billNumberDate.addRow(billNumberDateRow3);
					billNumberTable = billNumberDate.build();

					TableBuilder tableCustDetailsBuilder = Table.builder().addColumnsOfWidth(340, 115).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					Row custDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("Details Of Receiver (Billed To)").colSpan(2)
									.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							.horizontalAlignment(CENTER).build();
					String custDetails[] = billInfoDAO.getCustomerName().split("-");
					
					Row custDetailsRow2 = Row.builder()
							.add(TextCell.builder()
									.text("Customer Name:  " + this.getBillInfoDAO().getCustomerName().split("-")[1])
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F)
									.build())
							.add(TextCell.builder().text("State Code:  27").horizontalAlignment(LEFT).borderWidth(0)
									.borderWidthBottom(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(9)
							.horizontalAlignment(CENTER).build();

					Row custDetailsRow3 = Row.builder()
							.add(TextCell.builder().text("Address:  " + billInfoDAO.getCustomerAddress())
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F)
									.build())
							.add(TextCell.builder().text("GST No:  " + custGSTNo).horizontalAlignment(LEFT)
									.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(8)
							.horizontalAlignment(CENTER).build();

					Row custDetailsRow4 = Row.builder()
							.add(TextCell.builder().text("Mobile:  " + custDetails[2]).horizontalAlignment(LEFT)
									.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Pin:  " + custPinCodeNumber).horizontalAlignment(LEFT)
									.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(9)
							.horizontalAlignment(CENTER).build();

					tableCustDetailsBuilder.addRow(custDetailsRow1);
					tableCustDetailsBuilder.addRow(custDetailsRow2);
					tableCustDetailsBuilder.addRow(custDetailsRow3);
					tableCustDetailsBuilder.addRow(custDetailsRow4);

					customerDetails = tableCustDetailsBuilder.build();

					TableBuilder tableproductDetailsBuilder = Table.builder()
							.addColumnsOfWidth(20, 80, 50, 40, 40, 40, 50, 30, 50, 30, 50, 50).font(HELVETICA)
							.borderWidth(0.5F).borderColor(Color.BLACK);

					Row productDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("Sr.").rowSpan(2).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Description Of Goods").rowSpan(2).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("HSN Code").rowSpan(2).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Unit Price").rowSpan(2).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Unit").rowSpan(2).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Qty").rowSpan(2).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Taxable Amount").rowSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("SGST").colSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("CGST").colSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Total Amount").rowSpan(2).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.backgroundColor(Color.LIGHT_GRAY).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(7).horizontalAlignment(CENTER).build();
					tableproductDetailsBuilder.addRow(productDetailsRow1);
					Row taxNameRow1 = Row.builder()
							.add(TextCell.builder().text("Rate %").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Amount").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Rate %").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Amount").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.backgroundColor(Color.LIGHT_GRAY).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(7).horizontalAlignment(CENTER).build();

					tableproductDetailsBuilder.addRow(taxNameRow1);

					int srNo = 1;

					float allUnitTotalAmount = 0.0F;
					float totalSgst = 0.0F;
					float totalCgst = 0.0F;
					for (int i = 0; i <= 5; i++) {

						BillProductInfoDAO dao = null;
						try {
							dao = this.getProductInfoList().get(i);
						} catch (Exception e) {
							dao = null;
						}
						Row productDetailsRow = null;
						if (dao != null) {

							float basicPrice = 0.0F;
							float taxableAmount = 0.0F;
							float totalUnitAmount = 0.0F;
							float unitCgst = 0.0F;
							float unitSgst = 0.0F;
							float taxPercentage = 0.0F;
							float halfTaxPercentage = 0.0F;
							float taxAmt = 0.0F;
							float qty = dao.getQuantity();
							float royaltyAmount = dao.getRoyalty();
							float transportAmount = dao.getTransportCharges();
							

							try {

								taxAmt = dao.getGrossAmount();
								
								
								basicPrice = dao.getSalesRate();
								/*
								 * unitCgst = Float.parseFloat(dao.getCgst()); unitSgst =
								 * Float.parseFloat(dao.getSgst());
								 */
								taxPercentage = Float.parseFloat(dao.getTaxPercentage());

								taxableAmount = basicPrice * qty;

								totalMaterialCost = totalMaterialCost + taxableAmount;

								totalUnitAmount = basicPrice + unitCgst + unitSgst;

								allUnitTotalAmount = allUnitTotalAmount + totalUnitAmount;

								halfTaxPercentage = taxPercentage / 2.0F;

								totalSgst = totalSgst + dao.getSgst();
								totalCgst = totalCgst + dao.getCgst();

								 totalTaxableAmount = totalTaxableAmount + taxAmt ;
				        		 
								 
							} catch (NumberFormatException e) {
								e.printStackTrace();
							}

							// int qty = Integer.parseInt(dao.getProductQuantity());

							// totalMaterialCost = totalMaterialCost + totalUnitAmount;

							productDetailsRow = Row.builder()
									.add(TextCell.builder().text("" + srNo).horizontalAlignment(CENTER)
											.borderWidth(0.5F).lineSpacing(1F).build())
									.add(TextCell.builder().text(dao.getProductName().toUpperCase()).fontSize(9)
											.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.3F).build())
									.add(TextCell.builder().text("" + dao.getProductHSNCode().toUpperCase()).fontSize(9)
											.horizontalAlignment(LEFT).verticalAlignment(MIDDLE).borderWidth(0.5F)
											.lineSpacing(0.3F).build())
									.add(TextCell.builder().text(df.format(dao.getSalesRate()))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(""+dao.getSalesUnit())
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getQuantity()))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).fontSize(8).build())
									.add(TextCell.builder().text(df.format(taxAmt)).horizontalAlignment(RIGHT)
											.borderWidth(0.5F).fontSize(8).verticalAlignment(MIDDLE).lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(halfTaxPercentage))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getSgst())).horizontalAlignment(RIGHT)
											.borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(halfTaxPercentage))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getCgst())).horizontalAlignment(RIGHT)
											.borderWidth(0.5F).verticalAlignment(MIDDLE).lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getAmountAfterDiscount()))
											.horizontalAlignment(RIGHT).verticalAlignment(MIDDLE).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
									.fontSize(8).horizontalAlignment(CENTER).height(22F).build();

							srNo++;
						}

						else {

							productDetailsRow = Row.builder()
									.add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(0.5F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
									.fontSize(7).horizontalAlignment(CENTER).height(23F).build();

							srNo++;
						}

						tableproductDetailsBuilder.addRow(productDetailsRow);

					}

					productDetails = tableproductDetailsBuilder.build();

					Table bankDetails;

					TableBuilder bankDetailsBuilder = Table.builder().addColumnsOfWidth(90, 120).font(HELVETICA)
							.borderWidth(1).horizontalAlignment(LEFT).borderColor(Color.BLACK);

					Row bankDeHeaderRow = Row.builder()
							.add(TextCell.builder().text("Our Bank Details").colSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(20F).build();
					bankDetailsBuilder.addRow(bankDeHeaderRow);

					
					
					Row bankingNameRow = Row.builder()
							.add(TextCell.builder().text("Banking Name").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + this.getBankingName()).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(7).horizontalAlignment(CENTER).height(20F).build();
					bankDetailsBuilder.addRow(bankingNameRow);
					
					
					Row nameOfBankRow = Row.builder()
							.add(TextCell.builder().text("Name Of Bank").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + this.getNameOfBank()).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(7).horizontalAlignment(CENTER).height(20F).build();
					bankDetailsBuilder.addRow(nameOfBankRow);
					
					

					Row bankingBranchNameRow = Row.builder()
							.add(TextCell.builder().text("Branch").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + this.getNameOfBranch()).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(7).horizontalAlignment(CENTER).height(20F).build();
					bankDetailsBuilder.addRow(bankingBranchNameRow);

					Row ifscRow = Row.builder()
							.add(TextCell.builder().text("IFSC Code").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + this.getIfscCode()).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(7).horizontalAlignment(CENTER).height(20F).build();
					bankDetailsBuilder.addRow(ifscRow);

					Row accNumberRow = Row.builder()
							.add(TextCell.builder().text("Account Number").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + this.getAccountNumber()).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(7).horizontalAlignment(CENTER).height(20F).build();
					bankDetailsBuilder.addRow(accNumberRow);

					bankDetails = bankDetailsBuilder.build();

					/*
					 * TableBuilder vehicleDetailsBuilder = Table.builder().addColumnsOfWidth(90,
					 * 120).font(HELVETICA)
					 * .borderWidth(1).horizontalAlignment(LEFT).borderColor(Color.BLACK);
					 * 
					 * Row vehicleRow = Row.builder()
					 * .add(TextCell.builder().text("Trip Details").colSpan(2).padding(2)
					 * .horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(0.5F).build())
					 * .backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.
					 * HELVETICA_BOLD) .fontSize(7).horizontalAlignment(CENTER).height(10F).build();
					 * vehicleDetailsBuilder.addRow(vehicleRow);
					 * 
					 * Row vehicleRow1 = Row.builder()
					 * .add(TextCell.builder().text("Vehicle Make").padding(2).horizontalAlignment(
					 * LEFT) .borderWidth(0.5F).lineSpacing(0.5F).build())
					 * .add(TextCell.builder().text(vehicleMake).padding(2).horizontalAlignment(
					 * LEFT) .borderWidth(0.5F).lineSpacing(0.5F).build())
					 * .backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.
					 * HELVETICA_BOLD) .fontSize(7).horizontalAlignment(CENTER).height(10F).build();
					 * vehicleDetailsBuilder.addRow(vehicleRow1);
					 * 
					 * Row vehicleRow2 = Row.builder()
					 * .add(TextCell.builder().text("Vehicle Number").padding(2).horizontalAlignment
					 * (LEFT) .borderWidth(0.5F).lineSpacing(0.5F).build())
					 * .add(TextCell.builder().text(vehicleNumber).padding(2).horizontalAlignment(
					 * LEFT) .borderWidth(0.5F).lineSpacing(0.5F).build())
					 * .backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.
					 * HELVETICA_BOLD) .fontSize(7).horizontalAlignment(CENTER).height(10F).build();
					 * vehicleDetailsBuilder.addRow(vehicleRow2);
					 * 
					 * Row vehicleRow3 = Row.builder()
					 * .add(TextCell.builder().text("From").padding(2).horizontalAlignment(LEFT).
					 * borderWidth(0.5F) .lineSpacing(0.5F).build())
					 * .add(TextCell.builder().text(tripFrom).padding(2).horizontalAlignment(LEFT)
					 * .borderWidth(0.5F).lineSpacing(0.5F).build())
					 * .backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.
					 * HELVETICA_BOLD) .fontSize(7).horizontalAlignment(CENTER).height(10F).build();
					 * vehicleDetailsBuilder.addRow(vehicleRow3);
					 * 
					 * Row vehicleRow4 = Row.builder()
					 * .add(TextCell.builder().text("To").horizontalAlignment(LEFT).padding(2).
					 * borderWidth(0.5F) .lineSpacing(0.5F).build())
					 * .add(TextCell.builder().text(tripTo).horizontalAlignment(LEFT).padding(2).
					 * borderWidth(0.5F) .lineSpacing(0.5F).build())
					 * .backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.
					 * HELVETICA_BOLD) .fontSize(7).horizontalAlignment(CENTER).height(10F).build();
					 * vehicleDetailsBuilder.addRow(vehicleRow4);
					 * 
					 * new NumberToWordsConverter(); Row vehicleRow5 = Row.builder()
					 * .add(TextCell.builder().text("Total Trips").padding(2).horizontalAlignment(
					 * LEFT) .borderWidth(0.5F).lineSpacing(0.5F).build()) .add(TextCell.builder()
					 * .text(noOfTrips + " (" + NumberToWordsConverter.getConverted2("" + noOfTrips)
					 * + ")")
					 * .padding(2).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).
					 * build())
					 * .backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.
					 * HELVETICA_BOLD) .fontSize(7).horizontalAlignment(CENTER).height(10F).build();
					 * vehicleDetailsBuilder.addRow(vehicleRow5);
					 * 
					 * vehicleDetailsTable = vehicleDetailsBuilder.build();
					 */

					TableBuilder totalDetailsBuilder = Table.builder().addColumnsOfWidth(190, 120).font(HELVETICA)
							.borderWidth(1).horizontalAlignment(RIGHT).borderColor(Color.BLACK);

					Row materialCostRow = Row.builder()
							.add(TextCell.builder().text("Total Taxable Amount").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + totalTaxableAmount).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(18F).build();
					totalDetailsBuilder.addRow(materialCostRow);

					Row totalSgstAmount = Row.builder()
							.add(TextCell.builder().text("Total SGST Amount").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(df.format(totalSgst)).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(18F).build();
					totalDetailsBuilder.addRow(totalSgstAmount);

					Row totalCgstAmount = Row.builder()
							.add(TextCell.builder().text("Total CGST Amount").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(df.format(totalCgst)).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(18F).build();
					totalDetailsBuilder.addRow(totalCgstAmount);

					Row transportCostRow = Row.builder()
							.add(TextCell.builder().text("Transportation Charges").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + billInfoDAO.getTransportCharge())
									.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(18F).build();
					totalDetailsBuilder.addRow(transportCostRow);

					Row totalDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(billInfoDAO.getTotalBillAmount()).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(18F).build();
					totalDetailsBuilder.addRow(totalDetailsRow1);

					Row totalDetailsRow2 = Row.builder()
							.add(TextCell.builder().text("Total Amount Paid").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + Float.parseFloat(billInfoDAO.getTotalAmountPaid()))
									.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
					totalDetailsBuilder.addRow(totalDetailsRow2);

					Row totalDetailsRow3 = Row.builder()
							.add(TextCell.builder().text("Total Balance Amount").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(billInfoDAO.getTotalAmountBalance()).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(18F).build();
					totalDetailsBuilder.addRow(totalDetailsRow3);

					totalAmountDetails = totalDetailsBuilder.build();

					TableBuilder tableBottomInfoBuilder = Table.builder().addColumnsOfWidth(530).font(HELVETICA)
							.borderColor(Color.BLACK);

					Row bottomInfoRow2 = Row.builder()
							.add(TextCell.builder()
									.text("" + "Declaration : We declare that this bill shows the "
											+ "actual price of the goods described, that all perticulers "
											+ "are true and correct. ")
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F)
									.verticalAlignment(BOTTOM).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA).fontSize(9)
							.horizontalAlignment(CENTER).height(20F).build();

					Float totalAmounttoConvert = Float.parseFloat(billInfoDAO.getTotalBillAmount());

					DecimalFormat dfConvert = new DecimalFormat("##.##");
					new NumberToWordsConverter();
					String convertedAmount = NumberToWordsConverter
							.getConverted(dfConvert.format(totalAmounttoConvert));

					Row bottomInfoRow3 = Row.builder()
							.add(TextCell.builder().text("Amount in words :" + convertedAmount)
									.horizontalAlignment(LEFT).borderWidth(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(20F).build();

					tableBottomInfoBuilder.addRow(bottomInfoRow3);

					if (billInfoDAO.getComments() == null || billInfoDAO.getComments().equals("")) {
						billInfoDAO.setComments("NA");
					}
					if (billInfoDAO.getComments().equals("NA")) {
						Row bottomInfoRowComments = Row.builder()
								.add(TextCell.builder().text("Comments:").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
								.fontSize(10).height(30F).horizontalAlignment(CENTER).build();
						tableBottomInfoBuilder.addRow(bottomInfoRowComments);

					} else {
						Row bottomInfoRowComments = Row.builder()
								.add(TextCell.builder().text("Comments:" + billInfoDAO.getComments())
										.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
								.fontSize(10).height(30F).horizontalAlignment(CENTER).build();
						tableBottomInfoBuilder.addRow(bottomInfoRowComments);
					}
					tableBottomInfoBuilder.addRow(bottomInfoRow2);
					bottomInfo = tableBottomInfoBuilder.build();

					TableBuilder signatureBuiler = Table.builder().addColumnsOfWidth(250, 250).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					Row signRow1 = Row.builder()
							.add(TextCell.builder().text("Receiver Signature").verticalAlignment(BOTTOM)
									.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("For "+crushernameenglish).verticalAlignment(BOTTOM)
									.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(20F).build();
					signatureBuiler.addRow(signRow1);

					signature = signatureBuiler.build();

					float startY = page.getMediaBox().getHeight() - PADDING20;

					float yCordinate = page.getCropBox().getUpperRightY() - 72;
					float startX = page.getCropBox().getLowerLeftX() + 10;
					float endX = page.getCropBox().getUpperRightX() - 10;

					TableDrawer.builder().contentStream(contentStream).table(header).startX(PADDING40).startY(startY)
							.build().draw();

					TableDrawer.builder().contentStream(contentStream).table(billNumberTable).startX(PADDING40)
							.startY(startY - 100).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(customerDetails).startX(70)
							.startY(startY - 150).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(productDetails).startX(PADDING40)
							.startY(startY - 230).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(bankDetails).startX(PADDING40)
							.startY(startY - 405).build().draw();

					/*
					 * TableDrawer.builder().contentStream(contentStream).table(vehicleDetailsTable)
					 * .startX(PADDING40) .startY(startY - 470).build().draw();
					 */

					TableDrawer.builder().contentStream(contentStream).table(totalAmountDetails).startX(260)
							.startY(startY - 405).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(bottomInfo).startX(PADDING40)
							.startY(startY - 540).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(signature).startX(PADDING40)
							.startY(startY - 780).build().draw();

					
					
					  if(pdLeftLogoImage != null)
				         {
				        	 contentStream.drawImage(pdLeftLogoImage, 40, 770, 65, 65);
					         
				         }
				      
				         if(pdRightLogoImage != null)
				         {
				        	 contentStream.drawImage(pdRightLogoImage, 505, 770, 65, 65);
				         }
				         
				         if(pdOwnerSignImage != null)
				         {
				        	 contentStream.drawImage(pdOwnerSignImage, 380, 40, 90, 30);
				         }
				         
				         if(pdCompanyStampImage != null)
				         {
				        	 contentStream.drawImage(pdCompanyStampImage, 260, 40, 67, 67);
				         }
				         
				         
				         
					
					contentStream.close();

					
					
					

					// System.out.println(path);

					document.save(path + "/bill.pdf");
					document.close();

					response.setHeader("Content-disposition", "inline; filename=bill.pdf");
					response.setContentType("application/pdf");
					@SuppressWarnings("resource")
					FileInputStream fileInputStream = new FileInputStream(path + "/bill.pdf");
					PrintWriter out = response.getWriter();
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						out.write(bytes);
					}
					fileInputStream.close();
					out.flush();
					out.close();

				}

				if (this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A4")
						&& billInfoDAO.getBillType().equals("BILL-OF-SUPPLY")) {

					

						// System.out.println("Bill Type:"+billInfoDAO.getBillType());
						PDDocument document = new PDDocument();
						PDPage page = null;
						page = new PDPage(PDRectangle.A4);

						document.addPage(page);
						
						
						 if(this.getSessionMap().get("left_logo_image_array") != null)
						 {
							 byte[] leftLogoBytes = (byte[]) this.getSessionMap().get("left_logo_image_array");
							
							 if (leftLogoBytes != null) 
							 {
							     String leftLogoFilePath = path + "/left_logo_temp.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(leftLogoFilePath))
							     {
							         fos.write(leftLogoBytes); 
							     }					      
							
							     pdLeftLogoImage = PDImageXObject.createFromFile(leftLogoFilePath, document); 
							 }
						 }
						 
						 if(this.getSessionMap().get("right_logo_image_array") != null)
						 {
						  byte[] rightLogoBytes = (byte[]) this.getSessionMap().get("right_logo_image_array");
							 if (rightLogoBytes != null) {
							     String rightLogoFilePath = path + "/right_logo_temp.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(rightLogoFilePath)) {
							         fos.write(rightLogoBytes); 
							     }

							      
							
							     pdRightLogoImage = PDImageXObject.createFromFile(rightLogoFilePath, document); 
							 }
						 }
							 
							 
						 if(this.getSessionMap().get("owner_sign_image_array") != null)
						 {
							 byte[] signImageBytes = (byte[]) this.getSessionMap().get("owner_sign_image_array");
							 if (signImageBytes != null) {
							     String signImageFilePath = path + "/owner_sign_image.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(signImageFilePath)) {
							         fos.write(signImageBytes); 
							     }
		
							      
							
							     pdOwnerSignImage = PDImageXObject.createFromFile(signImageFilePath, document); 
							 }
						 }
						 
						 if(this.getSessionMap().get("company_stamp_image_array") != null)
						 {
							 byte[] stampImageBytes = (byte[]) this.getSessionMap().get("company_stamp_image_array");
							 if (stampImageBytes != null) {
							     String stampImageFilePath = path + "/company_stamp_image.jpeg";
							     try (FileOutputStream fos = new FileOutputStream(stampImageFilePath)) {
							         fos.write(stampImageBytes); 
							     }
		
							      
							
							     pdCompanyStampImage = PDImageXObject.createFromFile(stampImageFilePath, document); 
							 }
						 
						 }
						 
						PDPageContentStream contentStream = new PDPageContentStream(document, page);

						String imagePath = request.getSession().getServletContext().getRealPath("/images/");

						Table header;
						Table billNumberTable;
						Table customerDetails;
						Table productDetails;
						Table totalAmountDetails;
						Table vehicleDetailsTable;
						Table bottomInfo;
						Table signature;

						TableBuilder tableHeaderBuilder = Table.builder().addColumnsOfWidth(550).font(HELVETICA)
								.borderColor(Color.BLACK).horizontalAlignment(CENTER);

						// System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
						Row taxInvoice = Row.builder()
								.add(TextCell.builder().text("BILL-OF-SUPPLY").horizontalAlignment(CENTER)
										.borderWidth(0).lineSpacing(0.5F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(12).horizontalAlignment(CENTER).build();

						Row headerName = Row.builder()
								.add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER)
										.borderWidth(0).lineSpacing(0.5F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(15).horizontalAlignment(CENTER).build();

						Row addressRow = Row.builder()
								.add(TextCell.builder().text(address).borderWidthBottom(0.5F)
										.horizontalAlignment(CENTER).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(8).horizontalAlignment(CENTER).build();

						Row contactRow = Row.builder()
								.add(TextCell.builder().text(contactPersonName + " - " + contactMobile )
										.borderWidthBottom(1F).horizontalAlignment(CENTER).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(10).horizontalAlignment(CENTER).build();

						Row gstRow = Row.builder()
								.add(TextCell.builder().text("Customer Care No :"+ crushercustcarenumber +"  GST NO :" + crushergstnumber).borderWidthBottom(0.5F)
										.horizontalAlignment(CENTER).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(10).horizontalAlignment(CENTER).build();

						tableHeaderBuilder.addRow(taxInvoice);
						tableHeaderBuilder.addRow(headerName);
						tableHeaderBuilder.addRow(addressRow);
						tableHeaderBuilder.addRow(contactRow);
						tableHeaderBuilder.addRow(gstRow);

						header = tableHeaderBuilder.build();

						TableBuilder billNumberDate = Table.builder().addColumnsOfWidth(139, 135, 135, 135)
								.font(HELVETICA).borderWidth(1).borderColor(Color.BLACK);

						Row billNumberDateRow1 = Row.builder()
								.add(TextCell.builder().text("Chalan Number").horizontalAlignment(LEFT).borderWidth(0.5F)
										.fontSize(8).lineSpacing(1F).build())
								.add(TextCell.builder().text(billInfoDAO.getChalanNumber()).horizontalAlignment(LEFT)
										.fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
								.add(TextCell.builder().text("Bill Date").horizontalAlignment(RIGHT).borderWidth(0.5F)
										.fontSize(8).lineSpacing(1F).build())
								.add(TextCell.builder().text(billInfoDAO.getBillDate()).horizontalAlignment(LEFT)
										.fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.horizontalAlignment(CENTER).build();

						Row billNumberDateRow2 = Row.builder()
								.add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT)
										.borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
								.add(TextCell.builder().text(billInfoDAO.getPaymentType()).horizontalAlignment(LEFT)
										.borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
								.add(TextCell.builder().text("Buyer Order Number").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
								.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8)
										.lineSpacing(1F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.horizontalAlignment(CENTER).build();
						Row billNumberDateRow3 = Row.builder()
								.add(TextCell.builder().text("State: Maharatshtra ").horizontalAlignment(LEFT)
										.borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
								.add(TextCell.builder().text("Code : 27").horizontalAlignment(LEFT).borderWidth(0.5F)
										.fontSize(10).lineSpacing(1F).build())
								.add(TextCell.builder().text("Dispatch Doc. Number").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
								.add(TextCell.builder().text("").horizontalAlignment(LEFT).fontSize(10)
										.borderWidth(0.5F).lineSpacing(1F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(10).horizontalAlignment(CENTER).build();

						billNumberDate.addRow(billNumberDateRow1);
						billNumberDate.addRow(billNumberDateRow2);
						billNumberDate.addRow(billNumberDateRow3);
						billNumberTable = billNumberDate.build();

						TableBuilder tableCustDetailsBuilder = Table.builder().addColumnsOfWidth(475).font(HELVETICA)
								.borderColor(Color.BLACK).horizontalAlignment(CENTER);

						Row custDetailsRow1 = Row.builder()
								.add(TextCell.builder().text("Details Of Receiver (Billed To)")
										.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(1F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(10).horizontalAlignment(CENTER).build();

						String custDetails[] = billInfoDAO.getCustomerName().split("-");
						Row custDetailsRow2 = Row.builder()
								.add(TextCell.builder().text("Customer Name:  " + custDetails[1])
										.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F)
										.lineSpacing(1F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).build();

						Row custDetailsRow3 = Row.builder()
								.add(TextCell.builder().text("Address: " + billInfoDAO.getCustomerAddress())
										.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F)
										.lineSpacing(1F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(8).horizontalAlignment(CENTER).build();

						Row custDetailsRow4 = Row.builder()
								.add(TextCell.builder().text("Mobile:  " + custDetails[2]).horizontalAlignment(LEFT)
										.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).build();

						tableCustDetailsBuilder.addRow(custDetailsRow1);
						tableCustDetailsBuilder.addRow(custDetailsRow2);
						tableCustDetailsBuilder.addRow(custDetailsRow3);
						tableCustDetailsBuilder.addRow(custDetailsRow4);

						customerDetails = tableCustDetailsBuilder.build();

						TableBuilder tableproductDetailsBuilder = Table.builder().addColumnsOfWidth(30, 150, 60, 60, 60, 70, 60, 60)
								.font(HELVETICA).borderWidth(0.5F).borderColor(Color.BLACK);

						Row productDetailsRow1 = Row.builder()
								.add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(1F).build())
								.add(TextCell.builder().text("Description Of Goods").horizontalAlignment(LEFT)
										.borderWidth(0.5F).lineSpacing(1F).build())
								.add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(1F).build())
								.add(TextCell.builder().text("Unit").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(1F).build())
								.add(TextCell.builder().text("Unit Price").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(1F).build())
								.add(TextCell.builder().text("Total Amount").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(1F).build())
								.add(TextCell.builder().text("Disc.Amt.").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(1F).build())
								.add(TextCell.builder().text("Amt.Aft.Disc.").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(1F).build())
								.backgroundColor(Color.LIGHT_GRAY).textColor(Color.BLACK)
								.font(PDType1Font.HELVETICA_BOLD).fontSize(8).horizontalAlignment(CENTER).build();

						tableproductDetailsBuilder.addRow(productDetailsRow1);

						int srNo = 1;

						float allUnitTotalAmount = 0.0F;

						for (int i = 0; i <= 5; i++) {

							BillProductInfoDAO dao = null;
							try {
								dao = productInfoList.get(i);
							} catch (Exception e) {
								dao = null;
							}

							if (dao != null) {

								float basicPrice = 0.0F;
								float taxableAmount = 0.0F;
								float totalUnitAmount = 0.0F;
								float unitCgst = 0.0F;
								float unitSgst = 0.0F;
								float taxPercentage = 0.0F;
								float halfTax = 0.0F;
								float qty = dao.getQuantity();
								float royaltyAmt = dao.getRoyalty();
								float transportAMt = dao.getTransportCharges();
								
								try {

									basicPrice = dao.getSalesRate();
									/*
									 * unitCgst = Float.parseFloat(dao.getCgst()); unitSgst =
									 * Float.parseFloat(dao.getSgst()); taxPercentage =
									 * Float.parseFloat(dao.getTaxPercentage());
									 */

									taxableAmount = basicPrice * qty;

									totalMaterialCost = totalMaterialCost + taxableAmount;

									totalUnitAmount = basicPrice + unitCgst + unitSgst;

									allUnitTotalAmount = allUnitTotalAmount + totalUnitAmount;

									halfTax = taxPercentage / 2.0F;

								} catch (NumberFormatException e) {
									e.printStackTrace();
								}

								// int qty = Integer.parseInt(dao.getProductQuantity());

								Row productDetailsRow = Row.builder()
										.add(TextCell.builder().text("" + srNo).horizontalAlignment(CENTER)
												.borderWidth(0.5F).lineSpacing(1F).build())
										.add(TextCell.builder().text(dao.getProductName().toUpperCase())
												.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
										.add(TextCell.builder().text(df.format(dao.getQuantity()))
												.horizontalAlignment(LEFT).borderWidth(0.5F).verticalAlignment(MIDDLE)
												.lineSpacing(1F).build())
										.add(TextCell.builder().text(""+dao.getSalesUnit())
												.horizontalAlignment(LEFT).borderWidth(0.5F).verticalAlignment(MIDDLE)
												.lineSpacing(1F).build())
										.add(TextCell.builder().text(df.format(dao.getSalesRate()))
												.horizontalAlignment(LEFT).borderWidth(0.5F).verticalAlignment(MIDDLE)
												.lineSpacing(1F).build())
										.add(TextCell.builder().text("" + df.format(taxableAmount))
												.horizontalAlignment(LEFT).verticalAlignment(MIDDLE).borderWidth(0.5F)
												.lineSpacing(1F).build())
										.add(TextCell.builder().text("" + dao.getDiscountRupees())
												.horizontalAlignment(LEFT).verticalAlignment(MIDDLE).borderWidth(0.5F)
												.lineSpacing(1F).build())
										.add(TextCell.builder().text("" + dao.getAmountAfterDiscount())
												.horizontalAlignment(LEFT).verticalAlignment(MIDDLE).borderWidth(0.5F)
												.lineSpacing(1F).build())
										.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
										.fontSize(9).horizontalAlignment(CENTER).height(22F).build();
								tableproductDetailsBuilder.addRow(productDetailsRow);

								srNo++;
							}

							else {

								Row productDetailsRow = Row.builder()
										.add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F)
												.lineSpacing(0.5F).build())
										.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
												.lineSpacing(0.5F).build())
										.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
												.lineSpacing(0.5F).build())
										.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
												.lineSpacing(0.5F).build())
										.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
												.lineSpacing(0.5F).build())
										.add(TextCell.builder().text("")
												.horizontalAlignment(LEFT).verticalAlignment(MIDDLE).borderWidth(0.5F)
												.lineSpacing(1F).build())
										.add(TextCell.builder().text("")
												.horizontalAlignment(LEFT).verticalAlignment(MIDDLE).borderWidth(0.5F)
												.lineSpacing(1F).build())
										.add(TextCell.builder().text("")
												.horizontalAlignment(LEFT).borderWidth(0.5F).verticalAlignment(MIDDLE)
												.lineSpacing(1F).build())
										.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
										.fontSize(9).horizontalAlignment(CENTER).height(22F).build();
								tableproductDetailsBuilder.addRow(productDetailsRow);

								srNo++;
							}

						}

						productDetails = tableproductDetailsBuilder.build();

						TableBuilder vehicleDetailsBuilder = Table.builder().addColumnsOfWidth(100, 100).font(HELVETICA)
								.borderWidth(1).horizontalAlignment(LEFT).borderColor(Color.BLACK);

						Row vehicleRow = Row.builder()
								.add(TextCell.builder().text("Trip Details").colSpan(2).horizontalAlignment(CENTER)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(31F).build();
						vehicleDetailsBuilder.addRow(vehicleRow);

						Row vehicleRow1 = Row.builder()
								.add(TextCell.builder().text("Vehicle Make").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.add(TextCell.builder().text(vehicleMake).horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(30F).build();
						vehicleDetailsBuilder.addRow(vehicleRow1);

						Row vehicleRow2 = Row.builder()
								.add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text(vehicleNumber).horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(31F).build();
						vehicleDetailsBuilder.addRow(vehicleRow2);

						Row vehicleRow3 = Row.builder()
								.add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.add(TextCell.builder().text(tripFrom).horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(31F).build();
						vehicleDetailsBuilder.addRow(vehicleRow3);

						Row vehicleRow4 = Row.builder()
								.add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.add(TextCell.builder().text(tripTo).horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(31F).build();
						vehicleDetailsBuilder.addRow(vehicleRow4);

						vehicleDetailsTable = vehicleDetailsBuilder.build();
						
						
						TableBuilder totalDetailsBuilder = Table.builder().addColumnsOfWidth(220, 115).font(HELVETICA)
								.borderWidth(1).horizontalAlignment(RIGHT).borderColor(Color.BLACK);

						Row materialCostRow = Row.builder()
								.add(TextCell.builder().text("Total Material Cost").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("" + totalMaterialCost).horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(materialCostRow);
						
						Row totalDiscAmtRow = Row.builder()
								.add(TextCell.builder().text("Total Disc. Amt.").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("" +totalDiscAmt).horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(totalDiscAmtRow);
						
						
						if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
						
						
							Row royaltyRow = Row.builder()
									.add(TextCell.builder().text("Royalty").horizontalAlignment(RIGHT)
											.borderWidth(0.5F).lineSpacing(0.5F).build())
									.add(TextCell.builder().text("" + this.getRoyalty()).horizontalAlignment(RIGHT)
											.borderWidth(0.5F).lineSpacing(0.5F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
									.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
							totalDetailsBuilder.addRow(royaltyRow);
						
						
						
						}
						Row transportCostRow = Row.builder()
								.add(TextCell.builder().text("Transportation Charges").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("" + billInfoDAO.getTransportCharge())
										.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(transportCostRow);

						Row totalDetailsRow1 = Row.builder()
								.add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text(billInfoDAO.getTotalBillAmount())
										.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(totalDetailsRow1);
   
						String CashAmt = "0";
						String OnlineAmt = "0";
						if(billInfoDAO.getAcc1PaymentType().equals("CASH"))
						{
							CashAmt = billInfoDAO.getAcc1Amount();
							
						}else if(billInfoDAO.getAcc2PaymentType().equals("CASH"))
						{
							CashAmt = billInfoDAO.getAcc2Amount();
							
						}
						
						if(!billInfoDAO.getAcc1PaymentType().equals("CASH"))
						{
							OnlineAmt = billInfoDAO.getAcc1Amount();
							
						}else if(!billInfoDAO.getAcc2PaymentType().equals("CASH"))
						{
							OnlineAmt = billInfoDAO.getAcc2Amount();
							
						}
						
						Row totalCashRow = Row.builder()
								.add(TextCell.builder().text("Cash").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("" + CashAmt)
										.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(totalCashRow);
						
						Row totalOnlineRow = Row.builder()
								.add(TextCell.builder().text("Online").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("" + OnlineAmt)
										.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(totalOnlineRow);
						
						
						
						Row totalDetailsRow2 = Row.builder()
								.add(TextCell.builder().text("Total Amount Paid").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("" + Float.parseFloat(billInfoDAO.getTotalAmountPaid()))
										.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(totalDetailsRow2);

						Row totalDetailsRow3 = Row.builder()
								.add(TextCell.builder().text("Total Balance Amount").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text(billInfoDAO.getTotalAmountBalance())
										.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(17F).build();
						totalDetailsBuilder.addRow(totalDetailsRow3);

						totalAmountDetails = totalDetailsBuilder.build();

						TableBuilder tableBottomInfoBuilder = Table.builder().addColumnsOfWidth(550).font(HELVETICA)
								.borderColor(Color.BLACK);

						Row bottomInfoRow2 = Row.builder()
								.add(TextCell.builder()
										.text("" + "Declaration : We declare that this bill shows the "
												+ "actual price of the goods described, that all perticulers "
												+ "are true and correct. ")
										.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F)
										.verticalAlignment(BOTTOM).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
								.fontSize(9).horizontalAlignment(CENTER).height(20F).build();

						Float totalAmounttoConvert = Float.parseFloat(billInfoDAO.getTotalBillAmount());

						DecimalFormat dfConvert = new DecimalFormat("##.##");
						String convertedAmount = NumberToWordsConverter
								.getConverted(dfConvert.format(totalAmounttoConvert));

						Row bottomInfoRow3 = Row.builder()
								.add(TextCell.builder().text("Amount in words :" + convertedAmount)
										.horizontalAlignment(LEFT).borderWidth(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(20F).build();

						tableBottomInfoBuilder.addRow(bottomInfoRow3);

						if (billInfoDAO.getComments() == null || billInfoDAO.getComments().equals("")) {
							billInfoDAO.setComments("NA");
						}
						if (billInfoDAO.getComments().equals("NA")) {
							Row bottomInfoRowComments = Row.builder()
									.add(TextCell.builder().text("Comments:").horizontalAlignment(LEFT)
											.borderWidth(0.5F).lineSpacing(0.5F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
									.fontSize(10).height(30F).horizontalAlignment(CENTER).build();
							tableBottomInfoBuilder.addRow(bottomInfoRowComments);

						} else {
							Row bottomInfoRowComments = Row.builder()
									.add(TextCell.builder().text("Comments:" + billInfoDAO.getComments())
											.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
									.fontSize(10).height(30F).horizontalAlignment(CENTER).build();
							tableBottomInfoBuilder.addRow(bottomInfoRowComments);
						}
						tableBottomInfoBuilder.addRow(bottomInfoRow2);
						bottomInfo = tableBottomInfoBuilder.build();

						TableBuilder signatureBuiler = Table.builder().addColumnsOfWidth(260, 260).font(HELVETICA)
								.borderColor(Color.BLACK).horizontalAlignment(CENTER);

						Row signRow1 = Row.builder()
								.add(TextCell.builder().text("Receiver Signature").verticalAlignment(BOTTOM)
										.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("For Propriter").verticalAlignment(BOTTOM)
										.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(20F).build();
						signatureBuiler.addRow(signRow1);

						signature = signatureBuiler.build();

						float startY = page.getMediaBox().getHeight() - PADDING20;

						float yCordinate = page.getCropBox().getUpperRightY() - 72;
						float startX = page.getCropBox().getLowerLeftX() + 10;
						float endX = page.getCropBox().getUpperRightX() - 10;

						TableDrawer.builder().contentStream(contentStream).table(header).startX(PADDING20)
								.startY(startY).build().draw();

						TableDrawer.builder().contentStream(contentStream).table(billNumberTable).startX(PADDING20)
								.startY(startY - 100).build().draw();

						TableDrawer.builder().contentStream(contentStream).table(customerDetails).startX(70)
								.startY(startY - 150).build().draw();

						TableDrawer.builder().contentStream(contentStream).table(productDetails).startX(PADDING20)
								.startY(startY - 230).build().draw();

						TableDrawer.builder().contentStream(contentStream).table(vehicleDetailsTable).startX(PADDING20)
								.startY(startY - 385).build().draw();

						TableDrawer.builder().contentStream(contentStream).table(totalAmountDetails).startX(235)
								.startY(startY - 385).build().draw();

						if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
							TableDrawer.builder().contentStream(contentStream).table(bottomInfo).startX(PADDING20)
							.startY(startY - 545).build().draw();
	
							
						}else {
							TableDrawer.builder().contentStream(contentStream).table(bottomInfo).startX(PADDING20)
							.startY(startY - 530).build().draw();

						}
						
						
						TableDrawer.builder().contentStream(contentStream).table(signature).startX(PADDING20)
								.startY(startY - 790).build().draw();

						
						if(pdLeftLogoImage != null)
				         {
				        	 contentStream.drawImage(pdLeftLogoImage, 20, 770, 65, 65);
					         
				         }
				      
				         if(pdRightLogoImage != null)
				         {
				        	 contentStream.drawImage(pdRightLogoImage, 505, 770, 65, 65);
				         }
				         
				         if(pdOwnerSignImage != null)
				         {
				        	 contentStream.drawImage(pdOwnerSignImage, 380, 40, 90, 30);
				         }
				         
				         if(pdCompanyStampImage != null)
				         {
				        	 contentStream.drawImage(pdCompanyStampImage, 260, 40, 67, 67);
				         }
				         
				         
						contentStream.close();

						// System.out.println(path);

						document.save(path + "/bill.pdf");
						document.close();

						response.setHeader("Content-disposition", "inline; filename=bill.pdf");
						response.setContentType("application/pdf");
						@SuppressWarnings("resource")
						FileInputStream fileInputStream = new FileInputStream(path + "/bill.pdf");
						PrintWriter out = response.getWriter();
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.flush();
						out.close();

					

				}

				if (this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A5")) 
				{
					String bankingName = (String) this.getSessionMap().get("banking_name");
					String nameOfBank = (String) this.getSessionMap().get("name_of_bank");
					String nameOfBranch = (String) this.getSessionMap().get("name_of_branch");
					String accountNumber = (String) this.getSessionMap().get("account_number");
					String ifscCode = (String) this.getSessionMap().get("ifsc_code");
					String micrCode = (String) this.getSessionMap().get("micr_code");
					

					PDDocument document = new PDDocument();
					PDPage page = null;
					page = new PDPage(PDRectangle.A5);

					document.addPage(page);
					
					
					 if(this.getSessionMap().get("left_logo_image_array") != null)
					 {
						 byte[] leftLogoBytes = (byte[]) this.getSessionMap().get("left_logo_image_array");
						
						 if (leftLogoBytes != null) 
						 {
						     String leftLogoFilePath = path + "/left_logo_temp.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(leftLogoFilePath))
						     {
						         fos.write(leftLogoBytes); 
						     }					      
						
						     pdLeftLogoImage = PDImageXObject.createFromFile(leftLogoFilePath, document); 
						 }
					 }
					 
					 if(this.getSessionMap().get("right_logo_image_array") != null)
					 {
					  byte[] rightLogoBytes = (byte[]) this.getSessionMap().get("right_logo_image_array");
						 if (rightLogoBytes != null) {
						     String rightLogoFilePath = path + "/right_logo_temp.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(rightLogoFilePath)) {
						         fos.write(rightLogoBytes); 
						     }

						      
						
						     pdRightLogoImage = PDImageXObject.createFromFile(rightLogoFilePath, document); 
						 }
					 }
						 
						 
					 if(this.getSessionMap().get("owner_sign_image_array") != null)
					 {
						 byte[] signImageBytes = (byte[]) this.getSessionMap().get("owner_sign_image_array");
						 if (signImageBytes != null) {
						     String signImageFilePath = path + "/owner_sign_image.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(signImageFilePath)) {
						         fos.write(signImageBytes); 
						     }
	
						      
						
						     pdOwnerSignImage = PDImageXObject.createFromFile(signImageFilePath, document); 
						 }
					 }
					 
					 if(this.getSessionMap().get("company_stamp_image_array") != null)
					 {
						 byte[] stampImageBytes = (byte[]) this.getSessionMap().get("company_stamp_image_array");
						 if (stampImageBytes != null) {
						     String stampImageFilePath = path + "/company_stamp_image.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(stampImageFilePath)) {
						         fos.write(stampImageBytes); 
						     }
	
						      
						
						     pdCompanyStampImage = PDImageXObject.createFromFile(stampImageFilePath, document); 
						 }
					 
					 }
					 
					 
					PDPageContentStream contentStream = new PDPageContentStream(document, page);

					String imagePath = request.getSession().getServletContext().getRealPath("/images/");

					// PDImageXObject pdImageNirmitiLogo =
					// PDImageXObject.createFromFile(imagePath+"/nirmiti-logo.jpg", document);

					Table header;
					Table billNumberTable;
					Table customerDetails;
					Table productDetails;
					Table totalAmountDetails;
					Table vehicleDetailsTable;
					Table bankDetailsTable;
					Table bottomInfo;
					Table signature;

					TableBuilder tableHeaderBuilder = Table.builder().addColumnsOfWidth(380).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					// System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
					Row taxInvoice = Row.builder()
							.add(TextCell.builder().text("BILL-OF-SUPPLY").horizontalAlignment(CENTER).borderWidth(0)
									.lineSpacing(0.5F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(6)
							.horizontalAlignment(CENTER).build();

					Row headerName = Row.builder()
							.add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER).borderWidth(0)
									.lineSpacing(0.5F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							.horizontalAlignment(CENTER).build();

					// System.out.println("address : "+address);
					Row addressRow = Row.builder()
							.add(TextCell.builder().text(address).borderWidthBottom(0.5F).horizontalAlignment(CENTER)
									.build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(7)
							.horizontalAlignment(CENTER).build();

					Row contactRow = Row.builder()
							.add(TextCell.builder().text(contactPersonName + " - " + contactMobile)
									.borderWidthBottom(1F).horizontalAlignment(CENTER).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(7)
							.horizontalAlignment(CENTER).build();

					Row gstRow = Row.builder()
							.add(TextCell.builder().text("Customer Care No : "+ crushercustcarenumber +"  GST NO : " + crushergstnumber).borderWidthBottom(1F)
									.horizontalAlignment(CENTER).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(7)
							.horizontalAlignment(CENTER).build();

					tableHeaderBuilder.addRow(taxInvoice);
					tableHeaderBuilder.addRow(headerName);
					tableHeaderBuilder.addRow(addressRow);
					tableHeaderBuilder.addRow(contactRow);
					tableHeaderBuilder.addRow(gstRow);

					header = tableHeaderBuilder.build();

					TableBuilder billNumberDate = Table.builder().addColumnsOfWidth(60, 60, 60, 60, 40, 100)
							.font(HELVETICA).borderWidth(1).borderColor(Color.BLACK);

					Row billNumberDateRow1 = Row.builder()
							.add(TextCell.builder().text("Chalan Number").horizontalAlignment(LEFT).borderWidth(0.5F)
									.fontSize(6).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getChalanNumber()).horizontalAlignment(LEFT)
									.fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).borderWidth(0.5F)
									.fontSize(6).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getPaymentType()).horizontalAlignment(LEFT)
									.borderWidth(0.5F).fontSize(6).lineSpacing(1F).build())
							.add(TextCell.builder().text("Bill Date").horizontalAlignment(RIGHT).borderWidth(0.5F)
									.fontSize(6).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getBillDate()).horizontalAlignment(LEFT)
									.fontSize(8).borderWidth(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.horizontalAlignment(CENTER).build();

					/*
					 * Row billNumberDateRow2 = Row.builder()
					 * .add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).
					 * borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					 * .add(TextCell.builder().text(billInfoDAO.getPaymentType()).
					 * horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build
					 * ())
					 * .add(TextCell.builder().text("Buyer Order Number").horizontalAlignment(RIGHT)
					 * .borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).
					 * fontSize(8).lineSpacing(1F).build()) .backgroundColor(WHITE)
					 * .textColor(Color.BLACK) .font(PDType1Font.HELVETICA_BOLD)
					 * .horizontalAlignment(CENTER) .build(); Row billNumberDateRow3 = Row.builder()
					 * .add(TextCell.builder().text("State: Maharatshtra ").horizontalAlignment(LEFT
					 * ).borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("Code : 27").horizontalAlignment(LEFT).
					 * borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("Dispatch Doc. Number").horizontalAlignment(
					 * RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("").horizontalAlignment(LEFT).fontSize(10).
					 * borderWidth(0.5F).lineSpacing(1F).build()) .backgroundColor(WHITE)
					 * .textColor(Color.BLACK) .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					 * .horizontalAlignment(CENTER) .build();
					 */
					billNumberDate.addRow(billNumberDateRow1);
					// billNumberDate.addRow(billNumberDateRow2);
					// billNumberDate.addRow(billNumberDateRow3);
					billNumberTable = billNumberDate.build();

					TableBuilder tableCustDetailsBuilder = Table.builder().addColumnsOfWidth(380).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					Row custDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("Details Of Receiver (Billed To)").horizontalAlignment(CENTER)
									.borderWidth(0).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(7)
							.horizontalAlignment(CENTER).build();

					String custDetails[] = billInfoDAO.getCustomerName().split("-");

					Row custDetailsRow2 = Row.builder()
							.add(TextCell.builder().text("Customer Name:  " + custDetails[1]).horizontalAlignment(LEFT)
									.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(7)
							.horizontalAlignment(CENTER).build();

					// System.out.println(billInfoDAO.getCustomerAddress());

					Row custDetailsRow3 = Row.builder()
							.add(TextCell.builder().text("Address: " + billInfoDAO.getCustomerAddress())
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F)
									.build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(7)
							.horizontalAlignment(CENTER).build();

					Row custDetailsRow4 = Row.builder()
							.add(TextCell.builder().text("Mobile:  " + custDetails[2]).horizontalAlignment(LEFT)
									.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(7)
							.horizontalAlignment(CENTER).build();

					tableCustDetailsBuilder.addRow(custDetailsRow1);
					tableCustDetailsBuilder.addRow(custDetailsRow2);
					tableCustDetailsBuilder.addRow(custDetailsRow3);
					tableCustDetailsBuilder.addRow(custDetailsRow4);

					customerDetails = tableCustDetailsBuilder.build();

					TableBuilder tableproductDetailsBuilder = Table.builder().addColumnsOfWidth(20, 100, 30, 40, 50, 50, 50, 50)
							.font(HELVETICA).borderWidth(0.5F).borderColor(Color.BLACK);

					Row productDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Description Of Goods").horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Unit").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Unit Price").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Total Amount").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Disc.Amt.").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("Amt.Aft.Disc.").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.backgroundColor(Color.LIGHT_GRAY).textColor(Color.BLACK).height(12.0F)
							.font(PDType1Font.HELVETICA_BOLD).fontSize(6).horizontalAlignment(CENTER).build();

					tableproductDetailsBuilder.addRow(productDetailsRow1);

					int srNo = 1;

					float allUnitTotalAmount = 0.0F;

					for (int i = 0; i <= 5; i++) {

						BillProductInfoDAO dao = null;
						try {
							dao = productInfoList.get(i);
						} catch (Exception e) {
							dao = null;
						}

						if (dao != null) {

							float basicPrice = 0.0F;
							float taxableAmount = 0.0F;
							float totalUnitAmount = 0.0F;
							float unitCgst = 0.0F;
							float unitSgst = 0.0F;
							float taxPercentage = 0.0F;
							float halfTax = 0.0F;
							float qty = dao.getQuantity();
							try {

								basicPrice = dao.getSalesRate();
								/*
								 * unitCgst = Float.parseFloat(dao.getCgst()); unitSgst =
								 * Float.parseFloat(dao.getSgst()); taxPercentage =
								 * Float.parseFloat(dao.getTaxPercentage());
								 */

								taxableAmount = basicPrice * qty;

								totalMaterialCost = totalMaterialCost + taxableAmount;

								totalUnitAmount = basicPrice + unitCgst + unitSgst;

								allUnitTotalAmount = allUnitTotalAmount + totalUnitAmount;

								halfTax = taxPercentage / 2.0F;

							} catch (NumberFormatException e) {
								e.printStackTrace();
							}

							// int qty = Integer.parseInt(dao.getProductQuantity());

							// totalMaterialCost = totalMaterialCost + totalUnitAmount;

							Row productDetailsRow = Row.builder()
									.add(TextCell.builder().text("" + srNo).horizontalAlignment(CENTER)
											.borderWidth(0.5F).lineSpacing(1F).build())
									.add(TextCell.builder().text(dao.getProductName().toUpperCase())
											.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getQuantity()))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(""+dao.getSalesUnit())
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getSalesRate()))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("" + df.format(taxableAmount))
											.horizontalAlignment(RIGHT).verticalAlignment(MIDDLE).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(""+dao.getDiscountRupees())
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(""+dao.getAmountAfterDiscount())
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
									.fontSize(8).horizontalAlignment(CENTER).height(15F).build();
							tableproductDetailsBuilder.addRow(productDetailsRow);

							srNo++;
						}

						else {

							Row productDetailsRow = Row.builder()
									.add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("")
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("")
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("")
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
									.fontSize(8).horizontalAlignment(CENTER).height(15F).build();
							tableproductDetailsBuilder.addRow(productDetailsRow);

							srNo++;
						}

					}

					productDetails = tableproductDetailsBuilder.build();

					TableBuilder vehicleDetailsBuilder = Table.builder().addColumnsOfWidth(70, 90).font(HELVETICA)
							.borderWidth(0.5F).horizontalAlignment(LEFT).borderColor(Color.BLACK);

					Row vehicleRow = Row.builder()
							.add(TextCell.builder().text("Trip Details").colSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(6).horizontalAlignment(CENTER).height(12F).build();
					vehicleDetailsBuilder.addRow(vehicleRow);

					Row vehicleRow1 = Row.builder()
							.add(TextCell.builder().text("Vehicle Make").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(vehicleMake).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					vehicleDetailsBuilder.addRow(vehicleRow1);

					Row vehicleRow2 = Row.builder()
							.add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(vehicleNumber).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					vehicleDetailsBuilder.addRow(vehicleRow2);

					/*
					 * Row vehicleRow3 = Row.builder()
					 * .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.
					 * 5F).lineSpacing(0.5F).build())
					 * .add(TextCell.builder().text(tripFrom).horizontalAlignment(LEFT).borderWidth(
					 * 0.5F).lineSpacing(0.5F).build()) .backgroundColor(Color.WHITE)
					 * .textColor(Color.BLACK) .font(PDType1Font.HELVETICA_BOLD) .fontSize(7)
					 * .horizontalAlignment(CENTER) .height(23F) .build();
					 * vehicleDetailsBuilder.addRow(vehicleRow3);
					 */

					Row vehicleRow4 = Row.builder()
							.add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(tripTo).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					vehicleDetailsBuilder.addRow(vehicleRow4);

					Row vehicleRow5 = Row.builder()
							.add(TextCell.builder().text("Driver").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(driverName).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					vehicleDetailsBuilder.addRow(vehicleRow5);

					Row vehicleRow6 = Row.builder()
							.add(TextCell.builder().text("Mobile").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(driverMobileNumber).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					vehicleDetailsBuilder.addRow(vehicleRow6);

					vehicleDetailsTable = vehicleDetailsBuilder.build();

					
					TableBuilder bankDetailsBuilder = Table.builder().addColumnsOfWidth(70, 90).font(HELVETICA)
							.borderWidth(0.5F).horizontalAlignment(LEFT).borderColor(Color.BLACK);

					Row bankRow = Row.builder()
							.add(TextCell.builder().text("Bank Details").colSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(6).horizontalAlignment(CENTER).height(12F).build();
					bankDetailsBuilder.addRow(bankRow);

					Row bankRow1 = Row.builder()
							.add(TextCell.builder().text("Banking Name").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(""+bankingName).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					bankDetailsBuilder.addRow(bankRow1);

					Row bankRow2 = Row.builder()
							.add(TextCell.builder().text("Name Of Bank").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(""+nameOfBank).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					bankDetailsBuilder.addRow(bankRow2);

				
					Row bankRow3 = Row.builder()
							.add(TextCell.builder().text("Name Of Branch").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(""+nameOfBranch).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					bankDetailsBuilder.addRow(bankRow3);

					Row bankRow4 = Row.builder()
							.add(TextCell.builder().text("Account Number").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(""+accountNumber).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					bankDetailsBuilder.addRow(bankRow4);

					Row bankRow5= Row.builder()
							.add(TextCell.builder().text("IFSC Code").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(""+ifscCode).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					bankDetailsBuilder.addRow(bankRow5);

					Row bankRow6 = Row.builder()
							.add(TextCell.builder().text("MICR Code").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(""+micrCode).horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(5).horizontalAlignment(CENTER).height(11F).build();
					bankDetailsBuilder.addRow(bankRow6);

					
					bankDetailsTable = bankDetailsBuilder.build();

					
					
					TableBuilder totalDetailsBuilder = Table.builder().addColumnsOfWidth(120, 100).font(HELVETICA)
							.borderWidth(1).horizontalAlignment(RIGHT).borderColor(Color.BLACK);

					Row materialCostRow = Row.builder()
							.add(TextCell.builder().text("Total Material Cost").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + totalMaterialCost).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(materialCostRow);
					Row totalDiscAmtRow = Row.builder()
							.add(TextCell.builder().text("Total Disc. Amt.").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" +totalDiscAmt).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(totalDiscAmtRow);

					
					if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
						 if (!"TAX-INVOICE".equals(this.getBillType())) {
				    	     
					
						Row royaltyRow = Row.builder()
								.add(TextCell.builder().text("Royalty").horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.add(TextCell.builder().text("" + this.getRoyalty()).horizontalAlignment(RIGHT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
								.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
						totalDetailsBuilder.addRow(royaltyRow);
						 }
					
					}
					Row transportCostRow = Row.builder()
							.add(TextCell.builder().text("Transportation Charges").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + billInfoDAO.getTransportCharge())
									.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(transportCostRow);

					Row totalDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(billInfoDAO.getTotalBillAmount()).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(totalDetailsRow1);

					
					String CashAmt = "0";
					String OnlineAmt = "0";
					if(billInfoDAO.getAcc1PaymentType().equals("CASH"))
					{
						CashAmt = billInfoDAO.getAcc1Amount();
						
					}else if(billInfoDAO.getAcc2PaymentType().equals("CASH"))
					{
						CashAmt = billInfoDAO.getAcc2Amount();
						
					}
					
					if(!billInfoDAO.getAcc1PaymentType().equals("CASH"))
					{
						OnlineAmt = billInfoDAO.getAcc1Amount();
						
					}else if(!billInfoDAO.getAcc2PaymentType().equals("CASH"))
					{
						OnlineAmt = billInfoDAO.getAcc2Amount();
						
					}
					
					Row totalCashRow = Row.builder()
							.add(TextCell.builder().text("Cash").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + CashAmt)
									.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(totalCashRow);
					
					Row totalOnlineRow = Row.builder()
							.add(TextCell.builder().text("Online").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + OnlineAmt)
									.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(totalOnlineRow);
					
					
					
					
					Row totalDetailsRow2 = Row.builder()
							.add(TextCell.builder().text("Total Amount Paid").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + Float.parseFloat(billInfoDAO.getTotalAmountPaid()))
									.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(totalDetailsRow2);

					Row totalDetailsRow3 = Row.builder()
							.add(TextCell.builder().text("Total Balance Amount").horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(billInfoDAO.getTotalAmountBalance()).horizontalAlignment(RIGHT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(16F).build();
					totalDetailsBuilder.addRow(totalDetailsRow3);
      
					totalAmountDetails = totalDetailsBuilder.build();

					TableBuilder tableBottomInfoBuilder = Table.builder().addColumnsOfWidth(390).font(HELVETICA)
							.borderColor(Color.BLACK);

					Row bottomInfoRow2 = Row.builder()
							.add(TextCell.builder()
									.text("" + "Declaration : We declare that this bill shows the "
											+ "actual price of the goods described, that all perticulers "
											+ "are true and correct. ")
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F)
									.verticalAlignment(BOTTOM).lineSpacing(1F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA).fontSize(8)
							.horizontalAlignment(CENTER).height(15F).build();

					Float totalAmounttoConvert = Float.parseFloat(billInfoDAO.getTotalBillAmount());

					DecimalFormat dfConvert = new DecimalFormat("##.##");
					String convertedAmount = NumberToWordsConverter
							.getConverted(dfConvert.format(totalAmounttoConvert));

					Row bottomInfoRow3 = Row.builder()
							.add(TextCell.builder().text("Amount in words :" + convertedAmount)
									.horizontalAlignment(LEFT).borderWidth(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(9).horizontalAlignment(CENTER).height(30F).build();

					tableBottomInfoBuilder.addRow(bottomInfoRow3);

					if (billInfoDAO.getComments() == null || billInfoDAO.getComments().equals("")) {
						billInfoDAO.setComments("NA");
					}
					if (billInfoDAO.getComments().equals("NA")) {
						Row bottomInfoRowComments = Row.builder()
								.add(TextCell.builder().text("Comments:").horizontalAlignment(LEFT).borderWidth(0.5F)
										.lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
								.fontSize(8).height(20F).horizontalAlignment(CENTER).build();
						tableBottomInfoBuilder.addRow(bottomInfoRowComments);

					} else {
						Row bottomInfoRowComments = Row.builder()
								.add(TextCell.builder().text("Comments:" + billInfoDAO.getComments())
										.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
								.fontSize(8).height(20F).horizontalAlignment(CENTER).build();
						tableBottomInfoBuilder.addRow(bottomInfoRowComments);
					}
					tableBottomInfoBuilder.addRow(bottomInfoRow2);
					bottomInfo = tableBottomInfoBuilder.build();

					TableBuilder signatureBuiler = Table.builder().addColumnsOfWidth(190, 190).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					Row signRow1 = Row.builder()
							.add(TextCell.builder().text("Receiver Signature").verticalAlignment(BOTTOM)
									.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("For Propriter").verticalAlignment(BOTTOM)
									.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
							.fontSize(8).horizontalAlignment(CENTER).height(20F).build();
					signatureBuiler.addRow(signRow1);

					signature = signatureBuiler.build();

					float startY = page.getMediaBox().getHeight() - PADDING20;

					float yCordinate = page.getCropBox().getUpperRightY() - 72;
					float startX = page.getCropBox().getLowerLeftX() + 10;
					float endX = page.getCropBox().getUpperRightX() - 10;

					TableDrawer.builder().contentStream(contentStream).table(header).startX(PADDING20).startY(startY)
							.build().draw();

					TableDrawer.builder().contentStream(contentStream).table(billNumberTable).startX(PADDING20)
							.startY(startY - 70).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(customerDetails).startX(PADDING20)
							.startY(startY - 90).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(productDetails).startX(PADDING20)
							.startY(startY - 150).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(vehicleDetailsTable).startX(PADDING20)
							.startY(startY - 255).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(bankDetailsTable).startX(PADDING20)
					.startY(startY - 325).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(totalAmountDetails).startX(190)
							.startY(startY - 255).build().draw();

					
					
					
					if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
						 if (!"TAX-INVOICE".equals(this.getBillType())) {
					    	 TableDrawer.builder().contentStream(contentStream).table(bottomInfo).startX(PADDING20)
						.startY(startY - 405).build().draw();
						 }else {
								TableDrawer.builder().contentStream(contentStream).table(bottomInfo).startX(PADDING20)
								.startY(startY - 390).build().draw();

							}
						
					}else {
						TableDrawer.builder().contentStream(contentStream).table(bottomInfo).startX(PADDING20)
						.startY(startY - 390).build().draw();

					}
					
					

					TableDrawer.builder().contentStream(contentStream).table(signature).startX(PADDING20)
							.startY(startY - 540).build().draw();

					
					
					if(pdLeftLogoImage != null)
			         {
			        	 contentStream.drawImage(pdLeftLogoImage, 20, 535, 60, 55);
				         
			         }
			      
			         if(pdRightLogoImage != null)
			         {
			        	 contentStream.drawImage(pdRightLogoImage, 340, 535, 60, 55);
			         }
			         
			         if(pdOwnerSignImage != null)
			         {
			        	 contentStream.drawImage(pdOwnerSignImage, 280, 40, 90, 30);
			         }
			         
			         if(pdCompanyStampImage != null)
			         {
			        	 contentStream.drawImage(pdCompanyStampImage, 180, 40, 67, 67);
			         }
			         
			         
					// contentStream.drawImage(pdImageNirmitiLogo, 30, 550, 100, 30);
					contentStream.close();

					// System.out.println(path);

					
					
					document.save(path + "/bill.pdf");
					document.close();

					response.setHeader("Content-disposition", "inline; filename=bill.pdf");
					response.setContentType("application/pdf");
					@SuppressWarnings("resource")
					FileInputStream fileInputStream = new FileInputStream(path + "/bill.pdf");
					PrintWriter out = response.getWriter();
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						out.write(bytes);
					}
					fileInputStream.close();
					out.flush();
					out.close();

				}

				if (this.getLang().equalsIgnoreCase("mar") && this.getSize().equals("A5")) {

					PDDocument document = new PDDocument();
					PDPage page = null;
					page = new PDPage(PDRectangle.A5);

					document.addPage(page);
					
					
					 if(this.getSessionMap().get("left_logo_image_array") != null)
					 {
						 byte[] leftLogoBytes = (byte[]) this.getSessionMap().get("left_logo_image_array");
						
						 if (leftLogoBytes != null) 
						 {
						     String leftLogoFilePath = path + "/left_logo_temp.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(leftLogoFilePath))
						     {
						         fos.write(leftLogoBytes); 
						     }					      
						
						     pdLeftLogoImage = PDImageXObject.createFromFile(leftLogoFilePath, document); 
						 }
					 }
					 
					 if(this.getSessionMap().get("right_logo_image_array") != null)
					 {
					  byte[] rightLogoBytes = (byte[]) this.getSessionMap().get("right_logo_image_array");
						 if (rightLogoBytes != null) {
						     String rightLogoFilePath = path + "/right_logo_temp.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(rightLogoFilePath)) {
						         fos.write(rightLogoBytes); 
						     }

						      
						
						     pdRightLogoImage = PDImageXObject.createFromFile(rightLogoFilePath, document); 
						 }
					 }
						 
						 
					 if(this.getSessionMap().get("owner_sign_image_array") != null)
					 {
						 byte[] signImageBytes = (byte[]) this.getSessionMap().get("owner_sign_image_array");
						 if (signImageBytes != null) {
						     String signImageFilePath = path + "/owner_sign_image.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(signImageFilePath)) {
						         fos.write(signImageBytes); 
						     }
	
						      
						
						     pdOwnerSignImage = PDImageXObject.createFromFile(signImageFilePath, document); 
						 }
					 }
					 
					 if(this.getSessionMap().get("company_stamp_image_array") != null)
					 {
						 byte[] stampImageBytes = (byte[]) this.getSessionMap().get("company_stamp_image_array");
						 if (stampImageBytes != null) {
						     String stampImageFilePath = path + "/company_stamp_image.jpeg";
						     try (FileOutputStream fos = new FileOutputStream(stampImageFilePath)) {
						         fos.write(stampImageBytes); 
						     }
	
						      
						
						     pdCompanyStampImage = PDImageXObject.createFromFile(stampImageFilePath, document); 
						 }
					 
					 }
					 
					 
					PDPageContentStream contentStream = new PDPageContentStream(document, page);

					String imagePath = request.getSession().getServletContext().getRealPath("/images/");

					PDImageXObject pdImagejagdambaLogo = PDImageXObject.createFromFile(imagePath + "mrbillhead.jpg",
							document);
					// PDImageXObject pdImageNirmitiHeading =
					// PDImageXObject.createFromFile(imagePath+"/nirmiti-heading.png", document);
					// PDImageXObject pdImageYashSCAddress =
					// PDImageXObject.createFromFile(imagePath+"/yash-sc-address.jpg", document);
					/*
					 * PDImageXObject pdImageNirmitiContact =
					 * PDImageXObject.createFromFile(imagePath+"/nirmiti-contact.png", document);
					 * PDImageXObject pdImageNirmitiSiteContact =
					 * PDImageXObject.createFromFile(imagePath+"/nirmiti-site-contact.png",
					 * document);
					 * 
					 */
					File fontFile = new File(
							request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
					File fontFileBold = new File(
							request.getSession().getServletContext().getRealPath("/fonts/nirmala-bold.ttf"));

					TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
					TrueTypeFont ttf2 = new TTFParser().parse(fontFileBold);

					File fontFilekrutiDev = new File(
							request.getSession().getServletContext().getRealPath("/fonts/Krutidev.ttf"));

					TrueTypeFont ttf3 = new TTFParser().parse(fontFilekrutiDev);

					PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
					PDFont fontMarathiBold = PDType0Font.load(document, ttf2, true);
					PDFont krutiDev = PDType0Font.load(document, ttf3, true);

					Table header;
					Table billNumberTable;
					Table customerDetails;
					Table productDetails;
					Table totalAmountDetails;
					Table vehicleDetailsTable;
					Table bottomInfo;
					Table signature;

					TableBuilder tableHeaderBuilder = Table.builder().addColumnsOfWidth(380).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					// System.out.println("Bill Type -"+sagarBillDAO.getTypeOfBill());
					Row taxInvoice = Row.builder()
							.add(TextCell.builder().text("BILL-OF-SUPPLY").horizontalAlignment(CENTER).borderWidth(0)
									.lineSpacing(0.5F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(6)
							.horizontalAlignment(CENTER).build();

					Row headerName = Row.builder()
							.add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER).borderWidth(0)
									.lineSpacing(0.5F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(fontMarathi).fontSize(15)
							.horizontalAlignment(CENTER).build();

					Row addressRow = Row.builder()
							.add(TextCell.builder().text(address).borderWidthBottom(0.5F).horizontalAlignment(CENTER)
									.build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(fontMarathi).fontSize(7)
							.horizontalAlignment(CENTER).build();

					Row contactRow = Row.builder()
							.add(TextCell.builder().text(contactPersonName + " - " + contactMobile)
									.borderWidthBottom(1F).horizontalAlignment(CENTER).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(fontMarathi).fontSize(7)
							.horizontalAlignment(CENTER).build();

					Row gstRow = Row.builder()
							.add(TextCell.builder().text(""+ crushercustcarenumber+"  GST NO : " + crushergstnumber).borderWidthBottom(0.5F)
									.horizontalAlignment(CENTER).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							.horizontalAlignment(CENTER).build();

					tableHeaderBuilder.addRow(taxInvoice);
					// tableHeaderBuilder.addRow(headerName);
					// tableHeaderBuilder.addRow(addressRow);
					// tableHeaderBuilder.addRow(contactRow);
					// tableHeaderBuilder.addRow(gstRow);

					header = tableHeaderBuilder.build();

					TableBuilder billNumberDate = Table.builder().addColumnsOfWidth(60, 60, 60, 60, 40, 100)
							.font(HELVETICA).borderWidth(1).borderColor(Color.BLACK);

					Row billNumberDateRow1 = Row.builder()
							.add(TextCell.builder().text("à¤¬à¥€à¤² à¤¨à¤‚à¤¬à¤°").font(fontMarathi).fontSize(9)
									.horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getBillNumber()).font(fontMarathi).fontSize(9)
									.horizontalAlignment(LEFT).fontSize(10).borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("ns; izdkj").font(krutiDev).fontSize(15)
									.horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getPaymentType()).font(fontMarathi).fontSize(9)
									.horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text("à¤¤à¤¾à¤°à¥€à¤–").font(fontMarathi).fontSize(9)
									.horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
							.add(TextCell.builder().text(billInfoDAO.getBillDate()).font(fontMarathi).fontSize(9)
									.horizontalAlignment(LEFT).fontSize(8).borderWidth(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).build();

					/*
					 * Row billNumberDateRow2 = Row.builder()
					 * .add(TextCell.builder().text("Mode Of Payment").horizontalAlignment(LEFT).
					 * borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					 * .add(TextCell.builder().text(billInfoDAO.getPaymentType()).
					 * horizontalAlignment(LEFT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build
					 * ())
					 * .add(TextCell.builder().text("Buyer Order Number").horizontalAlignment(RIGHT)
					 * .borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).
					 * fontSize(8).lineSpacing(1F).build()) .backgroundColor(WHITE)
					 * .textColor(Color.BLACK) .font(PDType1Font.HELVETICA_BOLD)
					 * .horizontalAlignment(CENTER) .build(); Row billNumberDateRow3 = Row.builder()
					 * .add(TextCell.builder().text("State: Maharatshtra ").horizontalAlignment(LEFT
					 * ).borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("Code : 27").horizontalAlignment(LEFT).
					 * borderWidth(0.5F).fontSize(10).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("Dispatch Doc. Number").horizontalAlignment(
					 * RIGHT).borderWidth(0.5F).fontSize(8).lineSpacing(1F).build())
					 * .add(TextCell.builder().text("").horizontalAlignment(LEFT).fontSize(10).
					 * borderWidth(0.5F).lineSpacing(1F).build()) .backgroundColor(WHITE)
					 * .textColor(Color.BLACK) .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					 * .horizontalAlignment(CENTER) .build();
					 */
					billNumberDate.addRow(billNumberDateRow1);
					// billNumberDate.addRow(billNumberDateRow2);
					// billNumberDate.addRow(billNumberDateRow3);
					billNumberTable = billNumberDate.build();

					TableBuilder tableCustDetailsBuilder = Table.builder().addColumnsOfWidth(100, 280).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					Row custDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("fcy riâ€œkhy").colSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(krutiDev).fontSize(16)
							.horizontalAlignment(CENTER).build();

					String custDetails[] = billInfoDAO.getCustomerName().split("-");

					Row custDetailsRow2 = Row.builder()
							.add(TextCell.builder().text("xzkgdkps uko%").font(krutiDev).fontSize(13)
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F)
									.build())
							.add(TextCell.builder().text("" + custNameMarathi).font(fontMarathi)
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F)
									.build())
							.backgroundColor(WHITE).textColor(Color.BLACK).fontSize(10).horizontalAlignment(CENTER)
							.build();

					Row custDetailsRow3 = Row.builder()
							.add(TextCell.builder().text("iRrk%").font(krutiDev).fontSize(13).horizontalAlignment(LEFT)
									.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("" + custAddMarathi).font(fontMarathi)
									.horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F)
									.build())
							.backgroundColor(WHITE).textColor(Color.BLACK).fontSize(10).horizontalAlignment(CENTER)
							.build();

					Row custDetailsRow4 = Row.builder()
							.add(TextCell.builder().text("à¤®à¥‹à¤¬à¤¾à¤ˆà¤² à¤¨à¤‚à¤¬à¤°:  ").horizontalAlignment(LEFT)
									.borderWidth(0).borderWidthBottom(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text("" + custDetails[2]).horizontalAlignment(LEFT).borderWidth(0)
									.borderWidthBottom(0.5F).lineSpacing(1F).build())
							.backgroundColor(WHITE).textColor(Color.BLACK).font(fontMarathi).fontSize(10)
							.horizontalAlignment(CENTER).build();

					tableCustDetailsBuilder.addRow(custDetailsRow1);
					tableCustDetailsBuilder.addRow(custDetailsRow2);
					tableCustDetailsBuilder.addRow(custDetailsRow3);
					tableCustDetailsBuilder.addRow(custDetailsRow4);

					customerDetails = tableCustDetailsBuilder.build();

					TableBuilder tableproductDetailsBuilder = Table.builder().addColumnsOfWidth(30, 160, 60, 40, 90)
							.font(HELVETICA).borderWidth(0.5F).borderColor(Color.BLACK);

					Row productDetailsRow1 = Row.builder()
							.add(TextCell.builder().text("va-dz").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("rikhy").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("izrh czkl nj").horizontalAlignment(LEFT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text("ux").horizontalAlignment(CENTER).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.add(TextCell.builder().text(",dq.k jDde").horizontalAlignment(RIGHT).borderWidth(0.5F)
									.lineSpacing(1F).build())
							.backgroundColor(Color.LIGHT_GRAY).textColor(Color.BLACK).height(12.0F).font(krutiDev)
							.fontSize(10).horizontalAlignment(CENTER).build();

					tableproductDetailsBuilder.addRow(productDetailsRow1);

					int srNo = 1;

					float allUnitTotalAmount = 0.0F;

					for (int i = 0; i <= 5; i++) {

						BillProductInfoDAO dao = null;
						try {
							dao = productInfoList.get(i);
						} catch (Exception e) {
							dao = null;
						}

						if (dao != null) {

							float basicPrice = 0.0F;
							float taxableAmount = 0.0F;
							float totalUnitAmount = 0.0F;
							float unitCgst = 0.0F;
							float unitSgst = 0.0F;
							float taxPercentage = 0.0F;
							float halfTax = 0.0F;
							float qty = dao.getQuantity();
							try {

								basicPrice = dao.getSalesRate();
								/*
								 * unitCgst = Float.parseFloat(dao.getCgst()); unitSgst =
								 * Float.parseFloat(dao.getSgst()); taxPercentage =
								 * Float.parseFloat(dao.getTaxPercentage());
								 */

								taxableAmount = basicPrice * qty;

								totalMaterialCost = totalMaterialCost + taxableAmount;

								totalUnitAmount = basicPrice + unitCgst + unitSgst;

								allUnitTotalAmount = allUnitTotalAmount + totalUnitAmount;

								halfTax = taxPercentage / 2.0F;

							} catch (NumberFormatException e) {
								e.printStackTrace();
							}

							// int qty = Integer.parseInt(dao.getProductQuantity());

							// totalMaterialCost = totalMaterialCost + totalUnitAmount;
							Row productDetailsRow = Row.builder()
									.add(TextCell.builder().text("" + srNo).horizontalAlignment(CENTER)
											.borderWidth(0.5F).lineSpacing(1F).build())
									.add(TextCell.builder().text(dao.getProductName().toUpperCase())
											.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getSalesRate()))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text(df.format(dao.getQuantity()))
											.horizontalAlignment(RIGHT).borderWidth(0.5F).verticalAlignment(MIDDLE)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("" + df.format(taxableAmount))
											.horizontalAlignment(RIGHT).verticalAlignment(MIDDLE).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(fontMarathi).fontSize(9)
									.horizontalAlignment(CENTER).height(15F).build();
							tableproductDetailsBuilder.addRow(productDetailsRow);

							srNo++;
						}

						else {

							Row productDetailsRow = Row.builder()
									.add(TextCell.builder().text("").horizontalAlignment(CENTER).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F)
											.lineSpacing(1F).build())
									.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
									.fontSize(9).horizontalAlignment(CENTER).height(15F).build();
							tableproductDetailsBuilder.addRow(productDetailsRow);

							srNo++;
						}

					}

					productDetails = tableproductDetailsBuilder.build();

					TableBuilder vehicleDetailsBuilder = Table.builder().addColumnsOfWidth(70, 120).font(HELVETICA)
							.borderWidth(1).horizontalAlignment(LEFT).borderColor(Color.BLACK);

					Row vehicleRow = Row.builder()
							.add(TextCell.builder().text("xkMh rikhy").colSpan(2).horizontalAlignment(CENTER)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(krutiDev).fontSize(12)
							.horizontalAlignment(CENTER).height(15F).build();
					vehicleDetailsBuilder.addRow(vehicleRow);

					Row vehicleRow1 = Row.builder()
							.add(TextCell.builder().text("xkMh").font(krutiDev).fontSize(10).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text(vehicleMake).font(fontMarathi).fontSize(8)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(15F)
							.build();
					vehicleDetailsBuilder.addRow(vehicleRow1);

					Row vehicleRow2 = Row.builder()
							.add(TextCell.builder().text("xkMh uacj").font(krutiDev).fontSize(10)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							.add(TextCell.builder().text(vehicleNumber).font(fontMarathi).fontSize(8)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).fontSize(7).horizontalAlignment(CENTER)
							.height(15F).build();
					vehicleDetailsBuilder.addRow(vehicleRow2);

					/*
					 * Row vehicleRow3 = Row.builder()
					 * .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.
					 * 5F).lineSpacing(0.5F).build())
					 * .add(TextCell.builder().text(tripFrom).horizontalAlignment(LEFT).borderWidth(
					 * 0.5F).lineSpacing(0.5F).build()) .backgroundColor(Color.WHITE)
					 * .textColor(Color.BLACK) .font(PDType1Font.HELVETICA_BOLD) .fontSize(7)
					 * .horizontalAlignment(CENTER) .height(23F) .build();
					 * vehicleDetailsBuilder.addRow(vehicleRow3);
					 */

					Row vehicleRow4 = Row.builder()
							.add(TextCell.builder().text("Bhdk.k").font(krutiDev).fontSize(9).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(tripTo).font(fontMarathi).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).fontSize(7).horizontalAlignment(CENTER)
							.height(15F).build();
					vehicleDetailsBuilder.addRow(vehicleRow4);

					if (driverName == null) {
						driverName = "NA";
					}

					Row vehicleRow5 = Row.builder()
							.add(TextCell.builder().text("Mªk;ojps uko").font(krutiDev).fontSize(10)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(driverName).font(fontMarathi).fontSize(7)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(15F)
							.build();
					vehicleDetailsBuilder.addRow(vehicleRow5);

					if (driverMobileNumber == null) {
						driverMobileNumber = "NA";
					}
					Row vehicleRow6 = Row.builder()
							.add(TextCell.builder().text("Mªk;ojpk eks- uacj").font(krutiDev).fontSize(10)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(driverMobileNumber).font(fontMarathi).fontSize(8)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(15F)
							.build();
					vehicleDetailsBuilder.addRow(vehicleRow6);

					vehicleDetailsTable = vehicleDetailsBuilder.build();

					TableBuilder totalDetailsBuilder = Table.builder().addColumnsOfWidth(95, 90).font(HELVETICA)
							.borderWidth(1).horizontalAlignment(RIGHT).borderColor(Color.BLACK);

					Row materialCostRow = Row.builder()
							.add(TextCell.builder().text(",dq.k eVsjhvy jDde").font(krutiDev).fontSize(11)
									.verticalAlignment(MIDDLE).horizontalAlignment(RIGHT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + totalMaterialCost).font(fontMarathi).fontSize(9)
									.horizontalAlignment(RIGHT).borderWidth(0.5F).fontSize(11).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(18F)
							.build();
					totalDetailsBuilder.addRow(materialCostRow);

					Row transportCostRow = Row.builder()
							.add(TextCell.builder().text("okgrqd jDde").font(krutiDev).fontSize(11)
									.horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + billInfoDAO.getTransportCharge()).font(fontMarathi)
									.fontSize(11).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(18F)
							.build();
					totalDetailsBuilder.addRow(transportCostRow);

					Row totalDetailsRow1 = Row.builder()
							.add(TextCell.builder().text(",dq.k fcy jDde").font(krutiDev).fontSize(11)
									.verticalAlignment(MIDDLE).horizontalAlignment(RIGHT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text(billInfoDAO.getTotalBillAmount()).font(fontMarathi).fontSize(9)
									.horizontalAlignment(RIGHT).fontSize(11).borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(18F)
							.build();
					totalDetailsBuilder.addRow(totalDetailsRow1);

					Row totalDetailsRow2 = Row.builder()
							.add(TextCell.builder().text("vnk dsysyh jDde").font(krutiDev).fontSize(11)
									.verticalAlignment(MIDDLE).horizontalAlignment(RIGHT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("" + Float.parseFloat(billInfoDAO.getTotalAmountPaid()))
									.font(fontMarathi).fontSize(11).horizontalAlignment(RIGHT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(18F)
							.build();
					totalDetailsBuilder.addRow(totalDetailsRow2);

					Row totalDetailsRow3 = Row.builder()
							.add(TextCell.builder().text(";s.ks ckdh jDde").font(krutiDev).fontSize(11)
									.verticalAlignment(MIDDLE).horizontalAlignment(RIGHT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder()
									.text("" + Math.abs(Float.parseFloat(billInfoDAO.getTotalAmountBalance())))
									.font(fontMarathi).fontSize(11).horizontalAlignment(RIGHT).borderWidth(0.5F)
									.lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(18F)
							.build();
					totalDetailsBuilder.addRow(totalDetailsRow3);

					totalAmountDetails = totalDetailsBuilder.build();

					TableBuilder tableBottomInfoBuilder = Table.builder().addColumnsOfWidth(80, 300).font(HELVETICA)
							.borderColor(Color.BLACK);

					Row bottomInfoRow2 = Row.builder()
							.add(TextCell.builder()
									.text("" + "Declaration : We declare that this bill shows the "
											+ "actual price of the goods described, that all perticulers "
											+ "are true and correct. ")
									.colSpan(2).horizontalAlignment(LEFT).borderWidth(0).borderWidthBottom(0.0F)
									.verticalAlignment(BOTTOM).lineSpacing(1F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA).fontSize(8)
							.horizontalAlignment(CENTER).height(15F).build();

					Float totalAmounttoConvert = Float.parseFloat(billInfoDAO.getTotalBillAmount());

					DecimalFormat dfConvert = new DecimalFormat("0.0");
					String convertedAmount = NumberToWordsConverter
							.getConverted(dfConvert.format(totalAmounttoConvert));

					Row bottomInfoRow3 = Row.builder()
							.add(TextCell.builder().text("v{kjh :Ik;s%").font(krutiDev).fontSize(10)
									.horizontalAlignment(LEFT).borderWidth(0.5F).borderWidthRight(0.0F).build())
							.add(TextCell.builder().text(convertedAmount).font(fontMarathi).fontSize(9)
									.horizontalAlignment(LEFT).borderWidth(0.5F).borderWidthLeft(0.0F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).horizontalAlignment(CENTER).height(20F)
							.build();

					tableBottomInfoBuilder.addRow(bottomInfoRow3);

					if (billInfoDAO.getComments() == null || billInfoDAO.getComments().equals("")) {
						billInfoDAO.setComments("NA");
					}
					if (billInfoDAO.getComments().equals("NA")) {
						Row bottomInfoRowComments = Row.builder()
								.add(TextCell.builder().text("Comments:").colSpan(2).horizontalAlignment(LEFT)
										.borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(fontMarathi).fontSize(8)
								.height(20F).horizontalAlignment(CENTER).build();
						tableBottomInfoBuilder.addRow(bottomInfoRowComments);

					} else {
						Row bottomInfoRowComments = Row.builder()
								.add(TextCell.builder().text("Comments:" + billInfoDAO.getComments()).colSpan(2)
										.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
								.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(fontMarathi).fontSize(8)
								.height(20F).horizontalAlignment(CENTER).build();
						tableBottomInfoBuilder.addRow(bottomInfoRowComments);
					}
					// tableBottomInfoBuilder.addRow(bottomInfoRow2);

					bottomInfo = tableBottomInfoBuilder.build();

					TableBuilder signatureBuiler = Table.builder().addColumnsOfWidth(100, 90, 100, 90).font(HELVETICA)
							.borderColor(Color.BLACK).horizontalAlignment(CENTER);

					SimpleDateFormat _24HourSDF = new SimpleDateFormat("HH:mm");
					Date _24HourDt = _24HourSDF.parse(billTime);
					SimpleDateFormat _12HourSDF = new SimpleDateFormat("hh:mm a");

					Row bottomInfoRowBillTime = Row.builder()
							.add(TextCell.builder().text("xkMh fu?k.;kph osG%").font(krutiDev).fontSize(11)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text(_12HourSDF.format(_24HourDt)).font(fontMarathi).fontSize(9)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("xkMh iksgp.;kph osG%").font(krutiDev).fontSize(11)
									.horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							.add(TextCell.builder().text("").font(fontMarathi).fontSize(9).horizontalAlignment(LEFT)
									.borderWidth(0.5F).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).height(20F).horizontalAlignment(CENTER)
							.build();
					signatureBuiler.addRow(bottomInfoRowBillTime);

					Row signRow1 = Row.builder()
							.add(TextCell.builder().text("eky ?ks.kkj;kps uko o lgh").colSpan(2)
									.verticalAlignment(BOTTOM).horizontalAlignment(CENTER).borderWidth(0)
									.lineSpacing(0.5F).build())
							.add(TextCell.builder().text("LVksu dz�kjlkBh").colSpan(2).verticalAlignment(BOTTOM)
									.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())
							.backgroundColor(Color.WHITE).textColor(Color.BLACK).font(krutiDev).fontSize(12)
							.horizontalAlignment(CENTER).height(130F).build();
					signatureBuiler.addRow(signRow1);

					signature = signatureBuiler.build();

					float startY = page.getMediaBox().getHeight() - PADDING20;

					float yCordinate = page.getCropBox().getUpperRightY() - 72;
					float startX = page.getCropBox().getLowerLeftX() + 10;
					float endX = page.getCropBox().getUpperRightX() - 10;

					TableDrawer.builder().contentStream(contentStream).table(header).startX(PADDING20)
							.startY(startY + 10).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(billNumberTable).startX(PADDING20)
							.startY(startY - 90).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(customerDetails).startX(PADDING20)
							.startY(startY - 110).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(productDetails).startX(PADDING20)
							.startY(startY - 170).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(vehicleDetailsTable).startX(PADDING20)
							.startY(startY - 275).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(totalAmountDetails).startX(215)
							.startY(startY - 275).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(bottomInfo).startX(PADDING20)
							.startY(startY - 370).build().draw();

					TableDrawer.builder().contentStream(contentStream).table(signature).startX(PADDING20)
							.startY(startY - 410).build().draw();

					// contentStream.drawImage(pdImagejagdambaLogo, 20, 540, 100, 40);
					// contentStream.drawImage(pdImagejagdambaLogo, 60, 550, 300, 25);
					// contentStream.drawImage(pdImageYashSCAddress, 120, 530, 170, 12);
					/*
					 * contentStream.drawImage(pdImageNirmitiContact, 60, 510, 310, 25);
					 * contentStream.drawImage(pdImageNirmitiSiteContact, 90, 495, 250, 12);
					 */
					
					
					if(pdLeftLogoImage != null)
			         {
			        	 contentStream.drawImage(pdLeftLogoImage, 20, 535, 60, 55);
				         
			         }
			      
			         if(pdRightLogoImage != null)
			         {
			        	 contentStream.drawImage(pdRightLogoImage, 340, 535, 60, 55);
			         }
			         
			         if(pdOwnerSignImage != null)
			         {
			        	 contentStream.drawImage(pdOwnerSignImage, 280, 40, 90, 30);
			         }
			         
			         if(pdCompanyStampImage != null)
			         {
			        	 contentStream.drawImage(pdCompanyStampImage, 180, 40, 67, 67);
			         }
			         
			         
					contentStream.close();

					// System.out.println(path);

					document.save(path + "/bill.pdf");
					document.close();

					response.setHeader("Content-disposition", "inline; filename=bill.pdf");
					response.setContentType("application/pdf");
					@SuppressWarnings("resource")
					FileInputStream fileInputStream = new FileInputStream(path + "/bill.pdf");
					PrintWriter out = response.getWriter();
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						out.write(bytes);
					}
					fileInputStream.close();
					out.flush();
					out.close();
					ttf1.close();
					ttf2.close();
					ttf3.close();

				}
				
				if(this.getSize().equals("tharmal"))
				{
					
					 DecimalFormat df1 = new DecimalFormat("##");
		        	 PDDocument document = new PDDocument(); 
						PDPage page = null;
						
						float pageHeight = 220.0F+(listSize*16.2F);
						
						
						PDRectangle pdRectangle = new PDRectangle(220.0F, pageHeight);
						 page = new PDPage(pdRectangle);
						 
						 document.addPage(page);
					
							File fontFile = new File(
									request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
							File fontFileBold = new File(
									request.getSession().getServletContext().getRealPath("/fonts/nirmala-bold.ttf"));

							TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
							TrueTypeFont ttf2 = new TTFParser().parse(fontFileBold);

							File fontFilekrutiDev = new File(
									request.getSession().getServletContext().getRealPath("/fonts/Krutidev.ttf"));

							TrueTypeFont ttf3 = new TTFParser().parse(fontFilekrutiDev);

							PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
							PDFont fontMarathiBold = PDType0Font.load(document, ttf2, true);
							PDFont krutiDev = PDType0Font.load(document, ttf3, true);
						 
					
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
		         
		         Table header;
		         Table billInfoTable;
		         Table itemInfo;
		         Table bottomInfo;
		         
		         TableBuilder tableHeaderBuilder = Table.builder()
			                .addColumnsOfWidth(200)				                
			                .font(HELVETICA)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		         
		     int fontSize = 0;
		     
		     if (crushernameenglish.length()> 25) {
		    	 fontSize = 8;
		     }else {
		    	 fontSize = 10;
		     }
		         
		         Row crusherNameHeader = Row.builder()
			                .add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(fontSize)				              
			                .horizontalAlignment(CENTER)
			                .build();
		         
		         Row addressRow1 = Row.builder()
			                .add(TextCell.builder().text(address).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
			                .horizontalAlignment(CENTER)
			                .build();
		         Row addressRow2 = Row.builder()
			                .add(TextCell.builder().text("Mob No : "+contactMobile).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
			                .horizontalAlignment(CENTER)
			                .build();
		         
		         Row.builder()
			                .add(TextCell.builder()
			                		.text(" ")
			                		.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(0.5F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)				              
			                .horizontalAlignment(CENTER)
			                .build();
		     
		         
		         
		         
		         if(companyDetailsDisplay.equals("YES")) {
		        	 tableHeaderBuilder.addRow(crusherNameHeader);
			         tableHeaderBuilder.addRow(addressRow1);
			         tableHeaderBuilder.addRow(addressRow2);
			        
		         }else {
		        	 //tableHeaderBuilder.addRow(crusherNameHeader);
			         //tableHeaderBuilder.addRow(addressRow1);
			         //tableHeaderBuilder.addRow(addressRow2);
			        
		         }
		        
		         
		         header = tableHeaderBuilder.build();
		         
		         
		         
		         TableBuilder tableBillInfoBuilder = Table.builder()
			                .addColumnsOfWidth(100,100)				                
			                .font(HELVETICA)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		         
		         Row billInfoRow1 = Row.builder()
			                .add(TextCell.builder().text("Chalan No : "+this.getBillInfoDAO().getChalanNumber()).fontSize(9).font(PDType1Font.HELVETICA_BOLD).horizontalAlignment(CENTER).borderWidthTop(0.5F).lineSpacing(0.5F).build())				               
			                .add(TextCell.builder().text("Date :"+billDateTime.split(" ")[0]).font(PDType1Font.HELVETICA_BOLD).fontSize(9).horizontalAlignment(CENTER).borderWidthTop(0.5F).lineSpacing(0.5F).build())				               
				            .backgroundColor(WHITE)
			                .textColor(Color.BLACK)			                		              
			                .horizontalAlignment(CENTER)
			                .build();
		         
		         
		         
		         Row billInfoRow2 = Row.builder()
			                .add(TextCell.builder().text("Veh.No : "+vehicleNumber).font(PDType1Font.HELVETICA_BOLD).horizontalAlignment(CENTER).borderWidthTop(0.5F).lineSpacing(0.5F).build())				               
			                .add(TextCell.builder().text("Time :"+billDateTime.split(" ")[1]).font(PDType1Font.HELVETICA_BOLD).horizontalAlignment(CENTER).borderWidthTop(0.5F).lineSpacing(0.5F).build())				               
				            .backgroundColor(WHITE)
			                .textColor(Color.BLACK)			                		              
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
			                .horizontalAlignment(CENTER)
			                .build();
		        
		         Row billInfoRow3 = Row.builder()
		        		 .add(TextCell.builder().text("Payment Mode :"+this.getBillInfoDAO().getPaymentType()).font(PDType1Font.HELVETICA_BOLD).horizontalAlignment(CENTER).borderWidthTop(0.5F).lineSpacing(0.5F).build())				               
				            .add(TextCell.builder().text("Billed By: "+this.getBillInfoDAO().getBilledBy()).horizontalAlignment(CENTER).borderWidthTop(0.5F).lineSpacing(0.5F).build())				               
				            .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
			                .horizontalAlignment(CENTER)
			                .build();
		         
		      
		         Row custName = Row.builder()
			                .add(TextCell.builder().text("Customer : "+this.getBillInfoDAO().getCustomerName().split("-")[1]).colSpan(2).horizontalAlignment(CENTER).borderWidthTop(0.5F).lineSpacing(0.5F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .fontSize(9)
			                .font(PDType1Font.HELVETICA_BOLD)			              
			                .horizontalAlignment(CENTER)
			                .build();
		         Row custmobile = Row.builder()
		        		    .add(TextCell.builder().text("Mobile : "+this.getBillInfoDAO().getCustomerName().split("-")[2]).horizontalAlignment(CENTER).borderWidthTop(0F).lineSpacing(0.5F).build())				               
			                .add(TextCell.builder().text("Addr. : "+this.getBillInfoDAO().getCustomerAddress()).horizontalAlignment(CENTER).borderWidthTop(0F).lineSpacing(0.5F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .fontSize(8)
			                .font(PDType1Font.HELVETICA_BOLD)			              
			                .horizontalAlignment(CENTER)
			                .build();
		        		 
		        		
		         
		         tableBillInfoBuilder.addRow(billInfoRow1);
		         tableBillInfoBuilder.addRow(billInfoRow2);
		         tableBillInfoBuilder.addRow(billInfoRow3);
		         tableBillInfoBuilder.addRow(custName);
		         tableBillInfoBuilder.addRow(custmobile);
		          billInfoTable = tableBillInfoBuilder.build();
		          
		          
			         float startY = page.getMediaBox().getHeight()-2;
			         TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(header)
		                .startX(5F)
		                .startY(startY)
		                .build()
		                .draw();
			         
			         float currectY = startY - 45;
			        
			         TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(billInfoTable)
		                .startX(5F)
		                .startY(currectY)
		                .build()
		                .draw();
			         
			         currectY = currectY - 70;
			         float itemEndY = currectY-20;
			     
		        	  

			       
				         TableBuilder tableItemInfoBuilder = Table.builder()
					                .addColumnsOfWidth(60,40,35,35,35)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
			          
				         Row itemInfoHeader = Row.builder()
					                .add(TextCell.builder().text("Item").font(PDType1Font.HELVETICA_BOLD).fontSize(8).horizontalAlignment(LEFT).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(0.5F).build())				               
					                .add(TextCell.builder().text("QTY").fontSize(8).font(PDType1Font.HELVETICA_BOLD).horizontalAlignment(LEFT).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(0.5F).build())				               
					                .add(TextCell.builder().text("Rate").font(PDType1Font.HELVETICA_BOLD).fontSize(8).horizontalAlignment(LEFT).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(0.5F).build())				               
					                .add(TextCell.builder().text("Dis.Rs.").font(PDType1Font.HELVETICA_BOLD).fontSize(8).horizontalAlignment(LEFT).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(0.5F).build())				               
					                .add(TextCell.builder().text("Amt.Aft.Dis.").font(PDType1Font.HELVETICA_BOLD).fontSize(8).horizontalAlignment(LEFT).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(0.5F).build())				               
							        .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .fontSize(7)				              
					                .horizontalAlignment(CENTER)
					                .build();
				       
				         tableItemInfoBuilder.addRow(itemInfoHeader);
				     	
							for(BillProductInfoDAO informationDAO : this.getProductInfoList())
							{
								 Row itemDetails = null;
								 
									
						         itemDetails = Row.builder()
							                .add(TextCell.builder().text(informationDAO.getProductNameMarathi()).fontSize(9).horizontalAlignment(LEFT).borderWidth(0.0F).lineSpacing(0.5F).build())				               
							                .add(TextCell.builder().text(informationDAO.getQuantity()+" "+shortName).fontSize(7).horizontalAlignment(LEFT).borderWidth(0F).lineSpacing(0.5F).build())				               
							                .add(TextCell.builder().text(""+informationDAO.getSalesRate()).fontSize(8).horizontalAlignment(LEFT).borderWidth(0F).lineSpacing(0.5F).build())				               
							                .add(TextCell.builder().text(""+informationDAO.getDiscountRupees()).fontSize(9).horizontalAlignment(LEFT).borderWidth(0.0F).lineSpacing(0.5F).build())				               
							                .add(TextCell.builder().text(""+informationDAO.getAmountAfterDiscount()).fontSize(8).horizontalAlignment(LEFT).borderWidth(0.0F).lineSpacing(0.5F).build())				               
									        .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(fontMarathi).fontSize(8)	 			              
							                .horizontalAlignment(CENTER)
							                .build();
						         tableItemInfoBuilder.addRow(itemDetails);
						         itemEndY = itemEndY - 13.2F;
							}
				         
							 itemInfo = tableItemInfoBuilder.build();
							
							    TableBuilder tableBottomInfoBuilder = Table.builder()
						                .addColumnsOfWidth(100,100)				                
						                .font(HELVETICA)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
							   
							    Row itemTotalItemsInfo = Row.builder()
						                .add(TextCell.builder().text("Total Items : "+listSize).horizontalAlignment(CENTER).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(2F).build())				               
						                .add(TextCell.builder().text("Royalty  : " +this.getRoyalty()).horizontalAlignment(CENTER).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(2F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD)	
						                .fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
					         
							    Row advanceInfo = Row.builder()
						                .add(TextCell.builder().text("Total Amount  : "+df1.format(floatTotalAmtAfterDiscount+totalRoyaltyAmount+totalTrAmount)).horizontalAlignment(CENTER).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(2F).build())				               
						                .add(TextCell.builder().text("Total Amount Paid : " +this.getBillInfoDAO().getTotalAmountPaid()).horizontalAlignment(CENTER).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(2F).build())				               
							             .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD)
						                .fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
							    Row balanceInfo = Row.builder()
						                .add(TextCell.builder().text("Total Balance Amt : " +this.getBillInfoDAO().getTotalAmountBalance()).colSpan(2).horizontalAlignment(CENTER).borderWidthTop(0.5F).borderWidthBottom(0.5F).lineSpacing(2F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD)
						                .fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
					     
					         
					         tableBottomInfoBuilder.addRow(itemTotalItemsInfo);
					         tableBottomInfoBuilder.addRow(advanceInfo);
					         tableBottomInfoBuilder.addRow(balanceInfo);
					         
					         bottomInfo = tableBottomInfoBuilder.build();
					       
			          
			          
		          
			   
		        
		        
		           TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(itemInfo)
	                .startX(5F)
	                .startY(currectY)
	                .build()
	                .draw();
		       
		         
		        
		        
		        	
		        	 itemEndY = itemEndY -30;
		        	 TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(bottomInfo)
		                .startX(0F)
		                .startY(itemEndY)
		                .build()
		                .draw();
		        	 
		        	 	
		         
		        	
		         contentStream.close();
				 	document.save(path+"/bill.pdf");
			        document.close();
			        
			        

					response.setHeader("Content-disposition", "inline; filename=bill.pdf");
					response.setContentType("application/pdf");
					FileInputStream fileInputStream = new FileInputStream(path+"/bill.pdf");
					PrintWriter outFile = response.getWriter();  
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						outFile.write(bytes);
					}
					fileInputStream.close();
					outFile.flush();
					outFile.close();
					
					
					
				}
				
				
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		} finally {
			if (resultSet != null) {
				try {
					resultSet.close();
					resultSet = null;
				} catch (SQLException e) {

				}
			}
			if (preparedStatement != null) {
				try {
					preparedStatement.close();
					preparedStatement = null;
				} catch (SQLException e) {
				}
			}
			if (connection != null) {

				try {
					connection.close();
					connection = null;
				} catch (SQLException e) {
				}
			}

		}

	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}

	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}

	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}

	@Override
	public void setSession(Map<String, Object> map) {
		sessionMap = (SessionMap<String, Object>) map;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public String getSize() {
		return size;
	}

	public void setSize(String size) {
		this.size = size;
	}

	public String getLang() {
		return lang;
	}

	public void setLang(String lang) {
		this.lang = lang;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getBankingName() {
		return bankingName;
	}

	public void setBankingName(String bankingName) {
		this.bankingName = bankingName;
	}

	public String getNameOfBranch() {
		return nameOfBranch;
	}

	public void setNameOfBranch(String nameOfBranch) {
		this.nameOfBranch = nameOfBranch;
	}

	public String getAccountNumber() {
		return accountNumber;
	}

	public void setAccountNumber(String accountNumber) {
		this.accountNumber = accountNumber;
	}

	public String getIfscCode() {
		return ifscCode;
	}

	public void setIfscCode(String ifscCode) {
		this.ifscCode = ifscCode;
	}

	public String getRoyalty() {
		return royalty;
	}

	public void setRoyalty(String royalty) {
		this.royalty = royalty;
	}

	public String getNameOfBank() {
		return nameOfBank;
	}

	public void setNameOfBank(String nameOfBank) {
		this.nameOfBank = nameOfBank;
	}

	
	
}
