package com.stonecrusher.message;


import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.OutstandingMessageSendReportDAO;
import com.stonecrusher.bulksmsgateway.AddBulkSMSGatewayResponseToDB;
import com.stonecrusher.bulksmsgateway.SendBulkSMSGatewayMessage;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.infrawhatsappmsg.SendWhatsAppMessage;
public class SendSelectedCreditMessage extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3477252382765835945L;
	
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
	private List<String> selection = new ArrayList<String>();
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private List<OutstandingMessageSendReportDAO> messageSendReportList = new ArrayList<OutstandingMessageSendReportDAO>();
	private String defaultValue;

	private String returnMessage;
	public String execute()
	{
		String result = "login";
		 session=ServletActionContext.getRequest().getSession(false); 
			
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";  
	        
	        }  
	        else{  
	        	
	        
			Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			String sql = "";
			String db = (String) session.getAttribute("db");
			try
			{
				
				
		       	String shopId = (String) this.getSessionMap().get("shopId");
		   		String shopCode = (String) this.getSessionMap().get("shopCode");
		   	
			
				customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
				
				
				int messageCount = 0;
				
				String crusherNameMarathi = (String) this.getSessionMap().get("crushernamemarathi");
				String crusherNameEnglish = (String) this.getSessionMap().get("crushernameenglish");
				
				String customerCareNumber = (String) this.getSessionMap().get("crushercustcarenumber");
				
				String defaultWhatsAppNumber = (String) this.getSessionMap().get("defaultWhatsAppNumber");
				
				HashMap<String, String> tokenList = (HashMap<String, String>) this.getSessionMap().get("whatsappmsgtokenlist");
				
				String tokenNumberWithUsername = tokenList.get(defaultWhatsAppNumber);
				
				String [] tokenData = tokenNumberWithUsername.split("#");
				
				String userNameMsg = tokenData[0];
				String tokenNumber = tokenData[1];
			
				String msg = "";
				
				String defaultMessageLang = "MARATHI";
				
				for(String s:this.getSelection())
				{
					
					
					String [] data = s.split("-");
					String mobileNumber = data[0];
					String amountBalance = data[1];
					
					
					if(defaultMessageLang.equals("MARATHI"))
					{
						msg = "\n*नमस्कार,*";
						msg += "\n*प्रिय ग्राहक,*";
						msg += "\n*आपणाकडील एकूण उधारी येणे बाकी रक्कम : "+amountBalance+" *रु. येणे आहे.";
						msg += "\n*बाकी लवकरात लवकर जमा करून आम्हाला सहकार्य करावे, हि नम्र विनंती !*";
						msg += "\n*धन्यवाद !*";
						msg += "\n*"+crusherNameMarathi+"*";			    							
						msg += "\n*संपर्क* : "+customerCareNumber;
						
						
						//System.out.println(fileUrl);
						String whatsAppResp = SendWhatsAppMessage.sendMessageOnly(userNameMsg, mobileNumber, msg, tokenNumber);
						
						
						if(whatsAppResp.contains("success"))
						{
							messageCount = messageCount + 1;
						}
					
						
					}
				}
				
				if(messageCount > 0)
				{
					result = "success";				
					addActionMessage("Credit message sent to "+messageCount+" customers!");
				}
				else
				{
					result = "error";
					addActionMessage("Messages not sent! Please check internet connection!");
				}
			}
			 catch (Exception e)
				{
					result = "error";
					
					addActionMessage(e.getMessage() +" || MESSAGES NOT SENT !");
				} 
		
			finally {
					if(resultSet !=null)
					{
						try
						{
							resultSet.close();
						}
						catch(SQLException sqe)
						{
							
						}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
			result = "success";

	        }
	        
	        return result;
	}


	public List<String> getSelection() {
		return selection;
	}


	public void setSelection(List<String> selection) {
		this.selection = selection;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}


	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}


	public String getCustomerSearchOption() {
		return customerSearchOption;
	}


	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public String getDefaultValue() {
		return defaultValue;
	}


	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public List<OutstandingMessageSendReportDAO> getMessageSendReportList() {
		return messageSendReportList;
	}


	public void setMessageSendReportList(List<OutstandingMessageSendReportDAO> messageSendReportList) {
		this.messageSendReportList = messageSendReportList;
	}


	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}


	public String getReturnMessage() {
		return returnMessage;
	}


	public void setReturnMessage(String returnMessage) {
		this.returnMessage = returnMessage;
	}

	
	
	
	
}



