package com.stonecrusher.login;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BankAccountStatementDAO;
import com.stonecrusher.DAO.CustomerCreditReportDAO;
import com.stonecrusher.DAO.CustomerInfoDAO;
import com.stonecrusher.DAO.CustomerPaymentDetailsDAO;
import com.stonecrusher.DAO.CustomerPaymentReminderDetailsDAO;
import com.stonecrusher.DAO.DailyExpenseDAO;
import com.stonecrusher.DAO.RMCBillIngredientsUsedDAO;
import com.stonecrusher.DAO.SupplierAccountDetailsDAO;
import com.stonecrusher.DAO.SupplierDebtReportDAO;
import com.stonecrusher.DAO.TodayBillingListDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetBankAccountEntryDetails;
import com.stonecrusher.utils.GetNotificationList;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class HomeAction extends ActionSupport implements SessionAware, ServletRequestAware, ServletResponseAware {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8903509517602329692L;
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;

	private HttpSession session;
	private SessionMap<String, Object> sessionMap;
	private String billDate;
	private String defaultValue;
	private Map<String, String> customerSearchOptionList = new HashMap<String, String>();
	private String customerSearchOption;

	private List<TodayBillingListDAO> todayBillingList = new ArrayList<TodayBillingListDAO>();

	private List<TodayBillingListDAO> lastBillingList = new ArrayList<TodayBillingListDAO>();

	private List<CustomerPaymentDetailsDAO> last5EntryCustPaymentList = new ArrayList<CustomerPaymentDetailsDAO>();
	private List<String> vehicleNotificationList = new ArrayList<String>();
      private List<BankAccountStatementDAO> bankAccountReportDAOList = new ArrayList<BankAccountStatementDAO>();

	private List<DailyExpenseDAO> dailyExpenseList = new ArrayList<DailyExpenseDAO>();
	private Float totalExpenseAmount = 0.0F;

	private Float materialTotal;

	private Float allBillMatrialCostTotal;
	private Float transportTotal;
	private Float totalBillAmount;
	private Float totalBalanceAmount;
	private Float totalReceivedAmount;

	private Float totalCredit = 0.0F;
	private Float totalDebit = 0.0F;
	private Float balance = 0.0F;
	private Float totalRoyalty;
	private Float totalTransportCharges = 0.0F;
	private List<BankAccountStatementDAO> reportList = new ArrayList<BankAccountStatementDAO>();
	private List<BankAccountStatementDAO> bankCreditList = new ArrayList<BankAccountStatementDAO>();
	private List<CustomerPaymentDetailsDAO> custPaymentDetailsDAOList = new ArrayList<CustomerPaymentDetailsDAO>();
	private Float totalReportCreditAmountCustomer = 0.0f ;
	private Float AllTotalDebtAmountSupplier = 0.0f ;
	private Float AllTotalExpenseAmount = 0.0f ;
	
	String  fromDate ;
	String  toDate ;
	private ArrayList<CustomerPaymentReminderDetailsDAO> customerPaymentReminderList = new ArrayList<CustomerPaymentReminderDetailsDAO>();
	private List<SupplierAccountDetailsDAO> purchaseDetailsList = new ArrayList<SupplierAccountDetailsDAO>();
	

	private Float totalTenMMUsed;
	private Float totalTwentyMMUsed;
	private Float totalWashSandUsed;
	private Float totalCrushSandUsed;
	private Float totalAddMixtureUsed;
	private Float totalOPCUsed;
	private Float totalPPCUsed;
	private Float totalWaterUsed;
	private List<RMCBillIngredientsUsedDAO> rmcUsedIngreDAOList = new ArrayList<RMCBillIngredientsUsedDAO>();
	private Float totalCashAmt = 0.0f;
	private Float totalOnlineAmt = 0.0f;
	
	private Float totalTaxableAmtAllTheTime;
	private Float totalCgstAllTheTime;
	private Float totalSgstAllTheTime;
	private Float totalPumpAmtAllTheTime;
	private Float totalLaborAmtAllTheTime;
	
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
	
	
	@Override
	public String execute() throws Exception {
		String result = "login";
		session = ServletActionContext.getRequest().getSession(false);

		if (session == null || session.getAttribute("login") == null) {
			addActionMessage(this.getText("message.error.plzloginfirst"));
			result = "login";
		} else {

			boolean requestFromAndroid = false;
			Map<String, String> map = new HashMap<String, String>();

			Enumeration<String> headerNames = this.getRequest().getHeaderNames();

			while (headerNames.hasMoreElements()) {
				String key = (String) headerNames.nextElement();
				String value = this.getRequest().getHeader(key);
				map.put(key, value);
			}
			// Android
			String ua = "";
			for (String key : map.keySet()) {
				if (key.equals("user-agent")) {

					ua = map.get(key);

					if (ua.contains("Android")) {
						requestFromAndroid = true;
					}
				}
			}

			DecimalFormat df= new DecimalFormat("##.##");
			customerSearchOptionList.put("BYNAME", "BY NAME");
			customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
			customerSearchOptionList.put("BYADDRESS", "BY ADDRESS");
			setCustomerSearchOption("BYNAME");
			setDefaultValue("BYNAME");

			String crusherId = (String) this.getSessionMap().get("crusherId");
			String crusherCode = (String) this.getSessionMap().get("crusherCode");

			Date d = new Date();
			SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
			setBillDate(dateFormat.format(d));

			Connection connection = null;
			PreparedStatement preparedStatement = null;
			ResultSet resultSet = null;
			String sql = "";
			String db = (String) session.getAttribute("db");

			 float totalMaterial = 0.0F;
			  
			  allBillMatrialCostTotal = 0.0F;
			  transportTotal = 0.0F;
			  totalBillAmount = 0.0F;
			  totalBalanceAmount = 0.0F;
			  totalReceivedAmount = 0.0F;
			  totalLaborAmtAllTheTime = 0.0f;
  			totalPumpAmtAllTheTime = 0.0f;

			try {
				connection = GetDBConnection.getDBConnection(db);
				LinkedHashMap<String,TodayBillingListDAO> billMap = new LinkedHashMap<String,TodayBillingListDAO>();
				  
				
					
				
				sql = "SELECT "
				  		+ "bi.bill_number,"
				  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
				  		+ "bi.customer_id,"
				  		+ "bi.customer_name,"
				  		+ "cust.billing_address,"
				  		+ "bi.transportation_charges,"
				  		+ "bi.bill_total_amount,"
				  		+ "bi.bill_amount_received,"
				  		+ "bi.billed_by,"
				  		+ "bi.chalan_number,"
				  		+ "bi.bill_type,"
				  		+ "bi.comments,"
				  		+ "bill_time,"
				  		+ "bi.account1_credit_debit_id,"
						+ "bi.account2_credit_debit_id " 
						+ "FROM "
				  		+ "crusher_bill_info_master as bi "
				  		+ "INNER JOIN "
				  		+ "crusher_customer_master as cust "
				  		+ "ON "
				  		+ "bi.customer_id = cust.customer_id "
				  		+ "WHERE "
				  		+ "(bill_date  "
				  		+ "BETWEEN "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
				  		+ "AND "
				  		+ "STR_TO_DATE(?,'%d-%m-%Y'))  "
				  		+ "AND "
				  		+ "bi.crusher_id = ? "
				  		+ "AND "
				  		+ "bi.crusher_code = ? "
				  		+ "AND "
				  		+ "cust.crusher_id = ? "
				  		+ "AND "
				  		+ "cust.crusher_code = ? "
						+ "ORDER BY bi.bill_date,bi.bill_number";
				  
				  preparedStatement = connection.prepareStatement(sql);
				  
				  preparedStatement.setString(1, this.getBillDate());
				  preparedStatement.setString(2, this.getBillDate());
				  preparedStatement.setString(3, crusherId);
				  preparedStatement.setString(4, crusherCode);
				  preparedStatement.setString(5, crusherId);
				  preparedStatement.setString(6, crusherCode);
				  
				  
				  resultSet = preparedStatement.executeQuery();
				  
				  while(resultSet.next())
				  {
					  
					  float billAmtLocal = 0.0f;
					  float recievedAmtLocal = 0.0f;
					  
					  transportTotal = transportTotal + resultSet.getFloat(6);
					  totalBillAmount = totalBillAmount + resultSet.getFloat(7);
					  totalReceivedAmount  = totalReceivedAmount + resultSet.getFloat(8);
					  billAmtLocal = resultSet.getFloat(7);
					  recievedAmtLocal = resultSet.getFloat(8);
					  
					  
					  float balAmt = billAmtLocal - recievedAmtLocal;
					 
					  if(balAmt>=0)
					  {
						  totalBalanceAmount = totalBalanceAmount + balAmt;
					  }
					  
					  TodayBillingListDAO dao = new TodayBillingListDAO();
					
					  dao.setBillNumber(resultSet.getString(1));
					  dao.setBillDate(resultSet.getString(2));
					  dao.setCustId(resultSet.getString(3));
					  dao.setCustName(resultSet.getString(4).split("-")[1]);
					  dao.setCustAddress(resultSet.getString(5));
					  dao.setTransportCharges(resultSet.getString(6));
					  dao.setBillTotalAmount(resultSet.getString(7));
					  dao.setBillAmountRecieved(resultSet.getString(8));
					  dao.setBilledBy(resultSet.getString(9));
					  dao.setChalanNumber(resultSet.getString(10));
					  dao.setBillType(resultSet.getString(11));
					  dao.setComments(resultSet.getString(12));
					  dao.setBillTime(resultSet.getString(13));
					  dao.setAccount1CreditDebitId(resultSet.getString(14));
					  dao.setAccount2CreditDebitId(resultSet.getString(15));
					  dao.setPumpAmount("0");
					  dao.setLaborAmount("0");
					  dao.setOriginateSource("CRUSHER");
					  
					  
					  String getVehicleIdSQL  =  "SELECT"
					  		+ " vehicle_id "
					  		+ "FROM "
					  		+ "crusher_vehicle_trip_master "
					  		+ "WHERE "
					  		+ "bill_number = ? "
					  		+ "AND "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  PreparedStatement getVehicleIdPSMT = connection.prepareStatement(getVehicleIdSQL);
					  getVehicleIdPSMT.setString(1, resultSet.getString(1));
					  getVehicleIdPSMT.setString(2, crusherId);
					  getVehicleIdPSMT.setString(3, crusherCode);
					  
					  ResultSet getVehicleIdRS = getVehicleIdPSMT.executeQuery();
					  if(getVehicleIdRS.next())
					  {
						  String vehicleId = getVehicleIdRS.getString(1);
						  
						  HashMap<String,String> vehicleDetails = GetVehicleDetailsById.getVehicleDetailsById(vehicleId, this.getSessionMap(), connection);
						  
						  dao.setVehicleMake(vehicleDetails.get("VEHICLEMAKE"));
						  dao.setVehicleNumber(vehicleDetails.get("REGISTRATIONNUMBER"));
					  }
					  
					  
					  if(getVehicleIdRS != null)
					  {
						  getVehicleIdRS.close();
						  getVehicleIdRS = null;
					  }
					  
					  if(getVehicleIdPSMT != null)
					  {
						  getVehicleIdPSMT.close();
						  getVehicleIdPSMT = null;
					  }
					  
					  
					  billMap.put(resultSet.getString(1)+"#"+resultSet.getString(11), dao);
				  }
				
				  
				  if(resultSet != null)
				  {
					  resultSet.close();
					  resultSet = null;
				  }
				  
				  if(preparedStatement != null)
				  {
					  preparedStatement.close();
					  preparedStatement = null;
				  }
				  
				  
				  // rmc details 
				 
				 
						
					  
				  sql = "SELECT "
					  		+ "bi.bill_number,"
					  		+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
					  		+ "bi.customer_id,"
					  		+ "bi.customer_name,"
					  		+ "cust.billing_address,"
					  		+ "bi.transport_charges,"
					  		+ "bi.bill_total_amount,"
					  		+ "bi.bill_amount_received,"
					  		+ "bi.billed_by,"
					  		+ "bi.chalan_number,"
					  		+ "bi.bill_type,"
					  		+ "bi.comments,"
					  		+ "bill_time,"
					  		+ "bi.account1_credit_debit_id,"
							+ "bi.account2_credit_debit_id," 
							+ "bi.pumpAmount,"
           					+ "bi.labourAmount "
	           				+ "FROM "
					  		+ "crusher_rmc_billinfo as bi "
					  		+ "INNER JOIN "
					  		+ "crusher_customer_master as cust "
					  		+ "ON "
					  		+ "bi.customer_id = cust.customer_id "
					  		+ "WHERE "
					  		+ "(bill_date  "
					  		+ "BETWEEN "
					  		+ "STR_TO_DATE(?,'%d-%m-%Y') "
					  		+ "AND "
					  		+ "STR_TO_DATE(?,'%d-%m-%Y'))  "
					  		+ "AND "
					  		+ "bi.crusher_id = ? "
					  		+ "AND "
					  		+ "bi.crusher_code = ? "
					  		+ "AND "
					  		+ "cust.crusher_id = ? "
					  		+ "AND "
					  		+ "cust.crusher_code = ? "
							+ "ORDER BY bi.bill_date,bi.bill_number";
					  
					  preparedStatement = connection.prepareStatement(sql);
					  
					  preparedStatement.setString(1, this.getBillDate());
					  preparedStatement.setString(2, this.getBillDate());
					  preparedStatement.setString(3, crusherId);
					  preparedStatement.setString(4, crusherCode);
					  preparedStatement.setString(5, crusherId);
					  preparedStatement.setString(6, crusherCode);
					  
					  
					  resultSet = preparedStatement.executeQuery();
					  
					  
					  
					  while(resultSet.next())
					  {
						  
						  float billAmtLocal = 0.0f;
						  float recievedAmtLocal = 0.0f;
						  
						  transportTotal = transportTotal + resultSet.getFloat(6);
						  totalBillAmount = totalBillAmount + resultSet.getFloat(7);
						  totalReceivedAmount  = totalReceivedAmount + resultSet.getFloat(8);
						  billAmtLocal = resultSet.getFloat(7);
						  recievedAmtLocal = resultSet.getFloat(8);
						  
						  
						  float balAmt = billAmtLocal - recievedAmtLocal;
				
						  if(balAmt>=0)
						  {
							  totalBalanceAmount = totalBalanceAmount + balAmt;
						  }
						  
						  TodayBillingListDAO dao = new TodayBillingListDAO();
						
						  dao.setBillNumber(resultSet.getString(1));
						  dao.setBillDate(resultSet.getString(2));
						  dao.setCustId(resultSet.getString(3));
						  dao.setCustName(resultSet.getString(4).split("-")[1]);
						  dao.setCustAddress(resultSet.getString(5));
						  dao.setTransportCharges(resultSet.getString(6));
						  dao.setBillTotalAmount(resultSet.getString(7));
						  dao.setBillAmountRecieved(resultSet.getString(8));
						  dao.setBilledBy(resultSet.getString(9));
						  dao.setChalanNumber(resultSet.getString(10));
						  dao.setBillType(resultSet.getString(11));
						  dao.setComments(resultSet.getString(12));
						  dao.setBillTime(resultSet.getString(13));
						  dao.setAccount1CreditDebitId(resultSet.getString(14));
						  dao.setAccount2CreditDebitId(resultSet.getString(15));
						  dao.setPumpAmount(resultSet.getString(16));
						  dao.setLaborAmount(resultSet.getString(17));
						  dao.setOriginateSource("RMC");
							 
						  
						 totalPumpAmtAllTheTime = totalPumpAmtAllTheTime + resultSet.getFloat(16);
	        		        totalLaborAmtAllTheTime = totalLaborAmtAllTheTime + resultSet.getFloat(17);
	        		        
						  String getVehicleIdSQL  =  "SELECT"
						  		+ " trip_vehicle_id "
						  		+ "FROM "
						  		+ "crusher_rmc_vehicle_trip_master "
						  		+ "WHERE "
						  		+ "bill_number = ? "
						  		+ "AND "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						  PreparedStatement getVehicleIdPSMT = connection.prepareStatement(getVehicleIdSQL);
						  getVehicleIdPSMT.setString(1, resultSet.getString(1));
						  getVehicleIdPSMT.setString(2, crusherId);
						  getVehicleIdPSMT.setString(3, crusherCode);
						  
						  ResultSet getVehicleIdRS = getVehicleIdPSMT.executeQuery();
						  if(getVehicleIdRS.next())
						  {
							  String vehicleId = getVehicleIdRS.getString(1);
							  
							  HashMap<String,String> vehicleDetails = GetVehicleDetailsById.getVehicleDetailsById(vehicleId, this.getSessionMap(), connection);
							  
							  dao.setVehicleMake(vehicleDetails.get("VEHICLEMAKE"));
							  dao.setVehicleNumber(vehicleDetails.get("REGISTRATIONNUMBER"));
						  }
						  
						  
						  if(getVehicleIdRS != null)
						  {
							  getVehicleIdRS.close();
							  getVehicleIdRS = null;
						  }
						  
						  if(getVehicleIdPSMT != null)
						  {
							  getVehicleIdPSMT.close();
							  getVehicleIdPSMT = null;
						  }
						  
						  
						  billMap.put(resultSet.getString(1)+"#"+resultSet.getString(11), dao);
					  }
				  
			  
				  float royalty = 0.0F;
				  float totalcgst = 0.0F;
				  float totalsgst = 0.0F;
				  totalTaxableAmtAllTheTime = 0.0f;
				  totalCgstAllTheTime = 0.0f;
				  totalSgstAllTheTime = 0.0f;
				  
				  
				  
				  for(String billNumber:billMap.keySet())
				  {
					 
					  float totalMaterialCost = 0.0F;
						 
					  
					  String getProductInfoSQL = "";
					  PreparedStatement getProductInfoPSMT = null;
					  ResultSet getProductInfoRS = null;
					  
					  TodayBillingListDAO dao = billMap.get(billNumber);
					  
						  if(dao.getOriginateSource().equals("CRUSHER"))
						  { 
						
					  getProductInfoSQL = "SELECT "
					  		+ "product_name,"
					  		+ "product_sale_amount_after_discount,"
					  		+ "sale_quantity,"
					  		+ "sales_rate,"
					  		+ "product_cgst_amount,"
					  		+ "product_sgst_amount,"
					  		+ "product_igst,"
					  		+ "product_gross_amount,"
					  		+ "royalty "
					  		+ "FROM "
					  		+ "crusher_bill_product_info "
					  		+ "WHERE "
					  		+ "bill_number = ? "
					  		+ "AND "
					  		+ "bill_type = ? "
					  		+ "AND "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  
					  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
					  
					  getProductInfoPSMT.setString(1, billNumber.split("#")[0]);
					  getProductInfoPSMT.setString(2, dao.getBillType());					  
					  getProductInfoPSMT.setString(3, crusherId);
					  getProductInfoPSMT.setString(4, crusherCode);
					  
					  getProductInfoRS = getProductInfoPSMT.executeQuery();
					
					  
					  StringBuilder productNames = new StringBuilder();
					  StringBuilder quantities = new StringBuilder();
					 
					  while(getProductInfoRS.next())
					  {
						  
						  String productName = getProductInfoRS.getString(1);
						    float quantity = getProductInfoRS.getFloat(3);

						     boolean found = false;
						    for (Map<String, Object> productInfo : productQuantityList) {
						        if (productInfo.get("productName").equals(productName)) {
						            float existingQuantity = (float) productInfo.get("quantity");
						            productInfo.put("quantity", existingQuantity + quantity);
						            found = true;
						            break;
						        }
						    }
						    

							   if (!found) {
							        Map<String, Object> newProduct = new LinkedHashMap<>();
							        newProduct.put("productName", productName);
							        newProduct.put("quantity", quantity);
							        productQuantityList.add(newProduct);
							    }
							

							  if (productNames.length() > 0) {
							        productNames.append(" / ");
							        quantities.append(" / ");
							    }
							  
							  productNames.append(getProductInfoRS.getString(1));  
							    quantities.append(getProductInfoRS.getString(3));    

							    dao.setItemNameAll(productNames.toString());  
							    dao.setItemQuantityAll(quantities.toString());
							    
							    
							    
						  totalMaterialCost = totalMaterialCost + getProductInfoRS.getFloat(2);
						  allBillMatrialCostTotal = allBillMatrialCostTotal + getProductInfoRS.getFloat(2);;
						
							  dao.setItemName(getProductInfoRS.getString(1));
							  dao.setItemQuantity(getProductInfoRS.getString(3));
							  dao.setItemRate(getProductInfoRS.getString(4));
							  dao.setCgst(getProductInfoRS.getFloat(5));
								 dao.setSgst(getProductInfoRS.getFloat(6));
								 dao.setIgst(getProductInfoRS.getString(7));
								   
								 dao.setTaxableAmt(getProductInfoRS.getString(8));

								  
								  totalCgstAllTheTime = totalCgstAllTheTime + getProductInfoRS.getFloat(5);
								  totalSgstAllTheTime = totalSgstAllTheTime + getProductInfoRS.getFloat(6);
								  totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime + getProductInfoRS.getFloat(8);
								  
								  
								 totalcgst = totalcgst + getProductInfoRS.getFloat(5);
								 totalsgst = totalsgst + getProductInfoRS.getFloat(6);
								 
							 totalMaterial = totalMaterial + getProductInfoRS.getFloat(3);
							 
							  royalty = royalty + getProductInfoRS.getFloat("royalty");
							  
							 	 
							  float royalty1 = getProductInfoRS.getFloat("royalty") ;
							  
							  
							  dao.setRoyalty(royalty1 + dao.getRoyalty());
								
							  
							  
				
					  }
						  }
					  
						
					  if(resultSet != null)
					  {
						  resultSet.close();
						  resultSet = null;
					  }
					  
					  if(preparedStatement != null)
					  {
						  preparedStatement.close();
						  preparedStatement = null;
					  }
					  
					  
					  
					  //rmc details
					  
					  
					  
						  if(dao.getOriginateSource().equals("RMC"))
						  {
						
					  getProductInfoSQL = "SELECT "
						  		+ "product_name,"
						  		+ "product_amt_after_discount,"
						  		+ "quanity,"
						  		+ "sales_rate,"
						  		+ "cgst,"
						  		+ "sgst,"
						  		+ "igst,"
						  		+ "gross_amount "
						  		+ "FROM "
						  		+ "crusher_rmc_productbillinfo "
						  		+ "WHERE "
						  		+ "bill_number = ? "
						  		+ "AND "
						  		+ "bill_type = ? "
						  		+ "AND "
						  		+ "crusher_id = ? "
						  		+ "AND "
						  		+ "crusher_code = ? ";
						  
						  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
						  
						  getProductInfoPSMT.setString(1, billNumber.split("#")[0]);
						  getProductInfoPSMT.setString(2, dao.getBillType());					  
						  getProductInfoPSMT.setString(3, crusherId);
						  getProductInfoPSMT.setString(4, crusherCode);
						  
						  getProductInfoRS = getProductInfoPSMT.executeQuery();
						
						  StringBuilder productNames = new StringBuilder();
						  StringBuilder quantities = new StringBuilder();
						 
						  while(getProductInfoRS.next())
						  {
							  
							  String productName = getProductInfoRS.getString(1);
							    float quantity = getProductInfoRS.getFloat(3);

							     boolean found = false;
							    for (Map<String, Object> productInfo : productQuantityList) {
							        if (productInfo.get("productName").equals(productName)) {
							            float existingQuantity = (float) productInfo.get("quantity");
							            productInfo.put("quantity", existingQuantity + quantity);
							            found = true;
							            break;
							        }
							    }
							    

								   if (!found) {
								        Map<String, Object> newProduct = new LinkedHashMap<>();
								        newProduct.put("productName", productName);
								        newProduct.put("quantity", quantity);
								        productQuantityList.add(newProduct);
								    }
								

								  if (productNames.length() > 0) {
								        productNames.append(" / ");
								        quantities.append(" / ");
								    }
								  
								  productNames.append(getProductInfoRS.getString(1));  
								    quantities.append(getProductInfoRS.getString(3));    

								    dao.setItemNameAll(productNames.toString());  
								    dao.setItemQuantityAll(quantities.toString());
								    
								    
								    
							  totalMaterialCost = totalMaterialCost + getProductInfoRS.getFloat(2);
							  allBillMatrialCostTotal = allBillMatrialCostTotal + getProductInfoRS.getFloat(2);;
							
								  dao.setItemName(getProductInfoRS.getString(1));
								  dao.setItemQuantity(getProductInfoRS.getString(3));
								  dao.setItemRate(getProductInfoRS.getString(4));
								  dao.setCgst(getProductInfoRS.getFloat(5));
								 dao.setSgst(getProductInfoRS.getFloat(6));
								 dao.setIgst(getProductInfoRS.getString(7));
								   
								 dao.setTaxableAmt(getProductInfoRS.getString(8));

								  
								  totalCgstAllTheTime = totalCgstAllTheTime + getProductInfoRS.getFloat(5);
								  totalSgstAllTheTime = totalSgstAllTheTime + getProductInfoRS.getFloat(6);
								  totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime + getProductInfoRS.getFloat(8);
								  
								  
								  
									 totalcgst = totalcgst + getProductInfoRS.getFloat(5);
									 totalsgst = totalsgst + getProductInfoRS.getFloat(6);
									 
								 totalMaterial = totalMaterial + getProductInfoRS.getFloat(3);
								 
								
								
								  
					
						  }
						  
						}
					  
					  this.setTotalRoyalty(royalty);
					  
					  this.setMaterialTotal(totalMaterial);
					  float amountReceived = Float.parseFloat(dao.getBillAmountRecieved());
					  
					
					  float totalAmount = Float.parseFloat(dao.getBillTotalAmount());
					  dao.setMaterialAmount(""+totalMaterialCost);
					  dao.setBalanceAmount(""+(totalAmount-amountReceived));
					  billMap.put(billNumber, dao);
					  
					  if(getProductInfoRS != null)
					  {
						  getProductInfoRS.close();
						  getProductInfoRS = null;
					  }
					  
					  if(getProductInfoPSMT != null)
					  {
						  getProductInfoPSMT.close();
						  getProductInfoPSMT = null;
					  }
					  

			            
						String getCashOnlineAmtCode = "SELECT payment_type,"
								+ "amount "
								+ " FROM "
								+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
								+ "crusher_code = ?";

						PreparedStatement getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

						getCashOnlineAmtPSMT.setString(1, dao.getAccount1CreditDebitId());
						getCashOnlineAmtPSMT.setString(2, crusherId);
						getCashOnlineAmtPSMT.setString(3, crusherCode);

						ResultSet getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
						if (getCashOnlineAmtRs.next()) {
							dao.setAcc1PaymentType(getCashOnlineAmtRs.getString(1));
							dao.setAcc1Amount(getCashOnlineAmtRs.getFloat(2));
						} else {
							dao.setAcc1PaymentType("NA");
							dao.setAcc1Amount(0.0f);
							
						}

						if (getCashOnlineAmtRs != null) {
							getCashOnlineAmtRs.close();
							getCashOnlineAmtRs = null;
						}

						if (getCashOnlineAmtPSMT != null) {
							getCashOnlineAmtPSMT.close();
							getCashOnlineAmtPSMT = null;
						}
						
						
						
						 getCashOnlineAmtCode = "SELECT payment_type,"
								+ "amount "
								+ " FROM "
								+ "bank_account_credit_debit_master WHERE entry_id = ? " + "AND " + "crusher_id = ? " + "AND "
								+ "crusher_code = ?";

						 getCashOnlineAmtPSMT = connection.prepareStatement(getCashOnlineAmtCode);

						getCashOnlineAmtPSMT.setString(1, dao.getAccount2CreditDebitId());
						getCashOnlineAmtPSMT.setString(2, crusherId);
						getCashOnlineAmtPSMT.setString(3, crusherCode);

						 getCashOnlineAmtRs = getCashOnlineAmtPSMT.executeQuery();
						if (getCashOnlineAmtRs.next()) {
							dao.setAcc2PaymentType(getCashOnlineAmtRs.getString(1));
							dao.setAcc2Amount(getCashOnlineAmtRs.getFloat(2));
						} else {
							dao.setAcc2PaymentType("NA");
							dao.setAcc2Amount(0.0f);
							
						}

						if (getCashOnlineAmtRs != null) {
							getCashOnlineAmtRs.close();
							getCashOnlineAmtRs = null;
						}

						if (getCashOnlineAmtPSMT != null) {
							getCashOnlineAmtPSMT.close();
							getCashOnlineAmtPSMT = null;
						}

						
				  
						
						
						if(dao.getAcc1PaymentType().equals("CASH"))
						{
							dao.setCashAmt(dao.getAcc1Amount()); 
							
						}else if(dao.getAcc2PaymentType().equals("CASH"))
						{
							dao.setCashAmt(dao.getAcc2Amount());
							
						}
						
						if(!dao.getAcc1PaymentType().equals("CASH"))
						{
							dao.setOnlineAmt(dao.getAcc1Amount());
							
						}else if(!dao.getAcc2PaymentType().equals("CASH"))
						{
							dao.setOnlineAmt(dao.getAcc2Amount());
							
						}
						
						this.setTotalCashAmt(this.getTotalCashAmt() + dao.getCashAmt());
						this.setTotalOnlineAmt(this.getTotalOnlineAmt() + dao.getOnlineAmt());
					  
				  }
				  
				 
					 
				  for(String billNumber:billMap.keySet())
				  {
					  this.getTodayBillingList().add(billMap.get(billNumber));
				  }
				  
				  
			
				

				
				  if(resultSet != null) { resultSet.close(); resultSet = null; }
				  
				  if(preparedStatement != null) { preparedStatement.close(); preparedStatement
				  = null; }
				 

				sql = "SELECT " 
				        + "bi.bill_number," 
						+ "DATE_FORMAT(bi.bill_date,'%d-%m-%Y')," 
				        + "bi.customer_id,"
						+ "bi.customer_name," 
				        + "cust.billing_address," 
						+ "bi.transportation_charges,"
						+ "bi.bill_total_amount," 
						+ "bi.bill_amount_received," 
						+ "bi.billed_by," 
						+ "bi.chalan_number,"
						+ "bi.bill_type " 
						+ "FROM " 
						+ "crusher_bill_info_master as bi "
						+ "INNER JOIN "
						+ "crusher_customer_master as cust " 
						+ "ON " 
						+ "bi.customer_id = cust.customer_id " 
						+ "WHERE "
						+ "bill_date = STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND " 
						+ "bi.crusher_id = ? " 
						+ "AND "
						+ "bi.crusher_code = ? " 
						+ "AND " 
						+ "cust.crusher_id = ? " 
						+ "AND " 
						+ "cust.crusher_code = ? "
						+ "ORDER BY bi.bill_number DESC LIMIT 5";

				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, this.getBillDate());
				preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				preparedStatement.setString(4, crusherId);
				preparedStatement.setString(5, crusherCode);

				resultSet = preparedStatement.executeQuery();

				while (resultSet.next()) {
					TodayBillingListDAO dao = new TodayBillingListDAO();

					dao.setBillNumber(resultSet.getString(1));
					dao.setBillDate(resultSet.getString(2));
					dao.setCustId(resultSet.getString(3));
					dao.setCustName(resultSet.getString(4).split("-")[1]);
					dao.setCustAddress(resultSet.getString(5));
					dao.setTransportCharges(resultSet.getString(6));
					dao.setBillTotalAmount(resultSet.getString(7));
					dao.setBillAmountRecieved(resultSet.getString(8));
					dao.setBilledBy(resultSet.getString(9));
					dao.setChalanNumber(resultSet.getString(10));
					dao.setBillType(resultSet.getString(11));
					lastBillingList.add(dao);
				}

				
				  if(resultSet != null) { resultSet.close(); resultSet = null; }
				  
				  if(preparedStatement != null) { preparedStatement.close(); preparedStatement
				  = null; }
				  
				  sql = "SELECT " 
				          + "bi.bill_number," 
						  + "DATE_FORMAT(bi.bill_date,'%d-%m-%Y'),"
				          + "bi.customer_id," 
						  + "bi.customer_name," 
				          + "cust.billing_address,"
						  + "bi.transport_charges," 
				          + "bi.bill_total_amount," 
						  + "bi.bill_amount_received," 
				          + "bi.billed_by," 
						  + "bi.chalan_number," 
				          + "bi.bill_type " 
						  + "FROM " 
				          + "crusher_rmc_billinfo as bi " 
						  + "INNER JOIN "
				          + "crusher_customer_master as cust " 
						  + "ON " 
				          + "bi.customer_id = cust.customer_id " 
						  + "WHERE " 
				          + "bill_date = STR_TO_DATE(?,'%d-%m-%Y') " 
						  + "AND " 
				          + "bi.crusher_id = ? " 
						  + "AND " 
				          + "bi.crusher_code = ? " 
						  + "AND " 
				          + "cust.crusher_id = ? " 
						  + "AND " 
				          + "cust.crusher_code = ? "
						  + "ORDER BY bi.bill_number DESC LIMIT 5";
				  
				  preparedStatement = connection.prepareStatement(sql);
				  preparedStatement.setString(1, this.getBillDate());
				  preparedStatement.setString(2, crusherId); preparedStatement.setString(3,
				  crusherCode); preparedStatement.setString(4, crusherId);
				  preparedStatement.setString(5, crusherCode);
				  
				  resultSet = preparedStatement.executeQuery();
				  
				  while(resultSet.next()) {
					  TodayBillingListDAO dao = new TodayBillingListDAO();
				  
				  dao.setBillNumber(resultSet.getString(1));
				  dao.setBillDate(resultSet.getString(2));
				  dao.setCustId(resultSet.getString(3));
				  dao.setCustName(resultSet.getString(4).split("-")[1]);
				  dao.setCustAddress(resultSet.getString(5));
				  dao.setTransportCharges(resultSet.getString(6));
				  dao.setBillTotalAmount(resultSet.getString(7));
				  dao.setBillAmountRecieved(resultSet.getString(8));
				  dao.setBilledBy(resultSet.getString(9));
				  dao.setChalanNumber(resultSet.getString(10));
				  dao.setBillType(resultSet.getString(11)); 
				  lastBillingList.add(dao); }
				  
				  
				 

				// LAST 5 CUSTOMER PAYMENT ENTRYIES

				if (resultSet != null) {
					resultSet.close();
					resultSet = null;
				}

				if (preparedStatement != null) {
					preparedStatement.close();
					preparedStatement = null;
				}

				sql = "SELECT " + "cpd.payement_entry_id," + "cpd.customer_id," + "cpd.customer_name,"
						+ "DATE_FORMAT(cpd.payment_date,'%d-%m-%Y')," + "cpd.amount," + "cpd.payemnt_details,"
						+ "cpd.payment_entry_by," + "c.billing_address " + "FROM "
						+ "crusher_customer_payment_details_master as cpd " + "INNER JOIN "
						+ "crusher_customer_master as c " + "ON " + "c.customer_id = cpd.customer_id " + "WHERE "
						+ "cpd.crusher_id = ? " + "AND " + "cpd.crusher_code = ? " + "AND " + "c.crusher_id = ? "
						+ "AND " + "c.crusher_code = ? " + "ORDER BY payement_entry_id DESC LIMIT 5";

				preparedStatement = connection.prepareStatement(sql);

				preparedStatement.setString(1, crusherId);
				preparedStatement.setString(2, crusherCode);
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);

				resultSet = preparedStatement.executeQuery();

				while (resultSet.next()) {
					CustomerPaymentDetailsDAO dao = new CustomerPaymentDetailsDAO();

					dao.setPaymentId(resultSet.getString(1));
					dao.setCustId(resultSet.getString(2));
					dao.setCustName(resultSet.getString(3));
					dao.setPaymentDate(resultSet.getString(4));
					dao.setAmount(resultSet.getFloat(5));
					dao.setDetails(resultSet.getString(6));
					dao.setReceivedBy(resultSet.getString(7));
					dao.setCustAddess(resultSet.getString(8));
					this.getLast5EntryCustPaymentList().add(dao);

				}

				
				
				  this.setVehicleNotificationList(new
						  GetNotificationList().getVehicleNotificationList());
						 
				  this.getSessionMap().put("vehicleNotifications", new
				  GetNotificationList().getVehicleNotificationList());
				 
				 
				this.setBankAccountReportDAOList(GetBankAccountEntryDetails.getBankAccountDetails(this.getBillDate(),
						this.getBillDate(), this.getSessionMap()));

				for (BankAccountStatementDAO dao : this.getBankAccountReportDAOList()) {
					if (dao.getEntryType().equals("CREDIT")) {
						this.setTotalCredit(this.getTotalCredit() + dao.getAmount());
					}

					if (dao.getEntryType().equals("DEBIT")) {
						this.setTotalDebit(this.getTotalDebit() + dao.getAmount());
					}
				}

				this.setBalance(this.getTotalCredit() - this.getTotalDebit());
				
				
				
				PreparedStatement getDaiyExpensePSMT = null;
				ResultSet getDaiyExpenseRS = null;

				sql = "SELECT " + "entry_id," + "DATE_FORMAT(expense_date,'%d-%m-%Y')," + "expense_details,"
						+ "expense_amount," + "type_of_payment," + "expense_entry_by," + "expense_bill_image " + "FROM "
						+ "crusher_daily_expenses " + "WHERE " + "(expense_date BETWEEN "
						+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) " + "AND " + "crusher_id = ? "
						+ "AND " + "crusher_code = ? ";

				getDaiyExpensePSMT = connection.prepareStatement(sql);

				getDaiyExpensePSMT.setString(1, this.getBillDate());
				getDaiyExpensePSMT.setString(2, this.getBillDate());
				getDaiyExpensePSMT.setString(3, crusherId);
				getDaiyExpensePSMT.setString(4, crusherCode);

				getDaiyExpenseRS = getDaiyExpensePSMT.executeQuery();

				while (getDaiyExpenseRS.next()) {
					DailyExpenseDAO dailyExpenseDAO = new DailyExpenseDAO();
					dailyExpenseDAO.setId(getDaiyExpenseRS.getString(1));
					dailyExpenseDAO.setExpenseDate(getDaiyExpenseRS.getString(2));
					dailyExpenseDAO.setExpenseReason(getDaiyExpenseRS.getString(3));
					dailyExpenseDAO.setAmount(getDaiyExpenseRS.getString(4));
					dailyExpenseDAO.setTypeOfPayment(getDaiyExpenseRS.getString(5));
					dailyExpenseDAO.setDescription(getDaiyExpenseRS.getString(6));
					dailyExpenseDAO.setExpenseImage(getDaiyExpenseRS.getBlob(7));
					dailyExpenseDAO.setKey(EncryptionDecryption.encrypt(getDaiyExpenseRS.getString(1) + "#"
							+ getDaiyExpenseRS.getString(2) + "#" + getDaiyExpenseRS.getString(4)));
					this.setTotalExpenseAmount(
							this.getTotalExpenseAmount() + Float.parseFloat(getDaiyExpenseRS.getString(4)));
					// id # date # amount
					this.getDailyExpenseList().add(dailyExpenseDAO);

				}

				if (getDaiyExpenseRS != null) {
					getDaiyExpenseRS.close();
					getDaiyExpenseRS = null;
				}

				if (getDaiyExpensePSMT != null) {
					getDaiyExpensePSMT.close();
					getDaiyExpensePSMT = null;
				}
				
				
				
				sql = "SELECT "
						+ "account_id,"
						+ "account_number,"
						+ "SUM(amount) AS total_credit "
					     + "FROM "
						+ "bank_account_credit_debit_master "
						+ "WHERE "
						+ "entry_type = ? "
						+ "AND "
						+ "(entry_date "
						+ "BETWEEN "
						+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND crusher_code = ? "
					    + "GROUP BY account_id, account_number "
					    + "HAVING total_credit > 0";
						
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, "CREDIT");
				preparedStatement.setString(2, this.getBillDate());
				preparedStatement.setString(3, this.getBillDate());
				preparedStatement.setString(4, crusherId);
				preparedStatement.setString(5, crusherCode);
				
				resultSet = preparedStatement.executeQuery();
				
				resultSet.last();
				
				int rowCount = resultSet.getRow();
				
				resultSet.beforeFirst();
				
				if(rowCount > 0)
				{
					while(resultSet.next())
					{
						
					
					String accountId = resultSet.getString(1);
					
						BankAccountStatementDAO dao = new BankAccountStatementDAO();
						
						dao.setAccountId(resultSet.getString(1));
						dao.setAccountNumber(resultSet.getString(2));
						dao.setAmount(resultSet.getFloat("total_credit"));

						
						
						PreparedStatement preparedStatementBank= null;
						ResultSet resultSetBank = null;
						
							
							sql = "SELECT "
									+ "account_holder_name "
									+ "FROM "
									+ "crusher_bank_account "
									+ "WHERE "
									+ "account_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
									
							
							preparedStatementBank = connection.prepareStatement(sql);
							preparedStatementBank.setString(1, accountId);
							preparedStatementBank.setString(2, crusherId);
							preparedStatementBank.setString(3, crusherCode);
							
							resultSetBank = preparedStatementBank.executeQuery();
							
							
								while(resultSetBank.next())
								{
									dao.setAccountName(resultSetBank.getString(1));
									
								}
								
						
						this.getBankCreditList().add(dao);
					}
					}
				
				
				
				
				  
				  sql = "SELECT "
	    					+ "cpd.payement_entry_id,"
	    					+ "cpd.customer_id,"
	    					+ "cpd.customer_name,"
	    					+ "DATE_FORMAT(cpd.payment_date,'%d-%m-%Y'),"
	    					+ "cpd.amount,"
	    					+ "cpd.payemnt_details,"
	    					+ "cust.billing_address "
	    					+ "FROM "
	    					+ "crusher_customer_payment_details_master AS cpd "
	    					+ "INNER JOIN "
	    					+ "crusher_customer_master AS cust "
	    					+ "ON "
	    					+ "cpd.customer_id = cust.customer_id "
	    					+ "WHERE "
	    					+ "(cpd.payment_date "
	    					+ "BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
	    					+ "AND "
	    					+ "cpd.crusher_id = ? "
	    					+ "AND "
	    					+ "cpd.crusher_code = ? "
	    					+ "AND "
	    					+ "cust.crusher_id = ? "
	    					+ "AND "
	    					+ "cust.crusher_code = ? ";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, this.getBillDate());
	    			preparedStatement.setString(2, this.getBillDate());
	    			preparedStatement.setString(3, crusherId);
	    			preparedStatement.setString(4, crusherCode);
	    			preparedStatement.setString(5, crusherId);
	    			preparedStatement.setString(6, crusherCode);
	    			
	    			
				  
	    			resultSet = preparedStatement.executeQuery();
	    			
	    			int rowCount1 = 0;
	    			resultSet.last();
	    			rowCount1 = resultSet.getRow();
	    			resultSet.beforeFirst();
	    			
	    			if(rowCount1 > 0)
	    			{
	    				
	    				
	    				while(resultSet.next())
	    				{
	    					CustomerPaymentDetailsDAO dao = new CustomerPaymentDetailsDAO();
	    					
	    					dao.setPaymentId(resultSet.getString(1));
	    					dao.setCustId(resultSet.getString(2));
	    					dao.setCustName(resultSet.getString(3));
	    					dao.setPaymentDate(resultSet.getString(4));
	    					dao.setAmount(resultSet.getFloat(5));
	    					dao.setDetails(resultSet.getString(6));
	    					dao.setCustAddess(resultSet.getString(7));
	    					
	    					
	    					this.getCustPaymentDetailsDAOList().add(dao);
	    				}
	    				
	    				
	    			}
	    			
	    			  
					  if(resultSet != null)
					  {
						  resultSet.close();
						  resultSet = null;
					  }
					  
					  if(preparedStatement != null)
					  {
						  preparedStatement.close();
						  preparedStatement = null;
					  }
					  
					  
					  HashMap<String,String> bankNameMapping = new HashMap<String,String>();
					  sql = "SELECT "
					  		+ "account_id,"
					  		+ "account_holder_name "
					  		+ "FROM "
					  		+ "crusher_bank_account "
					  		+ "WHERE "
					  		+ "crusher_id = ? "
					  		+ "AND "
					  		+ "crusher_code = ? ";
					  
					  preparedStatement = connection.prepareStatement(sql);
					  preparedStatement.setString(1, crusherId);
					  preparedStatement.setString(2, crusherCode);
				
					  
					  resultSet = preparedStatement.executeQuery();
					
					  while(resultSet.next())
					  {
						  bankNameMapping.put(resultSet.getString(1), resultSet.getString(2));
					  }
					  
						 if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
						  
						  
					  sql = "SELECT "
								+ "entry_id,"
								+ "account_id,"
								+ "account_number,"
								+ "entry_date,"
								+ "DATE_FORMAT(entry_date,'%d-%m-%Y'),"
								+ "entry_time,"
								+ "entry_type,"
								+ "amount,"
								+ "payment_type,"
								+ "entry_by,"
								+ "entry_details "
								+ "FROM "
								+ "bank_account_credit_debit_master "
								+ "WHERE "
								+ "entry_type = 'DEBIT' "
								+ "AND "
								+ "(entry_date BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? " 
								+ "ORDER BY "
								+ "entry_date,account_id";
						
						preparedStatement = connection.prepareStatement(sql);
						preparedStatement.setString(1, this.getBillDate());
						preparedStatement.setString(2, this.getBillDate());
						preparedStatement.setString(3, crusherId);
						preparedStatement.setString(4, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						resultSet.last();
						
						rowCount = resultSet.getRow();
						
						resultSet.beforeFirst();
						
						if(rowCount > 0)
						{
							
							while(resultSet.next())
							{
								BankAccountStatementDAO dao = new BankAccountStatementDAO();
								dao.setAccountId(resultSet.getString(2));
								dao.setDateAsString(resultSet.getString(5));
								dao.setEntryId(resultSet.getString(1));
								dao.setEntryType(resultSet.getString(7));
								dao.setAmount(resultSet.getFloat(8));
								dao.setPaymentType(resultSet.getString(9));
								dao.setEntryBy(resultSet.getString(10));
								dao.setAccountNumber(resultSet.getString(3));
								dao.setEntryDetails(resultSet.getString(11));
								dao.setAccountName(bankNameMapping.get(resultSet.getString(2)));
								this.getReportList().add(dao);
							}
						}
					  
				
						
						
						  int customerCount = 0;
							
					         sql = "SELECT "
					              + "customer_name "
					              + "FROM "
					              + "crusher_customer_master "
					              + "WHERE "
					              + "crusher_id = ? "
					              + "AND "
					              + "crusher_code = ?";
	
					  preparedStatement = connection.prepareStatement(sql);
					  preparedStatement.setString(1, crusherId);
					  preparedStatement.setString(2, crusherCode);
	
					  resultSet = preparedStatement.executeQuery();
	
					  while (resultSet.next()) {
					      
						  customerCount++;
					  }
	
					 
					  
					  this.getSessionMap().replace("totalNoOfCustomer", customerCount);
					
	
						if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
						  
						  int employeeCount = 0;
							
						  sql = "SELECT "
					              + "employee_name "
					              + "FROM "
					              + "crusher_employee_master "
					              + "WHERE "
					              + "crusher_id = ? "
					              + "AND "
					              + "crusher_code = ?";
		
					  preparedStatement = connection.prepareStatement(sql);
					  preparedStatement.setString(1, crusherId);
					  preparedStatement.setString(2, crusherCode);
	
					  resultSet = preparedStatement.executeQuery();
		
					  while (resultSet.next()) {
					      
						  employeeCount++;
					  }
		
					 
					  this.getSessionMap().replace("totalNoOfEmployee", employeeCount);
					
		
						if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
						  
						  
						  int vehicleCount = 0;
							
						  sql = "SELECT "
					              + "vehicle_id "
					              + "FROM "
					              + "crusher_vehicle_details_master "
					              + "WHERE "
					              + "crusher_id = ? "
					              + "AND "
					              + "crusher_code = ?";
		
					  preparedStatement = connection.prepareStatement(sql);
					  preparedStatement.setString(1, crusherId);
					  preparedStatement.setString(2, crusherCode);
				
					  resultSet = preparedStatement.executeQuery();
				
					  while (resultSet.next()) {
					      
						  vehicleCount++;
					  }
				
					 
					  
					  this.getSessionMap().replace("totalNoOfVehicle", vehicleCount);
					
				
						if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
						  
						  
						  int supplierCount = 0;
							
						  sql = "SELECT "
					              + "supplier_name "
					              + "FROM "
					              + "crusher_supplier_master "
					              + "WHERE "
					              + "crusher_id = ? "
					              + "AND "
					              + "crusher_code = ?";
		
					  preparedStatement = connection.prepareStatement(sql);
					  preparedStatement.setString(1, crusherId);
					  preparedStatement.setString(2, crusherCode);
				
					
					resultSet = preparedStatement.executeQuery();
					
					while (resultSet.next()) {
					    
						supplierCount++;
					}
					
					
					
					this.getSessionMap().replace("totalNoOfSupplier", supplierCount);
					
							
					
					
					
					
					
						if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
					
						  
						  
							String actualStartDate = "";
				        
					
						  Date today = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
				        	
				        	Calendar cal = Calendar.getInstance(); cal.setTime(today); // don't forget this if date is arbitrary e.g. 01-01-2014
				        	int year = cal.get(Calendar.YEAR);
				       
				        	SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-YYYY");
				        	
				        	actualStartDate = "01-04-"+(year-2);
				        	
				        	  fromDate = ("01-04-"+(year-2));
				        	  toDate = (sdf.format(today));
				        	
				        	
				        	 Map<String,CustomerInfoDAO> customerInfoMap = new LinkedHashMap<String,CustomerInfoDAO>();
					    		
								
				    			sql = "SELECT "
				    					+ "customer_id,"
				    					+ "customer_name,"
				    					+ "mobile_number,"
				    					+ "billing_address,"
				    					+ "credit_limit "
				    					+ "FROM "
				    					+ "crusher_customer_master "
				    					+ "WHERE "
				    					+ "crusher_id = ? "
				    					+ "AND "
				    					+ "crusher_code = ? "
				    					+ "ORDER BY customer_name asc";
				    			
				    			preparedStatement = connection.prepareStatement(sql);
				    			/*preparedStatement.setString(1, this.getCustIdStart());
				    			preparedStatement.setString(2, this.getCustIdEnd());*/
				    			
				    			preparedStatement.setString(1, crusherId);
				    			preparedStatement.setString(2, crusherCode);
				    			
				    			resultSet = preparedStatement.executeQuery();
				    			int count = 1;
				    		
				    		
				    			while(resultSet.next())
				    			{
				    				CustomerInfoDAO customerInfoDAO = new CustomerInfoDAO();
				    				
				    				customerInfoDAO.setCustomerId(resultSet.getString(1));
				    				customerInfoDAO.setCustName(resultSet.getString(2));
				    				customerInfoDAO.setMobileNumber(resultSet.getString(3));
				    				customerInfoDAO.setBillingaddress(resultSet.getString(4));
				    				customerInfoDAO.setCreditlimit(resultSet.getString(5));
				    				
				    				customerInfoMap.put(resultSet.getString(1),customerInfoDAO);	    				
				    			}
				    			
				    			if(resultSet != null)
				    			{
				    				resultSet.close();
				    				resultSet = null;
				    			}
				    			
				    			if(preparedStatement != null)
				    			{
				    				preparedStatement.close();
				    				preparedStatement = null;
				    			}
				    			
				    			
				    			
				    			List<CustomerCreditReportDAO> custCreditList = new ArrayList<CustomerCreditReportDAO>();	
				    			
				    			Map<String,CustomerCreditReportDAO> custCreditReportMap = new LinkedHashMap<String,CustomerCreditReportDAO>() ;
				    			
				    			for(String custId: customerInfoMap.keySet())
				    			{
				    				float opeingBalFloat = 0.0F;
			       					PreparedStatement getOpeningBalPSMT = null;
			           				ResultSet getOpeningBalRs = null;
			           				String getOpeningBalSQL = "SELECT "
			           						+ "opening_balance,"
			           						+ "DATE_FORMAT(opening_balance_date,'%d/%m/%Y'),"
			           						+ "updated_by "
			           						+ "FROM "
			           						+ "crusher_cust_close_open_bal_master "
			           						+ "WHERE "
			           						+ "customer_id = ? "
			           						+ "AND "
			           						+ "crusher_id = ? "
			           						+ "AND "
			           						+ "crusher_code = ?";
			           				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
			           				
			           				getOpeningBalPSMT.setString(1, custId);
			           				getOpeningBalPSMT.setString(2, crusherId);
			           				getOpeningBalPSMT.setString(3, crusherCode);
			           				
			           				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
			           				
			           				if(getOpeningBalRs.next())
			           				{
			       					
			           					opeingBalFloat = getOpeningBalRs.getFloat(1);
			       					
			           				}
			           				
			           			//	System.out.println(opeingBalFloat);
			           				if(getOpeningBalRs != null)
			           				{
			           					getOpeningBalRs.close();
			           					getOpeningBalRs = null;
			           				}
			           				if(getOpeningBalPSMT != null)
			           				{
			           					getOpeningBalPSMT.close();
			           					getOpeningBalPSMT = null;
			           				}
			       					
			       					
			           				
				    				CustomerInfoDAO customerInfoDAO = customerInfoMap.get(custId);
				    				CustomerCreditReportDAO creditReportDAO = new CustomerCreditReportDAO();
				    				creditReportDAO.setCustometName(customerInfoDAO.getCustName());
				    				creditReportDAO.setCustomerMobile(customerInfoDAO.getMobileNumber());
				    				creditReportDAO.setCustomerAddress(customerInfoDAO.getBillingaddress());
				    				creditReportDAO.setOpeningBalance(opeingBalFloat);
				    				creditReportDAO.setSrNo(count);
				    				
				    				customerInfoDAO.setOpeningBalance(opeingBalFloat);
					    			
				    				
				    				count ++;
				    				
				    				float custTotalPaymentAmount = 0.0F;
				    				
				    				float custBeforeDateTotalPayment = 0.0F;
				    				float custAfterDateTotalPayment = 0.0F;
				    				
				    				PreparedStatement getCustPaymentDetailsPSMT = null;
				    				ResultSet getCustPaymnetDetailsRS = null;
				    				
				    				String getCustPaymentDetailsSQL = "SELECT "
					    						+ "SUM(amount) "
						       					+ "FROM "
						       					+ "crusher_customer_payment_details_master "
						       					+ "WHERE "
						       					+ "customer_id = ? "
						       					+ "AND "
						       					+ "(payment_date >= STR_TO_DATE(?, '%d-%m-%Y') "
						       					+ "AND "
						       					+ "payment_date < STR_TO_DATE(?, '%d-%m-%Y')) "
						       					+ "AND "
						       					+ "crusher_id = ? "
						       					+ "AND "
						       					+ "crusher_code = ? ";
				    		
				    			getCustPaymentDetailsPSMT = connection.prepareStatement(getCustPaymentDetailsSQL);
				    			
				    			getCustPaymentDetailsPSMT.setString(1, custId);
				    			getCustPaymentDetailsPSMT.setString(2, actualStartDate);
				    			getCustPaymentDetailsPSMT.setString(3, fromDate);
				    			getCustPaymentDetailsPSMT.setString(4, crusherId);
				    			getCustPaymentDetailsPSMT.setString(5, crusherCode);
				    			
				    			getCustPaymnetDetailsRS = getCustPaymentDetailsPSMT.executeQuery();
				    			
				    			if(getCustPaymnetDetailsRS.next())
				    			{
				    				if(getCustPaymnetDetailsRS.getString(1) != null)
				    				{
				    					custBeforeDateTotalPayment = getCustPaymnetDetailsRS.getFloat(1);
				    				}
				    			}
				    			
			  			
				    			if(getCustPaymnetDetailsRS != null)
				    			{
				    				getCustPaymnetDetailsRS.close();
				    				getCustPaymnetDetailsRS = null;
				    			}
				    			
				    			if(getCustPaymentDetailsPSMT != null)
				    			{
				    				getCustPaymentDetailsPSMT.close();
				    				getCustPaymentDetailsPSMT = null;
				    			}
				    			
				    		 getCustPaymentDetailsSQL = "SELECT "
			    						+ "SUM(amount) "
				       					+ "FROM "
				       					+ "crusher_customer_payment_details_master "
				       					+ "WHERE "
				       					+ "customer_id = ? "
				       					+ "AND "
				       					+ "(payment_date "
				       					+ "BETWEEN "
				       					+ "STR_TO_DATE(?, '%d-%m-%Y') "
				       					+ "AND "
				       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
				       					+ "AND "
				       					+ "crusher_id = ? "
				       					+ "AND "
				       					+ "crusher_code = ? ";
					
						getCustPaymentDetailsPSMT = connection.prepareStatement(getCustPaymentDetailsSQL);
						
						getCustPaymentDetailsPSMT.setString(1, custId);
						getCustPaymentDetailsPSMT.setString(2, fromDate);
						getCustPaymentDetailsPSMT.setString(3, toDate);
						getCustPaymentDetailsPSMT.setString(4, crusherId);
						getCustPaymentDetailsPSMT.setString(5, crusherCode);
						
						//System.out.println(getCustPaymentDetailsPSMT.toString());
						
						getCustPaymnetDetailsRS = getCustPaymentDetailsPSMT.executeQuery();
						
						if(getCustPaymnetDetailsRS.next())
						{
							if(getCustPaymnetDetailsRS.getString(1) != null)
							{
								custAfterDateTotalPayment = getCustPaymnetDetailsRS.getFloat(1);
							}
						}
				    			
						creditReportDAO.setTotalPaymentBeforeDate(df.format(custBeforeDateTotalPayment));
						creditReportDAO.setTotalPaymentAfterDate(df.format(custAfterDateTotalPayment));
						custTotalPaymentAmount = custBeforeDateTotalPayment + custAfterDateTotalPayment;
						
						creditReportDAO.setTotalPaymentAmount(df.format(custTotalPaymentAmount));
						
						custCreditReportMap.put(custId, creditReportDAO);
				    			
				    			
						    			if(getCustPaymnetDetailsRS != null)
						    			{
						    				getCustPaymnetDetailsRS.close();
						    				getCustPaymnetDetailsRS = null;
						    			}
						    			
						    			if(getCustPaymentDetailsPSMT != null)
						    			{
						    				getCustPaymentDetailsPSMT.close();
						    				getCustPaymentDetailsPSMT = null;
						    			}
						    			
						    		//	System.out.println(creditReportDAO.getCustometName()+"::"+ creditReportDAO.getOpeningBalance());
				    			}
				    			
				    			for(String custId: custCreditReportMap.keySet())	    				
				    			{
				    				CustomerCreditReportDAO creditReportDAO = custCreditReportMap.get(custId);
				    				
				    				float custTotalPaymentAmount = Float.parseFloat(creditReportDAO.getTotalPaymentAmount());
						    				
						    				float billAmountBeforeDate = 0.0F;
						    				float billAmountAfterDate = 0.0F;
						    				
						    				float totalBillAmountBeforeDate = 0.0F;	
						    				float totalBillAmountAfterDate = 0.0F;
						    				
						    				float billAmountReceivedBeforeDate = 0.0F;
						    				float billAmountReceivedAfterDate = 0.0F;
						    				
						    				float totalAmountRecievedBeforeDate = 0.0F;
						    				float totalAmountRecievedAfterDate = 0.0F;
						    				
						    				float billAmountBalanceBeforeDate = 0.0F;
						    				float billAmountBalanceAfterDate = 0.0F;
						    				
						    				float totalBalanceAmtBeforeDate = 0.0F;
						    				float totalBalanceAmtAfterDate = 0.0F;
						    				
						       				
						       				float custTotalCreditAmount = 0.0F;
						    				float custTotalBillAmount = 0.0F;
						    				float custTotalAmountReceived = 0.0F;
						       				
						       				PreparedStatement getBillAmountPSMT = null;
						       				ResultSet getBillAmountRS = null;
						       				String getBillAmountSQL=  "SELECT "	           					
						           					+ "bill_total_amount,"
						           					+ "bill_amount_received,"
						           					+ "bill_amount_return "
						           					+ "FROM "
						           					+ "crusher_bill_info_master "
						           					+ "WHERE "		           					
						           					+ "customer_id = ? "			           				
						           					+ "AND "
							       					+ "(bill_date >= STR_TO_DATE(?, '%d-%m-%Y') "
							       					+ "AND "
							       					+ "bill_date < STR_TO_DATE(?, '%d-%m-%Y')) "
							       					+ "AND "
							       					+ "crusher_id = ? "
							       					+ "AND "
							       					+ "crusher_code = ? ";
						       				
						       				
						       				getBillAmountPSMT = connection.prepareStatement(getBillAmountSQL);
						       				getBillAmountPSMT.setString(1, custId);
						       				getBillAmountPSMT.setString(2, actualStartDate);
						       				getBillAmountPSMT.setString(3, fromDate);
						       				getBillAmountPSMT.setString(4, crusherId);
						       				getBillAmountPSMT.setString(5, crusherCode);
						       				
						       				
						       				getBillAmountRS = getBillAmountPSMT.executeQuery();
						       				
						       				while(getBillAmountRS.next())
						       				{
						       					
						       					try
						       					{
						       						if(getBillAmountRS.getString(2) != null)
						       						{
						       						
						       							billAmountBeforeDate = getBillAmountRS.getFloat(1);
						       							billAmountReceivedBeforeDate = getBillAmountRS.getFloat(2);
						       							billAmountBalanceBeforeDate = billAmountBeforeDate - billAmountReceivedBeforeDate;
						       							totalBillAmountBeforeDate = totalBillAmountBeforeDate + billAmountBeforeDate;
							           	   				if(billAmountBalanceBeforeDate > 0)
								           				{
								           					
								           					totalAmountRecievedBeforeDate = totalAmountRecievedBeforeDate + billAmountReceivedBeforeDate;
								           					totalBalanceAmtBeforeDate = totalBalanceAmtBeforeDate+billAmountBalanceBeforeDate;
								           					
								           				}
								           				else if(billAmountBalanceBeforeDate == 0)
								           				{
								           					totalAmountRecievedBeforeDate = totalAmountRecievedBeforeDate + billAmountReceivedBeforeDate;
									           								           				
								           				}
						       						}
						       						
							           			}catch(NumberFormatException nfe)
						       					{
						       						result = "error";
													/*
													 * addActionError("Error while fomatting ! " +
													 * "While calculating each bill datails for customer");
													 */
						       					}
						       				}
						       				
						       				
						       				totalBalanceAmtBeforeDate = totalBalanceAmtBeforeDate + creditReportDAO.getOpeningBalance();
						       				creditReportDAO.setTotalBalAmountBeforeDate(totalBalanceAmtBeforeDate);
						       				creditReportDAO.setTotalBillAmountBeforeDate(totalBillAmountBeforeDate);
						       				creditReportDAO.setTotalPaymentBeforeDate(""+(Float.parseFloat(creditReportDAO.getTotalPaymentBeforeDate()) + totalAmountRecievedBeforeDate));
						       			
						       					getBillAmountSQL=  "SELECT "	           					
						           					+ "bill_total_amount,"
						           					+ "bill_amount_received,"
						           					+ "bill_amount_return "
						           					+ "FROM "
						           					+ "crusher_bill_info_master "
						           					+ "WHERE "		           					
						           					+ "customer_id = ? "
						           					+ "AND "
						           					+ "(bill_date "
						           					+ "BETWEEN "
						           					+ "STR_TO_DATE(?, '%d-%m-%Y') "
							       					+ "AND "
							       					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
							       					+ "AND "
							       					+ "crusher_id = ? "
							       					+ "AND "
							       					+ "crusher_code = ? ";
						       				
						       				if(getBillAmountRS != null)
						       				{
						       					getBillAmountRS.close();
						       					getBillAmountRS = null;
						       				}
						       				if(getBillAmountPSMT != null)
						       				{
						       					getBillAmountPSMT.close();
						       					getBillAmountPSMT = null;
						       				}
						       				
						       				
						       				getBillAmountPSMT = connection.prepareStatement(getBillAmountSQL);
						       				getBillAmountPSMT.setString(1, custId);
						       				getBillAmountPSMT.setString(2, fromDate);
						       				getBillAmountPSMT.setString(3, toDate);
						       				getBillAmountPSMT.setString(4, crusherId);
						       				getBillAmountPSMT.setString(5, crusherCode);
						       				
						       				getBillAmountRS = getBillAmountPSMT.executeQuery();
						       				
						       				while(getBillAmountRS.next())
						       				{
						       					
						       					try
						       					{
						       						if(getBillAmountRS.getString(2) != null)
						       						{
						       						
						       							billAmountAfterDate = getBillAmountRS.getFloat(1);
						       							billAmountReceivedAfterDate = getBillAmountRS.getFloat(2);
						       							billAmountBalanceAfterDate = billAmountAfterDate - billAmountReceivedAfterDate;
						       							totalBillAmountAfterDate = totalBillAmountAfterDate + billAmountAfterDate;
							           					if(billAmountBalanceAfterDate > 0)
								           				{
								           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
								           					totalBalanceAmtAfterDate = totalBalanceAmtAfterDate+billAmountBalanceAfterDate;
								           					
								           				}
								           				else if(billAmountBalanceAfterDate == 0)
								           				{
								           					totalAmountRecievedAfterDate = totalAmountRecievedAfterDate + billAmountReceivedAfterDate;
									           								           				
								           				}
						       						}
						       						
							           			}catch(NumberFormatException nfe)
						       					{
						       						result = "error";
													/*
													 * addActionError("Error while fomatting ! " +
													 * "While calculating each bill datails for customer ");
													 */
						       					}
						       				}
						       			
						       				
							       			creditReportDAO.setTotalBillAmountAfterDate(totalBillAmountAfterDate);
						       				creditReportDAO.setTotalPaymentAfterDate(""+(Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate()) + totalAmountRecievedAfterDate));
						       				
						       				creditReportDAO.setTotalBalAmountAfterDate(totalBillAmountAfterDate - (Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate())));
						       			
						       				
						       				
						       				
						       				creditReportDAO.setTotalBalAmount(totalBalanceAmtBeforeDate + totalBalanceAmtAfterDate);
						       				
						     				
						       				custTotalBillAmount = totalBillAmountBeforeDate + totalBillAmountAfterDate;
						       				custTotalAmountReceived = totalAmountRecievedBeforeDate + totalAmountRecievedAfterDate;
						       				
						       				custTotalPaymentAmount = Float.parseFloat(creditReportDAO.getTotalPaymentBeforeDate()) + Float.parseFloat(creditReportDAO.getTotalPaymentAfterDate());
						       				custTotalCreditAmount = (custTotalBillAmount+creditReportDAO.getOpeningBalance()) - custTotalPaymentAmount;
						       				
						       				creditReportDAO.setTotalBillAmount(""+custTotalBillAmount);
						       				creditReportDAO.setTotalCreditAmount(custTotalCreditAmount);
						       				creditReportDAO.setTotalPaymentAmount(""+custTotalPaymentAmount);
						       				
						       				creditReportDAO.setSmsData(EncryptionDecryption.encrypt(creditReportDAO.getCustomerMobile()
						       						+"-"+creditReportDAO.getTotalCreditAmount()));
						       				

						       				if(getBillAmountRS != null)
						       				{
						       					getBillAmountRS.close();
						       					getBillAmountRS = null;
						       				}
						       				if(getBillAmountPSMT != null)
						       				{
						       					getBillAmountPSMT.close();
						       					getBillAmountPSMT = null;
						       				}
						       				
						       				 if(custTotalCreditAmount>0)
						       				{
						       					custCreditList.add(creditReportDAO);
						       					
						       				}
						       					
						       				
						       				
						       				
						       				
						       			 Collections.sort(custCreditList);
						       			   
						       			
						       				
							    			
				    			}	
				    			
				    			
				    			for(CustomerCreditReportDAO  dao : custCreditList)
			       				{
			       					
			       				 
			       				 try{
			       					 
			       				 
			       					totalReportCreditAmountCustomer =  totalReportCreditAmountCustomer+dao.getTotalCreditAmount() ;
				       				
				       				 }catch (Exception e) {
			       					
			       				 }
			       				}
				    			
				    			this.setTotalReportCreditAmountCustomer(totalReportCreditAmountCustomer);
				    			
				    			this.getSessionMap().replace("allCustomerCreditAmt", this.getTotalReportCreditAmountCustomer());
								
				    			
				    		
				    			
				    			Date today1 = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
					        	
					        	Calendar cal1 = Calendar.getInstance(); cal1.setTime(today1); // don't forget this if date is arbitrary e.g. 01-01-2014
					        	int year1 = cal1.get(Calendar.YEAR);
					        	SimpleDateFormat sdf1 = new SimpleDateFormat("dd-MM-YYYY");
					        	
					        	String StartDate1 = "01-04-"+(year1-1);
					        	String EndDate1 = sdf1.format(today1);
					        	
					        	
					        	Map<String,SupplierDebtReportDAO> supplierInfoMap = new LinkedHashMap<String,SupplierDebtReportDAO>();
					    		
					        	sql = "SELECT "
				    					+ "supplier_id,"
				    					+ "supplier_name,"
				    					+ "contact_number,"
				    					+ "supplier_address "
				    					+ "FROM "
				    					+ "crusher_supplier_master "
				    					+ "WHERE "
				    					+ "crusher_id = ? "
				    					+ "AND "
				    					+ "crusher_code = ? "
				    					+ "ORDER BY supplier_name ASC";
				    			
				    			preparedStatement = connection.prepareStatement(sql);
				    			preparedStatement.setString(1, crusherId);
				    			preparedStatement.setString(2, crusherCode);
				    			
				    			
				    			resultSet = preparedStatement.executeQuery();
				    			int count1 = 1;
				    			
				    			while(resultSet.next())
				    			{
				    				SupplierDebtReportDAO dao =  new SupplierDebtReportDAO();
				    				dao.setSrNo(count1);
				    				dao.setSupplierName(resultSet.getString("supplier_name"));
				    				dao.setSupplierAddress(resultSet.getString("supplier_address"));
				    				
				    				supplierInfoMap.put(resultSet.getString(1), dao);
				    				count1++;
				    			}
				    			
				    			if(resultSet != null)
				    			{
				    				resultSet.close();
				    				resultSet = null;
				    			}
				    			
				    			if(preparedStatement != null)
				    			{
				    				preparedStatement.close();
				    				preparedStatement = null;
				    			}
				    			
			    			for(String supplierId : supplierInfoMap.keySet())
			    			{
				    				
				    				SupplierDebtReportDAO dao = supplierInfoMap.get(supplierId);

									PreparedStatement getOpeningBalPSMT = null;
				       				ResultSet getOpeningBalRs = null;
				       				String getOpeningBalSQL = "SELECT "
				       						+ "opening_balance "
				       						+ "FROM "
				       						+ "crusher_supplier_close_open_bal_master "
				       						+ "WHERE "
				       						+ "supplier_id = ? "
				       						+ "AND "
				       						+ "crusher_id = ? "
				       						+ "AND "
				       						+ "crusher_code = ? ";
				       				
				       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
				       				
				       				getOpeningBalPSMT.setString(1, supplierId);
				       				getOpeningBalPSMT.setString(2, crusherId);
				       				getOpeningBalPSMT.setString(3, crusherCode);
				       				
				       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
				       				
				       				if(getOpeningBalRs.next())
				       				{
				       					dao.setOpeningBalance(getOpeningBalRs.getFloat(1));
				       				}
				       				else
				       				{
				       					dao.setOpeningBalance(0.0F);
				       				}
				       				
				       				if(getOpeningBalRs != null)
				       				{
				       					getOpeningBalRs.close();
				       					getOpeningBalRs = null;
				       				}
				       				if(getOpeningBalPSMT != null)
				       				{
				       					getOpeningBalPSMT.close();
				       					getOpeningBalPSMT = null;
				       				}
				       				
				       				
				       				float floatTotalPurchaseAmt = 0.0F;
				       				float floatTotalAmountPaid = 0.0F;
				       				float floatTotalBalanceAmt = 0.0F;
				       				
				       				
				       				PreparedStatement getTotalPurchasePSMT = null;
				       				ResultSet getTotalPurchaseRS = null;
				       				
				       				String getTotalPurchaseSQL = "SELECT "
				       						+ "SUM(purchase_total_amount),"
				       						+ "SUM(purchase_amount_paid) "
				       						+ "FROM "
				       						+ "crusher_purchase_master "
				       						+ "WHERE "
				       						+ "supplier_id = ? "
				       						+ "AND "
				       						+ "crusher_id = ? "
				       						+ "AND "
				       						+ "crusher_code = ? ";
				       				
				       				getTotalPurchasePSMT = connection.prepareStatement(getTotalPurchaseSQL);
				       				
				       				getTotalPurchasePSMT.setString(1, supplierId);
				       				getTotalPurchasePSMT.setString(2, crusherId);
				       				getTotalPurchasePSMT.setString(3, crusherCode);
				       				
				       				
				       				getTotalPurchaseRS = getTotalPurchasePSMT.executeQuery();
				       				
				       				if(getTotalPurchaseRS.next())
				       				{
				       					floatTotalPurchaseAmt = getTotalPurchaseRS.getFloat(1);
				       					floatTotalAmountPaid = getTotalPurchaseRS.getFloat(2);
				       					
				       				}
				       				
				       				
				       				PreparedStatement getSuppAmtPaidPSMT = null;
				       				ResultSet getSuppAmtPaidRS = null;
				       				String getSuppAmtPaidSQL = "SELECT "
				       						+ "SUM(amount) "
				       						+ "FROM "
				       						+ "crusher_supplier_payment_details_master "
				       						+ "WHERE "
				       						+ "supplier_id = ? "
				       						+ "AND "
				       						+ "crusher_id = ? "
				       						+ "AND "
				       						+ "crusher_code = ? ";
				       				
				       				getSuppAmtPaidPSMT = connection.prepareStatement(getSuppAmtPaidSQL);
				       				getSuppAmtPaidPSMT.setString(1, supplierId);
				       				getSuppAmtPaidPSMT.setString(2, crusherId);
				       				getSuppAmtPaidPSMT.setString(3, crusherCode);
				       				
				       				
				       				getSuppAmtPaidRS = getSuppAmtPaidPSMT.executeQuery();
				       				
				       				
				       				
				       				if(getSuppAmtPaidRS.next())
				       				{
				       					floatTotalAmountPaid = floatTotalAmountPaid + getSuppAmtPaidRS.getFloat(1);
				       				}
				       				
				       				floatTotalBalanceAmt = floatTotalPurchaseAmt - floatTotalAmountPaid;
				       				
				       				dao.setTotalPurchaseAmount(floatTotalPurchaseAmt);
				       				dao.setTotalDebtAmount(floatTotalBalanceAmt+dao.getOpeningBalance());
				       				dao.setTotalPaymentAmount(floatTotalAmountPaid);
				       				
				       			//	System.out.println(floatTotalBalanceAmt+dao.getOpeningBalance());
				       				if(getSuppAmtPaidRS != null)
				       				{
				       					getSuppAmtPaidRS.close();
				       					getSuppAmtPaidRS = null;
				       				}
				       				
				       				if(getSuppAmtPaidPSMT != null)
				       				{
				       					getSuppAmtPaidPSMT.close();
				       					getSuppAmtPaidPSMT = null;
				       				}
				       				
				       				
				       				
				       				if(getTotalPurchaseRS != null)
				       				{
				       					getTotalPurchaseRS.close();
				       					getTotalPurchaseRS = null;
				       				}
				       				
				       				if(getTotalPurchasePSMT != null)
				       				{
				       					getTotalPurchasePSMT.close();
				       					getTotalPurchasePSMT = null;
				       				}
				       				
				       				supplierInfoMap.put(supplierId, dao);
				       				
			    			}
			    			this.setAllTotalDebtAmountSupplier(0.0f);
			    			for(String supplierId : supplierInfoMap.keySet())
			    			{
			    				this.setAllTotalDebtAmountSupplier(this.getAllTotalDebtAmountSupplier()+supplierInfoMap.get(supplierId).getTotalDebtAmount());
			    				
			    			}
			    			this.getSessionMap().replace("allSupplierDebtAmt", this.getAllTotalDebtAmountSupplier());
							
		    			
						  
			    			
			    			sql = "SELECT "
			    					+ "entry_id,"
			    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
			    					+ "expense_reason,"
			    					+ "expense_amount,"
			    					+ "type_of_payment,"
			    					+ "expense_details,"
			    					+ "expense_bill_image "
			    					+ "FROM "
			    					+ "crusher_daily_expenses "
			    					+ "WHERE "
			    					+ "(expense_date BETWEEN "
			    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
			    					+ "AND "
			    					+ "crusher_id = ? "
			    					+ "AND "
			    					+ "crusher_code = ? ";
			    					
			    			
			    			preparedStatement = connection.prepareStatement(sql);
			    			
			    			preparedStatement.setString(1, fromDate );
			    			preparedStatement.setString(2, toDate);
			    			preparedStatement.setString(3, crusherId);
			    			preparedStatement.setString(4, crusherCode);
			    			
			    			resultSet = preparedStatement.executeQuery();
			    			resultSet.last();
			    			int resultCount = resultSet.getRow();
			    			resultSet.beforeFirst();
			    			
			    			float AllTotalExpenseAmount = 0.0f;
			    			if(resultCount > 0)
			    			{
			    				while(resultSet.next())
			    				{
			    					AllTotalExpenseAmount = AllTotalExpenseAmount+Float.parseFloat(resultSet.getString(4));
			    					
			    				}
			    			}
			    			this.setAllTotalExpenseAmount(AllTotalExpenseAmount);
			    			
			    				this.getSessionMap().replace("allTotalExpenseAmt", this.getAllTotalExpenseAmount());
								
			    				
			    				
			    				
			    				 

								  PreparedStatement getpurchaseEntryPSMT = null;
				       				ResultSet getpurchaseEntryRs = null;
				       				
					       			
					       			
				       				sql = "SELECT "
				       						+ "purchase_id,"
				       						+ "purchase_invoice_number,"
				       						+ "DATE_FORMAT(purchase_date,'%d/%m/%Y'),"
				       						+ "tarnsportation_charges,"
				       						+ "other_expenses,"
				       						+ "purchase_total_amount,"
				       						+ "purchase_amount_paid,"
				       						+ "comments,"
				       						+ "purcahsed_by,"
				       						+ "purchase_entry_by,"
				       						+ "entry_type "
				       						+ "FROM "
				       						+ "crusher_purchase_master "
				       						+ "WHERE "
				       						+ "(purchase_date BETWEEN "
						   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
						   					+ "AND "
						   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
						   					+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
				       				
				       				getpurchaseEntryPSMT = connection.prepareStatement(sql);
				       				
				       				getpurchaseEntryPSMT.setString(1, this.getBillDate());
				       				getpurchaseEntryPSMT.setString(2, this.getBillDate());
				       				getpurchaseEntryPSMT.setString(3, crusherId);
				       				getpurchaseEntryPSMT.setString(4, crusherCode);
									
									
									
									
				       				getpurchaseEntryRs = getpurchaseEntryPSMT.executeQuery();
				       				while(getpurchaseEntryRs.next())
				       				{
				       					
				       					SupplierAccountDetailsDAO dao = new SupplierAccountDetailsDAO();
				       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(getpurchaseEntryRs.getString(3)); 
			    	       				
				       					dao.setEntryType("PURCHASE");
				       					dao.setPaymentPurchaseId(getpurchaseEntryRs.getString(1));
										
										  dao.setPuchaseNumber(getpurchaseEntryRs.getString(1));
										 dao.setInvoiceNumber(getpurchaseEntryRs.getString(2));
										 dao.setDate(date1);
					       				dao.setPurchaseAmount(getpurchaseEntryRs.getString(6));
				       					dao.setAmountPaid(getpurchaseEntryRs.getFloat(7));
				       					dao.setBalanceAmount(getpurchaseEntryRs.getFloat(6) - getpurchaseEntryRs.getFloat(7));
				       					dao.setComments(getpurchaseEntryRs.getString(8));
				       					dao.setPurchaseBy(getpurchaseEntryRs.getString(9));
				       					dao.setEntryBy(getpurchaseEntryRs.getString(10));
				       					dao.setDebtAmount(0.0F);
				       					dao.setEntryAddedBy(getpurchaseEntryRs.getString(11));
				       					
				       					this.getPurchaseDetailsList().add(dao);
				       					
				       				}
				       				 List<Map<String, Object>> productQuantityList = new ArrayList<>();
				       				
			   						for(SupplierAccountDetailsDAO dao : this.getPurchaseDetailsList())
				       				{
			   							
			   						dao.setDateAsString(dateFormat.format(d));
			   						 
									 
									  String getProductInfoSQL = "";
									  PreparedStatement getProductInfoPSMT = null;
									  ResultSet getProductInfoRS = null;
									 
									 
									  getProductInfoSQL = "SELECT "
										  		+ "product_name,"
										  		+ "purchase_quantity,"
										  		+ "purchase_rate "
										  		+ "FROM "
										  		+ "crusher_purchase_product_info_master "
										  		+ "WHERE "
										  		+ "purchase_id = ? "
										  		+ "AND "
										  		+ "crusher_id = ? "
										  		+ "AND "
										  		+ "crusher_code = ? ";
									  
									  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
									  
									  getProductInfoPSMT.setString(1, dao.getPuchaseNumber());
									  getProductInfoPSMT.setString(2, crusherId);
									  getProductInfoPSMT.setString(3, crusherCode);
									 
									  
									  getProductInfoRS = getProductInfoPSMT.executeQuery();
								 
									
									  StringBuilder productNames = new StringBuilder();
									  StringBuilder quantities = new StringBuilder();
									  
									  
									  while(getProductInfoRS.next())
									  {
										  
										  String productName = getProductInfoRS.getString(1);
										    float quantity = getProductInfoRS.getFloat(2);

										     boolean found = false;
										    for (Map<String, Object> productInfo : productQuantityList) {
										        if (productInfo.get("productName").equals(productName)) {
										            float existingQuantity = (float) productInfo.get("quantity");
										            productInfo.put("quantity", existingQuantity + quantity);
										            found = true;
										            break;
										        }
										    }

										   if (!found) {
										        Map<String, Object> newProduct = new LinkedHashMap<>();
										        newProduct.put("productName", productName);
										        newProduct.put("quantity", quantity);
										        productQuantityList.add(newProduct);
										    }
										   
										   
										   if (productNames.length() > 0) {
										        productNames.append(" / ");
										        quantities.append(" / ");
										    }
										  
										  productNames.append(getProductInfoRS.getString(1));  
										    quantities.append(getProductInfoRS.getString(2));    

										    dao.setItemNameAll(productNames.toString());  
										    dao.setItemQuantityAll(quantities.toString());
										    
										   
										    
										    
										  dao.setItemRate(getProductInfoRS.getString(3));
										 
										 
										 
									  }
									  
									  
									  
									  
									  
									  
				       				}
				       				
				       				this.getSessionMap().replace("purchaseEntrylist", this.getPurchaseDetailsList());
									  
				       			
				       				
				       				
				       				if (resultSet != null) {
				    					resultSet.close();
				    					resultSet = null;
				    				}

				    				if (preparedStatement != null) {
				    					preparedStatement.close();
				    					preparedStatement = null;
				    				}

				    				

				    				 sql = "SELECT "
				    					    + "rmc_bill_number, "
				    					    + "DATE_FORMAT(entry_date, '%d-%m-%Y') AS entry_date, "
				    					    + "10mm, "
				    					    + "20mm, "
				    					    + "crushsand, "
				    					    + "washsand, "
				    					    + "water, "
				    					    + "addmixture, "
				    					    + "cementopc, "
				    					    + "cementppc, "
				    					    + "bill_type "
				    					    + "FROM rmc_bill_ingredients_used_details_master "				    					   
				    					    + "WHERE entry_date = STR_TO_DATE(?, '%d-%m-%Y') "
				    					    + "AND crusher_id = ? "
				    					    + "AND crusher_code = ? "			    					    
				    					    + "ORDER BY "
				    					    + "entry_date, "
				    					    + "entry_time, "
				    					    + "rmc_bill_number, "
				    					    + "bill_type";

				       			

				        			preparedStatement = connection.prepareStatement(sql);
				        			preparedStatement.setString(1, this.getBillDate());
				            		preparedStatement.setString(2, crusherId); 
				            		preparedStatement.setString(3, crusherCode);
				            		
				            		resultSet = preparedStatement.executeQuery();
				            		
				            		
				            		this.setTotalTenMMUsed(0.0f);
				            		this.setTotalTwentyMMUsed(0.0f);
				            		this.setTotalWashSandUsed(0.0f);
				            		this.setTotalCrushSandUsed(0.0f);
				            		this.setTotalWaterUsed(0.0f);
				            		this.setTotalAddMixtureUsed(0.0f);
				            		this.setTotalOPCUsed(0.0f);
				            		this.setTotalPPCUsed(0.0f);
				            		
				            		
				            		while(resultSet.next())
				            		{
				            			RMCBillIngredientsUsedDAO billIngredientsUsedDAO = new RMCBillIngredientsUsedDAO();
				            			
				            			billIngredientsUsedDAO.setRmBillNumber(resultSet.getString(1));
				            			
				            			billIngredientsUsedDAO.setBillDate(resultSet.getString(2));
				            			billIngredientsUsedDAO.setTenmm(resultSet.getFloat(3));
				            			billIngredientsUsedDAO.setTwentymm(resultSet.getFloat(4));
				            			billIngredientsUsedDAO.setCrushsand(resultSet.getFloat(5));
				            			billIngredientsUsedDAO.setWashsand(resultSet.getFloat(6));
				            			billIngredientsUsedDAO.setWater(resultSet.getFloat(7));
				            			billIngredientsUsedDAO.setAddmixture(resultSet.getFloat(8));
				            			billIngredientsUsedDAO.setCementOPC(resultSet.getFloat(9));
				            			billIngredientsUsedDAO.setCementPPC(resultSet.getFloat(10));
				            			billIngredientsUsedDAO.setBillType(resultSet.getString(11));
				            			
				            			
				            			String getRMCBillInfoSQL = "SELECT "
				            					+ "chalan_number,"
				            					+ "customer_name "
				            					+ "FROM "
				            					+ "crusher_rmc_billinfo "
				            					+ "WHERE "
				            					+ "bill_number = ? "
				            					+ "AND "
				            					+ "crusher_id = ? "
				            					+ "AND "
				            					+ "crusher_code = ? ";
				            			
				            			PreparedStatement getRMCBillInfoPSMT = connection.prepareStatement(getRMCBillInfoSQL);
				            			
				            			getRMCBillInfoPSMT.setString(1, billIngredientsUsedDAO.getRmBillNumber());
				            			getRMCBillInfoPSMT.setString(2, crusherId);
				            			getRMCBillInfoPSMT.setString(3, crusherCode);
				            			
				            			
				            			ResultSet getRMCBillInfoRS = getRMCBillInfoPSMT.executeQuery();
				            			
				            			if(getRMCBillInfoRS.next())
				            			{
				            				billIngredientsUsedDAO.setChalanNo(getRMCBillInfoRS.getString(1));
				            				billIngredientsUsedDAO.setCutomerName(getRMCBillInfoRS.getString(2).split("-")[1]);
				            			}
				            			
				            			
				            			if(getRMCBillInfoRS != null)
				            			{
				            				getRMCBillInfoRS.close();
				            				getRMCBillInfoRS = null;
				            			}
				            			
				            			if(getRMCBillInfoPSMT != null)
				            			{
				            				getRMCBillInfoPSMT.close();
				            				getRMCBillInfoPSMT = null;
				            			}
				            		
				            			
				                		this.setTotalTenMMUsed(this.getTotalTenMMUsed() + resultSet.getFloat(3));
				                		this.setTotalTwentyMMUsed(this.getTotalTwentyMMUsed() + resultSet.getFloat(4));
				                		this.setTotalCrushSandUsed(this.getTotalCrushSandUsed() + resultSet.getFloat(5));
				                		this.setTotalWashSandUsed(this.getTotalWashSandUsed() + resultSet.getFloat(6));
				                		this.setTotalWaterUsed(this.getTotalWaterUsed() + resultSet.getFloat(7));
				                		this.setTotalAddMixtureUsed(this.getTotalAddMixtureUsed() + resultSet.getFloat(8));
				                		this.setTotalOPCUsed(this.getTotalOPCUsed() + resultSet.getFloat(9));
				                		this.setTotalPPCUsed(this.getTotalPPCUsed() + resultSet.getFloat(10));
				            			
				            			
				            			String getRMCProductName = "SELECT "
				            					+ "product_name "
				            					+ "FROM "
				            					+ "crusher_rmc_productbillinfo "
				            					+ "WHERE "
				            					+ "crusher_id = ? "
				            					+ "AND "
				            					+ "crusher_code = ? "
				            					+ "AND "
				            					+ "bill_number = ? ";
				            			
				            			
				            			PreparedStatement getRMCProductNamePSMT = connection.prepareStatement(getRMCProductName);
				            			getRMCProductNamePSMT.setString(1, crusherId);
				            			getRMCProductNamePSMT.setString(2, crusherCode);
				            			getRMCProductNamePSMT.setString(3, resultSet.getString(1));
				            			
				            			ResultSet getRMCPRoductNameRS = getRMCProductNamePSMT.executeQuery();
				            			
				            			if(getRMCPRoductNameRS.next())
				            			{
				            				billIngredientsUsedDAO.setProductName(getRMCPRoductNameRS.getString(1));
				            			}
				            			
				            			this.getRmcUsedIngreDAOList().add(billIngredientsUsedDAO);
				            			
				            			
				            			if(getRMCPRoductNameRS != null)
				            			{
				            				getRMCPRoductNameRS.close();
				            				getRMCPRoductNameRS = null;
				            			}
				            			
				            			
				            			if(getRMCProductNamePSMT != null)
				            			{
				            				getRMCProductNamePSMT.close();
				            				getRMCProductNamePSMT = null;
				            			}
				            		}
				            		
				            		
			    			
				this.getSessionMap().remove("productList");
				this.getSessionMap().remove("billInformation");
				this.getSessionMap().remove("deletedProductList");
				this.getSessionMap().remove("purchaseProductList");
				this.getSessionMap().remove("purchaseInformation");
				this.getSessionMap().remove("finishedProductInfoList");
				this.getSessionMap().remove("deletedProductInfoList");
				this.getSessionMap().remove("billvehicleinfo");
				this.getSessionMap().remove("challanProductList");
				this.getSessionMap().remove("challanInformation");
				this.getSessionMap().remove("challanVehicleinfo");
				this.getSessionMap().remove("quotationInformation");
				this.getSessionMap().remove("quotationProductList");
				this.getSessionMap().remove("RMCProductList");
				this.getSessionMap().remove("RMCBillInformation");
				this.getSessionMap().remove("RMCBillvehicleinfo");
				this.getSessionMap().remove("dcselected");
				
				
				
				
                this.setCustomerPaymentReminderList(GetNotificationList.getCustPaymentReminderList(this.getSessionMap()));
        		
        		this.getSessionMap().put("customerpaymentnotificationlist",this.getCustomerPaymentReminderList());

        		
				if (requestFromAndroid) {
					result = "android-success";
				} else {
					result = SUCCESS;
				}

			} catch (SQLException e) {
				 e.printStackTrace();
				result = ERROR;
				addActionError(e.getErrorCode() + "| "+this.getText("message.error.connectionError"));

			} catch (Exception e) {
				e.printStackTrace();
				result = ERROR;
				addActionError(e.getMessage() + "| "+this.getText("message.error.connectionError"));
			} finally {
				if (resultSet != null) {
					try {
						resultSet.close();
						resultSet = null;
					} catch (SQLException e) {

					}
				}
				if (preparedStatement != null) {
					try {

						preparedStatement.close();
						preparedStatement = null;
					} catch (SQLException e) {

					}
				}
				if (connection != null) {
					try {

						connection.close();
						connection = null;
					} catch (SQLException e) {

						// e.printStackTrace();
					}
				}

			}
		}

		return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public void setSession(Map<String, Object> map) {
		sessionMap = (SessionMap<String, Object>) map;
	}

	public String getBillDate() {
		return billDate;
	}

	public void setBillDate(String billDate) {
		this.billDate = billDate;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public List<TodayBillingListDAO> getTodayBillingList() {
		return todayBillingList;
	}

	public void setTodayBillingList(List<TodayBillingListDAO> todayBillingList) {
		this.todayBillingList = todayBillingList;
	}

	public List<TodayBillingListDAO> getLastBillingList() {
		return lastBillingList;
	}

	public void setLastBillingList(List<TodayBillingListDAO> lastBillingList) {
		this.lastBillingList = lastBillingList;
	}

	public List<CustomerPaymentDetailsDAO> getLast5EntryCustPaymentList() {
		return last5EntryCustPaymentList;
	}

	public void setLast5EntryCustPaymentList(List<CustomerPaymentDetailsDAO> last5EntryCustPaymentList) {
		this.last5EntryCustPaymentList = last5EntryCustPaymentList;
	}

	public List<String> getVehicleNotificationList() {
		return vehicleNotificationList;
	}

	public void setVehicleNotificationList(List<String> vehicleNotificationList) {
		this.vehicleNotificationList = vehicleNotificationList;
	}

	public List<BankAccountStatementDAO> getBankAccountReportDAOList() {
		return bankAccountReportDAOList;
	}

	public void setBankAccountReportDAOList(List<BankAccountStatementDAO> bankAccountReportDAOList) {
		this.bankAccountReportDAOList = bankAccountReportDAOList;
	}

	public List<DailyExpenseDAO> getDailyExpenseList() {
		return dailyExpenseList;
	}

	public void setDailyExpenseList(List<DailyExpenseDAO> dailyExpenseList) {
		this.dailyExpenseList = dailyExpenseList;
	}

	public Float getTotalExpenseAmount() {
		return totalExpenseAmount;
	}

	public void setTotalExpenseAmount(Float totalExpenseAmount) {
		this.totalExpenseAmount = totalExpenseAmount;
	}

	public Float getMaterialTotal() {
		return materialTotal;
	}

	public void setMaterialTotal(Float materialTotal) {
		this.materialTotal = materialTotal;
	}

	public Float getAllBillMatrialCostTotal() {
		return allBillMatrialCostTotal;
	}

	public void setAllBillMatrialCostTotal(Float allBillMatrialCostTotal) {
		this.allBillMatrialCostTotal = allBillMatrialCostTotal;
	}

	public Float getTransportTotal() {
		return transportTotal;
	}

	public void setTransportTotal(Float transportTotal) {
		this.transportTotal = transportTotal;
	}

	public Float getTotalBillAmount() {
		return totalBillAmount;
	}

	public void setTotalBillAmount(Float totalBillAmount) {
		this.totalBillAmount = totalBillAmount;
	}

	public Float getTotalBalanceAmount() {
		return totalBalanceAmount;
	}

	public void setTotalBalanceAmount(Float totalBalanceAmount) {
		this.totalBalanceAmount = totalBalanceAmount;
	}

	public Float getTotalReceivedAmount() {
		return totalReceivedAmount;
	}

	public void setTotalReceivedAmount(Float totalReceivedAmount) {
		this.totalReceivedAmount = totalReceivedAmount;
	}

	public Float getTotalCredit() {
		return totalCredit;
	}

	public void setTotalCredit(Float totalCredit) {
		this.totalCredit = totalCredit;
	}

	public Float getTotalDebit() {
		return totalDebit;
	}

	public void setTotalDebit(Float totalDebit) {
		this.totalDebit = totalDebit;
	}

	public Float getBalance() {
		return balance;
	}

	public void setBalance(Float balance) {
		this.balance = balance;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	@Override
	public void setServletResponse(HttpServletResponse httpServletResponse) {
		this.response = httpServletResponse;
	}

	@Override
	public void setServletRequest(HttpServletRequest httpServletRequest) {
		this.request = httpServletRequest;
	}

	public Float getTotalTransportCharges() {
		return totalTransportCharges;
	}

	public void setTotalTransportCharges(Float totalTransportCharges) {
		this.totalTransportCharges = totalTransportCharges;
	}

	public Float getTotalRoyalty() {
		return totalRoyalty;
	}

	public void setTotalRoyalty(Float totalRoyalty) {
		this.totalRoyalty = totalRoyalty;
	}

	public List<BankAccountStatementDAO> getReportList() {
		return reportList;
	}

	public void setReportList(List<BankAccountStatementDAO> reportList) {
		this.reportList = reportList;
	}

	public List<CustomerPaymentDetailsDAO> getCustPaymentDetailsDAOList() {
		return custPaymentDetailsDAOList;
	}

	public void setCustPaymentDetailsDAOList(List<CustomerPaymentDetailsDAO> custPaymentDetailsDAOList) {
		this.custPaymentDetailsDAOList = custPaymentDetailsDAOList;
	}

	public List<BankAccountStatementDAO> getBankCreditList() {
		return bankCreditList;
	}

	

	public Float getTotalReportCreditAmountCustomer() {
		return totalReportCreditAmountCustomer;
	}

	public void setTotalReportCreditAmountCustomer(Float totalReportCreditAmountCustomer) {
		this.totalReportCreditAmountCustomer = totalReportCreditAmountCustomer;
	}

	public Float getAllTotalDebtAmountSupplier() {
		return AllTotalDebtAmountSupplier;
	}

	public void setAllTotalDebtAmountSupplier(Float allTotalDebtAmountSupplier) {
		AllTotalDebtAmountSupplier = allTotalDebtAmountSupplier;
	}

	public Float getAllTotalExpenseAmount() {
		return AllTotalExpenseAmount;
	}

	public void setAllTotalExpenseAmount(Float allTotalExpenseAmount) {
		AllTotalExpenseAmount = allTotalExpenseAmount;
	}

	public void setBankCreditList(List<BankAccountStatementDAO> bankCreditList) {
		this.bankCreditList = bankCreditList;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public ArrayList<CustomerPaymentReminderDetailsDAO> getCustomerPaymentReminderList() {
		return customerPaymentReminderList;
	}

	public void setCustomerPaymentReminderList(ArrayList<CustomerPaymentReminderDetailsDAO> customerPaymentReminderList) {
		this.customerPaymentReminderList = customerPaymentReminderList;
	}

	public List<SupplierAccountDetailsDAO> getPurchaseDetailsList() {
		return purchaseDetailsList;
	}

	public void setPurchaseDetailsList(List<SupplierAccountDetailsDAO> purchaseDetailsList) {
		this.purchaseDetailsList = purchaseDetailsList;
	}

	public Float getTotalTenMMUsed() {
		return totalTenMMUsed;
	}

	public void setTotalTenMMUsed(Float totalTenMMUsed) {
		this.totalTenMMUsed = totalTenMMUsed;
	}

	public Float getTotalTwentyMMUsed() {
		return totalTwentyMMUsed;
	}

	public void setTotalTwentyMMUsed(Float totalTwentyMMUsed) {
		this.totalTwentyMMUsed = totalTwentyMMUsed;
	}

	public Float getTotalWashSandUsed() {
		return totalWashSandUsed;
	}

	public void setTotalWashSandUsed(Float totalWashSandUsed) {
		this.totalWashSandUsed = totalWashSandUsed;
	}

	public Float getTotalCrushSandUsed() {
		return totalCrushSandUsed;
	}

	public void setTotalCrushSandUsed(Float totalCrushSandUsed) {
		this.totalCrushSandUsed = totalCrushSandUsed;
	}

	public Float getTotalAddMixtureUsed() {
		return totalAddMixtureUsed;
	}

	public void setTotalAddMixtureUsed(Float totalAddMixtureUsed) {
		this.totalAddMixtureUsed = totalAddMixtureUsed;
	}

	public Float getTotalOPCUsed() {
		return totalOPCUsed;
	}

	public void setTotalOPCUsed(Float totalOPCUsed) {
		this.totalOPCUsed = totalOPCUsed;
	}

	public Float getTotalPPCUsed() {
		return totalPPCUsed;
	}

	public void setTotalPPCUsed(Float totalPPCUsed) {
		this.totalPPCUsed = totalPPCUsed;
	}

	public Float getTotalWaterUsed() {
		return totalWaterUsed;
	}

	public void setTotalWaterUsed(Float totalWaterUsed) {
		this.totalWaterUsed = totalWaterUsed;
	}

	public List<RMCBillIngredientsUsedDAO> getRmcUsedIngreDAOList() {
		return rmcUsedIngreDAOList;
	}

	public void setRmcUsedIngreDAOList(List<RMCBillIngredientsUsedDAO> rmcUsedIngreDAOList) {
		this.rmcUsedIngreDAOList = rmcUsedIngreDAOList;
	}

	public Float getTotalCashAmt() {
		return totalCashAmt;
	}

	public void setTotalCashAmt(Float totalCashAmt) {
		this.totalCashAmt = totalCashAmt;
	}

	public Float getTotalOnlineAmt() {
		return totalOnlineAmt;
	}

	public void setTotalOnlineAmt(Float totalOnlineAmt) {
		this.totalOnlineAmt = totalOnlineAmt;
	}

	public Float getTotalTaxableAmtAllTheTime() {
		return totalTaxableAmtAllTheTime;
	}

	public void setTotalTaxableAmtAllTheTime(Float totalTaxableAmtAllTheTime) {
		this.totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime;
	}

	public Float getTotalCgstAllTheTime() {
		return totalCgstAllTheTime;
	}

	public void setTotalCgstAllTheTime(Float totalCgstAllTheTime) {
		this.totalCgstAllTheTime = totalCgstAllTheTime;
	}

	public Float getTotalSgstAllTheTime() {
		return totalSgstAllTheTime;
	}

	public void setTotalSgstAllTheTime(Float totalSgstAllTheTime) {
		this.totalSgstAllTheTime = totalSgstAllTheTime;
	}

	public Float getTotalPumpAmtAllTheTime() {
		return totalPumpAmtAllTheTime;
	}

	public void setTotalPumpAmtAllTheTime(Float totalPumpAmtAllTheTime) {
		this.totalPumpAmtAllTheTime = totalPumpAmtAllTheTime;
	}

	public Float getTotalLaborAmtAllTheTime() {
		return totalLaborAmtAllTheTime;
	}

	public void setTotalLaborAmtAllTheTime(Float totalLaborAmtAllTheTime) {
		this.totalLaborAmtAllTheTime = totalLaborAmtAllTheTime;
	}

	public List<Map<String, Object>> getProductQuantityList() {
		return productQuantityList;
	}

	public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
		this.productQuantityList = productQuantityList;
	}

	

	
	

}
