package com.stonecrusher.jspRedirect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class ViewSalarySlipJsp extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2110901200057633219L;
	private SessionMap<String,Object> sessionMap;  
	private String key;
	private String fromDate;
	private String toDate;
	private String laborName;
	private String noOfDaysInMonth;
	private String noOfAbsentDays;
	private String noOfOverTime;
	private String noOfHalfDays;
	private String noOfFullDaysPresent;
	private String additionalDeductionAmt;
	private String additionalPaymentAmt;
	private String totalSalary;
	private String comments;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
    			String entryId = keyDetails[0];
    			String laborId = keyDetails[1];
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "entry_id,"
							+ "DATE_FORMAT(salary_from_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(salary_to_date,'%d-%M-%Y'),"
							+ "employee_name,"
							+ "no_of_day_in_month,"
							+ "no_of_absent_days,"
							+ "no_of_over_time,"
							+ "no_of_half_days,"
							+ "no_of_full_days_present,"
							+ "additional_deduction_amount,"
							+ "additional_payment_amount,"
							+ "total_calculated_salary_amount,"
							+ "comments "
							+ "FROM "
							+ "crusher_employee_salary_calculation_details "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "employee_id = ? "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
    				preparedStatement.setString(1, entryId);
    				preparedStatement.setString(2, laborId);
    				preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
    				
    				if(resultSet.next())
    				{
    					this.setFromDate(resultSet.getString(2));
    					this.setToDate(resultSet.getString(3));
    					this.setLaborName(resultSet.getString(4));
    					this.setNoOfDaysInMonth(resultSet.getString(5));
    					this.setNoOfAbsentDays(resultSet.getString(6));
    					this.setNoOfOverTime(resultSet.getString(7));    				
    					this.setNoOfHalfDays(resultSet.getString(8));
    					this.setNoOfFullDaysPresent(resultSet.getString(9));
    					this.setAdditionalDeductionAmt(resultSet.getString(10));
    					this.setAdditionalPaymentAmt(resultSet.getString(11));
    					this.setTotalSalary(resultSet.getString(12));
    					this.setComments(resultSet.getString(13));
    					result = SUCCESS;
    					
    				}
    				else
    				{
    					result = ERROR;
    					addActionError(this.getText("message.error.salaryDetailsNotFound"));
    				}
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
				}
				catch (Exception e) {
					
					e.printStackTrace();
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public String getNoOfDaysInMonth() {
		return noOfDaysInMonth;
	}

	public void setNoOfDaysInMonth(String noOfDaysInMonth) {
		this.noOfDaysInMonth = noOfDaysInMonth;
	}

	public String getNoOfAbsentDays() {
		return noOfAbsentDays;
	}

	public void setNoOfAbsentDays(String noOfAbsentDays) {
		this.noOfAbsentDays = noOfAbsentDays;
	}

	public String getNoOfOverTime() {
		return noOfOverTime;
	}

	public void setNoOfOverTime(String noOfOverTime) {
		this.noOfOverTime = noOfOverTime;
	}

	public String getNoOfHalfDays() {
		return noOfHalfDays;
	}

	public void setNoOfHalfDays(String noOfHalfDays) {
		this.noOfHalfDays = noOfHalfDays;
	}

	public String getNoOfFullDaysPresent() {
		return noOfFullDaysPresent;
	}

	public void setNoOfFullDaysPresent(String noOfFullDaysPresent) {
		this.noOfFullDaysPresent = noOfFullDaysPresent;
	}

	public String getAdditionalDeductionAmt() {
		return additionalDeductionAmt;
	}

	public void setAdditionalDeductionAmt(String additionalDeductionAmt) {
		this.additionalDeductionAmt = additionalDeductionAmt;
	}

	public String getAdditionalPaymentAmt() {
		return additionalPaymentAmt;
	}

	public void setAdditionalPaymentAmt(String additionalPaymentAmt) {
		this.additionalPaymentAmt = additionalPaymentAmt;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getTotalSalary() {
		return totalSalary;
	}

	public void setTotalSalary(String totalSalary) {
		this.totalSalary = totalSalary;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}