package com.stonecrusher.jspRedirect;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.PurchaseInvoiceInformationDAO;
import com.stonecrusher.DAO.PurchaseProductInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;

public class ViewPurchaseJsp extends ActionSupport  implements SessionAware{

	
	private static final long serialVersionUID = 3567874872813915230L;
	
	private HttpSession session;
	private String purchaseNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO = null;	
	private List<PurchaseProductInfoDAO> purchaseProductInfoList = null;
	
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private String purchaseDateTime;
	private Float totalPurchaseAmount;
	private Float amountPaid;
	private Float frightCharges;
	private Float otherExpense;
	private File invoiceImage;
	private String comments;
	private DecimalFormat df;
	
	private Float totalNettAmount;
	private Float totalCGST;
	private Float totalSGST;
	private Float totalIGST;
	
	
	private String productName;
	private Float amount;
	private Float quantity;
	private Float purchaseUnit;
	private Float purchaseRate;
	private String taxId;
	
	private String purchaseId;
	private String supplierName;
	private String invoiceNumber;
	private String paymentDefaultValue;
	private String invoiceImageContentType;
	private boolean addToStock;
	private String purchaseBy;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	private String addSideBarJs;
	private String accountId;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private SessionMap<String,Object> sessionMap;
	private boolean invoiceBillAvailable;
	
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	private Float totalQuantity;
	private List<String> paymentTypeList2 = new ArrayList<String>();
	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	this.setTotalQuantity(0.0F);
	        	
	        	try
	        	{
	    			taxList = GetListResource.GetTaxList();
	    			
	    		} catch (IOException e) {
	    			
	    		}
	        	unitList = GetListResource.GetUnitList();
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	paymentTypeList2.add("CASH");
	        	paymentTypeList2.add("UPI");
	        	paymentTypeList2.add("RTGS");
	        	paymentTypeList2.add("NEFT");
	        	
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        
	        	
	        	
	    		
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
	       		
				
				//System.out.println(this.getPurchaseNumber());
				
	        	
	        	if(this.getPurchaseNumber() != null  || !this.getPurchaseNumber().equals(""))
	        	{
	        		try
	        		{
	        			this.setPurchaseProductInfoList(new ArrayList<PurchaseProductInfoDAO>());
	        		
	        			
						connection = GetDBConnection.getDBConnection(db);
	        			
		        			sql = "SELECT "
		        			+ "purchase_invoice_number,"
		        			+ "DATE_FORMAT(purchase_date,'%d-%m-%Y'),"								
							+ "purchase_time,"									
							+ "supplier_id,"
							+ "supplier_name,"
							+ "tarnsportation_charges,"
							+ "comments,"
							+ "other_expenses,"
							+ "purchase_total_amount,"
							+ "purchase_amount_paid,"
							+ "purchase_total_cgst_amount,"
							+ "purchase_total_sgst_amount,"
							+ "purchase_total_igst_amount,"
							+ "purchase_total_nett_amount,"
							+ "payemnt_type,"
							+ "purcahsed_by,"
							+ "purchase_invoice_pic "
							+ "FROM "
							+ "crusher_purchase_master "
							+ "WHERE "
							+ "purchase_id =? "
							+ "AND "
							+ "purchase_time <> 'null' "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
		        			
		        			preparedStatement = connection.prepareStatement(sql);
		        			preparedStatement.setString(1, this.getPurchaseNumber());
		        			preparedStatement.setString(2, crusherId);
	        				preparedStatement.setString(3, crusherCode);
	        				
		        			//System.out.println(preparedStatement.toString());
		        			resultSet = preparedStatement.executeQuery();
		        			
		        			int rowCount = 0;
		        			resultSet.last();
		        			rowCount = resultSet.getRow();
		        			resultSet.beforeFirst();
		        			
		        			if(rowCount > 0)
		        			{
		        				this.setPurchaseInvoiceInformationDAO(new PurchaseInvoiceInformationDAO());
		        				
		        				while(resultSet.next())
		        				{
		        					this.getPurchaseInvoiceInformationDAO().setPurchaseId(this.getPurchaseNumber());
		        					this.getPurchaseInvoiceInformationDAO().setInvoiceNumber(resultSet.getString(1));
		        					this.getPurchaseInvoiceInformationDAO().setPurchaseDate(resultSet.getString(2));
		        					this.getPurchaseInvoiceInformationDAO().setSupplierId(resultSet.getString(4));
		        					this.getPurchaseInvoiceInformationDAO().setSupplierName(resultSet.getString(5));
		        					this.getPurchaseInvoiceInformationDAO().setFrightCharges(resultSet.getFloat(6));
		        					this.getPurchaseInvoiceInformationDAO().setComments(resultSet.getString(7));
		        					this.getPurchaseInvoiceInformationDAO().setOtherExpense(resultSet.getFloat(8));
		        					this.getPurchaseInvoiceInformationDAO().setPurchaseTotalAmount(resultSet.getFloat(9));
		        					this.getPurchaseInvoiceInformationDAO().setPurchaseAmountPaid(resultSet.getFloat(10));
		        					this.getPurchaseInvoiceInformationDAO().setTotalCGST(resultSet.getFloat(11));
		        					this.getPurchaseInvoiceInformationDAO().setTotalSGST(resultSet.getFloat(12));
		        					this.getPurchaseInvoiceInformationDAO().setTotalIGST(resultSet.getFloat(13));
		        					this.getPurchaseInvoiceInformationDAO().setTotalNettAmount(resultSet.getFloat(14));
		        					this.getPurchaseInvoiceInformationDAO().setPaymentType(resultSet.getString(15));
		        					this.getPurchaseInvoiceInformationDAO().setPurchaseBy(resultSet.getString(16));
		        					
		        					if(resultSet.getBlob(17) != null)
		        					{
		        						this.setInvoiceBillAvailable(true);
		        					}
		        					
		        						
		        					this.getPurchaseInvoiceInformationDAO().setPurchaseSaved(true);
		        					this.getPurchaseInvoiceInformationDAO().setViewPurchaseInvoice(true);
		        					PreparedStatement getProductInfoPSMT = null;
		        					ResultSet getProductInfoRS = null;
		        					
		        					String getPurchaseProductListSQL = "SELECT "
		        							+ "product_id,"
		        							+ "product_name,"
											+ "purchase_unit,"
											+ "tax_percentage,"
											+ "discount_percentage,"
											+ "purchase_quantity,"
											+ "purchase_total_amount_after_discount,"
											+ "purchase_gross_amount,"
											+ "purchase_igst_amount,"
											+ "purchase_cgst_amount,"
											+ "purchase_sgst_amount,"
											+ "rate_type,"
											+ "purchase_gross_amount "
											+ "FROM "
											+ "crusher_purchase_product_info_master "
											+ "WHERE "
											+ "purchase_id = ? "
											+ "AND "
				    						+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ?";
		        					
		        					getProductInfoPSMT = connection.prepareStatement(getPurchaseProductListSQL);
		        					
		        					getProductInfoPSMT.setString(1, this.getPurchaseNumber());
		        					getProductInfoPSMT.setString(2, crusherId);
		        					getProductInfoPSMT.setString(3, crusherCode);
		            				
		        					//System.out.println(getProductInfoPSMT.toString());
		        					
		        					getProductInfoRS = getProductInfoPSMT.executeQuery();
		        					
		        					while(getProductInfoRS.next())
		        					{
		        						PurchaseProductInfoDAO productInfoDAO = new PurchaseProductInfoDAO();
		        						
		        						productInfoDAO.setProductId(getProductInfoRS.getString(1));
		        						productInfoDAO.setProductName(getProductInfoRS.getString(2));
		        						productInfoDAO.setPurchaseUnit(getProductInfoRS.getString(3));
		        						productInfoDAO.setTaxPercentage(getProductInfoRS.getFloat(4));
		        						productInfoDAO.setPurchaseRate(getProductInfoRS.getFloat(5));
		        						productInfoDAO.setQuantity(getProductInfoRS.getFloat(6));
		        						productInfoDAO.setAmount(getProductInfoRS.getFloat(7));
		        						productInfoDAO.setNettAmount(getProductInfoRS.getFloat(8));
		        						productInfoDAO.setIgst(getProductInfoRS.getFloat(9));
		        						productInfoDAO.setCgst(getProductInfoRS.getFloat(10));
		        						productInfoDAO.setSgst(getProductInfoRS.getFloat(11));
		        						productInfoDAO.setRateType(getProductInfoRS.getString(12));
		        						
		        						this.setRateTyprDefaultValue(getProductInfoRS.getString(12));
		        						productInfoDAO.setGrossAmount(getProductInfoRS.getFloat(13));
		        						
		        						this.getPurchaseProductInfoList().add(productInfoDAO);
		        					}
		        					
		        					
		        					
		        					if(getProductInfoRS != null)
		        					{
		        						getProductInfoRS.close();
		        						getProductInfoRS = null;
		        					}
		        					
		        					if(getProductInfoPSMT != null)
		        					{
		        						getProductInfoPSMT.close();
		        						getProductInfoPSMT = null;
		        						
		        					}
		        					
		        					
		        					
		        					
		        				}
		        				
		        				 float floatTotalPurchaseAmount = 0.0F;
		        		       	 float floatTotalCGST = 0.0F;
		        		       	 float floatTotalSGST = 0.0F;
		        		       	 float floatTotalIGST = 0.0F;
		        		       	 float floatTotalNettAmount = 0.0F;
		        		       	 
		        		       	 for (PurchaseProductInfoDAO pProductInfoDAO : purchaseProductInfoList)
		        		       	 {
		        		       		 this.setTotalQuantity(pProductInfoDAO.getQuantity()+this.getTotalQuantity());
		       	        		     floatTotalPurchaseAmount = floatTotalPurchaseAmount + pProductInfoDAO.getAmount();
		        		       		 floatTotalCGST = floatTotalCGST + pProductInfoDAO.getCgst();
		        		       		 floatTotalSGST = floatTotalSGST + pProductInfoDAO.getSgst();
		        		       		 floatTotalIGST = floatTotalIGST + pProductInfoDAO.getIgst();
		        		       		 floatTotalNettAmount = floatTotalNettAmount + pProductInfoDAO.getNettAmount();
		        		       	 }
		        		       	 //System.out.println(floatTotalNettAmount);
		        		       	 
		        		       	 this.setDf(new DecimalFormat("##.##"));
		        		       	 
		        		       	this.setTotalPurchaseAmount(floatTotalPurchaseAmount);
		        		       	this.setTotalNettAmount(floatTotalNettAmount);
		        		       	this.setTotalCGST(floatTotalCGST);
		        		       	this.setTotalSGST(floatTotalSGST);
		        		       	this.setTotalIGST(floatTotalIGST);
		        		   		this.setPaymentDefaultValue(purchaseInvoiceInformationDAO.getPaymentType());
		        		   		this.setPurchaseBy(purchaseInvoiceInformationDAO.getPurchaseBy());
		        		       	this.setPurchaseId(purchaseInvoiceInformationDAO.getPurchaseId());
		        		       	this.setSupplierName(purchaseInvoiceInformationDAO.getSupplierId()+"-"+purchaseInvoiceInformationDAO.getSupplierName());
		        		       	this.setInvoiceNumber(purchaseInvoiceInformationDAO.getInvoiceNumber());
		        		       	this.setPurchaseDateTime(purchaseInvoiceInformationDAO.getPurchaseDate());
		        		       	this.setAddToStock(purchaseInvoiceInformationDAO.isAddToStock());
		        		       	this.getSession().setAttribute("purchaseInformation", purchaseInvoiceInformationDAO);
		        		       	this.getSession().setAttribute("purchaseProductList", purchaseProductInfoList);
		        				this.setAddSideBarJs("FALSE");
		        				result = "success";
		        			}
		        			else
		        			{
		        				result = "error";
		        				addActionError(this.getText("message.error.recordsNotFound"));
		        			}
	        		
	        		
	        		}
	        		catch(SQLException sqe)
	        		{
	        			//sqe.printStackTrace();
	        			result = "error";	
						addActionError(sqe.getErrorCode()+" || "+sqe.getMessage() +" || "+this.getText("message.error.purchaseDetailsCannotBeLoaded"));
				
	        		}catch (Exception e) {
	        			//e.printStackTrace();
	        			result = "error";						
						addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.purchaseDetailsCannotBeLoaded"));
					
					}finally 
					{
						if(resultSet != null)
		   				{
		   					try {resultSet.close(); resultSet = null;}catch(SQLException sqe){}   					
		   				}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						if(connection != null)
						{
							
							try {connection.close(); connection = null;}catch (SQLException e) {}
						}
						
					}
	        		
	        		
	        	}
	        	else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.urlTemperedDetailsNotFound"));
	        	}
	        	
	        	
	        }
	        return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getPurchaseNumber() {
		return purchaseNumber;
	}

	public void setPurchaseNumber(String purchaseNumber) {
		this.purchaseNumber = purchaseNumber;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public PurchaseInvoiceInformationDAO getPurchaseInvoiceInformationDAO() {
		return purchaseInvoiceInformationDAO;
	}

	public void setPurchaseInvoiceInformationDAO(PurchaseInvoiceInformationDAO purchaseInvoiceInformationDAO) {
		this.purchaseInvoiceInformationDAO = purchaseInvoiceInformationDAO;
	}

	public List<PurchaseProductInfoDAO> getPurchaseProductInfoList() {
		return purchaseProductInfoList;
	}

	public void setPurchaseProductInfoList(List<PurchaseProductInfoDAO> purchaseProductInfoList) {
		this.purchaseProductInfoList = purchaseProductInfoList;
	}

	
	public Float getTotalPurchaseAmount() {
		return totalPurchaseAmount;
	}

	public void setTotalPurchaseAmount(Float totalPurchaseAmount) {
		this.totalPurchaseAmount = totalPurchaseAmount;
	}

	public File getInvoiceImage() {
		return invoiceImage;
	}

	public void setInvoiceImage(File invoiceImage) {
		this.invoiceImage = invoiceImage;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public DecimalFormat getDf() {
		return df;
	}

	public void setDf(DecimalFormat df) {
		this.df = df;
	}


	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	

	public Float getAmountPaid() {
		return amountPaid;
	}

	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}

	public Float getFrightCharges() {
		return frightCharges;
	}

	public void setFrightCharges(Float frightCharges) {
		this.frightCharges = frightCharges;
	}

	public Float getOtherExpense() {
		return otherExpense;
	}

	public void setOtherExpense(Float otherExpense) {
		this.otherExpense = otherExpense;
	}

	public Float getTotalNettAmount() {
		return totalNettAmount;
	}

	public void setTotalNettAmount(Float totalNettAmount) {
		this.totalNettAmount = totalNettAmount;
	}

	public Float getTotalCGST() {
		return totalCGST;
	}

	public void setTotalCGST(Float totalCGST) {
		this.totalCGST = totalCGST;
	}

	public Float getTotalSGST() {
		return totalSGST;
	}

	public void setTotalSGST(Float totalSGST) {
		this.totalSGST = totalSGST;
	}

	public Float getTotalIGST() {
		return totalIGST;
	}

	public void setTotalIGST(Float totalIGST) {
		this.totalIGST = totalIGST;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public Float getQuantity() {
		return quantity;
	}

	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}

	public Float getPurchaseUnit() {
		return purchaseUnit;
	}

	public void setPurchaseUnit(Float purchaseUnit) {
		this.purchaseUnit = purchaseUnit;
	}

	public Float getPurchaseRate() {
		return purchaseRate;
	}

	public void setPurchaseRate(Float purchaseRate) {
		this.purchaseRate = purchaseRate;
	}

	public String getTaxId() {
		return taxId;
	}

	public void setTaxId(String taxId) {
		this.taxId = taxId;
	}

	public String getPurchaseId() {
		return purchaseId;
	}

	public void setPurchaseId(String purchaseId) {
		this.purchaseId = purchaseId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getInvoiceNumber() {
		return invoiceNumber;
	}

	public void setInvoiceNumber(String invoiceNumber) {
		this.invoiceNumber = invoiceNumber;
	}

	public String getInvoiceImageContentType() {
		return invoiceImageContentType;
	}

	public void setInvoiceImageContentType(String invoiceImageContentType) {
		this.invoiceImageContentType = invoiceImageContentType;
	}

	public boolean isAddToStock() {
		return addToStock;
	}

	public void setAddToStock(boolean addToStock) {
		this.addToStock = addToStock;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public String getPurchaseDateTime() {
		return purchaseDateTime;
	}

	public void setPurchaseDateTime(String purchaseDateTime) {
		this.purchaseDateTime = purchaseDateTime;
	}

	public String getPaymentDefaultValue() {
		return paymentDefaultValue;
	}

	public void setPaymentDefaultValue(String paymentDefaultValue) {
		this.paymentDefaultValue = paymentDefaultValue;
	}

	public String getPurchaseBy() {
		return purchaseBy;
	}

	public void setPurchaseBy(String purchaseBy) {
		this.purchaseBy = purchaseBy;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	

	public boolean isInvoiceBillAvailable() {
		return invoiceBillAvailable;
	}

	public void setInvoiceBillAvailable(boolean invoiceBillAvailable) {
		this.invoiceBillAvailable = invoiceBillAvailable;
	}

	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}

	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}

	public String getRateType() {
		return rateType;
	}

	public void setRateType(String rateType) {
		this.rateType = rateType;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0; 
	}

	public Float getTotalQuantity() {
		return totalQuantity;
	}

	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}

	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}

	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}
	

	
	
}
