package com.stonecrusher.jspRedirect;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.DAO.ChallanInfoDAO;
import com.stonecrusher.DAO.ChallanProductInfoDAO;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.opensymphony.xwork2.ActionSupport;

public class ViewOnlyDC extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -4014599345339676180L;

	private SessionMap<String,Object> sessionMap;  
	
	private String challanNumber;
	private String challanDateTime;
	private String paymentType;
	private String customerName;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private Float quantity;
	private String comments;
	private String alternateMobileNumber;
	private String productNameForDelete;
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private ArrayList<ChallanProductInfoDAO> challanProductInfoList = new ArrayList<ChallanProductInfoDAO> ();
	private String defaultValue;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private BillVehicleInfoDAO billVehicleInfoDAO = new BillVehicleInfoDAO();
	
	private String removeVaules="false";
	
	private ChallanInfoDAO challanInfoDAO = new ChallanInfoDAO();
	
	private boolean viewChallan;
	private boolean updateWeightScale;
	
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	
	private boolean challanSaved;
	private boolean sendSMS;
	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private String addSideBarJs;
	
	private Float transportCharges;
	private String keyVehicle;
	
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
				String crusherCode = (String) this.getSessionMap().get("crusherCode");

				
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	       	
	        	this.setAddSideBarJs("FALSE");
	      
	        	unitList = GetListResource.GetUnitList();
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				this.setBillVehicleInfoDAO(new BillVehicleInfoDAO());
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "DATE_FORMAT(challan_date,'%d-%m-%Y'),"
							+ "payment_type,"
							+ "customer_all_details,"
							+ "customer_id,"
							+ "customer_name,"
							+ "vehicle_all_details,"
							+ "vehicle_id,"
							+ "veihcle_reg_number,"
							+ "vehicle_start_km,"
							+ "vehicle_end_km,"
							+ "vehicle_total_km,"
							+ "trip_start_location,"
							+ "trip_end_location,"
							+ "total_trip_count,"
							+ "comments "
							+ "FROM "
							+ "crusher_delivery_challan_master "
							+ "WHERE "
							+ "challan_number = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement =connection.prepareStatement(sql);
					preparedStatement.setString(1, this.getChallanNumber());
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{


		            	this.setChallanDateTime(resultSet.getString(1));
		            	this.setPaymentType(resultSet.getString(2));
						this.setCustomerName(resultSet.getString(3));
		            	this.setVehicleId(resultSet.getString(6));
		            	this.setKmStart(resultSet.getFloat(9));
		            	this.setKmEnd(resultSet.getFloat(10));
		            	this.setTotalKm(resultSet.getFloat(11));
		            	this.setTripFrom(resultSet.getString(12));
		            	this.setTripTo(resultSet.getString(13));
		            	this.setTotalTrips(resultSet.getInt(14));
		            	this.setComments(resultSet.getString(15));
		            	this.setChallanSaved(true);
		            	
		            	
		            	this.getChallanInfoDAO().setChallanDate(resultSet.getString(1));
		            	this.getChallanInfoDAO().setPaymentType(resultSet.getString(2));
		            	this.getChallanInfoDAO().setCustomerAllDetails(resultSet.getString(3));
		            	this.getChallanInfoDAO().setCustomerId(resultSet.getString(4));
		            	this.getChallanInfoDAO().setCustomerName(resultSet.getString(5));
		            	this.getChallanInfoDAO().setVehicleAllDetails(resultSet.getString(6));
		            	this.getChallanInfoDAO().setVehicleId(resultSet.getString(7));
		            	this.getChallanInfoDAO().setVehicleRegNumber(resultSet.getString(8));
		            	this.getChallanInfoDAO().setKmStart(resultSet.getFloat(9));
		            	this.getChallanInfoDAO().setKmEnd(resultSet.getFloat(10));
		            	this.getChallanInfoDAO().setTotalKm(resultSet.getFloat(11));
		            	this.getChallanInfoDAO().setTripFrom(resultSet.getString(12));
		            	this.getChallanInfoDAO().setTripTo(resultSet.getString(13));
		            	this.getChallanInfoDAO().setTotalTripCount(resultSet.getInt(14));
		            	this.getChallanInfoDAO().setComments(resultSet.getString(15));
		            	this.getChallanInfoDAO().setChallanSaved(true);
		            	this.getChallanInfoDAO().setChallanNumber(this.getChallanNumber());
		            	if(resultSet != null)
		            	{
		            		resultSet.close();
		            		resultSet = null;
		            	}
		            	
		            	if(preparedStatement != null)
		            	{
		            		preparedStatement.close();
		            		preparedStatement = null;
		            	}
		              
		        		sql = "SELECT "
		        				+ "product_id,"
		        				+ "product_name_eng,"
		        				+ "sale_unit,"
		        				+ "quantity,"
		        				+ "empty_weight,"
		        				+ "gross_weight "
		        				+ "FROM "
		        				+ "challan_product_details "
		        				+ "WHERE "
		        				+ "challan_number = ? "
		        				+ "AND "
		        				+ "crusher_id = ? "
		        				+ "AND "
		        				+ "crusher_code = ?";
		        		
		        		preparedStatement = connection.prepareStatement(sql);
		        		preparedStatement.setString(1, this.getChallanNumber());
		        		preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		
		        		
		        		resultSet = preparedStatement.executeQuery();
		        		
		        		while(resultSet.next())
		        		{
		        			ChallanProductInfoDAO dao = new ChallanProductInfoDAO();
		        			dao.setProductId(resultSet.getString(1));
		        			dao.setProductName(resultSet.getString(2));
		        			dao.setSalesUnit(resultSet.getString(3));
		        			dao.setQuantity(resultSet.getFloat(4));
		        			dao.setVehicleEmptyWeight(resultSet.getFloat(5));
		        			dao.setGrossWeight(resultSet.getFloat(6));
		        			
		        			
		        			
		        			
		        			this.getChallanProductInfoList().add(dao);
		        			
		        		}
		        		
		        		
		        		
		        		if(resultSet != null)
						{
							try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
						}
						if(preparedStatement != null)
						{
							try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
						}
						
						
	        			
	        			sql = "SELECT "
		        				+ "entry_id,"
		        				+ "empty_weight,"
		        				+ "gross_weight "
		        				+ "FROM "
		        				+ "crusher_vehicle_entry_details "
		        				+ "WHERE "
		        				+ "delivery_chalan_no = ? "
		        				+ "AND "
		        				+ "crusher_id = ? "
		        				+ "AND "
		        				+ "crusher_code = ?";
		        		
		        		preparedStatement = connection.prepareStatement(sql);
		        		preparedStatement.setString(1, this.getChallanNumber());
		        		preparedStatement.setString(2, crusherId);
		        		preparedStatement.setString(3, crusherCode);
		        		
		        		
		        		resultSet = preparedStatement.executeQuery();
		        		for(ChallanProductInfoDAO infoDAO : this.getChallanProductInfoList())
			        	{
		        		while(resultSet.next())
		        		{
		        			infoDAO.setVehicleEmptyWeight(resultSet.getFloat(2));
		        			
		        			this.setKeyVehicle(EncryptionDecryption.encrypt(resultSet.getString(1)));
		        		}
			        		
		        		if (infoDAO.getVehicleEmptyWeight() > 0) {
			        		
   			        		viewChallan = true;
   			        		updateWeightScale = true;
   			        	}
   			        	
			        	}
		        		
		        		

			    		this.getSessionMap().put("challanInformation", this.getChallanInfoDAO());
			    		this.getSessionMap().put("challanProductList", this.getChallanProductInfoList());
			       
		        		result = SUCCESS;
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.chalanDetailsNotFoundPlzTryAgain"));
					}
				}
				catch (SQLException e) {
					e.printStackTrace();
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				catch (Exception e) {
					e.printStackTrace();
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	
	
	public ArrayList<ChallanProductInfoDAO> getChallanProductInfoList() {
		return challanProductInfoList;
	}




	public void setChallanProductInfoList(ArrayList<ChallanProductInfoDAO> challanProductInfoList) {
		this.challanProductInfoList = challanProductInfoList;
	}




	public String getChallanNumber() {
		return challanNumber;
	}




	public void setChallanNumber(String challanNumber) {
		this.challanNumber = challanNumber;
	}




	public String getChallanDateTime() {
		return challanDateTime;
	}




	public void setChallanDateTime(String challanDateTime) {
		this.challanDateTime = challanDateTime;
	}




	public String getPaymentType() {
		return paymentType;
	}




	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}




	public String getCustomerName() {
		return customerName;
	}




	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}




	public String getProductName() {
		return productName;
	}




	public void setProductName(String productName) {
		this.productName = productName;
	}




	public String getProductMarathiName() {
		return productMarathiName;
	}




	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}




	public String getAlias() {
		return alias;
	}




	public void setAlias(String alias) {
		this.alias = alias;
	}




	public String getSalesUnit() {
		return salesUnit;
	}




	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}




	public Float getQuantity() {
		return quantity;
	}




	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}




	public String getComments() {
		return comments;
	}




	public void setComments(String comments) {
		this.comments = comments;
	}




	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}




	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}




	public String getProductNameForDelete() {
		return productNameForDelete;
	}




	public void setProductNameForDelete(String productNameForDelete) {
		this.productNameForDelete = productNameForDelete;
	}




	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}




	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}






	public String getDefaultValue() {
		return defaultValue;
	}




	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}




	public Map<String, String> getVehicleList() {
		return vehicleList;
	}




	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}




	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}




	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}




	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}




	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}




	public String getRemoveVaules() {
		return removeVaules;
	}




	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}




	public ChallanInfoDAO getChallanInfoDAO() {
		return challanInfoDAO;
	}




	public void setChallanInfoDAO(ChallanInfoDAO challanInfoDAO) {
		this.challanInfoDAO = challanInfoDAO;
	}





	public boolean isViewChallan() {
		return viewChallan;
	}




	public void setViewChallan(boolean viewChallan) {
		this.viewChallan = viewChallan;
	}




	public Map<String, String> getUnitList() {
		return unitList;
	}




	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}




	public boolean isChallanSaved() {
		return challanSaved;
	}




	public void setChallanSaved(boolean challanSaved) {
		this.challanSaved = challanSaved;
	}




	public boolean isSendSMS() {
		return sendSMS;
	}




	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}




	public String getTripDate() {
		return tripDate;
	}




	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}




	public String getVehicleId() {
		return vehicleId;
	}




	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}




	public String getMaterialName() {
		return materialName;
	}




	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}




	public Float getMaterialVolume() {
		return materialVolume;
	}




	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}




	public Float getKmStart() {
		return kmStart;
	}




	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}




	public Float getKmEnd() {
		return kmEnd;
	}




	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}




	public Float getTotalKm() {
		return totalKm;
	}




	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}




	public String getTripFrom() {
		return tripFrom;
	}




	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}




	public String getTripTo() {
		return tripTo;
	}




	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}




	public Integer getTotalTrips() {
		return totalTrips;
	}




	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}




	public String getAddSideBarJs() {
		return addSideBarJs;
	}




	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}




	public Float getTransportCharges() {
		return transportCharges;
	}




	public void setTransportCharges(Float transportCharges) {
		this.transportCharges = transportCharges;
	}




	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}







	public String getKeyVehicle() {
		return keyVehicle;
	}




	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}




	public boolean isUpdateWeightScale() {
		return updateWeightScale;
	}




	public void setUpdateWeightScale(boolean updateWeightScale) {
		this.updateWeightScale = updateWeightScale;
	}
	

}



