package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class ViewBillJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7713193858695407144L;
	private String chalanNumber;
	private HttpSession session;
	private String billDateTime;
	private String operator;
	private String paymentType;
	private String customerName;
	private String billType;
	
	private Float transportCharge;
	private String comments;
	
	
	private String billNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private List<BillProductInfoDAO> productInfoList = new ArrayList<BillProductInfoDAO>();
	private String defaultValue;
	
	
	private String totalCGST;
	private String totalSGST;
	private String totalAmount;
	private String totalDiscount;
	private String totalAmouAfterDisount;
	private Float amountPaid;
	private String returnAmount;
	private boolean billSaved;
	private String removeVaules="false";
	
	private BillInformationDAO billInfoDAO = null;
	
	private SessionMap<String,Object> sessionMap;
	
	private boolean isFromVehicleEntryDetails;
	
	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private String royalty;
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	
	
	private Map<String,String> vehicleList = new HashMap<String,String>();
	
	private BillVehicleInfoDAO billVehicleInfoDAO = new BillVehicleInfoDAO();

	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList2 = new ArrayList<String>();
	
	private String keyVehicle;
	
	private boolean viewBill;
	private boolean generateBillForDc;
	
     private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();

	
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{
	        	try
	        	{
	    			taxList = GetListResource.GetTaxList();
	    			
	    		} catch (IOException e) {
	    			
	    		}
	        	
	        	unitList = GetListResource.GetUnitList();
	        	billTypeList = GetListResource.GetBillTypeList();
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	if(productInfoList == null)
	        	{
	        		productInfoList = new ArrayList<BillProductInfoDAO>();
	        	}
	        	
	        	if(billInfoDAO==null)
	        	{
	        		billInfoDAO = new BillInformationDAO();        		      		
	        		
	        	}
	        	
	        	this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        
	        	
	        	this.setRateTyprDefaultValue("INCLUDINGGST");
	        	
	        	this.setAccountList(GetAccountListForDrCr.getAccountList((this.getSessionMap()))); 
	        	this.setPaymentTypeList2(GetTypeOfPaymentList.getPaymentTypeList());
	        	
	        	
	        	  discountTypeList.put("", "Select Discount Type");
			      discountTypeList.put("By Quantity", "By Quantity");
			      discountTypeList.put("By Percentage", "By Percentage");
			      discountTypeList.put("By Direct Amount", "By Direct Amount");
				
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
					String tableInfoInfo;
		     		
					if(this.getBillType().equals("TAX-INVOICE"))
		 			{
						tableInfoInfo = "crusher_bill_info_master ";
		 			}else {
		 				tableInfoInfo = "crusher_bill_info_master ";
		 			}
					
					
	       			sql = "SELECT "
	       					+ "DATE_FORMAT(bill_date, '%d-%m-%Y'),"
	       					+ "payment_type,"
	       					+ "bill_type,"
	       					+ "customer_name,"
	       					+ "transportation_charges,"
	       					+ "comments, "
	       					+ "chalan_number,"
	       					+ "bill_amount_received,"
	       					+ "bill_amount_return,"
	       					+ "discount_type "
	       					+ "FROM "
	       					+ tableInfoInfo
	       					+ "WHERE "
	       					+ "bill_number = ? "
	       					+ "AND "
	       					+ "bill_type = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, this.getBillNumber());
	       			preparedStatement.setString(2, this.getBillType());
	       			preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			
	       			if(rowCount>0)
	       			{
	       				result = "success";
	       				if(resultSet.next())
	       				{
	       					this.setBillDateTime(resultSet.getString(1));
	       					this.setPaymentType(resultSet.getString(2));
	       					this.setDefaultValue(resultSet.getString(2));
	       					
	       					this.setBillType(resultSet.getString(3));
	       					
	       					this.setCustomerName(resultSet.getString(4));
	       					this.setTransportCharge(resultSet.getFloat(5));
	       					this.setComments(resultSet.getString(6));
	       					this.setChalanNumber(resultSet.getString(7));
	       					this.setAmountPaid(resultSet.getFloat(8));
	       					this.setReturnAmount(resultSet.getString(9));
	       					this.setDiscountType(resultSet.getString(10));
	       					
	       					billInfoDAO.setBillDate(resultSet.getString(1));
	       					billInfoDAO.setTransportCharge(resultSet.getFloat(5));
	       					billInfoDAO.setComments(resultSet.getString(6));
	       					billInfoDAO.setBillNumber(getBillNumber());	        	
	       	        		billInfoDAO.setPaymentType(getPaymentType());
	       	        		billInfoDAO.setBillType(getBillType());
	       	        		billInfoDAO.setCustomerName(getCustomerName());        		
	       		        	billInfoDAO.setBillSaved(true);
	       		        	this.setBillSaved(true);
	       		        	billInfoDAO.setBillInformationInserted(true);
	       		        	billInfoDAO.setChalanNumber(resultSet.getString(7));
	       		        	billInfoDAO.setDiscountType(resultSet.getString(10));
	       		        	
	       		        	if(resultSet != null)
	       		        	{
	       		        		resultSet.close();
	       		        		resultSet = null;
	       		        	}
	       					if(preparedStatement != null)
	       					{
	       						preparedStatement.close();
	       						preparedStatement = null;
	       					}
	       					
	       					
	       					String tableProductInfo;
	    		     		
	    					if(this.getBillType().equals("TAX-INVOICE"))
	    		 			{
	    						tableProductInfo = "crusher_bill_product_info ";
	    		 			}else {
	    		 				tableProductInfo = "crusher_bill_product_info ";
	    		 			}
	    					
	    					
	       					sql = "SELECT "
	       							+ "product_id,"
	       							+ "product_name,"
	       							+ "sales_unit,"
	       							+ "tax_percentage,"
	       							+ "sales_rate,"
	       							+ "sale_quantity,"
	       							+ "discount_percentage,"
	       							+ "total_discount_amount,"
	       							+ "product_sale_amount_before_discount,"
	       							+ "product_sale_amount_after_discount,"
	       							+ "product_gross_amount,"
	       							+ "product_igst,"
	       							+ "product_cgst_amount,"
	       							+ "product_sgst_amount,"
	       							+ "product_name_marathi,"
	       							+ "royalty,"
	       							+ "sale_vehicle_empty_weight,"
	       							+ "sale_vehicle_gross_weight,"
	       							+ "transport_charge "
	       							+ "FROM "
	       							+ tableProductInfo
	       							+ "WHERE "
	       							+ "bill_number = ? "
	       							+ "AND "
	       							+ "bill_type = ? "
	       							+ "AND "
	        						+ "crusher_id = ? "
	    							+ "AND "
	    							+ "crusher_code = ?";
	       					
	       					
	       					
	       					preparedStatement = connection.prepareStatement(sql);
	       					preparedStatement.setString(1, this.getBillNumber());	
	       					preparedStatement.setString(2, this.getBillType());
	       					preparedStatement.setString(3, crusherId);
	        				preparedStatement.setString(4, crusherCode);
	        				
	       					
	       					resultSet = preparedStatement.executeQuery();
	       					
	       					float totalCGSTAmt = 0.0F;
	       					float totalSGSTAmt = 0.0F;
	       					
	       					while(resultSet.next())
	       					{
	       						BillProductInfoDAO  billProductInfoDAO = new BillProductInfoDAO();
	       						
	       						billProductInfoDAO.setProductId(resultSet.getString(1));
	       						billProductInfoDAO.setProductName(resultSet.getString(2));
	       						billProductInfoDAO.setSalesUnit(resultSet.getString(3));
	       						billProductInfoDAO.setTaxId(resultSet.getString(4));
	       						billProductInfoDAO.setSalesRate(resultSet.getFloat(5));
	       						billProductInfoDAO.setQuantity(resultSet.getFloat(6));
	       						billProductInfoDAO.setDiscountPecentage(resultSet.getFloat(7));
	       						billProductInfoDAO.setDiscountRupees(resultSet.getFloat(8));
	       						billProductInfoDAO.setAmount(resultSet.getFloat(9));
	       						billProductInfoDAO.setAmountAfterDiscount(resultSet.getFloat(10));
	       						billProductInfoDAO.setGrossAmount(resultSet.getFloat(11));
	       						billProductInfoDAO.setIgst(resultSet.getFloat(12));
	       						billProductInfoDAO.setCgst(resultSet.getFloat(13));
	       						billProductInfoDAO.setSgst(resultSet.getFloat(14));
	       						billProductInfoDAO.setProductNameMarathi(resultSet.getString(15));
	       						billProductInfoDAO.setRoyalty(resultSet.getFloat(16));
	       						billProductInfoDAO.setVehicleEmptyWeight(resultSet.getFloat(17));
	       						billProductInfoDAO.setGrossWeight(resultSet.getFloat(18));
	    	        			billProductInfoDAO.setTransportCharges(resultSet.getFloat(19));
	       						
	       						String taxDetails = GetListResource.getTaxDetailsByTaxId(resultSet.getString(3));
	       						String taxPercentage = "";
	       						try
	       						{
	       							taxPercentage = taxDetails.split(":")[1];
	       						}
	       						catch(Exception e)
	       						{
	       							taxPercentage = "0";
	       						}
	       						billProductInfoDAO.setTaxPercentage(taxPercentage);
	       						
	       			        	/*float totalProductDiscount = resultSet.getFloat(8) - resultSet.getFloat(9);
	       						
	       			        	System.out.println("total_discount_amount : "+resultSet.getString(8));
	       			        	System.out.println("product_sale_amount_before_discount : "+resultSet.getString(9));
	       			        	System.out.println("totalProductDiscount : "+totalProductDiscount);*/
	       			        	
	       			        	billProductInfoDAO.setProductTotalDiscount(resultSet.getFloat(8));
	       			        	
	       			        	totalCGSTAmt = totalCGSTAmt + resultSet.getFloat(13);
	       			        	totalSGSTAmt = totalSGSTAmt + resultSet.getFloat(14);
	       						
	       			        	
	       			        	
	       			        	
	       			        	
	       			        	this.getProductInfoList().add(billProductInfoDAO);
	       						
	       						
	       						
	       						
	       					}
	       					
	       					this.setTotalCGST(""+totalCGSTAmt);
	       					this.setTotalSGST(""+totalSGSTAmt);
	       				}
	       				
	       				
	       				
	       				
	       				
	       				
	       				
	       			}
	       			
	       			
	       		
	       			
	       			String tableTripInfo;
		     		
					if(this.getBillType().equals("TAX-INVOICE"))
		 			{
						tableTripInfo = "crusher_vehicle_trip_master ";
		 			}else {
		 				tableTripInfo = "crusher_vehicle_trip_master ";
		 			}
					
					
	       			sql = "SELECT "
	       					+ "vehicle_id,"
	       					+ "product_id,"
	       					+ "product_name,"
	       					+ "product_quantity,"
	       					+ "vehicle_km_start,"
	       					+ "vehicle_km_end,"
	       					+ "trip_total_km,"
	       					+ "trip_start_from,"
	       					+ "trip_end_to,"
	       					+ "total_trip_count,"
	       					+ "product_empty_weight,"
	       					+ "product_gross_weight "
	       					+ "FROM "
	       					+ tableTripInfo
	       					+ "WHERE "
	       					+ "bill_number = ? "
			       			+ "AND "
							+ "bill_type = ? "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, billInfoDAO.getBillNumber());
	       			preparedStatement.setString(2, billInfoDAO.getBillType());
	       			preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			if(resultSet.next())
	       			{
	       				
	       				HashMap<String,String> vehicleDetailsMap =  GetVehicleDetailsById.getVehicleDetailsById(resultSet.getString(1), this.getSessionMap(), connection);
	       				this.setVehicleId(resultSet.getString(1)+"-"+vehicleDetailsMap.get("VEHICLEMAKE")+"-"+vehicleDetailsMap.get("REGISTRATIONNUMBER"));
	       				this.setKmStart(resultSet.getFloat(5));
	       				this.setKmEnd(resultSet.getFloat(6));
	       				this.setTotalKm(resultSet.getFloat(7));
	       				this.setTripFrom(resultSet.getString(8));
	       				this.setTripTo(resultSet.getString(9));
	       				this.setTotalTrips(resultSet.getInt(10));
	       				
	       				this.getBillVehicleInfoDAO().setVehicleId(resultSet.getString(1));
	       				
		        		this.getBillVehicleInfoDAO().setProductId(resultSet.getString(2));
		        		this.getBillVehicleInfoDAO().setProductName(resultSet.getString(3));
		        		this.getBillVehicleInfoDAO().setProductQuantity(resultSet.getFloat(4));
		        		
	       				this.getBillVehicleInfoDAO().setKmStart(this.getKmStart());
		        		this.getBillVehicleInfoDAO().setKmEnd(this.getKmEnd());
		        		this.getBillVehicleInfoDAO().setTripFrom(this.getTripFrom());
		        		this.getBillVehicleInfoDAO().setTripTo(this.getTripTo());
		        		this.getBillVehicleInfoDAO().setTotalKM(this.getTotalKm());
		        		this.getBillVehicleInfoDAO().setTotalTrips(this.getTotalTrips());
		        		this.getBillVehicleInfoDAO().setVehicleEmptyWeight(resultSet.getFloat(11));
                        this.getBillVehicleInfoDAO().setGrossWeight(resultSet.getFloat(12));
		        		
	       			}
	       			
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement  = null;
	       			}
	       			
	       			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "crusher_vehicle_details_master "
	    					+ "WHERE "
	    					+ "vehicle_id = ? "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, this.getVehicleId());
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				this.getBillVehicleInfoDAO().setVehicleMake(resultSet.getString(2));
		        		this.getBillVehicleInfoDAO().setVehicleRCNumber(resultSet.getString(3));
		        	
	       			}
	       			
	       	       	this.getSessionMap().put("billvehicleinfo", this.getBillVehicleInfoDAO());
		        	
	       		   
	       	     if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement  = null;
	       			}
	       			
	       			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "crusher_vehicle_details_master "
	    					+ "WHERE "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
    				preparedStatement.setString(2, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();


	    			while(resultSet.next())
	    			{
	    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
	    			}
	    			
	    			
	       			float transportCharge = 0.0F;
	       			try
	       			{
		        	if(!billInfoDAO.getTransportCharge().equals("")){
		        		
		        		try
		        		{
		        			transportCharge = billInfoDAO.getTransportCharge();
		        		}catch(NumberFormatException nfe)
		        		{
		        			addActionError(this.getText("message.error.plzProvideCorrectTransportationAmount"));
		        		}
		        	}
	       			}
	       			catch(Exception e)
	       			{
	       				this.setTransportCharge(0.0f);
	       				transportCharge = 0.0f;
	       			}
	       			
		        	float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        	float floatTotalRoyalty = 0.0F;
		        	
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		floatTotalRoyalty= floatTotalRoyalty + infoDAO.getRoyalty();
		        	}
		        	
		        	
		        	if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
			        	
			        	sql = "SELECT "
			        			+ "entry_id,"
	        				+ "empty_weight,"
	        				+ "gross_weight "
	        				+ "FROM "
	        				+ "crusher_vehicle_entry_details "
	        				+ "WHERE "
	        				+ "bill_no = ? "
	        				+ "AND "
	        				+ "crusher_id = ? "
	        				+ "AND "
	        				+ "crusher_code = ?";
	        		
	        		preparedStatement = connection.prepareStatement(sql);
	        		preparedStatement.setString(1, this.getBillNumber());
	        		preparedStatement.setString(2, crusherId);
	        		preparedStatement.setString(3, crusherCode);
	        		
	        		
	        		resultSet = preparedStatement.executeQuery();
	        		for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
	        		while(resultSet.next())
	        		{
	        			infoDAO.setVehicleEmptyWeight(resultSet.getFloat(2));
	        			this.setKeyVehicle(EncryptionDecryption.encrypt(resultSet.getString(1)));
	        			
	        		}
	        			
	        		if (infoDAO.getVehicleEmptyWeight() > 0) {
	        			 
			        		
			        		viewBill = true;
			        		generateBillForDc = true;
			        		
			        	}
		        	}
		        
		        
		        	if(!hasActionErrors())
		        	{
		        		this.setTotalAmount(""+(floatTotalAmount+this.getTransportCharge()));	        	
		        		this.setTotalDiscount(""+floatTotalDiscount);
		        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getTransportCharge()+floatTotalRoyalty));
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	else
		        	{
		        		this.setTotalAmount(""+(floatTotalAmount+this.getTransportCharge()));	        	
		        		this.setTotalDiscount(""+floatTotalDiscount);
		        		this.setTotalAmouAfterDisount(""+(floatTotalAmtAfterDiscount+this.getTransportCharge()+floatTotalRoyalty));
			        	addActionMessage(this.getText("message.success.productAddedSuccessfullyToList"));
		        	}
		        	
	       			this.getSessionMap().put("billInformation", billInfoDAO);
	       			this.getSessionMap().put("productList", productInfoList);
	       			
	       			
	       			result = SUCCESS;
	       			
	       		} catch (SQLException e) {
	       			result =  ERROR;
	   				e.printStackTrace();
	   				addActionError(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.somethingWentWrong"));
				
				} catch (Exception e) {
					result =  ERROR;
					e.printStackTrace();
					addActionError(e.getMessage()+"|| "+this.getText("message.error.somethingWentWrong"));
				}	
	   			finally
	   			{
	   				if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    						resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	   				if(preparedStatement != null)
	   				{
	   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	   				}
	   				if(connection != null)
	   				{
	   					try {connection.close(); connection = null;} catch (SQLException e) {}
	   				}
	   				
	   			}
	        	
	        }
	       // System.out.println("Size:"+this.getProductInfoList().size());
	        return result;
	}




	public HttpSession getSession() {
		return session;
	}




	public void setSession(HttpSession session) {
		this.session = session;
	}




	public String getBillDateTime() {
		return billDateTime;
	}




	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}




	public String getOperator() {
		return operator;
	}




	public void setOperator(String operator) {
		this.operator = operator;
	}




	public String getPaymentType() {
		return paymentType;
	}




	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}




	public String getCustomerName() {
		return customerName;
	}




	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}


	public Float getTransportCharge() {
		return transportCharge;
	}




	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}




	public String getComments() {
		return comments;
	}




	public void setComments(String comments) {
		this.comments = comments;
	}


	public String getBillNumber() {
		return billNumber;
	}




	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}




	public Map<String, String> getTaxList() {
		return taxList;
	}




	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}




	public Map<String, String> getUnitList() {
		return unitList;
	}




	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}




	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}




	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}




	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}




	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}




	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}




	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}




	public String getDefaultValue() {
		return defaultValue;
	}




	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}




	public String getTotalAmount() {
		return totalAmount;
	}




	public void setTotalAmount(String totalAmount) {
		this.totalAmount = totalAmount;
	}




	public String getTotalDiscount() {
		return totalDiscount;
	}




	public void setTotalDiscount(String totalDiscount) {
		this.totalDiscount = totalDiscount;
	}




	public String getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}




	public void setTotalAmouAfterDisount(String totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}




	public String getRemoveVaules() {
		return removeVaules;
	}




	public void setRemoveVaules(String removeVaules) {
		this.removeVaules = removeVaules;
	}




	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}




	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}




	public String getBillType() {
		return billType;
	}




	public void setBillType(String billType) {
		this.billType = billType;
	}




	



	



	public boolean isFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}




	public void setFromVehicleEntryDetails(boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}




	public String getChalanNumber() {
		return chalanNumber;
	}




	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}




	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public Float getAmountPaid() {
		return amountPaid;
	}




	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}




	public String getReturnAmount() {
		return returnAmount;
	}




	public void setReturnAmount(String returnAmount) {
		this.returnAmount = returnAmount;
	}




	public String getTripDate() {
		return tripDate;
	}




	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}




	public String getVehicleId() {
		return vehicleId;
	}




	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}




	public String getMaterialName() {
		return materialName;
	}




	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}




	public Float getMaterialVolume() {
		return materialVolume;
	}




	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}




	public Float getKmStart() {
		return kmStart;
	}




	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}




	public Float getKmEnd() {
		return kmEnd;
	}




	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}




	public Float getTotalKm() {
		return totalKm;
	}




	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}




	public String getTripFrom() {
		return tripFrom;
	}




	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}




	public String getTripTo() {
		return tripTo;
	}




	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}




	public Integer getTotalTrips() {
		return totalTrips;
	}




	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}




	public Map<String, String> getVehicleList() {
		return vehicleList;
	}




	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}




	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}




	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}




	public String getTotalCGST() {
		return totalCGST;
	}




	public void setTotalCGST(String totalCGST) {
		this.totalCGST = totalCGST;
	}




	public String getTotalSGST() {
		return totalSGST;
	}




	public void setTotalSGST(String totalSGST) {
		this.totalSGST = totalSGST;
	}




	public String getRoyalty() {
		return royalty;
	}




	public void setRoyalty(String royalty) {
		this.royalty = royalty;
	}




	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}




	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}




	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}




	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}




	public String getRateType() {
		return rateType;
	}




	public void setRateType(String rateType) {
		this.rateType = rateType;
	}




	public Map<String, String> getAccountList() {
		return accountList;
	}




	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}




	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}




	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}




	public boolean isBillSaved() {
		return billSaved;
	}




	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}




	







	public String getKeyVehicle() {
		return keyVehicle;
	}




	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}




	public boolean isViewBill() {
		return viewBill;
	}




	public void setViewBill(boolean viewBill) {
		this.viewBill = viewBill;
	}




	public boolean isGenerateBillForDc() {
		return generateBillForDc;
	}




	public void setGenerateBillForDc(boolean generateBillForDc) {
		this.generateBillForDc = generateBillForDc;
	}




	public String getDiscountType() {
		return discountType;
	}




	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}




	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}




	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}








	
	
	
	
}
