package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateVehicleDetailsJsp extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -939499694356300637L;
	private HttpSession session;
	private String key;
	private String vehicleId;
	private String vehicleMake;
	private String vehicleRegistrationNumber;
	private String vehicleOwnerName;
	private String ownerMobileNumber;
	private String vehicleDriverName;
	private String driverMobileNumber;
	private String insuranceCompanyName;
	private String insuranceContactNumber;
	private String insuranceStartDate;
	private String insuranceEndDate;
	private String taxReceiptStartDate;
	private String taxReceiptEndDate;
	private String rtoPassingStartDate;
	private String rtoPassingEndDate;
	private String pucPassingStartDate;
	private String pucPassingEndDate;
	private Float carryingCapacityBrass;
	private SessionMap<String,Object> sessionMap;  
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String addSideBarJs;

	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	    		
	    		
	    		
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
	        	String vehicleId = "";
	        	
	        
	        		vehicleId = EncryptionDecryption.decrypt(this.getKey());
				
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		this.setAddSideBarJs("FALSE");
	       		if(!hasActionErrors())
	       		{
	       		try {
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			sql = "SELECT "
							+ "vehicle_id,"
							+ "vehicle_make,"
							+ "vehicle_registration_number,"
							+ "owner_name,"
							+ "owner_mobile_number,"
							+ "driver_name,"
							+ "driver_mobile_number,"							
							+ "vehicle_insurance_name,"
							+ "vehicle_insurance_company_contact,"
							+ "DATE_FORMAT(insurance_start_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(insurance_end_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(tax_receipt_start_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(tax_receipt_end_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(rto_passing_start_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(rto_passing_end_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(puc_passing_start_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(puc_passing_end_date,'%d-%m-%Y'),"
							+ "brass_quantity "
							+ "FROM "
							+ "crusher_vehicle_details_master "
							+ "WHERE "
							+ "vehicle_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, vehicleId);
	       			preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
	       			
	       			resultSet = preparedStatement.executeQuery();
	       			if(resultSet.next())
	       			{
	       				
	       				this.setVehicleId(resultSet.getString(1));
	       				this.setVehicleMake(resultSet.getString(2));
	       				this.setVehicleRegistrationNumber(resultSet.getString(3));
	       				this.setVehicleOwnerName(resultSet.getString(4));
	       				this.setOwnerMobileNumber(resultSet.getString(5));
	       				this.setVehicleDriverName(resultSet.getString(6));
	       				this.setDriverMobileNumber(resultSet.getString(7));
	       				this.setInsuranceCompanyName(resultSet.getString(8));
	       				this.setInsuranceContactNumber(resultSet.getString(9));
	       				this.setInsuranceStartDate(resultSet.getString(10));
	       				this.setInsuranceEndDate(resultSet.getString(11));
	       				this.setTaxReceiptStartDate(resultSet.getString(12));
	       				this.setTaxReceiptEndDate(resultSet.getString(13));
	       				this.setRtoPassingStartDate(resultSet.getString(14));
	       				this.setRtoPassingEndDate(resultSet.getString(15));
	       				this.setPucPassingStartDate(resultSet.getString(16));
	       				this.setPucPassingEndDate(resultSet.getString(17));
	       				this.setCarryingCapacityBrass(resultSet.getFloat(18));
	       				result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError("Vehicle details not found! URL Tampered!");
	       			}
	       			
	       			
	       		}catch (SQLException e) {
	        		result = "error";
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
			} catch (IOException e) {
				
				result = "error";
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
   			finally
   			{
   				if(resultSet != null)
				{
					try 
					{
						resultSet.close(); resultSet= null;
					
					}catch (SQLException e) {
						
					}
				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
	       		}else
	       		{
	       			result = "error";
	       			addActionError(this.getText("message.error.cannotLoadPage"));
	       		}
	        	
	        
	        }
	
	        
	        return result;
}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public String getVehicleId() {
		return vehicleId;
	}
	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}
	public String getVehicleMake() {
		return vehicleMake;
	}
	public void setVehicleMake(String vehicleMake) {
		this.vehicleMake = vehicleMake;
	}
	public String getVehicleRegistrationNumber() {
		return vehicleRegistrationNumber;
	}
	public void setVehicleRegistrationNumber(String vehicleRegistrationNumber) {
		this.vehicleRegistrationNumber = vehicleRegistrationNumber;
	}
	public String getInsuranceCompanyName() {
		return insuranceCompanyName;
	}
	public void setInsuranceCompanyName(String insuranceCompanyName) {
		this.insuranceCompanyName = insuranceCompanyName;
	}
	public String getInsuranceContactNumber() {
		return insuranceContactNumber;
	}
	public void setInsuranceContactNumber(String insuranceContactNumber) {
		this.insuranceContactNumber = insuranceContactNumber;
	}
	public String getInsuranceStartDate() {
		return insuranceStartDate;
	}
	public void setInsuranceStartDate(String insuranceStartDate) {
		this.insuranceStartDate = insuranceStartDate;
	}
	public String getInsuranceEndDate() {
		return insuranceEndDate;
	}
	public void setInsuranceEndDate(String insuranceEndDate) {
		this.insuranceEndDate = insuranceEndDate;
	}
	public String getTaxReceiptStartDate() {
		return taxReceiptStartDate;
	}
	public void setTaxReceiptStartDate(String taxReceiptStartDate) {
		this.taxReceiptStartDate = taxReceiptStartDate;
	}
	public String getTaxReceiptEndDate() {
		return taxReceiptEndDate;
	}
	public void setTaxReceiptEndDate(String taxReceiptEndDate) {
		this.taxReceiptEndDate = taxReceiptEndDate;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}
	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}
	public String getCustomerSearchOption() {
		return customerSearchOption;
	}
	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}
	public String getDefaultValue() {
		return defaultValue;
	}
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	public String getRtoPassingStartDate() {
		return rtoPassingStartDate;
	}
	public void setRtoPassingStartDate(String rtoPassingStartDate) {
		this.rtoPassingStartDate = rtoPassingStartDate;
	}
	public String getRtoPassingEndDate() {
		return rtoPassingEndDate;
	}
	public void setRtoPassingEndDate(String rtoPassingEndDate) {
		this.rtoPassingEndDate = rtoPassingEndDate;
	}
	public String getVehicleOwnerName() {
		return vehicleOwnerName;
	}
	public void setVehicleOwnerName(String vehicleOwnerName) {
		this.vehicleOwnerName = vehicleOwnerName;
	}
	public String getOwnerMobileNumber() {
		return ownerMobileNumber;
	}
	public void setOwnerMobileNumber(String ownerMobileNumber) {
		this.ownerMobileNumber = ownerMobileNumber;
	}
	public String getVehicleDriverName() {
		return vehicleDriverName;
	}
	public void setVehicleDriverName(String vehicleDriverName) {
		this.vehicleDriverName = vehicleDriverName;
	}
	public String getDriverMobileNumber() {
		return driverMobileNumber;
	}
	public void setDriverMobileNumber(String driverMobileNumber) {
		this.driverMobileNumber = driverMobileNumber;
	}
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public Float getCarryingCapacityBrass() {
		return carryingCapacityBrass;
	}
	public void setCarryingCapacityBrass(Float carryingCapacityBrass) {
		this.carryingCapacityBrass = carryingCapacityBrass;
	}
	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	public String getPucPassingStartDate() {
		return pucPassingStartDate;
	}
	public void setPucPassingStartDate(String pucPassingStartDate) {
		this.pucPassingStartDate = pucPassingStartDate;
	}
	public String getPucPassingEndDate() {
		return pucPassingEndDate;
	}
	public void setPucPassingEndDate(String pucPassingEndDate) {
		this.pucPassingEndDate = pucPassingEndDate;
	}
	
	

}
