package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;

public class UpdateSupplierPaymentJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -1867603398762964527L;
	private String paymentId;
	private HttpSession session;
	private String paymentDate;
	private String supplierName;
	private String key;
	private String amountPaid;
	private String paymentDetails;
	
	private String supplierId;
	private String supplierMobile;
	private String debtAmount;
	private SessionMap<String,Object> sessionMap;
	
	private String typeOfPayment;
	private String accountId;

	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	private String addSideBarJs;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
	       		
	        	this.setAddSideBarJs("FALSE");
	        	
	       		paymentTypeList.add("CASH");
	        	paymentTypeList.add("UPI");
	        	paymentTypeList.add("RTGS");
	        	paymentTypeList.add("NEFT");
	        	paymentTypeList.add("CHEQUE");
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try 
	       		{
	       			
	       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
	       			sql = "SELECT "
	       					+ "supplier_id,"
	       					+ "supplier_name,"
	       					+ "DATE_FORMAT(payment_entry_date,'%d-%m-%Y'),"
	       					+ "amount,"
	       					+ "payment_type,"
	       					+ "payment_details,"
	       					+ "amount_debit_account_id "
	       					+ "FROM "
	       					+ "crusher_supplier_payment_details_master "
	       					+ "WHERE "
	       					+ "entry_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, this.getPaymentId());
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				
	       				
	       				this.setSupplierName(resultSet.getString(2));
	       				this.setPaymentDate(resultSet.getString(3));
	       				this.setAmountPaid(resultSet.getString(4));
	       				this.setTypeOfPayment(resultSet.getString(5));
	       				this.setPaymentDetails(resultSet.getString(6));
	       				this.setAccountId(resultSet.getString(7));
	       				this.setKey(EncryptionDecryption.encrypt(this.getPaymentId()));
	       				
		       			String supplierId = resultSet.getString(1);
		       			
		       			float openingBal = 0.0F;
		       			PreparedStatement getOpeningBalPSMT = null;
	       				ResultSet getOpeningBalRs = null;
	       				String getOpeningBalSQL = "SELECT "
	       						+ "opening_balance "
	       						+ "FROM "
	       						+ "crusher_supplier_close_open_bal_master "
	       						+ "WHERE "
	       						+ "supplier_id = ? "
	       						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
	       				
	       				getOpeningBalPSMT.setString(1, supplierId);
	       				getOpeningBalPSMT.setString(2, crusherId);
	       				getOpeningBalPSMT.setString(3, crusherCode);
        				
	       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
	       				
	       				if(getOpeningBalRs.next())
	       				{
	       					openingBal = getOpeningBalRs.getFloat(1);
	       				}
	       				else
	       				{
	       					openingBal = 0.0F;
	       				}
	       				
	       				if(resultSet !=null)
	       				{
	       					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
	       				}
	       				if(preparedStatement != null)
	       				{
	       					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	       				}

		       		
		       			
		       			sql = "SELECT "
		       					+ "supplier_id,"
		       					+ "supplier_name,"
		       					+ "contact_number,"
		       					+ "supplier_address "
		       					+ "FROM "
		       					+ "crusher_supplier_master "
		       					+ "WHERE "
		       					+ "supplier_id =  ? "
		       					+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
		       			
		       			
		       			preparedStatement = connection.prepareStatement(sql);
		       			
		       			preparedStatement.setString(1, supplierId);
		       			preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
		       			
		       			resultSet = preparedStatement.executeQuery();
		       			
		       			resultSet.last();
		       			
		       			int rowCount = resultSet.getRow();
		       			
		       			resultSet.beforeFirst();
		       			
		       			if(rowCount > 0)
		       			{
		       				if(resultSet.next())
		       					
		       				{
		       				this.setSupplierId(resultSet.getString(1));
		       				this.setSupplierName(resultSet.getString(2));
		       				this.setSupplierMobile(resultSet.getString(3));
		       				this.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
		       				
		       				

							float floatTotalPurchaseAmt = 0.0F;
		       				float floatTotalAmountPaid = 0.0F;
		       				float floatTotalBalanceAmt = 0.0F;
		       				
		       				PreparedStatement getTotalPurchasePSMT = null;
		       				ResultSet getTotalPurchaseRS = null;
		       				
		       				String getTotalPurchaseSQL = "SELECT "
		       						+ "SUM(purchase_total_amount),"
		       						+ "SUM(purchase_amount_paid) "
		       						+ "FROM "
		       						+ "crusher_purchase_master "
		       						+ "WHERE "
		       						+ "supplier_id = ? "
		       						+ "AND "
		    						+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ?";
		       				
		       				getTotalPurchasePSMT = connection.prepareStatement(getTotalPurchaseSQL);
		       				
		       				getTotalPurchasePSMT.setString(1, resultSet.getString(1));
		       				getTotalPurchasePSMT.setString(2, crusherId);
		       				getTotalPurchasePSMT.setString(3, crusherCode);
	        				
		       				getTotalPurchaseRS = getTotalPurchasePSMT.executeQuery();
		       				
		       				if(getTotalPurchaseRS.next())
		       				{
		       					floatTotalPurchaseAmt = getTotalPurchaseRS.getFloat(1);
		       					floatTotalAmountPaid = getTotalPurchaseRS.getFloat(2);
		       					
		       					
		       				}
		       				
		       				
		       				PreparedStatement getSuppAmtPaidPSMT = null;
		       				ResultSet getSuppAmtPaidRS = null;
		       				String getSuppAmtPaidSQL = "SELECT "
		       						+ "SUM(amount) "
		       						+ "FROM "
		       						+ "crusher_supplier_payment_details_master "
		       						+ "WHERE "
		       						+ "supplier_id = ? "
		       						+ "AND "
		    						+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ?";
		       				
		       				getSuppAmtPaidPSMT = connection.prepareStatement(getSuppAmtPaidSQL);
		       				
		       				
		       				
		       				getSuppAmtPaidPSMT.setString(1, resultSet.getString(1));
		       				getSuppAmtPaidPSMT.setString(2, crusherId);
		       				getSuppAmtPaidPSMT.setString(3, crusherCode);
	        				
		       				getSuppAmtPaidRS = getSuppAmtPaidPSMT.executeQuery();
		       				
		       				
		       				
		       				if(getSuppAmtPaidRS.next())
		       				{
		       					floatTotalAmountPaid = floatTotalAmountPaid + getSuppAmtPaidRS.getFloat(1);
		       				}
		       				
		       				floatTotalBalanceAmt = floatTotalPurchaseAmt - floatTotalAmountPaid;
		       				
		       			
		       				
		       				this.setDebtAmount(""+(floatTotalBalanceAmt+openingBal));
		       				
		       				
		       				if(getSuppAmtPaidRS != null)
		       				{
		       					getSuppAmtPaidRS.close();
		       					getSuppAmtPaidRS = null;
		       				}
		       				
		       				if(getSuppAmtPaidPSMT != null)
		       				{
		       					getSuppAmtPaidPSMT.close();
		       					getSuppAmtPaidPSMT = null;
		       				}
		       				
		       				
		       				
		       				if(getTotalPurchaseRS != null)
		       				{
		       					getTotalPurchaseRS.close();
		       					getTotalPurchaseRS = null;
		       				}
		       				
		       				if(getTotalPurchasePSMT != null)
		       				{
		       					getTotalPurchasePSMT.close();
		       					getTotalPurchasePSMT = null;
		       				}
		       				
		       				}
		       			}
		       				
		       				
		       				
	       				result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.urlTemperedPlzTryagain"));
	       			}
		       			
	       			
	       			
	       		}
	       		catch (SQLException e) {
		       		result = "error";				
					addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someErrorWhileGettingInformation"));
			
	       	 	} catch (IOException e) {
				
				result = "error";
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
			finally
			{
				if(resultSet != null)
				{
					try {
						resultSet.close();
					} catch (SQLException e) {
						
					}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close();} catch (SQLException e) {}
				}
				if(connection != null)
				{
					try {connection.close();} catch (SQLException e) {}
				}
				
			}
		
	        	
	        
	        }
	
	        return result;
}

public String getPaymentId() {
	return paymentId;
}

public void setPaymentId(String paymentId) {
	this.paymentId = paymentId;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public String getPaymentDate() {
	return paymentDate;
}

public void setPaymentDate(String paymentDate) {
	this.paymentDate = paymentDate;
}

public String getSupplierName() {
	return supplierName;
}

public void setSupplierName(String supplierName) {
	this.supplierName = supplierName;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}

public String getAmountPaid() {
	return amountPaid;
}

public void setAmountPaid(String amountPaid) {
	this.amountPaid = amountPaid;
}

public String getPaymentDetails() {
	return paymentDetails;
}

public void setPaymentDetails(String paymentDetails) {
	this.paymentDetails = paymentDetails;
}


public String getSupplierId() {
	return supplierId;
}

public void setSupplierId(String supplierId) {
	this.supplierId = supplierId;
}

public String getSupplierMobile() {
	return supplierMobile;
}

public void setSupplierMobile(String supplierMobile) {
	this.supplierMobile = supplierMobile;
}

public String getDebtAmount() {
	return debtAmount;
}

public void setDebtAmount(String debtAmount) {
	this.debtAmount = debtAmount;
}


public Map<String, String> getAccountList() {
	return accountList;
}

public void setAccountList(Map<String, String> accountList) {
	this.accountList = accountList;
}

public List<String> getPaymentTypeList() {
	return paymentTypeList;
}

public void setPaymentTypeList(List<String> paymentTypeList) {
	this.paymentTypeList = paymentTypeList;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}



public String getTypeOfPayment() {
	return typeOfPayment;
}

public void setTypeOfPayment(String typeOfPayment) {
	this.typeOfPayment = typeOfPayment;
}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

public String getAccountId() {
	return accountId;
}

public void setAccountId(String accountId) {
	this.accountId = accountId;
}
	
	

}
