package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateSupplierJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6182062425953711991L;

	private String key;
	private String supplierId;
	private HttpSession session;
	private String supplierName;
	private String personName;
	private String mobileNumber;
	private String email;
	private String GSTINumber;
	private String TINumber;
	private String PANumber;
	private String address;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	String supplierId = EncryptionDecryption.decrypt(this.getKey());
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			sql = "SELECT "
	       					+ "supplier_id,"
	       					+ "add_date,"
	       					+ "supplier_name,"
	       					+ "contact_person_name,"
	       					+ "contact_number,"
	       					+ "supplier_email,"
	       					+ "supplier_gstin,"
	       					+ "supplier_pan,"
	       					+ "supplier_address "
	       					+ "FROM "
	       					+ "crusher_supplier_master "
	       					+ "WHERE "
	       					+ "supplier_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			int rowCount = 0;
	       			
	       			resultSet.last();
	       			rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			
	       			if(rowCount>0)
	       			{
	       				while(resultSet.next())
	       				{
	       					this.setSupplierId(supplierId);
	       					this.setSupplierName(resultSet.getString(3));
	       					this.setPersonName(resultSet.getString(4));
	       					this.setMobileNumber(resultSet.getString(5));
	       					this.setEmail(resultSet.getString(6));
	       					this.setGSTINumber(resultSet.getString(7));
	       					this.setPANumber(resultSet.getString(8));
	       					this.setAddress(resultSet.getString(9));
	       				}
	       				
	       				result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.urlTemperedInformationNotFound"));
	       			}
	       			
	       		
	       		}
	       		catch (SQLException e) 
	       		{
	        		result = "error";					
					addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"||"+this.getText("message.error.supplierInfoNotFoundSomeError"));
		
	       		}
	       		catch (IOException e) 
	       		{
					
					result = "error";
					addActionMessage(e.getMessage()+"|| "+this.getText("message.error.supplierInfoNotFoundSomeError"));
				}	
	   			finally
	   			{
	   				if(resultSet != null)
					{
						try {
							resultSet.close();
						} catch (SQLException e) {
							
						}
					}
	   				if(preparedStatement != null)
	   				{
	   					try {preparedStatement.close();} catch (SQLException e) {}
	   				}
	   				if(connection != null)
	   				{
	   					try {connection.close();} catch (SQLException e) {}
	   				}
	   				
	   			}
	   		
		        	
		        
		        }
		
		        return result;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getPersonName() {
		return personName;
	}

	public void setPersonName(String personName) {
		this.personName = personName;
	}

	public String getMobileNumber() {
		return mobileNumber;
	}

	public void setMobileNumber(String mobileNumber) {
		this.mobileNumber = mobileNumber;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getGSTINumber() {
		return GSTINumber;
	}

	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}

	public String getTINumber() {
		return TINumber;
	}

	public void setTINumber(String tINumber) {
		TINumber = tINumber;
	}

	public String getPANumber() {
		return PANumber;
	}

	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getSupplierId() {
		return supplierId;
	}

	public void setSupplierId(String supplierId) {
		this.supplierId = supplierId;
	}
	
	
}
