package com.stonecrusher.jspRedirect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;

public class UpdateSettingsJsp extends ActionSupport implements SessionAware, ServletResponseAware, ServletRequestAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 5451053843427525894L;
	private HttpSession session;
	private SessionMap<String,Object> sessionMap;
		
	private String bankingName;
	private String nameOfBank;
	private String nameOfBranch;
	private String accountNumber;
	private String ifscCode;
	private String micrCode;
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		      
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    		  
		    	  }
		      }
		      
		      
		      String crusherId = (String) session.getAttribute("crusherId");
				String crusherCode = (String) session.getAttribute("crusherCode");

				Connection connection = null;
		   		PreparedStatement preparedStatement= null;	
		   		ResultSet resultSet = null;
		   		
		   		String sql = "";
		   		String db = (String) session.getAttribute("db");
    		   	
		   		
				
				try
				{
					 connection = GetDBConnection.getDBConnection(db);
		  	            
					
					 sql = "SELECT "
								+ "name,"
								+ "value "
								+ "FROM "
								+ "crusher_settings_master "
								+ "WHERE "										
								+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);								
						preparedStatement.setString(1, crusherId);
						preparedStatement.setString(2, crusherCode);
						
						resultSet = preparedStatement.executeQuery();
						
						while(resultSet.next())
						{
							  this.getSessionMap().put(resultSet.getString(1),resultSet.getString(2));
							
						}
						
						
						
						
						this.setBankingName((String) this.getSessionMap().get("banking_name"));
						this.setNameOfBank((String) this.getSessionMap().get("name_of_bank"));
						this.setNameOfBranch((String) this.getSessionMap().get("name_of_branch"));
						this.setAccountNumber((String) this.getSessionMap().get("account_number"));
						this.setIfscCode((String) this.getSessionMap().get("ifsc_code"));
						this.setMicrCode((String) this.getSessionMap().get("micr_code"));
						
					
					
					if(requestFromAndroid)
					{
						result = "android-success";
						
					}else
					{
						result = "success";
					}
					
				}
				catch (Exception e) {
					if(requestFromAndroid)
					{
						result = "android-error";
						
					}else
					{
						result = "error";
					};
					addActionError(e.getMessage()+"|| "+this.getText("message.error.errorwhileprocessingkey"));
				}finally {
					if(resultSet !=null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();
						 connection = null;
						}catch (SQLException e) {}
					}
				}
		        
		        }
	        
		        return result;
		}

		public HttpSession getSession() {
			return session;
		}

		public void setSession(HttpSession session) {
			this.session = session;
		}

		public static long getSerialversionuid() {
			return serialVersionUID;
		}

	
	

		public HttpServletRequest getRequest() {
			return request;
		}

		public void setRequest(HttpServletRequest request) {
			this.request = request;
		}

		public HttpServletResponse getResponse() {
			return response;
		}

		public void setResponse(HttpServletResponse response) {
			this.response = response;
		}

		@Override  
		public void setSession(Map<String, Object> map) {  
		    sessionMap=(SessionMap<String, Object>)map;  
		}


		public SessionMap<String, Object> getSessionMap() {
			return sessionMap;
		}

		public void setSessionMap(SessionMap<String, Object> sessionMap) {
			this.sessionMap = sessionMap;
		}

		public String getBankingName() {
			return bankingName;
		}

		public void setBankingName(String bankingName) {
			this.bankingName = bankingName;
		}

		public String getAccountNumber() {
			return accountNumber;
		}

		public void setAccountNumber(String accountNumber) {
			this.accountNumber = accountNumber;
		}

		@Override
		public void setServletRequest(HttpServletRequest arg0) {
			// TODO Auto-generated method stub
			this.request = arg0;
		}

		@Override
		public void setServletResponse(HttpServletResponse arg0) {
			// TODO Auto-generated method stub
			this.response = arg0;
		}

		public String getNameOfBank() {
			return nameOfBank;
		}

		public void setNameOfBank(String nameOfBank) {
			this.nameOfBank = nameOfBank;
		}

		public String getNameOfBranch() {
			return nameOfBranch;
		}

		public void setNameOfBranch(String nameOfBranch) {
			this.nameOfBranch = nameOfBranch;
		}

		public String getIfscCode() {
			return ifscCode;
		}

		public void setIfscCode(String ifscCode) {
			this.ifscCode = ifscCode;
		}

		public String getMicrCode() {
			return micrCode;
		}

		public void setMicrCode(String micrCode) {
			this.micrCode = micrCode;
		}

		
		


}
