package com.stonecrusher.jspRedirect;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetCustomerTotalCreditAmountById;

public class UpdateReminderEntryJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6208411094853732491L;
	private HttpSession session;

	private SessionMap<String,Object> sessionMap;
	private String paymentReminderAddDate;
	private String customerName;
	private Float outstandingAmount;
	private String paymentPromiseDate;
	private String comments;
	
	private String addSideBarJs;
	
	private String key;
	public String execute() {
		
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				this.setAddSideBarJs("FALSE");
				 
					
				String sql = "";
				String db = (String)  session.getAttribute("db");
				
				try
				{
					String keyData [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					String entryId = keyData[0];
					String custId = keyData[1];
					String promiseDate = keyData[2];
					
					connection = GetDBConnection.getDBConnection(db);
					
					
					sql = "SELECT "
							+ "DATE_FORMAT(reminder_add_date,'%d-%m-%Y'),"
							+ "customer_id,"
							+ "customer_name,"
							+ "customer_mobile_number,"
							+ "outsatnding_amount,"
							+ "DATE_FORMAT(payment_promise_date,'%d-%m-%Y'),"
							+ "comments "
							+ "FROM "
							+ "crusher_customer_payment_reminder_master "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "customer_id = ? "
							+ "AND "
							+ "payment_promise_date = STR_TO_DATE(?,'%d-%M-%Y')";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, custId);
					preparedStatement.setString(3, promiseDate);
					
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						DecimalFormat df = new DecimalFormat("##.#");
						float custOutStandingAmt = GetCustomerTotalCreditAmountById.getCustomerTotalCreditAmountById(custId, this.getSessionMap());
						
						this.setPaymentReminderAddDate(resultSet.getString(1));
						this.setCustomerName(resultSet.getString(2)+"-"+resultSet.getString(3)+"-"+resultSet.getString(4));
						this.setOutstandingAmount(custOutStandingAmt);
						this.setPaymentPromiseDate(resultSet.getString(6));
						this.setComments(resultSet.getString(7));
						
						result = SUCCESS;
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.detailsNotFound"));
					}
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" ||"+this.getText("message.error.detailsNotFound"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	public String getPaymentReminderAddDate() {
		return paymentReminderAddDate;
	}
	public void setPaymentReminderAddDate(String paymentReminderAddDate) {
		this.paymentReminderAddDate = paymentReminderAddDate;
	}
	public String getCustomerName() {
		return customerName;
	}
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
	public Float getOutstandingAmount() {
		return outstandingAmount;
	}
	public void setOutstandingAmount(Float outstandingAmount) {
		this.outstandingAmount = outstandingAmount;
	}
	public String getPaymentPromiseDate() {
		return paymentPromiseDate;
	}
	public void setPaymentPromiseDate(String paymentPromiseDate) {
		this.paymentPromiseDate = paymentPromiseDate;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



}