package com.stonecrusher.jspRedirect;


import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class UpdateMaintenanceEntryJsp extends ActionSupport implements SessionAware{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 264333847599926759L;

	private SessionMap<String,Object> sessionMap;
	
	private String addSideBarJs;
	
	private String key;
	private String fromDate;
	private String toDate;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	private File invoiceImage;
	private Float amount;
	private String comments;
	private String entryDate;
	private String vehicleId;
	private String typeOfPayment;
	private String accountId;
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	
	public String execute() {
		
		
		String result = "login";
		 if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{ 
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		paymentTypeList.add("CASH");
	        	paymentTypeList.add("UPI");
	        	paymentTypeList.add("RTGS");
	        	paymentTypeList.add("NEFT");
	        	paymentTypeList.add("CHEQUE");
	        	
	        	this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));       
				
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				this.setAddSideBarJs("FALSE");
				 
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
					String entryId = keyDetails[0];
					String vehicleId = keyDetails[1];
					String entryDate = keyDetails[2];
					
					connection = GetDBConnection.getDBConnection(db);
					
					
					sql = "SELECT "
							+ "DATE_FORMAT(exepense_date,'%d-%m-%Y'),"
							+ "vehicle_id,"
							+ "exepense_amount,"
							+ "consupmtion_details,"
							+ "expence_image,"
							+ "credit_debit_id "
							+ "FROM "
							+ "crusher_vehicle_expense_master "
							+ "WHERE "
							+ "vehicle_expense_entry_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						this.setEntryDate(resultSet.getString(1));
						
						HashMap<String,String> vehicleDetailsMap = new HashMap<String,String>();
						
						vehicleDetailsMap = GetVehicleDetailsById.getVehicleDetailsById(resultSet.getString(2), this.getSessionMap(), connection);
						
						this.setVehicleId(resultSet.getString(2)+"-"+vehicleDetailsMap.get("VEHICLEMAKE")+"-"+vehicleDetailsMap.get("REGISTRATIONNUMBER"));
						
						
						
						this.setAmount(resultSet.getFloat(3));
						this.setComments(resultSet.getString(4));
						String creditDebitId = resultSet.getString(6);
						
						if(resultSet != null)
						  {
							  resultSet.close();
							  resultSet = null;
						  }
						  
						  if(preparedStatement != null)
						  {
							  preparedStatement.close();
							  preparedStatement = null;
						  }
						  
						  
						  
							sql = "SELECT "
									+ "account_id,"
									+ "account_number,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							
							preparedStatement.setString(1, creditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							
							resultSet = preparedStatement.executeQuery();
							
							if(resultSet.next())
							{
								this.setAccountId(resultSet.getString(1));
								this.setTypeOfPayment(resultSet.getString(2));
								
							}
						
						result = SUCCESS;
					}
					else
					{
						result = ERROR;
						addActionError(this.getText("message.error.detailsNotFound"));
					}
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public Map<String, String> getVehicleList() {
		return vehicleList;
	}

	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	public String getDownloadType() {
		return downloadType;
	}

	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}

	public File getInvoiceImage() {
		return invoiceImage;
	}

	public void setInvoiceImage(File invoiceImage) {
		this.invoiceImage = invoiceImage;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public String getEntryDate() {
		return entryDate;
	}

	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	public String getTypeOfPayment() {
		return typeOfPayment;
	}

	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public String getChequePayDate() {
		return chequePayDate;
	}

	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}

	public String getChequePayee() {
		return chequePayee;
	}

	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranchName() {
		return branchName;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}

	public String getChequeNumber() {
		return chequeNumber;
	}

	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public List<String> getBankList() {
		return bankList;
	}

	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}

	public List<String> getBranchList() {
		return branchList;
	}

	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}

	public List<String> getChequeList() {
		return chequeList;
	}

	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0; 
	}



}