package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateLaborDetailsJsp extends ActionSupport {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2516016896965191653L;
	private String key;
	private HttpSession session;
	private String laborId;
	private String laborName;
	private String laborMobileNumber;
	private String address;
	private String birthDate;
	private String joiningDate;
	private String addSideBarJs;
	private String adharNumber;
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	    		this.setAddSideBarJs("FALSE");
	    		
	        	String laborId = EncryptionDecryption.decrypt(this.getKey());
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try 
	       		{
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
					sql = "SELECT "
							+ "employee_name,"
							+ "employee_mobile_number,"
							+ "employee_address,"
							+ "DATE_FORMAT(employee_birth_date,'%d-%m-%Y'),"
							+ "DATE_FORMAT(joining_date,'%d-%m-%Y'),"
							+ "adhar_number "
							+ "FROM "
							+ "crusher_employee_master "
							+ "WHERE "
							+ "employee_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, laborId);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						this.setLaborName(resultSet.getString(1));
						this.setLaborMobileNumber(resultSet.getString(2));
						this.setAddress(resultSet.getString(3));
						this.setBirthDate(resultSet.getString(4));
						this.setJoiningDate(resultSet.getString(5));
						this.setAdharNumber(resultSet.getString(6));
						
						result = SUCCESS;
					}
					else
					{
						result = ERROR;
						
						addActionError(this.getText("message.error.detailsNotFoundPlzTryAgain"));
					}
							
					
					
	       		} catch (SQLException e) {
	       			result = ERROR;
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
			} catch (IOException e) {
				
				result = ERROR;
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
   			finally
   			{
   				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		
	        }
	        
	        return result;
}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getLaborId() {
		return laborId;
	}

	public void setLaborId(String laborId) {
		this.laborId = laborId;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public String getLaborMobileNumber() {
		return laborMobileNumber;
	}

	public void setLaborMobileNumber(String laborMobileNumber) {
		this.laborMobileNumber = laborMobileNumber;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getBirthDate() {
		return birthDate;
	}

	public void setBirthDate(String birthDate) {
		this.birthDate = birthDate;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getJoiningDate() {
		return joiningDate;
	}

	public void setJoiningDate(String joiningDate) {
		this.joiningDate = joiningDate;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getAdharNumber() {
		return adharNumber;
	}

	public void setAdharNumber(String adharNumber) {
		this.adharNumber = adharNumber;
	}



}
