package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateCustomerJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6951638191575198719L;
	private String key;
	private HttpSession session;
	private String custAddDate;
	private String custName;
	private String custMobileNumber;
	private String email;
	private String GSTINumber;
	private String TINumber;
	private String PANumber;
	private String BillingAddress;
	private String birthDate;
	private String creditLimit;
	private String custSecondaryMobileNumber;
	private String custNameMarathi;
	private String billingAddressMrathi;
	private String pinCode;
	private String addSideBarJs;
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
				
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	String custId = EncryptionDecryption.decrypt(this.getKey());
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			sql = "select "	       					
	       					+ "DATE_FORMAT(add_date,'%d-%M-%y'),"
	       					+ "customer_name,"
	       					+ "cust_name_marathi,"
	       					+ "mobile_number,"
	       					+ "cust_secondary_mobile,"
	       					+ "gst_number,"
	       					+ "pan_number,"
	       					+ "tin_number,"
	       					+ "billing_address,"
	       					+ "billing_address_marathi,"
	       					+ "DATE_FORMAT(birth_date,'%d-%m-%y'),"
	       					+ "credit_limit,"
	       					+ "pincode_number,"
	       					+ "customer_status "
	       					+ "FROM "
	       					+ "crusher_customer_master "
	       					+ "where "
	       					+ "customer_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, custId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			if(rowCount>0)
	       			{
		       			if(resultSet.next())
		       			{
		       				this.setCustAddDate(resultSet.getString(1));
		       				this.setCustName(resultSet.getString(2));
		       				this.setCustNameMarathi(resultSet.getString(3));
		       				this.setCustMobileNumber(resultSet.getString(4));
		       				this.setCustSecondaryMobileNumber(resultSet.getString(5));
		       				this.setGSTINumber(resultSet.getString(6));
		       				this.setPANumber(resultSet.getString(7));
		       				this.setTINumber(resultSet.getString(8));
		       			
		       				this.setBillingAddress(resultSet.getString(9));
		       				this.setBillingAddressMrathi(resultSet.getString(10));
		       				this.setBirthDate(resultSet.getString(11));
		       				this.setCreditLimit(resultSet.getString(12));		       				
		       				this.setPinCode(resultSet.getString(13));
		       				this.setAddSideBarJs("FALSE");
		       			}
		       			result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.detailsOfSpecifiedCustomerNotFound"));
	       			}
	       		
	        	}	 catch (SQLException e) {
	        		result = "error";
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
			} catch (IOException e) {
				
				result = "error";
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
   			finally
   			{
   				if(resultSet != null)
				{
					try {
						resultSet.close();resultSet = null;
					} catch (SQLException e) {
						
					}
				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		
	        	
	        
	        }
	
	        return result;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public String getCustAddDate() {
	return custAddDate;
}

public void setCustAddDate(String custAddDate) {
	this.custAddDate = custAddDate;
}

public String getCustName() {
	return custName;
}

public void setCustName(String custName) {
	this.custName = custName;
}

public String getCustMobileNumber() {
	return custMobileNumber;
}

public void setCustMobileNumber(String custMobileNumber) {
	this.custMobileNumber = custMobileNumber;
}

public String getEmail() {
	return email;
}

public void setEmail(String email) {
	this.email = email;
}

public String getGSTINumber() {
	return GSTINumber;
}

public void setGSTINumber(String gSTINumber) {
	GSTINumber = gSTINumber;
}

public String getTINumber() {
	return TINumber;
}

public void setTINumber(String tINumber) {
	TINumber = tINumber;
}

public String getPANumber() {
	return PANumber;
}

public void setPANumber(String pANumber) {
	PANumber = pANumber;
}

public String getBillingAddress() {
	return BillingAddress;
}

public void setBillingAddress(String billingAddress) {
	BillingAddress = billingAddress;
}

public String getBirthDate() {
	return birthDate;
}

public void setBirthDate(String birthDate) {
	this.birthDate = birthDate;
}

public String getCreditLimit() {
	return creditLimit;
}

public void setCreditLimit(String creditLimit) {
	this.creditLimit = creditLimit;
}

public String getCustSecondaryMobileNumber() {
	return custSecondaryMobileNumber;
}

public void setCustSecondaryMobileNumber(String custSecondaryMobileNumber) {
	this.custSecondaryMobileNumber = custSecondaryMobileNumber;
}

public String getCustNameMarathi() {
	return custNameMarathi;
}

public String getPinCode() {
	return pinCode;
}

public void setPinCode(String pinCode) {
	this.pinCode = pinCode;
}

public void setCustNameMarathi(String custNameMarathi) {
	this.custNameMarathi = custNameMarathi;
}

public String getBillingAddressMrathi() {
	return billingAddressMrathi;
}

public void setBillingAddressMrathi(String billingAddressMrathi) {
	this.billingAddressMrathi = billingAddressMrathi;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}


}
