package com.stonecrusher.jspRedirect;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

import com.opensymphony.xwork2.ActionSupport;

public class UpdateBoulderSupplierJsp extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5676534548750939957L;
	private SessionMap<String,Object> sessionMap;
	

	private String key;
	
	
	private String boulderSuppName;
	private String boulderSuppFirmName;
	private String address;
	private String boulderSuppMobileNumber;
	private String boulderSuppSecondaryMobileNumber;
	private String GSTINumber;
	private String PANumber;
	private Float boulderBrassRate;
	private Float boulderMtonRate;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String supplierId = EncryptionDecryption.decrypt(this.getKey());
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "boulder_supplier_name,"
							+ "boulder_supplier_firm_name,"
							+ "boulder_supplier_address,"
							+ "boulder_supplier_mobile_number,"
							+ "boulder_supplier_gst_number,"
							+ "boulder_supplier_pan_number,"
							+ "boulder_brass_rate,"
							+ "boulder_mton_rate "
							+ "FROM "
							+ "crusher_boulder_supplier_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "AND "
							+ "boulder_supplier_id = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, supplierId);
					
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						this.setBoulderSuppName(resultSet.getString(1));
						this.setBoulderSuppFirmName(resultSet.getString(2));
						this.setAddress(resultSet.getString(3));
						this.setBoulderSuppMobileNumber(resultSet.getString(4));
						this.setGSTINumber(resultSet.getString(5));
						this.setPANumber(resultSet.getString(6));
						this.setBoulderBrassRate(resultSet.getFloat(7));
						this.setBoulderMtonRate(resultSet.getFloat(8));
						
						result = SUCCESS;
						
					}
					else
					{
						result = ERROR;
						addActionError("URL Tampered! Please try again!");
					}
				}
				catch (SQLException e) {
						result = ERROR;
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
				}
				catch (Exception e) {
						result = ERROR;
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	
	public String getKey() {
		return key;
	}



	public void setKey(String key) {
		this.key = key;
	}



	public String getBoulderSuppName() {
		return boulderSuppName;
	}



	public void setBoulderSuppName(String boulderSuppName) {
		this.boulderSuppName = boulderSuppName;
	}



	public String getBoulderSuppFirmName() {
		return boulderSuppFirmName;
	}



	public void setBoulderSuppFirmName(String boulderSuppFirmName) {
		this.boulderSuppFirmName = boulderSuppFirmName;
	}



	public String getAddress() {
		return address;
	}



	public void setAddress(String address) {
		this.address = address;
	}



	public String getBoulderSuppMobileNumber() {
		return boulderSuppMobileNumber;
	}



	public void setBoulderSuppMobileNumber(String boulderSuppMobileNumber) {
		this.boulderSuppMobileNumber = boulderSuppMobileNumber;
	}



	public String getBoulderSuppSecondaryMobileNumber() {
		return boulderSuppSecondaryMobileNumber;
	}



	public void setBoulderSuppSecondaryMobileNumber(String boulderSuppSecondaryMobileNumber) {
		this.boulderSuppSecondaryMobileNumber = boulderSuppSecondaryMobileNumber;
	}



	public String getGSTINumber() {
		return GSTINumber;
	}



	public void setGSTINumber(String gSTINumber) {
		GSTINumber = gSTINumber;
	}



	public String getPANumber() {
		return PANumber;
	}



	public void setPANumber(String pANumber) {
		PANumber = pANumber;
	}



	public Float getBoulderBrassRate() {
		return boulderBrassRate;
	}



	public void setBoulderBrassRate(Float boulderBrassRate) {
		this.boulderBrassRate = boulderBrassRate;
	}



	public Float getBoulderMtonRate() {
		return boulderMtonRate;
	}



	public void setBoulderMtonRate(Float boulderMtonRate) {
		this.boulderMtonRate = boulderMtonRate;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}




