package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateBankAccountJsp extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -939499694356300637L;
	private HttpSession session;
	private String key;
	private String accountId;
	private String accountHolderName;
	private String accountNumber;
	private String ifscCode;
	private String bankName;
	private String branch;
	private String openingBalance;
	private String oldBalance;
	private SessionMap<String,Object> sessionMap;  
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private String addSideBarJs;

	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        	
	    	
	        	String accountId = "";
	        	
	        
	        	accountId = EncryptionDecryption.decrypt(this.getKey());
				
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		this.setAddSideBarJs("FALSE");
	       		if(!hasActionErrors())
	       		{
	       		try {
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			sql = "SELECT "
	       					+ "account_id,"
							+ "account_holder_name,"
							+ "account_number,"
							+ "ifsc_code,"
							+ "bank_name,"
							+ "branch,"
							+ "opening_balance "
							+ "FROM "
							+ "crusher_bank_account "
							+ "WHERE "
							+ "account_id = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, accountId);
	       			preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
	       			
	       			resultSet = preparedStatement.executeQuery();
	       			if(resultSet.next())
	       			{
	       				this.setAccountId(resultSet.getString(1));
	       				this.setAccountHolderName(resultSet.getString(2));
	       				this.setAccountNumber(resultSet.getString(3));
	       				this.setIfscCode(resultSet.getString(4));
	       				this.setBankName(resultSet.getString(5));
	       				this.setBranch(resultSet.getString(6));
	       				this.setOpeningBalance(resultSet.getString(7));
	       				this.setOldBalance(resultSet.getString(7));
	       				
	       				result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.bankAccountDetailsNotFound"));
	       			}
	       			
	       			
	       		}catch (SQLException e) {
	        		result = "error";
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
			} catch (IOException e) {
				
				result = "error";
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
   			finally
   			{
   				if(resultSet != null)
				{
					try 
					{
						resultSet.close(); resultSet= null;
					
					}catch (SQLException e) {
						
					}
				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
	       		}else
	       		{
	       			result = "error";
	       			addActionError(this.getText("message.error.cannotLoadPage"));
	       		}
	        	
	        
	        }
	
	        
	        return result;
}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getKey() {
		return key;
	}
	public void setKey(String key) {
		this.key = key;
	}
	
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}
	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}
	public String getCustomerSearchOption() {
		return customerSearchOption;
	}
	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}
	public String getDefaultValue() {
		return defaultValue;
	}
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	
	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	public String getAccountId() {
		return accountId;
	}
	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}
	public String getAccountHolderName() {
		return accountHolderName;
	}
	public void setAccountHolderName(String accountHolderName) {
		this.accountHolderName = accountHolderName;
	}
	public String getAccountNumber() {
		return accountNumber;
	}
	public void setAccountNumber(String accountNumber) {
		this.accountNumber = accountNumber;
	}
	public String getIfscCode() {
		return ifscCode;
	}
	public void setIfscCode(String ifscCode) {
		this.ifscCode = ifscCode;
	}
	public String getBankName() {
		return bankName;
	}
	public void setBankName(String bankName) {
		this.bankName = bankName;
	}
	public String getBranch() {
		return branch;
	}
	public void setBranch(String branch) {
		this.branch = branch;
	}
	public String getOpeningBalance() {
		return openingBalance;
	}
	public void setOpeningBalance(String openingBalance) {
		this.openingBalance = openingBalance;
	}
	public String getOldBalance() {
		return oldBalance;
	}
	public void setOldBalance(String oldBalance) {
		this.oldBalance = oldBalance;
	}
	
	

}
