package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class UpdateBankAccOpeningBalJsp extends ActionSupport{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2343062631048910704L;
	private String key;
	private String accountHolderName;
	private String accountNumber;
	private String bankName;
	private HttpSession session;
	private String addSideBarJs;
	private String oldBalance;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	String accountId = EncryptionDecryption.decrypt(this.getKey());
	        	
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			sql = "SELECT "	       					
	       					+ "account_holder_name,"
	       					+ "account_number,"
	       					+ "bank_name,"
	       					+ "opening_balance "
	       					+ "FROM "
	       					+ "crusher_bank_account "
	       					+ "where "
	       					+ "account_id = ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, accountId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			resultSet.last();
	       			int rowCount = resultSet.getRow();
	       			resultSet.beforeFirst();
	       			if(rowCount>0)
	       			{
		       			if(resultSet.next())
		       			{
		       				this.setAccountHolderName(resultSet.getString(1));
		       				this.setAccountNumber(resultSet.getString(2));
		       				this.setBankName(resultSet.getString(3));
		       				this.setOldBalance(resultSet.getString(4));
		       				
		       			
		       			}
		       			
		       			this.setAddSideBarJs("FALSE");
		       			result = "success";
	       			}
	       			else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.bankAccountDetailsNotFound"));
	       			}
	       		
	        	}	 catch (SQLException e) {
	        		result = "error";
   				
   				addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.someError"));
			
			} catch (IOException e) {
				
				result = "error";
				addActionMessage(e.getMessage()+"|| "+this.getText("message.error.someError"));
			}	
   			finally
   			{
   				if(resultSet != null)
				{
					try {
						resultSet.close(); resultSet = null;
					} catch (SQLException e) {
						
					}
				}
   				if(preparedStatement != null)
   				{
   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
   				}
   				if(connection != null)
   				{
   					try {connection.close(); connection = null;} catch (SQLException e) {}
   				}
   				
   			}
   		
	        	
	        
	        }
	
	        return result;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}



public static long getSerialversionuid() {
	return serialVersionUID;
}

public String getAddSideBarJs() {
	return addSideBarJs;
}

public void setAddSideBarJs(String addSideBarJs) {
	this.addSideBarJs = addSideBarJs;
}

public String getAccountHolderName() {
	return accountHolderName;
}

public void setAccountHolderName(String accountHolderName) {
	this.accountHolderName = accountHolderName;
}

public String getAccountNumber() {
	return accountNumber;
}

public void setAccountNumber(String accountNumber) {
	this.accountNumber = accountNumber;
}

public String getBankName() {
	return bankName;
}

public void setBankName(String bankName) {
	this.bankName = bankName;
}

public String getOldBalance() {
	return oldBalance;
}

public void setOldBalance(String oldBalance) {
	this.oldBalance = oldBalance;
}



}
