package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;

public class UpdateBankAccEntryJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2188217661646554920L;
	private SessionMap<String,Object> sessionMap;  
	private HttpSession session;
	private String key;
	private String entryType;
	private String entryDate;
	private Float amount;
	private String typeOfPayment;
	private String entryDetails;
	private String accountId;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	
	Map<String,String> accountList = new LinkedHashMap<String,String>();
	List<String> paymentTypeList = new ArrayList<String>();
	List<String> entryTypeList = new ArrayList<String>();
	
	private String addSideBarJs;
	
	
	public String execute() {
		 
		String result = "login";
		
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){
	        	
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) this.getSessionMap().get("db");
				
				this.getEntryTypeList().add("CREDIT");
				this.getEntryTypeList().add("DEBIT");
				
				try
				{
					
					this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));        	
			    	this.setPaymentTypeList(GetTypeOfPaymentList.getTypeOfPaymentList());
			    	
					String [] keyDetails = EncryptionDecryption.decrypt(this.getKey()).split("#") ;
					
					String entryId = keyDetails[0] ;
					String accountId = keyDetails[1];
					this.setEntryType(keyDetails[2]);
					
					connection = GetDBConnection.getDBConnection(db);
					
					sql ="SELECT "
							+ "account_id,"
							+ "account_number,"
							+ "DATE_FORMAT(entry_date,'%d-%m-%Y'),"
							+ "entry_time,"
							+ "entry_type,"
							+ "amount,"
							+ "payment_type,"
							+ "entry_by,"
							+ "entry_details "
							+ "FROM "
							+ "bank_account_credit_debit_master "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "account_id = ? "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, entryId);
					preparedStatement.setString(2, accountId);
					preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
					
					resultSet = preparedStatement.executeQuery();
					
					while(resultSet.next())
					{
						this.setAccountId(resultSet.getString(1));
						this.setEntryDate(resultSet.getString(3));						
						this.setAmount(resultSet.getFloat(6));
						this.setTypeOfPayment(resultSet.getString(7));
						this.setEntryDetails(resultSet.getString(9));
					}
					
					
					this.setAddSideBarJs("FALSE");
					
					result = SUCCESS;
					
				} catch (SQLException e) {
					result = "error";
					//e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.detailsNotFound"));
				} catch (IOException e) {
					result = "error";
					//e.printStackTrace();
					addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.detailsNotFound"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
		        
				
				
	        }
	        
	        return result;
	}
	
	

	public String getKey() {
		return key;
	}



	public void setKey(String key) {
		this.key = key;
	}



	public String getEntryType() {
		return entryType;
	}



	public void setEntryType(String entryType) {
		this.entryType = entryType;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public String getEntryDate() {
		return entryDate;
	}



	public void setEntryDate(String entryDate) {
		this.entryDate = entryDate;
	}



	public Float getAmount() {
		return amount;
	}



	public void setAmount(Float amount) {
		this.amount = amount;
	}



	public String getTypeOfPayment() {
		return typeOfPayment;
	}



	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}



	public String getEntryDetails() {
		return entryDetails;
	}



	public void setEntryDetails(String entryDetails) {
		this.entryDetails = entryDetails;
	}



	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}



	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}



	public String getCustomerSearchOption() {
		return customerSearchOption;
	}



	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}



	public String getDefaultValue() {
		return defaultValue;
	}



	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}



	public Map<String, String> getAccountList() {
		return accountList;
	}



	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}



	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}



	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}



	public HttpSession getSession() {
		return session;
	}



	public void setSession(HttpSession session) {
		this.session = session;
	}



	public String getAccountId() {
		return accountId;
	}



	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}




	public List<String> getEntryTypeList() {
		return entryTypeList;
	}



	public void setEntryTypeList(List<String> entryTypeList) {
		this.entryTypeList = entryTypeList;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	
}
