package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class ListVehicleInfoJsp extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8061612827507199332L;
	
	private HttpSession session;
	private List<VehicleDetailsDAO> vehicleInfoList = new ArrayList<VehicleDetailsDAO>();
	private SessionMap<String,Object> sessionMap;  
	
	public String execute() throws Exception {
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else
	        {
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);		
					
					sql = "SELECT "
							+ "vehicle_id,"
							+ "vehicle_make,"
							+ "vehicle_registration_number,"
							+ "vehicle_insurance_name,"
							+ "vehicle_insurance_company_contact,"
							+ "DATE_FORMAT(insurance_start_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(insurance_end_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(tax_receipt_start_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(tax_receipt_end_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(rto_passing_start_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(rto_passing_end_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(puc_passing_start_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(puc_passing_end_date,'%d-%M-%Y'),"
							+ "insurance_image_file,"
							+ "tax_receipt_image_file,"
							+ "rto_passing_image_file, "
							+ "puc_passing_image_file,"
							+ "gps_certificate_image_file "
							+ "FROM "
							+ "crusher_vehicle_details_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY vehicle_id ASC";
					
					preparedStatement = connection.prepareStatement(sql);
				
					preparedStatement.setString(1, crusherId); 
					preparedStatement.setString(2, crusherCode);

					
					resultSet = preparedStatement.executeQuery();
					resultSet.last();
					int rowCount = resultSet.getRow();
					resultSet.beforeFirst();
					if(rowCount >  0)
					{
						while(resultSet.next())
						{
							VehicleDetailsDAO dao = new VehicleDetailsDAO();
							dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
							dao.setVehicleId(resultSet.getString(1));
							dao.setVehicleMake(resultSet.getString(2));
							dao.setVehicleRegistrationNumber(resultSet.getString(3));
							dao.setInsuranceComapnyName(resultSet.getString(4));
							dao.setInsuranceComapnyNumber(resultSet.getString(5));
							dao.setInsuranceStartDate(resultSet.getString(6));
							dao.setInsuranceEndDate(resultSet.getString(7));
							dao.setTaxReceiptStartDate(resultSet.getString(8));
							dao.setTaxReceiptEndDate(resultSet.getString(9));
							dao.setRtoPassingStartDate(resultSet.getString(10));
							dao.setRtoPassingEndDate(resultSet.getString(11));
							
							dao.setPucPassingStartDate(resultSet.getString(12));
							dao.setPucPassingEndDate(resultSet.getString(13));
							
							dao.setInsurancePDF(resultSet.getBlob(14));
							dao.setTaxReceiptPDF(resultSet.getBlob(15));
							dao.setRtoPassingPDF(resultSet.getBlob(16));
							dao.setPucPassingPDF(resultSet.getBlob(17));
							dao.setGpsCertificatePDF(resultSet.getBlob(18));
							
							this.getVehicleInfoList().add(dao);
							
						}
						
						result = "success";
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.vehicleDetailsNotFound"));
					}
					
				} catch (SQLException e) {
					result = "error";
					//e.printStackTrace();
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() );
				} catch (IOException e) {
					result = "error";
					
					addActionError(e.getMessage()+" || "+e.getCause());
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
	        	
	        }
		
		return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public List<VehicleDetailsDAO> getVehicleInfoList() {
		return vehicleInfoList;
	}

	public void setVehicleInfoList(List<VehicleDetailsDAO> vehicleInfoList) {
		this.vehicleInfoList = vehicleInfoList;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	
}