package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.bankAccountDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class ListBankAccountJsp extends ActionSupport  implements SessionAware{


	/**
	 * 
	 */
	private static final long serialVersionUID = 3467435617843807795L;
	private HttpSession session;
	private List<bankAccountDetailsDAO> bankAccountInfoList = new ArrayList<bankAccountDetailsDAO>();
	private SessionMap<String,Object> sessionMap;  
	
	public String execute() throws Exception {
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else
	        {
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
					
					connection = GetDBConnection.getDBConnection(db);		
					
					sql = "SELECT "
							+ "account_id,"
							+ "account_holder_name,"
							+ "account_number,"
							+ "ifsc_code,"
							+ "bank_name,"
							+ "branch,"
							+ "opening_balance "
							+ "FROM "
							+ "crusher_bank_account "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY account_id ASC";
					
					preparedStatement = connection.prepareStatement(sql);
				
					preparedStatement.setString(1, crusherId); 
					preparedStatement.setString(2, crusherCode);

					
					resultSet = preparedStatement.executeQuery();
					resultSet.last();
					int rowCount = resultSet.getRow();
					resultSet.beforeFirst();
					if(rowCount >  0)
					{
						while(resultSet.next())
						{
							bankAccountDetailsDAO dao = new bankAccountDetailsDAO();
							dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
							dao.setAccountId(resultSet.getString(1));
							dao.setAccountHolderName(resultSet.getString(2));
							dao.setAccountNumber(resultSet.getString(3));
							dao.setIfscCode(resultSet.getString(4));
							dao.setBankName(resultSet.getString(5));
							dao.setBranch(resultSet.getString(6));
							dao.setOpeningBalance(resultSet.getString(7));
							
							this.getBankAccountInfoList().add(dao);
							
						}
						
						result = "success";
					}
					else
					{
						result = "error";
						addActionError(this.getText("message.error.bankAccountDetailsNotFound"));
					}
					
				} catch (SQLException e) {
					result = "error";
					//e.printStackTrace();
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() );
				} catch (IOException e) {
					result = "error";
					
					addActionError(e.getMessage()+" || "+e.getCause());
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
	        	
	        }
		
		return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}


	public List<bankAccountDetailsDAO> getBankAccountInfoList() {
		return bankAccountInfoList;
	}

	public void setBankAccountInfoList(List<bankAccountDetailsDAO> bankAccountInfoList) {
		this.bankAccountInfoList = bankAccountInfoList;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		 sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	
}