package com.stonecrusher.jspRedirect;


import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.opensymphony.xwork2.ActionSupport;

public class GenerateBillForSelectedDC extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4756103276737156811L;
	private SessionMap<String,Object> sessionMap;

	private List<String> selection = new ArrayList<String>();
	
	private String billDateTime;
	private String billNumber;
	private String chalanNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private String royalty;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private String addSideBarJs;
	private String tripFrom;
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	private String keyVehicle;
	private String vehicleId;
	private float vehicleEmptyWeight = 0.0f;
	private Boolean isFromVehicleEntryDetails ;
	private boolean viewBill;
    private String discountType;
    
	private Map<String,String> discountTypeList = new HashMap<String,String>();
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private Integer totalTrips;
	

	private boolean billSaved;
	private boolean displayDCPhotos;
	private boolean generateBillForDc;
	
	private boolean sendSMS;
	
	

	private String tripDate;
	private String materialName;
	private Float materialVolume;
	
	private String operator;
	private String paymentType;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private String taxPercentage;
	private Float salesRate;
	private Float quantity;
	private Float discountPercentage;
	private Float discountRupees;
	private Float amount;
	private Float amountAfterDiscount;
	private Float transportCharge;
	private String alternateMobileNumber;
	private Float totalPaybleAmount; 
	private String amountPaid;
	

	private Blob vehicleImage1PDF;
	private Blob vehicleImage2PDF;
	private Blob vehicleImage3PDF;


	private String comments;
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList2 = new ArrayList<String>();

	
	private List<BillProductInfoDAO> productInfoList = new ArrayList<BillProductInfoDAO>();
	private BillInformationDAO billInfoDAO = new BillInformationDAO();
	private BillVehicleInfoDAO billVehicleInfoDAO = new BillVehicleInfoDAO();

	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        			
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	billDateTime = dateFormat.format(d);
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	         	paymentTypeList2.add("CASH");
	        	paymentTypeList2.add("UPI");
	        	paymentTypeList2.add("RTGS");
	        	paymentTypeList2.add("NEFT");
	        	paymentTypeList2.add("CHEQUE");
	        	
	        	
	        	this.setChalanNumber("NA");
	        	this.setTripFrom("CRUSHER");
	        	this.setSendSMS(true);
	        	this.setDefaultValue("CREDIT");
	        	

	        	try {
					taxList = GetListResource.GetTaxList();
					
				} catch (IOException e) {
					
				}
	        	
	        	unitList = GetListResource.GetUnitList();
	        	billTypeList = GetListResource.GetBillTypeList();
	        	setBillType(billTypeList.get("TAX-INVOICE"));
	        	
	        	
	    		this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        
	        	
	        	this.setRateTyprDefaultValue("INCLUDINGGST");
	        	
	        	  discountTypeList.put("", "Select Discount Type");
			      discountTypeList.put("By Quantity", "By Quantity");
			      discountTypeList.put("By Percentage", "By Percentage");
			      discountTypeList.put("By Direct Amount", "By Direct Amount");
				
			    this.setDiscountType((String) this.getSessionMap().get("discountTypeForBilling"));
	    		
	        	this.setAccountList(GetAccountListForDrCr.getAccountList((this.getSessionMap()))); 
	    		
	  
				this.setBillNumber("NA");
				this.setAddSideBarJs("FALSE");
    				
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				this.getBillInfoDAO().setChalanNumber("NA");
	        	this.getBillInfoDAO().setBillDate(this.getBillDateTime());
	        	this.getBillInfoDAO().setBillNumber("NA");	        	
        		this.getBillInfoDAO().setPaymentType("CASH");
        		this.getBillInfoDAO().setBillType("TAX-INVOICE");
        		this.getBillInfoDAO().setCustomerName(this.getCustomerName());        		
	        	this.getBillInfoDAO().setBillSaved(false);
	        	this.getBillInfoDAO().setSendSMS(sendSMS);
	        	
	        	if(this.getBillInfoDAO().getTransportCharge() == null)
	        	{
	        		this.getBillInfoDAO().setTransportCharge(0.0F);
	        	}
	        	
	        	this.getBillInfoDAO().setTransportCharge(this.getTransportCharge());
	        	this.getBillInfoDAO().setComments(this.getComments());
	        	
				
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					this.setProductName("");
		        	this.setProductMarathiName("");
		        	this.setQuantity(0.0F);
		        	this.setSalesRate(0.0F);
		        	this.setAmount(0.0F);
		        	this.setDiscountRupees(0.0F);
		        	this.setAmountAfterDiscount(0.0F);
		        	this.setTransportCharge(0.0F);
		        	this.setSalesUnit("");
		        	//this.setTaxPercentage("");
		        
		        	this.setAmountPaid("0.0");	
		        	
		        	HashMap<String,BillProductInfoDAO> productMap = new HashMap<String,BillProductInfoDAO>();
		        	
					for(String challanNumber : this.getSelection())
					{
						ResultSet getProductDetailRS = null;
						PreparedStatement getProductDetailsPSMT = null;
						String getProductDetailsSQL = "SELECT "
		        				+ "product_id,"
		        				+ "product_name_eng,"
		        				+ "sale_unit,"
		        				+ "quantity,"
		        				+ "empty_weight,"
		        				+ "gross_weight "
		        				+ "FROM "
		        				+ "challan_product_details "
		        				+ "WHERE "
		        				+ "challan_number = ? "
		        				+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
		        		
						getProductDetailsPSMT = connection.prepareStatement(getProductDetailsSQL);
						getProductDetailsPSMT.setString(1, challanNumber);
						getProductDetailsPSMT.setString(2, crusherId);
						getProductDetailsPSMT.setString(3, crusherCode);
        				
		        		getProductDetailRS = getProductDetailsPSMT.executeQuery();
		        		
		        		while(getProductDetailRS.next())
		        		{
		        			if(productMap.get(getProductDetailRS.getString(1)) == null)
		        			{

			    	        	BillProductInfoDAO billProductInfoDAO = new BillProductInfoDAO();
			    	        	
			    	        	this.getBillVehicleInfoDAO().setProductId(getProductDetailRS.getString(1));
				        		this.getBillVehicleInfoDAO().setProductName(getProductDetailRS.getString(2));
				        		this.getBillVehicleInfoDAO().setProductQuantity(getProductDetailRS.getFloat(4));
				        
				        		
			    	        	billProductInfoDAO.setProductId(getProductDetailRS.getString(1));
			    	        	billProductInfoDAO.setProductName(getProductDetailRS.getString(2));
			    	        	billProductInfoDAO.setSalesUnit(getProductDetailRS.getNString(3));
			    	        	billProductInfoDAO.setTaxId("1");
			    	        	billProductInfoDAO.setSalesRate(0.0F);
			    	        	billProductInfoDAO.setQuantity(getProductDetailRS.getFloat(4));
			    	        	billProductInfoDAO.setDiscountPecentage(0.0F);
			    	        	billProductInfoDAO.setDiscountRupees(0.0F);
			    	        	billProductInfoDAO.setAmount(0.0F);
			    	        	billProductInfoDAO.setAmountAfterDiscount(0.0F);
			    	        	billProductInfoDAO.setAlias("");
			    	        	billProductInfoDAO.setProductTotalDiscount(0.0F);
			    	        	billProductInfoDAO.setAddedToDB(false);
			    	        	billProductInfoDAO.setTransportCharges(0.0f);
			    	          	billProductInfoDAO.setRoyalty(0.0f);
								  
			    	        	billProductInfoDAO.setVehicleEmptyWeight(getProductDetailRS.getFloat(5));
			    	        	billProductInfoDAO.setGrossWeight(getProductDetailRS.getFloat(6));
			    	        	
			    	        	productMap.put(getProductDetailRS.getString(1), billProductInfoDAO);
			        			
		        			}
		        			else
		        			{
		        				BillProductInfoDAO billProductInfoDAO = productMap.get(getProductDetailRS.getString(1));
			    	        	
			    	        	this.getBillVehicleInfoDAO().setProductId(getProductDetailRS.getString(1));
				        		this.getBillVehicleInfoDAO().setProductName(getProductDetailRS.getString(2));
				        		this.getBillVehicleInfoDAO().setProductQuantity(billProductInfoDAO.getQuantity() + getProductDetailRS.getFloat(4));
				        
				        		
			    	        	billProductInfoDAO.setProductId(getProductDetailRS.getString(1));
			    	        	billProductInfoDAO.setProductName(getProductDetailRS.getString(2));
			    	        	billProductInfoDAO.setSalesUnit(getProductDetailRS.getNString(3));
			    	        	billProductInfoDAO.setTaxId("1");
			    	        	billProductInfoDAO.setSalesRate(0.0F);
			    	        	billProductInfoDAO.setQuantity(billProductInfoDAO.getQuantity() + getProductDetailRS.getFloat(4));
			    	        	billProductInfoDAO.setDiscountPecentage(0.0F);
			    	        	billProductInfoDAO.setDiscountRupees(0.0F);
			    	        	billProductInfoDAO.setAmount(0.0F);
			    	        	billProductInfoDAO.setAmountAfterDiscount(0.0F);
			    	        	billProductInfoDAO.setAlias("");
			    	        	billProductInfoDAO.setProductTotalDiscount(0.0F);
			    	        	billProductInfoDAO.setAddedToDB(false);
			    	        	billProductInfoDAO.setTransportCharges(0.0f); 
			    	        	billProductInfoDAO.setRoyalty(0.0f);
					    	    
			    	        	billProductInfoDAO.setVehicleEmptyWeight(getProductDetailRS.getFloat(5));
			    	        	billProductInfoDAO.setGrossWeight(getProductDetailRS.getFloat(6));
			    	        	
			    	        	productMap.put(getProductDetailRS.getString(1), billProductInfoDAO);
		        			}
		        		}
					}
					
					
					for(String s : productMap.keySet())
					{
						this.getProductInfoList().add(productMap.get(s));
						
					}
					
					float floatTotalAmount = 0.0F;
		        	float floatTotalDiscount = 0.0F;
		        	float floatTotalAmtAfterDiscount = 0.0F;
		        
		        	
		        	
		        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
		        	{
		        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
		        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
		        		floatTotalDiscount = floatTotalDiscount + infoDAO.getProductTotalDiscount();
		        		
		        		
		        	}
		        	
	        		this.setBillSaved(false);
	        		
	        		
					this.getBillVehicleInfoDAO().setVehicleId("0");
	        		this.getBillVehicleInfoDAO().setVehicleMake("NA");
	        		this.getBillVehicleInfoDAO().setVehicleRCNumber("NA");
	        		this.getBillVehicleInfoDAO().setKmStart(0.0f);
	        		this.getBillVehicleInfoDAO().setKmEnd(0.0f);
	        		this.getBillVehicleInfoDAO().setTripFrom("CRUSHER");
	        		this.getBillVehicleInfoDAO().setTripTo("NA");
	        		this.getBillVehicleInfoDAO().setTotalKM(0.0f);
	        		this.getBillVehicleInfoDAO().setTotalTrips(0);
	        		
	        		this.getSessionMap().put("billInformation", this.getBillInfoDAO());
		        	this.getSessionMap().put("productList",  this.getProductInfoList());
		        	this.getSessionMap().put("billvehicleinfo", this.getBillVehicleInfoDAO());
		        	this.getSessionMap().put("dcselected", this.getSelection());
					
					
					result = SUCCESS;
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	@Override
	public void validate() {
		
		
		this.setAddSideBarJs("FALSE");
	
		if(this.getCustomerName() == null || this.getCustomerName().equals(""))
		{
			addActionError("Please select customer name !");
		}
		
		if(!hasActionErrors())
		{
		
			Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			String actualCustId = this.getCustomerName().split("-")[0];
			String actualCustName = this.getCustomerName().split("-")[1];
		
				
			String sql = "";
			String db = (String)  this.getSessionMap().get("db");
			
			try
			{
				connection = GetDBConnection.getDBConnection(db);
				
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    	
	    		HashMap<String,String> custInfoList = new HashMap<String,String> ();
				
				for(String challanNumber : this.getSelection())
				{
					sql = "SELECT "
							+ "customer_all_details "
							+ "FROM "
							+ "crusher_delivery_challan_master "
							+ "WHERE "
							+ "challan_number = ? "
							+ "AND "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? ";
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, challanNumber);
					preparedStatement.setString(2, crusherId);
					preparedStatement.setString(3, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					if(resultSet.next())
					{
						String custData [] = resultSet.getString(1).split("-");
						
						if(custInfoList.get(custData[0]) == null)
						{
							custInfoList.put(custData[0], custData[1]);
						}
					}
				}
				
				if(custInfoList.size() > 1)
				{
					addActionError("You have selected multiple customer's challan! Please slect chalan for only one customer!");
				}
				else
				{
					if(custInfoList.get(actualCustId) == null)
					{
						addActionError("Somthing went wrong! Customer details not matching! Please try again!");
					}
				}
				
				//System.out.println("Size : "+custInfoList.size());
			}
			catch (SQLException e) {
				
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
			}
			catch (Exception e) {
				
				addActionError(e.getMessage() +" || Something Went Wrong !");
			}
			finally {
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
		}
	}
	
	
	public List<String> getSelection() {
		return selection;
	}



	public void setSelection(List<String> selection) {
		this.selection = selection;
	}



	public String getBillDateTime() {
		return billDateTime;
	}



	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}



	public String getBillNumber() {
		return billNumber;
	}



	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}



	public String getChalanNumber() {
		return chalanNumber;
	}



	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}



	public Map<String, String> getTaxList() {
		return taxList;
	}



	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}



	public Map<String, String> getUnitList() {
		return unitList;
	}



	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}



	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}



	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}



	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}



	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}



	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}



	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}



	public String getDefaultValue() {
		return defaultValue;
	}



	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}



	public String getBillType() {
		return billType;
	}



	public void setBillType(String billType) {
		this.billType = billType;
	}



	public String getPrintType() {
		return printType;
	}



	public void setPrintType(String printType) {
		this.printType = printType;
	}



	public String getCustomerName() {
		return customerName;
	}



	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}



	public String getRoyalty() {
		return royalty;
	}



	public void setRoyalty(String royalty) {
		this.royalty = royalty;
	}



	public Map<String, String> getVehicleList() {
		return vehicleList;
	}



	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}



	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}



	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}



	public String getAddSideBarJs() {
		return addSideBarJs;
	}



	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}



	public String getTripFrom() {
		return tripFrom;
	}



	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}



	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}



	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}



	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}



	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}



	public String getRateType() {
		return rateType;
	}



	public void setRateType(String rateType) {
		this.rateType = rateType;
	}



	public String getKeyVehicle() {
		return keyVehicle;
	}



	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}



	public String getVehicleId() {
		return vehicleId;
	}



	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}



	public float getVehicleEmptyWeight() {
		return vehicleEmptyWeight;
	}



	public void setVehicleEmptyWeight(float vehicleEmptyWeight) {
		this.vehicleEmptyWeight = vehicleEmptyWeight;
	}



	public Boolean getIsFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}



	public void setIsFromVehicleEntryDetails(Boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}



	public boolean isViewBill() {
		return viewBill;
	}



	public void setViewBill(boolean viewBill) {
		this.viewBill = viewBill;
	}



	public String getDiscountType() {
		return discountType;
	}



	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}



	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}



	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}



	public Float getKmStart() {
		return kmStart;
	}



	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}



	public Float getKmEnd() {
		return kmEnd;
	}



	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}



	public Float getTotalKm() {
		return totalKm;
	}



	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}



	public Integer getTotalTrips() {
		return totalTrips;
	}



	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}



	public boolean isSendSMS() {
		return sendSMS;
	}



	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}



	public static long getSerialversionuid() {
		return serialVersionUID;
	}



	public String getTripDate() {
		return tripDate;
	}

	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public Float getMaterialVolume() {
		return materialVolume;
	}

	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}

	public String getOperator() {
		return operator;
	}

	public void setOperator(String operator) {
		this.operator = operator;
	}

	public String getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public String getProductMarathiName() {
		return productMarathiName;
	}

	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}

	public String getAlias() {
		return alias;
	}

	public void setAlias(String alias) {
		this.alias = alias;
	}

	public String getSalesUnit() {
		return salesUnit;
	}

	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}

	public String getTaxPercentage() {
		return taxPercentage;
	}

	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}

	public Float getSalesRate() {
		return salesRate;
	}

	public void setSalesRate(Float salesRate) {
		this.salesRate = salesRate;
	}

	public Float getQuantity() {
		return quantity;
	}

	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}

	public Float getDiscountPercentage() {
		return discountPercentage;
	}

	public void setDiscountPercentage(Float discountPercentage) {
		this.discountPercentage = discountPercentage;
	}

	public Float getDiscountRupees() {
		return discountRupees;
	}

	public void setDiscountRupees(Float discountRupees) {
		this.discountRupees = discountRupees;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public Float getAmountAfterDiscount() {
		return amountAfterDiscount;
	}

	public void setAmountAfterDiscount(Float amountAfterDiscount) {
		this.amountAfterDiscount = amountAfterDiscount;
	}

	public Float getTransportCharge() {
		return transportCharge;
	}

	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}

	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}

	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}

	public Float getTotalPaybleAmount() {
		return totalPaybleAmount;
	}

	public void setTotalPaybleAmount(Float totalPaybleAmount) {
		this.totalPaybleAmount = totalPaybleAmount;
	}

	public String getAmountPaid() {
		return amountPaid;
	}

	public void setAmountPaid(String amountPaid) {
		this.amountPaid = amountPaid;
	}

	public Blob getVehicleImage1PDF() {
		return vehicleImage1PDF;
	}

	public void setVehicleImage1PDF(Blob vehicleImage1PDF) {
		this.vehicleImage1PDF = vehicleImage1PDF;
	}

	public Blob getVehicleImage2PDF() {
		return vehicleImage2PDF;
	}

	public void setVehicleImage2PDF(Blob vehicleImage2PDF) {
		this.vehicleImage2PDF = vehicleImage2PDF;
	}

	public Blob getVehicleImage3PDF() {
		return vehicleImage3PDF;
	}

	public void setVehicleImage3PDF(Blob vehicleImage3PDF) {
		this.vehicleImage3PDF = vehicleImage3PDF;
	}

	
	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}

	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}

	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}

	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}

	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}

	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}

	public boolean isBillSaved() {
		return billSaved;
	}

	public void setBillSaved(boolean billSaved) {
		this.billSaved = billSaved;
	}

	public boolean isDisplayDCPhotos() {
		return displayDCPhotos;
	}

	public void setDisplayDCPhotos(boolean displayDCPhotos) {
		this.displayDCPhotos = displayDCPhotos;
	}

	public boolean isGenerateBillForDc() {
		return generateBillForDc;
	}

	public void setGenerateBillForDc(boolean generateBillForDc) {
		this.generateBillForDc = generateBillForDc;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}

	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



