package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.DayWiseCollectionDAO;
import com.stonecrusher.db.GetDBConnection;

public class CollectionReportJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8703987118265094121L;
	private String fromDate;
	private String toDate;
	private HttpSession session;
	private List<DayWiseCollectionDAO> collectionDAOList = new ArrayList<DayWiseCollectionDAO>();
	private String addSideBarJs;
	private List<String> downloadTypeList = new ArrayList<String>();
	
	@Override
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		

	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	this.setFromDate(dateFormat.format(d));
	        	this.setToDate(dateFormat.format(d));
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			DayWiseCollectionDAO collectionDAO = new DayWiseCollectionDAO();
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			
	    			// cash collection 
	    			sql = "SELECT "
	    					+ "DATE_FORMAT(bill_date, '%d-%M-%Y'),"
	    					+ "bill_total_amount,"
	    					+ "bill_amount_received,"
	    					+ "bill_amount_return "
	    					+ "FROM "
	    					+ "crusher_bill_info_master "
	    					+ "WHERE "
	    					+ "bill_date = STR_TO_DATE(?, '%d-%m-%Y') "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    			
	    			
	    			preparedStatement =connection.prepareStatement(sql);
	    			preparedStatement.setString(1, this.getFromDate());
	    			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
	    		
	    			float totalBillAmount = 0.0F;
	    			float totalCreditGiven = 0.0F;
	    			float totalAmountCollected = 0.0F;
	    			float totalCreditCollection =0.0F;
	    			while(resultSet.next())	    				
	    			{
	    				
    				if(resultSet.getString(2) != null && resultSet.getString(3) != null && resultSet.getString(4) != null)
    				{
	    				totalBillAmount = totalBillAmount + (Float.parseFloat(resultSet.getString(2)));
	    				
	    				float amtReceived = Float.parseFloat(resultSet.getString(3));
	    				float amountReturn  = Float.parseFloat(resultSet.getString(4));
	    				
	    				if(amountReturn > 0 )
	    				{
	    					totalAmountCollected = totalAmountCollected + Float.parseFloat(resultSet.getString(2));
	    				}
	    				else
	    				{
	    					totalAmountCollected = totalAmountCollected + amtReceived;
	    					totalCreditGiven = totalCreditGiven 
	    							+ (Float.parseFloat(resultSet.getString(2)) - amtReceived);
	    				}
	    				
	    			}
	    			}
	    			
	    			
	    			
	    			sql = "SELECT sum(amount) "
	    					+ "FROM "
	    					+ "crusher_customer_payment_details_master "
	    					+ "where "
	    					+ "payment_date = STR_TO_DATE(?, '%d-%m-%Y') "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    			
	    			
	    			PreparedStatement ps = connection.prepareStatement(sql);
	    			
	    			ps.setString(1, this.getFromDate());
	    			ps.setString(2, crusherId);
	    			ps.setString(3, crusherCode);
    				
	    			ResultSet rs =  ps.executeQuery();
	    		
	    			
	    			if(rs.next())
	    			{
	    				if(rs.getString(1) != null)
	    				{
	    				
	    					totalCreditCollection = Float.parseFloat(rs.getString(1));
	    				}
	    				else
	    				{
	    					totalCreditCollection = 0.0F;
	    				}
	    			}
	    			
	    			collectionDAO.setCollectionDate(getFromDate());
	    			collectionDAO.setTotalBilling(""+totalBillAmount);
	    			collectionDAO.setTotalCashCollection(""+totalAmountCollected);
	    			collectionDAO.setTotalCreditCollection(""+totalCreditCollection);
	    			collectionDAO.setTotalCreeditGiven(""+totalCreditGiven);
	    			collectionDAO.setTotalCollection(""+(totalCreditCollection+totalAmountCollected));
	    			collectionDAOList.add(collectionDAO);
	    		
	    			downloadTypeList.add("pdf");
		        	downloadTypeList.add("xl");
		        	
		        	
		        	
	    			result ="success";
	    			
	    			if(rs != null)
	    			{
	    				rs.close();
	    				rs  = null;
	    			}
	    			
	    			if(ps != null)
	    			{
	    				ps.close();
	    				ps = null;
	    			}
	    			
	    			this.setAddSideBarJs("FALSE");
	    		}
	    		 catch (SQLException e) {
		    			
		    			result = "error";
		    			
		    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
		    		} catch (IOException e) {
		    			result = "error";
		    			
		    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
		    		}finally {
		    			if(resultSet != null)
	    				{
	    					try {
	    						resultSet.close(); resultSet= null;
	    					} catch (SQLException e) {
	    						
	    					}
	    				}
		    			if(preparedStatement != null)
		    			{
		    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		    			}
		    			if(connection != null)
		    			{
		    				
		    				try {connection.close(); connection= null;}catch (SQLException e) {}
		    			}
		    			
		    		}
	        	
	        	
	        	
	        	
	        }
	        
	        return result;
	}
	public String getFromDate() {
		return fromDate;
	}
	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}
	public String getToDate() {
		return toDate;
	}
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public List<DayWiseCollectionDAO> getCollectionDAOList() {
		return collectionDAOList;
	}
	public void setCollectionDAOList(List<DayWiseCollectionDAO> collectionDAOList) {
		this.collectionDAOList = collectionDAOList;
	}
	public String getAddSideBarJs() {
		return addSideBarJs;
	}
	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}
	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}
	
	

}
