package com.stonecrusher.jspRedirect;


import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;


public class AddRmcBillJsp extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7362899112859144172L;
	private HttpSession session;
	private String billDateTime;
	private String billNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private String tripFrom;
	private String addSideBarJs;

	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
     private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();
	
	
	   private Float tenmm;
	   private Float twentymm;
	   private Float crushsand;
	   private Float washsand;
	   private Float water;
	   private Float addmixture;
	   private Float cementOPC;
	   private Float cementPPC;
	   
	   private String chalanNumber;
	   

	   private Float pumpAmount;
	   private Float labourAmount;
	   private Float kmStart;
		private Float kmEnd;
		private Float totalKm;
		private Integer totalTrips;
		
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	this.setAddSideBarJs("FALSE");
		    	 
	        	this.setTripFrom("RMC-PLANT");
	        	
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	billDateTime = dateFormat.format(d);
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	
	        	this.setTenmm(0.0f);
	        	this.setTwentymm(0.0f);
	        	this.setWashsand(0.0f);
	        	this.setCrushsand(0.0f);
	        	this.setAddmixture(0.0f);
	        	this.setWater(0.0f);
	        	this.setCementOPC(0.0f);
	        	this.setCementPPC(0.0f);
	        	
	        	this.setChalanNumber("NA");
	        	
	        	this.setLabourAmount(0.0f);
	        	this.setPumpAmount(0.0f);
	        	
	        	
	        	this.setDefaultValue("CREDIT");
	        	
	        	 discountTypeList.put("", "Select Discount Type");
			      discountTypeList.put("By Quantity", "By Quantity");
			      discountTypeList.put("By Percentage", "By Percentage");
			      discountTypeList.put("By Direct Amount", "By Direct Amount");
					this.setDiscountType((String) session.getAttribute("discountTypeForBilling"));
					

	        	try {
					taxList = GetListResource.GetTaxList();
					
				} catch (IOException e) {
					
				}
	        	
	        	unitList = GetListResource.GetUnitList();
	        	billTypeList = GetListResource.GetBillTypeList();
	        	setBillType(billTypeList.get("BILL-OF-SUPPLY"));
	        	billNumber = "1";
	        	
	        	

	    		this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        
	        	
	        	this.setRateTyprDefaultValue("INCLUDINGGST");
	        	
	        	 this.setKmStart(0.0f);
    			 this.setKmEnd(0.0f);
    			 this.setTotalKm(0.0f);
    			 this.setTotalTrips(1);
	        	
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    		session=ServletActionContext.getRequest().getSession(false); 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		 String crusherId = (String) session.getAttribute("crusherId");
					String crusherCode = (String) session.getAttribute("crusherCode");

	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			sql = "select customer_name "
	    					+ "from crusher_customer_master where customer_name like '%CASH%' "
	    					+ "AND crusher_id = ? "
	    			        + "AND crusher_code = ?";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId); 
	    			preparedStatement.setString(2, crusherCode); 

	    			resultSet = preparedStatement.executeQuery();
	    			
	    			while(resultSet.next())
	    			{
	    				setCustomerName(resultSet.getString(1));
	    			}
	    			
	    			
	    			
	    			if(resultSet != null)
	    			{
	    				resultSet.close();
	    				resultSet = null;
	    			}
	    			
	    			if(preparedStatement != null)
	    			{
	    				preparedStatement.close();
	    				preparedStatement = null;
	    				
	    			}
	    			
	    			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "crusher_vehicle_details_master "
	    					+ "WHERE "
	    			        + "crusher_id = ? "
	    			        + "AND crusher_code = ?";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId); 
	    			preparedStatement.setString(2, crusherCode); 

	    			
	    			resultSet = preparedStatement.executeQuery();


	    			while(resultSet.next())
	    			{
	    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
	    			}
	    			
	    		
	    			
	    				setBillNumber("NA");
	    				
	    				
	    			result = "success";
	    			
	    		} catch (SQLException e) {
	    			//e.printStackTrace();
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || " +this.getText("message.error.somethingWentWrong"));
	    		} catch (IOException e) {
	    			result = "error";
	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {resultSet.close();resultSet = null;} catch (SQLException e) {}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        		      
	        	
	        }

	        return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getBillDateTime() {
		return billDateTime;
	}

	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	


	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}

	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}

	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public Map<String, String> getVehicleList() {
		return vehicleList;
	}

	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}

	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}

	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getTripFrom() {
		return tripFrom;
	}

	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}

	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}

	public String getRateType() {
		return rateType;
	}

	public void setRateType(String rateType) {
		this.rateType = rateType;
	}

	public String getDiscountType() {
		return discountType;
	}

	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}

	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}

	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}

	public Float getTenmm() {
		return tenmm;
	}

	public void setTenmm(Float tenmm) {
		this.tenmm = tenmm;
	}

	public Float getTwentymm() {
		return twentymm;
	}

	public void setTwentymm(Float twentymm) {
		this.twentymm = twentymm;
	}

	public Float getCrushsand() {
		return crushsand;
	}

	public void setCrushsand(Float crushsand) {
		this.crushsand = crushsand;
	}

	public Float getWashsand() {
		return washsand;
	}

	public void setWashsand(Float washsand) {
		this.washsand = washsand;
	}

	public Float getWater() {
		return water;
	}

	public void setWater(Float water) {
		this.water = water;
	}

	public Float getAddmixture() {
		return addmixture;
	}

	public void setAddmixture(Float addmixture) {
		this.addmixture = addmixture;
	}

	public Float getCementOPC() {
		return cementOPC;
	}

	public void setCementOPC(Float cementOPC) {
		this.cementOPC = cementOPC;
	}

	public Float getCementPPC() {
		return cementPPC;
	}

	public void setCementPPC(Float cementPPC) {
		this.cementPPC = cementPPC;
	}

	public String getChalanNumber() {
		return chalanNumber;
	}

	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}

	public Float getPumpAmount() {
		return pumpAmount;
	}

	public void setPumpAmount(Float pumpAmount) {
		this.pumpAmount = pumpAmount;
	}

	public Float getLabourAmount() {
		return labourAmount;
	}

	public void setLabourAmount(Float labourAmount) {
		this.labourAmount = labourAmount;
	}

	public Float getKmStart() {
		return kmStart;
	}

	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}

	public Float getKmEnd() {
		return kmEnd;
	}

	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}

	public Float getTotalKm() {
		return totalKm;
	}

	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}

	public Integer getTotalTrips() {
		return totalTrips;
	}

	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}

	
	
	
	
	
	
	
	
	
}
