package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.TaxDAO;
import com.stonecrusher.db.GetDBConnection;

public class AddNewTaxJsp extends ActionSupport{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 5953849125972373414L;
	private HttpSession session;
	private List<TaxDAO> taxList = new ArrayList<TaxDAO>();
	
	@Override
	public String execute() throws Exception {
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else
	        {
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				
				String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
				try
				{
					connection = new GetDBConnection().getDBConnection(db);					
					
					sql = "SELECT tax_name, tax_percentage "
						    + "FROM crusher_tax_table "
						    + "WHERE crusher_id = ? "
						    + "AND crusher_code = ? "
						    + "ORDER BY tax_percentage";

					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, crusherId);
    				preparedStatement.setString(2, crusherCode);
    				
    				
					resultSet = preparedStatement.executeQuery();
					int serial = 1;
					while(resultSet.next())
					{
						TaxDAO taxDAO = new TaxDAO();
						taxDAO.setSerial(""+serial);
						taxDAO.setTaxName(resultSet.getString(1));
						taxDAO.setTaxPercentage((String)resultSet.getString(2));
						taxList.add(taxDAO);
						serial++;
					}
					
					result = "success";
					
					
				} catch (SQLException e) {
					result = "error";
					e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() );
				} catch (IOException e) {
					result = "error";
					e.printStackTrace();
					addActionError(e.getMessage()+" || "+e.getCause());
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
	        	
	        }
		
		return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public List<TaxDAO> getTaxList() {
		return taxList;
	}

	public void setTaxList(List<TaxDAO> taxList) {
		this.taxList = taxList;
	}
	
	

}
