package com.stonecrusher.jspRedirect;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.ServletRequestAware;
import org.apache.struts2.interceptor.ServletResponseAware;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class AddNewDCJsp extends ActionSupport implements SessionAware ,ServletRequestAware,ServletResponseAware {


	/**
	 * 
	 */
	private static final long serialVersionUID = 4063705789066672716L;
	private HttpSession session;
	private String challanDateTime;
	private String chalanNumber;
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String paymentType;
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private String billType;
	private String printType;
	private String customerName;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private String addSideBarJs;
	private String tripFrom;
	private SessionMap<String,Object> sessionMap;
	private HttpServletRequest request = null;
	private HttpServletResponse response = null;	
	private Boolean isFromVehicleEntryDetails ;
	
	private String alternateMobileNumber;
	private String comments;
	private String keyVehicle;
	private String vehicleId;
	private float vehicleEmptyWeight = 0.0f;
	private boolean viewChallan;
	
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	this.setChallanDateTime(dateFormat.format(d));
	       
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	this.setChalanNumber("NA");
	        	this.setTripFrom("CRUSHER");
	        	
	        	this.setPaymentType("CREDIT");
	        	

	        	unitList = GetListResource.GetUnitList();
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    		session=ServletActionContext.getRequest().getSession(false); 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		boolean requestFromAndroid = false;
		        Map<String, String> map = new HashMap<String, String>();

		        Enumeration <String> headerNames = this.getRequest().getHeaderNames();
		        
		        while (headerNames.hasMoreElements()) {
		            String key = (String) headerNames.nextElement();
		            String value = this.getRequest().getHeader(key);
		            map.put(key, value);
		        }
		        //Android
		        String ua = "";
		      for(String key:map.keySet())
		      {
		    	  if(key.equals("user-agent")){
		    		  
		    		  ua = map.get(key);	    		  
		    		
		    		  if(ua.contains("Android")){
		    			  requestFromAndroid = true;
		    		  }
		    	  }
		      }
		     
	    		
	    		try
	    		{
	    
	    			this.setAlternateMobileNumber("NA");
	    			this.setComments("NA");
	    			       
					connection = GetDBConnection.getDBConnection(db);
	    			sql = "SELECT customer_name "
	    					+ "FROM crusher_customer_master where customer_name like '%CASH%'"
	    					+ "AND crusher_id = ? "
	    				    + "AND crusher_code = ?";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
	    			
	    			while(resultSet.next())
	    			{
	    				this.setCustomerName(resultSet.getString(1));
	    			}
	    			
	    			
	    			
	    			if(resultSet != null)
	    			{
	    				resultSet.close();
	    				resultSet = null;
	    			}
	    			
	    			if(preparedStatement != null)
	    			{
	    				preparedStatement.close();
	    				preparedStatement = null;
	    				
	    			}
	    			
	    			sql = "SELECT "
	    					+ "vehicle_id,"
	    					+ "vehicle_make,"
	    					+ "vehicle_registration_number "
	    					+ "FROM "
	    					+ "crusher_vehicle_details_master "
	    					+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    			
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();


	    			while(resultSet.next())
	    			{
	    				this.getVehicleList().put(resultSet.getString(1), resultSet.getString(2)+" | "+resultSet.getString(3));
	    			}
	    			
	    			
	    			 if(isFromVehicleEntryDetails == null) {
	    				 isFromVehicleEntryDetails = false;
	   		    	  
	   		    	 	
	   		    	  
	   		      }else {
	   		    	  
	   		    	sql = "SELECT vehicle_id,"
   		    	  		    + "vehicle_name,"
   		    	  		    + "vehicle_reg_no,"
   		    	  		    + "empty_weight "
   	    					+ "FROM crusher_vehicle_entry_details where entry_id = ? "
   	    					+ "AND crusher_id = ? "
   	    				    + "AND crusher_code = ?";
   	    			
   	    			preparedStatement = connection.prepareStatement(sql);
   	    			preparedStatement.setString(1, EncryptionDecryption.decrypt(this.getKeyVehicle()));
   	    			preparedStatement.setString(2, crusherId);
   					preparedStatement.setString(3, crusherCode);
   					
   					resultSet = preparedStatement.executeQuery();
   	    			
   	    			while(resultSet.next())
   	    			{
   	    				this.setVehicleId(resultSet.getString(1)+"-"+resultSet.getString(2)+"-"+resultSet.getString(3));
   	    			    this.setVehicleEmptyWeight(resultSet.getFloat(4));
   	    			}
   	    			
	   		    	  
	   		      }
	    			
	    			
	    			this.setAddSideBarJs("FALSE");
	    				
	    			 if(requestFromAndroid)
	 	        	{
	 	        		result = "android-success";
	 	        	}else{
	 	        		 result = SUCCESS;
	 	        	}	
	    			
	    		} catch (SQLException e) {
	    			
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
	    		} catch (IOException e) {
	    			result = "error";
	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        		      
	        	
	        }

	      return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}

	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public Map<String, String> getVehicleList() {
		return vehicleList;
	}

	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}

	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}

	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getChalanNumber() {
		return chalanNumber;
	}

	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}

	public String getTripFrom() {
		return tripFrom;
	}

	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}

	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public String getChallanDateTime() {
		return challanDateTime;
	}

	public void setChallanDateTime(String challanDateTime) {
		this.challanDateTime = challanDateTime;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	public String getPaymentType() {
		return paymentType;
	}

	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}
	
	


	public HttpServletRequest getRequest() {
		return request;
	}
	
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	
	public HttpServletResponse getResponse() {
		return response;
	}
	
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	
	@Override
	public void setServletResponse(HttpServletResponse httpServletResponse) {
		this.response = httpServletResponse;
	}
	
	@Override
	public void setServletRequest(HttpServletRequest httpServletRequest) {
		this.request = httpServletRequest;
	}

	public String getAlternateMobileNumber() {
		return alternateMobileNumber;
	}

	public void setAlternateMobileNumber(String alternateMobileNumber) {
		this.alternateMobileNumber = alternateMobileNumber;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

	public Boolean getIsFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}

	public void setIsFromVehicleEntryDetails(Boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}

	public String getKeyVehicle() {
		return keyVehicle;
	}

	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	
	public float getVehicleEmptyWeight() {
		return vehicleEmptyWeight;
	}

	public void setVehicleEmptyWeight(float vehicleEmptyWeight) {
		this.vehicleEmptyWeight = vehicleEmptyWeight;
	}

	public boolean isViewChallan() {
		return viewChallan;
	}

	public void setViewChallan(boolean viewChallan) {
		this.viewChallan = viewChallan;
	}

	

	
	
	
	
	
}
