package com.stonecrusher.jspRedirect;


import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;


public class AddNewBillJsp extends ActionSupport  implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 7362899112859144172L;
	private HttpSession session;
	private String billDateTime;
	private String billNumber;
	private String chalanNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> printTypeList = new LinkedHashMap<String,String>();
	private String defaultValue;
	private String billType;
	private String printType;
	private String customerName;
	private String royalty;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();
	private String addSideBarJs;
	private String tripFrom;
	private SessionMap<String,Object> sessionMap;
	
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	private String keyVehicle;
	private String vehicleId;
	private float vehicleEmptyWeight = 0.0f;
	private Boolean isFromVehicleEntryDetails ;
	private boolean viewBill;
    private String discountType;
    
	private Map<String,String> discountTypeList = new HashMap<String,String>();
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private Integer totalTrips;
	

	
	private boolean sendSMS;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        
	        	
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
	    		
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	billDateTime = dateFormat.format(d);
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	
	        	this.setChalanNumber("NA");
	        	this.setTripFrom("CRUSHER");
	        	this.setSendSMS(true);
	        	this.setDefaultValue("CREDIT");
	        	

	        	try {
					taxList = GetListResource.GetTaxList();
					
				} catch (IOException e) {
					
				}
	        	
	        	unitList = GetListResource.GetUnitList();
	        	billTypeList = GetListResource.GetBillTypeList();
	        	setBillType(billTypeList.get("BILL-OF-SUPPLY"));
	        	billNumber = "1";
	        	
	        	
	    		this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	        
	        	
	        	this.setRateTyprDefaultValue("INCLUDINGGST");
	        	
	        	 discountTypeList.put("", "Select Discount Type");
			      discountTypeList.put("By Quantity", "By Quantity");
			      discountTypeList.put("By Percentage", "By Percentage");
			      discountTypeList.put("By Direct Amount", "By Direct Amount");
					this.setDiscountType((String) this.getSessionMap().get("discountTypeForBilling"));
					
					
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    		session=ServletActionContext.getRequest().getSession(false); 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			sql = "SELECT customer_name "
	    					+ "FROM crusher_customer_master where customer_name like '%CASH%'"
	    					+ "AND crusher_id = ? "
	    					+ "AND crusher_code = ?";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId); 
	    			preparedStatement.setString(2, crusherCode); 
	    			
	    			resultSet = preparedStatement.executeQuery();
	    			
	    			while(resultSet.next())
	    			{
	    				setCustomerName(resultSet.getString(1));
	    			}
	    			
	    			
	    			
	    			this.getSessionMap().remove("productList");
					this.getSessionMap().remove("billInformation");
					this.getSessionMap().remove("deletedProductList");
					this.getSessionMap().remove("purchaseProductList");
					this.getSessionMap().remove("purchaseInformation");
					this.getSessionMap().remove("finishedProductInfoList");
					this.getSessionMap().remove("deletedProductInfoList");
					this.getSessionMap().remove("billvehicleinfo");
					this.getSessionMap().remove("challanProductList");
					this.getSessionMap().remove("challanInformation");
					this.getSessionMap().remove("challanVehicleinfo");
					this.getSessionMap().remove("quotationInformation");
					this.getSessionMap().remove("quotationProductList");
					this.getSessionMap().remove("RMCProductList");
					this.getSessionMap().remove("RMCBillInformation");
					this.getSessionMap().remove("RMCBillvehicleinfo");					
					this.getSessionMap().remove("dcselected");
					
	    			 this.setKmStart(0.0f);
	    			 this.setKmEnd(0.0f);
	    			 this.setTotalKm(0.0f);
	    			 this.setTotalTrips(1);
	    			 this.setRoyalty("0");
	    			
	    				this.setBillNumber("NA");
	    				this.setAddSideBarJs("FALSE");
	    				
	    			result = "success";
	    			
	    		} catch (SQLException e) {
	    			
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.somethingWentWrong"));
	    		} catch (IOException e) {
	    			result = "error";
	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || "+this.getText("message.error.somethingWentWrong"));
	    		}finally {
	    			if(resultSet != null)
    				{
    					try {
    						resultSet.close(); resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
	        		      
	        	
	        }

	        return result;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getBillDateTime() {
		return billDateTime;
	}

	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public Map<String, String> getTaxList() {
		return taxList;
	}

	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}

	public Map<String, String> getUnitList() {
		return unitList;
	}

	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}

	


	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}

	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public Map<String, String> getPrintTypeList() {
		return printTypeList;
	}

	public void setPrintTypeList(Map<String, String> printTypeList) {
		this.printTypeList = printTypeList;
	}

	public String getPrintType() {
		return printType;
	}

	public void setPrintType(String printType) {
		this.printType = printType;
	}

	public String getCustomerName() {
		return customerName;
	}

	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}

	public Map<String, String> getVehicleList() {
		return vehicleList;
	}

	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}

	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}

	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

	public String getChalanNumber() {
		return chalanNumber;
	}

	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}

	public String getTripFrom() {
		return tripFrom;
	}

	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}

	
	
	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}

	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}

	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}

	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}

	public String getRateType() {
		return rateType;
	}

	public void setRateType(String rateType) {
		this.rateType = rateType;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public String getRoyalty() {
		return royalty;
	}

	public void setRoyalty(String royalty) {
		this.royalty = royalty;
	}

	public String getKeyVehicle() {
		return keyVehicle;
	}

	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	

	public float getVehicleEmptyWeight() {
		return vehicleEmptyWeight;
	}

	public void setVehicleEmptyWeight(float vehicleEmptyWeight) {
		this.vehicleEmptyWeight = vehicleEmptyWeight;
	}

	public Boolean getIsFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}

	public void setIsFromVehicleEntryDetails(Boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}

	public boolean isViewBill() {
		return viewBill;
	}

	public void setViewBill(boolean viewBill) {
		this.viewBill = viewBill;
	}

	public String getDiscountType() {
		return discountType;
	}

	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}

	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}

	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}

	public Float getKmStart() {
		return kmStart;
	}

	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}

	public Float getKmEnd() {
		return kmEnd;
	}

	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}

	public Float getTotalKm() {
		return totalKm;
	}

	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}

	public Integer getTotalTrips() {
		return totalTrips;
	}

	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}

	public boolean isSendSMS() {
		return sendSMS;
	}

	public void setSendSMS(boolean sendSMS) {
		this.sendSMS = sendSMS;
	}

	
	
	
	
	
	
	
	
	
}
