package com.stonecrusher.jspRedirect;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;

public class AddDailyExpenseJsp extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3033701479232199987L;
	private HttpSession session;
	private String expenseDate;
	private List<String> paymentTypeList = new ArrayList<String>();
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	private Map<String,String> accountHeadList = new HashMap<String,String>();
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private SessionMap<String,Object> sessionMap;
	
	
	
	private Map<String,String> siteList = new LinkedHashMap<String,String>();
	
	private String expenseReason;
	private Float amount;
	private String typeOfPayment;
	private String accountId;
	private String description;
	
	private String chequePayDate;
	private String chequePayee;
	private String bankName;
	private String branchName;
	private String chequeNumber;
	private String addSideBarJs;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	setExpenseDate(dateFormat.format(d));
	        	paymentTypeList.add("CASH");
	        	paymentTypeList.add("UPI");
	        	paymentTypeList.add("RTGS");
	        	paymentTypeList.add("NEFT");
	        	paymentTypeList.add("CHEQUE");
	        
	        	
					this.setAccountHeadList(GetListResource.getAccountHeadList());
					this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));       
				 
					this.setSiteList(GetListResource.getSiteList());
	        
	        	
	        	this.setExpenseReason("");
	        	this.setAmount(0.0F);
	        	this.setTypeOfPayment("CASH");
	        	this.setAccountId("");
	        	this.setChequePayDate("");
	        	this.setChequePayee("");
	        	this.setBranchName("");
	        	this.setBranchName("");
	        	this.setChequeNumber("");
	        	this.setDescription("");
	        	this.setAddSideBarJs("FALSE");
	        	result = "success";
	        }
	        return result;
	}

	public Map<String, String> getAccountHeadList() {
		return accountHeadList;
	}

	public void setAccountHeadList(Map<String, String> accountHeadList) {
		this.accountHeadList = accountHeadList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}

	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getExpenseDate() {
		return expenseDate;
	}

	public void setExpenseDate(String expenseDate) {
		this.expenseDate = expenseDate;
	}

	public List<String> getBankList() {
		return bankList;
	}

	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}

	public List<String> getBranchList() {
		return branchList;
	}

	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}

	public List<String> getChequeList() {
		return chequeList;
	}

	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}

	public Map<String, String> getAccountList() {
		return accountList;
	}

	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}

	public String getExpenseReason() {
		return expenseReason;
	}

	public void setExpenseReason(String expenseReason) {
		this.expenseReason = expenseReason;
	}

	public Float getAmount() {
		return amount;
	}

	public void setAmount(Float amount) {
		this.amount = amount;
	}

	public String getTypeOfPayment() {
		return typeOfPayment;
	}

	public void setTypeOfPayment(String typeOfPayment) {
		this.typeOfPayment = typeOfPayment;
	}

	public String getAccountId() {
		return accountId;
	}

	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public String getChequePayDate() {
		return chequePayDate;
	}

	public void setChequePayDate(String chequePayDate) {
		this.chequePayDate = chequePayDate;
	}

	public String getChequePayee() {
		return chequePayee;
	}

	public void setChequePayee(String chequePayee) {
		this.chequePayee = chequePayee;
	}

	public String getBankName() {
		return bankName;
	}

	public void setBankName(String bankName) {
		this.bankName = bankName;
	}

	public String getBranchName() {
		return branchName;
	}

	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}

	public String getChequeNumber() {
		return chequeNumber;
	}

	public void setChequeNumber(String chequeNumber) {
		this.chequeNumber = chequeNumber;
	}
	

public String getAddSideBarJs() {
		return addSideBarJs;
	}

	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}

public Map<String, String> getSiteList() {
		return siteList;
	}

	public void setSiteList(Map<String, String> siteList) {
		this.siteList = siteList;
	}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

	
}
