package com.stonecrusher.jspRedirect;


import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.opensymphony.xwork2.ActionSupport;

public class AddBoulderSuppPaymentDetailsJsp extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8776383375067969395L;
	private SessionMap<String,Object> sessionMap;
	
	private String key;
	private String paymentDate;
	private String boulderSupplierId;
	private String boulderSupplierName;
	private String boulderSupplierMobile;
	private String debtAmount;

	
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeList = new ArrayList<String>();
	
	
	
	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList = new ArrayList<String>();
	private String addSideBarJs;
	
	public String execute() {
		 
		String result = "login";
	
		
	        if(this.getSessionMap()==null || this.getSessionMap().get("login")==null){ 
	        	addActionMessage("Please Logout and Login again !");
	        	result = "login";
	        }  
	        else{
	        	
	        	this.setAddSideBarJs("FALSE");
	        			
	          	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    
	         	Date d = new Date();
	        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
	        	
	        	setPaymentDate(dateFormat.format(d));
	        		
	       		paymentTypeList.add("CASH");
	        	paymentTypeList.add("UPI");
	        	paymentTypeList.add("RTGS");
	        	paymentTypeList.add("NEFT");
	        	paymentTypeList.add("CHEQUE");
	       				
	      	
				Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					this.setAccountList(GetAccountListForDrCr.getAccountList(this.getSessionMap()));
		       		
	       			
	       			String boulderSupplierId = EncryptionDecryption.decrypt(key);
	       			
	       			float openingBal = 0.0F;
	       			PreparedStatement getOpeningBalPSMT = null;
       				ResultSet getOpeningBalRs = null;
       				String getOpeningBalSQL = "SELECT "
       						+ "opening_balance "
       						+ "FROM "
       						+ "crusher_boulder_supplier_close_open_bal_master "
       						+ "WHERE "
       						+ "boulder_supplier_id = ? "
       						+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
       				
       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
       				
       				getOpeningBalPSMT.setString(1, boulderSupplierId);
       				getOpeningBalPSMT.setString(2, crusherId);
       				getOpeningBalPSMT.setString(3, crusherCode);
    				
       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
       				
       				if(getOpeningBalRs.next())
       				{
       					openingBal = getOpeningBalRs.getFloat(1);
       				}
       				else
       				{
       					openingBal = 0.0F;
       				}
       				
       				if(getOpeningBalRs != null)
       				{
       					getOpeningBalRs.close();
       					getOpeningBalRs = null;
       				}
       				if(getOpeningBalPSMT != null)
       				{
       					getOpeningBalPSMT.close();
       					getOpeningBalPSMT = null;
       				}

	       		
	       			
	       			sql = "SELECT "
	       					+ "boulder_supplier_id,"
	       					+ "boulder_supplier_name,"
	       					+ "boulder_supplier_mobile_number,"
	       					+ "boulder_supplier_address "
	       					+ "FROM "
	       					+ "crusher_boulder_supplier_master "
	       					+ "WHERE "
	       					+ "boulder_supplier_id =  ? "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			
	       			preparedStatement.setString(1, boulderSupplierId);
	       			preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
	       			
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			resultSet.last();
	       			
	       			int rowCount = resultSet.getRow();
	       			
	       			resultSet.beforeFirst();
	       			
	       			if(rowCount > 0)
	       			{
	       				if(resultSet.next())
	       					
	       				{
	       				this.setBoulderSupplierId(resultSet.getString(1));
	       				this.setBoulderSupplierName(resultSet.getString(2));
	       				this.setBoulderSupplierMobile(resultSet.getString(3));
	       				this.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)));
	       				
	       				


						float floatTotalBillAmt = 0.0F;
	       				float floatTotalAmountPaid = 0.0f;
	       				float floatTotalBalanceAmt = 0.0f;
	       				
	       				PreparedStatement getTotalBillPSMT = null;
	       				ResultSet getTotalBillRS = null;
	       				
	       				String getTotalPurchaseSQL = "SELECT "
	       						+ "SUM(total_bill_amount) "
	       						+ "FROM "
	       						+ "boulder_inward_bill_info "
	       						+ "WHERE "
	       						+ "boulder_supp_id = ? "
	       						+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";
	       				
	       				getTotalBillPSMT = connection.prepareStatement(getTotalPurchaseSQL);
	       				
	       				getTotalBillPSMT.setString(1, resultSet.getString(1));
	       				getTotalBillPSMT.setString(2, crusherId);
	       				getTotalBillPSMT.setString(3, crusherCode);
        				
	       				getTotalBillRS = getTotalBillPSMT.executeQuery();
	       				
	       				if(getTotalBillRS.next())
	       				{
	       					floatTotalBillAmt = getTotalBillRS.getFloat(1);
	       				}
	       				
	       				
	       				PreparedStatement getSuppAmtPaidPSMT = null;
	       				ResultSet getSuppAmtPaidRS = null;
	       				String getSuppAmtPaidSQL = "SELECT "
	       						+ "SUM(amount) "
	       						+ "FROM "
	       						+ "crusher_boulder_supplier_payment_master "
	       						+ "WHERE "
	       						+ "boulder_supplier_id = ? "
	       						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				getSuppAmtPaidPSMT = connection.prepareStatement(getSuppAmtPaidSQL);
	       				
	       				
	       				
	       				getSuppAmtPaidPSMT.setString(1, resultSet.getString(1));
	       				getSuppAmtPaidPSMT.setString(2, crusherId);
	       				getSuppAmtPaidPSMT.setString(3, crusherCode);
        				
	       				getSuppAmtPaidRS = getSuppAmtPaidPSMT.executeQuery();
	       				
	       				
	       				
	       				if(getSuppAmtPaidRS.next())
	       				{
	       					floatTotalAmountPaid = floatTotalAmountPaid + getSuppAmtPaidRS.getFloat(1);
	       				}
	       				
	       				floatTotalBalanceAmt = floatTotalBillAmt - floatTotalAmountPaid;
	       				
	       			
	       				
	       				this.setDebtAmount(""+(floatTotalBalanceAmt+openingBal));
	       				if(getSuppAmtPaidRS != null)
	       				{
	       					getSuppAmtPaidRS.close();
	       					getSuppAmtPaidRS = null;
	       				}
	       				
	       				if(getSuppAmtPaidPSMT != null)
	       				{
	       					getSuppAmtPaidPSMT.close();
	       					getSuppAmtPaidPSMT = null;
	       				}
	       				
	       				
	       				
	       				if(getTotalBillRS != null)
	       				{
	       					getTotalBillRS.close();
	       					getTotalBillRS = null;
	       				}
	       				
	       				if(getTotalBillPSMT != null)
	       				{
	       					getTotalBillPSMT.close();
	       					getTotalBillPSMT = null;
	       				}
	       				
	       				result = "success";
	       				
	       			}
	       			else
	       			{
	       				result = "error";
	       				
	       				addActionError(this.getText("message.error.urlTemperedDetailsNotFoundForSpecifiedInformation"));
	       			}
	       			
	       			}else
	       			{
	       				result = "error";
	       				addActionError(this.getText("message.error.endOfResultset"));
	       			}
				}
				catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong !");
				}
				catch (Exception e) {
						result = "error";
					
					addActionError(e.getMessage() +" || Something Went Wrong !");
				}
				finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}
	
	
	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getPaymentDate() {
		return paymentDate;
	}


	public void setPaymentDate(String paymentDate) {
		this.paymentDate = paymentDate;
	}


	public String getBoulderSupplierId() {
		return boulderSupplierId;
	}


	public void setBoulderSupplierId(String boulderSupplierId) {
		this.boulderSupplierId = boulderSupplierId;
	}


	public String getBoulderSupplierName() {
		return boulderSupplierName;
	}


	public void setBoulderSupplierName(String boulderSupplierName) {
		this.boulderSupplierName = boulderSupplierName;
	}


	public String getBoulderSupplierMobile() {
		return boulderSupplierMobile;
	}


	public void setBoulderSupplierMobile(String boulderSupplierMobile) {
		this.boulderSupplierMobile = boulderSupplierMobile;
	}


	public String getDebtAmount() {
		return debtAmount;
	}


	public void setDebtAmount(String debtAmount) {
		this.debtAmount = debtAmount;
	}


	public List<String> getBankList() {
		return bankList;
	}


	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}


	public List<String> getBranchList() {
		return branchList;
	}


	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}


	public List<String> getChequeList() {
		return chequeList;
	}


	public void setChequeList(List<String> chequeList) {
		this.chequeList = chequeList;
	}


	public Map<String, String> getAccountList() {
		return accountList;
	}


	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}


	public List<String> getPaymentTypeList() {
		return paymentTypeList;
	}


	public void setPaymentTypeList(List<String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	

}



