package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BankAccountStatementDAO;
import com.stonecrusher.DAO.VehicleConsumptionInfoDAO;
import com.stonecrusher.DAO.VehicleMaintenanceInfoDAO;
import com.stonecrusher.DAO.VehicleTripEntryDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;




public class DownloadVehicleReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 375937246848642548L;
	private String fromDate;
	private String toDate;
	private HttpSession session;
	private String vehicleId;
	private Float totalQuantityInBrass;
	private Float totalTransportataionCharges ;
	private Float totalKm;
	private Float totalTrip;
	private Float totalCharges;
	private Float totalDiesel;
	private Float totalDieselAmount;
	private Float vehicleAvgPerLiter;
	private Float nettProfit;

	private SessionMap<String,Object> sessionMap;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private String billNo;
	private String customerName;
	
	private List<VehicleTripEntryDAO> vehicleTripEntryInfoList = new ArrayList<VehicleTripEntryDAO>();

	private ArrayList<VehicleConsumptionInfoDAO> vehicleConInfoList = new ArrayList<VehicleConsumptionInfoDAO> ();
	private Float totalConsumptionAmount = 0.0F;
	private Float totalQuantity = 0.0F;
	private ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList = new ArrayList<VehicleMaintenanceInfoDAO>();
	private Float totalMaintenanceAmount = 0.0F;
	

	
	
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;
	
	public void download()
	
    {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	String vehicleMake = "";
	        	String vehicleRCNumber = ""; 
	        	response = ServletActionContext.getResponse();
				request = ServletActionContext.getRequest();
				
				String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	    		
				Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		float totalQuantityInBrass = 0.0F;
	    	    float totalKm = 0.0F;
	    	    float totalTrips = 0.0F;
	    	    float totalTransportationCharges = 0.0F;
	    	    
	    	    
            String customerId = null;
	    		
	    		if(this.getCustomerName()!= null)
	    		{
	    			customerId = this.getCustomerName().split("-")[0];
	    		}
	    		
	    		
	    	    
	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			
	if (this.getCustomerName() == null || this.getCustomerName().trim().isEmpty()) {
					    
							
						
						sql = "SELECT "
		    					+ "vt.trip_entry_id,"
		    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
		    					+ "vt.vehicle_id,"
		    					+ "vd.vehicle_make,"
		    					+ "vd.vehicle_registration_number,"
		    					+ "vt.customer_id,"
		    					+ "vt.customer_name,"
		    					+ "vt.product_name,"
		    					+ "vt.product_quantity,"
		    					+ "vt.vehicle_km_start,"
		    					+ "vt.vehicle_km_end,"
		    					+ "vt.trip_total_km,"
		    					+ "vt.trip_start_from,"
		    					+ "vt.trip_end_to,"
		    					+ "vt.total_trip_count,"
		    					+ "vt.trip_driver_name,"
		    					+ "vt.trip_driver_mobile_number,"
		    					+ "vt.bill_number,"
		    					+ "vt.transportation_charges "
		    					+ "FROM "
		    					+ "crusher_vehicle_trip_master as vt "
		    					+ "INNER JOIN "
		    					+ "crusher_vehicle_details_master as vd "
		    					+ "ON "
		    					+ "vd.vehicle_id = vt.vehicle_id "
		    					+ "WHERE "
		    					+ "vt.vehicle_id = ? "
		    					+ "AND "
		    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
		    					+ "AND "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "ORDER BY "
		    					+ "vt.trip_entry_id";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getVehicleId());
		    			preparedStatement.setString(2, this.getFromDate());
		    			preparedStatement.setString(3, this.getToDate());
		    			preparedStatement.setString(4, crusherId);
		    			preparedStatement.setString(5, crusherCode);
		    			preparedStatement.setString(6, crusherId);
		    			preparedStatement.setString(7, crusherCode);
		    			
		    			
		    			
						
					}else {
						
						

						sql = "SELECT "
		    					+ "vt.trip_entry_id,"
		    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
		    					+ "vt.vehicle_id,"
		    					+ "vd.vehicle_make,"
		    					+ "vd.vehicle_registration_number,"
		    					+ "vt.customer_id,"
		    					+ "vt.customer_name,"
		    					+ "vt.product_name,"
		    					+ "vt.product_quantity,"
		    					+ "vt.vehicle_km_start,"
		    					+ "vt.vehicle_km_end,"
		    					+ "vt.trip_total_km,"
		    					+ "vt.trip_start_from,"
		    					+ "vt.trip_end_to,"
		    					+ "vt.total_trip_count,"
		    					+ "vt.trip_driver_name,"
		    					+ "vt.trip_driver_mobile_number,"
		    					+ "vt.bill_number,"
		    					+ "vt.transportation_charges "
		    					+ "FROM "
		    					+ "crusher_vehicle_trip_master as vt "
		    					+ "INNER JOIN "
		    					+ "crusher_vehicle_details_master as vd "
		    					+ "ON "
		    					+ "vd.vehicle_id = vt.vehicle_id "
		    					+ "WHERE "
		    					+ "vt.vehicle_id = ? "
		    					+ "AND "
		    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
		    					+ "AND "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "AND "
		    					+ "vt.crusher_id = ? "
		    					+ "AND "
		    					+ "vd.crusher_code = ? "
		    					+ "AND "
		    					+ "vt.customer_id = ? "
		    					+ "ORDER BY "
		    					+ "vt.trip_entry_id";
		    			
		    			preparedStatement = connection.prepareStatement(sql);
		    			
		    			preparedStatement.setString(1, this.getVehicleId());
		    			preparedStatement.setString(2, this.getFromDate());
		    			preparedStatement.setString(3, this.getToDate());
		    			preparedStatement.setString(4, crusherId);
		    			preparedStatement.setString(5, crusherCode);
		    			preparedStatement.setString(6, crusherId);
		    			preparedStatement.setString(7, crusherCode);
		    			preparedStatement.setString(8, customerId);
						
		    			
		    			
					}
	    			
	    		
	    			resultSet = preparedStatement.executeQuery();
	    		
	    			
	    			this.setTotalCharges(0.0F);
	    			this.setTotalQuantityInBrass(0.0F);
	    			this.setTotalKm(0.0F);
	    			this.setTotalDiesel(0.0F);
	    			this.setTotalDieselAmount(0.0F);
	    			this.setTotalTrip(0.0F);
	    			
	    			
	    				while(resultSet.next())
	    				{

	    					vehicleMake = resultSet.getString(4);
	    					vehicleRCNumber = resultSet.getString(5);
	    					
	    					
	    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
	    					
	    					entryDAO.setTripId(resultSet.getString(1));
	    					entryDAO.setTripDate(resultSet.getString(2));
	    					entryDAO.setTripVehicleMake(resultSet.getString(4));
	    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
	    					
	    					entryDAO.setCustomerId(resultSet.getString(6));
	    					entryDAO.setCustomerName(resultSet.getString(7));
	    					entryDAO.setMaterialName(resultSet.getString(8));
	    					entryDAO.setMaterialVolume(resultSet.getString(9));
	    					entryDAO.setVehicleKmStart(resultSet.getString(10));
	    					entryDAO.setVehicleKmEnd(resultSet.getString(11));
	    					entryDAO.setTripTotalKm(resultSet.getString(12));
	    					entryDAO.setTripFrom(resultSet.getString(13));	    					
	    					entryDAO.setTripTo(resultSet.getString(14));	    					
	    					entryDAO.setTotalTrips(resultSet.getString(15));
	    					entryDAO.setTransportataionCharges(resultSet.getString(19));
	    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
	    					this.setBillNo(resultSet.getString(18));
	    					
	    					
	    					totalQuantityInBrass += resultSet.getFloat(9);
	    		            totalKm += resultSet.getFloat(12);
	    		            totalTrips += resultSet.getFloat(15);
	    		            totalTransportationCharges += resultSet.getFloat(19);
	    					
	    		            
	    		          
	    					this.getVehicleTripEntryInfoList().add(entryDAO);
	    					
	    				}
	    				
	    				
	    				if(resultSet != null)
	    				{
	    					resultSet.close();
	    					resultSet = null;
	    				}
	    				
	    				if(preparedStatement != null)
	    				{
	    					preparedStatement.close();
	    					preparedStatement = null;
	    				}
	    				
	    				
	    				
	    				if (this.getCustomerName() == null || this.getCustomerName().trim().isEmpty()) {
	    				    	
	    					
	    					
	    					
	    					sql = "SELECT "
			    					+ "vt.trip_entry_id,"
			    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
			    					+ "vt.vehicle_id,"
			    					+ "vd.vehicle_make,"
			    					+ "vd.vehicle_registration_number,"
			    					+ "vt.customer_id,"
			    					+ "vt.customer_name,"
			    					+ "vt.product_name,"
			    					+ "vt.product_quantity,"
			    					+ "vt.vehicle_km_start,"
			    					+ "vt.vehicle_km_end,"
			    					+ "vt.trip_total_km,"
			    					+ "vt.trip_start_from,"
			    					+ "vt.trip_end_to,"
			    					+ "vt.total_trip_count,"
			    					+ "vt.trip_driver_name,"
			    					+ "vt.trip_driver_mobile_number,"
			    					+ "vt.transportation_charges "
			    					+ "FROM "
			    					+ "crusher_vehicle_trip_other_master as vt "
			    					+ "INNER JOIN "
			    					+ "crusher_vehicle_details_master as vd "
			    					+ "ON "
			    					+ "vd.vehicle_id = vt.vehicle_id "
			    					+ "WHERE "
			    					+ "vt.vehicle_id = ? "
			    					+ "AND "
			    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
			    					+ "AND "
			    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "ORDER BY "
			    					+ "vt.trip_entry_id";
			    			
			    			preparedStatement = connection.prepareStatement(sql);
			    			
			    			preparedStatement.setString(1, this.getVehicleId());
			    			preparedStatement.setString(2, this.getFromDate());
			    			preparedStatement.setString(3, this.getToDate());
			    			preparedStatement.setString(4, crusherId);
			    			preparedStatement.setString(5, crusherCode);
			    			preparedStatement.setString(6, crusherId);
			    			preparedStatement.setString(7, crusherCode);
			    			
			    			
	    					
	    				}else {
	    					
	    					sql = "SELECT "
			    					+ "vt.trip_entry_id,"
			    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
			    					+ "vt.vehicle_id,"
			    					+ "vd.vehicle_make,"
			    					+ "vd.vehicle_registration_number,"
			    					+ "vt.customer_id,"
			    					+ "vt.customer_name,"
			    					+ "vt.product_name,"
			    					+ "vt.product_quantity,"
			    					+ "vt.vehicle_km_start,"
			    					+ "vt.vehicle_km_end,"
			    					+ "vt.trip_total_km,"
			    					+ "vt.trip_start_from,"
			    					+ "vt.trip_end_to,"
			    					+ "vt.total_trip_count,"
			    					+ "vt.trip_driver_name,"
			    					+ "vt.trip_driver_mobile_number,"
			    					+ "vt.transportation_charges "
			    					+ "FROM "
			    					+ "crusher_vehicle_trip_other_master as vt "
			    					+ "INNER JOIN "
			    					+ "crusher_vehicle_details_master as vd "
			    					+ "ON "
			    					+ "vd.vehicle_id = vt.vehicle_id "
			    					+ "WHERE "
			    					+ "vt.vehicle_id = ? "
			    					+ "AND "
			    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
			    					+ "AND "
			    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "AND "
			    					+ "vt.crusher_id = ? "
			    					+ "AND "
			    					+ "vd.crusher_code = ? "
			    					+ "AND "
			    					+ "vt.customer_id = ? "
			    					+ "ORDER BY "
			    					+ "vt.trip_entry_id";
			    			
			    			preparedStatement = connection.prepareStatement(sql);
			    			
			    			preparedStatement.setString(1, this.getVehicleId());
			    			preparedStatement.setString(2, this.getFromDate());
			    			preparedStatement.setString(3, this.getToDate());
			    			preparedStatement.setString(4, crusherId);
			    			preparedStatement.setString(5, crusherCode);
			    			preparedStatement.setString(6, crusherId);
			    			preparedStatement.setString(7, crusherCode);
			    			preparedStatement.setString(8, customerId);
			    			
	    				}
	    				
		    			resultSet = preparedStatement.executeQuery();
		    	
		    		
		    				while(resultSet.next())
		    				{
		    				
		    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
		    					
		    					entryDAO.setTripId(resultSet.getString(1));
		    					entryDAO.setTripDate(resultSet.getString(2));
		    					entryDAO.setTripVehicleMake(resultSet.getString(4));
		    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
		    					entryDAO.setCustomerId(resultSet.getString(6));
		    					entryDAO.setCustomerName(resultSet.getString(7));
		    					entryDAO.setMaterialName(resultSet.getString(8));
		    					entryDAO.setMaterialVolume(resultSet.getString(9));
		    					entryDAO.setVehicleKmStart(resultSet.getString(10));
		    					entryDAO.setVehicleKmEnd(resultSet.getString(11));
		    					entryDAO.setTripTotalKm(resultSet.getString(12));
		    					entryDAO.setTripFrom(resultSet.getString(13));	    					
		    					entryDAO.setTripTo(resultSet.getString(14));	    					
		    					entryDAO.setTotalTrips(resultSet.getString(15));
		    					entryDAO.setTransportataionCharges(resultSet.getString(18));
		    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
		    					this.setBillNo("0");
		    					
		    					
		    					totalQuantityInBrass += resultSet.getFloat(9);
		    		            totalKm += resultSet.getFloat(12);
		    		            totalTrips += resultSet.getFloat(15);
		    		            totalTransportationCharges += resultSet.getFloat(18);
		    					
		    		            
		    		            
		    					
		    					this.getVehicleTripEntryInfoList().add(entryDAO);
		    					
		    				}

		    				
		    				

		    				if(resultSet != null)
		    				{
		    					resultSet.close();
		    					resultSet = null;
		    				}
		    				
		    				if(preparedStatement != null)
		    				{
		    					preparedStatement.close();
		    					preparedStatement = null;
		    				}
		    				
		    				
		    				


		    				
		    				if (this.getCustomerName() == null || this.getCustomerName().trim().isEmpty()) {
							    
								
								
								sql = "SELECT "
				    					+ "vt.trip_id,"
				    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
				    					+ "vt.trip_vehicle_id,"
				    					+ "vd.vehicle_make,"
				    					+ "vd.vehicle_registration_number,"
				    					+ "vt.customer_id,"
				    					+ "vt.customer_name,"
				    					+ "vt.material_name,"
				    					+ "vt.material_volume,"
				    					+ "vt.vehicle_km_start,"
				    					+ "vt.vehicle_km_end,"
				    					+ "vt.trip_total_km,"
				    					+ "vt.trip_from,"
				    					+ "vt.trip_to,"
				    					+ "vt.total_trips,"
				    					+ "vt.trip_driver_name,"
				    					+ "vt.trip_driver_mobile_number,"
				    					+ "vt.bill_number,"
				    					+ "vt.total_transportataion_charges "
				    					+ "FROM "
				    					+ "crusher_rmc_vehicle_trip_master as vt "
				    					+ "INNER JOIN "
				    					+ "crusher_vehicle_details_master as vd "
				    					+ "ON "
				    					+ "vd.vehicle_id = vt.trip_vehicle_id "
				    					+ "WHERE "
				    					+ "vt.trip_vehicle_id = ? "
				    					+ "AND "
				    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
				    					+ "AND "
				    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "ORDER BY "
				    					+ "vt.trip_id";
				    			
				    			preparedStatement = connection.prepareStatement(sql);
				    			
				    			preparedStatement.setString(1, this.getVehicleId());
				    			preparedStatement.setString(2, this.getFromDate());
				    			preparedStatement.setString(3, this.getToDate());
				    			preparedStatement.setString(4, crusherId);
				    			preparedStatement.setString(5, crusherCode);
				    			preparedStatement.setString(6, crusherId);
				    			preparedStatement.setString(7, crusherCode);
				    			
				    			
				    			
								
							}else {
								
								

								sql = "SELECT "
				    					+ "vt.trip_id,"
				    					+ "DATE_FORMAT(vt.trip_date,'%d-%m-%Y'),"
				    					+ "vt.trip_vehicle_id,"
				    					+ "vd.vehicle_make,"
				    					+ "vd.vehicle_registration_number,"
				    					+ "vt.customer_id,"
				    					+ "vt.customer_name,"
				    					+ "vt.material_name,"
				    					+ "vt.material_volume,"
				    					+ "vt.vehicle_km_start,"
				    					+ "vt.vehicle_km_end,"
				    					+ "vt.trip_total_km,"
				    					+ "vt.trip_from,"
				    					+ "vt.trip_to,"
				    					+ "vt.total_trips,"
				    					+ "vt.trip_driver_name,"
				    					+ "vt.trip_driver_mobile_number,"
				    					+ "vt.bill_number,"
				    					+ "vt.total_transportataion_charges "
				    					+ "FROM "
				    					+ "crusher_rmc_vehicle_trip_master as vt "
				    					+ "INNER JOIN "
				    					+ "crusher_vehicle_details_master as vd "
				    					+ "ON "
				    					+ "vd.vehicle_id = vt.trip_vehicle_id "
				    					+ "WHERE "
				    					+ "vt.trip_vehicle_id = ? "
				    					+ "AND "
				    					+ "(trip_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
				    					+ "AND "
				    					+ "STR_TO_DATE(?,'%d-%m-%Y')) "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "AND "
				    					+ "vt.crusher_id = ? "
				    					+ "AND "
				    					+ "vd.crusher_code = ? "
				    					+ "AND "
				    					+ "vt.customer_id = ? "
				    					+ "ORDER BY "
				    					+ "vt.trip_id";
				    			
				    			preparedStatement = connection.prepareStatement(sql);
				    			
				    			preparedStatement.setString(1, this.getVehicleId());
				    			preparedStatement.setString(2, this.getFromDate());
				    			preparedStatement.setString(3, this.getToDate());
				    			preparedStatement.setString(4, crusherId);
				    			preparedStatement.setString(5, crusherCode);
				    			preparedStatement.setString(6, crusherId);
				    			preparedStatement.setString(7, crusherCode);
				    			preparedStatement.setString(8, customerId);
								
				    			
				    			
							}
			    			
			    		
			    			resultSet = preparedStatement.executeQuery();
			    		
			    			
			    				while(resultSet.next())
			    				{
			    				
			    					VehicleTripEntryDAO entryDAO = new VehicleTripEntryDAO();
			    					
			    					entryDAO.setTripId(resultSet.getString(1));
			    					entryDAO.setTripDate(resultSet.getString(2));
			    					entryDAO.setTripVehicleMake(resultSet.getString(4));
			    					entryDAO.setTripVehicleRCNumber(resultSet.getString(5));
			    					entryDAO.setCustomerId(resultSet.getString(6));
			    					entryDAO.setCustomerName(resultSet.getString(7));
			    					entryDAO.setMaterialName(resultSet.getString(8));
			    					entryDAO.setMaterialVolume(resultSet.getString(9));
			    					entryDAO.setVehicleKmStart(resultSet.getString(10));
			    					entryDAO.setVehicleKmEnd(resultSet.getString(11));
			    					entryDAO.setTripTotalKm(resultSet.getString(12));
			    					entryDAO.setTripFrom(resultSet.getString(13));	    					
			    					entryDAO.setTripTo(resultSet.getString(14));	    					
			    					entryDAO.setTotalTrips(resultSet.getString(15));
			    					entryDAO.setTransportataionCharges(resultSet.getString(19));
			    					entryDAO.setKey(URLEncoder.encode(EncryptionDecryption.encrypt(resultSet.getString(1)),"UTF-8"));
			    					this.setBillNo(resultSet.getString(18));
			    					
			    					
			    					totalQuantityInBrass += resultSet.getFloat(9);
			    		            totalKm += resultSet.getFloat(12);
			    		            totalTrips += resultSet.getFloat(15);
			    		            totalTransportationCharges += resultSet.getFloat(19);
			    					
			    		            
			    					this.getVehicleTripEntryInfoList().add(entryDAO);
			    					
			    				}
			    				
		    				
		    				
		    				   this.setTotalQuantityInBrass(totalQuantityInBrass);
		    				    this.setTotalKm(totalKm);
		    				    this.setTotalTrip(totalTrips);
		    				    this.setTotalTransportataionCharges(totalTransportationCharges);
		    				    
		    				    sql  = "SELECT "
										+ "coninfo.vehicle_expense_entry_id,"
										+ "coninfo.vehicle_id,"
										+ "vinfo.vehicle_make,"
										+ "vinfo.vehicle_registration_number,"
										+ "DATE_FORMAT(coninfo.consumption_date,'%d-%m-%Y'),"
										+ "coninfo.consupmtion_time,"									
										+ "coninfo.consumption_product_id,"
										+ "coninfo.consumption_product_name,"
										+ "coninfo.quantity,"
										+ "coninfo.product_rate,"
										+ "coninfo.amount,"
										+ "coninfo.entry_by,"
										+ "coninfo.consupmtion_details "
										+ "FROM "
										+ "crusher_vehicle_consumption_master AS coninfo "
										+ "INNER JOIN "
										+ "crusher_vehicle_details_master AS vinfo "
										+ "ON coninfo.vehicle_id = vinfo.vehicle_id "
										+ "WHERE "
										+ "coninfo.vehicle_id = ? "
										+ "AND "
										+ "(coninfo.consumption_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
										+ "AND "
										+ "coninfo.crusher_id = ? "
										+ "AND "
										+ "coninfo.crusher_code = ? "
										+ "AND "
										+ "vinfo.crusher_id = ? "
										+ "AND "
										+ "vinfo.crusher_code = ? ";
								
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, this.getVehicleId());
									preparedStatement.setString(2, this.getFromDate());
									preparedStatement.setString(3, this.getToDate());
									preparedStatement.setString(4, crusherId);
									preparedStatement.setString(5, crusherCode);
									preparedStatement.setString(6, crusherId);
									preparedStatement.setString(7, crusherCode);
									
									resultSet = preparedStatement.executeQuery();
									
									
									while(resultSet.next())
									{
										VehicleConsumptionInfoDAO infoDAO = new VehicleConsumptionInfoDAO();
										
										infoDAO.setEntryId(resultSet.getString(1));
										infoDAO.setVehicleId(resultSet.getString(2));
										infoDAO.setVehicleMake(resultSet.getString(3));
										infoDAO.setVehicleRegNumber(resultSet.getString(4));
										infoDAO.setConsumptionDate(resultSet.getString(5));
										infoDAO.setConsumptionTime(resultSet.getString(6));
										infoDAO.setProductId(resultSet.getString(7));
										infoDAO.setProductName(resultSet.getString(8));
										infoDAO.setQuantity(resultSet.getFloat(9));
										infoDAO.setRate(resultSet.getFloat(10));
										infoDAO.setAmount(resultSet.getFloat(11));
										infoDAO.setEntryBy(resultSet.getString(12));
										infoDAO.setConsumptionDetails(resultSet.getString(13));
										
										this.setTotalConsumptionAmount(this.getTotalConsumptionAmount() + resultSet.getFloat(11));
										this.setTotalQuantity(this.getTotalQuantity() + resultSet.getFloat(9));
										
										this.getVehicleConInfoList().add(infoDAO);
										
									}


									
									sql = "SELECT "
											+ "maininfo.vehicle_expense_entry_id,"
											+ "maininfo.vehicle_id,"
											+ "vinfo.vehicle_make,"
											+ "vinfo.vehicle_registration_number,"
											+ "maininfo.exepense_date,"
											+ "maininfo.exepense_time,"
											+ "maininfo.exepense_amount,"
											+ "maininfo.entry_by,"
											+ "maininfo.consupmtion_details,"
											+ "maininfo.expence_image "
											+ "FROM "
											+ "crusher_vehicle_expense_master AS maininfo "
											+ "INNER JOIN "
											+ "crusher_vehicle_details_master AS vinfo "
											+ "ON maininfo.vehicle_id = vinfo.vehicle_id "
											+ "WHERE "
											+ "maininfo.vehicle_id = ? "
											+ "AND "
											+ "(maininfo.exepense_date "
											+ "BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
											+ "AND "
											+ "maininfo.crusher_id = ? "
											+ "AND "
											+ "maininfo.crusher_code = ? "
											+ "AND "
											+ "vinfo.crusher_id = ? "
											+ "AND "
											+ "vinfo.crusher_code = ? ";
									
										preparedStatement = connection.prepareStatement(sql);
										preparedStatement.setString(1, this.getVehicleId());
										preparedStatement.setString(2, this.getFromDate());
										preparedStatement.setString(3, this.getToDate());
										preparedStatement.setString(4, crusherId);
										preparedStatement.setString(5, crusherCode);
										preparedStatement.setString(6, crusherId);
										preparedStatement.setString(7, crusherCode);
										
										
										resultSet = preparedStatement.executeQuery();
										
										while(resultSet.next())
										{
											VehicleMaintenanceInfoDAO infoDAO = new VehicleMaintenanceInfoDAO();
											infoDAO.setEntryId(resultSet.getString(1));
											infoDAO.setVehicleId(resultSet.getString(2));
											infoDAO.setVehicleMake(resultSet.getString(3));
											infoDAO.setVehicleRegNumber(resultSet.getString(4));
											infoDAO.setEntryDate(resultSet.getString(5));
											infoDAO.setEntryTime(resultSet.getString(6));
											infoDAO.setAmount(resultSet.getFloat(7));
											infoDAO.setEntryBy(resultSet.getString(8));
											infoDAO.setComments(resultSet.getString(9));
											if(resultSet.getBlob(10) != null)
											{
												infoDAO.setImageAvailable(true);
											}
											else
											{
												infoDAO.setImageAvailable(false);
											}
											
											
											this.setTotalMaintenanceAmount(this.getTotalMaintenanceAmount() + resultSet.getFloat(7));
											
											this.getVehicleMainInfoList().add(infoDAO);
											
											
										}
		    				    
		    				if(this.getVehicleTripEntryInfoList().size() > 0)
		    				{
		    					
		    					this.setVehicleAvgPerLiter(this.getTotalKm()/this.getTotalQuantity());
			    				this.setNettProfit(this.getTotalTransportataionCharges()-this.getTotalConsumptionAmount()-this.getTotalMaintenanceAmount());
			    				
			    				
		    				}
		    				else
		    				{
		    					
		    					addActionError("Details not found!");
		    				}
	    				
	    			@SuppressWarnings("unchecked")
					String crusherName = (String) this.getSessionMap().get("crushernameenglish");
				    
	    				
	    				
	    				String path=	request.getSession().getServletContext().getRealPath("/images/");
		    			PDDocument document = new PDDocument(); 
						PDPage page = null;
						
						SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-Y");
						Date date = new Date();
						
						String dateToday = sdf.format(date); 
						page = 	new PDPage(PDRectangle.A4);
						
						 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
						 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
						 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
						
					        document.addPage(page);
					         PDPageContentStream contentStream = new PDPageContentStream(document, page);
					         int pageCount = 1;
				    			 
					         Table header;
				    			
				    			
				    			  TableBuilder tableHeaderBuilder = Table.builder()
							                .addColumnsOfWidth(580)				                
							                .font(HELVETICA)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);
						         
						          Row headerName = Row.builder()
							                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
							                .horizontalAlignment(CENTER)
							                .build();
						          
						          
						          Row info1 = Row.builder()
							                .add(TextCell.builder().text("Vehicle Trip Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							                .horizontalAlignment(CENTER)
							                .build();
						          
						          Row info2 = Row.builder()
							                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							                .horizontalAlignment(CENTER)
							                .build();
						          
						          Row info3 = Row.builder()
							                .add(TextCell.builder().text("From Date: "
							                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							                .horizontalAlignment(CENTER)
							                .build();
						          
						       
						          tableHeaderBuilder.addRow(headerName);
						          tableHeaderBuilder.addRow(info1);
						          tableHeaderBuilder.addRow(info2);
						          tableHeaderBuilder.addRow(info3);
						          header = tableHeaderBuilder.build();
						          
						          
						          
						          
						          
						          Table vehicleTripDetails ;
						          
						          TableBuilder tripDetailsDetailsBuilder = Table.builder()
						        		  .addColumnsOfWidth(45,105,60,35,35,35,35,60,60,40,85)		                
							               .font(HELVETICA)
							                .borderWidth(0.5F)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);
						          
						          
						          Row tripDetailsHeader = Row.builder()
						        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							                .add(TextCell.builder().text("Customer").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("Material").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("QTY(Brass)").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							                .add(TextCell.builder().text("KM Start").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("KM End").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("Total KM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
							                .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
							                .add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
							                .add(TextCell.builder().text("charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
							                .add(TextCell.builder().text("Description").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
									                
							                .backgroundColor(Color.LIGHT_GRAY)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .build();
						          tripDetailsDetailsBuilder.addRow(tripDetailsHeader);
						          
						          vehicleTripDetails = tripDetailsDetailsBuilder.build();
						          
						          int size = this.getVehicleTripEntryInfoList().size();
						          
						          float startY = page.getMediaBox().getHeight() - PADDING20;
						          float currentY = startY;
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(header)
					                .startX(PADDING20)
					                .startY(startY)
					                .build()
					                .draw();
						          
						          currentY = startY - 70;
						          
						          
						          for(int s=0;s<size;s++)
					        	  {
					        		  if(currentY < 200)
					        		  {
					        			  pageCount++;
					        			  vehicleTripDetails = tripDetailsDetailsBuilder.build();
					        			  TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(vehicleTripDetails)
							                .startX(PADDING30)
							                .startY(startY-70)
							                .build()
							                .draw();
					        			  
					        			  contentStream.close();
					        			  
					        			  header = null;
					        			  
					        			  

    					    			  tableHeaderBuilder = Table.builder()
    								                .addColumnsOfWidth(580)				                
    								                .font(HELVETICA)
    								                .borderColor(Color.BLACK)
    								                .horizontalAlignment(CENTER);
    							         
    							          headerName = Row.builder()
    								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
    								                .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           info1 = Row.builder()
    								                .add(TextCell.builder().text("Vehicle Trip Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
    								                .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           
    								        info2 = Row.builder()
    									                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
    									                .backgroundColor(WHITE)
    									                .textColor(Color.BLACK)
    									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
    									                .horizontalAlignment(CENTER)
    									                .build();
    								          
    							          
    							           info3 = Row.builder()
  								                .add(TextCell.builder().text("From Date: "
  								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
  								                .backgroundColor(WHITE)
  								                .textColor(Color.BLACK)
  								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
  								                .horizontalAlignment(CENTER)
  								                .build();
    							          
    							       
    							          tableHeaderBuilder.addRow(headerName);
    							          tableHeaderBuilder.addRow(info1);
    							          tableHeaderBuilder.addRow(info2);
    							          tableHeaderBuilder.addRow(info3);
    							          header = tableHeaderBuilder.build();
    							          
    							          
    							          
    							          
    							          
    							          tripDetailsDetailsBuilder = Table.builder()
    							        		  .addColumnsOfWidth(45,105,60,35,35,35,35,60,60,40,85)		                
    								               .font(HELVETICA)
    								                .borderWidth(0.5F)
    								                .borderColor(Color.BLACK)
    								                .horizontalAlignment(CENTER);
    							          
    							          
    							          tripDetailsHeader = Row.builder()
    							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
    								                .add(TextCell.builder().text("Customer").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
    								                .add(TextCell.builder().text("Material").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
    								                .add(TextCell.builder().text("QTY(Brass)").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
    								                .add(TextCell.builder().text("KM Start").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
    								                .add(TextCell.builder().text("KM End").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
    								                .add(TextCell.builder().text("Total KM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
    								                .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
    								                .add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
    								                .add(TextCell.builder().text("charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
    								                .add(TextCell.builder().text("Description").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
    										           
    								                .backgroundColor(Color.LIGHT_GRAY)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          tripDetailsDetailsBuilder.addRow(tripDetailsHeader);
					        			  
    							          
    							      	PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	 startY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             currentY = startY;
							             currentY = startY - 70;
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING20)
							                .startY(startY)
							                .build()
							                .draw();
					        		  }
					        		  
					        		  VehicleTripEntryDAO entryDAO = this.getVehicleTripEntryInfoList().get(s);
					        		  
					        		  Row tripInfo = Row.builder()
					        				  .add(TextCell.builder().text(entryDAO.getTripDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
								                .add(TextCell.builder().text(""+entryDAO.getCustomerName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())
								                .add(TextCell.builder().text(""+entryDAO.getMaterialName()).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(0.5F).build())
								                .add(TextCell.builder().text(""+entryDAO.getMaterialVolume()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
								                .add(TextCell.builder().text(""+entryDAO.getVehicleKmStart()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								                .add(TextCell.builder().text(""+entryDAO.getVehicleKmEnd()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
								                .add(TextCell.builder().text(""+entryDAO.getTripTotalKm()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text(""+entryDAO.getTripFrom()).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text(""+entryDAO.getTripTo()).font(fontMarathi).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text(""+entryDAO.getTransportataionCharges()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
								                .add(TextCell.builder().text(""+entryDAO.getMaintenanceDescription()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
										     	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA)
								                .fontSize(7)				              
								                .horizontalAlignment(CENTER)
								                .height(20F)					                
								                .build();
						        	  
					        		  tripDetailsDetailsBuilder.addRow(tripInfo);
						        	 
						        	  currentY = currentY-15;
						        	  
						        	  //System.out.println(currentY);
					        		  
					        	  }
						          

					        	  Row totalRow = Row.builder()
					        			  	.add(TextCell.builder().text("Total:").colSpan(3).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							                .add(TextCell.builder().text(""+this.getTotalQuantityInBrass()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text("").colSpan(2).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text(""+this.getTotalKm()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
							                .add(TextCell.builder().text("").colSpan(2).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())
							                .add(TextCell.builder().text(""+this.getTotalTransportataionCharges()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
							                .add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
							               .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)					                
							                .build();
					        	  tripDetailsDetailsBuilder.addRow(totalRow);
					        	  
						          vehicleTripDetails = tripDetailsDetailsBuilder.build();
						          
						          
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(vehicleTripDetails)
					                .startX(PADDING20)
					                .startY(startY-70)
					                .build()
					                .draw();
						          
						          Table vehicleAvgInfo ;
					        	  
					        	  TableBuilder  vehicleAvgInfoTableBuilder = Table.builder()
							                .addColumnsOfWidth(133,133)				                
							                .font(HELVETICA)
							                .borderWidth(0.5F)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);

					        	  Row avgRow1 = Row.builder()
					        			  	.add(TextCell.builder().text("Vehicle Average per Liter").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
					        			  	.add(TextCell.builder().text(""+this.getVehicleAvgPerLiter()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)					                
							                .build();
					        	  Row avgRow2 = Row.builder()
					        			  	.add(TextCell.builder().text("Net Profit").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
					        			  	.add(TextCell.builder().text(""+this.getNettProfit()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.5F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(15F)					                
							                .build();
					        	  
					        	 
					        	  
					        	  vehicleAvgInfoTableBuilder.addRow(avgRow1);
					        	  vehicleAvgInfoTableBuilder.addRow(avgRow2);
					        	  vehicleAvgInfo = vehicleAvgInfoTableBuilder.build();
					        	  
					        	  vehicleAvgInfo = vehicleAvgInfoTableBuilder.build();
					        	 
						          
						          
						          /*if(currentY < 200)
						          {
						        	  pageCount++;
				        			
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			  

					    			  tableHeaderBuilder = Table.builder()
								                .addColumnsOfWidth(830)				                
								                .font(HELVETICA)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							         
							          headerName = Row.builder()
								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
								                .backgroundColor(WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          
							           info1 = Row.builder()
								                .add(TextCell.builder().text("Vehicle Trip Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
								                .backgroundColor(WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
								                .horizontalAlignment(CENTER)
								                .build();
							          
							           
								        info2 = Row.builder()
									                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
							          
							           info3 = Row.builder()
								                .add(TextCell.builder().text("From Date: "
								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
								                .backgroundColor(WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
								                .horizontalAlignment(CENTER)
								                .build();
							          
							       
							          tableHeaderBuilder.addRow(headerName);
							          tableHeaderBuilder.addRow(info1);
							          tableHeaderBuilder.addRow(info2);
							          tableHeaderBuilder.addRow(info3);
							          header = tableHeaderBuilder.build();
							          
							          
							          PDPage newPage = new PDPage(new PDRectangle(830,580));
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	 startY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING20)
							                .startY(startY)
							                .build()
							                .draw();
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(vehicleAvgInfo)
							                .startX(PADDING20)
							                .startY(startY-70)
							                .build()
							                .draw();
							          
						          }
						          else
						          {
						        	  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(vehicleAvgInfo)
						                .startX(PADDING20)
						                .startY(currentY-150)
						                .build()
						                .draw();
						          }
						       */
						          
						        
					        	    if(this.getVehicleConInfoList().size() > 0)
							          {

								          
									      	PDPage pageConDetails = null;
												
												
									      	
									      	pageConDetails = 	new PDPage(PDRectangle.A4);
											
									      	
												pageCount++;
												
									        document.addPage(pageConDetails);
									         PDPageContentStream conDetailsContentStream = new PDPageContentStream(document, pageConDetails);
							          
									         
								    			
									          tableHeaderBuilder = Table.builder()
										                .addColumnsOfWidth(580)				                
										                .font(HELVETICA)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									         
									           headerName = Row.builder()
										                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          
									          
									           info1 = Row.builder()
										                .add(TextCell.builder().text("Vehicle Consumption Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									           info2 = Row.builder()
										                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									           info3 = Row.builder()
										                .add(TextCell.builder().text("From Date: "
										                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									       
									          tableHeaderBuilder.addRow(headerName);
									          tableHeaderBuilder.addRow(info1);
									          tableHeaderBuilder.addRow(info2);
									          tableHeaderBuilder.addRow(info3);
									          header = tableHeaderBuilder.build();
									          
									          
									          float debitEntryStartY = pageConDetails.getMediaBox().getHeight() - PADDING20;
									          float debitEntryCurrentY = debitEntryStartY;
									          
									          TableDrawer.builder()
								                .contentStream(conDetailsContentStream)
								                .table(header)
								                .startX(PADDING30)
								                .startY(debitEntryCurrentY)
								                .build()
								                .draw();
									          
									          Table conDetails;
								    			 
									          TableBuilder tableConDetailsBuilder = Table.builder()
										                .addColumnsOfWidth(60, 80, 80, 50, 50, 50, 50, 130)		                
										                .font(HELVETICA)
										                .borderWidth(0.5F)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									          
									          Row tableHeader = Row.builder()
									        		  	.add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										                .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
										                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
										                .add(TextCell.builder().text("Quantity").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
										                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
										                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
										                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
										                .backgroundColor(Color.LIGHT_GRAY)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          tableConDetailsBuilder.addRow(tableHeader);
									       
									        
									          for(int s=0;s<this.getVehicleConInfoList().size();s++)
								        	  {
									        	  if(debitEntryCurrentY < 130)
								        		  {
									        		  pageCount++;
									        		  conDetails = tableConDetailsBuilder.build();
								        			  TableDrawer.builder()
										                .contentStream(conDetailsContentStream)
										                .table(conDetails)
										                .startX(PADDING30)
										                .startY(debitEntryStartY-70)
										                .build()
										                .draw();
								        			  
								        			  conDetailsContentStream.close();
								        			  
								        			  conDetailsContentStream = null;
			    							          
			    							      	PDPage debitEntryDetailsnewPage = new PDPage(new PDRectangle(830,580));
			    							      	conDetailsContentStream = new PDPageContentStream(document,debitEntryDetailsnewPage);
			    							      	debitEntryCurrentY =  debitEntryDetailsnewPage.getMediaBox().getHeight() - PADDING20;
									             document.addPage( debitEntryDetailsnewPage );
									            
									             conDetails = null;
									             tableConDetailsBuilder = null;
									             header = null;
									             tableHeaderBuilder = null;
							        			  
							        			  
											    			 
											    			
									             tableHeaderBuilder = Table.builder()
											                .addColumnsOfWidth(580)				                
											                .font(HELVETICA)
											                .borderColor(Color.BLACK)
											                .horizontalAlignment(CENTER);
										         
										           headerName = Row.builder()
											                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
											                .horizontalAlignment(CENTER)
											                .build();
										          
										          
										           info1 = Row.builder()
											                .add(TextCell.builder().text("Vehicle Consumption Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
											                .horizontalAlignment(CENTER)
											                .build();
										          
										           info2 = Row.builder()
											                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
											                .horizontalAlignment(CENTER)
											                .build();
										          
										           info3 = Row.builder()
											                .add(TextCell.builder().text("From Date: "
											                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
											                .horizontalAlignment(CENTER)
											                .build();
										          
										       
										          tableHeaderBuilder.addRow(headerName);
										          tableHeaderBuilder.addRow(info1);
										          tableHeaderBuilder.addRow(info2);
										          tableHeaderBuilder.addRow(info3);
										          header = tableHeaderBuilder.build();
										          
										          conDetails = null;
									        			  tableConDetailsBuilder = Table.builder()
									        					   .addColumnsOfWidth(60, 80, 80, 50, 50, 50, 50, 130)			                
													                .font(HELVETICA)
													                .borderWidth(0.5F)
													                .borderColor(Color.BLACK)
													                .horizontalAlignment(CENTER);
												          
												           tableHeader = Row.builder()
												        		   .add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
													                .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
													                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
													                .add(TextCell.builder().text("Quantity").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
													                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
													                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
													                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
													                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
													                .backgroundColor(Color.LIGHT_GRAY)
													                .textColor(Color.BLACK)
													                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
													                .horizontalAlignment(CENTER)
													                .build();
												           tableConDetailsBuilder.addRow(tableHeader);
												          
									        			  
									        				PDPage newPage = new PDPage(PDRectangle.A4);
												        	 contentStream = new PDPageContentStream(document,newPage);
												        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
												             document.addPage( newPage );
												             
												             TableDrawer.builder()
												                .contentStream(conDetailsContentStream)
												                .table(header)
												                .startX(PADDING30)
												                .startY(currentY)
												                .build()
												                .draw();
									        		  }
									        		  
									        		  VehicleConsumptionInfoDAO dao2 = this.getVehicleConInfoList().get(s);
									        		  
									        			Row supplierInfo = Row.builder()
										        			  	.add(TextCell.builder().text(dao2.getConsumptionDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(dao2.getVehicleMake() + " | " +  dao2.getVehicleRegNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(dao2.getProductName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getQuantity()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getEntryBy()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getConsumptionDetails()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.backgroundColor(Color.WHITE)
												                .textColor(Color.BLACK)
												                .font(PDType1Font.HELVETICA)
												                .fontSize(8)				              
												                .horizontalAlignment(CENTER)
												                .height(25F)					                
												                .build();
										        	  
									        			tableConDetailsBuilder.addRow(supplierInfo);
										        	 
										        	  currentY = currentY -25;
									        	  }
										          
										    	  Row custInfo = Row.builder()
										    			   .add(TextCell.builder().text("Total Consumption Amount").colSpan(3).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
										    			   .add(TextCell.builder().text("" + this.getTotalQuantity()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
										    			   .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build()) // Empty cell for column 7
										    			    .add(TextCell.builder().text("" + this.getTotalConsumptionAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
										    			    .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build()) // Empty cell for column 6
										    			    .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build()) // Empty cell for column 7
										    			    .backgroundColor(Color.WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD)
											                .fontSize(8)				              
											                .horizontalAlignment(CENTER)
											                .height(15F)					                
											                .build();
									        	  
										    	  tableConDetailsBuilder.addRow(custInfo);
										    	  conDetails = tableConDetailsBuilder.build();
									         
									          
									          TableDrawer.builder()
								                .contentStream(conDetailsContentStream)
								                .table(conDetails)
								                .startX(PADDING30)
								                .startY(startY-70)
								                .build()
								                .draw();
									          conDetailsContentStream.close();
									          
									         
							          }
						          
						          
					        	    
					        	    
					        	    
					        	    if(this.getVehicleMainInfoList().size() > 0)
							          {

								          
									      	PDPage pageMaintenanceDetails = null;
												
												
									      	
									      	pageMaintenanceDetails = 	new PDPage(PDRectangle.A4);
											
									      	
												pageCount++;
												
									        document.addPage(pageMaintenanceDetails);
									         PDPageContentStream maintenanceDetailsContentStream = new PDPageContentStream(document, pageMaintenanceDetails);
							          
									         	
									          tableHeaderBuilder = Table.builder()
										                .addColumnsOfWidth(580)				                
										                .font(HELVETICA)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									         
									           headerName = Row.builder()
										                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          
									          
									           info1 = Row.builder()
										                .add(TextCell.builder().text("Vehicle Maintenance Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									           info2 = Row.builder()
										                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									           info3 = Row.builder()
										                .add(TextCell.builder().text("From Date: "
										                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									       
									          tableHeaderBuilder.addRow(headerName);
									          tableHeaderBuilder.addRow(info1);
									          tableHeaderBuilder.addRow(info2);
									          tableHeaderBuilder.addRow(info3);
									          header = tableHeaderBuilder.build();
									          
									          
									          float debitEntryStartY = pageMaintenanceDetails.getMediaBox().getHeight() - PADDING20;
									          float debitEntryCurrentY = debitEntryStartY;
									          
									          TableDrawer.builder()
								                .contentStream(maintenanceDetailsContentStream)
								                .table(header)
								                .startX(PADDING30)
								                .startY(debitEntryCurrentY)
								                .build()
								                .draw();
									          
									          Table maintenanceDetails;
								    			 
									          TableBuilder tableMaintenanceDetailsBuilder = Table.builder()
									        		  .addColumnsOfWidth(80, 100, 50, 50, 130)		                
										                .font(HELVETICA)
										                .borderWidth(0.5F)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									          
									          Row tableHeader = Row.builder()
									        		  .add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										                .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
										                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
										                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
										                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
										               .backgroundColor(Color.LIGHT_GRAY)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          tableMaintenanceDetailsBuilder.addRow(tableHeader);
									       
									        
									          for(int s=0;s<this.getVehicleMainInfoList().size();s++)
								        	  {
									        	  if(debitEntryCurrentY < 130)
								        		  {
									        		  pageCount++;
									        		  maintenanceDetails = tableMaintenanceDetailsBuilder.build();
								        			  TableDrawer.builder()
										                .contentStream(maintenanceDetailsContentStream)
										                .table(maintenanceDetails)
										                .startX(PADDING30)
										                .startY(debitEntryStartY-70)
										                .build()
										                .draw();
								        			  
								        			  maintenanceDetailsContentStream.close();
								        			  
								        			  maintenanceDetailsContentStream = null;
			    							          
			    							      	PDPage debitEntryDetailsnewPage = new PDPage(new PDRectangle(830,580));
			    							      	maintenanceDetailsContentStream = new PDPageContentStream(document,debitEntryDetailsnewPage);
			    							      	debitEntryCurrentY =  debitEntryDetailsnewPage.getMediaBox().getHeight() - PADDING20;
									             document.addPage( debitEntryDetailsnewPage );
									            
									             maintenanceDetails = null;
									             tableMaintenanceDetailsBuilder = null;
									             header = null;
									             tableHeaderBuilder = null;
							        			  
							        			  
											    			 
											    			
									             tableHeaderBuilder = Table.builder()
											                .addColumnsOfWidth(580)				                
											                .font(HELVETICA)
											                .borderColor(Color.BLACK)
											                .horizontalAlignment(CENTER);
										         
										           headerName = Row.builder()
											                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
											                .horizontalAlignment(CENTER)
											                .build();
										          
										          
										           info1 = Row.builder()
											                .add(TextCell.builder().text("Vehicle Maintenance Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
											                .horizontalAlignment(CENTER)
											                .build();
										          
										           info2 = Row.builder()
											                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
											                .horizontalAlignment(CENTER)
											                .build();
										          
										           info3 = Row.builder()
											                .add(TextCell.builder().text("From Date: "
											                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
											                .horizontalAlignment(CENTER)
											                .build();
										          
										       
										          tableHeaderBuilder.addRow(headerName);
										          tableHeaderBuilder.addRow(info1);
										          tableHeaderBuilder.addRow(info2);
										          tableHeaderBuilder.addRow(info3);
										          header = tableHeaderBuilder.build();
										          
										          maintenanceDetails = null;
									        			  tableMaintenanceDetailsBuilder = Table.builder()
									        					  .addColumnsOfWidth(80, 100, 50, 50, 130)		                
													                 .font(HELVETICA)
													                .borderWidth(0.5F)
													                .borderColor(Color.BLACK)
													                .horizontalAlignment(CENTER);
												          
												           tableHeader = Row.builder()
												        		   .add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
													                .add(TextCell.builder().text("Vehicle").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
													                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
													                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
													                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
													               .backgroundColor(Color.LIGHT_GRAY)
													                .textColor(Color.BLACK)
													                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
													                .horizontalAlignment(CENTER)
													                .build();
												           tableMaintenanceDetailsBuilder.addRow(tableHeader);
												          
									        			  
									        				PDPage newPage = new PDPage(PDRectangle.A4);
												        	 contentStream = new PDPageContentStream(document,newPage);
												        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
												             document.addPage( newPage );
												             
												             TableDrawer.builder()
												                .contentStream(maintenanceDetailsContentStream)
												                .table(header)
												                .startX(PADDING30)
												                .startY(currentY)
												                .build()
												                .draw();
									        		  }
									        		  
									        	  VehicleMaintenanceInfoDAO dao2 = this.getVehicleMainInfoList().get(s);
								        		  
								        			
									        			Row supplierInfo = Row.builder()
										        			  	.add(TextCell.builder().text(dao2.getEntryDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(dao2.getVehicleMake() + " | " +  dao2.getVehicleRegNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getEntryBy()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.add(TextCell.builder().text(""+dao2.getComments()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
										        			  	.backgroundColor(Color.WHITE)
												                .textColor(Color.BLACK)
												                .font(PDType1Font.HELVETICA)
												                .fontSize(8)				              
												                .horizontalAlignment(CENTER)
												                .height(25F)					                
												                .build();
										        	  
									        			tableMaintenanceDetailsBuilder.addRow(supplierInfo);
										        	 
										        	  currentY = currentY -25;
									        	  }
										          
										    	  Row custInfo = Row.builder()
										    			  .add(TextCell.builder().text("Total Maintenance Amount").colSpan(2).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
										    			   .add(TextCell.builder().text("" + this.getTotalMaintenanceAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
										    			    .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build()) // Empty cell for column 6
										    			    .add(TextCell.builder().text("").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build()) // Empty cell for column 7
										    			    .backgroundColor(Color.WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD)
											                .fontSize(8)				              
											                .horizontalAlignment(CENTER)
											                .height(15F)					                
											                .build();
									        	  
										    	  tableMaintenanceDetailsBuilder.addRow(custInfo);
										    	  maintenanceDetails = tableMaintenanceDetailsBuilder.build();
									         
									          
									          TableDrawer.builder()
								                .contentStream(maintenanceDetailsContentStream)
								                .table(maintenanceDetails)
								                .startX(PADDING30)
								                .startY(startY-70)
								                .build()
								                .draw();
									          maintenanceDetailsContentStream.close();
									          
									         
							          }
					        	    
					        	    
					        	    
					        	   
					        	    
					        	    
					        	    if(this.getVehicleTripEntryInfoList().size() > 0)
							          {

								          
									      	PDPage pageVehicleNetProfitDetails = null;
												
												
									      	
									      	pageVehicleNetProfitDetails = 	new PDPage(PDRectangle.A4);
											
									      	
												pageCount++;
												
									        document.addPage(pageVehicleNetProfitDetails);
									         PDPageContentStream vehicleNetProfitDetailsContentStream = new PDPageContentStream(document, pageVehicleNetProfitDetails);
							          
									         	
									          tableHeaderBuilder = Table.builder()
										                .addColumnsOfWidth(580)				                
										                .font(HELVETICA)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									         
									           headerName = Row.builder()
										                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          
									          
									           info1 = Row.builder()
										                .add(TextCell.builder().text("Vehicle Net Profit Details").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									           info2 = Row.builder()
										                .add(TextCell.builder().text("Make :- "+vehicleMake+"   RC Number:- "+vehicleRCNumber).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									           info3 = Row.builder()
										                .add(TextCell.builder().text("From Date: "
										                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
									          
									       
									          tableHeaderBuilder.addRow(headerName);
									          tableHeaderBuilder.addRow(info1);
									          tableHeaderBuilder.addRow(info2);
									          tableHeaderBuilder.addRow(info3);
									          header = tableHeaderBuilder.build();
									          
									          
									          float vehicleNetProfitEntryStartY = pageVehicleNetProfitDetails.getMediaBox().getHeight() - PADDING10;
									          float vehicleNetProfitEntryCurrentY = vehicleNetProfitEntryStartY;
									          
									          TableDrawer.builder()
								                .contentStream(vehicleNetProfitDetailsContentStream)
								                .table(header)
								                .startX(PADDING30)
								                .startY(vehicleNetProfitEntryCurrentY)
								                .build()
								                .draw();
									          
									          Table vehicleNetProfitDetails;

									          TableBuilder tableVehicleNetProfitDetailsBuilder = Table.builder()
									              .addColumnsOfWidth(200, 150)
									              .font(HELVETICA)
									              .borderWidth(0.5F)
									              .borderColor(Color.BLACK)
									              .horizontalAlignment(CENTER);

									         
									          Row avgPerLiterRow = Row.builder()
									        		    .add(TextCell.builder()
									        		         .text("Vehicle Average per Liter")
									        		         .horizontalAlignment(LEFT)
									        		         .borderWidth(0.5F)
									        		         .lineSpacing(1F)
									        		         .font(PDType1Font.HELVETICA_BOLD)
									        		         .fontSize(10)
									        		         .backgroundColor(Color.LIGHT_GRAY)  
									        		         .textColor(Color.BLACK)
									        		         .build())
									        		    .add(TextCell.builder()
									        		         .text("" + this.getVehicleAvgPerLiter())
									        		         .horizontalAlignment(LEFT)
									        		         .borderWidth(0.5F)
									        		         .lineSpacing(1F)
									        		         .font(PDType1Font.HELVETICA)
									        		         .fontSize(10)
									        		         .textColor(Color.BLACK)  
									        		         .build())
									        		    .height(25F)
									        		    .build();

									        		tableVehicleNetProfitDetailsBuilder.addRow(avgPerLiterRow);

									        		
									        		Row netProfitRow = Row.builder()
									        		    .add(TextCell.builder()
									        		         .text("Net Profit")
									        		         .horizontalAlignment(LEFT)
									        		         .borderWidth(0.5F)
									        		         .lineSpacing(1F)
									        		         .font(PDType1Font.HELVETICA_BOLD)
									        		         .fontSize(10)
									        		         .backgroundColor(Color.LIGHT_GRAY)
									        		         .textColor(Color.BLACK)
									        		         .build())
									        		    .add(TextCell.builder()
									        		         .text("" + this.getNettProfit())
									        		         .horizontalAlignment(LEFT)
									        		         .borderWidth(0.5F)
									        		         .lineSpacing(1F)
									        		         .font(PDType1Font.HELVETICA)
									        		         .fontSize(10)
									        		         .textColor(Color.BLACK)  
									        		         .build())
									        		    .height(25F)
									        		    .build();

									        		tableVehicleNetProfitDetailsBuilder.addRow(netProfitRow);

									         
									          currentY = currentY - 50; 

									          vehicleNetProfitDetails = tableVehicleNetProfitDetailsBuilder.build();

									          TableDrawer.builder()
								                .contentStream(vehicleNetProfitDetailsContentStream)
								                .table(vehicleNetProfitDetails)
								                .startX(PADDING30)
								                .startY(startY-70)
								                .build()
								                .draw();
									          vehicleNetProfitDetailsContentStream.close();
									          
									         
							          }
					        	    
					        	    
					        	    
					        	    
						          contentStream.close();
							        
							      			
							        
							        document.save(path+"/vehicle-report.pdf");
							        document.close();
							        
							        response.setHeader("Content-disposition", "inline; filename=vehicle-report.pdf");
									response.setContentType("application/pdf");
									
									FileInputStream fileInputStream = new FileInputStream(path+"/vehicle-report.pdf");
									PrintWriter out = response.getWriter();  
									int bytes;
									while ((bytes = fileInputStream.read()) != -1) {
										out.write(bytes);
									}
									fileInputStream.close();
									out.flush();
									out.close();
									ttf1.close();
	    				
	    		
	    			
	    		} catch (SQLException e) {
	    			e.printStackTrace();
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    		} catch (Exception e) {
	    			result = "error";
	    			e.printStackTrace();
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || Something Went Wrong!");
	    		} finally {
	    			if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    			
	    		}

	        }
    }	        
	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getVehicleId() {
		return vehicleId;
	}

	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}

	public Float getTotalQuantityInBrass() {
		return totalQuantityInBrass;
	}

	public void setTotalQuantityInBrass(Float totalQuantityInBrass) {
		this.totalQuantityInBrass = totalQuantityInBrass;
	}

	public Float getTotalKm() {
		return totalKm;
	}

	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}

	public Float getTotalTrip() {
		return totalTrip;
	}

	public void setTotalTrip(Float totalTrip) {
		this.totalTrip = totalTrip;
	}

	public Float getTotalCharges() {
		return totalCharges;
	}

	public void setTotalCharges(Float totalCharges) {
		this.totalCharges = totalCharges;
	}

	public Float getTotalDiesel() {
		return totalDiesel;
	}

	public void setTotalDiesel(Float totalDiesel) {
		this.totalDiesel = totalDiesel;
	}

	public Float getTotalDieselAmount() {
		return totalDieselAmount;
	}

	public void setTotalDieselAmount(Float totalDieselAmount) {
		this.totalDieselAmount = totalDieselAmount;
	}

	public Float getTotalMaintenanceAmount() {
		return totalMaintenanceAmount;
	}

	public void setTotalMaintenanceAmount(Float totalMaintenanceAmount) {
		this.totalMaintenanceAmount = totalMaintenanceAmount;
	}

	public Float getVehicleAvgPerLiter() {
		return vehicleAvgPerLiter;
	}

	public void setVehicleAvgPerLiter(Float vehicleAvgPerLiter) {
		this.vehicleAvgPerLiter = vehicleAvgPerLiter;
	}

	public Float getNettProfit() {
		return nettProfit;
	}

	public void setNettProfit(Float nettProfit) {
		this.nettProfit = nettProfit;
	}

	public List<VehicleTripEntryDAO> getVehicleTripEntryInfoList() {
		return vehicleTripEntryInfoList;
	}

	public void setVehicleTripEntryInfoList(List<VehicleTripEntryDAO> vehicleTripEntryInfoList) {
		this.vehicleTripEntryInfoList = vehicleTripEntryInfoList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	public Float getTotalTransportataionCharges() {
		return totalTransportataionCharges;
	}
	public void setTotalTransportataionCharges(Float totalTransportataionCharges) {
		this.totalTransportataionCharges = totalTransportataionCharges;
	}
	public String getBillNo() {
		return billNo;
	}
	public void setBillNo(String billNo) {
		this.billNo = billNo;
	}
	public String getCustomerName() {
		return customerName;
	}
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
	public ArrayList<VehicleConsumptionInfoDAO> getVehicleConInfoList() {
		return vehicleConInfoList;
	}
	public void setVehicleConInfoList(ArrayList<VehicleConsumptionInfoDAO> vehicleConInfoList) {
		this.vehicleConInfoList = vehicleConInfoList;
	}
	public Float getTotalConsumptionAmount() {
		return totalConsumptionAmount;
	}
	public void setTotalConsumptionAmount(Float totalConsumptionAmount) {
		this.totalConsumptionAmount = totalConsumptionAmount;
	}
	public Float getTotalQuantity() {
		return totalQuantity;
	}
	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}
	public ArrayList<VehicleMaintenanceInfoDAO> getVehicleMainInfoList() {
		return vehicleMainInfoList;
	}
	public void setVehicleMainInfoList(ArrayList<VehicleMaintenanceInfoDAO> vehicleMainInfoList) {
		this.vehicleMainInfoList = vehicleMainInfoList;
	}
	
	
	
}