package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.SupplierDebtReportDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadSupplierDebtReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -9001030197827726107L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;
	private Float minAmount;
	private Float maxAmount;
	private String startDate;
	private String endDate;
	private Float allTotalPurchaseAmount;
	private Float allTotalPaymentAmount;
	private Float allTotalDebtAmount;
	
	List<SupplierDebtReportDAO> supplierDebtList = new ArrayList<SupplierDebtReportDAO>();
	private String fromDate;
	private String toDate;
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		

        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();

		
        	
        	Date today = new Date(); // Fri Jun 17 14:54:28 PDT 2016 
        	
        	Calendar cal = Calendar.getInstance(); cal.setTime(today); // don't forget this if date is arbitrary e.g. 01-01-2014
        	int year = cal.get(Calendar.YEAR);
        	SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-YYYY");
        	
        	setStartDate("01-04-"+(year-1));
        	setEndDate(sdf.format(today));
        	
        	Connection connection = null;
    		PreparedStatement preparedStatement= null;
    		ResultSet resultSet = null;
    	 
    		String sql = "";
    		String db = (String) session.getAttribute("db");
    		
    		try
    		{
    			 Map<String,SupplierDebtReportDAO> supplierInfoMap = new LinkedHashMap<String,SupplierDebtReportDAO>();
	    			
					connection = GetDBConnection.getDBConnection(db);
    			
					sql = "SELECT "
	    					+ "supplier_id,"
	    					+ "supplier_name,"
	    					+ "contact_number,"
	    					+ "supplier_address "
	    					+ "FROM "
	    					+ "crusher_supplier_master "
	    					+ "WHERE "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
	    					+ "ORDER BY supplier_name ASC";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			preparedStatement.setString(1, crusherId);
    				preparedStatement.setString(2, crusherCode);
    				
	    			resultSet = preparedStatement.executeQuery();
	    			int count = 1;
	    			
	    			while(resultSet.next())
	    			{
	    				SupplierDebtReportDAO dao =  new SupplierDebtReportDAO();
	    				dao.setSrNo(count);
	    				dao.setSupplierName(resultSet.getString("supplier_name"));
	    				dao.setSupplierAddress(resultSet.getString("supplier_address"));
	    				
	    				supplierInfoMap.put(resultSet.getString(1), dao);
	    				count++;
	    			}
	    			
	    			if(resultSet != null)
	    			{
	    				resultSet.close();
	    				resultSet = null;
	    			}
	    			
	    			if(preparedStatement != null)
	    			{
	    				preparedStatement.close();
	    				preparedStatement = null;
	    			}
	    			
    			for(String supplierId : supplierInfoMap.keySet())
    			{
	    				
	    				SupplierDebtReportDAO dao = supplierInfoMap.get(supplierId);

						PreparedStatement getOpeningBalPSMT = null;
	       				ResultSet getOpeningBalRs = null;
	       				String getOpeningBalSQL = "SELECT "
	       						+ "opening_balance "
	       						+ "FROM "
	       						+ "crusher_supplier_close_open_bal_master "
	       						+ "WHERE "
	       						+ "supplier_id = ? "
	       						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	       				
	       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
	       				
	       				getOpeningBalPSMT.setString(1, supplierId);
	       				getOpeningBalPSMT.setString(2, crusherId);
	       				getOpeningBalPSMT.setString(3, crusherCode);
        				
	       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
	       				
	       				if(getOpeningBalRs.next())
	       				{
	       					dao.setOpeningBalance(getOpeningBalRs.getFloat(1));
	       				}
	       				else
	       				{
	       					dao.setOpeningBalance(0.0F);
	       				}
	       				
	       				if(getOpeningBalRs != null)
	       				{
	       					getOpeningBalRs.close();
	       					getOpeningBalRs = null;
	       				}
	       				if(getOpeningBalPSMT != null)
	       				{
	       					getOpeningBalPSMT.close();
	       					getOpeningBalPSMT = null;
	       				}
	       				
	       				
	       				float floatTotalPurchaseAmt = 0.0F;
	       				float floatTotalAmountPaid = 0.0F;
	       				float floatTotalBalanceAmt = 0.0F;
	       				
	       				
	       				PreparedStatement getTotalPurchasePSMT = null;
	       				ResultSet getTotalPurchaseRS = null;
	       				
	       				String getTotalPurchaseSQL = "SELECT "
	       						+ "SUM(purchase_total_amount),"
	       						+ "SUM(purchase_amount_paid) "
	       						+ "FROM "
	       						+ "crusher_purchase_master "
	       						+ "WHERE "
	       						+ "(purchase_date "
								+ "BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "supplier_id = ? "
	       						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	       				
	       				getTotalPurchasePSMT = connection.prepareStatement(getTotalPurchaseSQL);
	       				
	       				getTotalPurchasePSMT.setString(1, this.getFromDate());
	       				getTotalPurchasePSMT.setString(2, this.getToDate());
						getTotalPurchasePSMT.setString(3, supplierId);
	       				getTotalPurchasePSMT.setString(4, crusherId);
	       				getTotalPurchasePSMT.setString(5, crusherCode);
	       				
	       				getTotalPurchaseRS = getTotalPurchasePSMT.executeQuery();
	       				
	       				if(getTotalPurchaseRS.next())
	       				{
	       					floatTotalPurchaseAmt = getTotalPurchaseRS.getFloat(1);
	       					floatTotalAmountPaid = getTotalPurchaseRS.getFloat(2);
	       					
	       				}
	       				
	       				
	       				PreparedStatement getSuppAmtPaidPSMT = null;
	       				ResultSet getSuppAmtPaidRS = null;
	       				String getSuppAmtPaidSQL = "SELECT "
	       						+ "SUM(amount) "
	       						+ "FROM "
	       						+ "crusher_supplier_payment_details_master "
	       						+ "WHERE "
	       						+ "(payment_entry_date "
								+ "BETWEEN "
								+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
								+ "AND "
								+ "supplier_id = ? "
	       						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	       				
	       				getSuppAmtPaidPSMT = connection.prepareStatement(getSuppAmtPaidSQL);
	       				getSuppAmtPaidPSMT.setString(1, this.getFromDate());
	       				getSuppAmtPaidPSMT.setString(2, this.getToDate());
						getSuppAmtPaidPSMT.setString(3, supplierId);
	       				getSuppAmtPaidPSMT.setString(4, crusherId);
	       				getSuppAmtPaidPSMT.setString(5, crusherCode);
	       				
	       				
	       				getSuppAmtPaidRS = getSuppAmtPaidPSMT.executeQuery();
	       				
	       				
	       				
	       				if(getSuppAmtPaidRS.next())
	       				{
	       					floatTotalAmountPaid = floatTotalAmountPaid + getSuppAmtPaidRS.getFloat(1);
	       				}
	       				
	       				floatTotalBalanceAmt = floatTotalPurchaseAmt - floatTotalAmountPaid;
	       				
	       				dao.setTotalPurchaseAmount(floatTotalPurchaseAmt);
	       				dao.setTotalDebtAmount(floatTotalBalanceAmt+dao.getOpeningBalance());
	       				dao.setTotalPaymentAmount(floatTotalAmountPaid);
	       				
	       			//	System.out.println(floatTotalBalanceAmt+dao.getOpeningBalance());
	       				if(getSuppAmtPaidRS != null)
	       				{
	       					getSuppAmtPaidRS.close();
	       					getSuppAmtPaidRS = null;
	       				}
	       				
	       				if(getSuppAmtPaidPSMT != null)
	       				{
	       					getSuppAmtPaidPSMT.close();
	       					getSuppAmtPaidPSMT = null;
	       				}
	       				
	       				
	       				
	       				if(getTotalPurchaseRS != null)
	       				{
	       					getTotalPurchaseRS.close();
	       					getTotalPurchaseRS = null;
	       				}
	       				
	       				if(getTotalPurchasePSMT != null)
	       				{
	       					getTotalPurchasePSMT.close();
	       					getTotalPurchasePSMT = null;
	       				}
	       				
	       				supplierInfoMap.put(supplierId, dao);
	       				
    			}
    			this.setAllTotalDebtAmount(0.0F);
    			this.setAllTotalPaymentAmount(0.0F);
    			this.setAllTotalPurchaseAmount(0.0F);
    			for(String supplierId : supplierInfoMap.keySet())
    			{
    				this.setAllTotalDebtAmount(this.getAllTotalDebtAmount()+supplierInfoMap.get(supplierId).getTotalDebtAmount());
    				this.setAllTotalPurchaseAmount(this.getAllTotalPurchaseAmount()+supplierInfoMap.get(supplierId).getTotalPurchaseAmount());
    				this.setAllTotalPaymentAmount(this.getAllTotalPaymentAmount()+supplierInfoMap.get(supplierId).getTotalPaymentAmount());
    				this.getSupplierDebtList().add(supplierInfoMap.get(supplierId));
    			}
    			
    			
    			@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
				
    			
    			String path=	request.getSession().getServletContext().getRealPath("/images/");
    			PDDocument document = new PDDocument(); 
				PDPage page = null;
				
				
				Date date = new Date();
				
				String dateToday = sdf.format(date); 
					 page = new PDPage(PDRectangle.A4);
				
				
			        document.addPage(page);
			         PDPageContentStream contentStream = new PDPageContentStream(document, page);
			         int pageCount = 1;
		    			 Table header;
		    			 Table creditDetails;
		    			 
		    			
		    			  TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row info1 = Row.builder()
					                .add(TextCell.builder().text("Supplier Debt Report From Date: "
					                			+startDate+" To Date : "+endDate +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info2 = Row.builder()
					                .add(TextCell.builder().text("Report generated for Minimum Debt Amount: "
					                		+ ""+this.getMinAmount()
					                		+ "and Maximum Debt Amount:"+this.getMaxAmount()+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				          
				          tableHeaderBuilder.addRow(headerName);
				          tableHeaderBuilder.addRow(info1);
				          tableHeaderBuilder.addRow(info2);
				          header = tableHeaderBuilder.build();
				          
				          
				          TableBuilder tableDebtDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(40,140,130,60,60,60,60)				                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				          
				          Row tableHeader = Row.builder()
				        		  	.add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Supplier Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Opening Bal").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Purchase Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Paid Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Debt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          tableDebtDetailsBuilder.addRow(tableHeader);
				       
				        
				     
				        	  int size = this.getSupplierDebtList().size();
				        	  
				        	  
					          float startY = page.getMediaBox().getHeight() - PADDING20;
					          float currentY = startY;
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
					          
					          
					          
					    	  for(int s=0;s<size;s++)
				        	  {
				        		  
				        		  if(currentY < 50)
				        		  {
				        			  pageCount++;
				        			  creditDetails = tableDebtDetailsBuilder.build();
				        			  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(creditDetails)
						                .startX(PADDING30)
						                .startY(startY-50)
						                .build()
						                .draw();
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			 
						    			 
						    			
						    			  tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(550)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								           headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								           info1 = Row.builder()
									                .add(TextCell.builder().text("Supplier Debt Report From Date: "
									                			+startDate+" To Date : "+endDate +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
								           info2 = Row.builder()
									                .add(TextCell.builder().text("Report generated for Minimum Debt Amount: "
									                		+ ""+this.getMinAmount()
									                		+ "and Maximum Debt Amount:"+this.getMaxAmount()+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								          header = tableHeaderBuilder.build();
				        			  
				        			  creditDetails = null;
				        			   tableDebtDetailsBuilder = Table.builder()
								                .addColumnsOfWidth(40,140,130,60,60,60,60)				                
								                .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							           tableHeader = Row.builder()
							        		 	.add(TextCell.builder().text("Sr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text("Supplier Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Opening Bal").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text("Purchase Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Paid Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Debt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                 .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          tableDebtDetailsBuilder.addRow(tableHeader);
							          
				        			  
				        				PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
				        		  }
				        		  
				        		  SupplierDebtReportDAO dao2 = this.getSupplierDebtList().get(s);
				        		  
				        			Row supplierInfo = Row.builder()
					        			  	.add(TextCell.builder().text(""+(s+1)).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getSupplierName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getSupplierAddress()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getOpeningBalance()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getTotalPurchaseAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getTotalPaymentAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getTotalDebtAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableDebtDetailsBuilder.addRow(supplierInfo);
					        	 
					        	  currentY = currentY -25;
				        	  }
					          
					    	  Row custInfo = Row.builder()
				        			  	.add(TextCell.builder().text("Total").colSpan(4).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        			  	.add(TextCell.builder().text(""+this.getAllTotalPurchaseAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        			  	.add(TextCell.builder().text(""+this.getAllTotalPaymentAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        			  	.add(TextCell.builder().text(""+this.getAllTotalDebtAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        			  	.backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD)
						                .fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .height(15F)					                
						                .build();
				        	  
				        	  tableDebtDetailsBuilder.addRow(custInfo);
				        	  creditDetails = tableDebtDetailsBuilder.build();
				         
				          
				          TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(creditDetails)
			                .startX(PADDING30)
			                .startY(startY-50)
			                .build()
			                .draw();
				          contentStream.close();
					          
					          
					          
					          document.save(path+"/supp-debt-report.pdf");
						        document.close();
						        
						        response.setHeader("Content-disposition", "inline; filename=supp-debt-report.pdf");
								response.setContentType("application/pdf");
								
								FileInputStream fileInputStream = new FileInputStream(path+"/supp-debt-report.pdf");
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.flush();
								out.close();
    			
    		}
    		catch (SQLException e) 
    		{
	    			//e.printStackTrace();
	    				    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    			
	    	} catch (IOException e) {
	    		
	    				    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || Something Went Wrong!");
	    	}
    			finally {
    				if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
        }
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public Float getMinAmount() {
		return minAmount;
	}


	public void setMinAmount(Float minAmount) {
		this.minAmount = minAmount;
	}


	public Float getMaxAmount() {
		return maxAmount;
	}


	public void setMaxAmount(Float maxAmount) {
		this.maxAmount = maxAmount;
	}


	public String getStartDate() {
		return startDate;
	}


	public void setStartDate(String startDate) {
		this.startDate = startDate;
	}


	public String getEndDate() {
		return endDate;
	}


	public void setEndDate(String endDate) {
		this.endDate = endDate;
	}


	public Float getAllTotalPurchaseAmount() {
		return allTotalPurchaseAmount;
	}


	public void setAllTotalPurchaseAmount(Float allTotalPurchaseAmount) {
		this.allTotalPurchaseAmount = allTotalPurchaseAmount;
	}


	public Float getAllTotalPaymentAmount() {
		return allTotalPaymentAmount;
	}


	public void setAllTotalPaymentAmount(Float allTotalPaymentAmount) {
		this.allTotalPaymentAmount = allTotalPaymentAmount;
	}


	public Float getAllTotalDebtAmount() {
		return allTotalDebtAmount;
	}


	public void setAllTotalDebtAmount(Float allTotalDebtAmount) {
		this.allTotalDebtAmount = allTotalDebtAmount;
	}


	public List<SupplierDebtReportDAO> getSupplierDebtList() {
		return supplierDebtList;
	}


	public void setSupplierDebtList(List<SupplierDebtReportDAO> supplierDebtList) {
		this.supplierDebtList = supplierDebtList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}
	

}
