package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.SupplierAccountDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DownloadSupplierAccStmtReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -612091481218640033L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;
    
    private HttpSession session;
    private String returnMessage;
	private String key;
	
	private String fromDate;
	private String toDate;
	
	
	private Float totalPurchaseAmountBeforeDate;
	private Float totalAmountPaidBeforeDate;
	private Float totalDebtAmountBeforeDate;
	
	private Float totalPurchaseAmountAllTheTime;
	private Float totalAmountPaidAllTheTime;
	private Float totalDebtAmountAllTheTime;
	
	private Float totalPurchaseAmountBetweenDates = 0.0f;
	private Float totalAmountPaidBetweenDates = 0.0f;
	private Float totalDebtAmountBetweenDates = 0.0f;
	
	
	private List<SupplierAccountDetailsDAO> supplierAccountDetailsList = new ArrayList<SupplierAccountDetailsDAO>();
	private List<SupplierAccountDetailsDAO> supplierAccountDetailsSortedList = new ArrayList<SupplierAccountDetailsDAO>();
	
	private Float supplierOpeningBalnce = 0.0F;
	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
	
 public void download() throws ParseException
	
    {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	response = ServletActionContext.getResponse();
				request = ServletActionContext.getRequest();
				
				String supplierId = EncryptionDecryption.decrypt(getKey());
		        
	        	setKey(EncryptionDecryption.encrypt(supplierId));
	        	

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			
	       			
					connection = GetDBConnection.getDBConnection(db);
	
	       			
					 String nameOfSupplier = "";
	                  String supplierAddress = "";
		       			    
						connection = GetDBConnection.getDBConnection(db);
		       			
						sql = "SELECT "
								+ "supplier_name,"
								+ "supplier_address "
								+ "FROM "
								+ "crusher_supplier_master "
								+ "WHERE "
								+ "supplier_id = ? "
								+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, supplierId);
						preparedStatement.setString(2, crusherId);
	    				preparedStatement.setString(3, crusherCode);
	    				
	    				resultSet = preparedStatement.executeQuery();
						 
						 if(resultSet.next())
						 {
							 nameOfSupplier = resultSet.getString(1); 
							 supplierAddress = resultSet.getString(2); 
						 }
								
						 if(resultSet != null)
			       			{
			       				resultSet.close();
			       				resultSet = null;
			       			}
						 if(preparedStatement != null)
		       				{
		       					preparedStatement.close();
		       					preparedStatement = null;
		       				}
		       			
						 
						 
	       			PreparedStatement getOpeningBalPSMT = null;
       				ResultSet getOpeningBalRs = null;
       				String getOpeningBalSQL = "SELECT "
       						+ "opening_balance,"
       						+ "DATE_FORMAT(opening_balance_date,'%d/%m/%Y'),"
       						+ "update_by "
       						+ "FROM "
       						+ "crusher_supplier_close_open_bal_master "
       						+ "WHERE "
       						+ "supplier_id = ? "
       						+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
       				
       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
       				
       				getOpeningBalPSMT.setString(1, supplierId);
       				getOpeningBalPSMT.setString(2, crusherId);
       				getOpeningBalPSMT.setString(3, crusherCode);
    				
       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
       				
       				if(getOpeningBalRs.next())
       				{
       					this.setSupplierOpeningBalnce(getOpeningBalRs.getFloat(1));
       					this.setOpeingBalanceUpdateDate(getOpeningBalRs.getString(2));
       					this.setOpeingBalancUpdatedBy(getOpeningBalRs.getString(3));
       				}
       				else
       				{
       					this.setSupplierOpeningBalnce(0.0F);
       				}
       				if(getOpeningBalRs != null)
       				{
       					getOpeningBalRs.close();
       					getOpeningBalRs = null;
       				}
       				if(getOpeningBalPSMT != null)
       				{
       					getOpeningBalPSMT.close();
       					getOpeningBalPSMT = null;
       				}
       				
	       			
	       			
	       			sql = "SELECT "
	       					+ "SUM(amount) "
	       					+ "FROM "
	       					+ "crusher_supplier_payment_details_master "
	       					+ "WHERE "
	       					+ "supplier_id = ? "
	       					+ "and "
	       					+ "payment_entry_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				if(resultSet.getString(1) != null)
	       				{
	       					this.setTotalAmountPaidBeforeDate(resultSet.getFloat(1));
	       				}
	       				else
	       				{
	       					this.setTotalAmountPaidBeforeDate(0.0F);
	       				}
	       			}
	       			else
	       			{
	       				this.setTotalAmountPaidBeforeDate(0.0F);
	       			}
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement = null;
	       			}
	       			
	       			
	       			float floatPurchaseAmt = 0.0F;
       				float floatAmtPaid = 0.0F;
       				float floatBalanceAmt = 0.0F;
       				float totalBalanceAmt = 0.0F;
       				float totalAmountPaid = this.getTotalAmountPaidBeforeDate();
       				float totalPurchaseAmountBeforeDate = 0.0F;
       				
       				
       				sql = "SELECT "
       						+ "purchase_total_amount,"
       						+ "purchase_amount_paid "
       						+ "FROM "
       						+ "crusher_purchase_master "
       						+ "WHERE "
	       					+ "supplier_id = ? "
	       					+ "AND "
	       					+ "purchase_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, supplierId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			while(resultSet.next())
	       			{
	       				
	       				try
	       				{
	       					floatPurchaseAmt = resultSet.getFloat(1);
	       					floatAmtPaid =  resultSet.getFloat(2);
	       				
	       					totalPurchaseAmountBeforeDate = totalPurchaseAmountBeforeDate + floatPurchaseAmt;
	       					
	       					floatBalanceAmt = resultSet.getFloat(1) - resultSet.getFloat(2);
	       					
	       					if(floatBalanceAmt > 0 )
	       					{
	       						totalBalanceAmt = totalBalanceAmt + floatBalanceAmt;
	       						totalAmountPaid = totalAmountPaid + floatAmtPaid;
	       					}
	       					else
	       					{
	       						totalAmountPaid = totalAmountPaid + floatAmtPaid;
	       					}
	       					
	       				}
	       				catch(Exception e)
	       				{
	       					
	       					addActionError("One Of the purchase invoice could not be processed!");
	       				}
	       				
	       			}
	       			if(!hasActionErrors())
	       			{
	       				this.setTotalPurchaseAmountBeforeDate(totalPurchaseAmountBeforeDate);
	       				this.setTotalAmountPaidBeforeDate(totalAmountPaid);
	       				this.setTotalDebtAmountBeforeDate((totalPurchaseAmountBeforeDate-totalAmountPaid));
	       				
       				
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "supplier_id,"
	       						+ "DATE_FORMAT(payment_entry_date, '%d/%m/%Y'),"
	       						+ "amount,"
	       						+ "payment_details,"
	       						+ "entry_by "
	       						+ "FROM "
	       						+ "crusher_supplier_payment_details_master "
	       						+ "WHERE "
	       						+ "supplier_id = ?"
			       				+ "AND "
		       					+ "(payment_entry_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, supplierId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
        				preparedStatement.setString(5, crusherCode);
        				
	       				resultSet = preparedStatement.executeQuery();
	       				
	       				while(resultSet.next())
	       				{
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
	    	       			
	       				
	       					SupplierAccountDetailsDAO dao = new SupplierAccountDetailsDAO();
	       					dao.setPaymentPurchaseId(resultSet.getString(1));
	       					dao.setDate(date1);
	       					dao.setAmountPaid(resultSet.getFloat(4));
	       					dao.setComments(resultSet.getString(5));
	       					dao.setEntryBy(resultSet.getString(6));
	       					dao.setBalanceAmount(0.0F);
	       					dao.setPurchaseAmount("0.0");       					
	       					dao.setEntryType("PAYMENT");
	       					this.getSupplierAccountDetailsList().add(dao);
	       				}
	       				
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				sql = "SELECT "
	       						+ "purchase_id,"
	       						+ "purchase_invoice_number,"
	       						+ "DATE_FORMAT(purchase_date,'%d/%m/%Y'),"
	       						+ "tarnsportation_charges,"
	       						+ "other_expenses,"
	       						+ "purchase_total_amount,"
	       						+ "purchase_amount_paid,"
	       						+ "comments,"
	       						+ "purcahsed_by,"
	       						+ "purchase_entry_by "
	       						+ "FROM "
	       						+ "crusher_purchase_master "
	       						+ "WHERE "
	       						+ "supplier_id = ? "
	       						+ "AND "
		       					+ "(purchase_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, supplierId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
        				preparedStatement.setString(5, crusherCode);
        				
	       				resultSet = preparedStatement.executeQuery();
	       				while(resultSet.next())
	       				{
	       					SupplierAccountDetailsDAO dao = new SupplierAccountDetailsDAO();
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
    	       				
	       					dao.setEntryType("PURCHASE");
	       					dao.setPaymentPurchaseId(resultSet.getString(1));
	       				    dao.setPuchaseNumber(resultSet.getString(1));
	       					dao.setInvoiceNumber(resultSet.getString(2));
	       					dao.setDate(date1);
	       					dao.setPurchaseAmount(resultSet.getString(6));
	       					dao.setAmountPaid(resultSet.getFloat(7));
	       					dao.setBalanceAmount(resultSet.getFloat(6) - resultSet.getFloat(7));
	       					dao.setComments(resultSet.getString(8));
	       					dao.setPurchaseBy(resultSet.getString(9));
	       					dao.setEntryBy(resultSet.getString(10));
	       					dao.setDebtAmount(0.0F);
	       					this.getSupplierAccountDetailsList().add(dao);
	       					
	       				}
	       				
	       				
	       				for(SupplierAccountDetailsDAO dao : this.getSupplierAccountDetailsList())
	       				{
	       				 DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");  
						 Date d = dao.getDate();
						 dao.setDateAsString(dateFormat.format(d));
	       					
	       					try
	       					{
	       						this.setTotalAmountPaidBetweenDates(this.getTotalAmountPaidBetweenDates() + dao.getAmountPaid());
		       					this.setTotalPurchaseAmountBetweenDates(this.getTotalPurchaseAmountBetweenDates() + Float.parseFloat(dao.getPurchaseAmount()));
		       					
	       					}
	       					catch(NumberFormatException nfe)
	       					{
	       						addActionError("Error while nuber formation!");
	       						
	       					}
	       				}
	       				this.setTotalDebtAmountBetweenDates(this.getTotalPurchaseAmountBetweenDates() - this.getTotalAmountPaidBetweenDates());
	       				
	       				this.setTotalAmountPaidAllTheTime(this.getTotalAmountPaidBeforeDate() + this.getTotalAmountPaidBetweenDates());
	       				this.setTotalPurchaseAmountAllTheTime(this.getTotalPurchaseAmountBeforeDate()+ this.getTotalPurchaseAmountBetweenDates());
	       				this.setTotalDebtAmountAllTheTime(this.getTotalDebtAmountBeforeDate() + this.getTotalDebtAmountBetweenDates());
	       				if(!hasActionErrors())
	       				{
	       					

   						 
   						 Collections.sort(this.getSupplierAccountDetailsList(), new Comparator<SupplierAccountDetailsDAO>() {
   							  public int compare(SupplierAccountDetailsDAO o1, SupplierAccountDetailsDAO o2) {
   							      if (o1.getDate() == null || o2.getDate() == null)
   							        return 0;
   							      return o1.getDate().compareTo(o2.getDate());
   							  }
   							});
	       					
   						 
   						 float currentDebtAmount = this.getSupplierOpeningBalnce() + this.getTotalDebtAmountBeforeDate();
   						 
   						this.setTotalDebtAmountAllTheTime(this.getTotalDebtAmountAllTheTime()+this.getSupplierOpeningBalnce());
   						for(SupplierAccountDetailsDAO dao : this.getSupplierAccountDetailsList())
	       				{
   							if(dao.getEntryType().equals("PURCHASE"))
   							{
   								dao.setDebtAmount(currentDebtAmount + dao.getBalanceAmount());
   								
   								currentDebtAmount = currentDebtAmount + dao.getBalanceAmount();
   							}
   							else if(dao.getEntryType().equals("PAYMENT"))
   							{
   								dao.setDebtAmount(currentDebtAmount - dao.getAmountPaid());
   								currentDebtAmount = currentDebtAmount -  dao.getAmountPaid();
   							}
	       				}
   						
   						
   						
   						for(SupplierAccountDetailsDAO dao : this.getSupplierAccountDetailsList())
	       				{
						 
						  String getProductInfoSQL = "";
						  PreparedStatement getProductInfoPSMT = null;
						  ResultSet getProductInfoRS = null;
						 
						 
						  getProductInfoSQL = "SELECT "
							  		+ "product_name,"
							  		+ "purchase_quantity,"
							  		+ "purchase_rate "
							  		+ "FROM "
							  		+ "crusher_purchase_product_info_master "
							  		+ "WHERE "
							  		+ "purchase_id = ? "
							  		+ "AND "
							  		+ "crusher_id = ? "
							  		+ "AND "
							  		+ "crusher_code = ? ";
						  
						  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
						  
						  getProductInfoPSMT.setString(1, dao.getPuchaseNumber());
						  getProductInfoPSMT.setString(2, crusherId);
						  getProductInfoPSMT.setString(3, crusherCode);
						 
						  
						  getProductInfoRS = getProductInfoPSMT.executeQuery();
					 
						
						  StringBuilder productNames = new StringBuilder();
						  StringBuilder quantities = new StringBuilder();
						  
						  
						  while(getProductInfoRS.next())
						  {
							  
							  String productName = getProductInfoRS.getString(1);
							    float quantity = getProductInfoRS.getFloat(2);

							     boolean found = false;
							    for (Map<String, Object> productInfo : productQuantityList) {
							        if (productInfo.get("productName").equals(productName)) {
							            float existingQuantity = (float) productInfo.get("quantity");
							            productInfo.put("quantity", existingQuantity + quantity);
							            found = true;
							            break;
							        }
							    }

							   if (!found) {
							        Map<String, Object> newProduct = new LinkedHashMap<>();
							        newProduct.put("productName", productName);
							        newProduct.put("quantity", quantity);
							        productQuantityList.add(newProduct);
							    }
							   
							   
							   if (productNames.length() > 0) {
							        productNames.append(" / ");
							        quantities.append(" / ");
							    }
							  
							  productNames.append(getProductInfoRS.getString(1));  
							    quantities.append(getProductInfoRS.getString(2));    

							    dao.setItemNameAll(productNames.toString());  
							    dao.setItemQuantityAll(quantities.toString());
							    
							   
							    
							    
							  dao.setItemRate(getProductInfoRS.getString(3));
							 
							 
							 
						  }
						  
						  
						  
						  
						  
						  
	       				}
   						
   						
   						
	       				
	       				}
	       			}
	       			
	       			
	       			
	       			
	       			@SuppressWarnings("unchecked")
					String crusherName = (String) this.getSessionMap().get("crushernameenglish");
				    
					
	       		 
					 String path=	request.getSession().getServletContext().getRealPath("/images/");
		    			PDDocument document = new PDDocument(); 
						PDPage page = null;
						
						SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-Y");
						Date date = new Date();
						
						String dateToday = sdf.format(date); 
						page = 	new PDPage(PDRectangle.A4);
						
						 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
						 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
						 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
						
					        document.addPage(page);
					         PDPageContentStream contentStream = new PDPageContentStream(document, page);
					         int pageCount = 1;
				    			 
					         Table header;
					         Table productTable = null;
						          
				    			
				    			  TableBuilder tableHeaderBuilder = Table.builder()
							                .addColumnsOfWidth(560)				                
							                .font(HELVETICA)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);
						         
						          Row headerName = Row.builder()
							                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
							                .horizontalAlignment(CENTER)
							                .build();
						          
						          
						          Row info1 = Row.builder()
							                .add(TextCell.builder().text("Supplier Account Statement").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							                .horizontalAlignment(CENTER)
							                .build();
						          
						          Row info2 = Row.builder()
							                .add(TextCell.builder().text("Name :- "+nameOfSupplier+"   Address:- "+supplierAddress+"  (Opening Bal:"+this.getSupplierOpeningBalnce()+")").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							                .horizontalAlignment(CENTER)
							                .build();
						          
						          Row info3 = Row.builder()
							                .add(TextCell.builder().text("From Date: "
							                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
							                .backgroundColor(WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
							                .horizontalAlignment(CENTER)
							                .build();
						          
						       
						          tableHeaderBuilder.addRow(headerName);
						          tableHeaderBuilder.addRow(info1);
						          tableHeaderBuilder.addRow(info2);
						          tableHeaderBuilder.addRow(info3);
						          header = tableHeaderBuilder.build();
						          
						          Table beforeDateDetails ;
						          TableBuilder beforeDateDetailsBuilder = Table.builder()
							                .addColumnsOfWidth(175,175,175)				                
							                .font(HELVETICA)
							                .borderWidth(0.5F)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);
						          
						          Row beforeDateDetailsHeader = Row.builder()
						        		  .add(TextCell.builder().text("Purchase amount before date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text("Amount paid before date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Debt amount before date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
							                     
							                .backgroundColor(Color.LIGHT_GRAY)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)				              
							                .horizontalAlignment(CENTER)
							                .build();
						          beforeDateDetailsBuilder.addRow(beforeDateDetailsHeader);
						          
						          
						          Row beforeDateDetailsRow1 = Row.builder()
						        		    .add(TextCell.builder().text(""+this.getTotalPurchaseAmountBeforeDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text(""+this.getTotalAmountPaidBeforeDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text(""+this.getTotalDebtAmountBeforeDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
							                .backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)				              
							                .horizontalAlignment(CENTER)
							                .build();
						          beforeDateDetailsBuilder.addRow(beforeDateDetailsRow1);
						          
						          beforeDateDetails = beforeDateDetailsBuilder.build();
						          
						          
						          
						          Table stateMentDetails ;
						          
						          TableBuilder statementDetailsBuilder = Table.builder()
						        		  .addColumnsOfWidth(40,40,50,30,40,50,50,50,60,50,40,50)				                
							               .font(HELVETICA)
							                .borderWidth(0.5F)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);
						          
						          
						          Row tableDetailsHeader = Row.builder()
						        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text("Invoice Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Purchase Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Amount Paid").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Balance Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							                .add(TextCell.builder().text("Debt Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Purchase By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
							                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
							                .add(TextCell.builder().text("Comments").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                  
							                .backgroundColor(Color.LIGHT_GRAY)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .build();
						          statementDetailsBuilder.addRow(tableDetailsHeader);
						          
						          
						          int size = this.getSupplierAccountDetailsList().size();
						          
						          float startY = page.getMediaBox().getHeight() - PADDING20;
						          float currentY = startY;
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(header)
					                .startX(PADDING30)
					                .startY(startY)
					                .build()
					                .draw();
						          
						          currentY = currentY - 70;
						          startY = startY - 70; 
							         TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(beforeDateDetails)
					                .startX(PADDING30)
					                .startY(currentY)
					                .build()
					                .draw();
						          
						          for(int s=0;s<size;s++)
					        	  {
					        		  if(currentY < 130)
					        		  {
					        			  pageCount++;
					        			  stateMentDetails = statementDetailsBuilder.build();
					        			  TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(stateMentDetails)
							                .startX(PADDING30)
							                .startY(startY-70)
							                .build()
							                .draw();
					        			  
					        			  contentStream.close();
					        			  
					        			  header = null;
					        			  
					        			  

    					    			  tableHeaderBuilder = Table.builder()
    								                .addColumnsOfWidth(550)				                
    								                .font(HELVETICA)
    								                .borderColor(Color.BLACK)
    								                .horizontalAlignment(CENTER);
    							         
    							          headerName = Row.builder()
    								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
    								                .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           info1 = Row.builder()
    								                .add(TextCell.builder().text("Supplier Account Statement").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
    								                .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           info2 = Row.builder()
    							        		   	.add(TextCell.builder().text("Name :- "+nameOfSupplier+"   Address:- "+supplierAddress+"  (Opening Bal:"+this.getSupplierOpeningBalnce()+")").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
    										        .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           info3 = Row.builder()
  								                .add(TextCell.builder().text("From Date: "
  								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
  								                .backgroundColor(WHITE)
  								                .textColor(Color.BLACK)
  								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
  								                .horizontalAlignment(CENTER)
  								                .build();
    							          
    							       
    							          tableHeaderBuilder.addRow(headerName);
    							          tableHeaderBuilder.addRow(info1);
    							          tableHeaderBuilder.addRow(info2);
    							          tableHeaderBuilder.addRow(info3);
    							          header = tableHeaderBuilder.build();
    							          
    							          
    							          statementDetailsBuilder = Table.builder()
    							        		  .addColumnsOfWidth(40,40,50,30,40,50,50,50,60,50,40,50)				                
    								                 .font(HELVETICA)
    								                .borderWidth(0.5F)
    								                .borderColor(Color.BLACK)
    								                .horizontalAlignment(CENTER);
    							          
    							          
    							          tableDetailsHeader = Row.builder()
    							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        		  .add(TextCell.builder().text("Invoice Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
    							        		  .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
  								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
  								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
  								                .add(TextCell.builder().text("Purchase Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
    								                .add(TextCell.builder().text("Amount Paid").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
    								                .add(TextCell.builder().text("Balance Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    								                .add(TextCell.builder().text("Debt Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
    								                .add(TextCell.builder().text("Purchase By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
    								                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
    								                .add(TextCell.builder().text("Comments").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.5F).build())									                
    									                  
    								                      
    								                .backgroundColor(Color.LIGHT_GRAY)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          statementDetailsBuilder.addRow(tableDetailsHeader);
					        			  
    							          
    							      	PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
					        		  }
					        		  DecimalFormat df = new DecimalFormat("#.##");
					        		  SupplierAccountDetailsDAO dao = this.getSupplierAccountDetailsList().get(s);
					        		  Row custInfo = Row.builder()
						        			  	.add(TextCell.builder().text(dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getInvoiceNumber()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getItemNameAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.add(TextCell.builder().text(""+dao.getItemQuantityAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.add(TextCell.builder().text(""+dao.getItemRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.add(TextCell.builder().text(dao.getPurchaseAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(df.format(dao.getAmountPaid())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(df.format(dao.getBalanceAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(df.format(dao.getDebtAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getPurchaseBy()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(dao.getEntryBy()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(dao.getComments()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA)
								                .fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .height(25F)					                
								                .build();
						        	  
					        			statementDetailsBuilder.addRow(custInfo);
						        	 
						        	  currentY = currentY -25;
					        		  
					        	  }
					        	  
						          

									TableBuilder productTableBuilder = Table.builder()
											.addColumnsOfWidth(200, 133).font(HELVETICA)
											.borderWidth(0.5F).borderColor(Color.BLACK)
											.horizontalAlignment(CENTER);

									
									
									Row productHeader = Row.builder()
											.add(TextCell.builder().text("Product Name")
													.horizontalAlignment(LEFT).borderWidth(0.5F)
													.build())
											.add(TextCell.builder().text("Total Quantity")
													.horizontalAlignment(LEFT).borderWidth(0.5F)
													.build())
											.backgroundColor(Color.LIGHT_GRAY)
											.textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
											.fontSize(8).height(20F).horizontalAlignment(CENTER)
											.build();
									productTableBuilder.addRow(productHeader);

									for (Map<String, Object> product : productQuantityList) {

										
										
										 String productName = product.get("productName") != null ? product.get("productName").toString() : "";
		     							    double quantity = product.get("quantity") != null ? Double.parseDouble(product.get("quantity").toString()) : 0.0;

		     							    
										Row productRow = Row.builder()
												.add(TextCell.builder().text("" + productName)
														.horizontalAlignment(LEFT).borderWidth(0.5F)
														.build())
												.add(TextCell.builder().text("" + quantity)
														.horizontalAlignment(LEFT).borderWidth(0.5F)
														.build())
												.backgroundColor(Color.WHITE).textColor(Color.BLACK)
												.font(PDType1Font.HELVETICA).fontSize(10)
												.height(20F).horizontalAlignment(CENTER).build();

										productTableBuilder.addRow(productRow);
									}

									productTable = productTableBuilder.build();
									  
									  
									  
				        	  
				        	  
				          
			        	  
			        	  
			        	  
			        	 
			        	  
			        	  
			        	  stateMentDetails = statementDetailsBuilder.build();
			        	  
			        	  
			        	  
			        	  
			        	    
					        	  
					        	  
					        	  TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(stateMentDetails)
					                .startX(PADDING30)
					                .startY(startY-40)
					                .build()
					                .draw();
					        	  
					        	  Table totalInfo ;
					        	  
					        	  TableBuilder  totalTableBuilder = Table.builder()
							                .addColumnsOfWidth(133,133)				                
							                .font(HELVETICA)
							                .borderWidth(0.5F)
							                .borderColor(Color.BLACK)
							                .horizontalAlignment(CENTER);

						        	  Row totalBillAmt = Row.builder()
						        			  	.add(TextCell.builder().text("Total Purchase Amount : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getTotalPurchaseAmountAllTheTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA)
								                .fontSize(10)				              
								                .horizontalAlignment(CENTER)
								                .height(25F)					                
								                .build();
						        	  Row totalAmtReceived = Row.builder()
						        			  	.add(TextCell.builder().text("Total Amount Paid: ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA)
								                .fontSize(10)				              
								                .horizontalAlignment(CENTER)
								                .height(25F)					                
								                .build();
						        	  
						        	  Row openBalAmt = Row.builder()
						        			  	.add(TextCell.builder().text("Opening Balance Amount : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getSupplierOpeningBalnce()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA)
								                .fontSize(10)				              
								                .horizontalAlignment(CENTER)
								                .height(25F)					                
								                .build();
						        	  
						        	  Row totalAmtOutstanding = Row.builder()
						        			  	.add(TextCell.builder().text("Total Amount Debt: ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.add(TextCell.builder().text(""+this.getTotalDebtAmountAllTheTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			  	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA)
								                .fontSize(10)				              
								                .horizontalAlignment(CENTER)
								                .height(25F)					                
								                .build();
						        	  
						        	  totalTableBuilder.addRow(totalBillAmt);
						        	  totalTableBuilder.addRow(totalAmtReceived);
						        	  totalTableBuilder.addRow(openBalAmt);
						        	  totalTableBuilder.addRow(totalAmtOutstanding);
						        	  totalInfo = totalTableBuilder.build(); 
						        	  
						        	  
						        	  Table betweenDatestotalInfo ;
						        	  
						        	  TableBuilder  betweenDatesTableBuilder = Table.builder()
								                .addColumnsOfWidth(220,133)				                
								                .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);

  						        	  Row betweenDatestotalBillAmt = Row.builder()
							        			  	.add(TextCell.builder().text("Total Purchase Amount Between Dates : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getTotalPurchaseAmountBetweenDates()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA)
									                .fontSize(10)				              
									                .horizontalAlignment(CENTER)
									                .height(25F)					                
									                .build();
  						        	  Row betweenDatestotalAmtReceived = Row.builder()
							        			  	.add(TextCell.builder().text("Total Amount Paid Between Dates : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidBetweenDates()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA)
									                .fontSize(10)				              
									                .horizontalAlignment(CENTER)
									                .height(25F)					                
									                .build();
  						        	  
  						        	  Row betweenDatesopenBalAmt = Row.builder()
							        			  	.add(TextCell.builder().text("Opening Balance Amount : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getSupplierOpeningBalnce()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA)
									                .fontSize(10)				              
									                .horizontalAlignment(CENTER)
									                .height(25F)					                
									                .build();
  						        	  Row betweenDatestotalAmtOutstanding = Row.builder()
							        			  	.add(TextCell.builder().text("Total Amount Debt Between Dates : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.add(TextCell.builder().text(""+this.getTotalDebtAmountBetweenDates()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
							        			  	.backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA)
									                .fontSize(10)				              
									                .horizontalAlignment(CENTER)
									                .height(25F)					                
									                .build();
							        	  
  						        	betweenDatesTableBuilder.addRow(betweenDatestotalBillAmt);
  						        	betweenDatesTableBuilder.addRow(betweenDatestotalAmtReceived);
  						        	betweenDatesTableBuilder.addRow(betweenDatesopenBalAmt);
  						        	betweenDatesTableBuilder.addRow(betweenDatestotalAmtOutstanding);
  						        	betweenDatestotalInfo = betweenDatesTableBuilder.build();
  						        	  
						        	  
						        	  if(currentY < 250)
    						          {
    						        	  pageCount++;
					        			
					        			  
					        			  contentStream.close();
					        			  
					        			  header = null;
					        			  
					        			  

    					    			  tableHeaderBuilder = Table.builder()
    								                .addColumnsOfWidth(550)				                
    								                .font(HELVETICA)
    								                .borderColor(Color.BLACK)
    								                .horizontalAlignment(CENTER);
    							         
    							          headerName = Row.builder()
    								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
    								                .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           info1 = Row.builder()
    								                .add(TextCell.builder().text("Supplier Account Statement").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
    								                .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           info2 = Row.builder()
   							        		   	.add(TextCell.builder().text("Name :- "+nameOfSupplier+"   Address:- "+supplierAddress+"  (Opening Bal:"+this.getSupplierOpeningBalnce()+")").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
   									           .backgroundColor(WHITE)
    								                .textColor(Color.BLACK)
    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
    								                .horizontalAlignment(CENTER)
    								                .build();
    							          
    							           info3 = Row.builder()
  								                .add(TextCell.builder().text("From Date: "
  								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
  								                .backgroundColor(WHITE)
  								                .textColor(Color.BLACK)
  								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
  								                .horizontalAlignment(CENTER)
  								                .build();
    							          
    							       
    							          tableHeaderBuilder.addRow(headerName);
    							          tableHeaderBuilder.addRow(info1);
    							          tableHeaderBuilder.addRow(info2);
    							          tableHeaderBuilder.addRow(info3);
    							          header = tableHeaderBuilder.build();
    							          
    							          
    							          PDPage newPage = new PDPage(PDRectangle.A4);
								        	 contentStream = new PDPageContentStream(document,newPage);
								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
								             document.addPage( newPage );
								             
								             TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(header)
								                .startX(PADDING30)
								                .startY(currentY)
								                .build()
								                .draw();

        							        	TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(totalInfo)
		       					                .startX(PADDING30)
		       					                .startY(currentY-130)
		       					                .build()
		       					                .draw();
        							        	
        							        	
        							         TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(betweenDatestotalInfo)
		       					                .startX(PADDING30)
		       					                .startY(currentY-250)
		       					                .build()
		       					                .draw();
        							           
        							         
        							        	TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(productTable)
		       					                .startX(PADDING30)
		       					                .startY(currentY-370)
		       					                .build()
		       					                .draw();
        							        	 
    							          
    						          }
    						          else
    						          {
    						        	  TableDrawer.builder()
         					                .contentStream(contentStream)
         					                .table(totalInfo)
         					                .startX(PADDING30)
         					                .startY(currentY-140)
         					                .build()
         					                .draw();
     							        	
     							        	
     							         TableDrawer.builder()
	       					                .contentStream(contentStream)
	       					                .table(betweenDatestotalInfo)
	       					                .startX(PADDING30)
	       					                .startY(currentY-250)
	       					                .build()
	       					                .draw();
     							         
     							         
     							        	TableDrawer.builder()
         					                .contentStream(contentStream)
         					                .table(productTable)
         					                .startX(PADDING30)
         					                .startY(currentY-370)
         					                .build()
         					                .draw();
     							        	
    						          }
						          
						        
						          contentStream.close();
							        
							       // System.out.println(path);
											
							        
							        document.save(path+"/supp-acc-stmt-report.pdf");
							        document.close();
							        
							        response.setHeader("Content-disposition", "inline; filename=supp-stmt.pdf");
									response.setContentType("application/pdf");
									FileInputStream fileInputStream = new FileInputStream(path+"/supp-acc-stmt-report.pdf");
									PrintWriter out = response.getWriter();  
									int bytes;
									while ((bytes = fileInputStream.read()) != -1) {
										out.write(bytes);
									}
									fileInputStream.close();
									out.flush();
									out.close();
									ttf1.close();
	       			
	       			
	       			
	       			
	       		}catch(ParseException pe)
	       		{
	       			result = "error";
	    			addActionError(pe.getMessage() +" || DETAILS NOT FOUND !");
	       		}
	       		catch (SQLException e) {
	    			result = "error";
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || DETAILS NOT FOUND !");
	    		} catch (IOException e) {
	    			
	    			result = "error";
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || DETAILS NOT FOUND !");
	    		}finally {
	    			if(resultSet != null)
					{
						try {
							resultSet.close();
						} catch (SQLException e) {
							
						}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close();} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close();}catch (SQLException e) {}
	    			}
	    			
	    		
	    		}
	        }
    }

public HttpServletRequest getRequest() {
	return request;
}

public void setRequest(HttpServletRequest request) {
	this.request = request;
}

public HttpServletResponse getResponse() {
	return response;
}

public void setResponse(HttpServletResponse response) {
	this.response = response;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public String getReturnMessage() {
	return returnMessage;
}

public void setReturnMessage(String returnMessage) {
	this.returnMessage = returnMessage;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}




public String getFromDate() {
	return fromDate;
}

public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}

public String getToDate() {
	return toDate;
}

public void setToDate(String toDate) {
	this.toDate = toDate;
}

public Float getTotalPurchaseAmountBeforeDate() {
	return totalPurchaseAmountBeforeDate;
}

public void setTotalPurchaseAmountBeforeDate(Float totalPurchaseAmountBeforeDate) {
	this.totalPurchaseAmountBeforeDate = totalPurchaseAmountBeforeDate;
}

public Float getTotalAmountPaidBeforeDate() {
	return totalAmountPaidBeforeDate;
}

public void setTotalAmountPaidBeforeDate(Float totalAmountPaidBeforeDate) {
	this.totalAmountPaidBeforeDate = totalAmountPaidBeforeDate;
}

public Float getTotalDebtAmountBeforeDate() {
	return totalDebtAmountBeforeDate;
}

public void setTotalDebtAmountBeforeDate(Float totalDebtAmountBeforeDate) {
	this.totalDebtAmountBeforeDate = totalDebtAmountBeforeDate;
}

public Float getTotalPurchaseAmountAllTheTime() {
	return totalPurchaseAmountAllTheTime;
}

public void setTotalPurchaseAmountAllTheTime(Float totalPurchaseAmountAllTheTime) {
	this.totalPurchaseAmountAllTheTime = totalPurchaseAmountAllTheTime;
}

public Float getTotalAmountPaidAllTheTime() {
	return totalAmountPaidAllTheTime;
}

public void setTotalAmountPaidAllTheTime(Float totalAmountPaidAllTheTime) {
	this.totalAmountPaidAllTheTime = totalAmountPaidAllTheTime;
}

public Float getTotalDebtAmountAllTheTime() {
	return totalDebtAmountAllTheTime;
}

public void setTotalDebtAmountAllTheTime(Float totalDebtAmountAllTheTime) {
	this.totalDebtAmountAllTheTime = totalDebtAmountAllTheTime;
}

public List<SupplierAccountDetailsDAO> getSupplierAccountDetailsList() {
	return supplierAccountDetailsList;
}

public void setSupplierAccountDetailsList(List<SupplierAccountDetailsDAO> supplierAccountDetailsList) {
	this.supplierAccountDetailsList = supplierAccountDetailsList;
}

public List<SupplierAccountDetailsDAO> getSupplierAccountDetailsSortedList() {
	return supplierAccountDetailsSortedList;
}

public void setSupplierAccountDetailsSortedList(List<SupplierAccountDetailsDAO> supplierAccountDetailsSortedList) {
	this.supplierAccountDetailsSortedList = supplierAccountDetailsSortedList;
}

public Float getSupplierOpeningBalnce() {
	return supplierOpeningBalnce;
}

public void setSupplierOpeningBalnce(Float supplierOpeningBalnce) {
	this.supplierOpeningBalnce = supplierOpeningBalnce;
}

public String getOpeingBalancUpdatedBy() {
	return opeingBalancUpdatedBy;
}

public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
	this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
}

public String getOpeingBalanceUpdateDate() {
	return opeingBalanceUpdateDate;
}

public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
	this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
}

public SessionMap<String, Object> getSessionMap() {
	return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
	this.sessionMap = sessionMap;
}

@Override  
public void setSession(Map<String, Object> map) {  
    sessionMap=(SessionMap<String, Object>)map;  
}

public List<Map<String, Object>> getProductQuantityList() {
	return productQuantityList;
}

public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
	this.productQuantityList = productQuantityList;
}

public Float getTotalPurchaseAmountBetweenDates() {
	return totalPurchaseAmountBetweenDates;
}

public void setTotalPurchaseAmountBetweenDates(Float totalPurchaseAmountBetweenDates) {
	this.totalPurchaseAmountBetweenDates = totalPurchaseAmountBetweenDates;
}

public Float getTotalAmountPaidBetweenDates() {
	return totalAmountPaidBetweenDates;
}

public void setTotalAmountPaidBetweenDates(Float totalAmountPaidBetweenDates) {
	this.totalAmountPaidBetweenDates = totalAmountPaidBetweenDates;
}

public Float getTotalDebtAmountBetweenDates() {
	return totalDebtAmountBetweenDates;
}

public void setTotalDebtAmountBetweenDates(Float totalDebtAmountBetweenDates) {
	this.totalDebtAmountBetweenDates = totalDebtAmountBetweenDates;
}


}
