package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ItemWiseStockDetailsDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadStockReport extends ActionSupport implements SessionAware{

	

		/**
	 * 
	 */
	private static final long serialVersionUID = -8389840547877015596L;
	
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;  
	
	
		private final static Color BLUE_DARK = new Color(76, 129, 190);
	    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
	    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

	    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
	    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
	    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
	    private static final float PADDING10 = 10f;
	    private static final float PADDING20 = 20f;
	    private static final float PADDING30 = 30f;
	    private static final float PADDING40 = 40f;
	    private static final float PADDING50 = 50f;
	    
	    private HttpSession session;
		
	
	private List<ItemWiseStockDetailsDAO> productStockList = new ArrayList<ItemWiseStockDetailsDAO>();
	
	
	
		
		public void downloadStockReport()
		{
			session=ServletActionContext.getRequest().getSession(false); 
			 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	
	        }  
	        else{
	        	
	        	response = ServletActionContext.getResponse();
				request = ServletActionContext.getRequest();
		
		
		
		
		String crusherId = (String) this.getSessionMap().get("crusherId");
		String crusherCode = (String) this.getSessionMap().get("crusherCode");
		

    	Connection connection = null;
		PreparedStatement preparedStatement= null;
		ResultSet resultSet = null;
		
		String sql = "";
		String db = (String) this.getSession().getAttribute("db");
    	
		
				
				Map<String, Object> session = ActionContext.getContext().getSession();
				
				
				try
	        	{
					connection = GetDBConnection.getDBConnection(db);
					
					
					sql = "SELECT "
							+ "product_name_eng,"
							+ "product_name_mar,"
							+ "product_alias,"
							+ "low_stock_count,"
							+ "in_stock_quantity "
							+ "FROM "
							+ "crusher_product_master "
							+ "WHERE "
							+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ? "
							+ "ORDER BY "
							+ "product_name_eng ASC ";
					
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					
					resultSet = preparedStatement.executeQuery();
					
					while(resultSet.next())
					{
						ItemWiseStockDetailsDAO detailsDAO = new ItemWiseStockDetailsDAO();
						
						detailsDAO.setProductNameEn(resultSet.getString(1));
						detailsDAO.setProductNameMr(resultSet.getString(2));
						detailsDAO.setAlias(resultSet.getString(3));
						detailsDAO.setLowStockCount(resultSet.getString(4));
						detailsDAO.setStock(resultSet.getString(5));
						
						this.getProductStockList().add(detailsDAO);
						 
					}
					
					
					
					if(this.getProductStockList().size()>0)
					{
						
						
						try
						{
							String crusherName = (String) this.getSessionMap().get("crushernameenglish");
							String crusherAddress = (String) this.getSessionMap().get("crusheraddresseng");
							String path=	request.getSession().getServletContext().getRealPath("/images/");
			    			
							
							
							 java.util.Date date = new java.util.Date();
				        	SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
				        	String reportDate = dateFormat.format(date);
							
							
				       	     long t = date.getTime();	        	     
				       	     java.sql.Time time = new java.sql.Time(t);
				       	     
							PDDocument document = new PDDocument(); 
							PDPage page = null;
							
							 page = new PDPage(PDRectangle.A4);
							
							 
							 document.addPage(page);
							 
							 
					         PDPageContentStream contentStream = new PDPageContentStream(document, page);
							 
					         int pageCount = 1;
					         
					         Table header;
					         
					         
					         
					         
					         TableBuilder tableHeaderBuilder = Table.builder()
						                .addColumnsOfWidth(550)				                
						                .font(HELVETICA)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					         
					         Row crusherNameHeader = Row.builder()
						                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(16)				              
						                .horizontalAlignment(CENTER)
						                .build();
					         
					         Row addressRow = Row.builder()
						                .add(TextCell.builder().text(crusherAddress).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .build();
					         
					         
					         Row reportInfo1 = Row.builder()
						                .add(TextCell.builder()
						                		.text("Stock Details Report On : "+reportDate+" "+time)
						                		.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(12)				              
						                .horizontalAlignment(CENTER)
						                .build();
					         
					         
					         
					         
					         tableHeaderBuilder.addRow(crusherNameHeader);
					         tableHeaderBuilder.addRow(addressRow);
					         tableHeaderBuilder.addRow(reportInfo1);
					        
					         
					         header = tableHeaderBuilder.build();
					         
					         float startY = page.getMediaBox().getHeight() - PADDING20;
					         TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
							
					         
					         Table stockReportHeaderInfo;
					         TableBuilder tableStockInfoBuilder = Table.builder()
						                .addColumnsOfWidth(40,140,140,50,50,90)				                
						                .font(HELVETICA)
						                .borderWidth(0.5F)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					         
					         
					         Row stockTableHeader = Row.builder()
					        		  	.add(TextCell.builder().text("SrNo").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())					              
						                .add(TextCell.builder().text("Product Name").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())				               
						                .add(TextCell.builder().text("Marathi Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Short Name").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Low Stock Count").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("In Stock").horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(1F).build())
						                .backgroundColor(Color.LIGHT_GRAY)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .build();
					         
					         tableStockInfoBuilder.addRow(stockTableHeader);
					         stockReportHeaderInfo = tableStockInfoBuilder.build();
					        		
					        		 TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(stockReportHeaderInfo)
						                .startX(PADDING20)
						                .startY(startY-50)
						                .build()
						                .draw();
					         
					        		 float currentY =  75.0F;
					        		 
					        		 int srNo = 1;
					        		 
					        		 for(ItemWiseStockDetailsDAO detailsDAO :  this.getProductStockList())
					        		 {
					        			 
					        			 Table stockInfoRowTable = null;
							        	 
								         TableBuilder tableStockInfoRowBuilder = Table.builder()
									                .addColumnsOfWidth(40,140,140,50,50,90)				                
									                .font(HELVETICA)
									                .borderWidth(0.5F)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
							        	 
							        	 
								         if(currentY > 750)
								         {
								        	 pageCount++;
								        	 contentStream.close();
								        	PDPage newPage = new PDPage(PDRectangle.A4);
								        	 contentStream = new PDPageContentStream(document,newPage);
								        	currentY = 20.0F;
								             document.addPage( newPage );
								             
								             
								             
								             Table headerOtherPage;
								             
								             
								             TableBuilder tableHeaderBuilderOtherPage = Table.builder()
										                .addColumnsOfWidth(550)				                
										                .font(HELVETICA)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									         
									         Row dairyNameHeaderOtherPage = Row.builder()
										                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(16)				              
										                .horizontalAlignment(CENTER)
										                .build();
									         
									         Row addressRowOtherPage = Row.builder()
										                .add(TextCell.builder().text(crusherAddress).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
										                .horizontalAlignment(CENTER)
										                .build();
									         
									         
									         Row reportInfo1OtherPage = Row.builder()
										                .add(TextCell.builder()
										                		.text("Stock Details Report On : "+reportDate+" "+time)
										                		.horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(12)				              
										                .horizontalAlignment(CENTER)
										                .build();
									         
									         
									         
									         
									         tableHeaderBuilderOtherPage.addRow(dairyNameHeaderOtherPage);
									         tableHeaderBuilderOtherPage.addRow(addressRowOtherPage);
									         tableHeaderBuilderOtherPage.addRow(reportInfo1OtherPage);
									        
									         
									         headerOtherPage = tableHeaderBuilderOtherPage.build();
									         
									         TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(headerOtherPage)
								                .startX(PADDING30)
								                .startY(startY)
								                .build()
								                .draw();
									         
									         
								             
								             TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(stockReportHeaderInfo)
								                .startX(PADDING20)
								                .startY(startY-50)
								                .build()
								                .draw();
								             currentY = currentY + 55;
											
								         }
					        			 
								         

							        	 Row collectionTableInfoRow = Row.builder()
									                .add(TextCell.builder().text(""+srNo).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(20F).build())				               
									                .add(TextCell.builder().text(detailsDAO.getProductNameEn()).fontSize(9).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(20F).build())
									                .add(TextCell.builder().text(detailsDAO.getProductNameMr()).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(20F).build())
									                .add(TextCell.builder().text(detailsDAO.getAlias()).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(20F).build())
									                .add(TextCell.builder().text(detailsDAO.getLowStockCount()).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(20F).build())
									                .add(TextCell.builder().text(detailsDAO.getStock()).horizontalAlignment(CENTER).borderWidth(0.5F).lineSpacing(20F).build())
									                .backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA).fontSize(12)				              
									                .horizontalAlignment(CENTER)
									                .height(25F)
									                .build();
								         
							        	 tableStockInfoRowBuilder.addRow(collectionTableInfoRow);
								         
							        	 stockInfoRowTable = tableStockInfoRowBuilder.build();
								         
								         
								        // float currentY = 
								         TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(stockInfoRowTable)
							                .startX(PADDING20)
							                .startY(startY-currentY)
							                .build()
							                .draw();
								         currentY = (float) (currentY + 25.0F);
								         
								         srNo++;
								         
					        		 }
							
					        		 
					        		 contentStream.close();
									 	document.save(path+"/stock-report-"+crusherCode+".pdf");
								        document.close();
								        
								        

										response.setHeader("Content-disposition", "inline; filename=stock-report-"+crusherCode+".pdf");
										response.setContentType("application/pdf");
										FileInputStream fileInputStream = new FileInputStream(path+"/stock-report-"+crusherCode+".pdf");
										PrintWriter out = response.getWriter();  
										int bytes;
										while ((bytes = fileInputStream.read()) != -1) {
											out.write(bytes);
										}
										fileInputStream.close();
										out.flush();
										out.close();
						}
						catch(Exception e)
						{
							e.printStackTrace();
						}
					}
					
					
	        	}catch (SQLException | IOException e) {
					e.printStackTrace();
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close();resultSet = null;
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close(); connection = null;}catch (SQLException e) {}
					}
					
				}
	        	}
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	public HttpServletRequest getRequest() {
		return request;
	}

	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}

	public HttpServletResponse getResponse() {
		return response;
	}

	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}

	
	
	public List<ItemWiseStockDetailsDAO> getProductStockList() {
		return productStockList;
	}

	public void setProductStockList(List<ItemWiseStockDetailsDAO> productStockList) {
		this.productStockList = productStockList;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}
	
	
}
