package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.opensymphony.xwork2.ActionSupport;

public class DownloadLabourSalarySlip extends ActionSupport implements SessionAware{



	/**
	 * 
	 */
	private static final long serialVersionUID = 2923017921649103599L;

	private HttpSession session;
	
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	
	
	private String key;
	private String fromDate;
	private String toDate;
	private String laborName;
	private String noOfDaysInMonth;
	private String noOfAbsentDays;
	private String noOfOverTime;
	private String noOfHalfDays;
	private String noOfFullDaysPresent;
	private String additionalDeductionAmt;
	private String additionalPaymentAmt;
	private String totalSalary;
	private String comments;
	private String size;
	private String lang;

	
	private final static Color BLUE_DARK = new Color(76, 129, 190);
	private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
	private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

	private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
	private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
	private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
	private static final float PADDING10 = 10f;
	private static final float PADDING20 = 20f;
	private static final float PADDING30 = 30f;
	private static final float PADDING40 = 40f;
	private static final float PADDING50 = 50f;
	
	public void download(){
	
			this.setSession(ServletActionContext.getRequest().getSession(false)); 
		
	        if(this.getSession()==null || this.getSession().getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	         }  
	        else{
	        	
	        	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		

	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
			
				String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
    			String entryId = keyDetails[0];
    			String laborId = keyDetails[1];
					
				String sql = "";
				String db = (String)  this.getSessionMap().get("db");
				
				try
				{
					connection = GetDBConnection.getDBConnection(db);
					
					sql = "SELECT "
							+ "entry_id,"
							+ "DATE_FORMAT(salary_from_date,'%d-%M-%Y'),"
							+ "DATE_FORMAT(salary_to_date,'%d-%M-%Y'),"
							+ "employee_name,"
							+ "no_of_day_in_month,"
							+ "no_of_absent_days,"
							+ "no_of_over_time,"
							+ "no_of_half_days,"
							+ "no_of_full_days_present,"
							+ "additional_deduction_amount,"
							+ "additional_payment_amount,"
							+ "total_calculated_salary_amount,"
							+ "comments "
							+ "FROM "
							+ "crusher_employee_salary_calculation_details "
							+ "WHERE "
							+ "entry_id = ? "
							+ "AND "
							+ "employee_id = ? "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
    				preparedStatement.setString(1, entryId);
    				preparedStatement.setString(2, laborId);
    				preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
    				
    				if(resultSet.next())
    				{
    					this.setFromDate(resultSet.getString(2));
    					this.setToDate(resultSet.getString(3));
    					this.setLaborName(resultSet.getString(4));
    					this.setNoOfDaysInMonth(resultSet.getString(5));
    					this.setNoOfAbsentDays(resultSet.getString(6));
    					this.setNoOfOverTime(resultSet.getString(7));    				
    					this.setNoOfHalfDays(resultSet.getString(8));
    					this.setNoOfFullDaysPresent(resultSet.getString(9));
    					this.setAdditionalDeductionAmt(resultSet.getString(10));
    					this.setAdditionalPaymentAmt(resultSet.getString(11));
    					this.setTotalSalary(resultSet.getString(12));
    					this.setComments(resultSet.getString(13));
    					
    					
    				}else {
    					addActionError(this.getText("message.error.salaryDetailsNotFound"));
    				}
    				
    				
    				
    				if (this.getLang().equalsIgnoreCase("eng") && this.getSize().equals("A4"))
    						{

    					

    						// System.out.println("Bill Type:"+billInfoDAO.getBillType());
    						PDDocument document = new PDDocument();
    						PDPage page = null;
    						page = new PDPage(PDRectangle.A4);

    						document.addPage(page);
    						
    						response = ServletActionContext.getResponse();

    						request = ServletActionContext.getRequest();

    						String path = request.getSession().getServletContext().getRealPath("/images/");

    						
    						String crushernameenglish = (String) this.getSessionMap().get("crushernameenglish");
    						String address = (String) this.getSessionMap().get("crusheronelineaddress");

    						 
    						PDPageContentStream contentStream = new PDPageContentStream(document, page);

    						
    						Table header;
    						Table salaryTable;
    						
    						TableBuilder tableHeaderBuilder = Table.builder().addColumnsOfWidth(550).font(HELVETICA)
    								.borderColor(Color.BLACK).horizontalAlignment(CENTER);

    						
    						Row headerName = Row.builder()
    								.add(TextCell.builder().text(crushernameenglish).horizontalAlignment(CENTER)
    										.borderWidth(0).lineSpacing(10F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
    								.fontSize(30).horizontalAlignment(CENTER).build();

    						Row addressRow = Row.builder()
    								.add(TextCell.builder().text(address).borderWidthBottom(0.5F)
    										.horizontalAlignment(CENTER).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
    								.fontSize(8).horizontalAlignment(CENTER).build();

    						Row salaryDetailsRow = Row.builder()
    								.add(TextCell.builder().text("Employee Salary Details OF : "+ this.getLaborName())
    										.borderWidthBottom(0.5F).horizontalAlignment(CENTER).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
    								.fontSize(10).horizontalAlignment(CENTER).build();

    						Row dateRow = Row.builder()
    								.add(TextCell.builder().text("From Date :"+ this.getFromDate() +"  From Date :" + this.getToDate()).borderWidthBottom(1F)
    										.horizontalAlignment(CENTER).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
    								.fontSize(10).horizontalAlignment(CENTER).build();

    						tableHeaderBuilder.addRow(headerName);
    						tableHeaderBuilder.addRow(addressRow);
    						tableHeaderBuilder.addRow(salaryDetailsRow);
    						tableHeaderBuilder.addRow(dateRow);

    						header = tableHeaderBuilder.build();

    						TableBuilder salaryDetails = Table.builder().addColumnsOfWidth(250, 250)
    								.font(HELVETICA).borderWidth(10).borderColor(Color.BLACK);

    						Row salaryDetailsRow1 = Row.builder()
    								.add(TextCell.builder().text("No Of Days In Month : ").horizontalAlignment(RIGHT).borderWidth(0.5F)
    										.fontSize(10).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getNoOfDaysInMonth()).horizontalAlignment(CENTER)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.horizontalAlignment(CENTER).build();

    						Row salaryDetailsRow2 = Row.builder()
    								.add(TextCell.builder().text("No Of Absent Days In Month : ").horizontalAlignment(RIGHT).borderWidth(0.5F)
    										.fontSize(10).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getNoOfAbsentDays()).horizontalAlignment(CENTER)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.horizontalAlignment(CENTER).build();

    						Row salaryDetailsRow3 = Row.builder()
    								.add(TextCell.builder().text("No Of Over Time In March : ").horizontalAlignment(RIGHT)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getNoOfOverTime()).horizontalAlignment(CENTER)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.horizontalAlignment(CENTER).build();
    						
    						Row salaryDetailsRow4 = Row.builder()
    								.add(TextCell.builder().text("No Of Half Days In Month : ").horizontalAlignment(RIGHT)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getNoOfHalfDays()).horizontalAlignment(CENTER).borderWidth(0.5F)
    										.fontSize(10).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.horizontalAlignment(CENTER).build();
    						
    						Row salaryDetailsRow5 = Row.builder()
    								.add(TextCell.builder().text("No Of Full Days In Month : ").horizontalAlignment(RIGHT)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getNoOfFullDaysPresent()).horizontalAlignment(CENTER).borderWidth(0.5F)
    										.fontSize(10).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.fontSize(10).horizontalAlignment(CENTER).build();

    						
    						Row salaryDetailsRow6 = Row.builder()
    								.add(TextCell.builder().text("Additional Deduction In Month : ").horizontalAlignment(RIGHT)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getAdditionalDeductionAmt()).horizontalAlignment(CENTER)
    										.fontSize(10).borderWidth(0.5F).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.fontSize(10).horizontalAlignment(CENTER).build();

    						
    						
    						Row salaryDetailsRow7 = Row.builder()
    								.add(TextCell.builder().text("Additional Payment In Month : ").horizontalAlignment(RIGHT)
    										.borderWidth(0.5F).fontSize(10).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getAdditionalPaymentAmt()).horizontalAlignment(CENTER).borderWidth(0.5F)
    										.fontSize(10).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.fontSize(10).horizontalAlignment(CENTER).build();

    						Row salaryDetailsRow8 = Row.builder()
    								.add(TextCell.builder().text("Total Salary Amount In Month : ").horizontalAlignment(RIGHT)
    										.borderWidth(0.5F).fontSize(10).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getTotalSalary()).horizontalAlignment(CENTER).fontSize(10)
    										.borderWidth(0.5F).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.fontSize(10).horizontalAlignment(CENTER).build();

    						
    						Row salaryDetailsRow9 = Row.builder()
    								.add(TextCell.builder().text("Comments : ").horizontalAlignment(RIGHT)
    										.borderWidth(0.5F).fontSize(10).lineSpacing(5F).build())
    								.add(TextCell.builder().text(this.getComments()).horizontalAlignment(CENTER).borderWidth(0.5F)
    										.fontSize(10).lineSpacing(5F).build())
    								.backgroundColor(WHITE).textColor(Color.BLACK).font(PDType1Font.HELVETICA)
    								.fontSize(10).horizontalAlignment(CENTER).build();

    						
    						
    						
    						salaryDetails.addRow(salaryDetailsRow1);
    						salaryDetails.addRow(salaryDetailsRow2);
    						salaryDetails.addRow(salaryDetailsRow3);
    						salaryDetails.addRow(salaryDetailsRow4);
    						salaryDetails.addRow(salaryDetailsRow5);
    						salaryDetails.addRow(salaryDetailsRow6);
    						salaryDetails.addRow(salaryDetailsRow7);
    						salaryDetails.addRow(salaryDetailsRow8);
    						salaryDetails.addRow(salaryDetailsRow9);
    						salaryTable = salaryDetails.build();

    					
    						

    						float startY = page.getMediaBox().getHeight() - PADDING20;

    						TableDrawer.builder().contentStream(contentStream).table(header).startX(PADDING20)
    								.startY(startY).build().draw();

    						TableDrawer.builder().contentStream(contentStream).table(salaryTable).startX(PADDING20)
    								.startY(startY - 100).build().draw();

    						
    						
    						
    						
    				         
    						contentStream.close();

    						// System.out.println(path);

    						document.save(path + "/labour_salary_slip_FromDate-"+this.getFromDate()+"_ToDate-"+this.getToDate()+".pdf");
    						document.close();

    						response.setHeader("Content-disposition", "inline; filename = "+"labour_salary_slip_FromDate-"+this.getFromDate()+"_ToDate-"+this.getToDate()+".pdf");
    						response.setContentType("application/pdf");
    						@SuppressWarnings("resource")
    						FileInputStream fileInputStream = new FileInputStream(path + "/labour_salary_slip_FromDate-"+this.getFromDate()+"_ToDate-"+this.getToDate()+".pdf");
    						PrintWriter out = response.getWriter();
    						int bytes;
    						while ((bytes = fileInputStream.read()) != -1) {
    							out.write(bytes);
    						}
    						fileInputStream.close();
    						out.flush();
    						out.close();

    					

    				}

    				
					
				}
				catch (SQLException e) 
				{

					e.printStackTrace();
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Collection details could not be found !");


				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}catch(Exception e)
				{
					e.printStackTrace();
				}
				finally {
					
					
					if(resultSet !=null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
					if(preparedStatement != null)
					{
						try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();
						 connection = null;
						}catch (SQLException e) {}
					}
				
			}
        }
}



	public HttpSession getSession() {
		return session;
	}



	public void setSession(HttpSession session) {
		this.session = session;
	}
      

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}



	public HttpServletRequest getRequest() {
		return request;
	}



	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}



	public HttpServletResponse getResponse() {
		return response;
	}



	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}



	public String getKey() {
		return key;
	}



	public void setKey(String key) {
		this.key = key;
	}



	public String getFromDate() {
		return fromDate;
	}



	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}



	public String getToDate() {
		return toDate;
	}



	public void setToDate(String toDate) {
		this.toDate = toDate;
	}



	public String getLaborName() {
		return laborName;
	}



	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}



	public String getNoOfDaysInMonth() {
		return noOfDaysInMonth;
	}



	public void setNoOfDaysInMonth(String noOfDaysInMonth) {
		this.noOfDaysInMonth = noOfDaysInMonth;
	}



	public String getNoOfAbsentDays() {
		return noOfAbsentDays;
	}



	public void setNoOfAbsentDays(String noOfAbsentDays) {
		this.noOfAbsentDays = noOfAbsentDays;
	}



	public String getNoOfOverTime() {
		return noOfOverTime;
	}



	public void setNoOfOverTime(String noOfOverTime) {
		this.noOfOverTime = noOfOverTime;
	}



	public String getNoOfHalfDays() {
		return noOfHalfDays;
	}



	public void setNoOfHalfDays(String noOfHalfDays) {
		this.noOfHalfDays = noOfHalfDays;
	}



	public String getNoOfFullDaysPresent() {
		return noOfFullDaysPresent;
	}



	public void setNoOfFullDaysPresent(String noOfFullDaysPresent) {
		this.noOfFullDaysPresent = noOfFullDaysPresent;
	}



	public String getAdditionalDeductionAmt() {
		return additionalDeductionAmt;
	}



	public void setAdditionalDeductionAmt(String additionalDeductionAmt) {
		this.additionalDeductionAmt = additionalDeductionAmt;
	}



	public String getAdditionalPaymentAmt() {
		return additionalPaymentAmt;
	}



	public void setAdditionalPaymentAmt(String additionalPaymentAmt) {
		this.additionalPaymentAmt = additionalPaymentAmt;
	}



	public String getTotalSalary() {
		return totalSalary;
	}



	public void setTotalSalary(String totalSalary) {
		this.totalSalary = totalSalary;
	}



	public String getComments() {
		return comments;
	}



	public void setComments(String comments) {
		this.comments = comments;
	}



	public String getSize() {
		return size;
	}



	public void setSize(String size) {
		this.size = size;
	}



	public String getLang() {
		return lang;
	}



	public void setLang(String lang) {
		this.lang = lang;
	}
    
}

