package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Row.RowBuilder;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BankAccountStatementDAO;
import com.stonecrusher.DAO.LaborAccountDetailsDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DownloadLaborAccStmtReport extends ActionSupport implements SessionAware{

	

	/**
	 * 
	 */
	private static final long serialVersionUID = -625899965556423051L;
	public HttpServletRequest request;
	public HttpServletResponse response;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;
	private String key;
	private String laborName;
	private String laborMobile;
	private String defaultValue;
	private String fromDate;
	private String toDate;
	
	
	private Float totalSalaryAmountBeforeDate;
	private Float totalSalaryPaidBeforeDate;
	private Float totalUnpaidSalaryAmountBeforeDate;
	private String hiddenKey;
	private Float totalSalaryAmountAllTheTime;
	private Float totalSalaryAmountPaidAllTheTime;
	private Float totalUnpaidAmountAllTheTime;
	
	private List<LaborAccountDetailsDAO> laborAccountDetailsList = new ArrayList<LaborAccountDetailsDAO>();
	private List<LaborAccountDetailsDAO> laborAccountDetailsSortedList = new ArrayList<LaborAccountDetailsDAO>();
	
	private Float laborBalancePending = 0.0F;
	private Float laborBalanceAdvance = 0.0f;
	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	private Float totalSalaryAmount = 0.0f;
	private Float totalAmount = 0.0f;
	private Float totalAdditionalDeductionAmount = 0.0f;
	private Float totalAdditionalPaymentAmount = 0.0f;
	
	private SessionMap<String,Object> sessionMap;  

	
	public void download() throws ParseException
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();
			
			String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		


        	Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			String sql = "";
			String db = (String) this.getSession().getAttribute("db");
        	
			@SuppressWarnings("unchecked")
			String crusherName = (String) this.getSessionMap().get("crushernameenglish");
		    
			
			try
			{
				
				connection = GetDBConnection.getDBConnection(db);
				
				String laborId = EncryptionDecryption.decrypt(getKey());
		        
	        	setKey(EncryptionDecryption.encrypt(laborId));
	        	

	       			
	       			String nameOfLabour = "";
	       			
					connection = GetDBConnection.getDBConnection(db);
	       			
					sql = "SELECT "
							+ "employee_name "
							+ "FROM "
							+ "crusher_employee_master "
							+ "WHERE "
							+ "employee_id = ? "
							+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					
					preparedStatement.setString(1, laborId);
					preparedStatement.setString(2, crusherId);
    				preparedStatement.setString(3, crusherCode);
    				
    				resultSet = preparedStatement.executeQuery();
					 
					 if(resultSet.next())
					 {
						 nameOfLabour = resultSet.getString(1); 
					 }
							
	       			
	       			
	       			PreparedStatement getPendingAdvBalPSMT = null;
       				ResultSet getPendingAdvBalRs = null;
       				
       				String getPendingAdvBalSQL = "SELECT "
       						+ "opening_bal_type,"
       						+ "opening_balance_amount "
       						+ "FROM "
       						+ "crusher_employee_salary_details "
       						+ "WHERE "
       						+ "employee_id = ? "
       						+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
       				
       				getPendingAdvBalPSMT = connection.prepareStatement(getPendingAdvBalSQL);
       				
       				getPendingAdvBalPSMT.setString(1, laborId);
       				getPendingAdvBalPSMT.setString(2, crusherId);
       				getPendingAdvBalPSMT.setString(3, crusherCode);
    				
       				getPendingAdvBalRs = getPendingAdvBalPSMT.executeQuery();
       				
       				if(getPendingAdvBalRs.next())
       				{
       					if(getPendingAdvBalRs.getString(1).equals("ADVANCE"))
       					{
       						this.setLaborBalanceAdvance(getPendingAdvBalRs.getFloat(2));
       						this.setLaborBalancePending(0.0F);
       					}
       					else
       					{
       						this.setLaborBalanceAdvance(0.0F);
       						this.setLaborBalancePending(getPendingAdvBalRs.getFloat(2));
       					}
       					
       				
       				}
       				else
       				{
       					this.setLaborBalanceAdvance(0.0F);
   						this.setLaborBalancePending(0.0F);
       				}
       				if(getPendingAdvBalRs != null)
       				{
       					getPendingAdvBalRs.close();
       					getPendingAdvBalRs = null;
       				}
       				if(getPendingAdvBalPSMT != null)
       				{
       					getPendingAdvBalPSMT.close();
       					getPendingAdvBalPSMT = null;
       				}
       				
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement = null;
	       				
	       			}
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			
	       			sql = "SELECT "
	       					+ "SUM(payment_amount) "
	       					+ "FROM "
	       					+ "crusher_employee_payment_details "
	       					+ "WHERE "
	       					+ "employee_id = ? "
	       					+ "and "
	       					+ "payment_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, laborId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			if(resultSet.next())
	       			{
	       				if(resultSet.getString(1) != null)
	       				{
	       					this.setTotalSalaryPaidBeforeDate(resultSet.getFloat(1));
	       				}
	       				else
	       				{
	       					this.setTotalSalaryPaidBeforeDate(0.0F);
	       				}
	       			}
	       			else
	       			{
	       				this.setTotalSalaryPaidBeforeDate(0.0F);
	       			}
	       			
	       			if(resultSet != null)
	       			{
	       				resultSet.close();
	       				resultSet = null;
	       			}
	       			if(preparedStatement != null)
	       			{
	       				preparedStatement.close();
	       				preparedStatement = null;
	       			}
	       			
	       			
	       			float floatSalaryAmt = 0.0F;
       				
       				float totalSalaryAmountPaid = this.getTotalSalaryPaidBeforeDate();
       				float totalSalaryAmountBeforeDate = 0.0F;
       				
       				
       				sql = "SELECT "
       						+ "total_calculated_salary_amount "
       						+ "FROM "
       						+ "crusher_employee_salary_calculation_details "
       						+ "WHERE "
	       					+ "employee_id = ? "
	       					+ "AND "
	       					+ "salary_to_date < STR_TO_DATE(?, '%d-%m-%Y') "
	       					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	       			
	       			preparedStatement = connection.prepareStatement(sql);
	       			preparedStatement.setString(1, laborId);
	       			preparedStatement.setString(2, this.getFromDate());
	       			preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
	       			resultSet = preparedStatement.executeQuery();
	       			
	       			while(resultSet.next())
	       			{
	       				
	       				try
	       				{
	       					floatSalaryAmt = resultSet.getFloat(1);
	       					totalSalaryAmountBeforeDate = totalSalaryAmountBeforeDate + floatSalaryAmt;
	       					
	       				}
	       				catch(Exception e)
	       				{
	       					
	       					addActionError("One Of the purchase invoice could not be processed!");
	       				}
	       				
	       			}
	       		
	       				this.setTotalSalaryAmountBeforeDate(totalSalaryAmountBeforeDate);
	       			
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "employee_id,"
	       						+ "DATE_FORMAT(payment_date, '%d/%m/%Y'),"
	       						+ "payment_amount,"
	       						+ "payment_details "
	       						+ "FROM "
	       						+ "crusher_employee_payment_details "
	       						+ "WHERE "
	       						+ "employee_id = ?"
			       				+ "AND "
		       					+ "(payment_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, laborId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
        				preparedStatement.setString(5, crusherCode);
        				
	       				resultSet = preparedStatement.executeQuery();
	       				
	       				while(resultSet.next())
	       				{
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
	    	       			
	       				
	       					LaborAccountDetailsDAO dao = new LaborAccountDetailsDAO();
	       					dao.setEntryId(resultSet.getString(1));
	       					dao.setDate(resultSet.getString(3));
	       					dao.setEntryDate(date1);
	       					dao.setSalaryAmount(0.0F);
	       					dao.setAmount(resultSet.getFloat(4));
	       					dao.setComments(resultSet.getString(5));
	       					
	       					dao.setAmountType("PAYMENT");
	       					dao.setDueAmount(0.0F);
	       					dao.setSalaryFromDate("-");
	       					dao.setSalaryToDate("-");
	       					dao.setAdditionalDeductionAmount(0.0f);
	       					dao.setAdditionalPaymentAmount(0.0f);
	       					
	       					dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+laborId));
	       					
	       					this.setTotalSalaryAmount(this.getTotalSalaryAmount() + dao.getSalaryAmount());
	       					this.setTotalAmount(this.getTotalAmount() + dao.getAmount());
	       					
	       					
	       					this.getLaborAccountDetailsList().add(dao);
	       					
	       				}
	       				
	       				if(resultSet != null)
	       				{
	       					resultSet.close();
	       					resultSet = null;
	       				}
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				sql = "SELECT "
	       						+ "entry_id,"
	       						+ "DATE_FORMAT(salary_from_date,'%d/%m/%Y'),"
	       						+ "DATE_FORMAT(salary_to_date,'%d/%m/%Y'),"
	       						+ "total_calculated_salary_amount,"
	       						+ "comments,"
	       						+ "additional_deduction_amount,"
	       						+ "additional_payment_amount "
	       						+ "FROM "
	       						+ "crusher_employee_salary_calculation_details "
	       						+ "WHERE "
	       						+ "employee_id = ? "
	       						+ "AND "
		       					+ "(salary_to_date BETWEEN "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
			   					+ "AND "
			   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
			   					+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				
	       				preparedStatement.setString(1, laborId);
	       				preparedStatement.setString(2, this.getFromDate());
	       				preparedStatement.setString(3, this.getToDate());
	       				preparedStatement.setString(4, crusherId);
        				preparedStatement.setString(5, crusherCode);
        				
	       				resultSet = preparedStatement.executeQuery();
	       				while(resultSet.next())
	       				{
	       					Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(3)); 
	    	       			
		       				
	       					LaborAccountDetailsDAO dao = new LaborAccountDetailsDAO();
	       					dao.setEntryId(resultSet.getString(1));
	       					dao.setDate(resultSet.getString(2) + " - TO -"+resultSet.getString(3));
	       					dao.setSalaryFromDate(resultSet.getString(2));
	       					dao.setSalaryToDate(resultSet.getString(3));
	       					dao.setEntryDate(date1);
	       					dao.setSalaryAmount(resultSet.getFloat(4));
	       					dao.setAmount(0.0F);	       					
	       					dao.setAmountType("SALARY");
	       					dao.setComments(resultSet.getString(5));
	       					dao.setAdditionalDeductionAmount(resultSet.getFloat(6));
	       					dao.setAdditionalPaymentAmount(resultSet.getFloat(7));
	       					dao.setDueAmount(0.0F);
	       					dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+laborId));
	       					
	       					
	       					this.setTotalSalaryAmount(this.getTotalSalaryAmount() + dao.getSalaryAmount());
	       					this.setTotalAmount(this.getTotalAmount() + dao.getAmount());
	       					this.setTotalAdditionalDeductionAmount(this.getTotalAdditionalDeductionAmount() + dao.getAdditionalDeductionAmount());
	       					this.setTotalAdditionalPaymentAmount(this.getTotalAdditionalPaymentAmount()  + dao.getAdditionalPaymentAmount());
	       					
	       					
	       					this.getLaborAccountDetailsList().add(dao);
	       					
	       				}
	       				
	       				
	       		
	       					

   						 
   						 Collections.sort(this.getLaborAccountDetailsList(), new Comparator<LaborAccountDetailsDAO>() {
   							  public int compare(LaborAccountDetailsDAO o1, LaborAccountDetailsDAO o2) {
   							      if (o1.getEntryDate() == null || o2.getEntryDate() == null)
   							        return 0;
   							      return o1.getEntryDate().compareTo(o2.getEntryDate());
   							  }
   							});
   						 
   						
   						 float dueAmountBeforeDates = this.getTotalSalaryAmountBeforeDate() - this.getTotalSalaryPaidBeforeDate();
   						 float currentSalaryAmtDue = 0.0F;
   					
   						this.setTotalUnpaidSalaryAmountBeforeDate(dueAmountBeforeDates);
						if(this.getLaborBalanceAdvance() > 0)
						{
							currentSalaryAmtDue = dueAmountBeforeDates - this.getLaborBalanceAdvance();
						} 
						else if(this.getLaborBalancePending() > 0 )
						{
							currentSalaryAmtDue = dueAmountBeforeDates + this.getLaborBalancePending(); 
						}
						 else
						 {
							currentSalaryAmtDue = dueAmountBeforeDates;
						 }
	   						      
   						for(LaborAccountDetailsDAO dao : this.getLaborAccountDetailsList())
	       				{
   							if(dao.getAmountType().equals("SALARY"))
   							{
   								dao.setDueAmount(currentSalaryAmtDue + dao.getSalaryAmount());
   								
   								currentSalaryAmtDue = currentSalaryAmtDue + dao.getSalaryAmount();
   							}
   							else if(dao.getAmountType().equals("PAYMENT"))
   							{
   								dao.setDueAmount(currentSalaryAmtDue - dao.getAmount());
   								currentSalaryAmtDue = currentSalaryAmtDue -  dao.getAmount();
   							}
	       				}
   						
   					
					
					DecimalFormat df = new DecimalFormat("##.##");
					
	    			String path=	request.getSession().getServletContext().getRealPath("/images/");
	    			PDDocument document = new PDDocument(); 
					PDPage page = null;
					
					
					Date date = new Date();
					SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-YYYY");
		        	
		        	
					String dateToday = sdf.format(date); 
						 page = new PDPage(PDRectangle.A4);
					
					
				        document.addPage(page);
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
				         int pageCount = 1;
				         
				         
				    	 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
						 
						 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
						 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
					 
			    			 Table header;
			    			
			    			  TableBuilder tableHeaderBuilder = Table.builder()
						                .addColumnsOfWidth(550)				                
						                .font(HELVETICA)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					         
					          Row headerName = Row.builder()
						                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
						                .horizontalAlignment(CENTER)
						                .build();
					          
					          
					          Row info1 = Row.builder()
						                .add(TextCell.builder().text("Employee Account Statment: From Date: "
						                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
						                .horizontalAlignment(CENTER)
						                .build();
					          
					          Row info2 = Row.builder()
						                .add(TextCell.builder().text("Employee Name: "
						                		+nameOfLabour
						                		+", Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
					          
					          
					          
					          Row beforeDateRow = Row.builder()
						                .add(TextCell.builder().text("Salary Before date: "
						                		+this.getTotalSalaryAmountBeforeDate()
						                		+", Salary Paid Before Date : "+this.getTotalSalaryPaidBeforeDate()
						                		+", Salary balance Before Date : "+this.getTotalUnpaidSalaryAmountBeforeDate()).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
					         
					          
					          Row pendingAdvRow = Row.builder()
						                .add(TextCell.builder().text("Peding Amount "
						                		+this.getLaborBalancePending()
						                		+", Advance Amount : "+this.getLaborBalanceAdvance()).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
					         
					          
					          tableHeaderBuilder.addRow(headerName);
					          tableHeaderBuilder.addRow(info1);
					          tableHeaderBuilder.addRow(info2);
					          tableHeaderBuilder.addRow(beforeDateRow);
					          tableHeaderBuilder.addRow(pendingAdvRow);
					          header = tableHeaderBuilder.build();
					          
					          
					          Table stmtDetails;
				    			 
				    			
					          
					          TableBuilder tableStmtDetailsBuilder = Table.builder()
					        		  .addColumnsOfWidth(65,65,65,50,50,50,50,50,100)				                
						               .font(HELVETICA)
						                .borderWidth(0.5F)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					          
					          Row tableHeader = Row.builder()
					        		  	.add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						                .add(TextCell.builder().text("From Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("To Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Additional Deduction").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						                .add(TextCell.builder().text("Additional Payment").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						                .add(TextCell.builder().text("Salary").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
						                .add(TextCell.builder().text("Amount Paid").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Balance/Due").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
						                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
						                .backgroundColor(Color.LIGHT_GRAY)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .build();
					          tableStmtDetailsBuilder.addRow(tableHeader);
					       
					        
					     
					        	  int size = this.getLaborAccountDetailsList().size();
					        	  
					        	  
						          float startY = page.getMediaBox().getHeight() - PADDING20;
						          float currentY = startY;
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(header)
					                .startX(PADDING30)
					                .startY(startY)
					                .build()
					                .draw();
						          
						          for(int s=0;s<size;s++)
					        	  {
					        		  
					        		  if(currentY < 120)
					        		  {
					        			  
					        			  pageCount++;
					        			  stmtDetails = tableStmtDetailsBuilder.build();
					        			  TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(stmtDetails)
							                .startX(PADDING30)
							                .startY(startY-50)
							                .build()
							                .draw();
					        			  
					        			  contentStream.close();
					        			  
					        			  header = null;
					        			  
					        			 
							    			 
							    			
							    			  tableHeaderBuilder = Table.builder()
										                .addColumnsOfWidth(550)				                
										                .font(HELVETICA)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									         
									           headerName = Row.builder()
										                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          
									          
										          
									           		info1 = Row.builder()
										                .add(TextCell.builder().text("Employee Account Statment: From Date: "
										                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
										                .horizontalAlignment(CENTER)
										                .build();
										          
									           		info2 = Row.builder()
											                .add(TextCell.builder().text("Employee Name: "
											                		+nameOfLabour
											                		+", Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
											                .horizontalAlignment(CENTER)
											                .build();
										         
										         
									          
									          tableHeaderBuilder.addRow(headerName);
									          tableHeaderBuilder.addRow(info1);
									          tableHeaderBuilder.addRow(info2);
									          header = tableHeaderBuilder.build();
					        			  
					        			  stmtDetails = null;
					        			   tableStmtDetailsBuilder = Table.builder()
					        					   .addColumnsOfWidth(65,65,65,50,50,50,50,50,100)				                
										               .font(HELVETICA)
									                .borderWidth(0.5F)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
					        			      
					        			   tableHeader = Row.builder()
					        					 	.add(TextCell.builder().text("Entry Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
									                .add(TextCell.builder().text("From Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("To Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("Additional Deduction").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
									                .add(TextCell.builder().text("Additional Payment").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
									                .add(TextCell.builder().text("Salary").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
									                .add(TextCell.builder().text("Amount Paid").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("Balance/Due").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
									                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
									                .backgroundColor(Color.LIGHT_GRAY)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          tableStmtDetailsBuilder.addRow(tableHeader);
								          
					        			  
					        				PDPage newPage = new PDPage(PDRectangle.A4);
								        	 contentStream = new PDPageContentStream(document,newPage);
								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
								             document.addPage( newPage );
								             
								             TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(header)
								                .startX(PADDING30)
								                .startY(currentY)
								                .build()
								                .draw();
					        		  }
					        		  
					        		  
					        		  LaborAccountDetailsDAO dao = this.getLaborAccountDetailsList().get(s);
					        		
					        		  if(dao.getComments() == null )
					        		  {
					        			  dao.setComments("");
					        		  }
					        		  
							          Row infoRow = Row.builder()
							        		  	.add(TextCell.builder().text(dao.getDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text(dao.getSalaryFromDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text(dao.getSalaryToDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text(df.format(dao.getAdditionalDeductionAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text(df.format(dao.getAdditionalPaymentAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text(df.format(dao.getSalaryAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text(df.format(dao.getAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text(df.format(dao.getDueAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text(dao.getComments()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							      	  
						        	  tableStmtDetailsBuilder.addRow(infoRow);
						        	 
						        	  currentY = currentY -20;
					        	  }
						          
						          
						          Row totalInfoRow = Row.builder()
					        			  .add(TextCell.builder().text("Total").colSpan(3).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  .add(TextCell.builder().text(""+this.getTotalAdditionalDeductionAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+this.getTotalAdditionalPaymentAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+this.getTotalSalaryAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+this.getTotalAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
						        			.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(fontMarathi)
							                .fontSize(10)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
						          tableStmtDetailsBuilder.addRow(totalInfoRow);
				        			
						   
						          stmtDetails = tableStmtDetailsBuilder.build();
						          
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(stmtDetails)
					                .startX(PADDING30)
					                .startY(startY-90)
					                .build()
					                .draw();
						          contentStream.close();
							          
						          
						          document.save(path+"/emp-acc-stmt.pdf");
							        document.close();
							        
							        response.setHeader("Content-disposition", "inline; filename=emp-acc-stmt"+nameOfLabour+".pdf");
									response.setContentType("application/pdf");
									
									FileInputStream fileInputStream = new FileInputStream(path+"/emp-acc-stmt.pdf");
									PrintWriter out = response.getWriter();  
									int bytes;
									while ((bytes = fileInputStream.read()) != -1) {
										out.write(bytes);
									}
									fileInputStream.close();
									out.flush();
									out.close();
									ttf1.close();
						          
				
			}catch (SQLException e) {
				
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Account details not found!");
			} catch (IOException e) {
				
				addActionError(e.getMessage()+" || "+e.getCause()+" || Account details not found !");
			}finally {
				if(resultSet != null)
				{
					try {resultSet.close();} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close();} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close();}catch (SQLException e) {}
				}
				
			}
        }
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	


	public String getKey() {
		return key;
	}


	public void setKey(String key) {
		this.key = key;
	}


	public String getLaborName() {
		return laborName;
	}


	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}


	public String getLaborMobile() {
		return laborMobile;
	}


	public void setLaborMobile(String laborMobile) {
		this.laborMobile = laborMobile;
	}


	public String getDefaultValue() {
		return defaultValue;
	}


	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public Float getTotalSalaryAmountBeforeDate() {
		return totalSalaryAmountBeforeDate;
	}


	public void setTotalSalaryAmountBeforeDate(Float totalSalaryAmountBeforeDate) {
		this.totalSalaryAmountBeforeDate = totalSalaryAmountBeforeDate;
	}


	public Float getTotalSalaryPaidBeforeDate() {
		return totalSalaryPaidBeforeDate;
	}


	public void setTotalSalaryPaidBeforeDate(Float totalSalaryPaidBeforeDate) {
		this.totalSalaryPaidBeforeDate = totalSalaryPaidBeforeDate;
	}


	public Float getTotalUnpaidSalaryAmountBeforeDate() {
		return totalUnpaidSalaryAmountBeforeDate;
	}


	public void setTotalUnpaidSalaryAmountBeforeDate(Float totalUnpaidSalaryAmountBeforeDate) {
		this.totalUnpaidSalaryAmountBeforeDate = totalUnpaidSalaryAmountBeforeDate;
	}


	public String getHiddenKey() {
		return hiddenKey;
	}


	public void setHiddenKey(String hiddenKey) {
		this.hiddenKey = hiddenKey;
	}


	public Float getTotalSalaryAmountAllTheTime() {
		return totalSalaryAmountAllTheTime;
	}


	public void setTotalSalaryAmountAllTheTime(Float totalSalaryAmountAllTheTime) {
		this.totalSalaryAmountAllTheTime = totalSalaryAmountAllTheTime;
	}


	public Float getTotalSalaryAmountPaidAllTheTime() {
		return totalSalaryAmountPaidAllTheTime;
	}


	public void setTotalSalaryAmountPaidAllTheTime(Float totalSalaryAmountPaidAllTheTime) {
		this.totalSalaryAmountPaidAllTheTime = totalSalaryAmountPaidAllTheTime;
	}


	public Float getTotalUnpaidAmountAllTheTime() {
		return totalUnpaidAmountAllTheTime;
	}


	public void setTotalUnpaidAmountAllTheTime(Float totalUnpaidAmountAllTheTime) {
		this.totalUnpaidAmountAllTheTime = totalUnpaidAmountAllTheTime;
	}


	public List<LaborAccountDetailsDAO> getLaborAccountDetailsList() {
		return laborAccountDetailsList;
	}


	public void setLaborAccountDetailsList(List<LaborAccountDetailsDAO> laborAccountDetailsList) {
		this.laborAccountDetailsList = laborAccountDetailsList;
	}


	public List<LaborAccountDetailsDAO> getLaborAccountDetailsSortedList() {
		return laborAccountDetailsSortedList;
	}


	public void setLaborAccountDetailsSortedList(List<LaborAccountDetailsDAO> laborAccountDetailsSortedList) {
		this.laborAccountDetailsSortedList = laborAccountDetailsSortedList;
	}


	public Float getLaborBalancePending() {
		return laborBalancePending;
	}


	public void setLaborBalancePending(Float laborBalancePending) {
		this.laborBalancePending = laborBalancePending;
	}


	public Float getLaborBalanceAdvance() {
		return laborBalanceAdvance;
	}


	public void setLaborBalanceAdvance(Float laborBalanceAdvance) {
		this.laborBalanceAdvance = laborBalanceAdvance;
	}


	public String getOpeingBalancUpdatedBy() {
		return opeingBalancUpdatedBy;
	}


	public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
		this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
	}


	public String getOpeingBalanceUpdateDate() {
		return opeingBalanceUpdateDate;
	}


	public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
		this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public Float getTotalSalaryAmount() {
		return totalSalaryAmount;
	}


	public void setTotalSalaryAmount(Float totalSalaryAmount) {
		this.totalSalaryAmount = totalSalaryAmount;
	}


	public Float getTotalAmount() {
		return totalAmount;
	}


	public void setTotalAmount(Float totalAmount) {
		this.totalAmount = totalAmount;
	}


	public Float getTotalAdditionalDeductionAmount() {
		return totalAdditionalDeductionAmount;
	}


	public void setTotalAdditionalDeductionAmount(Float totalAdditionalDeductionAmount) {
		this.totalAdditionalDeductionAmount = totalAdditionalDeductionAmount;
	}


	public Float getTotalAdditionalPaymentAmount() {
		return totalAdditionalPaymentAmount;
	}


	public void setTotalAdditionalPaymentAmount(Float totalAdditionalPaymentAmount) {
		this.totalAdditionalPaymentAmount = totalAdditionalPaymentAmount;
	}
	
	
	
}
