package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ItemWiseSaleReportDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadItemWiseSaleSalesReport extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8292337304631426465L;
	public HttpServletRequest request;
	public HttpServletResponse response;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;

	private Float allBillMatrialCostTotal = 0.0f;
	private Float allMaterialQuantity = 0.0f;
	private String fromDate;
	private String toDate;
	
	private String type;
	
	private SessionMap<String,Object> sessionMap;  
	
	List<ItemWiseSaleReportDAO> itemWiseSaleList = new ArrayList<ItemWiseSaleReportDAO>();
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();


        	Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			String sql = "";
			String db = (String) this.getSession().getAttribute("db");
			
			
			DecimalFormat df= new DecimalFormat("##.##");
			
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				Map<String, ItemWiseSaleReportDAO> productMap = new LinkedHashMap<>();
				
				
				if(this.getType().equals("ALL") || this.getType().equals("CRUSHER"))
				{
				sql =   "SELECT proInfo.product_name,"
						+ "SUM(proInfo.product_sale_amount_after_discount),"
						+ "SUM(proInfo.sale_quantity) "
						+ "FROM "
						+ "crusher_bill_product_info as proInfo "
						+ "WHERE "
						+ "bill_number IN "
						+ "(SELECT bill_number "
						+ "FROM crusher_bill_info_master WHERE (bill_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND STR_TO_DATE(?,'%d-%m-%Y')) "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ ") "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ "group by proInfo.product_name";
				
				
				preparedStatement = connection.prepareStatement(sql);
				
				preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				preparedStatement.setString(5, crusherId);
				preparedStatement.setString(6, crusherCode);
			
				this.setAllBillMatrialCostTotal(0.0F);
				this.setAllMaterialQuantity(0.0F);
				resultSet = preparedStatement.executeQuery();
				
				while(resultSet.next()){
				
					String productName = resultSet.getString(1);
				    float saleAmount = resultSet.getFloat(2);
				    float quantity = resultSet.getFloat(3);

				    if (productMap.containsKey(productName)) {
				       
				        ItemWiseSaleReportDAO existingDao = productMap.get(productName);
				        existingDao.setSaleAmount(df.format(Float.parseFloat(existingDao.getSaleAmount()) + saleAmount));
				        existingDao.setProductQuantity(df.format(Float.parseFloat(existingDao.getProductQuantity()) + quantity));
				    } else {
				       
				        ItemWiseSaleReportDAO dao = new ItemWiseSaleReportDAO();
				        dao.setProductName(productName);
				        dao.setSaleAmount(df.format(saleAmount));
				        dao.setProductQuantity(df.format(quantity));
				        productMap.put(productName, dao);
				    }
				    this.setAllBillMatrialCostTotal(this.getAllBillMatrialCostTotal() + saleAmount);
				    this.setAllMaterialQuantity(this.getAllMaterialQuantity() + quantity);
				}
				}
				
				
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				
				if(this.getType().equals("ALL") || this.getType().equals("RMC"))
				{
				sql =   "SELECT proInfo.product_name,"
						+ "SUM(proInfo.product_amt_after_discount),"
						+ "SUM(proInfo.quanity) "
						+ "FROM "
						+ "crusher_rmc_productbillinfo as proInfo "
						+ "WHERE "
						+ "bill_number IN "
						+ "(SELECT bill_number "
						+ "FROM crusher_rmc_billinfo WHERE (bill_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') "
						+ "AND STR_TO_DATE(?,'%d-%m-%Y')) "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ ") "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?  "
						+ "group by proInfo.product_name";
				
				
				preparedStatement = connection.prepareStatement(sql);
				
				preparedStatement.setString(1, this.getFromDate());
				preparedStatement.setString(2, this.getToDate());
				preparedStatement.setString(3, crusherId);
				preparedStatement.setString(4, crusherCode);
				preparedStatement.setString(5, crusherId);
				preparedStatement.setString(6, crusherCode);
			
				resultSet = preparedStatement.executeQuery();
				while(resultSet.next()){
				
					String productName = resultSet.getString(1);
				    float saleAmount = resultSet.getFloat(2);
				    float quantity = resultSet.getFloat(3);

				    if (productMap.containsKey(productName)) {
				        
				        ItemWiseSaleReportDAO existingDao = productMap.get(productName);
				        existingDao.setSaleAmount(df.format(Float.parseFloat(existingDao.getSaleAmount()) + saleAmount));
				        existingDao.setProductQuantity(df.format(Float.parseFloat(existingDao.getProductQuantity()) + quantity));
				    } else {
				        
				        ItemWiseSaleReportDAO dao = new ItemWiseSaleReportDAO();
				        dao.setProductName(productName);
				        dao.setSaleAmount(df.format(saleAmount));
				        dao.setProductQuantity(df.format(quantity));
				        productMap.put(productName, dao);
				    }
				    this.setAllBillMatrialCostTotal(this.getAllBillMatrialCostTotal() + saleAmount);
				    this.setAllMaterialQuantity(this.getAllMaterialQuantity() + quantity);
				}
				}
				
				int k = 1;
				for (ItemWiseSaleReportDAO dao : productMap.values()) {
				    dao.setSrNo(k++);
				    this.getItemWiseSaleList().add(dao);
				}
				
				
				 String path=	request.getSession().getServletContext().getRealPath("/images/");

				PDDocument document = new PDDocument(); 
		      	PDPage pageItemDetails = null;
					
		      	@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
		     
		      	pageItemDetails = new PDPage(PDRectangle.A4);
					int pageCount = 1;
					
		        document.addPage(pageItemDetails);
		         PDPageContentStream contentStream = new PDPageContentStream(document, pageItemDetails);
          
		         Table itemWiseSalesDetailsPageheader;
	    			
	    			
    			  TableBuilder itemWiseSaleDetailsTableHeaderBuilder = Table.builder()
			                .addColumnsOfWidth(530)				                
			                .font(HELVETICA)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		         
		          Row itemWiseSaleheaderName = Row.builder()
			                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          
		          
		          Row itemWiseSaleinfo1 = Row.builder()
			                .add(TextCell.builder().text("Item Wise Sale Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
		    
		          
		          Row itemWiseSaleinfo2 = Row.builder()
		                .add(TextCell.builder().text("From Date: "
		                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
		                .backgroundColor(WHITE)
		                .textColor(Color.BLACK)
		                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
		                .horizontalAlignment(CENTER)
		                .build();
		          
		       
		          itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleheaderName);
		          itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo1);
		          itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo2);
		       
		          itemWiseSalesDetailsPageheader = itemWiseSaleDetailsTableHeaderBuilder.build();
		          
		          
		          float startY = pageItemDetails.getMediaBox().getHeight() - PADDING20;
		          float currentY = startY;
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(itemWiseSalesDetailsPageheader)
	                .startX(PADDING50)
	                .startY(currentY)
	                .build()
	                .draw();
		          
		          Table itemSaleDetails ;
		          
		          TableBuilder itemSaleDetailsBuilder = Table.builder()
			                .addColumnsOfWidth(40,200,100,100)				                
			                .font(HELVETICA)
			                .borderWidth(0.5F)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		          
		          
		          Row itemWisrSaledetailsTableHeader = Row.builder()
		        		  	.add(TextCell.builder().text("SrNo").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
				        	.add(TextCell.builder().text("Product").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
			                .add(TextCell.builder().text("Quantity (in BRASS)").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
			                .add(TextCell.builder().text("Amount (in Rs.)").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
			                .backgroundColor(Color.LIGHT_GRAY)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          itemSaleDetailsBuilder.addRow(itemWisrSaledetailsTableHeader);
		          
		          
		         
		         
		          int listSize = this.getItemWiseSaleList().size();
		          
		          for(int s=0;s<listSize;s++)
	        	  {
		        	  
	        		  if(currentY < 130)
	        		  {
	        			  pageCount++;
	        			  itemSaleDetails = itemSaleDetailsBuilder.build();
	        			  TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(itemSaleDetails)
			                .startX(PADDING50)
			                .startY(startY-70)
			                .build()
			                .draw();
	        			  
	        			  contentStream.close();
	        			  
	        			  contentStream = null;
				          
				      	PDPage itemDetailsNewPage = new PDPage(new PDRectangle(830,580));
		        	 contentStream = new PDPageContentStream(document,itemDetailsNewPage);
		        	 currentY =  itemDetailsNewPage.getMediaBox().getHeight() - PADDING20;
		             document.addPage( itemDetailsNewPage );
		            
		             
		             itemWiseSalesDetailsPageheader = null;
		             itemWiseSaleDetailsTableHeaderBuilder = null;
        			  
        			  
		             itemWiseSaleDetailsTableHeaderBuilder = Table.builder()
				                .addColumnsOfWidth(530)				                
				                .font(HELVETICA)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			         
		             itemWiseSaleheaderName = Row.builder()
				                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
				                .horizontalAlignment(CENTER)
				                .build();
			          
		             itemWiseSaleinfo1 = Row.builder()
				                .add(TextCell.builder().text("Item Wise Sale Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
				                .horizontalAlignment(CENTER)
				                .build();
			       
			          
		             itemWiseSaleinfo2 = Row.builder()
			                .add(TextCell.builder().text("From Date: "
			                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
			          
			       
		             itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleheaderName);
		             itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo1);
		             itemWiseSaleDetailsTableHeaderBuilder.addRow(itemWiseSaleinfo2);
			       
		             itemWiseSalesDetailsPageheader = itemWiseSaleDetailsTableHeaderBuilder.build();
			          
		             itemSaleDetails = null;
			          
			          
			          
        			  itemSaleDetailsBuilder = Table.builder()
        					  	.addColumnsOfWidth(40,200,100,100)			                
					            .font(HELVETICA)
				                .borderWidth(0.5F)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			          
			          
        			  itemWisrSaledetailsTableHeader = Row.builder()
  		        		  	.add(TextCell.builder().text("SrNo").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
  				        	.add(TextCell.builder().text("Product").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
  			                .add(TextCell.builder().text("Quantity (in BRASS)").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
  			                .add(TextCell.builder().text("Amount (in Rs.)").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())
  			                .backgroundColor(Color.LIGHT_GRAY)
  			                .textColor(Color.BLACK)
  			                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
  			                .horizontalAlignment(CENTER)
  			                .build();
  		          itemSaleDetailsBuilder.addRow(itemWisrSaledetailsTableHeader);
        			  
			          TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(itemWiseSalesDetailsPageheader)
		                .startX(PADDING50)
		                .startY(currentY)
		                .build()
		                .draw();
		             
		          
	        		  }
	        		  
	        		  
	        		  ItemWiseSaleReportDAO dao = this.getItemWiseSaleList().get(s);
	        		  
	        	
	        		Row itemInfoRow = Row.builder()
	        					.add(TextCell.builder().text(""+dao.getSrNo()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(dao.getProductName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(dao.getProductQuantity()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(dao.getSaleAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(10)				              
				                .horizontalAlignment(CENTER)
				                .height(25F)					                
				                .build();
	        		  
	        		itemSaleDetailsBuilder.addRow(itemInfoRow);
		        	 
	        			currentY = currentY -25;
	        		  
	        	  }
	        	  
	        	

	        		Row totalInfoRow = Row.builder()
		        			  	.add(TextCell.builder().text("Total").colSpan(2).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getAllMaterialQuantity()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getAllBillMatrialCostTotal()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(12)				              
				                .horizontalAlignment(CENTER)
				                .height(25F)					                
				                .build();
	        		itemSaleDetailsBuilder.addRow(totalInfoRow);
	        	  
	        		itemSaleDetails = itemSaleDetailsBuilder.build();
	        	  
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(itemSaleDetails)
	                .startX(PADDING50)
	                .startY(startY-70)
	                .build()
	                .draw();
		          
		     
		          contentStream.close();
		         
			       // System.out.println(path);
							
			        
			        document.save(path+"/item-wise-sales.pdf");
			        document.close();
			        
			        response.setHeader("Content-disposition", "inline; filename=item-wise-sales.pdf");
					response.setContentType("application/pdf");
					FileInputStream fileInputStream = new FileInputStream(path+"/item-wise-sales.pdf");
					PrintWriter out = response.getWriter();  
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						out.write(bytes);
					}
					fileInputStream.close();
					out.flush();
					out.close();
				
				
				
				
			}catch (SQLException e) {
				//e.printStackTrace();
			
				addActionError("Records not found for specified dates!");
				
				
			} catch (IOException e) {
			
			
				//e.printStackTrace();
				addActionError("Records not found for specified dates!");
			}finally
			{
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
        }
	}
	public HttpServletRequest getRequest() {
		return request;
	}
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	public HttpServletResponse getResponse() {
		return response;
	}
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public Float getAllBillMatrialCostTotal() {
		return allBillMatrialCostTotal;
	}
	public void setAllBillMatrialCostTotal(Float allBillMatrialCostTotal) {
		this.allBillMatrialCostTotal = allBillMatrialCostTotal;
	}
	public Float getAllMaterialQuantity() {
		return allMaterialQuantity;
	}
	public void setAllMaterialQuantity(Float allMaterialQuantity) {
		this.allMaterialQuantity = allMaterialQuantity;
	}
	public String getFromDate() {
		return fromDate;
	}
	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}
	public String getToDate() {
		return toDate;
	}
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public List<ItemWiseSaleReportDAO> getItemWiseSaleList() {
		return itemWiseSaleList;
	}
	public void setItemWiseSaleList(List<ItemWiseSaleReportDAO> itemWiseSaleList) {
		this.itemWiseSaleList = itemWiseSaleList;
	}
	


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	
	

}
