package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.DailyExpenseDAO;
import com.stonecrusher.DAO.VehicleMaintenanceInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DownloadDailyExpenseReport extends ActionSupport implements SessionAware{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 5550157277608651979L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

    private HttpSession session;
	private String fromDate;
	private String toDate;
	private List<DailyExpenseDAO> dailyExpenseList = new ArrayList<DailyExpenseDAO>();
	private Float totalExpenseAmount = 0.0F;
	private String addSideBarJs;
	private HashMap<String,String> accountHeadMapList = new HashMap<String,String>(); 
	private String accountHeadId;
	private Map<String,String> siteList = new LinkedHashMap<String,String>();
	private String siteCode;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();
			
			downloadTypeList.add("pdf");
	    	downloadTypeList.add("xl");
		
        	
        	Connection connection = null;
    		PreparedStatement preparedStatement= null;
    		ResultSet resultSet = null;
    	 
    		String sql = "";
    		String db = (String) session.getAttribute("db");
    		
    		try
    		{
    			String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
    			
				connection = GetDBConnection.getDBConnection(db);
    			
				if(this.getAccountHeadId().equals("ALL")  && this.getSiteCode().equals("ALL"))
				{
	    			sql = "SELECT "
	    					+ "entry_id,"
	    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
	    					+ "expense_reason,"
	    					+ "expense_amount,"
	    					+ "type_of_payment,"
	    					+ "expense_details,"
	    					+ "expense_bill_image "
	    					+ "FROM "
	    					+ "crusher_daily_expenses "
	    					+ "WHERE "
	    					+ "expense_date BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y') "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    					
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			
	    			preparedStatement.setString(1, this.getFromDate());
	    			preparedStatement.setString(2, this.getToDate());
	    			preparedStatement.setString(3, crusherId);
    				preparedStatement.setString(4, crusherCode);
    				
				}else if(!this.getAccountHeadId().equals("ALL")  && this.getSiteCode().equals("ALL"))
				{
	    			sql = "SELECT "
	    					+ "entry_id,"
	    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
	    					+ "expense_reason,"
	    					+ "expense_amount,"
	    					+ "type_of_payment,"
	    					+ "expense_details,"
	    					+ "expense_bill_image "
	    					+ "FROM "
	    					+ "crusher_daily_expenses "
	    					+ "WHERE "
	    					+ "expense_date BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y') "
	    					+ "AND "
	    					+ "head_id = ? "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    			
	    					
	    					
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			
	    			preparedStatement.setString(1, this.getFromDate());
	    			preparedStatement.setString(2, this.getToDate());
	    			preparedStatement.setString(3, this.getAccountHeadId());
	    			preparedStatement.setString(4, crusherId);
    				preparedStatement.setString(5, crusherCode);
    				
	    			
				}else if(this.getAccountHeadId().equals("ALL")  && !this.getSiteCode().equals("ALL"))
				{
	    			sql = "SELECT "
	    					+ "entry_id,"
	    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
	    					+ "expense_reason,"
	    					+ "expense_amount,"
	    					+ "type_of_payment,"
	    					+ "expense_details,"
	    					+ "expense_bill_image "
	    					+ "FROM "
	    					+ "crusher_daily_expenses "
	    					+ "WHERE "
	    					+ "expense_date BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y') "
	    					+ "AND "
	    					+ "site_code = ? "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
	    			
	    					
	    					
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			
	    			preparedStatement.setString(1, this.getFromDate());
	    			preparedStatement.setString(2, this.getToDate());
	    			preparedStatement.setString(3, this.getSiteCode());
	    			preparedStatement.setString(4, crusherId);
    				preparedStatement.setString(5, crusherCode);
    				
	    			
				} else
				{
					sql = "SELECT "
	    					+ "entry_id,"
	    					+ "DATE_FORMAT(expense_date,'%d-%m-%Y'),"
	    					+ "expense_reason,"
	    					+ "expense_amount,"
	    					+ "type_of_payment,"
	    					+ "expense_details,"
	    					+ "expense_bill_image "
	    					+ "FROM "
	    					+ "crusher_daily_expenses "
	    					+ "WHERE "
	    					+ "head_id = ? "
	    					+ "AND "
	    					+ "(expense_date BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
	    					+ "site_code = ? "
	    					+ "AND "
    						+ "crusher_id = ? "
							+ "AND "
							+ "crusher_code = ?";
					
	    			preparedStatement = connection.prepareStatement(sql);
	    			
	    			preparedStatement.setString(1, this.getAccountHeadId());
	    			preparedStatement.setString(2, this.getFromDate());
	    			preparedStatement.setString(3, this.getToDate());
	    			preparedStatement.setString(4, this.getSiteCode());
	    			preparedStatement.setString(5, crusherId);
    				preparedStatement.setString(6, crusherCode);
    				
    				
				}
    			
    			resultSet = preparedStatement.executeQuery();
    			resultSet.last();
    			int resultCount = resultSet.getRow();
    			resultSet.beforeFirst();
    			
    			if(resultCount > 0)
    			{
    				while(resultSet.next())
    				{
    					DailyExpenseDAO dailyExpenseDAO = new DailyExpenseDAO();
    					dailyExpenseDAO.setId(resultSet.getString(1));
    					dailyExpenseDAO.setExpenseDate(resultSet.getString(2));
    					dailyExpenseDAO.setExpenseReason(resultSet.getString(3));
    					dailyExpenseDAO.setAmount(resultSet.getString(4));
    					dailyExpenseDAO.setTypeOfPayment(resultSet.getString(5));
    					dailyExpenseDAO.setDescription(resultSet.getString(6));
    					dailyExpenseDAO.setExpenseImage(resultSet.getBlob(7));
    					dailyExpenseDAO.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(2)+"#"+resultSet.getString(4)));
    					this.setTotalExpenseAmount(this.getTotalExpenseAmount()+Float.parseFloat(resultSet.getString(4)));
    					
    					dailyExpenseList.add(dailyExpenseDAO);
    					
    				}
    				
    			}
    			
    			@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
				if(this.getDownloadType().equals("pdf"))
				{
					
				
    			
    			String path=	request.getSession().getServletContext().getRealPath("/images/");
    			PDDocument document = new PDDocument(); 
				PDPage page = null;
				
				
					 page = new PDPage(PDRectangle.A4);
				
				
			        document.addPage(page);
			         PDPageContentStream contentStream = new PDPageContentStream(document, page);
			         int pageCount = 1;
		    			 Table header;
		    			 Table creditDetails;
		    			 
		    			
		    			  TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row info1 = Row.builder()
					                .add(TextCell.builder().text("Daily Expense Report  "
					                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info2 = Row.builder()
					                .add(TextCell.builder().text("From Date : "
					                		+ ""+this.getFromDate()
					                		+ " and To Date :"+this.getToDate() +" Head Id : " + this.getAccountHeadId() +" Site : " + this.getSiteCode()).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				          
				          tableHeaderBuilder.addRow(headerName);
				          tableHeaderBuilder.addRow(info1);
				          tableHeaderBuilder.addRow(info2);
				          header = tableHeaderBuilder.build();
				          
				          
				          TableBuilder tableDebtDetailsBuilder = Table.builder()
				        		  .addColumnsOfWidth(25, 50, 180, 50, 180 ,50)		                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				          
				          Row tableHeader = Row.builder()
				        		  	.add(TextCell.builder().text("ID").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Expense Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Reason").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Payment Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Description").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          tableDebtDetailsBuilder.addRow(tableHeader);
				       
				        
				     
				        	  int size = this.getDailyExpenseList().size();
				        	  
				        	  
					          float startY = page.getMediaBox().getHeight() - PADDING20;
					          float currentY = startY;
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
					          
					          
					          
					    	  for(int s=0;s<size;s++)
				        	  {
				        		  
				        		  if(currentY < 50)
				        		  {
				        			  pageCount++;
				        			  creditDetails = tableDebtDetailsBuilder.build();
				        			  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(creditDetails)
						                .startX(PADDING30)
						                .startY(startY-50)
						                .build()
						                .draw();
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			 
						    			 
						    			
						    			  tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(550)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								           headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								           info1 = Row.builder()
									                .add(TextCell.builder().text("Daily Expense Report  "
								                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
								           info2 = Row.builder()
									                .add(TextCell.builder().text("From Date : "
									                		+ ""+this.getFromDate()
									                		+ " and To Date :"+this.getToDate() +" Head Id : " + this.getAccountHeadId() +" Site : " + this.getSiteCode()).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								          header = tableHeaderBuilder.build();
				        			  
				        			  creditDetails = null;
				        			   tableDebtDetailsBuilder = Table.builder()
				        					   .addColumnsOfWidth(25, 50, 180, 50, 180 ,50)		                
								                .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							           tableHeader = Row.builder()
							        		    .add(TextCell.builder().text("ID").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text("Expense Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Reason").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Payment Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Description").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          tableDebtDetailsBuilder.addRow(tableHeader);
							          
				        			  
				        				PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
				        		  }
				        		  
				        		  DailyExpenseDAO dao2 = this.getDailyExpenseList().get(s);
				        		  
				        			Row supplierInfo = Row.builder()
				        					.add(TextCell.builder().text(dao2.getId()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getExpenseDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getExpenseReason()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getTypeOfPayment()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getDescription()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableDebtDetailsBuilder.addRow(supplierInfo);
					        	 
					        	  currentY = currentY -25;
				        	  }
					          
					    	  Row custInfo = Row.builder()
					    			   .add(TextCell.builder().text("Total Expense Amount").colSpan(5).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			   .add(TextCell.builder().text("" + this.getTotalExpenseAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			    .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD)
						                .fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .height(15F)					                
						                .build();
				        	  
				        	  tableDebtDetailsBuilder.addRow(custInfo);
				        	  creditDetails = tableDebtDetailsBuilder.build();
				         
				          
				          TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(creditDetails)
			                .startX(PADDING30)
			                .startY(startY-50)
			                .build()
			                .draw();
				          contentStream.close();
					          
					          
					          
					          document.save(path+"/daily-expense-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-headId-"+this.getAccountHeadId()+"-site-"+this.getSiteCode()+"-report.pdf");
						        document.close();
						        
						        response.setHeader("Content-disposition", "inline; filename=daily-expense-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-headId-"+this.getAccountHeadId()+"-site-"+this.getSiteCode()+"-report.pdf");
								response.setContentType("application/pdf");
								
								FileInputStream fileInputStream = new FileInputStream(path+"/daily-expense-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-headId-"+this.getAccountHeadId()+"-site-"+this.getSiteCode()+"-report.pdf");
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.flush();
								out.close();
								
				}
				
				if(this.getDownloadType().equals("xl"))
				{

					String fileName = "daily-expense-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-headId-"+this.getAccountHeadId()+"-site-"+this.getSiteCode()+".xls";
					 HSSFWorkbook workbook = new HSSFWorkbook();
					  HSSFSheet mySheet = workbook.createSheet("daily-expense-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-headId-"+this.getAccountHeadId()+"-site-"+this.getSiteCode());  
					
					  mySheet.setColumnWidth(0, 10 * 256); 
					  mySheet.setColumnWidth(1, 30 * 256); 
					  mySheet.setColumnWidth(2, 50 * 256); 
					  mySheet.setColumnWidth(3, 25 * 256); 
					  mySheet.setColumnWidth(4, 40 * 256); 
					  mySheet.setColumnWidth(5, 40 * 256); 
					 

					
					 
					 	Font font = workbook.createFont();
				       
				        font.setBold(true);
				       
					 final HSSFCellStyle cellStyle = workbook.createCellStyle();

					 cellStyle.setBorderBottom(BorderStyle.THIN);
					 cellStyle.setBorderRight(BorderStyle.THIN);
					 cellStyle.setBorderLeft(BorderStyle.THIN);
					 cellStyle.setBorderTop(BorderStyle.THIN);
					 cellStyle.setFont(font);
					 cellStyle.setWrapText(true);
					 
					 final HSSFCellStyle cellStyleNonBold = workbook.createCellStyle();

					 cellStyleNonBold.setBorderBottom(BorderStyle.THIN);
					 cellStyleNonBold.setBorderRight(BorderStyle.THIN);
					 cellStyleNonBold.setBorderLeft(BorderStyle.THIN);
					 cellStyleNonBold.setBorderTop(BorderStyle.THIN);
					 
					 short s = 255-0-0;
					 final HSSFCellStyle cellStyleBoldRed = workbook.createCellStyle();	 
					 
					 cellStyleBoldRed.setBorderBottom(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderRight(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderLeft(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderTop(BorderStyle.THIN);
					 cellStyleBoldRed.setFillForegroundColor(s);
					 cellStyleBoldRed.setFont(font);								 
					 cellStyleBoldRed.setWrapText(true);
					 
					 HSSFRow rowHead = mySheet.createRow(0);							 
					 
					 Cell cellHead1 = rowHead.createCell(0);
					 cellHead1.setCellValue("ID");
					 cellHead1.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead2 = rowHead.createCell(1);
					 cellHead2.setCellValue("Expense Date");
					 cellHead2.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead3 = rowHead.createCell(2);
					 cellHead3.setCellValue("Reason");
					 cellHead3.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead4 = rowHead.createCell(3);
					 cellHead4.setCellValue("Payment Type");
					 cellHead4.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead5 = rowHead.createCell(4);
					 cellHead5.setCellValue("Description");
					 cellHead5.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead6 = rowHead.createCell(5);
					 cellHead6.setCellValue("Amount");
					 cellHead6.setCellStyle(cellStyleBoldRed);
					 
					 
					 
					 int rowCount = 1;
					   for(DailyExpenseDAO dao:this.getDailyExpenseList())
				       {
								 HSSFRow rowData = mySheet.createRow(rowCount);
								  
								 
								 
								 Cell cell1 = rowData.createCell(0);
								 cell1.setCellValue(dao.getId());
								 cell1.setCellStyle(cellStyleNonBold);
								 
								 Cell cell2 = rowData.createCell(1);
								 cell2.setCellValue(dao.getExpenseDate());
								 cell2.setCellStyle(cellStyleNonBold);
								 
								  
								Cell cell3 = rowData.createCell(2);
								 cell3.setCellValue(dao.getExpenseReason());
								 cell3.setCellStyle(cellStyleNonBold);
								 
								 Cell cell4 = rowData.createCell(3);
								 cell4.setCellValue(dao.getTypeOfPayment());
								 cell4.setCellStyle(cellStyleNonBold);
								 
								 
								 Cell cell5 = rowData.createCell(4);
								 cell5.setCellValue(dao.getDescription());
								 cell5.setCellStyle(cellStyleNonBold);
								 
								 Cell cell6 = rowData.createCell(5);
								 cell6.setCellValue(dao.getAmount());
								 cell6.setCellStyle(cellStyleNonBold);
								 
								

								
								
								 
								 
								 rowCount++;
								 
				       }
					   
					   HSSFRow totalRow = mySheet.createRow(rowCount);

					Cell totalLabelCell = totalRow.createCell(4);
					totalLabelCell.setCellValue("Total Expense Amount");
					totalLabelCell.setCellStyle(cellStyleBoldRed); 

					Cell totalAmountCell = totalRow.createCell(5);
					totalAmountCell.setCellValue(this.getTotalExpenseAmount());
					totalAmountCell.setCellStyle(cellStyleBoldRed); 

					Cell emptyCell1 = totalRow.createCell(0);
					emptyCell1.setCellValue("");
					emptyCell1.setCellStyle(cellStyleNonBold);

					Cell emptyCell2 = totalRow.createCell(1);
					emptyCell2.setCellValue("");
					emptyCell2.setCellStyle(cellStyleNonBold);

					Cell emptyCell3 = totalRow.createCell(2);
					emptyCell3.setCellValue("");
					emptyCell3.setCellStyle(cellStyleNonBold);

					Cell emptyCell4 = totalRow.createCell(3);
					emptyCell4.setCellValue("");
					emptyCell4.setCellStyle(cellStyleNonBold);

					
					   
					
					   
					   FileOutputStream fileOut = new FileOutputStream(fileName);
					   workbook.write(fileOut);
			            fileOut.close();
			            workbook.close();
			            
			    		response.setHeader("Content-disposition", "inline; filename="+""+fileName);
						response.setContentType("application/xls");
						FileInputStream fileInputStream = new FileInputStream(fileName);
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.close();
				}
    			
    		}
    		catch (SQLException e) 
    		{
	    		 e.printStackTrace();
	    				    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    			
	    	} catch (Exception e) {
	    		
	    		e.printStackTrace();	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || Something Went Wrong!");
	    	}
    			finally {
    				if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
        }
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	


	


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}


	public List<DailyExpenseDAO> getDailyExpenseList() {
		return dailyExpenseList;
	}


	public void setDailyExpenseList(List<DailyExpenseDAO> dailyExpenseList) {
		this.dailyExpenseList = dailyExpenseList;
	}


	public Float getTotalExpenseAmount() {
		return totalExpenseAmount;
	}


	public void setTotalExpenseAmount(Float totalExpenseAmount) {
		this.totalExpenseAmount = totalExpenseAmount;
	}


	public HashMap<String, String> getAccountHeadMapList() {
		return accountHeadMapList;
	}


	public void setAccountHeadMapList(HashMap<String, String> accountHeadMapList) {
		this.accountHeadMapList = accountHeadMapList;
	}


	public String getAccountHeadId() {
		return accountHeadId;
	}


	public void setAccountHeadId(String accountHeadId) {
		this.accountHeadId = accountHeadId;
	}


	public Map<String, String> getSiteList() {
		return siteList;
	}


	public void setSiteList(Map<String, String> siteList) {
		this.siteList = siteList;
	}


	public String getSiteCode() {
		return siteCode;
	}


	public void setSiteCode(String siteCode) {
		this.siteCode = siteCode;
	}


	

}
