package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.CustomerAccountDetailsDAO;
import com.stonecrusher.DAO.DailyExpenseDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.GetVehicleList;

public class DownloadCustomerAccStmtReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8067551982812238850L;
	
	public HttpServletRequest request;
	public HttpServletResponse response;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;
    
    private HttpSession session;
    private String returnMessage;
	private String key;
    private String fromDate;
	private String toDate;
	private String totalBillAmountBeforeDate;
	private String totalAmountPaidBeforeDate;
	private String totalOutStandingAmountBeforeDate;
	
	private String totalBillAmountAllTheTime;
	private String totalAmountPaidAllTheTime;
	private String totalOutStandingAmountAllTheTime;
	
	private float totalBillAmountBetweenDates;
	private float totalAmountPaidBetweenDates;
	private float totalOutStandingAmountBetweenDates;
	
	
	
	private String smsData;
	private List<CustomerAccountDetailsDAO> customerAccountDetailsList = new ArrayList<CustomerAccountDetailsDAO>();
	private List<CustomerAccountDetailsDAO> customerAccountDetailsSoretdList = new ArrayList<CustomerAccountDetailsDAO>();
	private Float custOpeningBalnce = 0.0F;
	private String opeingBalancUpdatedBy;
	private String opeingBalanceUpdateDate;
	
	
	private String total6mm;
	private String total10mm;
	private String total20mm;
	private String total40mm;
	private String totalCSand;
	private String totalDust;
	private String totalOther;
	private String totalPS;
	private String totalPowder;
    
	private SessionMap<String,Object> sessionMap;  
	private Float materialTotal;
	private Float totalRoyaltyAllTheTime;
	private String type;
	private List<String> typeList = new ArrayList<String>();
	private List<Map<String, Object>> productQuantityList = new ArrayList<>();
	   
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	private Float totalTrChargesAllTheTime;
	private Float totalMaterialCostAllTheTime;
	private Float totalPumpAmtAllTheTime;
	private Float totalLaborAmtAllTheTime;
	
	private Float totalTaxableAmtAllTheTime;
	private Float totalCgstAllTheTime;
	private Float totalSgstAllTheTime;
	private String crusherAccount;
	
    public void download() throws ParseException
	
    {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else{
	        	
	        	
	       		
	        	LinkedHashMap<String,String> vehicleList = GetVehicleList.getVehicleList(this.getSession());
	        	
	        	
	        	
	        	response = ServletActionContext.getResponse();
				request = ServletActionContext.getRequest();
				
				String custId = EncryptionDecryption.decrypt(getKey());	
	        	
	        	setKey(EncryptionDecryption.encrypt(custId));
	        	

	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	    		
	       		DecimalFormat df = new DecimalFormat("##.##");
	       	
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		try {
	       			
	       			String crusherId = (String) session.getAttribute("crusherId");
		    		String crusherCode = (String) session.getAttribute("crusherCode");
		    		
		       		
					connection = GetDBConnection.getDBConnection(db);
	       			
	       			
                  String nameOfCustomer = "";
                  String custAddress = "";
	       			
					connection = GetDBConnection.getDBConnection(db);
					
					
	       				sql = "SELECT "
								+ "customer_name,"
								+ "billing_address "
								+ "FROM "
								+ "crusher_customer_master "
								+ "WHERE "
								+ "customer_id = ? "
								+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ?";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, custId);
						preparedStatement.setString(2, crusherId);
	    				preparedStatement.setString(3, crusherCode);
	    				
	       			
    				resultSet = preparedStatement.executeQuery();
					 
					 if(resultSet.next())
					 {
						 nameOfCustomer = resultSet.getString(1); 
						 custAddress = resultSet.getString(2); 
					 }
							
					 if(resultSet != null)
		       			{
		       				resultSet.close();
		       				resultSet = null;
		       			}
					 if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       			
					 PreparedStatement getOpeningBalPSMT = null;
	       				ResultSet getOpeningBalRs = null;
	       			
	       				String getOpeningBalSQL = "SELECT "
	       						+ "opening_balance,"
	       						+ "DATE_FORMAT(opening_balance_date,'%d/%m/%Y'),"
	       						+ "updated_by "
	       						+ "FROM "
	       						+ "crusher_cust_close_open_bal_master "
	       						+ "WHERE "
	       						+ "customer_id = ? "
	       						+ "AND "
		       					+ "crusher_id = ? "
		       					+ "AND "
		       					+ "crusher_code = ? ";
	       				
	       				getOpeningBalPSMT = connection.prepareStatement(getOpeningBalSQL);
	       				
	       				getOpeningBalPSMT.setString(1, custId);
	       				getOpeningBalPSMT.setString(2, crusherId);
	       				getOpeningBalPSMT.setString(3, crusherCode);
	       				
	       				
	       				getOpeningBalRs = getOpeningBalPSMT.executeQuery();
	       				
	       				if(getOpeningBalRs.next())
	       				{
	       					this.setCustOpeningBalnce(getOpeningBalRs.getFloat(1));
	       					this.setOpeingBalanceUpdateDate(getOpeningBalRs.getString(2));
	       					this.setOpeingBalancUpdatedBy(getOpeningBalRs.getString(3));
	       				}
	       				else
	       				{
	       					this.setCustOpeningBalnce(0.0F);
	       				}
	       				if(getOpeningBalRs != null)
	       				{
	       					getOpeningBalRs.close();
	       					getOpeningBalRs = null;
	       				}
	       				if(getOpeningBalPSMT != null)
	       				{
	       					getOpeningBalPSMT.close();
	       					getOpeningBalPSMT = null;
	       				}
	       				
	       			
	       				sql = "SELECT SUM(amount) "
		       					+ "FROM "
		       					+ "crusher_customer_payment_details_master "
		       					+ "WHERE "
		       					+ "customer_id = ? "
		       					+ "AND "
		       					+ "payment_date < STR_TO_DATE(?, '%d-%m-%Y') "
		       					+ "AND "
		       					+ "crusher_id = ? "
		       					+ "AND "
		       					+ "crusher_code = ? ";
		       			
		       			preparedStatement = connection.prepareStatement(sql);
		       			preparedStatement.setString(1, custId);
		       			preparedStatement.setString(2, this.getFromDate());
		       			preparedStatement.setString(3, crusherId);
		       			preparedStatement.setString(4, crusherCode);
		       			
	       			
		       			resultSet = preparedStatement.executeQuery();
		       			
		       			if(resultSet.next())
		       			{
		       				if(resultSet.getString(1) != null)
		       				{
		       				setTotalAmountPaidBeforeDate(resultSet.getString(1));
		       				}
		       				else
		       				{
		       					setTotalAmountPaidBeforeDate("0.0");
		       				}
		       			}
		       			else
		       			{
		       				setTotalAmountPaidBeforeDate("0.0");
		       			}
		       			
		       			//System.out.println(" Amount Paid :"+getTotalAmountPaidBeforeDate());
		       			
		       			if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
		       			
		       			float floatTotalAmt = 0.0F;
	       				float floatAmtReceived = 0.0F;
	       				float floatBalanceAmt = 0.0F;
	       				float totalBalanceAmt = 0.0F;
	       				float totalAmountReceived = Float.parseFloat(this.getTotalAmountPaidBeforeDate());
	       				float totalBillAmountBeforeDate = 0.0F;
	       				
	       				
	       				if(this.getCrusherAccount().equals("ALL") || this.getCrusherAccount().equals("CRUSHER"))
		       			{
	       				sql = "SELECT "	           					
	           					+ "bill_total_amount,"
	           					+ "bill_amount_received,"
	           					+ "bill_amount_return "
	           					+ "FROM "
	           					+ "crusher_bill_info_master "
	           					+ "WHERE "		           					
	           					+ "customer_id = ? "
	           					+ "AND "
	           					+ "bill_date < STR_TO_DATE(?, '%d-%m-%Y') "
	           					+ "AND "
	           					+ "crusher_id = ? "
	           					+ "AND "
	           					+ "crusher_code = ? ";
	       				
	       				preparedStatement = connection.prepareStatement(sql);
	       				preparedStatement.setString(1, custId);
		       			preparedStatement.setString(2, this.getFromDate());
		       			preparedStatement.setString(3, crusherId);
		       			preparedStatement.setString(4, crusherCode);
		       			
		       			
		       				
	    					
		       			
	       				ResultSet resultSetBillInfo = preparedStatement.executeQuery();
	       				
	       				while(resultSetBillInfo.next())
	       				{
	       					try
	       					{
		       					floatTotalAmt = Float.parseFloat(resultSetBillInfo.getString(1));
		           				floatAmtReceived = Float.parseFloat(resultSetBillInfo.getString(2));
		           				
		           				totalBillAmountBeforeDate = totalBillAmountBeforeDate + floatTotalAmt;
		           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
		           			
		           				
		           				if(floatBalanceAmt > 0)
		           				{
		           					totalAmountReceived = totalAmountReceived + floatAmtReceived;
		           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 	           					
		           				}
		           				else if(floatBalanceAmt == 0)
		           				{
		           					totalAmountReceived = totalAmountReceived + floatTotalAmt;
		           				}
		           				
	       					}catch(NumberFormatException nfe)
	       					{
	       						result = "error";
	       						
	       					}
	       				}

	       				if(resultSetBillInfo != null)
	       				{
	       					resultSetBillInfo.close();
	       					resultSetBillInfo = null;
	       				}
		       		}
	       				
	       				
	       				
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}

	       				
	       				if(this.getCrusherAccount().equals("ALL") || this.getCrusherAccount().equals("RMC"))
		       			{
	       				
	    					
		       				sql = "select "	           					
		           					+ "bill_total_amount,"
		           					+ "bill_amount_received,"
		           					+ "amount_return "
		           					+ "from "
		           					+ "crusher_rmc_billinfo "
		           					+ "where "		           					
		           					+ "customer_id = ? "
		           					+ "and "
		           					+ "bill_date < STR_TO_DATE(?, '%d-%m-%Y') "
		           					+ "AND "
		           					+ "crusher_id = ? "
		           					+ "AND "
		           					+ "crusher_code = ? ";
		       				
		       				preparedStatement = connection.prepareStatement(sql);
		       				preparedStatement.setString(1, custId);
			       			preparedStatement.setString(2, this.getFromDate());
			       			preparedStatement.setString(3, crusherId);
			       			preparedStatement.setString(4, crusherCode);
		       				
		       			
	       				ResultSet resultSetRMCBillInfo = preparedStatement.executeQuery();
	       				
	       				
	       				  
	       				while(resultSetRMCBillInfo.next())
	       				{
	       					try
	       					{
		       					floatTotalAmt = Float.parseFloat(resultSetRMCBillInfo.getString(1));
		           				floatAmtReceived = Float.parseFloat(resultSetRMCBillInfo.getString(2));
		           				
		           				totalBillAmountBeforeDate = totalBillAmountBeforeDate + floatTotalAmt;
		           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
		           			
		           				
		           				if(floatBalanceAmt > 0)
		           				{
		           					totalAmountReceived = totalAmountReceived + floatAmtReceived;
		           					totalBalanceAmt = totalBalanceAmt+floatBalanceAmt; 	           					
		           				}
		           				else if(floatBalanceAmt == 0)
		           				{
		           					totalAmountReceived = totalAmountReceived + floatTotalAmt;
		           				}
		           				
	       					}catch(NumberFormatException nfe)
	       					{
	       						result = "error";
	       						
	       					}
	       				}
	       				
	       				if(resultSetRMCBillInfo != null)
	       				{
	       					resultSetRMCBillInfo.close();
	       					resultSetRMCBillInfo = null;
	       				}
	       				
		       		}
	       				
	       				
	       				
	       				
	       				if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
	       				
	       				
	       				
	       				float floatTotalAmtPaidBeforeDate = 0.0F;
	       				if(getTotalAmountPaidBeforeDate() != null)
	       				{
	       					try
	       					{
	       					floatTotalAmtPaidBeforeDate = totalAmountReceived;
	       					
	       					}
	       					catch(NumberFormatException nfe)
	       					{
	       						result = "error";
	       						addActionError(this.getText("message.error.errorWhileParsingInBeforeDateCalculation"));
	       					}
	       				}
	       				setTotalOutStandingAmountBeforeDate(""+(totalBillAmountBeforeDate-floatTotalAmtPaidBeforeDate));
	       				setTotalAmountPaidBeforeDate(""+floatTotalAmtPaidBeforeDate);
		       			setTotalBillAmountBeforeDate(""+totalBillAmountBeforeDate);
		       			
		       			
		       			if(resultSet != null)
		       			{
		       				resultSet.close();
		       				resultSet = null;
		       			}
		       			
		       			
		       		

	    					
		       				sql = "SELECT "
			       					+ "DATE_FORMAT(payment_date, '%d/%m/%Y'),"
			       					+ "amount,"
			       					+ "payemnt_details,"
			       					+ "payment_entry_by,"
			       					+ "payement_entry_id "
			       					+ "FROM "
			       					+ "crusher_customer_payment_details_master "
			       					+ "WHERE "
			       					+ "customer_id = ? "
			       					+ "AND "
			       					+ "(payment_date BETWEEN "
				   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
				   					+ "AND "
				   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
				   					+ "AND "
				   					+ "crusher_id = ? "
				   					+ "AND "
				   					+ "crusher_code = ? ";
			       			
			       			preparedStatement = connection.prepareStatement(sql);
			       			preparedStatement.setString(1, custId);
			       			preparedStatement.setString(2, this.getFromDate());
			       			preparedStatement.setString(3, this.getToDate());
			       			preparedStatement.setString(4, crusherId);
			       			preparedStatement.setString(5, crusherCode);
		       			
		       			
		       			resultSet = preparedStatement.executeQuery();
		       		
		       			
		       			while(resultSet.next())	       				
		       			{
		       				
		       				CustomerAccountDetailsDAO accountDetailsDAO = new CustomerAccountDetailsDAO();
		       				Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(1)); 
		       				
		       				accountDetailsDAO.setDate(date1);
		       				accountDetailsDAO.setAmountPaid(resultSet.getFloat(2));
		       				accountDetailsDAO.setComments(resultSet.getString(3));
		       				accountDetailsDAO.setBilledBy(resultSet.getString(4));
		       				accountDetailsDAO.setBalanceAmount("0.0");
		       				accountDetailsDAO.setBillNumber("");
		       				accountDetailsDAO.setCustPaymentId(resultSet.getString(5));
		       				accountDetailsDAO.setBillAmount("0.0");
		       				accountDetailsDAO.setChalanNumber("RECEIVED");
		       				
		       				customerAccountDetailsList.add(accountDetailsDAO);
		       				
		       			}
		       			
		       			if(preparedStatement != null)
	       				{
	       					preparedStatement.close();
	       					preparedStatement = null;
	       				}
		       			
		       			float totaltrAmount = 0.0f;
		       			totalLaborAmtAllTheTime = 0.0f;
		       			totalPumpAmtAllTheTime = 0.0f;
		       			
		       			if(this.getCrusherAccount().equals("ALL") || this.getCrusherAccount().equals("CRUSHER"))
		       			{
		       			
		       				sql = "SELECT "
			       					+ "bill_number,"
			       					+ "DATE_FORMAT(bill_date, '%d/%m/%Y'),"
			       					+ "comments,"	           					
		           					+ "bill_total_amount,"
		           					+ "bill_amount_received,"
		           					+ "bill_amount_return,"
		           					+ "billed_by,"
		           					+ "chalan_number,"
		           					+ "bill_type,"
		           					+ "vehicle_id,"
		           					+ "transportation_charges "
		           					+ "FROM "
		           					+ "crusher_bill_info_master "
		           					+ "WHERE "		           					
		           					+ "customer_id = ? "
		           					+ "AND "
		           					+ "(bill_date between "
				   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
				   					+ "AND "
				   					+ "STR_TO_DATE(?, '%d-%m-%Y')) "
				   					+ "AND "
				   					+ "crusher_id = ? "
				   					+ "AND "
				   					+ "crusher_code = ? ";
							       
							 
			       			
		       						preparedStatement = connection.prepareStatement(sql);
		       						preparedStatement.setString(1, custId);
		       		       			preparedStatement.setString(2, this.getFromDate());
		       		       			preparedStatement.setString(3, this.getToDate());
		       		       			preparedStatement.setString(4, crusherId);
		       		       			preparedStatement.setString(5, crusherCode);
		       				
		       			
	       						resultSet = preparedStatement.executeQuery();
	       						
	       						while(resultSet.next())
	       						{

	       							
	       		       				CustomerAccountDetailsDAO accountDetailsDAO = new CustomerAccountDetailsDAO();
	       		       				
	       		       			Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(2)); 
	    	       				
	    	       			
	       		       				
	       		       				accountDetailsDAO.setBillNumber(resultSet.getString(1));
	       		       				accountDetailsDAO.setDate(date1);
	       		       				accountDetailsDAO.setBillAmount(df.format(resultSet.getFloat(4)));
	       		       				accountDetailsDAO.setChalanNumber(resultSet.getString(8));
	       		       				accountDetailsDAO.setComments(resultSet.getString(3));
	       		       				accountDetailsDAO.setBilledBy(resultSet.getString(7));
	       		       				accountDetailsDAO.setBillType(resultSet.getString(9));
	       		       			    accountDetailsDAO.setOriginateSource("CRUSHER");
	       		       			
	       		    				accountDetailsDAO.setVehicleNumber(vehicleList.get(resultSet.getString(10)));
	       		        		    accountDetailsDAO.setTransportationCharges(resultSet.getFloat(11));
	       		        		 totaltrAmount = totaltrAmount + resultSet.getFloat(11);
	       		        		 
	       		        		accountDetailsDAO.setPumpAmount("0");
	   		        		    accountDetailsDAO.setLabourAmount("0");

	   		        		   
	       		       			try
		       					{
			       					floatTotalAmt = Float.parseFloat(resultSet.getString(4));
			           				floatAmtReceived = Float.parseFloat(resultSet.getString(5));
			           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
			           				
			           				if(floatBalanceAmt > 0)
			           				{
			           					accountDetailsDAO.setBalanceAmount(""+floatBalanceAmt); 
			           					accountDetailsDAO.setAmountPaid(resultSet.getFloat(5));
			           				}
			           				else
			           				{
			           					accountDetailsDAO.setAmountPaid(resultSet.getFloat(4));
			           					accountDetailsDAO.setBalanceAmount("0.0"); 
			           				}
			           				
		       					}catch(NumberFormatException nfe)
		       					{
		       						result = "error";
		       						addActionError(this.getText("message.error.errorWhileFormattingWhileCalculatingBalanceAmount")+nfe.getMessage());
		       					}
	       		       				     
	       		       			
	       		   		  
	           		       	
	               						
	               						
	       		       				customerAccountDetailsList.add(accountDetailsDAO);
	       						}
	       						
	       						
		       			}

	       						if(resultSet != null)
	       		       			{
	       		       				resultSet.close();
	       		       				resultSet = null;
	       		       			}
	       		       			
	       		       			if(preparedStatement != null)
	       	       				{
	       	       					preparedStatement.close();
	       	       					preparedStatement = null;
	       	       				}
	       		       			
	       		       			//RMC Billing Info Addition
	       		       		if(this.getCrusherAccount().equals("ALL") || this.getCrusherAccount().equals("RMC"))
	    	       			{
	   		       			sql = "SELECT "
	   		       					+ "bill_number,"
	   		       					+ "DATE_FORMAT(bill_date, '%d/%m/%Y'),"
	   		       					+ "comments,"	           					
	   	           					+ "bill_total_amount,"
	   	           					+ "bill_amount_received,"
	   	           					+ "amount_return,"
	   	           					+ "billed_by,"
	   	           					+ "chalan_number,"
	   	           					+ "bill_type,"
	   	           					+ "vehicle_id,"
	   	           					+ "transport_charges,"
	       	           				+ "pumpAmount,"
		           					+ "labourAmount "
	   	           					+ "FROM "
	   	           					+ "crusher_rmc_billinfo "
	   	           					+ "WHERE "		           					
	   	           					+ "customer_id = ? "
	   	           					+ "AND "
	   	           					+ "(bill_date between "
	   			   					+ "STR_TO_DATE(?, '%d-%m-%Y') "
	   			   					+ "AND "
	   			   					+ "STR_TO_DATE(?, '%d-%m-%Y'))"
	   			   				    + "AND "
			   					    + "crusher_id = ? "
			   					    + "AND "
			   					    + "crusher_code = ? ";
	   		       			
	   	       						preparedStatement = connection.prepareStatement(sql);
	   	       						preparedStatement.setString(1, custId);
	   	       		       			preparedStatement.setString(2, this.getFromDate());
	   	       		       			preparedStatement.setString(3, this.getToDate());
	   	       		            	preparedStatement.setString(4, crusherId);
	   		       			        preparedStatement.setString(5, crusherCode);
	   		       			
	       	       						resultSet = preparedStatement.executeQuery();
	       	       						
	       	       						
	       	       						while(resultSet.next())
	       	       						{
	       	       							
	       	       		       				CustomerAccountDetailsDAO accountDetailsDAO = new CustomerAccountDetailsDAO();
	       	       		       				
	       	       		       				Date date1=new SimpleDateFormat("dd/MM/yyyy").parse(resultSet.getString(2)); 
	       	    	       				
	       	    	       			
	       	       		       				
	       	       		       				accountDetailsDAO.setBillNumber(resultSet.getString(1));
	       	       		       				accountDetailsDAO.setDate(date1);
	       	       		       				accountDetailsDAO.setBillAmount(df.format(resultSet.getFloat(4)));
	       	       		       				accountDetailsDAO.setChalanNumber(resultSet.getString(8));
	       	       		       				accountDetailsDAO.setComments(resultSet.getString(3));
	       	       		       				accountDetailsDAO.setBilledBy(resultSet.getString(7));
	       	       		       				accountDetailsDAO.setBillType(resultSet.getString(9));
	       	       		       				accountDetailsDAO.setOriginateSource("RMC");
	       	       		       		        accountDetailsDAO.setVehicleNumber(vehicleList.get(resultSet.getString(10)));
	       	       		       		        accountDetailsDAO.setTransportationCharges(resultSet.getFloat(11));
	       	       		       		        accountDetailsDAO.setPumpAmount(resultSet.getString(12));
		       		       		            accountDetailsDAO.setLabourAmount(resultSet.getString(13));
		       		       		
		       		       		        
		       		       		        totalPumpAmtAllTheTime = totalPumpAmtAllTheTime + resultSet.getFloat(12);
			        		            totalLaborAmtAllTheTime = totalLaborAmtAllTheTime + resultSet.getFloat(13);
			        		        
	       	       		       		  totaltrAmount = totaltrAmount + resultSet.getFloat(11);
	            		        		
	       	       		       			try
	       		       					{
	       			       					floatTotalAmt = Float.parseFloat(resultSet.getString(4));
	       			           				floatAmtReceived = Float.parseFloat(resultSet.getString(5));
	       			           				floatBalanceAmt = floatTotalAmt - floatAmtReceived;
	       			           				
	       			           				if(floatBalanceAmt > 0)
	       			           				{
	       			           					accountDetailsDAO.setBalanceAmount(""+floatBalanceAmt); 
	       			           					accountDetailsDAO.setAmountPaid(resultSet.getFloat(5));
	       			           				}
	       			           				else
	       			           				{
	       			           					accountDetailsDAO.setAmountPaid(resultSet.getFloat(4));
	       			           					accountDetailsDAO.setBalanceAmount("0.0"); 
	       			           				}
	       			           				
	       		       					}catch(NumberFormatException nfe)
	       		       					{
	       		       						result = "error";
	       		       						addActionError(this.getText("message.error.errorWhileFormattingWhileCalculatingBalanceAmount")+nfe.getMessage());
	       		       					}
	       	       		       				       		       				
	       	       		       				customerAccountDetailsList.add(accountDetailsDAO);
	       	       						}
	           				
	    	       			}
	       	       						this.setTotalTrChargesAllTheTime(totaltrAmount);
	       						
	       						
	       						float totalOutSAmtBeforeDate = Float.parseFloat(this.getTotalOutStandingAmountBeforeDate());
							
	       						float dueAmt = this.getCustOpeningBalnce()+totalOutSAmtBeforeDate;
	       						
	       					 for(CustomerAccountDetailsDAO dao : customerAccountDetailsList)
	       					 {
	       						 
	       						 
	       						
	       						
	       							
		       						 try
		       						 {
		       							 float billAmount = Float.parseFloat(dao.getBillAmount());
		       							 float paymentReceived = dao.getAmountPaid();
		       							 
		       							this.setTotalBillAmountBetweenDates(this.getTotalBillAmountBetweenDates()+billAmount);
		       							this.setTotalAmountPaidBetweenDates(this.getTotalAmountPaidBetweenDates() + paymentReceived);
		       							
		       						 }
		       						 catch(NumberFormatException nfe)
		       						 {
		       							 nfe.printStackTrace();
		       							 result = "error";
		       							 addActionError(this.getText("message.error.errorWhileParsing") +" 3 !");
		       						 }
	       						 
		       						 
		       						 
		       					
		       						if(this.getCrusherAccount().equals("ALL") || this.getCrusherAccount().equals("CRUSHER"))
		       		       			{	
		           		       		
		       		       		sql = "SELECT "
	        	       					+ "trip_end_to "
	        	       					+ "FROM "
	                   					+ "crusher_vehicle_trip_master "
	                   					+ "WHERE "		           					
	                   					+ "bill_number = ? "
	                   					+ "AND "
	        		   					+ "crusher_id = ? "
	        		   					+ "AND "
	        		   					+ "crusher_code = ? ";
	        					       
	       		       			
	        	       			
	               						preparedStatement = connection.prepareStatement(sql);
	               						preparedStatement.setString(1, dao.getBillNumber());
	               		       			preparedStatement.setString(2, crusherId);
	               		       			preparedStatement.setString(3, crusherCode);
	       		       				
		               						resultSet = preparedStatement.executeQuery();
		               						
		               						while(resultSet.next())
		               						{
		               							dao.setTripTo(resultSet.getString(1));
		               							
		               							
		               							
		               						}
		       		       			}
		               						if(resultSet != null)
		               						{
		               							try {
		               								resultSet.close(); resultSet = null;
		               							} catch (SQLException e) {
		               								
		               							}
		               						}
		               		    			if(preparedStatement != null)
		               		    			{
		               		    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
		               		    			}
		               		    			if(this.getCrusherAccount().equals("ALL") || this.getCrusherAccount().equals("RMC"))
		    	       		       			{
		               						
		    	       		       			sql = "SELECT "
		    	        	       					+ "trip_to "
		    	        	       					+ "FROM "
		    	                   					+ "crusher_rmc_vehicle_trip_master "
		    	                   					+ "WHERE "		           					
		    	                   					+ "bill_number = ? "
		    	                   					+ "AND "
		    	        		   					+ "crusher_id = ? "
		    	        		   					+ "AND "
		    	        		   					+ "crusher_code = ? ";
		    	        					       
		    	        					 
		    	        	       			
		    	               						preparedStatement = connection.prepareStatement(sql);
		    	               						preparedStatement.setString(1, dao.getBillNumber());
		    	               		       			preparedStatement.setString(2, crusherId);
		    	               		       			preparedStatement.setString(3, crusherCode);
		    	       		       			
		    	               						resultSet = preparedStatement.executeQuery();
		    	               						
		    	               						while(resultSet.next())
		    	               						{
		    	               							dao.setTripTo(resultSet.getString(1));
		    	               							
		    	               							
		    	               							
		    	               						}
		    	               						
		    	       		       			}
		               						
	       						 
	       					 }
	       					
	       					
	       					 this.setTotalOutStandingAmountBetweenDates((totalBillAmountBeforeDate+this.getTotalBillAmountBetweenDates()) - (floatTotalAmtPaidBeforeDate+this.getTotalAmountPaidBetweenDates()));
	       					 
	       					this.setTotalOutStandingAmountBetweenDates( this.getTotalOutStandingAmountBetweenDates() + +this.getCustOpeningBalnce());
	       					 setTotalAmountPaidAllTheTime(""+(floatTotalAmtPaidBeforeDate+this.getTotalAmountPaidBetweenDates()));
	       					 setTotalOutStandingAmountAllTheTime(""+this.getTotalOutStandingAmountBetweenDates());
	       					 
	       					 
	       					 
	       					
	    					 
	    					 	//System.out.println(dateList);
	    					 	
	    						// System.out.println(sortedDateList);
	    					 
	    						 
	    						 Collections.sort(customerAccountDetailsList, new Comparator<CustomerAccountDetailsDAO>() {
	    							  public int compare(CustomerAccountDetailsDAO o1, CustomerAccountDetailsDAO o2) {
	    							      if (o1.getDate() == null || o2.getDate() == null)
	    							        return 0;
	    							      return o1.getDate().compareTo(o2.getDate());
	    							  }
	    							});
	    					
	    						  
	    						  float totalQuantity6mm = 0.0F;
	    						  float totalQuantity10mm = 0.0F;
	    						  float totalQuantity20mm = 0.0F;
	    						  float totalQuantity40mm = 0.0F;
	    						  float totalQuantityCS = 0.0F;
	    						  float totalQuantityPS = 0.0F;
	    						  float totalQuantityPowder = 0.0F;
	    						  float totalQuantityDust = 0.0F;
	    						  float totalQuantityOther = 0.0F;
	    						  float totalRoyalty = 0.0F;
	    						  float totalMaterial = 0.0F;
	    						  float totalMaterialCost = 0.0F;
	    						  totalTaxableAmtAllTheTime = 0.0f;
	    						  totalCgstAllTheTime = 0.0f;
	    						  totalSgstAllTheTime = 0.0f;
	    						  
	    						 for(CustomerAccountDetailsDAO dao :customerAccountDetailsList)
	    						 {
	    							 
	    							  String getProductInfoSQL = "";
	    							  PreparedStatement getProductInfoPSMT = null;
	    							  ResultSet getProductInfoRS = null;
	    							 
	    							  if(dao.getOriginateSource() == null)
	    							  {
	    								  
	    								  
		    	       		       			getProductInfoSQL = "SELECT "
		    								  		+ "product_name,"
		    								  		+ "product_sale_amount_after_discount,"
		    								  		+ "sale_quantity,"
		    								  		+ "sales_rate,"
		    								  		+ "product_cgst_amount,"
		    								  		+ "product_sgst_amount,"
		    								  		+ "sales_unit,"
		    								  		+ "product_gross_amount,"
		    								  		+ "royalty "
		    								  		+ "product_sale_amount_after_discount "
		    								  		+ "FROM "
		    								  		+ "crusher_bill_product_info "
		    								  		+ "WHERE "
		    								  		+ "bill_number = ? "
		    								  		+ "AND "
		    								  		+ "bill_type = ? "
		    								  		+ "AND "
		    								  		+ "crusher_id = ? "
		    								  		+ "AND "
		    								  		+ "crusher_code = ? ";
		    	       		       			
	    							  }else {
	    							  if(dao.getOriginateSource().equals("CRUSHER"))
	    							  {
	    								  
	    								 
		    	       		       				
		    	       		       			 getProductInfoSQL = "SELECT "
		     								  		+ "product_name,"
		     								  		+ "product_sale_amount_after_discount,"
		     								  		+ "sale_quantity,"
		     								  		+ "sales_rate,"
		     								  		+ "product_cgst_amount,"
		     								  		+ "product_sgst_amount,"
		     								  		+ "sales_unit,"
		     								  		+ "product_gross_amount,"
		    								  		+ "royalty "
		     								  		+ "FROM "
		     								  		+ "crusher_bill_product_info "
		     								  		+ "WHERE "
		     								  		+ "bill_number = ? "
		     								  		+ "AND "
		    								  		+ "bill_type = ? "
		    								  		+ "AND "
		     								  		+ "crusher_id = ? "
		     								  		+ "AND "
		     								  		+ "crusher_code = ? ";
		    	       		       			
	    							  }
	    							  if(dao.getOriginateSource().equals("RMC"))
	    							  {
	    								  
	    								  
		    	       		       			 getProductInfoSQL = "SELECT "
			    								  		+ "product_name,"
			    								  		+ "product_amt_after_discount,"
			    								  		+ "quanity,"
			    								  		+ "sales_rate,"
			    								  		+ "cgst,"
			    								  		+ "sgst,"
			    								  		+ "sales_unit,"
			    								  		+ "gross_amount "
			    								  		+ "FROM "
			    								  		+ "crusher_rmc_productbillinfo "
			    								  		+ "WHERE "
			    								  		+ "bill_number = ? "
			    								  		+ "AND "
	    	    								  		+ "bill_type = ? "
	    	    								  		+ "AND "
			    								  		+ "crusher_id = ? "
			    								  		+ "AND "
			    								  		+ "crusher_code = ? ";
		    	       		       			
	    							  }
	    							  }
	    							  
	    								  getProductInfoPSMT = connection.prepareStatement(getProductInfoSQL);
	    								  
	    								  getProductInfoPSMT.setString(1, dao.getBillNumber());
	    								  getProductInfoPSMT.setString(2, dao.getBillType());
	    								  getProductInfoPSMT.setString(3, crusherId);
	    		        				 getProductInfoPSMT.setString(4, crusherCode);

	    								  
	    								  getProductInfoRS = getProductInfoPSMT.executeQuery();
	    							 
	    								  
	    								  
	    								  StringBuilder productNames = new StringBuilder();
	    								  StringBuilder quantities = new StringBuilder();
	    								  
	    								 
	    								  
	    								  while(getProductInfoRS.next())
	    								  {
	    									  
	    									  String productName = getProductInfoRS.getString(1);
	    									  float quantity = getProductInfoRS.getFloat(3);
	    									  String salesUnit = getProductInfoRS.getString(7);

	    									  boolean found = false;
	    									  for (Map<String, Object> productInfo : productQuantityList) {
	    									      if (productInfo.get("productName").equals(productName) &&
	    									          productInfo.get("salesUnit").equals(salesUnit)) {
	    									          
	    									          float existingQuantity = (float) productInfo.get("quantity");
	    									          productInfo.put("quantity", existingQuantity + quantity);
	    									          found = true;
	    									          break;
	    									      }
	    									  }

	    									  if (!found) {
	    									      Map<String, Object> newProduct = new LinkedHashMap<>();
	    									      newProduct.put("productName", productName);
	    									      newProduct.put("salesUnit", salesUnit);
	    									      newProduct.put("quantity", quantity);
	    									      productQuantityList.add(newProduct);
	    									  }

	    									
	     
	    									  if (productNames.length() > 0) {
	    									        productNames.append(" / ");
	    									        quantities.append(" / ");
	    									    }
	    									  
	    									  productNames.append(getProductInfoRS.getString(1));  
	    									    quantities.append(getProductInfoRS.getString(3));    

	    									    dao.setItemNameAll(productNames.toString());  
	    									    dao.setItemQuantityAll(quantities.toString());
	    									    
	    									   
	    									    
	    									    
	    									  dao.setItemName(getProductInfoRS.getString(1));
	    									  dao.setMaterialCost(getProductInfoRS.getFloat(2));
											  dao.setItemQuantity(getProductInfoRS.getString(3));
											  dao.setItemRate(getProductInfoRS.getString(4));
											 dao.setCgst(getProductInfoRS.getFloat(5));
											 dao.setSgst(getProductInfoRS.getFloat(6));
											 dao.setSalesUnit(getProductInfoRS.getString(7));
											 dao.setTaxableAmt(getProductInfoRS.getString(8));

											 
											 totalCgstAllTheTime = totalCgstAllTheTime + getProductInfoRS.getFloat(5);
											  totalSgstAllTheTime = totalSgstAllTheTime + getProductInfoRS.getFloat(6);
											  totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime + getProductInfoRS.getFloat(8);
											  
											 
											totalMaterial = totalMaterial + getProductInfoRS.getFloat(3);
	    									  
											 
											 
	    									  totalMaterialCost = totalMaterialCost + Float.parseFloat(getProductInfoRS.getString(2));
	    									  if(dao.getSixMm()== null || dao.getSixMm().equals("") || dao.getSixMm().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("6"))
	    										  {
	    											  dao.setSixMm(getProductInfoRS.getString(3));
	    											  
	    											  totalQuantity6mm = totalQuantity6mm + Float.parseFloat(getProductInfoRS.getString(3));
	    											  
	    										  }else
	    										  {
	    											  dao.setSixMm("-");
	    										  }
	    									  }
	    									  
	    									  
	    									  if(dao.getTenMm() == null || dao.getTenMm().equals("") || dao.getTenMm().equals("-"))
	    									  {
	    											  
	    										  if(getProductInfoRS.getString(1).contains("10"))
	    										  {
	    											  dao.setTenMm(getProductInfoRS.getString(3));
	    											 
	    											 totalQuantity10mm = totalQuantity10mm + Float.parseFloat(getProductInfoRS.getString(3));
	    	    										
	    										  }
	    										  else
	    										  {
	    											  dao.setTenMm("-");
	    										  }
	    									  }
	    									  
	    									  if(dao.getTewntyMm() == null || dao.getTewntyMm().equals("") || dao.getTewntyMm().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("20"))
	    										  {
	    											  dao.setTewntyMm(getProductInfoRS.getString(3));
	    											  totalQuantity20mm = totalQuantity20mm + Float.parseFloat(getProductInfoRS.getString(3));
	      	    									
	    											  
	    										  }
	    										  else
	    										  {
	    											  dao.setTewntyMm("-");
	    										  }
	    									  }
	    									  
	    									  if(dao.getFourtyMm() == null || dao.getFourtyMm().equals("") || dao.getFourtyMm().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("40"))
	    										  {
	    											  dao.setFourtyMm(getProductInfoRS.getString(3));
	    											  totalQuantity40mm = totalQuantity40mm + Float.parseFloat(getProductInfoRS.getString(3));
	      	    									
	    											 // this.setMaterial25MMTotal(this.getMaterial25MMTotal()+Float.parseFloat(getProductInfoRS.getString(3)));
	    											  
	    										  }else
	    										  {
	    											  dao.setFourtyMm("-");  
	    										  }
	    										  
	    									  }
	    									  if(dao.getCrushSand() == null || dao.getCrushSand().equals("") || dao.getCrushSand().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("CRUSH") || getProductInfoRS.getString(1).contains("VSI"))
	    										  {
	    											  dao.setCrushSand(getProductInfoRS.getString(3));
	    											  totalQuantityCS = totalQuantityCS + Float.parseFloat(getProductInfoRS.getString(3));
	      	    									
	    											  
	    										  }else
	    										  {
	    											  dao.setCrushSand("-");
	    										  }
	    									  }
	    									  
	    									  if(dao.getOtherMaterial() == null || dao.getOtherMaterial().equals("") || dao.getOtherMaterial().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("OTHER"))
	    										  {
	    											  dao.setOtherMaterial(getProductInfoRS.getString(3));
	    											  totalQuantityOther = totalQuantityOther + Float.parseFloat(getProductInfoRS.getString(3));
	        	    								  
	    										  }
	    										  else
	    										  {
	    											  dao.setOtherMaterial("-");
	    										  }
	    									  }
	    									  
	    									  if(dao.getPlasterSand() == null || dao.getPlasterSand().equals("") || dao.getPlasterSand().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("PLASTER SAND"))
	    										  {
	    											  dao.setPlasterSand(getProductInfoRS.getString(3));
	    											  totalQuantityPS = totalQuantityPS + Float.parseFloat(getProductInfoRS.getString(3));
	        	    								  
	    										  }
	    										  else
	    										  {
	    											  dao.setPlasterSand("-");
	    										  }
	    									  }
	    									  
	    									  if(dao.getPowder() == null || dao.getPowder().equals("") || dao.getPowder().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("POWDER"))
	    										  {
	    											  dao.setPowder(getProductInfoRS.getString(3));
	    											  totalQuantityPowder = totalQuantityPowder + Float.parseFloat(getProductInfoRS.getString(3));
	        	    								  
	    										  }
	    										  else
	    										  {
	    											  dao.setPowder("-");
	    										  }
	    									  }
	    									  
	    									  
	    									  if(dao.getDust() == null || dao.getDust().equals("") || dao.getDust().equals("-"))
	    									  {
	    										  if(getProductInfoRS.getString(1).contains("DUST"))
	    										  {
	    											  dao.setDust(getProductInfoRS.getString(3));
	    											  totalQuantityDust = totalQuantityDust + Float.parseFloat(getProductInfoRS.getString(3));
	        	    								  
	    										  }
	    										  else
	    										  {
	    											  dao.setDust("-");
	    										  }
	    									  }
	    									  
	    									  
	    									  if (dao.getOriginateSource() == null || dao.getOriginateSource().equals("CRUSHER")) 
	    									  {

	    									  totalRoyalty = totalRoyalty + getProductInfoRS.getFloat("royalty");
	    									  
	    									 	 
	    									  float royalty = getProductInfoRS.getFloat("royalty") ;
	    									  
	    									  
	    									  dao.setRoyalty(royalty + dao.getRoyalty());
	    									  
	    											  
	    									 
	    									  }	
	    									  
	    									   
	    									  
	    									  
	    								  }
	    								 
	    								 
	    								  this.setMaterialTotal((Math.round(totalMaterial)/100.0f)*100.0f);
	    								  this.setTotalMaterialCostAllTheTime(totalMaterialCost);
	    	    						
	    									  this.setTotalRoyaltyAllTheTime(totalRoyalty);
										  
	    								  
	    								  if(getProductInfoRS != null)
	    								  {
	    									  getProductInfoRS.close();
	    									  getProductInfoRS = null;
	    								  }
	    								  
	    								  if(getProductInfoPSMT != null)
	    								  {
	    									  getProductInfoPSMT.close();
	    									  getProductInfoPSMT = null;
	    								  }
	    								 
	    								  
	    							 DateFormat dateFormat = new SimpleDateFormat("dd-MMM-yy");  
	    							 Date d = dao.getDate();
	    							 dao.setDateAsString(dateFormat.format(d));
	    							 
	    						 }
	    						
	    						 
	    						 setTotalBillAmountAllTheTime(""+(totalBillAmountBeforeDate+this.getTotalBillAmountBetweenDates() - totalRoyalty));
	           					 
	    						 
	    						 
	    						 this.setTotal6mm(""+totalQuantity6mm);
	    						 this.setTotal10mm(""+totalQuantity10mm);
	    						 this.setTotal20mm(""+totalQuantity20mm);
	    						 this.setTotal40mm(""+totalQuantity40mm);
	    						 this.setTotalCSand(""+totalQuantityCS);
	    						 this.setTotalDust(""+totalQuantityDust);
	    						 this.setTotalOther(""+totalQuantityOther);
	    						 this.setTotalPS(""+totalQuantityPS);
	    						 this.setTotalPowder(""+totalQuantityPowder);
	       		
	       					
	       					 for(CustomerAccountDetailsDAO dao : customerAccountDetailsList)
	       					 {
	       						 
								  if(dao.getChalanNumber().equals("RECEIVED"))
								  {
									 
									  dueAmt = dueAmt-dao.getAmountPaid();
									
									  dao.setDueAmount(""+dueAmt);
									 
								  }
								  else
								  {								
									
									  dueAmt = dueAmt+Float.parseFloat(dao.getBalanceAmount());
									
									  dao.setDueAmount(""+dueAmt);
								  }
	       					 }
       				
       					
       					
       						@SuppressWarnings("unchecked")
        					String crusherName = (String) this.getSessionMap().get("crushernameenglish");
        				    
       						if(this.getDownloadType().equals("pdf"))
       						{
       							
       						
           					 String path=	request.getSession().getServletContext().getRealPath("/images/");
        			    			PDDocument document = new PDDocument(); 
        							PDPage page = null;
        							
        							SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-Y");
        							Date date = new Date();
        							
        							String dateToday = sdf.format(date); 
        							page = 	new PDPage(new PDRectangle(830,580));
        							
        							 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
        							 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
        							 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
        							
        						        document.addPage(page);
        						         PDPageContentStream contentStream = new PDPageContentStream(document, page);
        						         int pageCount = 1;
        					    			 
        						         Table header;
        						         Table productTable = null;
   							          
        					    			
        					    			  TableBuilder tableHeaderBuilder = Table.builder()
        								                .addColumnsOfWidth(830)				                
        								                .font(HELVETICA)
        								                .borderColor(Color.BLACK)
        								                .horizontalAlignment(CENTER);
        							         
        							          Row headerName = Row.builder()     
        								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
        								                .backgroundColor(WHITE)
        								                .textColor(Color.BLACK)
        								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
        								                .horizontalAlignment(CENTER)
        								                .build();
        							          
        							          
        							          Row info1 = Row.builder()
        								                .add(TextCell.builder().text("Customer Account Statement").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
        								                .backgroundColor(WHITE)
        								                .textColor(Color.BLACK)
        								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
        								                .horizontalAlignment(CENTER)
        								                .build();
        							          
        							          Row info2 = Row.builder()
        								                .add(TextCell.builder().text("Name :- "+nameOfCustomer+"   Address:- "+custAddress+"  (Opening Bal:"+this.getCustOpeningBalnce()+")").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
        								                .backgroundColor(WHITE)
        								                .textColor(Color.BLACK)
        								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
        								                .horizontalAlignment(CENTER)
        								                .build();
        							          
        							          Row info3 = Row.builder()
      								                .add(TextCell.builder().text("From Date: "
      								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
      								                .backgroundColor(WHITE)
      								                .textColor(Color.BLACK)
      								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
      								                .horizontalAlignment(CENTER)
      								                .build();
        							          
        							       
        							          tableHeaderBuilder.addRow(headerName);
        							          tableHeaderBuilder.addRow(info1);
        							          tableHeaderBuilder.addRow(info2);
        							          tableHeaderBuilder.addRow(info3);
        							          header = tableHeaderBuilder.build();
        							          
        							          
        							          
        							          Table stateMentDetails = null;
        							          TableBuilder statementDetailsBuilder = null;
        							          Row tableDetailsHeader = null;
        							          
        							            
        							          if(this.getType().equals("Type 1"))
        							          {
        							        	  
        							        	  
        							          
        							          
        							          if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
     							        	      statementDetailsBuilder = Table.builder()
            							        		  .addColumnsOfWidth(45,50,70,32,32,32,32,32,32,32,32,37,57,57,45,57,65)				                
        	    	    								     .font(HELVETICA)
            								                .borderWidth(0.5F)
            								                .borderColor(Color.BLACK)
            								                .horizontalAlignment(CENTER);
        							          }else {
        							        	  
        							        	  statementDetailsBuilder = Table.builder()
            							        		  .addColumnsOfWidth(50,50,70,35,35,35,35,35,35,35,35,35,60,60,60,70)				                
        	    	    								      .font(HELVETICA)
            								                .borderWidth(0.5F)
            								                .borderColor(Color.BLACK)
            								                .horizontalAlignment(CENTER);
            							          
        							          }
        							         
        							          
        							          if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
        							        	   
            							           tableDetailsHeader = Row.builder()
            							        		  
            							        		  
            							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
            								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("6MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("10MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
            								                .add(TextCell.builder().text("20MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("40MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("CSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("PSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("POW").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("DUST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("GSB").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                								                  
            								                .backgroundColor(Color.LIGHT_GRAY)
            								                .textColor(Color.BLACK)
            								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
            								                .horizontalAlignment(CENTER)
            								                .build();
            							          
        							          }else {
        							        	  
        							        	  tableDetailsHeader = Row.builder()
            							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
            								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("6MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("10MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
            								                .add(TextCell.builder().text("20MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("40MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
            								                .add(TextCell.builder().text("CSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("PSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("POW").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("DUST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("GSB").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
            								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                								                  
            								                .backgroundColor(Color.LIGHT_GRAY)
            								                .textColor(Color.BLACK)
            								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
            								                .horizontalAlignment(CENTER)
            								                .build();
        							        	  
        							          }
        							          
            							          statementDetailsBuilder.addRow(tableDetailsHeader);
            							          	
        							          }else {
        							        	  
        							        	  if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
        							        		  
        							        		  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
        							        			  {
        							        			  statementDetailsBuilder = Table.builder()
               							        	    		 .addColumnsOfWidth(45,45,60,70,45,40,45,35,35,35,35,35,35,35,40,40,40,40,50)				                
                 	    	    								     .font(HELVETICA)
                      								                .borderWidth(0.5F)
                      								                .borderColor(Color.BLACK)
                      								                .horizontalAlignment(CENTER);  
        							        			  }else {
        							        				  statementDetailsBuilder = Table.builder()
        							        						  .addColumnsOfWidth(45,50,60,70,40,40,50,40,40,40,50,40,40,40,50,50,60)				                
                     	    	    								     .font(HELVETICA)
                         								                .borderWidth(0.5F)
                         								                .borderColor(Color.BLACK)
                         								                .horizontalAlignment(CENTER); 
        							        			  }
         							        	           
            							          }else {
            							        	  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
    							        			  {
            							        		  statementDetailsBuilder = Table.builder()
                							        			  .addColumnsOfWidth(45,45,60,70,45,45,45,35,35,35,35,35,35,35,35,50,50,60)				                
                	    	    								      .font(HELVETICA)
                    								                .borderWidth(0.5F)
                    								                .borderColor(Color.BLACK)
                    								                .horizontalAlignment(CENTER);
    							        			  }else {
    							        				  statementDetailsBuilder = Table.builder()
                							        			  .addColumnsOfWidth(45,50,60,70,50,50,50,40,40,40,40,40,40,40,50,80)				                
                	    	    								      .font(HELVETICA)
                    								                .borderWidth(0.5F)
                    								                .borderColor(Color.BLACK)
                    								                .horizontalAlignment(CENTER);
    							        			  }
            							        	  
                							          
            							          }
        							        	 
            							          
            							          if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
            							        	   
                							           	  
                							        		   if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
 		        							        		  {
                							        			   tableDetailsHeader = Row.builder()
                                      							        	
                    							        				   
                             							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                             								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                             								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								               .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                           								                   .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                             								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                             								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                             								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                             								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                             								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                                 								                  
                             								                .backgroundColor(Color.LIGHT_GRAY)
                             								                .textColor(Color.BLACK)
                             								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                             								                .horizontalAlignment(CENTER)
                             								                .build();
 		        							        		  }else {
 		        							        			 tableDetailsHeader = Row.builder()
 	                               							        	
 	                							        				   
 		                  							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 		                  								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
 		                  								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
 		                  								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 		                  								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
 		                  								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
 		                  								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
 		                  								                .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	                     								                .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	                      								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	                      								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
 		                  								                .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
 		                  								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
 		                  								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
 		                  								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
 		                  								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
 		                  								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
 		                      								                  
 		                  								                .backgroundColor(Color.LIGHT_GRAY)
 		                  								                .textColor(Color.BLACK)
 		                  								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
 		                  								                .horizontalAlignment(CENTER)
 		                  								                .build();
 		        							        		  }
                							        		   
                							          
            							          }else {
            							        	  
            							        	  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
	        							        		  {
            							        		  tableDetailsHeader = Row.builder()
                  							        			.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                    								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                    								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
      	              								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
		      	              								        .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
		            								                .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
		             								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
		             								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
      	          								                    .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                								                    .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                								                    .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                								                    .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                        								                  
                      								                .backgroundColor(Color.LIGHT_GRAY)
                      								                .textColor(Color.BLACK)
                      								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                      								                .horizontalAlignment(CENTER)
                      								                .build();
	        							        		  }else {
	        							        			  tableDetailsHeader = Row.builder()
	                  							        			.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	                    								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	                    								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	                    								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	                    								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	                    								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	      	              								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
			      	              								        .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
		                								                .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
		                 								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
		                 								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	      	          								                    .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	                    								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	                    								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	                    								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	                								                    .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
	                        								                  
	                      								                .backgroundColor(Color.LIGHT_GRAY)
	                      								                .textColor(Color.BLACK)
	                      								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
	                      								                .horizontalAlignment(CENTER)
	                      								                .build();
	        							        		  }
            							        	  
            							        	  
            							          }
            							          
                							          statementDetailsBuilder.addRow(tableDetailsHeader);
        							        	  
        							        	  
        							        	  
        							          }
        							          
        							          int size = customerAccountDetailsList.size();
        							          
        							          float startY = page.getMediaBox().getHeight() - PADDING20;
        							          float currentY = startY;
        							          TableDrawer.builder()
        						                .contentStream(contentStream)
        						                .table(header)
        						                .startX(PADDING30)
        						                .startY(startY)
        						                .build()
        						                .draw();

        						        	  for(int s=0;s<size;s++)
        						        	  {
        						        		  if(currentY < 150)
        						        		  {
        						        			  pageCount++;
        						        			  stateMentDetails = statementDetailsBuilder.build();
        						        			  TableDrawer.builder()
        								                .contentStream(contentStream)
        								                .table(stateMentDetails)
        								                .startX(PADDING10)
        								                .startY(startY-70)
        								                .build()
        								                .draw();
        						        			  
        						        			  contentStream.close();
        						        			  
        						        			  header = null;
        						        			  
        						        			  

        	    					    			  tableHeaderBuilder = Table.builder()
        	    								                .addColumnsOfWidth(830)				                
        	    								                .font(HELVETICA)
        	    								                .borderColor(Color.BLACK)
        	    								                .horizontalAlignment(CENTER);
        	    							         
        	    							          headerName = Row.builder()
        	    								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
        	    								                .backgroundColor(WHITE)
        	    								                .textColor(Color.BLACK)
        	    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
        	    								                .horizontalAlignment(CENTER)
        	    								                .build();
        	    							          
        	    							           info1 = Row.builder()
        	    								                .add(TextCell.builder().text("Customer Account Statement").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
        	    								                .backgroundColor(WHITE)
        	    								                .textColor(Color.BLACK)
        	    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
        	    								                .horizontalAlignment(CENTER)
        	    								                .build();
        	    							          
        	    							           info2 = Row.builder()
        	    								                .add(TextCell.builder().text("Name :- "+nameOfCustomer+"   Address:- "+custAddress).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
        	    								                .backgroundColor(WHITE)
        	    								                .textColor(Color.BLACK)
        	    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
        	    								                .horizontalAlignment(CENTER)
        	    								                .build();
        	    							          
        	    							           info3 = Row.builder()
        	  								                .add(TextCell.builder().text("From Date: "
        	  								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
        	  								                .backgroundColor(WHITE)
        	  								                .textColor(Color.BLACK)
        	  								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
        	  								                .horizontalAlignment(CENTER)
        	  								                .build();
        	    							          
        	    							       
        	    							          tableHeaderBuilder.addRow(headerName);
        	    							          tableHeaderBuilder.addRow(info1);
        	    							          tableHeaderBuilder.addRow(info2);
        	    							          tableHeaderBuilder.addRow(info3);
        	    							          header = tableHeaderBuilder.build();
        	    							          
        	    							          
        	    							          
        	    							          
        	    							         
                							          
                							          if(this.getType().equals("Type 1"))
                							          {
                							        	  
                							        	  
                							          
                							          
                							          if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
             							        	      statementDetailsBuilder = Table.builder()
                    							        		  .addColumnsOfWidth(45,50,70,32,32,32,32,32,32,32,32,37,57,57,45,57,65)				                
                	    	    								     .font(HELVETICA)
                    								                .borderWidth(0.5F)
                    								                .borderColor(Color.BLACK)
                    								                .horizontalAlignment(CENTER);
                							          }else {
                							        	  
                							        	  statementDetailsBuilder = Table.builder()
                    							        		  .addColumnsOfWidth(50,50,70,35,35,35,35,35,35,35,35,35,60,60,60,70)				                
                	    	    								      .font(HELVETICA)
                    								                .borderWidth(0.5F)
                    								                .borderColor(Color.BLACK)
                    								                .horizontalAlignment(CENTER);
                    							          
                							          }
                							         
                							          
                							          if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
                							        	   
                    							           tableDetailsHeader = Row.builder()
                    							        		  
                    							        		  
                    							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                    								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("6MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("10MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                    								                .add(TextCell.builder().text("20MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("40MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("CSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("PSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("POW").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("DUST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("GSB").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                           	    								 	.add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                        								                  
                    								                .backgroundColor(Color.LIGHT_GRAY)
                    								                .textColor(Color.BLACK)
                    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                    								                .horizontalAlignment(CENTER)
                    								                .build();
                    							          
                							          }else {
                							        	  
                							        	  tableDetailsHeader = Row.builder()
                    							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                    								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("6MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("10MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                    								                .add(TextCell.builder().text("20MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("40MM").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                    								                .add(TextCell.builder().text("CSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("PSand").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("POW").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("DUST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("GSB").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                    								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                        								                  
                    								                .backgroundColor(Color.LIGHT_GRAY)
                    								                .textColor(Color.BLACK)
                    								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                    								                .horizontalAlignment(CENTER)
                    								                .build();
                							        	  
                							          }
                							          
                    							          statementDetailsBuilder.addRow(tableDetailsHeader);
                    							          	
                							          }else {
                							        	  
                							        	  
                							        	  
                							        	  if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
                							        		  
                							        		  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
                							        			  {
                							        			  statementDetailsBuilder = Table.builder()
                       							        	    		 .addColumnsOfWidth(45,45,60,70,45,40,45,35,35,35,35,35,35,35,40,40,40,40,50)				                
                         	    	    								     .font(HELVETICA)
                              								                .borderWidth(0.5F)
                              								                .borderColor(Color.BLACK)
                              								                .horizontalAlignment(CENTER);  
                							        			  }else {
                							        				  statementDetailsBuilder = Table.builder()
                							        						  .addColumnsOfWidth(45,50,60,70,40,40,50,40,40,40,50,40,40,40,50,50,60)				                
                             	    	    								     .font(HELVETICA)
                                 								                .borderWidth(0.5F)
                                 								                .borderColor(Color.BLACK)
                                 								                .horizontalAlignment(CENTER); 
                							        			  }
                 							        	           
                    							          }else {
                    							        	  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
            							        			  {
                    							        		  statementDetailsBuilder = Table.builder()
                        							        			  .addColumnsOfWidth(45,45,60,70,45,45,45,35,35,35,35,35,35,35,35,50,50,60)				                
                        	    	    								      .font(HELVETICA)
                            								                .borderWidth(0.5F)
                            								                .borderColor(Color.BLACK)
                            								                .horizontalAlignment(CENTER);
            							        			  }else {
            							        				  statementDetailsBuilder = Table.builder()
                        							        			  .addColumnsOfWidth(45,50,60,70,50,50,50,40,40,40,40,40,40,40,50,80)				                
                        	    	    								      .font(HELVETICA)
                            								                .borderWidth(0.5F)
                            								                .borderColor(Color.BLACK)
                            								                .horizontalAlignment(CENTER);
            							        			  }
                    							        	  
                        							          
                    							          }
                							        	 
                    							         
                    							          
                    							          if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
                    							        	   
                    							        	  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
            							        			  {
                    							        		  tableDetailsHeader = Row.builder()
                            							        		  
                            							        		  
                            							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                                								                  
                            								                .backgroundColor(Color.LIGHT_GRAY)
                            								                .textColor(Color.BLACK)
                            								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                            								                .horizontalAlignment(CENTER)
                            								                .build();
            							        			  }else {
            							        				  tableDetailsHeader = Row.builder()
                            							        		  
                            							        		  
                            							        		  .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Royalty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                                								                  
                            								                .backgroundColor(Color.LIGHT_GRAY)
                            								                .textColor(Color.BLACK)
                            								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                            								                .horizontalAlignment(CENTER)
                            								                .build();
            							        			  }
                        							           
                        							          
                    							          }else {
                    							        	  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
            							        			  {
                    							        		  tableDetailsHeader = Row.builder()
                          							        			.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	      	                  								                .add(TextCell.builder().text("Pump Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	      	                								                .add(TextCell.builder().text("Labor Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
	      	                								                .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                        								                    .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                                								                  
                              								                .backgroundColor(Color.LIGHT_GRAY)
                              								                .textColor(Color.BLACK)
                              								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                              								                .horizontalAlignment(CENTER)
                              								                .build();
            							        			  }else {
            							        				  tableDetailsHeader = Row.builder()
                          							        			.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Chalan No.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Vehicle Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Product Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                            								                .add(TextCell.builder().text("Qty.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Rate").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Material Cost").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                            								                .add(TextCell.builder().text("Taxable Amt").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("CGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("SGST").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
                             								                .add(TextCell.builder().text("Tr Charges").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
      	                  								                    .add(TextCell.builder().text("Total Bill Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Amount Received").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Due Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                            								                .add(TextCell.builder().text("Address").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                        								                    .add(TextCell.builder().text("Comments").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
                                								                  
                              								                .backgroundColor(Color.LIGHT_GRAY)
                              								                .textColor(Color.BLACK)
                              								                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
                              								                .horizontalAlignment(CENTER)
                              								                .build();
            							        			  }
                    							        	  
                    							        	  
                    							          }
                    							          
                        							          statementDetailsBuilder.addRow(tableDetailsHeader);
                							        	  
                							        	  
                							        	  
                							          }
                    							          
             							          
        	    							          
        	    							      	PDPage newPage = new PDPage(new PDRectangle(830,580));
       								        	 contentStream = new PDPageContentStream(document,newPage);
       								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
       								             document.addPage( newPage );
       								             
       								             TableDrawer.builder()
       								                .contentStream(contentStream)
       								                .table(header)
       								                .startX(PADDING30)
       								                .startY(currentY)
       								                .build()
       								                .draw();
        						        		  }
        						        		  
        						        		  
        						        		  CustomerAccountDetailsDAO dao = customerAccountDetailsList.get(s);
        						        		  
        						        		
        						        		  
        						        		  if(dao.getSixMm() == null)
        						        		  {
        						        			  dao.setSixMm("");
        						        		  }
        						        		  
        						        		  if(dao.getTenMm() ==null)
        						        		  {
        						        			  dao.setTenMm("");
        						        		  }
        						        		  
        						        		  if(dao.getTewntyMm() == null)
        						        		  {
        						        			  dao.setTewntyMm("");
        						        		  }
        						        		  if(dao.getFourtyMm() ==null)
        						        		  {
        						        			  dao.setFourtyMm("");
        						        		  }
        						        		  if(dao.getDust() == null)
        						        		  {
        						        			  dao.setDust("");
        						        		  }
        						        		  if(dao.getPlasterSand() == null)
        						        		  {
        						        			  dao.setPlasterSand("");
        						        		  }
        						        		  
        						        		  if(dao.getCrushSand()== null)
        						        		  {
        						        			  dao.setCrushSand("");
        						        		  }
        						        		  
        						        		  if(dao.getPowder()== null)
        						        		  {
        						        			  dao.setPowder("");
        						        		  }
        						        		  if(dao.getOther()== null)
        						        		  {
        						        			  dao.setOther("");
        						        		  }
        						        		  
        						        		  if(this.getType().equals("Type 1"))
            							          {
        						        			  
        						        			  
            							          
        						        		  if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
        						        			  
        						        			      
            						        			  
        	        						        		Row custInfo = Row.builder()
        	        							        			  	.add(TextCell.builder().text(dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(dao.getChalanNumber().replaceAll("\t", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getSixMm()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getTenMm()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getTewntyMm()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getFourtyMm()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getCrushSand()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getPlasterSand()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			 	.add(TextCell.builder().text(""+dao.getPowder()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			 	.add(TextCell.builder().text(""+dao.getDust()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			 	.add(TextCell.builder().text(""+dao.getOther()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        	       							        		.add(TextCell.builder().text(dao.getBillAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getRoyalty()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getAmountPaid()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(dao.getDueAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        				.add(TextCell.builder().text(dao.getComments().replaceAll("\t", " ")).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	            							        		  	.backgroundColor(Color.WHITE)
        	        									                .textColor(Color.BLACK)
        	        									                .font(fontMarathi)
        	        									                .fontSize(7)				              
        	        									                .horizontalAlignment(CENTER)
        	        									                .height(25F)					                
        	        									                .build();
        	        							        	  
        	        						        			statementDetailsBuilder.addRow(custInfo);
        	        						        		  
        						        			 
        						        		  }else {
        						        			      
            						        			  
        						        				  Row  custInfo = Row.builder()
            	        						        		  
              						        		 		  	.add(TextCell.builder().text(dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(dao.getChalanNumber().replaceAll("\t", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getSixMm()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getTenMm()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getTewntyMm()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getFourtyMm()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getCrushSand()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getPlasterSand()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			 	.add(TextCell.builder().text(""+dao.getPowder()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			 	.add(TextCell.builder().text(""+dao.getDust()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			 	.add(TextCell.builder().text(""+dao.getOther()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			 	.add(TextCell.builder().text(dao.getBillAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+dao.getAmountPaid()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(dao.getDueAmount()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        				.add(TextCell.builder().text(dao.getComments().replaceAll("\t", " ")).font(fontMarathi).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        		  	.backgroundColor(Color.WHITE)
              									                .textColor(Color.BLACK)
              									                .font(fontMarathi)
              									                .fontSize(7)				              
              									                .horizontalAlignment(CENTER)
              									                .height(25F)					                
              									                .build();
              						        		 		  	statementDetailsBuilder.addRow(custInfo);
        	        						        		  
        						        		  }
        						        		  
            							          }	else {
            							        	  
            							        	  
            							        	  if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
            						        			  
            							        		  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
		        							        		  {
            							        			  Row custInfo = Row.builder()
        	        							        			  	.add(TextCell.builder().text(dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			    .add(TextCell.builder().text(""+dao.getChalanNumber().replaceAll("\t", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
       	        							        			        .add(TextCell.builder().text(""+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getItemNameAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getItemQuantityAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getItemRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getMaterialCost()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getTaxableAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getCgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getSgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getTransportationCharges()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getPumpAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getLabourAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			    .add(TextCell.builder().text(""+dao.getRoyalty()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      	        							        			  	    .add(TextCell.builder().text(dao.getBillAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(""+dao.getAmountPaid()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        			  	.add(TextCell.builder().text(dao.getDueAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        				.add(TextCell.builder().text(""+dao.getTripTo()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	        							        				.add(TextCell.builder().text(dao.getComments().replaceAll("\t", " ")).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        	            							        		  	.backgroundColor(Color.WHITE)
        	        									                .textColor(Color.BLACK)
        	        									                .font(fontMarathi)
        	        									                .fontSize(7)				              
        	        									                .horizontalAlignment(CENTER)
        	        									                .height(25F)					                
        	        									                .build();
        	        							        	  
        	        						        			statementDetailsBuilder.addRow(custInfo);
		        							        		  }else {
		        							        			  Row custInfo = Row.builder()
		      	        							        			  	.add(TextCell.builder().text(dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			    .add(TextCell.builder().text(""+dao.getChalanNumber().replaceAll("\t", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		     	        							        			    .add(TextCell.builder().text(""+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			  	.add(TextCell.builder().text(""+dao.getItemNameAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			  	.add(TextCell.builder().text(""+dao.getItemQuantityAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			  	.add(TextCell.builder().text(""+dao.getItemRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			  	.add(TextCell.builder().text(""+dao.getMaterialCost()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			    .add(TextCell.builder().text(""+dao.getTaxableAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        	        							        			  	.add(TextCell.builder().text(""+dao.getCgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        	        							        			  	.add(TextCell.builder().text(""+dao.getSgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        	        							        			  	.add(TextCell.builder().text(""+dao.getTransportationCharges()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			    .add(TextCell.builder().text(""+dao.getRoyalty()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		    	        							        			  	.add(TextCell.builder().text(dao.getBillAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			  	.add(TextCell.builder().text(""+dao.getAmountPaid()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        			  	.add(TextCell.builder().text(dao.getDueAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        				.add(TextCell.builder().text(""+dao.getTripTo()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	        							        				.add(TextCell.builder().text(dao.getComments().replaceAll("\t", " ")).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
		      	            							        		  	.backgroundColor(Color.WHITE)
		      	        									                .textColor(Color.BLACK)
		      	        									                .font(fontMarathi)
		      	        									                .fontSize(7)				              
		      	        									                .horizontalAlignment(CENTER)
		      	        									                .height(25F)					                
		      	        									                .build();
		      	        							        	  
		      	        						        			statementDetailsBuilder.addRow(custInfo);
		        							        		  }
            						        			  
      	        						        		
      	        						        		  
      						        			 
      						        		  }else {
      						        			if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
  							        		  {
      						        				 Row  custInfo = Row.builder()
         	        						        		  
       						        						.add(TextCell.builder().text(dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			    .add(TextCell.builder().text(""+dao.getChalanNumber().replaceAll("\t", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getItemNameAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getItemQuantityAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getItemRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getMaterialCost()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getTaxableAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getCgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getSgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getTransportationCharges()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
   	        							        			  	.add(TextCell.builder().text(""+dao.getPumpAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
   	        							        			  	.add(TextCell.builder().text(""+dao.getLabourAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
   	        							        			    .add(TextCell.builder().text(dao.getBillAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getAmountPaid()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(dao.getDueAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	        							        			  	.add(TextCell.builder().text(""+dao.getTripTo()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
   	        							        				.add(TextCell.builder().text(dao.getComments().replaceAll("\t", " ")).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
 	            							        		  	.backgroundColor(Color.WHITE)
             									                .textColor(Color.BLACK)
             									                .font(fontMarathi)
             									                .fontSize(7)				              
             									                .horizontalAlignment(CENTER)
             									                .height(25F)					                
             									                .build();
             						        		 		  	statementDetailsBuilder.addRow(custInfo);
  							        		  }else {
  							        			 Row  custInfo = Row.builder()
     	        						        		  
   						        						.add(TextCell.builder().text(dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			    .add(TextCell.builder().text(""+dao.getChalanNumber().replaceAll("\t", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getItemNameAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getItemQuantityAll()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getItemRate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getMaterialCost()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getTaxableAmt()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getCgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getSgst()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getTransportationCharges()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			    .add(TextCell.builder().text(dao.getBillAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getAmountPaid()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(dao.getDueAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        			  	.add(TextCell.builder().text(""+dao.getTripTo()).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	        							        				.add(TextCell.builder().text(dao.getComments().replaceAll("\t", " ")).font(fontMarathi).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
	            							        		  	.backgroundColor(Color.WHITE)
         									                .textColor(Color.BLACK)
         									                .font(fontMarathi)
         									                .fontSize(7)				              
         									                .horizontalAlignment(CENTER)
         									                .height(25F)					                
         									                .build();
         						        		 		  	statementDetailsBuilder.addRow(custInfo);
  							        		  }
          						        			  
      						        				 
      	        						        		  
      						        		  }
      						        		  
            							        	  
            							        	  
            							          }
        							        	  currentY = currentY -25;
        						        		  
        						        	  }
        						        	  
        						        	  
        						        	  if(this.getType().equals("Type 1"))
        							          {
        						        		  
        						        		  
        							          
        						        	  if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
     	        							       
            						        	  Row totalInfoRow = Row.builder()
        							        			  	.add(TextCell.builder().text("Total").colSpan(3).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+totalQuantity6mm).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+totalQuantity10mm).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+totalQuantity20mm).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+totalQuantity40mm).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+totalQuantityCS).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+totalQuantityPS).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+totalQuantityPowder).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        								        			.add(TextCell.builder().text(""+totalQuantityDust).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        								        			.add(TextCell.builder().text(""+totalQuantityOther).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        								        			.add(TextCell.builder().text(""+this.getTotalBillAmountAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        								        			.add(TextCell.builder().text(""+this.getTotalRoyaltyAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
        							        				.add(TextCell.builder().text("").font(fontMarathi).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
          							        		  		.backgroundColor(Color.WHITE)
        									                .textColor(Color.BLACK)
        									                .font(fontMarathi)
        									                .fontSize(9)				              
        									                .horizontalAlignment(CENTER)
        									                .height(25F)					                
        									                .build();
        							        	  
        						        			statementDetailsBuilder.addRow(totalInfoRow);
            						        	  
            						        	  }else {
        						        	  
        						        	  Row totalInfoRow = Row.builder()
    							        			  	.add(TextCell.builder().text("Total").colSpan(3).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+totalQuantity6mm).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+totalQuantity10mm).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+totalQuantity20mm).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+totalQuantity40mm).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+totalQuantityCS).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+totalQuantityPS).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+totalQuantityPowder).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    								        			.add(TextCell.builder().text(""+totalQuantityDust).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    								        			.add(TextCell.builder().text(""+totalQuantityOther).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    								        			.add(TextCell.builder().text(""+this.getTotalBillAmountAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        				.add(TextCell.builder().text("").font(fontMarathi).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        		  		.backgroundColor(Color.WHITE)
    									                .textColor(Color.BLACK)
    									                .font(fontMarathi)
    									                .fontSize(9)				              
    									                .horizontalAlignment(CENTER)
    									                .height(25F)					                
    									                .build();
    							        	  
    						        			statementDetailsBuilder.addRow(totalInfoRow);
            						        	  }
        							          }else {
        							        	  
        							        	  
        							        	  if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
        							        		  
        							        		  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
          							        		  {
        							        			  Row totalInfoRow = Row.builder()
              							        			  	.add(TextCell.builder().text("Total").colSpan(4).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getMaterialTotal()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalMaterialCostAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			    .add(TextCell.builder().text(""+this.getTotalTaxableAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
            							        			    .add(TextCell.builder().text(""+this.getTotalCgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalSgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalTrChargesAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalPumpAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalLaborAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalRoyaltyAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalBillAmountAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              								        			.backgroundColor(Color.WHITE)
              									                .textColor(Color.BLACK)
              									                .font(fontMarathi)
              									                .fontSize(9)				              
              									                .horizontalAlignment(CENTER)
              									                .height(25F)					                
              									                .build();
              							        	  
              						        			statementDetailsBuilder.addRow(totalInfoRow);
          							        		  }else {
          							        			 Row totalInfoRow = Row.builder()
             							        			  	.add(TextCell.builder().text("Total").colSpan(4).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
             							        			  	.add(TextCell.builder().text(""+this.getMaterialTotal()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
             							        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             							        			  	.add(TextCell.builder().text(""+this.getTotalMaterialCostAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             							        			  	.add(TextCell.builder().text(""+this.getTotalTaxableAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			    .add(TextCell.builder().text(""+this.getTotalCgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalSgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
              							        			  	.add(TextCell.builder().text(""+this.getTotalTrChargesAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             							        			  	.add(TextCell.builder().text(""+this.getTotalRoyaltyAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             							        			  	.add(TextCell.builder().text(""+this.getTotalBillAmountAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
             								        			.backgroundColor(Color.WHITE)
             									                .textColor(Color.BLACK)
             									                .font(fontMarathi)
             									                .fontSize(9)				              
             									                .horizontalAlignment(CENTER)
             									                .height(25F)					                
             									                .build();
             							        	  
             						        			statementDetailsBuilder.addRow(totalInfoRow);
          							        		  }
        	        							       
                						        	 
                						        	  
                						        	  }else {
            						        	  
                						        		  
                						        		  if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
              							        		  {
                						        			  Row totalInfoRow = Row.builder()
                        						        			  .add(TextCell.builder().text("Total").colSpan(4).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			  	.add(TextCell.builder().text(""+this.getMaterialTotal()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			    .add(TextCell.builder().text(""+this.getTotalMaterialCostAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			    .add(TextCell.builder().text(""+this.getTotalTaxableAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			    .add(TextCell.builder().text(""+this.getTotalCgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			  	.add(TextCell.builder().text(""+this.getTotalSgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			  	.add(TextCell.builder().text(""+this.getTotalTrChargesAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
            	  							        			  	.add(TextCell.builder().text(""+this.getTotalPumpAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
            	  							        			  	.add(TextCell.builder().text(""+this.getTotalLaborAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
            	  							        			  	.add(TextCell.builder().text(""+this.getTotalBillAmountAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  								        			.backgroundColor(Color.WHITE)
                    									                .textColor(Color.BLACK)
                    									                .font(fontMarathi)
                    									                .fontSize(9)				              
                    									                .horizontalAlignment(CENTER)
                    									                .height(25F)					                
                    									                .build();
                    							        	  
                    						        			statementDetailsBuilder.addRow(totalInfoRow);
              							        		  }else {
              							        			Row totalInfoRow = Row.builder()
                      						        			  .add(TextCell.builder().text("Total").colSpan(4).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			  	.add(TextCell.builder().text(""+this.getMaterialTotal()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			    .add(TextCell.builder().text(""+this.getTotalMaterialCostAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			    .add(TextCell.builder().text(""+this.getTotalTaxableAmtAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			    .add(TextCell.builder().text(""+this.getTotalCgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			  	.add(TextCell.builder().text(""+this.getTotalSgstAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                  							        			  	.add(TextCell.builder().text(""+this.getTotalTrChargesAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
          	  							        			  	    .add(TextCell.builder().text(""+this.getTotalBillAmountAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                								        			.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())				                
                								        			.backgroundColor(Color.WHITE)
                  									                .textColor(Color.BLACK)
                  									                .font(fontMarathi)
                  									                .fontSize(9)				              
                  									                .horizontalAlignment(CENTER)
                  									                .height(25F)					                
                  									                .build();
                  							        	  
                  						        			statementDetailsBuilder.addRow(totalInfoRow);
              							        		  }
            						        	  
                						        	  }
        							        	  
        							        	  
        							        	  
        							        	 
														TableBuilder productTableBuilder = Table.builder()
																.addColumnsOfWidth(150, 130,130).font(HELVETICA)
																.borderWidth(0.5F).borderColor(Color.BLACK)
																.horizontalAlignment(CENTER);

														
														
														Row productHeader = Row.builder()
																.add(TextCell.builder().text("Product Name")
																		.horizontalAlignment(LEFT).borderWidth(0.5F)
																		.build())
																.add(TextCell.builder().text("Total Quantity")
																		.horizontalAlignment(LEFT).borderWidth(0.5F)
																		.build())
																.add(TextCell.builder().text("Sales Unit")
																		.horizontalAlignment(LEFT).borderWidth(0.5F)
																		.build())
																.backgroundColor(Color.LIGHT_GRAY)
																.textColor(Color.BLACK).font(PDType1Font.HELVETICA_BOLD)
																.fontSize(8).height(20F).horizontalAlignment(CENTER)
																.build();
														productTableBuilder.addRow(productHeader);

														for (Map<String, Object> product : productQuantityList) {

															
															
															 String productName = product.get("productName") != null ? product.get("productName").toString() : "";
							     							    double quantity = product.get("quantity") != null ? Double.parseDouble(product.get("quantity").toString()) : 0.0;
							     							   String salesUnit = product.get("salesUnit") != null ? product.get("salesUnit").toString() : "";

							     							    
															Row productRow = Row.builder()
																	.add(TextCell.builder().text("" + productName)
																			.horizontalAlignment(LEFT).borderWidth(0.5F)
																			.build())
																	.add(TextCell.builder().text("" + quantity)
																			.horizontalAlignment(LEFT).borderWidth(0.5F)
																			.build())
																	.add(TextCell.builder().text("" + salesUnit)
																			.horizontalAlignment(LEFT).borderWidth(0.5F)
																			.build())
																	.backgroundColor(Color.WHITE).textColor(Color.BLACK)
																	.font(PDType1Font.HELVETICA).fontSize(10)
																	.height(20F).horizontalAlignment(CENTER).build();

															productTableBuilder.addRow(productRow);
														}

														productTable = productTableBuilder.build();
        												  
        												  
        												  
        							        	  
        							        	  
        							          }
        						        	  
        						        	  
        						        	  
        						        	 
    							        	  
        						        	  
        						        	  stateMentDetails = statementDetailsBuilder.build();
        						        	  
        						        	  
        						        	  
        						        	  
        						        	  
												
												
												 
        						        	  
        						        	  
        						        	 Table totalInfo ;
        						        	  
        						        	  TableBuilder  totalTableBuilder = Table.builder()
      								                .addColumnsOfWidth(133,133)				                
      								                .font(HELVETICA)
      								                .borderWidth(0.5F)
      								                .borderColor(Color.BLACK)
      								                .horizontalAlignment(CENTER);

        						        	  Row totalBillAmt = Row.builder()
    							        			  	.add(TextCell.builder().text("Total Bill Amount : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+this.getTotalBillAmountAllTheTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.backgroundColor(Color.WHITE)
    									                .textColor(Color.BLACK)
    									                .font(PDType1Font.HELVETICA)
    									                .fontSize(10)				              
    									                .horizontalAlignment(CENTER)
    									                .height(25F)					                
    									                .build();
        						        	  Row totalAmtReceived = Row.builder()
    							        			  	.add(TextCell.builder().text("Total Amount Received: ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidAllTheTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.backgroundColor(Color.WHITE)
    									                .textColor(Color.BLACK)
    									                .font(PDType1Font.HELVETICA)
    									                .fontSize(10)				              
    									                .horizontalAlignment(CENTER)
    									                .height(25F)					                
    									                .build();
        						        	  
        						        	  Row openBalAmt = Row.builder()
    							        			  	.add(TextCell.builder().text("Opening Balance Amount : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+this.getCustOpeningBalnce()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.backgroundColor(Color.WHITE)
    									                .textColor(Color.BLACK)
    									                .font(PDType1Font.HELVETICA)
    									                .fontSize(10)				              
    									                .horizontalAlignment(CENTER)
    									                .height(25F)					                
    									                .build();
        						        	  Row totalAmtOutstanding = Row.builder()
    							        			  	.add(TextCell.builder().text("Total Amount Outstanding: ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.add(TextCell.builder().text(""+this.getTotalOutStandingAmountAllTheTime()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
    							        			  	.backgroundColor(Color.WHITE)
    									                .textColor(Color.BLACK)
    									                .font(PDType1Font.HELVETICA)
    									                .fontSize(10)				              
    									                .horizontalAlignment(CENTER)
    									                .height(25F)					                
    									                .build();
    							        	  
        						        	  totalTableBuilder.addRow(totalBillAmt);
        						        	  totalTableBuilder.addRow(totalAmtReceived);
        						        	  totalTableBuilder.addRow(openBalAmt);
        						        	  totalTableBuilder.addRow(totalAmtOutstanding);
        						        	  totalInfo = totalTableBuilder.build();  
        						          
        						        	  Table betweenDatestotalInfo ;
        						        	  
        						        	  TableBuilder  betweenDatesTableBuilder = Table.builder()
        								                .addColumnsOfWidth(220,133)				                
        								                .font(HELVETICA)
        								                .borderWidth(0.5F)
        								                .borderColor(Color.BLACK)
        								                .horizontalAlignment(CENTER);

          						        	  Row betweenDatestotalBillAmt = Row.builder()
      							        			  	.add(TextCell.builder().text("Total Bill Amount Between Dates : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.add(TextCell.builder().text(""+this.getTotalBillAmountBetweenDates()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.backgroundColor(Color.WHITE)
      									                .textColor(Color.BLACK)
      									                .font(PDType1Font.HELVETICA)
      									                .fontSize(10)				              
      									                .horizontalAlignment(CENTER)
      									                .height(25F)					                
      									                .build();
          						        	  Row betweenDatestotalAmtReceived = Row.builder()
      							        			  	.add(TextCell.builder().text("Total Amount Received Between Dates : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.add(TextCell.builder().text(""+this.getTotalAmountPaidBetweenDates()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.backgroundColor(Color.WHITE)
      									                .textColor(Color.BLACK)
      									                .font(PDType1Font.HELVETICA)
      									                .fontSize(10)				              
      									                .horizontalAlignment(CENTER)
      									                .height(25F)					                
      									                .build();
          						        	  
          						        	  Row betweenDatesopenBalAmt = Row.builder()
      							        			  	.add(TextCell.builder().text("Opening Balance Amount : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.add(TextCell.builder().text(""+this.getCustOpeningBalnce()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.backgroundColor(Color.WHITE)
      									                .textColor(Color.BLACK)
      									                .font(PDType1Font.HELVETICA)
      									                .fontSize(10)				              
      									                .horizontalAlignment(CENTER)
      									                .height(25F)					                
      									                .build();
          						        	  Row betweenDatestotalAmtOutstanding = Row.builder()
      							        			  	.add(TextCell.builder().text("Total Amount Outstanding Between Dates : ").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.add(TextCell.builder().text(""+this.getTotalOutStandingAmountBetweenDates()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
      							        			  	.backgroundColor(Color.WHITE)
      									                .textColor(Color.BLACK)
      									                .font(PDType1Font.HELVETICA)
      									                .fontSize(10)				              
      									                .horizontalAlignment(CENTER)
      									                .height(25F)					                
      									                .build();
      							        	  
          						        	betweenDatesTableBuilder.addRow(betweenDatestotalBillAmt);
          						        	betweenDatesTableBuilder.addRow(betweenDatestotalAmtReceived);
          						        	betweenDatesTableBuilder.addRow(betweenDatesopenBalAmt);
          						        	betweenDatesTableBuilder.addRow(betweenDatestotalAmtOutstanding);
          						        	betweenDatestotalInfo = betweenDatesTableBuilder.build();
          						        	  
          						        	  
        						        	  
        						          TableDrawer.builder()
        					                .contentStream(contentStream)
        					                .table(stateMentDetails)
        					                .startX(PADDING10)
        					                .startY(startY-70)
        					                .build()
        					                .draw();
        						          
        						         
        						        
        						        if(currentY < 500)
        						          {
        						        	  pageCount++;
    					        			
    					        			  
    					        			  contentStream.close();
    					        			  
    					        			  header = null;
    					        			  
    					        			  

        					    			  tableHeaderBuilder = Table.builder()
        								                .addColumnsOfWidth(830)				                
        								                .font(HELVETICA)
        								                .borderColor(Color.BLACK)
        								                .horizontalAlignment(CENTER);
        							         
        							          headerName = Row.builder()
        								                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
        								                .backgroundColor(WHITE)
        								                .textColor(Color.BLACK)
        								                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
        								                .horizontalAlignment(CENTER)
        								                .build();
        							          
        							           info1 = Row.builder()
        								                .add(TextCell.builder().text("Customer Account Statement").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
        								                .backgroundColor(WHITE)
        								                .textColor(Color.BLACK)
        								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
        								                .horizontalAlignment(CENTER)
        								                .build();
        							          
        							           info2 = Row.builder()
        								                .add(TextCell.builder().text("Name :- "+nameOfCustomer+"   Address:- "+custAddress).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
        								                .backgroundColor(WHITE)
        								                .textColor(Color.BLACK)
        								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
        								                .horizontalAlignment(CENTER)
        								                .build();
        							          
        							           info3 = Row.builder()
      								                .add(TextCell.builder().text("From Date: "
      								                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
      								                .backgroundColor(WHITE)
      								                .textColor(Color.BLACK)
      								                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
      								                .horizontalAlignment(CENTER)
      								                .build();
        							          
        							       
        							          tableHeaderBuilder.addRow(headerName);
        							          tableHeaderBuilder.addRow(info1);
        							          tableHeaderBuilder.addRow(info2);
        							          tableHeaderBuilder.addRow(info3);
        							          header = tableHeaderBuilder.build();
        							          
        							          
        							          PDPage newPage = new PDPage(new PDRectangle(830,580));
    								        	 contentStream = new PDPageContentStream(document,newPage);
    								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
    								             document.addPage( newPage );
    								             
    								             TableDrawer.builder()
    								                .contentStream(contentStream)
    								                .table(header)
    								                .startX(PADDING30)
    								                .startY(currentY)
    								                .build()
    								                .draw();
    								             if(this.getType().equals("Type 1"))
           							          {
    								             TableDrawer.builder()
    		       					                .contentStream(contentStream)
    		       					                .table(totalInfo)
    		       					                .startX(PADDING30)
    		       					                .startY(currentY-130)
    		       					                .build()
    		       					                .draw();
    								             
    								             TableDrawer.builder()
 		       					                .contentStream(contentStream)
 		       					                .table(betweenDatestotalInfo)
 		       					                .startX(PADDING30)
 		       					                .startY(currentY-250)
 		       					                .build()
 		       					                .draw();
    								             
           							          }else {
           							        	  
           							        	
           							        	
           							        	TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(totalInfo)
		       					                .startX(PADDING30)
		       					                .startY(currentY-130)
		       					                .build()
		       					                .draw();
           							        	
           							        	
           							         TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(betweenDatestotalInfo)
		       					                .startX(PADDING30)
		       					                .startY(currentY-250)
		       					                .build()
		       					                .draw();
           							         
           							         
           							        	TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(productTable)
		       					                .startX(PADDING30)
		       					                .startY(currentY-370)
		       					                .build()
		       					                .draw();
           							        	
           							        	
           							        
           							        	  
           							          }
        							          
        						          }
        						          else
        						          {
        						        	  if(this.getType().equals("Type 1"))
           							          {
        						        	   TableDrawer.builder()
           					                .contentStream(contentStream)
           					                .table(totalInfo)
           					                .startX(PADDING30)
           					                .startY(currentY-130)
           					                .build()
           					                .draw();
        						        	   
        						        	   TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(betweenDatestotalInfo)
		       					                .startX(PADDING30)
		       					                .startY(currentY-250)
		       					                .build()
		       					                .draw();
        						        	   
           							          }else {
           							        	  
           							        	
           							        	
           							        	TableDrawer.builder()
               					                .contentStream(contentStream)
               					                .table(totalInfo)
               					                .startX(PADDING30)
               					                .startY(currentY-125)
               					                .build()
               					                .draw();
           							        	
           							        	
           							         TableDrawer.builder()
		       					                .contentStream(contentStream)
		       					                .table(betweenDatestotalInfo)
		       					                .startX(PADDING30)
		       					                .startY(currentY-230)
		       					                .build()
		       					                .draw();
           							         
           							         
           							        	TableDrawer.builder()
               					                .contentStream(contentStream)
               					                .table(productTable)
               					                .startX(PADDING30)
               					                .startY(currentY-340)
               					                .build()
               					                .draw();
           							        	
           							        	  
           							          }
        						          }
        						       
        							          contentStream.close();
        								        
        								       // System.out.println(path);
        												
        								        
        								        document.save(path+"/cust-acc-stmt-report.pdf");
        								        document.close();
        								        
        								        response.setHeader("Content-disposition", "inline; filename=cust-acc-stmt-report.pdf");
        										response.setContentType("application/pdf");
        										FileInputStream fileInputStream = new FileInputStream(path+"/cust-acc-stmt-report.pdf");
        										PrintWriter out = response.getWriter();  
        										int bytes;
        										while ((bytes = fileInputStream.read()) != -1) {
        											out.write(bytes);
        										}
        										fileInputStream.close();
        										out.flush();
        										out.close();
        										ttf1.close();
        						 
       						}
       						
       						if(this.getDownloadType().equals("xl"))
       						{
       							
       							
       						  if(this.getType().equals("Type 1"))
					          {
       							

       							String fileName = "cust-acc-stmt-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-type-"+this.getType()+".xls";
       							 HSSFWorkbook workbook = new HSSFWorkbook();
       							  HSSFSheet mySheet = workbook.createSheet("cust-acc-stmt-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-type-"+this.getType());  
       							
       							mySheet.setColumnWidth(0, 15 * 256);  
       							mySheet.setColumnWidth(1, 15 * 256); 
       							mySheet.setColumnWidth(2, 15 * 256);  
       							mySheet.setColumnWidth(3, 10 * 256);  
       							mySheet.setColumnWidth(4, 10 * 256); 
       							mySheet.setColumnWidth(5, 10 * 256);  
       							mySheet.setColumnWidth(6, 10 * 256);  
       							mySheet.setColumnWidth(7, 10 * 256); 
       							mySheet.setColumnWidth(8, 10 * 256);  
       							mySheet.setColumnWidth(9, 10 * 256);  
       							mySheet.setColumnWidth(10, 10 * 256);  
       							mySheet.setColumnWidth(11, 10 * 256); 
       							mySheet.setColumnWidth(12, 15 * 256); 
       							mySheet.setColumnWidth(13, 15 * 256); 
       							
       							
       							if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
       							    mySheet.setColumnWidth(14, 15 * 256);
       							}
       							mySheet.setColumnWidth(15, 15 * 256); 
       							mySheet.setColumnWidth(16, 15 * 256); 
       							mySheet.setColumnWidth(17, 30 * 256);

       							 
       							 	Font font = workbook.createFont();
       						       
       						        font.setBold(true);
       						       
       							 final HSSFCellStyle cellStyle = workbook.createCellStyle();

       							 cellStyle.setBorderBottom(BorderStyle.THIN);
       							 cellStyle.setBorderRight(BorderStyle.THIN);
       							 cellStyle.setBorderLeft(BorderStyle.THIN);
       							 cellStyle.setBorderTop(BorderStyle.THIN);
       							 cellStyle.setFont(font);
       							 cellStyle.setWrapText(true);
       							 
       							 final HSSFCellStyle cellStyleNonBold = workbook.createCellStyle();

       							 cellStyleNonBold.setBorderBottom(BorderStyle.THIN);
       							 cellStyleNonBold.setBorderRight(BorderStyle.THIN);
       							 cellStyleNonBold.setBorderLeft(BorderStyle.THIN);
       							 cellStyleNonBold.setBorderTop(BorderStyle.THIN);
       							 
       							 short s = 255-0-0;
       							 final HSSFCellStyle cellStyleBoldRed = workbook.createCellStyle();	 
       							 
       							 cellStyleBoldRed.setBorderBottom(BorderStyle.THIN);
       							 cellStyleBoldRed.setBorderRight(BorderStyle.THIN);
       							 cellStyleBoldRed.setBorderLeft(BorderStyle.THIN);
       							 cellStyleBoldRed.setBorderTop(BorderStyle.THIN);
       							 cellStyleBoldRed.setFillForegroundColor(s);
       							 cellStyleBoldRed.setFont(font);								 
       							 cellStyleBoldRed.setWrapText(true);
       							 
       							 HSSFRow rowHead = mySheet.createRow(0);							 
       							 
       							List<String> headers = new ArrayList<>();
       							headers.add("Date");
       							headers.add("Chalan No.");
       							headers.add("Vehicle No");
       							headers.add("6MM");
       							headers.add("10MM");
       							headers.add("20MM");
       							headers.add("40MM");
       							headers.add("CSand");
       							headers.add("PSand");
       							headers.add("POW");
       							headers.add("Dust");
       							headers.add("GSB");
       							headers.add("Billed By");
       							headers.add("Total Bill Amount");

       							
       							if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
       							    headers.add("Royalty");
       							}

       							
       							headers.add("Amount Received");
       							headers.add("Due Amount");
       							headers.add("Comments");

       							// Create header cells dynamically
       							for (int i = 0; i < headers.size(); i++) {
       							    Cell cell = rowHead.createCell(i);
       							    cell.setCellValue(headers.get(i));
       							    cell.setCellStyle(cellStyleBoldRed);
       							}
    							 
    							 
       							 int rowCount = 1;
       							   for(CustomerAccountDetailsDAO dao:this.getCustomerAccountDetailsList())
       						       {
       										 HSSFRow rowData = mySheet.createRow(rowCount);
       										  
       										Cell cell1 = rowData.createCell(0);
       										cell1.setCellValue(dao.getDateAsString());
       										cell1.setCellStyle(cellStyleNonBold);

       										Cell cell2 = rowData.createCell(1);
       										cell2.setCellValue(dao.getChalanNumber().replaceAll("\t", " "));
       										cell2.setCellStyle(cellStyleNonBold);

       										Cell cell3 = rowData.createCell(2);
       										cell3.setCellValue(dao.getVehicleNumber());
       										cell3.setCellStyle(cellStyleNonBold);

       										Cell cell4 = rowData.createCell(3);
       										cell4.setCellValue(dao.getSixMm());
       										cell4.setCellStyle(cellStyleNonBold);

       										Cell cell5 = rowData.createCell(4);
       										cell5.setCellValue(dao.getTenMm());
       										cell5.setCellStyle(cellStyleNonBold);

       										Cell cell6 = rowData.createCell(5);
       										cell6.setCellValue(dao.getTwentyFiveMm());
       										cell6.setCellStyle(cellStyleNonBold);

       										Cell cell7 = rowData.createCell(6);
       										cell7.setCellValue(dao.getFourtyMm());
       										cell7.setCellStyle(cellStyleNonBold);

       										Cell cell8 = rowData.createCell(7);
       										cell8.setCellValue(dao.getCrushSand());
       										cell8.setCellStyle(cellStyleNonBold);

       										Cell cell9 = rowData.createCell(8);
       										cell9.setCellValue(dao.getPlasterSand());
       										cell9.setCellStyle(cellStyleNonBold);

       										Cell cell10 = rowData.createCell(9);
       										cell10.setCellValue(dao.getPowder());
       										cell10.setCellStyle(cellStyleNonBold);

       										Cell cell11 = rowData.createCell(10);
       										cell11.setCellValue(dao.getDust());
       										cell11.setCellStyle(cellStyleNonBold);

       										Cell cell12 = rowData.createCell(11);
       										cell12.setCellValue(dao.getOther());
       										cell12.setCellStyle(cellStyleNonBold);

       										

       										
       										Cell cell13 = rowData.createCell(12);
       										cell13.setCellValue(dao.getBilledBy());
       										cell13.setCellStyle(cellStyleNonBold);

       										Cell cell14 = rowData.createCell(13);
       										cell14.setCellValue(dao.getBillAmount());
       										cell14.setCellStyle(cellStyleNonBold);

       										int columnIndex = 14; // Start after Bill Amount
       										if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
       										    Cell cellRoyalty = rowData.createCell(columnIndex++);
       										    cellRoyalty.setCellValue("" + dao.getRoyalty());
       										    cellRoyalty.setCellStyle(cellStyleNonBold);
       										}

       										Cell cell15 = rowData.createCell(columnIndex++);
       										cell15.setCellValue(dao.getAmountPaid());
       										cell15.setCellStyle(cellStyleNonBold);

       										Cell cell16 = rowData.createCell(columnIndex++);
       										cell16.setCellValue(dao.getDueAmount());
       										cell16.setCellStyle(cellStyleNonBold);

       										Cell cell17 = rowData.createCell(columnIndex++);
       										cell17.setCellValue(dao.getComments());
       										cell17.setCellStyle(cellStyleNonBold);

       										 
       										 rowCount++;
       										 
       						       }
       							   
       							HSSFRow totalRow = mySheet.createRow(rowCount);

       							Cell totalLabelCell = totalRow.createCell(0);
       							totalLabelCell.setCellValue("Total");
       							totalLabelCell.setCellStyle(cellStyleBoldRed); 

       							
       							for (int i = 1; i <= 15; i++) {  
       							    Cell dataCell = totalRow.createCell(i);
       							    dataCell.setCellStyle(cellStyleNonBold);
       							}

       							
       							totalRow.getCell(3).setCellValue(totalQuantity6mm);
       							totalRow.getCell(4).setCellValue(totalQuantity10mm);
       							totalRow.getCell(5).setCellValue(totalQuantity20mm);
       							totalRow.getCell(6).setCellValue(totalQuantity40mm);
       							totalRow.getCell(7).setCellValue(totalQuantityCS);
       							totalRow.getCell(8).setCellValue(totalQuantityPS);
       							totalRow.getCell(9).setCellValue(totalQuantityPowder);
       							totalRow.getCell(10).setCellValue(totalQuantityDust);
       							totalRow.getCell(11).setCellValue(totalQuantityOther);
       							
       							
       							totalRow.getCell(12).setCellValue("");

       							
       							totalRow.getCell(13).setCellValue(this.getTotalBillAmountAllTheTime());

       							int nextColumn = 14;

       						
       						if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
       						    totalRow.createCell(nextColumn).setCellValue(this.getTotalRoyaltyAllTheTime());
       						    totalRow.getCell(nextColumn).setCellStyle(cellStyleNonBold);  // Ensure black styling
       						    nextColumn++; 
       						}

       						
       						totalRow.createCell(nextColumn).setCellValue(this.getTotalAmountPaidAllTheTime());
       						totalRow.getCell(nextColumn).setCellStyle(cellStyleNonBold);
       						nextColumn++;

       						
       						totalRow.createCell(nextColumn).setCellValue("");  
       						totalRow.getCell(nextColumn).setCellStyle(cellStyleNonBold);
       						nextColumn++;

       						totalRow.createCell(nextColumn).setCellValue("");  
       						totalRow.getCell(nextColumn).setCellStyle(cellStyleNonBold);

       							
       						rowCount += 2;

       						
       						int previousColumnWidth1 = mySheet.getColumnWidth(0);
       						int previousColumnWidth2 = mySheet.getColumnWidth(1);

       						mySheet.setColumnWidth(0, 20 * 300); 
       						mySheet.setColumnWidth(1, 35 * 300); 

       						List<String[]> totalData = new ArrayList<>();
       						totalData.add(new String[]{"Total Bill Amount:", "" + this.getTotalBillAmountAllTheTime()});
       						totalData.add(new String[]{"Total Amount Received:", "" + this.getTotalAmountPaidAllTheTime()});
       						totalData.add(new String[]{"Opening Balance Amount:", "" + this.getCustOpeningBalnce()});
       						totalData.add(new String[]{"Total Amount Outstanding:", "" + this.getTotalOutStandingAmountAllTheTime()});

       						for (String[] data : totalData) {
       						    HSSFRow totalRow1 = mySheet.createRow(rowCount);
       						    for (int i = 0; i < data.length; i++) {
       						        Cell cell = totalRow1.createCell(i);
       						        cell.setCellValue(data[i]);
       						        cell.setCellStyle(cellStyleBoldRed);
       						    }
       						    rowCount++;  
       						}

       						rowCount++;

       						mySheet.setColumnWidth(0, previousColumnWidth1);
       						mySheet.setColumnWidth(1, previousColumnWidth2);

       						
       						
       						int previousColumnWidth11 = mySheet.getColumnWidth(0);
       						int previousColumnWidth21 = mySheet.getColumnWidth(1);

       						mySheet.setColumnWidth(0, 20 * 300); 
       						mySheet.setColumnWidth(1, 35 * 300); 

       						List<String[]> totalData1 = new ArrayList<>();
       						totalData1.add(new String[]{"Total Bill Amount Between Dates:", "" + this.getTotalBillAmountBetweenDates()});
       						totalData1.add(new String[]{"Total Amount Received Between Dates:", "" + this.getTotalAmountPaidBetweenDates()});
       						totalData1.add(new String[]{"Opening Balance Amount:", "" + this.getCustOpeningBalnce()});
       						totalData1.add(new String[]{"Total Amount Outstanding Between Dates:", "" + this.getTotalOutStandingAmountBetweenDates()});

       						for (String[] data : totalData1) {
       						    HSSFRow totalRow1 = mySheet.createRow(rowCount);
       						    for (int i = 0; i < data.length; i++) {
       						        Cell cell = totalRow1.createCell(i);
       						        cell.setCellValue(data[i]);
       						        cell.setCellStyle(cellStyleBoldRed);
       						    }
       						    rowCount++;  
       						}

       						rowCount++;

       						mySheet.setColumnWidth(0, previousColumnWidth11);
       						mySheet.setColumnWidth(1, previousColumnWidth21);

       						
       						
       						
       							   FileOutputStream fileOut = new FileOutputStream(fileName);
       							   workbook.write(fileOut);
       					            fileOut.close();
       					            workbook.close();
       					            
       					    		response.setHeader("Content-disposition", "inline; filename="+""+fileName);
       								response.setContentType("application/xls");
       								FileInputStream fileInputStream = new FileInputStream(fileName);
       								PrintWriter out = response.getWriter();  
       								int bytes;
       								while ((bytes = fileInputStream.read()) != -1) {
       									out.write(bytes);
       								}
       								fileInputStream.close();
       								out.close();
       								
       								
       								
       						}
       						  
       						  
       						  
       						  
       						  
       						  
       						  
       						  
       						  
       						if(this.getType().equals("Type 2"))
					          {
     							

     							String fileName = "cust-acc-stmt-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-type-"+this.getType()+".xls";
     							 HSSFWorkbook workbook = new HSSFWorkbook();
     							  HSSFSheet mySheet = workbook.createSheet("cust-acc-stmt-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-type-"+this.getType());  
     							
     							mySheet.setColumnWidth(0, 15 * 256);  
     							mySheet.setColumnWidth(1, 15 * 256);  
     							mySheet.setColumnWidth(2, 15 * 256);  
     							mySheet.setColumnWidth(3, 20 * 256); 
     							mySheet.setColumnWidth(4, 10 * 256);  
     							mySheet.setColumnWidth(5, 10 * 256);  
     							mySheet.setColumnWidth(6, 15 * 256);  
     							mySheet.setColumnWidth(7, 15 * 256);  
     							mySheet.setColumnWidth(8, 15 * 256);  
     							mySheet.setColumnWidth(9, 15 * 256);  
     							mySheet.setColumnWidth(10, 15 * 256);  
     							
     							if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
			        			  {
     								 mySheet.setColumnWidth(11, 15 * 256);
     								 mySheet.setColumnWidth(12, 15 * 256);
			        			  }
     							if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
     							    mySheet.setColumnWidth(13, 15 * 256);
     							}

     							mySheet.setColumnWidth(14, 15 * 256);  
     							mySheet.setColumnWidth(15, 12 * 256); 
     							mySheet.setColumnWidth(16, 15 * 256); 
     							mySheet.setColumnWidth(17, 15 * 256); 
     							mySheet.setColumnWidth(18, 20 * 256);
     							mySheet.setColumnWidth(19, 15 * 256); 
     							
     							
     							 
     							 	Font font = workbook.createFont();
     						       
     						        font.setBold(true);
     						       
     							 final HSSFCellStyle cellStyle = workbook.createCellStyle();

     							 cellStyle.setBorderBottom(BorderStyle.THIN);
     							 cellStyle.setBorderRight(BorderStyle.THIN);
     							 cellStyle.setBorderLeft(BorderStyle.THIN);
     							 cellStyle.setBorderTop(BorderStyle.THIN);
     							 cellStyle.setFont(font);
     							 cellStyle.setWrapText(true);
     							 
     							 final HSSFCellStyle cellStyleNonBold = workbook.createCellStyle();

     							 cellStyleNonBold.setBorderBottom(BorderStyle.THIN);
     							 cellStyleNonBold.setBorderRight(BorderStyle.THIN);
     							 cellStyleNonBold.setBorderLeft(BorderStyle.THIN);
     							 cellStyleNonBold.setBorderTop(BorderStyle.THIN);
     							 
     							 short s = 255-0-0;
     							 final HSSFCellStyle cellStyleBoldRed = workbook.createCellStyle();	 
     							 
     							 cellStyleBoldRed.setBorderBottom(BorderStyle.THIN);
     							 cellStyleBoldRed.setBorderRight(BorderStyle.THIN);
     							 cellStyleBoldRed.setBorderLeft(BorderStyle.THIN);
     							 cellStyleBoldRed.setBorderTop(BorderStyle.THIN);
     							 cellStyleBoldRed.setFillForegroundColor(s);
     							 cellStyleBoldRed.setFont(font);								 
     							 cellStyleBoldRed.setWrapText(true);
     							 
     							 HSSFRow rowHead = mySheet.createRow(0);							 
     							 
     							List<String> headers = new ArrayList<>();
     							headers.add("Date");
     							headers.add("Chalan No.");
     							headers.add("Vehicle No");
     							headers.add("Product Name");
     							headers.add("Qty");
     							headers.add("Rate");
     							headers.add("Material Cost");
     							headers.add("Taxable Amt");
     							headers.add("CGST");
     							headers.add("SGST");
     							headers.add("Tr Charges");
     							
     							if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
			        			  {
     								headers.add("Pump Amt");
     								headers.add("Labor Amt");
			        			  }
     							if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
     							    headers.add("Royalty");
     							}

     							
     							headers.add("Total Bill Amount");
     							headers.add("Amount Received");
     							headers.add("Due Amount");
     							headers.add("Address");
     							headers.add("Comments");
     							headers.add("Billed By");
     							
     							
     							for (int i = 0; i < headers.size(); i++) {
     							    Cell cell = rowHead.createCell(i);
     							    cell.setCellValue(headers.get(i));
     							    cell.setCellStyle(cellStyleBoldRed);
     							}
  							 
  							   		  	
					        				
     							 int rowCount = 1;
     							   for(CustomerAccountDetailsDAO dao:this.getCustomerAccountDetailsList())
     						       {
     										 HSSFRow rowData = mySheet.createRow(rowCount);
     										  
     										Cell cell1 = rowData.createCell(0);
     										cell1.setCellValue(dao.getDateAsString());
     										cell1.setCellStyle(cellStyleNonBold);

     										
     										Cell cell2 = rowData.createCell(1);
     										cell2.setCellValue(""+dao.getChalanNumber().replaceAll("\t", " "));
     										cell2.setCellStyle(cellStyleNonBold);

     										Cell cell3 = rowData.createCell(2);
     										cell3.setCellValue(""+dao.getVehicleNumber());
     										cell3.setCellStyle(cellStyleNonBold);

     										Cell cell4 = rowData.createCell(3);
     										cell4.setCellValue(""+dao.getItemNameAll());
     										cell4.setCellStyle(cellStyleNonBold);

     										Cell cell5 = rowData.createCell(4);
     										cell5.setCellValue(""+dao.getItemQuantityAll());
     										cell5.setCellStyle(cellStyleNonBold);

     										Cell cell6 = rowData.createCell(5);
     										cell6.setCellValue(""+dao.getItemRate());
     										cell6.setCellStyle(cellStyleNonBold);

     										Cell cell7 = rowData.createCell(6);
     										cell7.setCellValue(""+dao.getMaterialCost());
     										cell7.setCellStyle(cellStyleNonBold);

     										Cell cell8 = rowData.createCell(7);
     										cell8.setCellValue(""+dao.getTaxableAmt());
     										cell8.setCellStyle(cellStyleNonBold);

     										Cell cell9 = rowData.createCell(8);
     										cell9.setCellValue(""+dao.getCgst());
     										cell9.setCellStyle(cellStyleNonBold);

     										Cell cell10 = rowData.createCell(9);
     										cell10.setCellValue(""+dao.getSgst());
     										cell10.setCellStyle(cellStyleNonBold);

     										
     										Cell cell11 = rowData.createCell(10);
     										cell11.setCellValue(""+dao.getTransportationCharges());
     										cell11.setCellStyle(cellStyleNonBold);

     										int columnIndex = 11; 
     										
     										if ("1".equals(this.getSessionMap().get("rmcAllowed"))) 
     					        			  {
     											 Cell cellPumpAmt = rowData.createCell(columnIndex++);
     											cellPumpAmt.setCellValue(""+dao.getPumpAmount());
     											cellPumpAmt.setCellStyle(cellStyleNonBold);
      										    
      										  Cell cellLaborAmt = rowData.createCell(columnIndex++);
      										cellLaborAmt.setCellValue(""+dao.getLabourAmount());
      										cellLaborAmt.setCellStyle(cellStyleNonBold);
     					        			  }
     									
     										  
     										if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
     										    Cell cellRoyalty = rowData.createCell(columnIndex++);
     										    cellRoyalty.setCellValue(""+dao.getRoyalty());
     										    cellRoyalty.setCellStyle(cellStyleNonBold);
     										}
     										
     										Cell cell14 = rowData.createCell(columnIndex++);
     										cell14.setCellValue(dao.getBillAmount());
     										cell14.setCellStyle(cellStyleNonBold);

     										Cell cell15 = rowData.createCell(columnIndex++);
     										cell15.setCellValue(dao.getAmountPaid());
     										cell15.setCellStyle(cellStyleNonBold);

     										Cell cell16 = rowData.createCell(columnIndex++);
     										cell16.setCellValue(dao.getDueAmount());
     										cell16.setCellStyle(cellStyleNonBold);

     										Cell cell17 = rowData.createCell(columnIndex++);
     										cell17.setCellValue(dao.getTripTo());
     										cell17.setCellStyle(cellStyleNonBold);

     										Cell cell18 = rowData.createCell(columnIndex++);
     										cell18.setCellValue(dao.getComments());
     										cell18.setCellStyle(cellStyleNonBold);

     										Cell cell19 = rowData.createCell(columnIndex);
     										cell19.setCellValue(dao.getBilledBy());
     										cell19.setCellStyle(cellStyleNonBold);

     										 
     										 rowCount++;
     										 
     						       }
     						
     							   
     									
     							  HSSFRow totalRow = mySheet.createRow(rowCount);

     							Cell totalLabelCell = totalRow.createCell(0);
     							totalLabelCell.setCellValue("Total");
     							totalLabelCell.setCellStyle(cellStyleBoldRed);
     							mySheet.addMergedRegion(new CellRangeAddress(rowCount, rowCount, 0, 3)); 

     							for (int i = 1; i <= 3; i++) { 
     							    Cell emptyCell = totalRow.createCell(i);
     							    emptyCell.setCellStyle(cellStyleNonBold);
     							}

     							Cell materialTotalCell = totalRow.createCell(4);
     							materialTotalCell.setCellValue(this.getMaterialTotal());
     							materialTotalCell.setCellStyle(cellStyleNonBold);

     							
     							for (int i = 5; i <= 5; i++) { 
     							    Cell emptyCell = totalRow.createCell(i);
     							    emptyCell.setCellStyle(cellStyleNonBold);
     							}
     							
     							Cell materialCostTotalCell = totalRow.createCell(6);
     							materialCostTotalCell.setCellValue(this.getTotalMaterialCostAllTheTime());
     							materialCostTotalCell.setCellStyle(cellStyleNonBold);

     							Cell totalTaxableAmountCell = totalRow.createCell(7);
     							totalTaxableAmountCell.setCellValue(this.getTotalTaxableAmtAllTheTime());
     							totalTaxableAmountCell.setCellStyle(cellStyleNonBold);

     							Cell cgstTotalCell = totalRow.createCell(8);
     							cgstTotalCell.setCellValue(this.getTotalCgstAllTheTime());
     							cgstTotalCell.setCellStyle(cellStyleNonBold);

     							Cell sgstTotalCell = totalRow.createCell(9);
     							sgstTotalCell.setCellValue(this.getTotalSgstAllTheTime());
     							sgstTotalCell.setCellStyle(cellStyleNonBold);


     							Cell trChargesTotalCell = totalRow.createCell(10);
     							trChargesTotalCell.setCellValue(this.getTotalTrChargesAllTheTime());
     							trChargesTotalCell.setCellStyle(cellStyleNonBold);
     							int columnIndex = 11; 
									
     							if ("1".equals(this.getSessionMap().get("rmcAllowed"))) {
									  
     						   Cell totalPumpAmtCell = totalRow.createCell(columnIndex++);
     							totalPumpAmtCell.setCellValue(this.getTotalPumpAmtAllTheTime());
     							totalPumpAmtCell.setCellStyle(cellStyleNonBold);

     							
     							Cell totalLaborAmtCell = totalRow.createCell(columnIndex++);
     							totalLaborAmtCell.setCellValue(this.getTotalLaborAmtAllTheTime());
     							totalLaborAmtCell.setCellStyle(cellStyleNonBold);
     							}
     							
     							if ("1".equals(this.getSessionMap().get("royaltyAllowed"))) {
									  
     							Cell totalRoyaltyCell = totalRow.createCell(columnIndex++);
     							totalRoyaltyCell.setCellValue(this.getTotalRoyaltyAllTheTime());
     							totalRoyaltyCell.setCellStyle(cellStyleNonBold);
     							}
     							
     							Cell totalBillCell = totalRow.createCell(columnIndex++);
     							totalBillCell.setCellValue(this.getTotalBillAmountAllTheTime());
     							totalBillCell.setCellStyle(cellStyleNonBold);

     							
     							Cell totalPaidCell = totalRow.createCell(columnIndex++);
     							totalPaidCell.setCellValue(this.getTotalAmountPaidAllTheTime());
     							totalPaidCell.setCellStyle(cellStyleNonBold);

     							for (int i = columnIndex++; i <= 19; i++) { 
     							    Cell emptyCell = totalRow.createCell(i);
     							    emptyCell.setCellStyle(cellStyleNonBold);
     							}

     							
     						  
     							
     							rowCount += 2;

     							int prevColWidthProduct = mySheet.getColumnWidth(0);
     							int prevColWidthQuantity = mySheet.getColumnWidth(1);
     							int prevColWidthsalesUnit = mySheet.getColumnWidth(3);

     							mySheet.setColumnWidth(0, 25 * 300); 
     							mySheet.setColumnWidth(1, 15 * 300); 
     							mySheet.setColumnWidth(2, 15 * 300); 

     						
     							HSSFRow headerRow = mySheet.createRow(rowCount);
     							Cell headerCell1 = headerRow.createCell(0);
     							headerCell1.setCellValue("Product Name");
     							headerCell1.setCellStyle(cellStyleBoldRed); 

     							Cell headerCell2 = headerRow.createCell(1);
     							headerCell2.setCellValue("Total Quantity");
     							headerCell2.setCellStyle(cellStyleBoldRed); 

     							Cell headerCell3 = headerRow.createCell(2);
     							headerCell3.setCellValue("Sales Unit");
     							headerCell3.setCellStyle(cellStyleBoldRed); 

     							
     							rowCount++; 

     							for (Map<String, Object> pq : productQuantityList) {
     							    HSSFRow dataRow = mySheet.createRow(rowCount);
     							    
     							    
     							    String productName = pq.get("productName") != null ? pq.get("productName").toString() : "";
     							    float quantity = pq.get("quantity") != null ?  (float) pq.get("quantity") : 0.0f;
     							    String salesUnit = pq.get("salesUnit") != null ? pq.get("salesUnit").toString() : "";
     							   
     							    
     							    Cell productCell = dataRow.createCell(0);
     							    productCell.setCellValue(productName);
     							    productCell.setCellStyle(cellStyleNonBold);

     							    Cell quantityCel2 = dataRow.createCell(1);
     							    quantityCel2.setCellValue(""+quantity);
     							    quantityCel2.setCellStyle(cellStyleNonBold);
     							    
     							    Cell quantityCel3 = dataRow.createCell(2);
    							    quantityCel3.setCellValue(""+salesUnit);
    							    quantityCel3.setCellStyle(cellStyleNonBold);
    							    
    							    
     							    rowCount++; 
     							}

     							mySheet.setColumnWidth(0, prevColWidthProduct);
     							mySheet.setColumnWidth(1, prevColWidthQuantity);
     							mySheet.setColumnWidth(3, prevColWidthsalesUnit);

     							
     							
     							
     						rowCount += 2;

     						
     						int previousColumnWidth1 = mySheet.getColumnWidth(0);
     						int previousColumnWidth2 = mySheet.getColumnWidth(1);

     						mySheet.setColumnWidth(0, 20 * 300); 
     						mySheet.setColumnWidth(1, 35 * 300); 

     						List<String[]> totalData = new ArrayList<>();
     						totalData.add(new String[]{"Total Bill Amount:", "" + this.getTotalBillAmountAllTheTime()});
     						totalData.add(new String[]{"Total Amount Received:", "" + this.getTotalAmountPaidAllTheTime()});
     						totalData.add(new String[]{"Opening Balance Amount:", "" + this.getCustOpeningBalnce()});
     						totalData.add(new String[]{"Total Amount Outstanding:", "" + this.getTotalOutStandingAmountAllTheTime()});

     						for (String[] data : totalData) {
     						    HSSFRow totalRow1 = mySheet.createRow(rowCount);
     						    for (int i = 0; i < data.length; i++) {
     						        Cell cell = totalRow1.createCell(i);
     						        cell.setCellValue(data[i]);
     						        cell.setCellStyle(cellStyleBoldRed);
     						    }
     						    rowCount++;  
     						}

     						rowCount++;

     						mySheet.setColumnWidth(0, previousColumnWidth1);
     						mySheet.setColumnWidth(1, previousColumnWidth2);

     						
     						int previousColumnWidth11 = mySheet.getColumnWidth(0);
       						int previousColumnWidth21 = mySheet.getColumnWidth(1);

       						mySheet.setColumnWidth(0, 20 * 300); 
       						mySheet.setColumnWidth(1, 35 * 300); 

       						List<String[]> totalData1 = new ArrayList<>();
       						totalData1.add(new String[]{"Total Bill Amount Between Dates:", "" + this.getTotalBillAmountBetweenDates()});
       						totalData1.add(new String[]{"Total Amount Received Between Dates:", "" + this.getTotalAmountPaidBetweenDates()});
       						totalData1.add(new String[]{"Opening Balance Amount:", "" + this.getCustOpeningBalnce()});
       						totalData1.add(new String[]{"Total Amount Outstanding Between Dates:", "" + this.getTotalOutStandingAmountBetweenDates()});

       						for (String[] data : totalData1) {
       						    HSSFRow totalRow1 = mySheet.createRow(rowCount);
       						    for (int i = 0; i < data.length; i++) {
       						        Cell cell = totalRow1.createCell(i);
       						        cell.setCellValue(data[i]);
       						        cell.setCellStyle(cellStyleBoldRed);
       						    }
       						    rowCount++;  
       						}

       						rowCount++;

       						mySheet.setColumnWidth(0, previousColumnWidth11);
       						mySheet.setColumnWidth(1, previousColumnWidth21);

     					
     						
     						
     						
     							   FileOutputStream fileOut = new FileOutputStream(fileName);
     							   workbook.write(fileOut);
     					            fileOut.close();
     					            workbook.close();
     					            
     					    		response.setHeader("Content-disposition", "inline; filename="+""+fileName);
     								response.setContentType("application/xls");
     								FileInputStream fileInputStream = new FileInputStream(fileName);
     								PrintWriter out = response.getWriter();  
     								int bytes;
     								while ((bytes = fileInputStream.read()) != -1) {
     									out.write(bytes);
     								}
     								fileInputStream.close();
     								out.close();
     								
     								
     								
     						}
       						
       						
       						}
    						 
	    			
	    		}catch (SQLException e) {
	    			
	    			result = "error";
	    			e.printStackTrace();
	    			setReturnMessage(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    		} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
    			finally {
	    			if(resultSet != null)
					{
						try {
							resultSet.close(); resultSet = null;
						} catch (SQLException e) {
							
						}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
    		
	        }
}

public HttpServletRequest getRequest() {
	return request;
}

public void setRequest(HttpServletRequest request) {
	this.request = request;
}

public HttpServletResponse getResponse() {
	return response;
}

public void setResponse(HttpServletResponse response) {
	this.response = response;
}

public static long getSerialversionuid() {
	return serialVersionUID;
}

public HttpSession getSession() {
	return session;
}

public void setSession(HttpSession session) {
	this.session = session;
}

public String getReturnMessage() {
	return returnMessage;
}

public void setReturnMessage(String returnMessage) {
	this.returnMessage = returnMessage;
}


public String getFromDate() {
	return fromDate;
}

public void setFromDate(String fromDate) {
	this.fromDate = fromDate;
}

public String getToDate() {
	return toDate;
}

public void setToDate(String toDate) {
	this.toDate = toDate;
}

public String getTotalBillAmountBeforeDate() {
	return totalBillAmountBeforeDate;
}

public void setTotalBillAmountBeforeDate(String totalBillAmountBeforeDate) {
	this.totalBillAmountBeforeDate = totalBillAmountBeforeDate;
}

public String getTotalAmountPaidBeforeDate() {
	return totalAmountPaidBeforeDate;
}

public void setTotalAmountPaidBeforeDate(String totalAmountPaidBeforeDate) {
	this.totalAmountPaidBeforeDate = totalAmountPaidBeforeDate;
}

public String getTotalOutStandingAmountBeforeDate() {
	return totalOutStandingAmountBeforeDate;
}

public void setTotalOutStandingAmountBeforeDate(String totalOutStandingAmountBeforeDate) {
	this.totalOutStandingAmountBeforeDate = totalOutStandingAmountBeforeDate;
}

public String getTotalBillAmountAllTheTime() {
	return totalBillAmountAllTheTime;
}

public void setTotalBillAmountAllTheTime(String totalBillAmountAllTheTime) {
	this.totalBillAmountAllTheTime = totalBillAmountAllTheTime;
}

public String getTotalAmountPaidAllTheTime() {
	return totalAmountPaidAllTheTime;
}

public void setTotalAmountPaidAllTheTime(String totalAmountPaidAllTheTime) {
	this.totalAmountPaidAllTheTime = totalAmountPaidAllTheTime;
}

public String getTotalOutStandingAmountAllTheTime() {
	return totalOutStandingAmountAllTheTime;
}

public void setTotalOutStandingAmountAllTheTime(String totalOutStandingAmountAllTheTime) {
	this.totalOutStandingAmountAllTheTime = totalOutStandingAmountAllTheTime;
}

public String getSmsData() {
	return smsData;
}

public void setSmsData(String smsData) {
	this.smsData = smsData;
}

public List<CustomerAccountDetailsDAO> getCustomerAccountDetailsList() {
	return customerAccountDetailsList;
}

public void setCustomerAccountDetailsList(List<CustomerAccountDetailsDAO> customerAccountDetailsList) {
	this.customerAccountDetailsList = customerAccountDetailsList;
}

public List<CustomerAccountDetailsDAO> getCustomerAccountDetailsSoretdList() {
	return customerAccountDetailsSoretdList;
}

public void setCustomerAccountDetailsSoretdList(List<CustomerAccountDetailsDAO> customerAccountDetailsSoretdList) {
	this.customerAccountDetailsSoretdList = customerAccountDetailsSoretdList;
}

public Float getCustOpeningBalnce() {
	return custOpeningBalnce;
}

public void setCustOpeningBalnce(Float custOpeningBalnce) {
	this.custOpeningBalnce = custOpeningBalnce;
}

public String getOpeingBalancUpdatedBy() {
	return opeingBalancUpdatedBy;
}

public void setOpeingBalancUpdatedBy(String opeingBalancUpdatedBy) {
	this.opeingBalancUpdatedBy = opeingBalancUpdatedBy;
}

public String getOpeingBalanceUpdateDate() {
	return opeingBalanceUpdateDate;
}

public void setOpeingBalanceUpdateDate(String opeingBalanceUpdateDate) {
	this.opeingBalanceUpdateDate = opeingBalanceUpdateDate;
}

public String getKey() {
	return key;
}

public void setKey(String key) {
	this.key = key;
}




public String getTotal6mm() {
	return total6mm;
}

public void setTotal6mm(String total6mm) {
	this.total6mm = total6mm;
}

public String getTotal10mm() {
	return total10mm;
}

public void setTotal10mm(String total10mm) {
	this.total10mm = total10mm;
}

public String getTotal20mm() {
	return total20mm;
}

public void setTotal20mm(String total20mm) {
	this.total20mm = total20mm;
}

public String getTotal40mm() {
	return total40mm;
}

public void setTotal40mm(String total40mm) {
	this.total40mm = total40mm;
}


public String getTotalCSand() {
	return totalCSand;
}

public void setTotalCSand(String totalCSand) {
	this.totalCSand = totalCSand;
}

public String getTotalDust() {
	return totalDust;
}

public void setTotalDust(String totalDust) {
	this.totalDust = totalDust;
}

public String getTotalPS() {
	return totalPS;
}

public void setTotalPS(String totalPS) {
	this.totalPS = totalPS;
}

public String getTotalPowder() {
	return totalPowder;
}

public void setTotalPowder(String totalPowder) {
	this.totalPowder = totalPowder;
}

public String getTotalOther() {
	return totalOther;
}

public void setTotalOther(String totalOther) {
	this.totalOther = totalOther;
}


public SessionMap<String, Object> getSessionMap() {
return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
this.sessionMap = sessionMap;
}

public void setSession(Map<String, Object> map) {  
sessionMap=(SessionMap<String, Object>)map;  
}

public Float getMaterialTotal() {
	return materialTotal;
}

public void setMaterialTotal(Float materialTotal) {
	this.materialTotal = materialTotal;
}

public Float getTotalRoyaltyAllTheTime() {
	return totalRoyaltyAllTheTime;
}

public void setTotalRoyaltyAllTheTime(Float totalRoyaltyAllTheTime) {
	this.totalRoyaltyAllTheTime = totalRoyaltyAllTheTime;
}

public String getType() {
	return type;
}

public void setType(String type) {
	this.type = type;
}

public List<String> getTypeList() {
	return typeList;
}

public void setTypeList(List<String> typeList) {
	this.typeList = typeList;
}

public List<Map<String, Object>> getProductQuantityList() {
	return productQuantityList;
}

public void setProductQuantityList(List<Map<String, Object>> productQuantityList) {
	this.productQuantityList = productQuantityList;
}

public List<String> getDownloadTypeList() {
	return downloadTypeList;
}

public void setDownloadTypeList(List<String> downloadTypeList) {
	this.downloadTypeList = downloadTypeList;
}

public String getDownloadType() {
	return downloadType;
}

public void setDownloadType(String downloadType) {
	this.downloadType = downloadType;
}

public float getTotalBillAmountBetweenDates() {
	return totalBillAmountBetweenDates;
}

public void setTotalBillAmountBetweenDates(float totalBillAmountBetweenDates) {
	this.totalBillAmountBetweenDates = totalBillAmountBetweenDates;
}

public float getTotalAmountPaidBetweenDates() {
	return totalAmountPaidBetweenDates;
}

public void setTotalAmountPaidBetweenDates(float totalAmountPaidBetweenDates) {
	this.totalAmountPaidBetweenDates = totalAmountPaidBetweenDates;
}

public float getTotalOutStandingAmountBetweenDates() {
	return totalOutStandingAmountBetweenDates;
}

public void setTotalOutStandingAmountBetweenDates(float totalOutStandingAmountBetweenDates) {
	this.totalOutStandingAmountBetweenDates = totalOutStandingAmountBetweenDates;
}

public Float getTotalTrChargesAllTheTime() {
	return totalTrChargesAllTheTime;
}

public void setTotalTrChargesAllTheTime(Float totalTrChargesAllTheTime) {
	this.totalTrChargesAllTheTime = totalTrChargesAllTheTime;
}

public Float getTotalMaterialCostAllTheTime() {
	return totalMaterialCostAllTheTime;
}

public void setTotalMaterialCostAllTheTime(Float totalMaterialCostAllTheTime) {
	this.totalMaterialCostAllTheTime = totalMaterialCostAllTheTime;
}

public Float getTotalPumpAmtAllTheTime() {
	return totalPumpAmtAllTheTime;
}

public void setTotalPumpAmtAllTheTime(Float totalPumpAmtAllTheTime) {
	this.totalPumpAmtAllTheTime = totalPumpAmtAllTheTime;
}

public Float getTotalLaborAmtAllTheTime() {
	return totalLaborAmtAllTheTime;
}

public void setTotalLaborAmtAllTheTime(Float totalLaborAmtAllTheTime) {
	this.totalLaborAmtAllTheTime = totalLaborAmtAllTheTime;
}

public String getCrusherAccount() {
	return crusherAccount;
}

public void setCrusherAccount(String crusherAccount) {
	this.crusherAccount = crusherAccount;
}

public Float getTotalTaxableAmtAllTheTime() {
	return totalTaxableAmtAllTheTime;
}

public void setTotalTaxableAmtAllTheTime(Float totalTaxableAmtAllTheTime) {
	this.totalTaxableAmtAllTheTime = totalTaxableAmtAllTheTime;
}

public Float getTotalCgstAllTheTime() {
	return totalCgstAllTheTime;
}

public void setTotalCgstAllTheTime(Float totalCgstAllTheTime) {
	this.totalCgstAllTheTime = totalCgstAllTheTime;
}

public Float getTotalSgstAllTheTime() {
	return totalSgstAllTheTime;
}

public void setTotalSgstAllTheTime(Float totalSgstAllTheTime) {
	this.totalSgstAllTheTime = totalSgstAllTheTime;
}


}
