package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.DayWiseCollectionDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadCollectionReportDayWiseReport extends ActionSupport implements SessionAware{

	

	/**
	 * 
	 */
	private static final long serialVersionUID = 7912303984103717831L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

    private String fromDate;
	private String toDate;
	private HttpSession session;
	private List<DayWiseCollectionDAO> collectionDAOList = new ArrayList<DayWiseCollectionDAO>();
	private String defaultValue;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	
	private String totalBilling;
	private String totalCashCollected;
	private String totalCreditCollected;
	private String totalCreditGiven;
	private String totalCollection;
	private String addSideBarJs;
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();
			
			downloadTypeList.add("pdf");
	    	downloadTypeList.add("xl");
	    	
    		String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    	
        	
        	Connection connection = null;
    		PreparedStatement preparedStatement= null;
    		ResultSet resultSet = null;
    	 
    		String sql = "";
    		String db = (String) session.getAttribute("db");
    		
    		try
    		{
    			
				connection = GetDBConnection.getDBConnection(db);
    			
    			 Date fromD=new SimpleDateFormat("dd-MM-yyyy").parse(this.getFromDate());  
    			 Date toD=new SimpleDateFormat("dd-MM-yyyy").parse(this.getToDate());  
    			 DateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy");
    			 
    			 long diff = toD.getTime() -fromD.getTime() ;
    			
    			 long fromDateMillies = fromD.getTime();
    			 
    			 
    			 List<String> listOfDays = new ArrayList<String>();
    			 
    			
    			 	listOfDays.add(this.getFromDate());
    			 	
    				long diffDays = diff / (24 * 60 * 60 * 1000);
    				
    				int intDays = Integer.parseInt(""+diffDays);
    				
    				for(int i = intDays;i>0;i--)
    				{
    					fromDateMillies = fromDateMillies+(24 * 60 * 60 * 1000);
    					Date d = new Date(fromDateMillies);	    					
    					listOfDays.add(dateFormat.format(d));    					
    				}
    				
    				 float floatTotalBilling=0.0F;
    				 float floatTotalCashCollected=0.0F;
    				 float floatTotalCreditCollected=0.0F;
    				 float floatTotalCreditGiven=0.0F;
    				 float floatTotalCollection=0.0F;
    				 
    				
    				
    				for(int i = 0;i<listOfDays.size();i++)
    				{
    					
    					
    					DayWiseCollectionDAO collectionDAO = new DayWiseCollectionDAO();
    					
    					
    					// cash collection 
    					sql = "SELECT "
    	    					+ "bill_date,"
    	    					+ "bill_total_amount,"
    	    					+ "bill_amount_received,"
    	    					+ "bill_amount_return "
    	    					+ "FROM "
    	    					+ "crusher_bill_info_master "
    	    					+ "WHERE "
    	    					+ "bill_date = STR_TO_DATE(?, '%d-%m-%Y') "
    	    					+ "AND "
    	    					+ "crusher_id = ? "
    	    					+ "AND "
    	    					+ "crusher_code = ? ";
    	    			
    	    			preparedStatement =connection.prepareStatement(sql);
    	    			preparedStatement.setString(1, listOfDays.get(i));
    	    			preparedStatement.setString(2, crusherId);
    	    			preparedStatement.setString(3, crusherCode);
    	    			
    	    			resultSet = preparedStatement.executeQuery();
    	    			
    	    			float totalBillAmount = 0.0F;
    	    			float totalCreditGiven = 0.0F;
    	    			float totalAmountCollected = 0.0F;
    	    			float totalCreditCollection =0.0F;
    	    			while(resultSet.next())	    				
    	    			{
    	    				
	    				if(resultSet.getString(2) != null && resultSet.getString(3) != null && resultSet.getString(4) != null)
	    				{
    	    				totalBillAmount = totalBillAmount + (Float.parseFloat(resultSet.getString(2)));
    	    				
    	    				float amtReceived = Float.parseFloat(resultSet.getString(3));
    	    				float amountReturn  = Float.parseFloat(resultSet.getString(4));
    	    				
    	    				if(amountReturn > 0 )
    	    				{
    	    					totalAmountCollected = totalAmountCollected + Float.parseFloat(resultSet.getString(2));
    	    				}
    	    				else
    	    				{
    	    					totalAmountCollected = totalAmountCollected + amtReceived;
    	    					totalCreditGiven = totalCreditGiven 
    	    							+ (Float.parseFloat(resultSet.getString(2)) - amtReceived);
    	    				}
    	    				
    	    				
    	    			}
    	    			
    	    			
    	    		}
    	    			sql = "SELECT sum(amount) "
    	    					+ "FROM "
    	    					+ "crusher_customer_payment_details_master "
    	    					+ "WHERE "
    	    					+ "payment_date = STR_TO_DATE(?, '%d-%m-%Y') "
    	    					+ "AND "
    	    					+ "crusher_id = ? "
    	    					+ "AND "
    	    					+ "crusher_code = ? ";
    	    			
    	    			PreparedStatement ps = connection.prepareStatement(sql);
    	    			
    	    			ps.setString(1, listOfDays.get(i));
    	    			ps.setString(2, crusherId);
    	    			ps.setString(3, crusherCode);
    	    			
    	    			ResultSet rs = ps.executeQuery();
    	    			
    	    			
    	    			if(rs.next())
    	    			{
    	    				try
    	    				{
	    	    				if(rs.getString(1) != null)
	    	    				{
	    	    				
	    	    					totalCreditCollection = Float.parseFloat(rs.getString(1));
	    	    				}
	    	    				else
	    	    				{
	    	    					totalCreditCollection = 0.0F;
	    	    				}
    	    				}catch(NumberFormatException nfe)
    	    				{}
    	    			}
    	    			
    	    			collectionDAO.setCollectionDate(listOfDays.get(i));
    	    			collectionDAO.setTotalBilling(""+totalBillAmount);
    	    			collectionDAO.setTotalCashCollection(""+totalAmountCollected);
    	    			collectionDAO.setTotalCreditCollection(""+totalCreditCollection);
    	    			collectionDAO.setTotalCreeditGiven(""+totalCreditGiven);
    	    			collectionDAO.setTotalCollection(""+(totalCreditCollection+totalAmountCollected));
    	    			
    	    			floatTotalBilling = floatTotalBilling+ totalBillAmount;
    	    			floatTotalCashCollected = floatTotalCashCollected + totalAmountCollected;
    	    			floatTotalCreditCollected = floatTotalCreditCollected + totalCreditCollection;
    	    			floatTotalCreditGiven = floatTotalCreditGiven + totalCreditGiven;
    	    			floatTotalCollection = floatTotalCollection + (totalCreditCollection+totalAmountCollected);
    	    			
    	    			
    	    			collectionDAOList.add(collectionDAO);	
    	    			
    	    			if(rs != null)
    	    			{
    	    				rs.close();
    	    				rs = null;
    	    			}
    	    			if(ps != null)
    	    			{
    	    				ps.close();
    	    				ps = null;
    	    			}
    				}
    				
    				
    				this.setTotalBilling(""+floatTotalBilling);
    				this.setTotalCashCollected(""+floatTotalCashCollected);
    				this.setTotalCreditCollected(""+floatTotalCreditCollected);
    				this.setTotalCreditGiven(""+floatTotalCreditGiven);
    				this.setTotalCollection(""+floatTotalCollection);
    				
    				this.setAddSideBarJs("FALSE");
    				
    				
    				
    				
    			
    		 	@SuppressWarnings("unchecked")
    			String crusherName = (String) this.getSessionMap().get("crushernameenglish");
    		     
    			
				if(this.getDownloadType().equals("pdf"))
				{
					
				
    			
    			String path=	request.getSession().getServletContext().getRealPath("/images/");
    			PDDocument document = new PDDocument(); 
				PDPage page = null;
				
				
					 page = new PDPage(PDRectangle.A4);
				
				
			        document.addPage(page);
			         PDPageContentStream contentStream = new PDPageContentStream(document, page);
			         int pageCount = 1;
		    			 Table header;
		    			 Table creditDetails;
		    			 
		    			
		    			  TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row info1 = Row.builder()
					                .add(TextCell.builder().text("Collection Report DayWise "
					                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info2 = Row.builder()
					                .add(TextCell.builder().text("From Date : "
					                		+ ""+this.getFromDate()
					                		+ " and To Date :"+this.getToDate() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				          
				          tableHeaderBuilder.addRow(headerName);
				          tableHeaderBuilder.addRow(info1);
				          tableHeaderBuilder.addRow(info2);
				          header = tableHeaderBuilder.build();
				          
				          
				          TableBuilder tableDebtDetailsBuilder = Table.builder()
					                .addColumnsOfWidth(80, 100, 80, 80, 80,60)		                
					                .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				          
				          Row tableHeader = Row.builder()
				        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Billing Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Cash Collected").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Credit Collected").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Credit Given").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Collection").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          tableDebtDetailsBuilder.addRow(tableHeader);
				       
				        
				     
				        	  int size = this.getCollectionDAOList().size() ;
				        	  
				        	  
					          float startY = page.getMediaBox().getHeight() - PADDING20;
					          float currentY = startY;
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
					          
					          
					          
					    	  for(int s=0;s<size;s++)
				        	  {
				        		 if(currentY < 97)
				        		  {
				        			  pageCount++;
				        			  creditDetails = tableDebtDetailsBuilder.build();
				        			  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(creditDetails)
						                .startX(PADDING30)
						                .startY(startY-50)
						                .build()
						                .draw();
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			 
						    			 
						    			
						    			  tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(550)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								           headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								           info1 = Row.builder()
									                .add(TextCell.builder().text("Collection Report DayWise "
								                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
								           info2 = Row.builder()
									                .add(TextCell.builder().text("From Date : "
									                		+ ""+this.getFromDate()
									                		+ " and To Date :"+this.getToDate() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								          header = tableHeaderBuilder.build();
				        			  
				        			  creditDetails = null;
				        			   tableDebtDetailsBuilder = Table.builder()
				        					   .addColumnsOfWidth(80, 100, 80, 80, 80,60)
								                .font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							           tableHeader = Row.builder()
							        		   .add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text("Billing Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Cash Collected").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Credit Collected").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Credit Given").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Collection").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          tableDebtDetailsBuilder.addRow(tableHeader);
							          
				        			  
				        				PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
				        		  }
				        		  
				        		  DayWiseCollectionDAO dao2 = this.getCollectionDAOList().get(s);
				        		  
				        			Row supplierInfo = Row.builder()
				        					.add(TextCell.builder().text(dao2.getCollectionDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getTotalBilling()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getTotalCashCollection()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getTotalCreditCollection()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getTotalCreeditGiven()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getTotalCollection()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableDebtDetailsBuilder.addRow(supplierInfo);
					        	 
					        	  currentY = currentY -25;
				        	  }
					          
					    	  Row custInfo = Row.builder()
					    			   .add(TextCell.builder().text("Total").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			   .add(TextCell.builder().text("" + this.getTotalBilling()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			   .add(TextCell.builder().text("" + this.getTotalCashCollected()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			   .add(TextCell.builder().text("" + this.getTotalCreditCollected()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			   .add(TextCell.builder().text("" + this.getTotalCreditGiven()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			   .add(TextCell.builder().text("" + this.getTotalCollection()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(1F).build())                
					    			    .backgroundColor(Color.WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD)
						                .fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .height(15F)					                
						                .build();
				        	  
				        	  tableDebtDetailsBuilder.addRow(custInfo);
				        	  creditDetails = tableDebtDetailsBuilder.build();
				         
				          
				          TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(creditDetails)
			                .startX(PADDING30)
			                .startY(startY-50)
			                .build()
			                .draw();
				          contentStream.close();
					          
					          
					          
					          document.save(path+"/collection-dayWise-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-report.pdf");
						        document.close();
						        
						        response.setHeader("Content-disposition", "inline; filename=collection-dayWise-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-report.pdf");
								response.setContentType("application/pdf");
								
								FileInputStream fileInputStream = new FileInputStream(path+"/collection-dayWise-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-report.pdf");
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.flush();
								out.close();
								
				}
				
				if(this.getDownloadType().equals("xl"))
				{

					String fileName = "collection-dayWise-report-"+this.getFromDate()+"-to-"+this.getToDate()+".xls";
					 HSSFWorkbook workbook = new HSSFWorkbook();
					  HSSFSheet mySheet = workbook.createSheet("collection-dayWise-"+this.getFromDate()+"-to-"+this.getToDate());  
					
					  mySheet.setColumnWidth(0, 15 * 256); 
					  mySheet.setColumnWidth(1, 15 * 256); 
					  mySheet.setColumnWidth(2, 15 * 256); 
					  mySheet.setColumnWidth(3, 15 * 256); 
					  mySheet.setColumnWidth(4, 15 * 256); 
					  mySheet.setColumnWidth(5, 15 * 256); 
					 

					
					 
					 	Font font = workbook.createFont();
				       
				        font.setBold(true);
				       
					 final HSSFCellStyle cellStyle = workbook.createCellStyle();

					 cellStyle.setBorderBottom(BorderStyle.THIN);
					 cellStyle.setBorderRight(BorderStyle.THIN);
					 cellStyle.setBorderLeft(BorderStyle.THIN);
					 cellStyle.setBorderTop(BorderStyle.THIN);
					 cellStyle.setFont(font);
					 cellStyle.setWrapText(true);
					 
					 final HSSFCellStyle cellStyleNonBold = workbook.createCellStyle();

					 cellStyleNonBold.setBorderBottom(BorderStyle.THIN);
					 cellStyleNonBold.setBorderRight(BorderStyle.THIN);
					 cellStyleNonBold.setBorderLeft(BorderStyle.THIN);
					 cellStyleNonBold.setBorderTop(BorderStyle.THIN);
					 
					 short s = 255-0-0;
					 final HSSFCellStyle cellStyleBoldRed = workbook.createCellStyle();	 
					 
					 cellStyleBoldRed.setBorderBottom(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderRight(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderLeft(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderTop(BorderStyle.THIN);
					 cellStyleBoldRed.setFillForegroundColor(s);
					 cellStyleBoldRed.setFont(font);								 
					 cellStyleBoldRed.setWrapText(true);
					 
					 HSSFRow rowHead = mySheet.createRow(0);							 
					 
					 Cell cellHead1 = rowHead.createCell(0);
					 cellHead1.setCellValue("Date");
					 cellHead1.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead2 = rowHead.createCell(1);
					 cellHead2.setCellValue("Billing Amount");
					 cellHead2.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead3 = rowHead.createCell(2);
					 cellHead3.setCellValue("Cash Collected");
					 cellHead3.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead4 = rowHead.createCell(3);
					 cellHead4.setCellValue("Credit Collected");
					 cellHead4.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead5 = rowHead.createCell(4);
					 cellHead5.setCellValue("Credit Given");
					 cellHead5.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead6 = rowHead.createCell(5);
					 cellHead6.setCellValue("Collection");
					 cellHead6.setCellStyle(cellStyleBoldRed);
					 
					 
					 
					 int rowCount = 1;
					   for(DayWiseCollectionDAO dao:this.getCollectionDAOList())
				       {
								 HSSFRow rowData = mySheet.createRow(rowCount);
								  
								 
								 
								 Cell cell1 = rowData.createCell(0);
								 cell1.setCellValue(dao.getCollectionDate());
								 cell1.setCellStyle(cellStyleNonBold);
								 
								 Cell cell2 = rowData.createCell(1);
								 cell2.setCellValue(dao.getTotalBilling());
								 cell2.setCellStyle(cellStyleNonBold);
								 
								  
								Cell cell3 = rowData.createCell(2);
								 cell3.setCellValue(dao.getTotalCashCollection());
								 cell3.setCellStyle(cellStyleNonBold);
								 
								 Cell cell4 = rowData.createCell(3);
								 cell4.setCellValue(dao.getTotalCreditCollection());
								 cell4.setCellStyle(cellStyleNonBold);
								 
								 
								 Cell cell5 = rowData.createCell(4);
								 cell5.setCellValue(dao.getTotalCreeditGiven());
								 cell5.setCellStyle(cellStyleNonBold);
								 
								 Cell cell6 = rowData.createCell(5);
								 cell6.setCellValue(dao.getTotalCollection());
								 cell6.setCellStyle(cellStyleNonBold);
								 
								

								
								
								 
								 
								 rowCount++;
								 
				       }
					   
					   HSSFRow totalRow = mySheet.createRow(rowCount);

					
					
					Cell totalLabelCell = totalRow.createCell(0);
					totalLabelCell.setCellValue("Total");
					totalLabelCell.setCellStyle(cellStyleBoldRed); 

					Cell totalBillingCell = totalRow.createCell(1);
					totalBillingCell.setCellValue(this.getTotalBilling());
					totalBillingCell.setCellStyle(cellStyleBoldRed); 

					Cell totalCashCollectedCell = totalRow.createCell(2);
					totalCashCollectedCell.setCellValue(this.getTotalCashCollected());
					totalCashCollectedCell.setCellStyle(cellStyleBoldRed); 

					Cell totalCreditCollectedCell = totalRow.createCell(3);
					totalCreditCollectedCell.setCellValue(this.getTotalCreditCollected());
					totalCreditCollectedCell.setCellStyle(cellStyleBoldRed); 

					Cell totalTotalCreditGivenCell = totalRow.createCell(4);
					totalTotalCreditGivenCell.setCellValue(this.getTotalCreditGiven());
					totalTotalCreditGivenCell.setCellStyle(cellStyleBoldRed); 

					Cell totalTotalCollectionCell = totalRow.createCell(5);
					totalTotalCollectionCell.setCellValue(this.getTotalCollection());
					totalTotalCollectionCell.setCellStyle(cellStyleBoldRed); 

					
					
					
					   
					
					   
					   FileOutputStream fileOut = new FileOutputStream(fileName);
					   workbook.write(fileOut);
			            fileOut.close();
			            workbook.close();
			            
			    		response.setHeader("Content-disposition", "inline; filename="+""+fileName);
						response.setContentType("application/xls");
						FileInputStream fileInputStream = new FileInputStream(fileName);
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.close();
				}
    			
    		}
    		catch (SQLException e) 
    		{
	    		 e.printStackTrace();
	    				    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    			
	    	} catch (Exception e) {
	    		
	    		e.printStackTrace();	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || Something Went Wrong!");
	    	}
    			finally {
    				if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
        }
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	


	


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}


	public List<DayWiseCollectionDAO> getCollectionDAOList() {
		return collectionDAOList;
	}


	public void setCollectionDAOList(List<DayWiseCollectionDAO> collectionDAOList) {
		this.collectionDAOList = collectionDAOList;
	}


	public String getDefaultValue() {
		return defaultValue;
	}


	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}


	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}


	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}


	public String getCustomerSearchOption() {
		return customerSearchOption;
	}


	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}


	public String getTotalBilling() {
		return totalBilling;
	}


	public void setTotalBilling(String totalBilling) {
		this.totalBilling = totalBilling;
	}


	public String getTotalCashCollected() {
		return totalCashCollected;
	}


	public void setTotalCashCollected(String totalCashCollected) {
		this.totalCashCollected = totalCashCollected;
	}


	public String getTotalCreditCollected() {
		return totalCreditCollected;
	}


	public void setTotalCreditCollected(String totalCreditCollected) {
		this.totalCreditCollected = totalCreditCollected;
	}


	public String getTotalCreditGiven() {
		return totalCreditGiven;
	}


	public void setTotalCreditGiven(String totalCreditGiven) {
		this.totalCreditGiven = totalCreditGiven;
	}


	public String getTotalCollection() {
		return totalCollection;
	}


	public void setTotalCollection(String totalCollection) {
		this.totalCollection = totalCollection;
	}


	
	

}
