package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.ChequeInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DownloadChequeReport extends ActionSupport implements SessionAware{

	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -6518504550647859506L;
	public HttpServletRequest request;
	public HttpServletResponse response;
	private SessionMap<String,Object> sessionMap;
	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

    private HttpSession session;
	private String fromDate;
	private String toDate;
	private String bankName;
	private String branchName;
	private String chequeStatus;
	private String addSideBarJs;
	
	private List<ChequeInfoDAO> chequeInfoList = new ArrayList<ChequeInfoDAO>();
	
	private List<String> bankList = new ArrayList<String>();
	private List<String> branchList = new ArrayList<String>();	
	private List<String> chequeSatusList = new ArrayList<String>();
	private List<String> downloadTypeList = new ArrayList<String>();
	private String downloadType;
	
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();
			
			downloadTypeList.add("pdf");
	    	downloadTypeList.add("xl");
		
        	
        	Connection connection = null;
    		PreparedStatement preparedStatement= null;
    		ResultSet resultSet = null;
    	 
    		String sql = "";
    		String db = (String) session.getAttribute("db");
    		String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    	
    		try
    		{
    			
				connection = GetDBConnection.getDBConnection(db);
    			
				if(this.getChequeStatus().equals("ALL"))
	    		{
	    			
	    			sql = "SELECT "
	    					+ "cheque_book_add_date,"
	    					+ "cheque_book_bank_name,"
	    					+ "cheque_book_branch_name,"
	    					+ "cheque_book_account_number,"
	    					+ "cheque_book_account_holder_name,"
	    					+ "cheque_number,"
	    					+ "DATE_FORMAT(cheuqe_pay_date,'%d-%M-%Y'),"
	    					+ "cheque_payee,"
	    					+ "cheque_amount,"
	    					+ "cheque_status,"
	    					+ "DATE_FORMAT(chaque_status_change_date,'%d-%M-%Y'),"
	    					+ "reason_for_cheque_given,"
	    					+ "status_changed_by "
	    					+ "FROM "
	    					+ "cheque_book_details_master "
	    					+ "WHERE "
	    					+ "cheque_book_bank_name = ? "
	    					+ "AND "
	    					+ "cheque_book_branch_name = ? "
	    					+ "AND "
	    					+ "(cheque_book_add_date "
	    					+ "BETWEEN "
	    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
	    					+ "AND "
	    					+ "crusher_id = ? "
	    					+ "AND "
	    					+ "crusher_code = ? ";
	    			
	    			preparedStatement = connection.prepareStatement(sql);
	    			
	    			preparedStatement.setString(1, this.getBankName());
	    			preparedStatement.setString(2, this.getBranchName());
	    			preparedStatement.setString(3, this.getFromDate());
	    			preparedStatement.setString(4, this.getToDate());
	    			preparedStatement.setString(5, crusherId);
	    			preparedStatement.setString(6, crusherCode);
	    			
	    			}
	    			else
	    			{
	    				sql = "SELECT "
		    					+ "DATE_FORMAT(cheque_book_add_date,'%d-%M-%Y'),"
		    					+ "cheque_book_bank_name,"
		    					+ "cheque_book_branch_name,"
		    					+ "cheque_book_account_number,"
		    					+ "cheque_book_account_holder_name,"
		    					+ "cheque_number,"
		    					+ "DATE_FORMAT(cheuqe_pay_date,'%d-%M-%Y'),"
		    					+ "cheque_payee,"
		    					+ "cheque_amount,"
		    					+ "cheque_status,"
		    					+ "DATE_FORMAT(chaque_status_change_date,'%d-%M-%Y'),"
		    					+ "reason_for_cheque_given,"
		    					+ "status_changed_by "
		    					+ "FROM "
		    					+ "cheque_book_details_master "
		    					+ "WHERE "
		    					+ "cheque_book_bank_name = ? "
		    					+ "AND "
		    					+ "cheque_book_branch_name = ? "
		    					+ "AND "
		    					+ "cheque_status = ? "
			    				+ "AND "
		    					+ "(cheque_book_add_date "
		    					+ "BETWEEN "
		    					+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
		    					+ "AND "
		    					+ "crusher_id = ? "
		    					+ "AND "
		    					+ "crusher_code = ? ";

		    			preparedStatement = connection.prepareStatement(sql);
		    			
	    				preparedStatement.setString(1, this.getBankName());
		    			preparedStatement.setString(2, this.getBranchName());
		    			preparedStatement.setString(3, this.getChequeStatus());
		    			preparedStatement.setString(4, this.getFromDate());
		    			preparedStatement.setString(5, this.getToDate());
		    			preparedStatement.setString(6, crusherId);
		    			preparedStatement.setString(7, crusherCode);
		    			
	    			}
	    		
    		
    		
    			resultSet = preparedStatement.executeQuery();
    			resultSet.last();
    			
    			int rowCount = resultSet.getRow();
    			
    			resultSet.beforeFirst();
    			
    			if(rowCount > 0 )
    			{
    				while(resultSet.next())
    				{
    					ChequeInfoDAO dao = new ChequeInfoDAO();
    					
    					dao.setChequeBookAddDate(resultSet.getString(1));
    					dao.setBankName(resultSet.getString(2));
    					dao.setBranchName(resultSet.getString(3));
    					dao.setAccountNumber(resultSet.getString(4));
    					dao.setAccHolderName(resultSet.getString(5));
    					dao.setChequeNumber(resultSet.getString(6));
    					dao.setChequePayDate(resultSet.getString(7));
    					dao.setChequePayee(resultSet.getString(8));
    					dao.setAmount(resultSet.getString(9));
    					dao.setStatus(resultSet.getString(10));
    					dao.setStatusChangeDate(resultSet.getString(11));
    					dao.setReason(resultSet.getString(12));
    					dao.setStatusChangedBy(resultSet.getString(13));
    					dao.setKey(URLEncoder.encode
    							(EncryptionDecryption.encrypt
    									(resultSet.getString(2)
    									+"#"+resultSet.getString(3)
    									+"#"+resultSet.getString(4)
    									+"#"+resultSet.getString(6)),"UTF-8"));
    					
    					//KEY = BANK_NAME#BRANCH_NAME#ACC_NUMBER#CHEQUE_NUMBER
    					
    				
    					this.getChequeInfoList().add(dao);
    					
    				}
    				
    				
    			}
    			else
    			{
    				
    				addActionError("Records not found!");
    			}
    			
    			
    			
    			
    			
    			
    		 	@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
	     
				if(this.getDownloadType().equals("pdf"))
				{
					
				
    			
    			String path=	request.getSession().getServletContext().getRealPath("/images/");
    			PDDocument document = new PDDocument(); 
				PDPage page = null;
				
				
					 page = new PDPage(PDRectangle.A4);
				
				
			        document.addPage(page);
			         PDPageContentStream contentStream = new PDPageContentStream(document, page);
			         int pageCount = 1;
		    			 Table header;
		    			 Table creditDetails;
		    			 
		    			
		    			  TableBuilder tableHeaderBuilder = Table.builder()
					                .addColumnsOfWidth(550)				                
					                .font(HELVETICA)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				         
				          Row headerName = Row.builder()
					                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          
				          Row info1 = Row.builder()
					                .add(TextCell.builder().text("Cheque Report  "
					                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
					                .horizontalAlignment(CENTER)
					                .build();
				          
				          Row info2 = Row.builder()
					                .add(TextCell.builder().text("From Date : "
					                		+ ""+this.getFromDate()
					                		+ " and To Date :"+this.getToDate() +" Bank : " + this.getBankName()+" Branch : " + this.getBranchName()+" Cheque Status : " + this.getChequeStatus() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
					                .backgroundColor(WHITE)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
					                .horizontalAlignment(CENTER)
					                .build();
				         
				          
				          tableHeaderBuilder.addRow(headerName);
				          tableHeaderBuilder.addRow(info1);
				          tableHeaderBuilder.addRow(info2);
				          header = tableHeaderBuilder.build();
				          
				          
				          TableBuilder tableDebtDetailsBuilder = Table.builder()
				        		  .addColumnsOfWidth(60, 80, 80, 30, 60, 30, 30, 30, 50, 60, 50) 
	        					   .font(HELVETICA)
					                .borderWidth(0.5F)
					                .borderColor(Color.BLACK)
					                .horizontalAlignment(CENTER);
				          
				          Row tableHeader = Row.builder()
				        		  	.add(TextCell.builder().text("Add Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					                .add(TextCell.builder().text("Account Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Acc. Holder Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
					                .add(TextCell.builder().text("Cheque Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Pay Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Payee").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Reason").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Status").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Status Change Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .add(TextCell.builder().text("Changed By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
					                .backgroundColor(Color.LIGHT_GRAY)
					                .textColor(Color.BLACK)
					                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
					                .horizontalAlignment(CENTER)
					                .build();
				          tableDebtDetailsBuilder.addRow(tableHeader);
				       
				        
				     
				        	  int size = this.getChequeInfoList().size();
				        	  
				        	  
					          float startY = page.getMediaBox().getHeight() - PADDING20;
					          float currentY = startY;
					          TableDrawer.builder()
				                .contentStream(contentStream)
				                .table(header)
				                .startX(PADDING30)
				                .startY(startY)
				                .build()
				                .draw();
					          
					          
					          
					    	  for(int s=0;s<size;s++)
				        	  {
				        		  
				        		  if(currentY < 50)
				        		  {
				        			  pageCount++;
				        			  creditDetails = tableDebtDetailsBuilder.build();
				        			  TableDrawer.builder()
						                .contentStream(contentStream)
						                .table(creditDetails)
						                .startX(PADDING30)
						                .startY(startY-50)
						                .build()
						                .draw();
				        			  
				        			  contentStream.close();
				        			  
				        			  header = null;
				        			  
				        			 
						    			 
						    			
						    			  tableHeaderBuilder = Table.builder()
									                .addColumnsOfWidth(550)				                
									                .font(HELVETICA)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
								         
								           headerName = Row.builder()
									                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
									                .horizontalAlignment(CENTER)
									                .build();
								          
								          
								           info1 = Row.builder()
									                .add(TextCell.builder().text("Cheque Report  "
								                			+"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
									                .horizontalAlignment(CENTER)
									                .build();
								          
								           info2 = Row.builder()
									                .add(TextCell.builder().text("From Date : "
									                		+ ""+this.getFromDate()
									                		+ " and To Date :"+this.getToDate() +" Bank : " + this.getBankName()+" Branch : " + this.getBranchName()+" Cheque Status : " + this.getChequeStatus() ).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
									                .backgroundColor(WHITE)
									                .textColor(Color.BLACK)
									                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
									                .horizontalAlignment(CENTER)
									                .build();
								         
								          
								          tableHeaderBuilder.addRow(headerName);
								          tableHeaderBuilder.addRow(info1);
								          tableHeaderBuilder.addRow(info2);
								          header = tableHeaderBuilder.build();
				        			  
				        			  creditDetails = null;
				        			   tableDebtDetailsBuilder = Table.builder()
				        					   .addColumnsOfWidth(60, 80, 80, 30, 60, 30, 30, 30, 50, 60, 50) 
					        					.font(HELVETICA)
								                .borderWidth(0.5F)
								                .borderColor(Color.BLACK)
								                .horizontalAlignment(CENTER);
							          
							           tableHeader = Row.builder()
							        		   .add(TextCell.builder().text("Add Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
								                .add(TextCell.builder().text("Account Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Acc. Holder Name").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())
								                .add(TextCell.builder().text("Cheque Number").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Pay Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Payee").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Amount").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Reason").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Status").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Status Change Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .add(TextCell.builder().text("Changed By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())									                
								                .backgroundColor(Color.LIGHT_GRAY)
								                .textColor(Color.BLACK)
								                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .build();
							          tableDebtDetailsBuilder.addRow(tableHeader);
							          
				        			  
				        				PDPage newPage = new PDPage(PDRectangle.A4);
							        	 contentStream = new PDPageContentStream(document,newPage);
							        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
							             document.addPage( newPage );
							             
							             TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(header)
							                .startX(PADDING30)
							                .startY(currentY)
							                .build()
							                .draw();
				        		  }
				        		  
				        		  ChequeInfoDAO dao2 = this.getChequeInfoList().get(s);
				        		  
				        			Row supplierInfo = Row.builder()
				        					.add(TextCell.builder().text(dao2.getChequeBookAddDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getAccountNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getAccHolderName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getChequeNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getChequePayDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getChequePayee()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getAmount()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getReason()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getStatus()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(""+dao2.getStatusChangeDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.add(TextCell.builder().text(dao2.getStatusChangedBy()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(1F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA)
							                .fontSize(8)				              
							                .horizontalAlignment(CENTER)
							                .height(25F)					                
							                .build();
					        	  
					        	  tableDebtDetailsBuilder.addRow(supplierInfo);
					        	 
					        	  currentY = currentY -25;
				        	  }
					          
							
				        	  creditDetails = tableDebtDetailsBuilder.build();
				         
				          
				          TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(creditDetails)
			                .startX(PADDING30)
			                .startY(startY-50)
			                .build()
			                .draw();
				          contentStream.close();
					          
					          
					          
					          document.save(path+"/cheque-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Bank-" + this.getBankName()+"-Branch-" + this.getBranchName()+"-ChequeStatus-" + this.getChequeStatus()+"-report.pdf");
						        document.close();
						        
						        response.setHeader("Content-disposition", "inline; filename=cheque-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Bank-" + this.getBankName()+"-Branch-" + this.getBranchName()+"-ChequeStatus-" + this.getChequeStatus()+"-report.pdf");
								response.setContentType("application/pdf");
								
								FileInputStream fileInputStream = new FileInputStream(path+"/cheque-report-fromDate-" + this.getFromDate() +"-ToDate-"+this.getToDate()+"-Bank-" + this.getBankName()+"-Branch-" + this.getBranchName()+"-ChequeStatus-" + this.getChequeStatus()+"-report.pdf");
								PrintWriter out = response.getWriter();  
								int bytes;
								while ((bytes = fileInputStream.read()) != -1) {
									out.write(bytes);
								}
								fileInputStream.close();
								out.flush();
								out.close();
								
				}
				
				if(this.getDownloadType().equals("xl"))
				{

					String fileName = "cheque-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-Bank-" + this.getBankName()+"-Branch-" + this.getBranchName()+"-ChequeStatus-" + this.getChequeStatus()+".xls";
					 HSSFWorkbook workbook = new HSSFWorkbook();
					  HSSFSheet mySheet = workbook.createSheet("cheque-payment-report-"+this.getFromDate()+"-to-"+this.getToDate()+"-Bank-" + this.getBankName()+"-Branch-" + this.getBranchName()+"-ChequeStatus-" + this.getChequeStatus());  
					
					  mySheet.setColumnWidth(0, 18 * 256);  
					  mySheet.setColumnWidth(1, 25 * 256);
					  mySheet.setColumnWidth(2, 30 * 256);
					  mySheet.setColumnWidth(3, 20 * 256);
					  mySheet.setColumnWidth(4, 18 * 256);
					  mySheet.setColumnWidth(5, 15 * 256);
					  mySheet.setColumnWidth(6, 10 * 256);
					  mySheet.setColumnWidth(7, 15 * 256);
					  mySheet.setColumnWidth(8, 15 * 256);
					  mySheet.setColumnWidth(9, 18 * 256);
					  mySheet.setColumnWidth(10, 15 * 256);
					
					 
					 	Font font = workbook.createFont();
				       
				        font.setBold(true);
				       
					 final HSSFCellStyle cellStyle = workbook.createCellStyle();

					 cellStyle.setBorderBottom(BorderStyle.THIN);
					 cellStyle.setBorderRight(BorderStyle.THIN);
					 cellStyle.setBorderLeft(BorderStyle.THIN);
					 cellStyle.setBorderTop(BorderStyle.THIN);
					 cellStyle.setFont(font);
					 cellStyle.setWrapText(true);
					 
					 final HSSFCellStyle cellStyleNonBold = workbook.createCellStyle();

					 cellStyleNonBold.setBorderBottom(BorderStyle.THIN);
					 cellStyleNonBold.setBorderRight(BorderStyle.THIN);
					 cellStyleNonBold.setBorderLeft(BorderStyle.THIN);
					 cellStyleNonBold.setBorderTop(BorderStyle.THIN);
					 
					 short s = 255-0-0;
					 final HSSFCellStyle cellStyleBoldRed = workbook.createCellStyle();	 
					 
					 cellStyleBoldRed.setBorderBottom(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderRight(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderLeft(BorderStyle.THIN);
					 cellStyleBoldRed.setBorderTop(BorderStyle.THIN);
					 cellStyleBoldRed.setFillForegroundColor(s);
					 cellStyleBoldRed.setFont(font);								 
					 cellStyleBoldRed.setWrapText(true);
					 
					 HSSFRow rowHead = mySheet.createRow(0);							 
					 
					 Cell cellHead1 = rowHead.createCell(0);
					 cellHead1.setCellValue("Add Date");
					 cellHead1.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead2 = rowHead.createCell(1);
					 cellHead2.setCellValue("Account Number");
					 cellHead2.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead3 = rowHead.createCell(2);
					 cellHead3.setCellValue("Acc. Holder Name");
					 cellHead3.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead4 = rowHead.createCell(3);
					 cellHead4.setCellValue("Cheque Number");
					 cellHead4.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead5 = rowHead.createCell(4);
					 cellHead5.setCellValue("Pay Date");
					 cellHead5.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead6 = rowHead.createCell(5);
					 cellHead6.setCellValue("Payee");
					 cellHead6.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead7 = rowHead.createCell(6);
					 cellHead7.setCellValue("Amount");
					 cellHead7.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead8 = rowHead.createCell(7);
					 cellHead8.setCellValue("Reason");
					 cellHead8.setCellStyle(cellStyleBoldRed);
					 
					 Cell cellHead9 = rowHead.createCell(8);
					 cellHead9.setCellValue("Status");
					 cellHead9.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead10 = rowHead.createCell(9);
					 cellHead10.setCellValue("Status Change Date");
					 cellHead10.setCellStyle(cellStyleBoldRed);
					 
					 
					 Cell cellHead11 = rowHead.createCell(10);
					 cellHead11.setCellValue("Changed By");
					 cellHead11.setCellStyle(cellStyleBoldRed);
					 
					 
					 
					 
					 
					 int rowCount1 = 1;
					   for(ChequeInfoDAO dao:this.getChequeInfoList())
				       {
								 HSSFRow rowData = mySheet.createRow(rowCount1);
								  
								
								 
								 Cell cell1 = rowData.createCell(0);
								 cell1.setCellValue(dao.getChequeBookAddDate());
								 cell1.setCellStyle(cellStyleNonBold);
								 
								 Cell cell2 = rowData.createCell(1);
								 cell2.setCellValue(dao.getAccountNumber());
								 cell2.setCellStyle(cellStyleNonBold);
								 
								  
								Cell cell3 = rowData.createCell(2);
								 cell3.setCellValue(dao.getAccHolderName());
								 cell3.setCellStyle(cellStyleNonBold);
								 
								 Cell cell4 = rowData.createCell(3);
								 cell4.setCellValue(dao.getChequeNumber());
								 cell4.setCellStyle(cellStyleNonBold);
								 
								 
								 Cell cell5 = rowData.createCell(4);
								 cell5.setCellValue(dao.getChequePayDate());
								 cell5.setCellStyle(cellStyleNonBold);
								 
								 Cell cell6 = rowData.createCell(5);
								 cell6.setCellValue(dao.getChequePayee());
								 cell6.setCellStyle(cellStyleNonBold);
								 
								 Cell cell7 = rowData.createCell(6);
								 cell7.setCellValue(dao.getAmount());
								 cell7.setCellStyle(cellStyleNonBold);
								 
								 Cell cell8 = rowData.createCell(7);
								 cell8.setCellValue(dao.getReason());
								 cell8.setCellStyle(cellStyleNonBold);
								 
								 Cell cell9 = rowData.createCell(8);
								 cell9.setCellValue(dao.getStatus());
								 cell9.setCellStyle(cellStyleNonBold);
								 
								 Cell cell10 = rowData.createCell(9);
								 cell10.setCellValue(dao.getStatusChangeDate());
								 cell10.setCellStyle(cellStyleNonBold);
								 
								 Cell cell11 = rowData.createCell(10);
								 cell11.setCellValue(dao.getStatusChangedBy());
								 cell11.setCellStyle(cellStyleNonBold);
								 
								 
								 
								 rowCount1++;
								 
				       }
					   
						
					
					   
					   FileOutputStream fileOut = new FileOutputStream(fileName);
					   workbook.write(fileOut);
			            fileOut.close();
			            workbook.close();
			            
			    		response.setHeader("Content-disposition", "inline; filename="+""+fileName);
						response.setContentType("application/xls");
						FileInputStream fileInputStream = new FileInputStream(fileName);
						PrintWriter out = response.getWriter();  
						int bytes;
						while ((bytes = fileInputStream.read()) != -1) {
							out.write(bytes);
						}
						fileInputStream.close();
						out.close();
				}
    			
    		}
    		catch (SQLException e) 
    		{
	    		 e.printStackTrace();
	    				    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Something Went Wrong!");
	    			
	    	} catch (Exception e) {
	    		
	    		e.printStackTrace();	    			
	    			addActionError(e.getMessage()+" || "+e.getCause()+" || Something Went Wrong!");
	    	}
    			finally {
    				if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
        }
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	
	
	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}
	
	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}
	
	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	


	public String getAddSideBarJs() {
		return addSideBarJs;
	}


	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}


	


	


	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}


	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}


	public String getDownloadType() {
		return downloadType;
	}


	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}


	public String getBankName() {
		return bankName;
	}


	public void setBankName(String bankName) {
		this.bankName = bankName;
	}


	public String getBranchName() {
		return branchName;
	}


	public void setBranchName(String branchName) {
		this.branchName = branchName;
	}


	public String getChequeStatus() {
		return chequeStatus;
	}


	public void setChequeStatus(String chequeStatus) {
		this.chequeStatus = chequeStatus;
	}


	public List<ChequeInfoDAO> getChequeInfoList() {
		return chequeInfoList;
	}


	public void setChequeInfoList(List<ChequeInfoDAO> chequeInfoList) {
		this.chequeInfoList = chequeInfoList;
	}


	public List<String> getBankList() {
		return bankList;
	}


	public void setBankList(List<String> bankList) {
		this.bankList = bankList;
	}


	public List<String> getBranchList() {
		return branchList;
	}


	public void setBranchList(List<String> branchList) {
		this.branchList = branchList;
	}


	public List<String> getChequeSatusList() {
		return chequeSatusList;
	}


	public void setChequeSatusList(List<String> chequeSatusList) {
		this.chequeSatusList = chequeSatusList;
	}




	

}
