package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BoulderInwardInfoDAO;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;

public class DownloadBoulderInwardReport extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 8292337304631426465L;
	public HttpServletRequest request;
	public HttpServletResponse response;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;

	private String fromDate;
	private String toDate;
	
	private List<BoulderInwardInfoDAO> boulderInwardList = new ArrayList<BoulderInwardInfoDAO>();
	
	private Float totalQuantity;
	
	private String vehicleId;
	private String boulderSupplierId;
	
	private SessionMap<String,Object> sessionMap;  
	
  
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	String crusherId = (String) this.getSessionMap().get("crusherId");
    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
    		
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();


        	Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			String sql = "";
			String db = (String) this.getSession().getAttribute("db");
			
			HashMap<String,String> inwardUnitList = GetListResource.GetBoulderInwardUnitList();
			
			String vehicleNumber = "";
			String boulderSuppName = "";
			
			
			try {
				
				connection = GetDBConnection.getDBConnection(db);
				
				HashMap<String,String> boulderSuppList = GetListResource.getBoulderSupplierList(this.getSessionMap());
				
				if(this.getVehicleId().length() == 0 && this.getBoulderSupplierId().length() == 0)
				{
					
					vehicleNumber = "ALL";
					boulderSuppName = "ALL";
				
					sql = "SELECT "
							+ "indetails.entry_id,"
							+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
							+ "indetails.vehicle_id,"
							+ "indetails.vehicle_number,"
							+ "indetails.boulder_quantity,"
							+ "indetails.boulder_quantity_unit,"
							+ "indetails.inward_from,"
							+ "indetails.inward_to,"
							+ "indetails.entry_by,"
							+ "indetails.bill_generated_status,"
							+ "vemap.boulder_supplier_id "
							+ "FROM "
							+ "boulder_inward_details AS indetails "
							+ "INNER JOIN "
							+ "boulder_supplier_vehicle_mapping_master AS vemap "
							+ "ON "
							+ "indetails.vehicle_id = vemap.vehicle_id "
							+ "WHERE "
							+ "indetails.crusher_id = ? "
							+ "AND "
							+ "indetails.crusher_code = ? "
							+ "AND "
							+ "vemap.crusher_id = ? "
							+ "AND "
							+ "vemap.crusher_code = ? "
							+ "AND "
							+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					preparedStatement.setString(5, this.getFromDate());
					preparedStatement.setString(6, this.getToDate());
				}
				else if(this.getVehicleId().length() > 0 && this.getBoulderSupplierId().length() == 0)
				{

					String [] vehicleDetails = this.getVehicleId().split("-");
					
					vehicleNumber = vehicleDetails[2];
					boulderSuppName = "ALL";
					
					sql = "SELECT "
							+ "indetails.entry_id,"
							+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
							+ "indetails.vehicle_id,"
							+ "indetails.vehicle_number,"
							+ "indetails.boulder_quantity,"
							+ "indetails.boulder_quantity_unit,"
							+ "indetails.inward_from,"
							+ "indetails.inward_to,"
							+ "indetails.entry_by,"
							+ "indetails.bill_generated_status,"
							+ "vemap.boulder_supplier_id "
							+ "FROM "
							+ "boulder_inward_details AS indetails "
							+ "INNER JOIN "
							+ "boulder_supplier_vehicle_mapping_master AS vemap "
							+ "ON "
							+ "indetails.vehicle_id = vemap.vehicle_id "
							+ "WHERE "
							+ "indetails.crusher_id = ? "
							+ "AND "
							+ "indetails.crusher_code = ? "
							+ "AND "
							+ "vemap.crusher_id = ? "
							+ "AND "
							+ "vemap.crusher_code = ? "
							+ "AND "
							+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
							+ "indetails.vehicle_id = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					preparedStatement.setString(5, this.getFromDate());
					preparedStatement.setString(6, this.getToDate());
					preparedStatement.setString(7, vehicleDetails[0]);
				}
				else if(this.getVehicleId().length() > 0 && this.getBoulderSupplierId().length() > 0)
				{

					String [] vehicleDetails = this.getVehicleId().split("-");
					String [] boulderSuppDetails = this.getBoulderSupplierId().split("-");
					
					vehicleNumber = vehicleDetails[2];
					boulderSuppName = boulderSuppDetails[1];
					
					sql = "SELECT "
							+ "indetails.entry_id,"
							+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
							+ "indetails.vehicle_id,"
							+ "indetails.vehicle_number,"
							+ "indetails.boulder_quantity,"
							+ "indetails.boulder_quantity_unit,"
							+ "indetails.inward_from,"
							+ "indetails.inward_to,"
							+ "indetails.entry_by,"
							+ "indetails.bill_generated_status,"
							+ "vemap.boulder_supplier_id "
							+ "FROM "
							+ "boulder_inward_details AS indetails "
							+ "INNER JOIN "
							+ "boulder_supplier_vehicle_mapping_master AS vemap "
							+ "ON "
							+ "indetails.vehicle_id = vemap.vehicle_id "
							+ "WHERE "
							+ "indetails.crusher_id = ? "
							+ "AND "
							+ "indetails.crusher_code = ? "
							+ "AND "
							+ "vemap.crusher_id = ? "
							+ "AND "
							+ "vemap.crusher_code = ? "
							+ "AND "
							+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
							+ "indetails.vehicle_id = ? "
							+ "AND "
							+ "vemap.boulder_supplier_id = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					preparedStatement.setString(5, this.getFromDate());
					preparedStatement.setString(6, this.getToDate());
					preparedStatement.setString(7, vehicleDetails[0]);
					preparedStatement.setString(8, boulderSuppDetails[0]);
				}
				
				else if(this.getVehicleId().length() == 0 && this.getBoulderSupplierId().length() > 0)
				{

					String [] boulderSuppDetails = this.getBoulderSupplierId().split("-");
					
					vehicleNumber = "ALL";
					boulderSuppName = boulderSuppDetails[1];
					
					sql = "SELECT "
							+ "indetails.entry_id,"
							+ "DATE_FORMAT(indetails.inward_date,'%d-%m-%Y'),"
							+ "indetails.vehicle_id,"
							+ "indetails.vehicle_number,"
							+ "indetails.boulder_quantity,"
							+ "indetails.boulder_quantity_unit,"
							+ "indetails.inward_from,"
							+ "indetails.inward_to,"
							+ "indetails.entry_by,"
							+ "indetails.bill_generated_status,"
							+ "vemap.boulder_supplier_id "
							+ "FROM "
							+ "boulder_inward_details AS indetails "
							+ "INNER JOIN "
							+ "boulder_supplier_vehicle_mapping_master AS vemap "
							+ "ON "
							+ "indetails.vehicle_id = vemap.vehicle_id "
							+ "WHERE "
							+ "indetails.crusher_id = ? "
							+ "AND "
							+ "indetails.crusher_code = ? "
							+ "AND "
							+ "vemap.crusher_id = ? "
							+ "AND "
							+ "vemap.crusher_code = ? "
							+ "AND "
							+ "(indetails.inward_date BETWEEN STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y')) "
							+ "AND "
							+ "vemap.boulder_supplier_id = ? ";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, crusherId);
					preparedStatement.setString(2, crusherCode);
					preparedStatement.setString(3, crusherId);
					preparedStatement.setString(4, crusherCode);
					preparedStatement.setString(5, this.getFromDate());
					preparedStatement.setString(6, this.getToDate());
					preparedStatement.setString(7, boulderSuppDetails[0]);
				}
				
				resultSet = preparedStatement.executeQuery();
				
				this.setTotalQuantity(0.0f);
				
				while(resultSet.next())
				{
					BoulderInwardInfoDAO dao = new BoulderInwardInfoDAO();
					
					dao.setEntryId(resultSet.getString(1));
					dao.setInwardDate(resultSet.getString(2));
					dao.setVehicleId(resultSet.getString(3));
					dao.setVehicleNumber(resultSet.getString(4));
					dao.setBoulderQuantity(resultSet.getFloat(5));
					dao.setBoulderInwardUnit(inwardUnitList.get(resultSet.getString(6)));
					dao.setFromPlace(resultSet.getString(7));
					dao.setToPlace(resultSet.getString(8));
					dao.setBillGeneratedStatus(resultSet.getString(10));
					dao.setBoulderSuppName(boulderSuppList.get(resultSet.getString(11)));
					
					this.setTotalQuantity(this.getTotalQuantity() + resultSet.getFloat(5));
					
					dao.setKey(EncryptionDecryption.encrypt(resultSet.getString(1)+"#"+resultSet.getString(2)+"#"+resultSet.getString(3)));
					
					this.getBoulderInwardList().add(dao);
					
					
				}
				

				
				
				 String path=	request.getSession().getServletContext().getRealPath("/images/");

				PDDocument document = new PDDocument(); 
		      	PDPage pageItemDetails = null;
					
		      	@SuppressWarnings("unchecked")
				String crusherName = (String) this.getSessionMap().get("crushernameenglish");
			    
		     
		      	pageItemDetails = new PDPage(PDRectangle.A4);
					int pageCount = 1;
					
		        document.addPage(pageItemDetails);
		         PDPageContentStream contentStream = new PDPageContentStream(document, pageItemDetails);
          
		         Table materialUsedDetailsPageheader;
	    			
	    			
    			  TableBuilder materialUsedDetailsTableHeaderBuilder = Table.builder()
			                .addColumnsOfWidth(530)				                
			                .font(HELVETICA)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		         
		          Row materialUsedheaderName = Row.builder()
			                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          
		          
		          Row materialUsedinfo1 = Row.builder()
			                .add(TextCell.builder().text("Boulder Inward Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
		    
		          
		          Row materialUsedinfo2 = Row.builder()
		                .add(TextCell.builder().text("From Date: "
		                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
		                .backgroundColor(WHITE)
		                .textColor(Color.BLACK)
		                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
		                .horizontalAlignment(CENTER)
		                .build();
		          
		          
		          Row typeInfoRow = Row.builder()
		                .add(TextCell.builder().text("Vehicle: "
		                			+vehicleNumber+", Boulder Supllier : "+boulderSuppName).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
		                .backgroundColor(WHITE)
		                .textColor(Color.BLACK)
		                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
		                .horizontalAlignment(CENTER)
		                .build();
		          
		       
		          materialUsedDetailsTableHeaderBuilder.addRow(materialUsedheaderName);
		          materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo1);
		          materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo2);
		          materialUsedDetailsTableHeaderBuilder.addRow(typeInfoRow);
			       
		          materialUsedDetailsPageheader = materialUsedDetailsTableHeaderBuilder.build();
		          
		          
		          float startY = pageItemDetails.getMediaBox().getHeight() - PADDING20;
		          float currentY = startY;
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(materialUsedDetailsPageheader)
	                .startX(PADDING50)
	                .startY(currentY)
	                .build()
	                .draw();
		          
		          Table inwardDetails ;
		          
		          TableBuilder inwardDetailsBuilder = Table.builder()
		        		  .addColumnsOfWidth(55,100,100,55,55,55,55,55)					                
			              .font(HELVETICA)
			                .borderWidth(0.5F)
			                .borderColor(Color.BLACK)
			                .horizontalAlignment(CENTER);
		          
		          
		          Row inwarddetailsTableHeader = Row.builder()
		        		  	.add(TextCell.builder().text("Inward Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			                .add(TextCell.builder().text("Supplier").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			                .add(TextCell.builder().text("Vehicle No").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			                .add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			                .add(TextCell.builder().text("Unit").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			                .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			                .add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			                .add(TextCell.builder().text("Bill Gen?").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
			               .backgroundColor(Color.LIGHT_GRAY)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
			                .horizontalAlignment(CENTER)
			                .build();
		          inwardDetailsBuilder.addRow(inwarddetailsTableHeader);
		          
		          
		         
		         
		          int listSize = this.getBoulderInwardList().size();
		          
		          for(int s=0;s<listSize;s++)
	        	  {
		        	  
	        		  if(currentY < 130)
	        		  {
	        			  pageCount++;
	        			  inwardDetails = inwardDetailsBuilder.build();
	        			  TableDrawer.builder()
			                .contentStream(contentStream)
			                .table(inwardDetails)
			                .startX(PADDING30)
			                .startY(startY-70)
			                .build()
			                .draw();
	        			  
	        			  contentStream.close();
	        			  
	        			  contentStream = null;
				          
				      	PDPage materialUsedDetailsNewPage = new PDPage(new PDRectangle(830,580));
		        	 contentStream = new PDPageContentStream(document,materialUsedDetailsNewPage);
		        	 currentY =  materialUsedDetailsNewPage.getMediaBox().getHeight() - PADDING20;
		             document.addPage( materialUsedDetailsNewPage );
		            
		             
		             materialUsedDetailsPageheader = null;
		             materialUsedDetailsTableHeaderBuilder = null;
        			  
        			  
		             materialUsedDetailsTableHeaderBuilder = Table.builder()
				                .addColumnsOfWidth(530)				                
				                .font(HELVETICA)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			         
		             materialUsedheaderName = Row.builder()
				                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(20)				              
				                .horizontalAlignment(CENTER)
				                .build();
			          
		             materialUsedinfo1 = Row.builder()
				                .add(TextCell.builder().text("Boulder Inward Report").borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
				                .backgroundColor(WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
				                .horizontalAlignment(CENTER)
				                .build();
			       
			          
		             materialUsedinfo2 = Row.builder()
			                .add(TextCell.builder().text("From Date: "
			                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
			          
		             
			          typeInfoRow = Row.builder()
			                .add(TextCell.builder().text("Vehicle: "
			                			+vehicleNumber+", Boulder Supllier : "+boulderSuppName).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
			                .backgroundColor(WHITE)
			                .textColor(Color.BLACK)
			                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
			                .horizontalAlignment(CENTER)
			                .build();
			          
			       
		             materialUsedDetailsTableHeaderBuilder.addRow(materialUsedheaderName);
		             materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo1);
		             materialUsedDetailsTableHeaderBuilder.addRow(materialUsedinfo2);
		             materialUsedDetailsTableHeaderBuilder.addRow(typeInfoRow);
			       
		             materialUsedDetailsPageheader = materialUsedDetailsTableHeaderBuilder.build();
			          
		             inwardDetails = null;
			          
			          
			          
		             inwardDetailsBuilder = Table.builder()
		            		 .addColumnsOfWidth(55,100,100,55,55,55,55,55)				                
				               .font(HELVETICA)
				                .borderWidth(0.5F)
				                .borderColor(Color.BLACK)
				                .horizontalAlignment(CENTER);
			          
			          
		             inwarddetailsTableHeader = Row.builder()
			        		  	.add(TextCell.builder().text("Inward Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				                .add(TextCell.builder().text("Supplier").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				                .add(TextCell.builder().text("Vehicle No").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				                .add(TextCell.builder().text("Qty").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				                .add(TextCell.builder().text("Unit").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				                .add(TextCell.builder().text("From").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				                .add(TextCell.builder().text("To").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				                .add(TextCell.builder().text("Bill Gen?").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
				               .backgroundColor(Color.LIGHT_GRAY)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD).fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .build();
		             inwardDetailsBuilder.addRow(inwarddetailsTableHeader);
        			  
			          TableDrawer.builder()
		                .contentStream(contentStream)
		                .table(materialUsedDetailsPageheader)
		                .startX(PADDING50)
		                .startY(currentY)
		                .build()
		                .draw();
		             
		          
	        		  }
	        		  
	        		  
	        		  BoulderInwardInfoDAO dao = this.getBoulderInwardList().get(s);
	        		  
	        	
	        		Row itemInfoRow = Row.builder()
	        					.add(TextCell.builder().text(dao.getInwardDate()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getBoulderSuppName()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getVehicleNumber()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getBoulderQuantity()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getBoulderInwardUnit()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getFromPlace()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getToPlace()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+dao.getBillGeneratedStatus()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA)
				                .fontSize(7)				              
				                .horizontalAlignment(CENTER)
				                .height(20F)					                
				                .build();
	        		  
	        		inwardDetailsBuilder.addRow(itemInfoRow);
		        	 
	        			currentY = currentY -25;
	        		  
	        	  }
	        	  
	        	

	        		Row totalInfoRow = Row.builder()
		        			  	.add(TextCell.builder().text("Total").horizontalAlignment(RIGHT).colSpan(3).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text(""+this.getTotalQuantity()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
		        			  	.backgroundColor(Color.WHITE)
				                .textColor(Color.BLACK)
				                .font(PDType1Font.HELVETICA_BOLD)
				                .fontSize(8)				              
				                .horizontalAlignment(CENTER)
				                .height(22F)					                
				                .build();
	        		inwardDetailsBuilder.addRow(totalInfoRow);
	        	  
	        		inwardDetails = inwardDetailsBuilder.build();
	        	  
		          TableDrawer.builder()
	                .contentStream(contentStream)
	                .table(inwardDetails)
	                .startX(PADDING30)
	                .startY(startY-70)
	                .build()
	                .draw();
		          
		     
		          contentStream.close();
		         
			       // System.out.println(path);
							
			        
			        document.save(path+"boulder-inward-report-"+this.getFromDate()+" TO "+this.getToDate()+".pdf");
			        document.close();
			        
			        response.setHeader("Content-disposition", "inline; filename=boulder-inward-report-"+this.getFromDate()+" TO "+this.getToDate()+".pdf");
					response.setContentType("application/pdf");
					FileInputStream fileInputStream = new FileInputStream(path+"/boulder-inward-report-"+this.getFromDate()+" TO "+this.getToDate()+".pdf");
					PrintWriter out = response.getWriter();  
					int bytes;
					while ((bytes = fileInputStream.read()) != -1) {
						out.write(bytes);
					}
					fileInputStream.close();
					out.flush();
					out.close();
				
				
				
				
			}catch (SQLException e) {
				e.printStackTrace();
			
				addActionError("Records not found for specified dates!");
				
				
			} catch (IOException e) {
			
			
				e.printStackTrace();
				addActionError("Records not found for specified dates!");
			}finally
			{
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
				
			}
        }
	}
	public HttpServletRequest getRequest() {
		return request;
	}
	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}
	public HttpServletResponse getResponse() {
		return response;
	}
	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	
	public String getFromDate() {
		return fromDate;
	}
	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}
	public String getToDate() {
		return toDate;
	}
	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	


	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}
	public List<BoulderInwardInfoDAO> getBoulderInwardList() {
		return boulderInwardList;
	}
	public void setBoulderInwardList(List<BoulderInwardInfoDAO> boulderInwardList) {
		this.boulderInwardList = boulderInwardList;
	}
	public Float getTotalQuantity() {
		return totalQuantity;
	}
	public void setTotalQuantity(Float totalQuantity) {
		this.totalQuantity = totalQuantity;
	}
	public String getVehicleId() {
		return vehicleId;
	}
	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}
	public String getBoulderSupplierId() {
		return boulderSupplierId;
	}
	public void setBoulderSupplierId(String boulderSupplierId) {
		this.boulderSupplierId = boulderSupplierId;
	}
	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

}
