package com.stonecrusher.download;

import static java.awt.Color.WHITE;
import static org.apache.pdfbox.pdmodel.font.PDType1Font.HELVETICA;
import static org.vandeseer.easytable.settings.HorizontalAlignment.CENTER;
import static org.vandeseer.easytable.settings.HorizontalAlignment.LEFT;
import static org.vandeseer.easytable.settings.HorizontalAlignment.RIGHT;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.fontbox.ttf.TTFParser;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;
import org.vandeseer.easytable.TableDrawer;
import org.vandeseer.easytable.structure.Row;
import org.vandeseer.easytable.structure.Table;
import org.vandeseer.easytable.structure.Table.TableBuilder;
import org.vandeseer.easytable.structure.cell.TextCell;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BankAccountStatementDAO;
import com.stonecrusher.DAO.SupplierDebtReportDAO;
import com.stonecrusher.db.GetDBConnection;

public class DownloadAccountStmtReport extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -4817067030451944750L;

	public HttpServletRequest request;
	public HttpServletResponse response;

	private final static Color BLUE_DARK = new Color(76, 129, 190);
    private final static Color BLUE_LIGHT_1 = new Color(186, 206, 230);
    private final static Color BLUE_LIGHT_2 = new Color(218, 230, 242);

    private final static Color GRAY_LIGHT_1 = new Color(245, 245, 245);
    private final static Color GRAY_LIGHT_2 = new Color(240, 240, 240);
    private final static Color GRAY_LIGHT_3 = new Color(216, 216, 216);
    private static final float PADDING10 = 10f;
    private static final float PADDING20 = 20f;
    private static final float PADDING30 = 30f;
    private static final float PADDING40 = 40f;
    private static final float PADDING50 = 50f;

	private HttpSession session;
	private String fromDate;
	private String toDate;
	private String accountId;
	
	private Float yesterdayBallanceAmt;
	
	private SessionMap<String,Object> sessionMap;  

	private List<BankAccountStatementDAO> reportList = new ArrayList<BankAccountStatementDAO>();
		
	
	public void download()
	{
		session=ServletActionContext.getRequest().getSession(false); 
		 
        if(session==null || session.getAttribute("login")==null){ 
        	addActionMessage("Please Login First !!!");
        	
        }  
        else{
        	
        	response = ServletActionContext.getResponse();
			request = ServletActionContext.getRequest();


        	Connection connection = null;
			PreparedStatement preparedStatement= null;
			ResultSet resultSet = null;
			
			String sql = "";
			String db = (String) this.getSession().getAttribute("db");
        	
			try
			{
				
				connection = GetDBConnection.getDBConnection(db);
				
			   	String crusherId = (String) this.getSessionMap().get("crusherId");
	    		String crusherCode = (String) this.getSessionMap().get("crusherCode");
	    		
	    		
				
				DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("dd-MM-yyyy");
	            DateTimeFormatter outputFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
	            
	            LocalDate fromDateLocal = LocalDate.parse(fromDate, inputFormatter);
	            LocalDate yesterdayDate = fromDateLocal.minusDays(1);

	            String yesterdayDateFormatted = yesterdayDate.format(outputFormatter);

	            
	            
	            
	            
	            sql = "SELECT "
	                    + "closeing_bal_amount "
	                    + "FROM "
	                    + "datewise_closing_balance "
	                    + "WHERE "
	                    + "account_id = ? "
	                    + "AND "
	                    + "crusher_id = ? "
	                    + "AND "
	                    + "crusher_code = ? "
	                    + "AND "
	                    + "closeing_bal_date <= ? "
	                    + "ORDER BY "
	                    + "closeing_bal_date DESC "
	                    + "LIMIT 1";

	            preparedStatement = connection.prepareStatement(sql);

	            preparedStatement.setString(1, this.getAccountId());
	            preparedStatement.setString(2, crusherId);
	            preparedStatement.setString(3, crusherCode);
	            preparedStatement.setString(4, yesterdayDateFormatted);


        		resultSet = preparedStatement.executeQuery();
        		if(resultSet.next())
        		{
        			yesterdayBallanceAmt = resultSet.getFloat(1);
        			
        		}
        		
        		
        		
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
        		
        		
        		
				float openingBal = 0.0F;
				String accountNumber = "";
				String accHolderName = "";
				String bankName = "";
				String branch = "";
				
				float ttlCrAmt = 0.0F;
	        	float ttlDrAmt = 0.0F;
	        	float balAmt = 0.0F;
	        	
        		sql = "SELECT "
        				+ "opening_balance,"
        				+ "account_holder_name,"
        				+ "account_number,"
        				+ "ifsc_code,"
        				+ "bank_name,"
        				+ "branch "
        				+ "FROM "
        				+ "crusher_bank_account "
        				+ "WHERE "
        				+ "account_id  = ? "
        				+ "AND "
        				+ "crusher_id = ? "
        				+ "AND "
        				+ "crusher_code = ? ";
        			
        		preparedStatement = connection.prepareStatement(sql);
        		
        		preparedStatement.setString(1, this.getAccountId());
        		preparedStatement.setString(2, crusherId);
        		preparedStatement.setString(3, crusherCode);
        		
        		
        		resultSet = preparedStatement.executeQuery();
        		if(resultSet.next())
        		{
        			openingBal = resultSet.getFloat(1);
        			accHolderName = resultSet.getString(2);
        			accountNumber = resultSet.getString(3);
        			bankName = resultSet.getString(5);
        			branch = resultSet.getString(6);
        		}
        		
        		
        		if(resultSet != null)
        		{
        			resultSet.close();
        			resultSet = null;
        		}
        		if(preparedStatement!= null)
        		{
        			preparedStatement.close();
        			preparedStatement = null;
        		}
        		sql = "SELECT "
						+ "entry_id,"
						+ "account_id,"
						+ "account_number,"
						+ "entry_date,"
						+ "DATE_FORMAT(entry_date,'%d-%m-%Y'),"
						+ "entry_time,"
						+ "entry_type,"
						+ "amount,"
						+ "payment_type,"
						+ "entry_by,"
						+ "entry_details "
						+ "FROM "
						+ "bank_account_credit_debit_master "
						+ "WHERE "
						+ "account_id = ? "
						+ "AND "
						+ "(entry_date "
						+ "BETWEEN "
						+ "STR_TO_DATE(?,'%d-%m-%Y') AND STR_TO_DATE(?,'%d-%m-%Y') ) "
						+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ? "
						+ "order by "
						+ "entry_date";
				
				preparedStatement = connection.prepareStatement(sql);
				preparedStatement.setString(1, this.getAccountId());
				preparedStatement.setString(2, this.getFromDate());
				preparedStatement.setString(3, this.getToDate());
				preparedStatement.setString(4, crusherId);
				preparedStatement.setString(5, crusherCode);
				
				
				resultSet = preparedStatement.executeQuery();
				
				resultSet.last();
				
				int rowCount = resultSet.getRow();
				
				resultSet.beforeFirst();
				
				if(rowCount > 0)
				{
					float balance =0.0F;
					
					if(yesterdayBallanceAmt == null) {
						 balance = openingBal ;
						 yesterdayBallanceAmt = openingBal;
					}else {
						 balance = this.getYesterdayBallanceAmt() ;
					}
				 
					while(resultSet.next())
					{
						BankAccountStatementDAO dao = new BankAccountStatementDAO();
						dao.setDateAsString(resultSet.getString(5));
						dao.setEntryId(resultSet.getString(1));
						dao.setEntryType(resultSet.getString(7));
						dao.setAmount(resultSet.getFloat(8));
						dao.setPaymentType(resultSet.getString(9));
						dao.setEntryBy(resultSet.getString(10));
						
						if(resultSet.getString(7).equals("CREDIT"))
						{
							ttlCrAmt = ttlCrAmt + resultSet.getFloat(8);
							balance = balance + resultSet.getFloat(8);
						}
						if(resultSet.getString(7).equals("DEBIT"))
						{
							ttlDrAmt = ttlDrAmt + resultSet.getFloat(8);
							balance = balance - resultSet.getFloat(8);
						}
						
						balAmt = balance;
						
						dao.setBalance(balance);
						dao.setEntryDetails(resultSet.getString(11));
						this.getReportList().add(dao);
					}
					
					
					
					
					DecimalFormat df = new DecimalFormat("##.##");
					
	    			String path=	request.getSession().getServletContext().getRealPath("/images/");
	    			PDDocument document = new PDDocument(); 
					PDPage page = null;
					
					
					Date date = new Date();
					SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-YYYY");
		        	
					@SuppressWarnings("unchecked")
					String crusherName = (String) this.getSessionMap().get("crushernameenglish");
				     
					 	
					String dateToday = sdf.format(date); 
						 page = new PDPage(PDRectangle.A4);
					
					
				        document.addPage(page);
				         PDPageContentStream contentStream = new PDPageContentStream(document, page);
				         int pageCount = 1;
				         
				         
				    	 File fontFile  =  new File( request.getSession().getServletContext().getRealPath("/fonts/Nirmala.ttf"));
						 
						 TrueTypeFont ttf1 = new TTFParser().parse(fontFile);
						 PDFont fontMarathi = PDType0Font.load(document, ttf1, true);
					 
			    			 Table header;
			    			
			    			  TableBuilder tableHeaderBuilder = Table.builder()
						                .addColumnsOfWidth(550)				                
						                .font(HELVETICA)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					         
					          Row headerName = Row.builder()
						                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
						                .horizontalAlignment(CENTER)
						                .build();
					          
					          
					          Row info1 = Row.builder()
						                .add(TextCell.builder().text("Account Statment: From Date: "
						                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
						                .horizontalAlignment(CENTER)
						                .build();
					          
					          Row info2 = Row.builder()
						                .add(TextCell.builder().text("Account Number: "
						                		+accountNumber
						                		+ ", Account Holder:"+accHolderName+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
						                .backgroundColor(WHITE)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
						                .horizontalAlignment(CENTER)
						                .build();
					         
					          
					          tableHeaderBuilder.addRow(headerName);
					          tableHeaderBuilder.addRow(info1);
					          tableHeaderBuilder.addRow(info2);
					          header = tableHeaderBuilder.build();
					          
					          
					          Table stmtDetails;
				    			 
				    			
					          
					          TableBuilder tableStmtDetailsBuilder = Table.builder()
					        		  	.addColumnsOfWidth(75,70,150,60,60,60,60)				                
						                .font(HELVETICA)
						                .borderWidth(0.5F)
						                .borderColor(Color.BLACK)
						                .horizontalAlignment(CENTER);
					          
					          Row tableHeader = Row.builder()
					        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						                .add(TextCell.builder().text("Payment Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
						                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
						                .add(TextCell.builder().text("Cr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						                .add(TextCell.builder().text("Dr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
						                .add(TextCell.builder().text("Balance").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
						                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())									                
						                .backgroundColor(Color.LIGHT_GRAY)
						                .textColor(Color.BLACK)
						                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
						                .horizontalAlignment(CENTER)
						                .build();
					          tableStmtDetailsBuilder.addRow(tableHeader);
					       
					        
					     
					        	  int size = this.getReportList().size();
					        	  
					        	  
						          float startY = page.getMediaBox().getHeight() - PADDING20;
						          float currentY = startY;
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(header)
					                .startX(PADDING30)
					                .startY(startY)
					                .build()
					                .draw();
						          
						          for(int s=0;s<size;s++)
					        	  {
					        		  
					        		  if(currentY < 120)
					        		  {
					        			  
					        			  pageCount++;
					        			  stmtDetails = tableStmtDetailsBuilder.build();
					        			  TableDrawer.builder()
							                .contentStream(contentStream)
							                .table(stmtDetails)
							                .startX(PADDING30)
							                .startY(startY-50)
							                .build()
							                .draw();
					        			  
					        			  contentStream.close();
					        			  
					        			  header = null;
					        			  
					        			 
							    			 
							    			
							    			  tableHeaderBuilder = Table.builder()
										                .addColumnsOfWidth(550)				                
										                .font(HELVETICA)
										                .borderColor(Color.BLACK)
										                .horizontalAlignment(CENTER);
									         
									           headerName = Row.builder()
										                .add(TextCell.builder().text(crusherName).horizontalAlignment(CENTER).borderWidth(0).lineSpacing(10F).build())				               
										                .backgroundColor(WHITE)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(18)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          
									          
										          
										           info1 = Row.builder()
											                .add(TextCell.builder().text("Account Statment: From Date: "
											                			+this.getFromDate()+" To Date : "+this.getToDate() +"       Page No . : "+pageCount).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(10)
											                .horizontalAlignment(CENTER)
											                .build();
										          
										           info2 = Row.builder()
											                .add(TextCell.builder().text("Account Number: "
											                		+accountNumber
											                		+ ", Account Holder:"+accHolderName+ " , Generated On : "+dateToday).borderWidthBottom(0.0F).horizontalAlignment(CENTER).build())				               
											                .backgroundColor(WHITE)
											                .textColor(Color.BLACK)
											                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)
											                .horizontalAlignment(CENTER)
											                .build();
										         
									          
									          tableHeaderBuilder.addRow(headerName);
									          tableHeaderBuilder.addRow(info1);
									          tableHeaderBuilder.addRow(info2);
									          header = tableHeaderBuilder.build();
					        			  
					        			  stmtDetails = null;
					        			   tableStmtDetailsBuilder = Table.builder()
					        					    .addColumnsOfWidth(75,70,150,60,60,60,60)				                
									                .font(HELVETICA)
									                .borderWidth(0.5F)
									                .borderColor(Color.BLACK)
									                .horizontalAlignment(CENTER);
					        			      
					        			   tableHeader = Row.builder()
									        		  	.add(TextCell.builder().text("Date").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
										                .add(TextCell.builder().text("Payment Type").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
										                .add(TextCell.builder().text("Details").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
										                .add(TextCell.builder().text("Cr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
										                .add(TextCell.builder().text("Dr.").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
										                .add(TextCell.builder().text("Balance").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())
										                .add(TextCell.builder().text("Entry By").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())									                
										                .backgroundColor(Color.LIGHT_GRAY)
										                .textColor(Color.BLACK)
										                .font(PDType1Font.HELVETICA_BOLD).fontSize(8)				              
										                .horizontalAlignment(CENTER)
										                .build();
									          tableStmtDetailsBuilder.addRow(tableHeader);
								          
					        			  
					        				PDPage newPage = new PDPage(PDRectangle.A4);
								        	 contentStream = new PDPageContentStream(document,newPage);
								        	currentY =  newPage.getMediaBox().getHeight() - PADDING20;
								             document.addPage( newPage );
								             
								             TableDrawer.builder()
								                .contentStream(contentStream)
								                .table(header)
								                .startX(PADDING30)
								                .startY(currentY)
								                .build()
								                .draw();
					        		  }
					        		  
					        		  
					        		  BankAccountStatementDAO dao = this.getReportList().get(s);
					        		  Row row = null;
					        		  if(dao.getEntryType().equals("CREDIT"))
					        		  {
					        		  
					        		   row = Row.builder()
						        			  	.add(TextCell.builder().text(""+dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getPaymentType()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getEntryDetails().replaceAll("\\s", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(df.format(dao.getAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text("-").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(df.format(dao.getBalance())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.add(TextCell.builder().text(""+dao.getEntryBy().replaceAll("\\s", " ")).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
						        			  	.backgroundColor(Color.WHITE)
								                .textColor(Color.BLACK)
								                .font(fontMarathi)
								                .fontSize(8)				              
								                .horizontalAlignment(CENTER)
								                .height(20F)					                
								                .build();
					        		  }
					        		  if(dao.getEntryType().equals("DEBIT"))
					        		  {
					        			  row = Row.builder()
							        			  	.add(TextCell.builder().text(""+dao.getDateAsString()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+dao.getPaymentType()).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+dao.getEntryDetails().replaceAll("\\s", " ")).horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text("-").horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(df.format(dao.getAmount())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(df.format(dao.getBalance())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.add(TextCell.builder().text(""+dao.getEntryBy()).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
							        			  	.backgroundColor(Color.WHITE)
									                .textColor(Color.BLACK)
									                .font(fontMarathi)
									                .fontSize(8)				              
									                .horizontalAlignment(CENTER)
									                .height(20F)					                
									                .build();
					        		  }
						        	  
						        	  tableStmtDetailsBuilder.addRow(row);
						        	 
						        	  currentY = currentY -20;
					        	  }
						          
						          
						         Row totalRow = Row.builder()
						        		 .add(TextCell.builder().text("Opening Bal :") .horizontalAlignment(LEFT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	.add(TextCell.builder().text(""+df.format(this.getYesterdayBallanceAmt())).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	.add(TextCell.builder().text("Total:") .horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	.add(TextCell.builder().text(df.format(ttlCrAmt)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	.add(TextCell.builder().text(df.format(ttlDrAmt)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	.add(TextCell.builder().text(df.format(balAmt)).horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	.add(TextCell.builder().text("").horizontalAlignment(RIGHT).borderWidth(0.5F).lineSpacing(0.2F).build())				                
					        			  	.backgroundColor(Color.WHITE)
							                .textColor(Color.BLACK)
							                .font(PDType1Font.HELVETICA_BOLD)
							                .fontSize(9)				              
							                .horizontalAlignment(CENTER)
							                .height(20F)					                
							                .build();
						          
						         tableStmtDetailsBuilder.addRow(totalRow);
						          stmtDetails = tableStmtDetailsBuilder.build();
						          
						          TableDrawer.builder()
					                .contentStream(contentStream)
					                .table(stmtDetails)
					                .startX(PADDING30)
					                .startY(startY-50)
					                .build()
					                .draw();
						          contentStream.close();
							          
						          
						          document.save(path+"/acc-stmt.pdf");
							        document.close();
							        
							        response.setHeader("Content-disposition", "inline; filename=supp-acc-stmt.pdf");
									response.setContentType("application/pdf");
									
									FileInputStream fileInputStream = new FileInputStream(path+"/acc-stmt.pdf");
									PrintWriter out = response.getWriter();  
									int bytes;
									while ((bytes = fileInputStream.read()) != -1) {
										out.write(bytes);
									}
									fileInputStream.close();
									out.flush();
									out.close();
									ttf1.close();
						          
					
				}
				else
				{
					addActionError("Details not found! Please try again!");
				}
				
				
				
			}catch (SQLException e) {
				e.printStackTrace();
				addActionError(e.getErrorCode()+" || "+e.getMessage() +" || Account details not found!");
			} catch (Exception e) {
				e.printStackTrace();
				addActionError(e.getMessage()+" || "+e.getCause()+" || Account details not found !");
			}finally {
				if(resultSet != null)
				{
					try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
				}
				if(preparedStatement != null)
				{
					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
				}
				if(connection != null)
				{
					
					try {connection.close(); connection = null;}catch (SQLException e) {}
				}
				
			}
        }
	}


	public HttpServletRequest getRequest() {
		return request;
	}


	public void setRequest(HttpServletRequest request) {
		this.request = request;
	}


	public HttpServletResponse getResponse() {
		return response;
	}


	public void setResponse(HttpServletResponse response) {
		this.response = response;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getFromDate() {
		return fromDate;
	}


	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}


	public String getToDate() {
		return toDate;
	}


	public void setToDate(String toDate) {
		this.toDate = toDate;
	}


	public String getAccountId() {
		return accountId;
	}


	public void setAccountId(String accountId) {
		this.accountId = accountId;
	}


	


	public List<BankAccountStatementDAO> getReportList() {
		return reportList;
	}


	public void setReportList(List<BankAccountStatementDAO> reportList) {
		this.reportList = reportList;
	}


	public static long getSerialversionuid() {
		return serialVersionUID;
	}
	

public SessionMap<String, Object> getSessionMap() {
return sessionMap;
}

public void setSessionMap(SessionMap<String, Object> sessionMap) {
this.sessionMap = sessionMap;
}

public void setSession(Map<String, Object> map) {  
sessionMap=(SessionMap<String, Object>)map;  
}


public Float getYesterdayBallanceAmt() {
	return yesterdayBallanceAmt;
}


public void setYesterdayBallanceAmt(Float yesterdayBallanceAmt) {
	this.yesterdayBallanceAmt = yesterdayBallanceAmt;
}

	
}
