package com.stonecrusher.delete;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DeleteVehicleTripEntry extends ActionSupport{

	/**
	 * 
	 */
	private static final long serialVersionUID = 5555731197485335005L;
	
	private HttpSession session;
	private String key;
	private String billNo;
	
	public String execute(){
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String tripId  = "";
	        	try {
					
	        		tripId = EncryptionDecryption.decrypt(URLDecoder.decode(this.getKey(),"UTF-8"));
				} catch (UnsupportedEncodingException e1) {
					result = "error";
					addActionError(this.getText("message.error.errorWhiledecryptionTheKey")+e1.getMessage());
				}
	        	
	        	if(!hasActionErrors())
	        	{
	        	Connection connection = null;
	       		PreparedStatement preparedStatement= null;
	       		ResultSet resultSet = null;
	       		
	       		String sql = "";
	       		String db = (String) session.getAttribute("db");
	       		
	       		String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	       		try {
	       			
	       			connection = GetDBConnection.getDBConnection(db);
	       			
	       			if(!this.getBillNo().equals("0"))
	       			{
	       		sql = "DELETE "
	       				+ "FROM "
	       				+ "crusher_vehicle_trip_master "
	       				+ "WHERE "
	       				+ "trip_entry_id = ? "
	       				+ "AND "
						+ "crusher_id = ? "
						+ "AND "
						+ "crusher_code = ?";
	       			}else {
	       				
	       				sql = "DELETE "
	    	       				+ "FROM "
	    	       				+ "crusher_vehicle_trip_other_master "
	    	       				+ "WHERE "
	    	       				+ "trip_entry_id = ? "
	    	       				+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	       				
	       			}
	       		preparedStatement = connection.prepareStatement(sql);
	       		
	       		preparedStatement.setString(1, tripId);
	       		preparedStatement.setString(2, crusherId);
				preparedStatement.setString(3, crusherCode);
				
	       		int rowCountDeleted = preparedStatement.executeUpdate();
	       		
	       		if(rowCountDeleted > 0)
	       		{
	       			result = "success";
	       			addActionMessage(this.getText("message.success.tripEntrydetailsDeletedSuccessfully"));
	       		}
	       		else
	       		{
	       			result = "error";
	       			addActionError(this.getText("message.error.tripEntryDetailsNotDeleted"));
	       		}
	       		}
	       		catch (SQLException e) 
	       		{
	       			e.printStackTrace();
	        		result = "error";
	        		addActionMessage(e.getErrorCode()+"||"+e.getMessage()+"|| "+this.getText("message.error.tripEntryDetailsNotDeleted"));
			
	       		} 
	       		
	       		catch (IOException e) {
	       			e.printStackTrace();
					
					result = "error";
					addActionMessage(e.getMessage()+"|| "+this.getText("message.error.tripEntryDetailsNotDeleted"));
				}	
	   			finally
	   			{
	   				if(resultSet != null)
					{
						try 
						{
							resultSet.close();
							resultSet = null;
						
						}catch (SQLException e) {
							
						}
					}
	   				if(preparedStatement != null)
	   				{
	   					try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	   				}
	   				if(connection != null)
	   				{
	   					try {connection.close(); connection = null;} catch (SQLException e) {}
	   				}
	   				
	   			}
	        	}else
	        	{
	        		result = "error";
	        		addActionError(this.getText("message.error.urlTemperedTripEntryDetailsNotdeleted"));
	        	}
		        	
		        
		        }
		
		        return result;
	}
		public HttpSession getSession() {
			return session;
		}
		public void setSession(HttpSession session) {
			this.session = session;
		}
		public String getKey() {
			return key;
		}
		public void setKey(String key) {
			this.key = key;
		}
		public String getBillNo() {
			return billNo;
		}
		public void setBillNo(String billNo) {
			this.billNo = billNo;
		}

}
