package com.stonecrusher.delete;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.TaxDAO;
import com.stonecrusher.db.GetDBConnection;

public class DeleteTax extends ActionSupport{
	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2947854572752689089L;
	private HttpSession session;
	private String taxName;
	private List<TaxDAO> taxList = new ArrayList<TaxDAO>();
	
	
	@Override
	public String execute() throws Exception {
		
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage("Please Login First !!!");
	        	result = "login";
	        }  
	        else
	        {
	        	
	        	Connection connection = null;
				PreparedStatement preparedStatement= null;
				ResultSet resultSet = null;
				
				String sql = "";
				String db = (String) session.getAttribute("db");
				
				try
				{
					connection = new GetDBConnection().getDBConnection(db);
					
					sql = "delete from tax_table where taxname = ?";
					
					preparedStatement = connection.prepareStatement(sql);
					preparedStatement.setString(1, taxName);
					int i = preparedStatement.executeUpdate();
					
					preparedStatement.close();
					
					sql = "select taxname,taxpercentage "
							+ "from tax_table order by taxpercentage";
					
					preparedStatement = connection.prepareStatement(sql);
					resultSet = preparedStatement.executeQuery();
					
					int serial = 1;
					
					while(resultSet.next())
					{
						TaxDAO taxDAO = new TaxDAO();
						taxDAO.setSerial(""+serial);
						taxDAO.setTaxName(resultSet.getString(1));
						taxDAO.setTaxPercentage((String)resultSet.getString(2));
						taxList.add(taxDAO);
						serial++;
					}
					
					if(i>0)
					{
					
						setTaxName("");
						result = "success";
						
						addActionMessage("TAX deleted Successfully !");
					}
					else
					{
						result = "error";
						addActionError("TAX Not Deleted !");
					}
					
				} catch (SQLException e) {
					result = "error";
					
					addActionError(e.getErrorCode()+" || "+e.getMessage() +" || TAX Not Delete !!!");
				} catch (IOException e) {
					result = "error";
					
					addActionError(e.getMessage()+" || "+e.getCause()+" || TAX Not Delete !!!");
				}finally {
					if(resultSet != null)
    				{
    					try {
    						resultSet.close();
    					} catch (SQLException e) {
    						
    					}
    				}
					if(preparedStatement != null)
					{
						try {preparedStatement.close();} catch (SQLException e) {}
					}
					if(connection != null)
					{
						
						try {connection.close();}catch (SQLException e) {}
					}
					
				}
	        	
	        }
	        return result;
	}


	public HttpSession getSession() {
		return session;
	}


	public void setSession(HttpSession session) {
		this.session = session;
	}


	public String getTaxName() {
		return taxName;
	}


	public void setTaxName(String taxName) {
		this.taxName = taxName;
	}


	public List<TaxDAO> getTaxList() {
		return taxList;
	}


	public void setTaxList(List<TaxDAO> taxList) {
		this.taxList = taxList;
	}
	
	

}
