package com.stonecrusher.delete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class DeleteSupplierPaymentEntry extends ActionSupport implements SessionAware{


	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2164936083473968026L;
	private HttpSession session;
	private String key;
	private String paymentPurchaseId;
	private String supplierName;
	private String supplierAddress;
	private String supplierMobile;
	private SessionMap<String,Object> sessionMap;  
	
	private String fromDate;
	private String toDate;
	
	@SuppressWarnings("resource")
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		java.util.Date date = new java.util.Date();
	      	      long t = date.getTime();	        	     
	      	      java.sql.Time time = new java.sql.Time(t);
					
					String user = (String) this.getSessionMap().get("userFullName");
					String userName = "";
					
					try
					{
						userName = user.split(" ")[0];
					}catch(Exception e)
					{
						userName = user;
					}
					
	    		try
	    		{
	    			
	    			String supplierId  = EncryptionDecryption.decrypt(this.getKey());
	    			
	    			
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
	    			
	    			if(!hasActionErrors())
	    			{
	    				
	    				
	    				sql = "SELECT "
								+ "credit_debit_id "
								+ "FROM "
								+ "crusher_supplier_payment_details_master "
								+ "WHERE "
	    						+ "entry_id = ? "
	    						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, paymentPurchaseId);
	    				preparedStatement.setString(2, crusherId);
	    				preparedStatement.setString(3, crusherCode);
	    				
						resultSet = preparedStatement.executeQuery();
						
						
						if(resultSet.next()){
							String crditDebitId = resultSet.getString(1);
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							sql = "SELECT "
									+ "entry_id,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
									
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							int m = 0;
							String paymentType = null;
							String entryDate1 = null;
							String accountId = null;
							Float amount = null;
							
							if(resultSet.next())
							{
								accountId = resultSet.getString(2);
							    paymentType = resultSet.getString(6);
								 entryDate1 = resultSet.getString(4);
								 amount = resultSet.getFloat(7);
								 
								PreparedStatement  insertIntoDeletedPSMT = null;
								
								String inertDeletedSQL = "INSERT "
										+ "INTO "
										+ "bank_account_credit_debit_deleted_entry_master "
										+ "("
										+ "entry_id,"
										+ "crusher_id,"
				        				+ "crusher_code,"
				        				+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details) "
										+ "VALUES "
										+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
								
								insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
								
								insertIntoDeletedPSMT.setString(1, crditDebitId);
								insertIntoDeletedPSMT.setString(2, crusherId);
								insertIntoDeletedPSMT.setString(3, crusherCode);
				        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
								insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
								insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
								insertIntoDeletedPSMT.setTime(7, time);
								insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
								insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
								insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
								insertIntoDeletedPSMT.setString(11, userName);
								insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
								
								  m = insertIntoDeletedPSMT.executeUpdate();
								
								if(insertIntoDeletedPSMT != null)
								{
									insertIntoDeletedPSMT.close();
									insertIntoDeletedPSMT = null;
								}
								
							}
							
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(m>0)
							{
								

							
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(k>0  )
							{
								boolean isCloseingBalMaintained = false;
							    
								SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(entryDate1); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
								   
								    if (paymentType.equals("CREDIT")) {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, userName, connection, this.getSessionMap());
								    } else {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, userName, connection, this.getSessionMap());
								    }
								}
						
							
							
								sql ="DELETE "
			    						+ "FROM "
			    						+ "crusher_supplier_payment_details_master "
			    						+ "WHERE "
			    						+ "entry_id = ? "
			    						+ "AND "
			    						+ "supplier_id = ? "
			    						+ "AND "
		        						+ "crusher_id = ? "
		    							+ "AND "
		    							+ "crusher_code = ?";
			    				
			    				preparedStatement = connection.prepareStatement(sql);
			    				preparedStatement.setString(1, paymentPurchaseId);
			    				preparedStatement.setString(2, supplierId);
			    				preparedStatement.setString(3, crusherId);
		        				preparedStatement.setString(4, crusherCode);
							
							int rowCount = preparedStatement.executeUpdate();
							
							if(rowCount > 0)
							{
								
								if(preparedStatement != null)
		    					{
		    						preparedStatement.close();
		    						preparedStatement = null;
		    					}
		    					
		    					sql = "SELECT "
		    							+ "supplier_name,"
		    							+ "supplier_address,"
		    							+ "contact_number "
		    							+ "FROM "
		    							+ "crusher_supplier_master "
		    							+ "WHERE "
		    							+ "supplier_id = ? "
		    							+ "AND "
		        						+ "crusher_id = ? "
		    							+ "AND "
		    							+ "crusher_code = ?";
		    					
		    					preparedStatement = connection.prepareStatement(sql);
		    					
		    					preparedStatement.setString(1, supplierId);
		    					preparedStatement.setString(2, crusherId);
		        				preparedStatement.setString(3, crusherCode);
		        				
		    					resultSet = preparedStatement.executeQuery();
		    					
		    					if(resultSet.next()){
		    						this.setSupplierName(resultSet.getString(1));
		    						this.setSupplierAddress(resultSet.getString(2));
		    						this.setSupplierMobile(resultSet.getString(3));
		    					}
		    					
		    					addActionMessage(this.getText("message.success.supplierPaymentEntryDeletedSuccessfully"));
		    						connection.commit();
									
									result = SUCCESS;
								
							}
	    				else
	    				{
	    					connection.rollback();
	    					addActionError(this.getText("message.error.supplierPaymentEntryNotDeleted"));
	    					result = "error";
	    				}
	    			
	    			
						}
	    			}
						
						}
	    			}
					}
	    			
	    		catch (SQLException e) {
	    			e.printStackTrace();
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.supplierPaymentEntryNotDeleted"));
	    		}
	    		catch (Exception e) {
	    			e.printStackTrace();
	    			addActionError(e.getMessage() +" || "+this.getText("message.error.supplierPaymentEntryNotDeleted"));
				}finally {
	    			if(resultSet != null)
   				{
   					try {
   						resultSet.close();
   						resultSet = null;
   					} catch (SQLException e) {
   						
   					}
   				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
       	
       	
       	
       	
       }
	    
	   
       
       return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getSupplierAddress() {
		return supplierAddress;
	}

	public void setSupplierAddress(String supplierAddress) {
		this.supplierAddress = supplierAddress;
	}

	public String getSupplierMobile() {
		return supplierMobile;
	}

	public void setSupplierMobile(String supplierMobile) {
		this.supplierMobile = supplierMobile;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getPaymentPurchaseId() {
		return paymentPurchaseId;
	}

	public void setPaymentPurchaseId(String paymentPurchaseId) {
		this.paymentPurchaseId = paymentPurchaseId;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	
	


	
	
}
