package com.stonecrusher.delete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.update.UpdateProductStockDetails;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class DeleteSupplierDieselAdbluePurchaseEntry extends ActionSupport implements SessionAware{

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private HttpSession session;
	private String paymentPurchaseId;
	
	private String key;
	private String supplierName;
	private String supplierAddress;
	private String supplierMobile;
	private SessionMap<String,Object> sessionMap;  
	
	private String fromDate;
	private String toDate;
	
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
        		String fullUserName = (String) session.getAttribute("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	String deletedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		deletedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		deletedBy =fullUserName;
	        	}
	        	
	        	
	        	java.util.Date date = new java.util.Date();
	      	      long t = date.getTime();	        	     
	      	      java.sql.Time time = new java.sql.Time(t);
					
					
						
					
					
	        	
	        	
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			String supplierId  = EncryptionDecryption.decrypt(this.getKey());
	    			
	    		
					connection = GetDBConnection.getDBConnection(db);
	    			connection.setAutoCommit(false);
	    			if(this.getPaymentPurchaseId() ==null || this.getPaymentPurchaseId().equals("") || this.getPaymentPurchaseId().length()>6)
	    			{
	    				addActionError(this.getText("message.error.urlTemperedPlzTryAgain"));
	    				result = "error";
	    			}
	    			if(!hasActionErrors())
	    			{
	    				
	    				sql = "SELECT "
								+ "credit_debit_id,"
								+ "vehicle_consumption_id "
								+ "FROM "
								+ "crusher_purchase_master "
								+ "WHERE "
	    						+ "purchase_id = ? "
	    						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, this.getPaymentPurchaseId());
	    				preparedStatement.setString(2, crusherId);
	    				preparedStatement.setString(3, crusherCode);
	    				
						resultSet = preparedStatement.executeQuery();
						
						
						if(resultSet.next()){
							String crditDebitId = resultSet.getString(1);
							String vehicleConsumptionId = resultSet.getString(2);
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							sql = "SELECT "
									+ "entry_id,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
									
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							int m = 0;
							String paymentType = null;
							String entryDate1 = null;
							String accountId = null;
							Float amount = null;
							
							if(resultSet.next())
							{
								accountId = resultSet.getString(2);
							    paymentType = resultSet.getString(6);
								 entryDate1 = resultSet.getString(4);
								 amount = resultSet.getFloat(7);
								 
								PreparedStatement  insertIntoDeletedPSMT = null;
								
								String inertDeletedSQL = "INSERT "
										+ "INTO "
										+ "bank_account_credit_debit_deleted_entry_master "
										+ "("
										+ "entry_id,"
										+ "crusher_id,"
				        				+ "crusher_code,"
				        				+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details) "
										+ "VALUES "
										+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
								
								insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
								
								insertIntoDeletedPSMT.setString(1, crditDebitId);
								insertIntoDeletedPSMT.setString(2, crusherId);
								insertIntoDeletedPSMT.setString(3, crusherCode);
				        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
								insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
								insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
								insertIntoDeletedPSMT.setTime(7, time);
								insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
								insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
								insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
								insertIntoDeletedPSMT.setString(11, deletedBy);
								insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
								
								  m = insertIntoDeletedPSMT.executeUpdate();
								
								if(insertIntoDeletedPSMT != null)
								{
									insertIntoDeletedPSMT.close();
									insertIntoDeletedPSMT = null;
								}
								
							}
							
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(m>0)
							{
								

							
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, crditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(k>0  )
							{
								boolean isCloseingBalMaintained = false;
							    
								SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(entryDate1); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
								   
								    if (paymentType.equals("CREDIT")) {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, deletedBy, connection, this.getSessionMap());
								    } else {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, deletedBy, connection, this.getSessionMap());
								    }
								}
						
								
			    			}
			    		}
							
						
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							
							
							String productId = "";
							Float productQty = 0.0F;
							String productName = "";
							String dieselCreditDebitId = "";
							String adblueCreditDebitId = "";
							
							sql = "SELECT "
									+ "consumption_product_id,"
									+ "quantity,"
									+ "diesel_credit_debit_id,"
									+ "consumption_product_name,"
									+ "adblue_credit_debit_id "
									+ "FROM "
									+ "crusher_vehicle_consumption_master "
									+ "WHERE "
									+ "vehicle_expense_entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, vehicleConsumptionId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							
							resultSet = preparedStatement.executeQuery();
							
							if(resultSet.next())
							{
								productId = resultSet.getString(1);
								productQty = resultSet.getFloat(2);
								dieselCreditDebitId = resultSet.getString(3);
								productName = resultSet.getString(4);
								adblueCreditDebitId = resultSet.getString(5);
							}
							
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(!productId.equals(""))
							{
								sql = "DELETE "
										+ "FROM "
										+ "crusher_vehicle_consumption_master "
										+ "WHERE "
										+ "vehicle_expense_entry_id = ? "
										+ "AND "
										+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ? ";
								
								preparedStatement = connection.prepareStatement(sql);
								preparedStatement.setString(1, vehicleConsumptionId);
								preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								
								
								int rowCount = preparedStatement.executeUpdate();
								
								if(rowCount > 0)
								{
									boolean stockPlus = UpdateProductStockDetails.addStockToCurrentStock(this.getSessionMap(), productId, productQty);
									if(stockPlus)
									{
										
										boolean isCloseingBalMaintained = false;
										
										if(productName.equals("DIESEL"))
										{
											if(resultSet != null)
											{
												try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
											}
											if(preparedStatement != null)
											{
												try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
											}
											
										sql = "SELECT "
												+ "entry_id,"
												+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details "
												+ "FROM "
												+ "diesel_credit_debit_master "
												+ "WHERE "
												+ "entry_id = ? "
												+ "AND "
												+ "crusher_id = ? "
												+ "AND "
												+ "crusher_code = ? ";
										
										preparedStatement = connection.prepareStatement(sql);
										preparedStatement.setString(1, dieselCreditDebitId);
										preparedStatement.setString(2, crusherId);
										preparedStatement.setString(3, crusherCode);

										
										resultSet = preparedStatement.executeQuery();
										
										int m1 = 0;
										if(resultSet.next())
										{
											
											PreparedStatement  insertIntoDeletedPSMT = null;
											
											String inertDeletedSQL = "INSERT "
													+ "INTO "
													+ "diesel_credit_debit_deleted_entry_master "
													+ "("
													+ "entry_id,"
													+ "crusher_id,"
													+ "crusher_code,"
													+ "product_id,"
													+ "product_name,"
													+ "entry_date,"
													+ "entry_time,"
													+ "entry_type,"
													+ "quantity,"
													+ "entry_by,"
													+ "entry_details) "
													+ "VALUES "
													+ "(?,?,?,?,?,?,?,?,?,?,?)";
											
											insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
											
											insertIntoDeletedPSMT.setString(1, dieselCreditDebitId);
											insertIntoDeletedPSMT.setString(2, crusherId);
											insertIntoDeletedPSMT.setString(3, crusherCode);
											insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
											insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
											insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
											insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
											insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
											insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
											insertIntoDeletedPSMT.setString(10, deletedBy);
											insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
											
											
											  m1 = insertIntoDeletedPSMT.executeUpdate();
											  
											  String paymentType1 = resultSet.getString(6);
											  
											  
											  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
												Date parsedDate = null;

												try {
												    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
												} catch (ParseException e) {
												    e.printStackTrace();  
												}

												if (parsedDate != null) {
												     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
												    String formattedDate = outputDateFormat.format(parsedDate); 
									
												    
											 
											    
											    
											  
											  
											  if (paymentType1.equals("CREDIT")) {
											   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
											  }else {
												   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
												  
											  }
												}
											  
											if(insertIntoDeletedPSMT != null)
											{
												insertIntoDeletedPSMT.close();
												insertIntoDeletedPSMT = null;
											}
											
											if(resultSet != null)
											{
												resultSet.close();
												resultSet = null;
											}
											if(preparedStatement != null)
											{
												preparedStatement.close();
												preparedStatement = null;
											}
											
											
											if(m1>0)
											{
												
												
											
											sql = "DELETE "
													+ "FROM "
													+ "diesel_credit_debit_master "
													+ "WHERE "
													+ "entry_id = ? "
													+ "AND "
													+ "crusher_id = ? "
													+ "AND "
													+ "crusher_code = ? ";
											
											preparedStatement = connection.prepareStatement(sql);
											preparedStatement.setString(1, dieselCreditDebitId);
											preparedStatement.setString(2, crusherId);
											preparedStatement.setString(3, crusherCode);
											
											int k = preparedStatement.executeUpdate();
											}
											
										}
										
									
										
									}
										
										
										
										if(productName.equals("ADBLUE") || productName.equals("DEF"))
										{
											if(resultSet != null)
											{
												try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
											}
											if(preparedStatement != null)
											{
												try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
											}
											
										sql = "SELECT "
												+ "entry_id,"
												+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details "
												+ "FROM "
												+ "adblue_credit_debit_master "
												+ "WHERE "
												+ "entry_id = ? "
												+ "AND "
												+ "crusher_id = ? "
												+ "AND "
												+ "crusher_code = ? ";
										
										preparedStatement = connection.prepareStatement(sql);
										preparedStatement.setString(1, adblueCreditDebitId);
										preparedStatement.setString(2, crusherId);
										preparedStatement.setString(3, crusherCode);

										
										resultSet = preparedStatement.executeQuery();
										
										int m1 = 0;
										if(resultSet.next())
										{
											
											PreparedStatement  insertIntoDeletedPSMT = null;
											
											String inertDeletedSQL = "INSERT "
													+ "INTO "
													+ "adblue_credit_debit_deleted_entry_master "
													+ "("
													+ "entry_id,"
													+ "crusher_id,"
													+ "crusher_code,"
													+ "product_id,"
													+ "product_name,"
													+ "entry_date,"
													+ "entry_time,"
													+ "entry_type,"
													+ "quantity,"
													+ "entry_by,"
													+ "entry_details) "
													+ "VALUES "
													+ "(?,?,?,?,?,?,?,?,?,?,?)";
											
											insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
											
											insertIntoDeletedPSMT.setString(1, adblueCreditDebitId);
											insertIntoDeletedPSMT.setString(2, crusherId);
											insertIntoDeletedPSMT.setString(3, crusherCode);
											insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
											insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
											insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
											insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
											insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
											insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
											insertIntoDeletedPSMT.setString(10, deletedBy);
											insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
											
											
											  m1 = insertIntoDeletedPSMT.executeUpdate();
											  
											  String paymentType1 = resultSet.getString(6);
											  
											  
											  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
												Date parsedDate = null;

												try {
												    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
												} catch (ParseException e) {
												    e.printStackTrace();  
												}

												if (parsedDate != null) {
												     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
												    String formattedDate = outputDateFormat.format(parsedDate); 
									
												    
											 
											    
											    
											  
											  
											  if (paymentType1.equals("CREDIT")) {
											   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
											  }else {
												   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
												  
											  }
												}
											  
											if(insertIntoDeletedPSMT != null)
											{
												insertIntoDeletedPSMT.close();
												insertIntoDeletedPSMT = null;
											}
											
											if(resultSet != null)
											{
												resultSet.close();
												resultSet = null;
											}
											if(preparedStatement != null)
											{
												preparedStatement.close();
												preparedStatement = null;
											}
											
											
											if(m1>0)
											{
												
												
											
											sql = "DELETE "
													+ "FROM "
													+ "adblue_credit_debit_master "
													+ "WHERE "
													+ "entry_id = ? "
													+ "AND "
													+ "crusher_id = ? "
													+ "AND "
													+ "crusher_code = ? ";
											
											preparedStatement = connection.prepareStatement(sql);
											preparedStatement.setString(1, adblueCreditDebitId);
											preparedStatement.setString(2, crusherId);
											preparedStatement.setString(3, crusherCode);
											
											int k = preparedStatement.executeUpdate();
											}
											
										}
										
									
										
									}
										
										
										
									}
									
								}
								
							}
							
			    			}
							}
							
	    				sql = "SELECT "
	    						+ "purchase_id,"
	    						+ "purchase_invoice_number,"
	    						+ "purchase_date,"
	    						+ "purchase_time,"
	    						+ "payemnt_type,"
	    						+ "supplier_id,"
	    						+ "supplier_name,"
	    						+ "tarnsportation_charges,"
	    						+ "other_expenses,"
	    						+ "purchase_total_amount,"
	    						+ "purchase_amount_paid,"
	    						+ "purchase_total_igst_amount,"
	    						+ "purchase_total_cgst_amount,"
	    						+ "purchase_total_sgst_amount,"
	    						+ "purchase_total_nett_amount,"
	    						+ "purcahsed_by,"
	    						+ "purchase_invoice_pic,"
	    						+ "purchase_entry_by,"
	    						+ "purchase_type,"
	    						+ "comments "
	    						+ "FROM "
	    						+ "crusher_purchase_master "
	    						+ "WHERE "
	    						+ "purchase_id = ? "
	    						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				
	    				preparedStatement.setString(1, this.getPaymentPurchaseId());
	    				preparedStatement.setString(2, crusherId);
        				preparedStatement.setString(3, crusherCode);
        				
	    				resultSet = preparedStatement.executeQuery();
	    				
	    				
	    				String invoiceNo; 
	    						
	    				if(resultSet.next())
	    				{
	    					
	    					invoiceNo = resultSet.getString("purchase_invoice_number");
	    					
	    					PreparedStatement insertIntoDeleteTbPSMT = null;
	    					String insertDeleteSQL = "INSERT INTO "
	    		        			+ "crusher_deleted_purchase_info_master"
	    		        			+ "( "
	    		        			+ "purchase_id,"
		    						+ "crusher_id,"
		    						+ "crusher_code,"
		    						+ "purchase_invoice_number,"
		    						+ "purchase_date,"
		    						+ "purchase_time,"
		    						+ "payemnt_type,"
		    						+ "supplier_id,"
		    						+ "supplier_name,"
		    						+ "tarnsportation_charges,"
		    						+ "other_expenses,"
		    						+ "purchase_total_amount,"
		    						+ "purchase_amount_paid,"
		    						+ "purchase_total_igst_amount,"
		    						+ "purchase_total_cgst_amount,"
		    						+ "purchase_total_sgst_amount,"
		    						+ "purchase_total_nett_amount,"
		    						+ "purcahsed_by,"
		    						+ "purchase_invoice_pic,"
		    						+ "purchase_entry_by,"
		    						+ "purchase_type,"
		    						+ "comments) "
	    	    					+ "VALUES "
	    	    					+ "(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
	    		        			
	    		        	
	    					insertIntoDeleteTbPSMT = connection.prepareStatement(insertDeleteSQL);
	    		        	
	    		        	
	    					   insertIntoDeleteTbPSMT.setString(1, resultSet.getString("purchase_id"));
	    					    insertIntoDeleteTbPSMT.setString(2, crusherId);
	    					    insertIntoDeleteTbPSMT.setString(3, crusherCode);
	    					    insertIntoDeleteTbPSMT.setString(4, resultSet.getString("purchase_invoice_number"));
	    					    insertIntoDeleteTbPSMT.setDate(5, resultSet.getDate("purchase_date"));
	    					    insertIntoDeleteTbPSMT.setTime(6, resultSet.getTime("purchase_time"));
	    					    insertIntoDeleteTbPSMT.setString(7, resultSet.getString("payemnt_type"));
	    					    insertIntoDeleteTbPSMT.setString(8, resultSet.getString("supplier_id"));
	    					    insertIntoDeleteTbPSMT.setString(9, resultSet.getString("supplier_name"));
	    					    insertIntoDeleteTbPSMT.setDouble(10, resultSet.getDouble("tarnsportation_charges"));
	    					    insertIntoDeleteTbPSMT.setDouble(11, resultSet.getDouble("other_expenses"));
	    					    insertIntoDeleteTbPSMT.setDouble(12, resultSet.getDouble("purchase_total_amount"));
	    					    insertIntoDeleteTbPSMT.setDouble(13, resultSet.getDouble("purchase_amount_paid"));
	    					    insertIntoDeleteTbPSMT.setDouble(14, resultSet.getDouble("purchase_total_igst_amount"));
	    					    insertIntoDeleteTbPSMT.setDouble(15, resultSet.getDouble("purchase_total_cgst_amount"));
	    					    insertIntoDeleteTbPSMT.setDouble(16, resultSet.getDouble("purchase_total_sgst_amount"));
	    					    insertIntoDeleteTbPSMT.setDouble(17, resultSet.getDouble("purchase_total_nett_amount"));
	    					    insertIntoDeleteTbPSMT.setString(18, resultSet.getString("purcahsed_by"));
	    					    insertIntoDeleteTbPSMT.setString(19, resultSet.getString("purchase_invoice_pic"));
	    					    insertIntoDeleteTbPSMT.setString(20, resultSet.getString("purchase_entry_by"));
	    					    insertIntoDeleteTbPSMT.setString(21, resultSet.getString("purchase_type"));
	    					    insertIntoDeleteTbPSMT.setString(22, resultSet.getString("comments"));
	    					    
	    		        	int countBillInfoDeleted = insertIntoDeleteTbPSMT.executeUpdate();
	    		        	
	    		        	boolean stockMinus = false;

	    		        	String productId = null;
	    		        	String productName = null;
	    		        	float quantity = 0;
	    		        	int deletedProCount = 0;

	    		        	if (countBillInfoDeleted > 0) {
	    		        		
	    		        		
	    		        		if(preparedStatement != null)
								{
									preparedStatement.close();
									preparedStatement = null;
								}
	    		        		

	    		        		if(resultSet != null)
								{
	    		        			resultSet.close();
	    		        			resultSet = null;
								}
	    		        		
								
								sql = "SELECT "
			  							+ "diesel_credit_debit_id,"
			  							+ "product_name,"
			  							+ "adblue_credit_debit_id "
			  							+ "FROM "
			  							+ "crusher_purchase_product_info_master "
			  							+ "WHERE "
					        			+ "purchase_id = ? "
					        			+ "AND "
					        			+ "crusher_id = ? "
										+ "AND "
										+ "crusher_code = ?";
								
								preparedStatement = connection.prepareStatement(sql);
								
								preparedStatement.setString(1, this.getPaymentPurchaseId());
					        	preparedStatement.setString(2, crusherId);
								preparedStatement.setString(3, crusherCode);
								
								resultSet = preparedStatement.executeQuery();
								
								
								if(resultSet.next()){
									
									
									
									String dieselCreditDebitId = resultSet.getString(1);
									String productName1 = resultSet.getString(2);
									String adblueCreditDebitId = resultSet.getString(3);
									
									if(productName1.trim().equals("DIESEL"))
									{
										
									
									sql = "SELECT "
											+ "entry_id,"
											+ "product_id,"
											+ "product_name,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "quantity,"
											+ "entry_by,"
											+ "entry_details "
											+ "FROM "
											+ "diesel_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, dieselCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);

									
									resultSet = preparedStatement.executeQuery();
									
									int m = 0;
									if(resultSet.next())
									{
										
										PreparedStatement  insertIntoDeletedPSMT = null;
										
										String inertDeletedSQL = "INSERT "
												+ "INTO "
												+ "diesel_credit_debit_deleted_entry_master "
												+ "("
												+ "entry_id,"
												+ "crusher_id,"
												+ "crusher_code,"
												+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details) "
												+ "VALUES "
												+ "(?,?,?,?,?,?,?,?,?,?,?)";
										
										insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
										
										insertIntoDeletedPSMT.setString(1, dieselCreditDebitId);
										insertIntoDeletedPSMT.setString(2, crusherId);
										insertIntoDeletedPSMT.setString(3, crusherCode);
										insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
										insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
										insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
										insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
										insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
										insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
										insertIntoDeletedPSMT.setString(10, deletedBy);
										insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
										
										
										  m = insertIntoDeletedPSMT.executeUpdate();
										  
										  String paymentType = resultSet.getString(6);
										  
										  
										  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
											Date parsedDate = null;

											try {
											    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
											} catch (ParseException e) {
											    e.printStackTrace();  
											}

											if (parsedDate != null) {
											     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
											    String formattedDate = outputDateFormat.format(parsedDate); 
								
											    
										 
										    
										    
										  boolean isCloseingBalMaintained = false;
										  
										  if (paymentType.equals("CREDIT")) {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
										  }else {
											   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalDiesel(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
											  
										  }
											}
										  
										if(insertIntoDeletedPSMT != null)
										{
											insertIntoDeletedPSMT.close();
											insertIntoDeletedPSMT = null;
										}
										
									}
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									
									
									if(m>0)
									{
										
										
									
									sql = "DELETE "
											+ "FROM "
											+ "diesel_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, dieselCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);
									
									int k = preparedStatement.executeUpdate();
									
									
									if(k > 0 )
									{
										sql = "UPDATE "
		        	        					+ "crusher_purchase_product_info_master "
		        	        					+ "SET "
		        	        					+ "diesel_credit_debit_id = ? "
		        	        					+ "WHERE "
		    									+ "purchase_id = ? "
		    									+ "AND "
		    									+ "product_name = ? "
		    									+ "AND "
		    									+ "crusher_id = ? "
		    									+ "AND "
		    									+ "crusher_code = ? ";
		        	        			
		        	        			
			    						preparedStatement = connection.prepareStatement(sql);
			    						
			    						preparedStatement.setString(1, null);
			    						preparedStatement.setString(2, this.getPaymentPurchaseId());
			    						preparedStatement.setString(3, productName1);
			    						preparedStatement.setString(4, crusherId);
			    		        		preparedStatement.setString(5, crusherCode);
			    		        		
			    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
			        				
			    						
			    						
									}
					    		}
								}
									
									
									
									if(productName1.trim().equals("ADBLUE") || productName1.trim().equals("DEF"))
									{
										
									
									sql = "SELECT "
											+ "entry_id,"
											+ "product_id,"
											+ "product_name,"
											+ "entry_date,"
											+ "entry_time,"
											+ "entry_type,"
											+ "quantity,"
											+ "entry_by,"
											+ "entry_details "
											+ "FROM "
											+ "adblue_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, adblueCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);

									
									resultSet = preparedStatement.executeQuery();
									
									int m = 0;
									if(resultSet.next())
									{
										
										PreparedStatement  insertIntoDeletedPSMT = null;
										
										String inertDeletedSQL = "INSERT "
												+ "INTO "
												+ "adblue_credit_debit_deleted_entry_master "
												+ "("
												+ "entry_id,"
												+ "crusher_id,"
												+ "crusher_code,"
												+ "product_id,"
												+ "product_name,"
												+ "entry_date,"
												+ "entry_time,"
												+ "entry_type,"
												+ "quantity,"
												+ "entry_by,"
												+ "entry_details) "
												+ "VALUES "
												+ "(?,?,?,?,?,?,?,?,?,?,?)";
										
										insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
										
										insertIntoDeletedPSMT.setString(1, adblueCreditDebitId);
										insertIntoDeletedPSMT.setString(2, crusherId);
										insertIntoDeletedPSMT.setString(3, crusherCode);
										insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
										insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
										insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
										insertIntoDeletedPSMT.setTime(7, resultSet.getTime(5));
										insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
										insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
										insertIntoDeletedPSMT.setString(10, deletedBy);
										insertIntoDeletedPSMT.setString(11, resultSet.getString(9));
										
										
										  m = insertIntoDeletedPSMT.executeUpdate();
										  
										  String paymentType = resultSet.getString(6);
										  
										  
										  SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
											Date parsedDate = null;

											try {
											    parsedDate = inputDateFormat.parse(resultSet.getString(4)); 
											} catch (ParseException e) {
											    e.printStackTrace();  
											}

											if (parsedDate != null) {
											     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
											    String formattedDate = outputDateFormat.format(parsedDate); 
								
											    
										 
										    
										    
										  boolean isCloseingBalMaintained = false;
										  
										  if (paymentType.equals("CREDIT")) {
										   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"DEBIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
										  }else {
											   isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBalAdblue(resultSet.getString(2),resultSet.getString(2),"CREDIT", formattedDate, resultSet.getFloat(7), deletedBy, connection, this.getSessionMap());
											  
										  }
											}
										  
										if(insertIntoDeletedPSMT != null)
										{
											insertIntoDeletedPSMT.close();
											insertIntoDeletedPSMT = null;
										}
										
									}
									if(resultSet != null)
									{
										resultSet.close();
										resultSet = null;
									}
									if(preparedStatement != null)
									{
										preparedStatement.close();
										preparedStatement = null;
									}
									
									
									if(m>0)
									{
										
										
									
									sql = "DELETE "
											+ "FROM "
											+ "adblue_credit_debit_master "
											+ "WHERE "
											+ "entry_id = ? "
											+ "AND "
											+ "crusher_id = ? "
											+ "AND "
											+ "crusher_code = ? ";
									
									preparedStatement = connection.prepareStatement(sql);
									preparedStatement.setString(1, adblueCreditDebitId);
									preparedStatement.setString(2, crusherId);
									preparedStatement.setString(3, crusherCode);
									
									int k = preparedStatement.executeUpdate();
									
									
									if(k > 0 )
									{
										sql = "UPDATE "
		        	        					+ "crusher_purchase_product_info_master "
		        	        					+ "SET "
		        	        					+ "adblue_credit_debit_id = ? "
		        	        					+ "WHERE "
		    									+ "purchase_id = ? "
		    									+ "AND "
		    									+ "product_name = ? "
		    									+ "AND "
		    									+ "crusher_id = ? "
		    									+ "AND "
		    									+ "crusher_code = ? ";
		        	        			
		        	        			
			    						preparedStatement = connection.prepareStatement(sql);
			    						
			    						preparedStatement.setString(1, null);
			    						preparedStatement.setString(2, this.getPaymentPurchaseId());
			    						preparedStatement.setString(3, productName1);
			    						preparedStatement.setString(4, crusherId);
			    		        		preparedStatement.setString(5, crusherCode);
			    		        		
			    						int rowCreditDebitIdInsetred = preparedStatement.executeUpdate();
			        				
			    						
			    						
									}
					    		}
								}
								
							}
	    		        		
	    		        		
	    		        	    int rowsToDelete = 0;

	    		        	    // Count how many rows match the criteria
	    		        	    sql = "SELECT count(*) FROM crusher_purchase_product_info_master WHERE purchase_id = ? AND crusher_id = ? AND crusher_code = ?";
	    		        	    preparedStatement = connection.prepareStatement(sql);
	    		        	    preparedStatement.setString(1, this.getPaymentPurchaseId());
	    		        	    preparedStatement.setString(2, crusherId);
	    		        	    preparedStatement.setString(3, crusherCode);

	    		        	    resultSet = preparedStatement.executeQuery();

	    		        	    if (resultSet.next()) {
	    		        	        rowsToDelete = resultSet.getInt(1);
	    		        	    }

	    		        	    // Fetch all matching products
	    		        	    sql = "SELECT product_id, product_name, purchase_quantity FROM crusher_purchase_product_info_master WHERE purchase_id = ? AND crusher_id = ? AND crusher_code = ?";
	    		        	    preparedStatement = connection.prepareStatement(sql);
	    		        	    preparedStatement.setString(1, this.getPaymentPurchaseId());
	    		        	    preparedStatement.setString(2, crusherId);
	    		        	    preparedStatement.setString(3, crusherCode);

	    		        	    resultSet = preparedStatement.executeQuery();

	    		        	    // Process each product in the result set
	    		        	    while (resultSet.next()) {
	    		        	        productId = resultSet.getString(1);
	    		        	        productName = resultSet.getString(2);
	    		        	        quantity = resultSet.getFloat(3);

	    		        	        // Deduct stock for each product
	    		        	        boolean currentStockMinus = UpdateProductStockDetails.minusStockToCurrentStock(connection, this.getSessionMap(), productId, productName, quantity);
	    		        	        
	    		        	        if (currentStockMinus) {
	    		        	            stockMinus = true; // If at least one product stock is deducted, set this to true
	    		        	        }
	    		        	    }

	    		        	    // Close the statement
	    		        	    if (preparedStatement != null) {
	    		        	        preparedStatement.close();
	    		        	    }

	    		        	    // Delete product details only if there were products to delete
	    		        	    if (rowsToDelete > 0) {
	    		        	        String deleteProDetails = "DELETE FROM crusher_purchase_product_info_master WHERE purchase_id = ? AND crusher_id = ? AND crusher_code = ?";
	    		        	        PreparedStatement delProPSMT = connection.prepareStatement(deleteProDetails);
	    		        	        delProPSMT.setString(1, this.getPaymentPurchaseId());
	    		        	        delProPSMT.setString(2, crusherId);
	    		        	        delProPSMT.setString(3, crusherCode);

	    		        	        deletedProCount = delProPSMT.executeUpdate();
	    		        	    }
	    		        	

	    		        	 
	    		        	 if(deletedProCount > 0 )
	    		        	 {
	    		        		 String deleteSql = "DELETE "
		    	    						+ "FROM "
		    	    						+ "crusher_purchase_master "
		    	    						+ "WHERE "
		    	    						+ "purchase_id = ? "
		    	    						+ "AND "
		            						+ "crusher_id = ? "
		        							+ "AND "
		        							+ "crusher_code = ?";
		    		        	 
		    		        	 PreparedStatement deletePSMT = connection.prepareStatement(deleteSql);
		    		        	 deletePSMT.setString(1, this.getPaymentPurchaseId());
		    		        	 deletePSMT.setString(2, crusherId);
		    		        	 deletePSMT.setString(3, crusherCode);
		            				
		    		        		int deletedCount = deletePSMT.executeUpdate();
		    		        		
		    		        		 if(deletePSMT != null)
			    		        	 {
			    		        		 deletePSMT.close();
			    		        		 deletePSMT = null;
			    		        	 }
		    		        		 
		    		        		 if(deletedCount > 0)
		    		        		 {
		    		        			 
		    		        			 

		 		    					sql = "SELECT "
		 		    							+ "supplier_name,"
		 		    							+ "supplier_address,"
		 		    							+ "contact_number "
		 		    							+ "FROM "
		 		    							+ "crusher_supplier_master "
		 		    							+ "WHERE "
		 		    							+ "supplier_id = ? "
		 		    							+ "AND "
		 		        						+ "crusher_id = ? "
		 		    							+ "AND "
		 		    							+ "crusher_code = ?";
		 		    					
		 		    					preparedStatement = connection.prepareStatement(sql);
		 		    					
		 		    					preparedStatement.setString(1, supplierId);
		 		    					preparedStatement.setString(2, crusherId);
		 		        				preparedStatement.setString(3, crusherCode);
		 		        				
		 		    					resultSet = preparedStatement.executeQuery();
		 		    					
		 		    					if(resultSet.next()){
		 		    						this.setSupplierName(resultSet.getString(1));
		 		    						this.setSupplierAddress(resultSet.getString(2));
		 		    						this.setSupplierMobile(resultSet.getString(3));
		 		    					}
		 		    					
			    		        		 result = "success";
			    		        		 connection.commit();
			    		        		 addActionMessage(this.getText("message.success.purchaseNumber")+this.getPaymentPurchaseId()+this.getText("message.success.withInvoiceNumber")+invoiceNo+this.getText("message.success.deletedSuccessfully"));
		    		        		 }
		    		        		 else
		    		        		 {
		    		        			 connection.rollback();
			    		        		 result = "error";
			    		        		 addActionError(this.getText("message.error.errorWhileDeletingActualPurchase"));
		    		        		 }
	    		        	 }
	    		        	 else
	    		        	 {
	    		        		 connection.rollback();
	    		        		 result = "error";
	    		        		 addActionError(this.getText("message.error.errorWhileDeletingActualPurchase"));
	    		        	 }
	    		        	 
	    		        	 
	    		        	
	    		        	
	    		        		
	    		        	}
	    		        	else
	    		        	{
	    		        		connection.rollback();
	    		        		result = "error";
	    		        		addActionError(this.getText("message.error.errorWhileInsertingIntoBackupTable"));
	    		        	}
	    		        	
	    		        	
	    		        	if(insertIntoDeleteTbPSMT != null)
	    		        	{
	    		        		insertIntoDeleteTbPSMT.close();
	    		        		insertIntoDeleteTbPSMT = null;
	    		        	}
	    					
	    					
	    					
	    				}
	    				else
	    				{
	    					result = "error";
	    					connection.rollback();
	    					addActionError(this.getText("message.error.errorWhileFindingPurchaseInformation"));
	    				}
	    				
	    			
	    		
				}
			
	        
	    		catch (SQLException e) {
	    			
	    			result = "error";
	    			e.printStackTrace();
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.purchaseDetailsNotDeleted"));
	    		}
	    		catch (Exception e) {
	    			addActionError(e.getMessage() +" || "+this.getText("message.error.purchaseDetailsNotDeleted"));
				}finally {
	    			if(resultSet != null)
   				{
   					try {
   						resultSet.close();resultSet= null;
   					} catch (SQLException e) {
   						
   					}
   				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
       	
       	
       	
       	
       }
       
       return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public String getPaymentPurchaseId() {
		return paymentPurchaseId;
	}

	public void setPaymentPurchaseId(String paymentPurchaseId) {
		this.paymentPurchaseId = paymentPurchaseId;
	}

	public String getSupplierName() {
		return supplierName;
	}

	public void setSupplierName(String supplierName) {
		this.supplierName = supplierName;
	}

	public String getSupplierAddress() {
		return supplierAddress;
	}

	public void setSupplierAddress(String supplierAddress) {
		this.supplierAddress = supplierAddress;
	}

	public String getSupplierMobile() {
		return supplierMobile;
	}

	public void setSupplierMobile(String supplierMobile) {
		this.supplierMobile = supplierMobile;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	
	


}
