package com.stonecrusher.delete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;

public class DeleteSalaryEntry extends ActionSupport{


	/**
	 * 
	 */
	private static final long serialVersionUID = -1740690174443170782L;
	private HttpSession session;
	private String key;
	private String secKey;
	private String laborName;
	private String laborMobile;
	
	
	private String fromDate;
	private String toDate;
	
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			
	    			String keyDetails [] = EncryptionDecryption.decrypt(this.getKey()).split("#");
	    			String entryId = keyDetails[0];
	    			String laborId = keyDetails[1];
	    		
					connection = GetDBConnection.getDBConnection(db);
	    			
	    			if(this.getKey() ==null || this.getKey().equals("") || this.getKey().length()>6)
	    			{
	    				addActionError(this.getText("message.error.urlTemperedPlzTryAgain"));
	    				result = "error";
	    			}
	    			if(!hasActionErrors())
	    			{
	    				sql ="DELETE "
	    						+ "FROM "
	    						+ "crusher_employee_salary_calculation_details "
	    						+ "WHERE "
	    						+ "entry_id = ? "
	    						+ "AND "
	    						+ "employee_id = ? "
	    						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				preparedStatement.setString(1, entryId);
	    				preparedStatement.setString(2, laborId);
	    				preparedStatement.setString(3, crusherId);
        				preparedStatement.setString(4, crusherCode);
        				
	    				int k = preparedStatement.executeUpdate();
	    				
	    				if(k>0)
	    				{
	    					
	    					if(preparedStatement != null)
	    					{
	    						preparedStatement.close();
	    						preparedStatement = null;
	    					}
	    					
	    					sql = "SELECT "
	    							+ "employee_name,"
	    							+ "employee_mobile_number "
	    							+ "FROM "
	    							+ "crusher_employee_master "
	    							+ "WHERE "
	    							+ "employee_id = ? "
	    							+ "AND "
	        						+ "crusher_id = ? "
	    							+ "AND "
	    							+ "crusher_code = ?";
	    					
	    					preparedStatement = connection.prepareStatement(sql);
	    					
	    					preparedStatement.setString(1, laborId);
	    					preparedStatement.setString(2, crusherId);
	        				preparedStatement.setString(3, crusherCode);
	        				
	    					resultSet = preparedStatement.executeQuery();
	    					
	    					if(resultSet.next()){
	    						this.setLaborName(resultSet.getString(1));
	    						this.setLaborMobile(resultSet.getString(2));
	    					}
	    					
	    					addActionMessage(this.getText("message.success.laborSalaryEntryDeletedSuccessfully"));
	    					result = SUCCESS;
	    				}
	    				else
	    				{
	    					addActionError(this.getText("message.error.laborSalaryEntryNotDeleted"));
	    					result = ERROR;
	    				}
	    			}
	    			
	    			
	    			
	    		}
	    		catch (SQLException e) {
	    			
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.laborSalaryEntryNotDeleted"));
	    		}
	    		catch (Exception e) {
	    			addActionError(e.getMessage() +" || "+this.getText("message.error.laborSalaryEntryNotDeleted"));
				}finally {
	    			if(resultSet != null)
   				{
   					try {
   						resultSet.close();
   						resultSet = null;
   					} catch (SQLException e) {
   						
   					}
   				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
       	
       	
       	
       	
       }
	    
	   this.setKey(this.getSecKey());
       
       return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	
	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public String getLaborName() {
		return laborName;
	}

	public void setLaborName(String laborName) {
		this.laborName = laborName;
	}

	public String getLaborMobile() {
		return laborMobile;
	}

	public void setLaborMobile(String laborMobile) {
		this.laborMobile = laborMobile;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getSecKey() {
		return secKey;
	}

	public void setSecKey(String secKey) {
		this.secKey = secKey;
	}

	


	
	
}

