package com.stonecrusher.delete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.cipher.EncryptionDecryption;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class DeleteRMCBill extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = -6022249787356151104L;

	private HttpSession session;
	private String billNumber;
	private String billType;
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private SessionMap<String,Object> sessionMap;  
	private List<String> downloadTypeList = new ArrayList<String>();
	private List<String> typeList = new ArrayList<String>();
	private String fromDate;
	private String toDate;
	private String type;
	private String downloadType;
	private String custMobile;
	private String custName;
	private String crusherAccount;
	
	
	
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	    		
	        	java.util.Date date = new java.util.Date();
	      	      long t = date.getTime();	        	     
	      	      java.sql.Time time = new java.sql.Time(t);
				

        		String fullUserName = (String) session.getAttribute("userFullName");
	        	
	        	String splitUserName [] = new String[5];
	        	String deletedBy = "";
	        	try
	        	{
	        		splitUserName = fullUserName.split(" ");
	        		deletedBy = splitUserName[0];
	        		
	        	}catch(Exception e)
	        	{
	        		deletedBy =fullUserName;
	        	}
	        	
	        	
	        
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		try
	    		{
	    			
					connection = GetDBConnection.getDBConnection(db);
	    			connection.setAutoCommit(false);
	    				if(this.getBillNumber() == null || this.getBillNumber().equals("") )
	    			{
	    				addActionError(this.getText("message.error.urlTemeredPlzTryAgain"));
	    				result = "error";
	    			}
	    			if(!hasActionErrors())
	    			{
	    				
	    				
	    				
	    				sql = "SELECT "
	    						+ "account1_credit_debit_id,"
								+ "account2_credit_debit_id "
								+ "FROM "
								+ "crusher_rmc_billinfo "
								+ "WHERE "
	    						+ "bill_number = ? "
	    						+ "AND "
	    						+ "bill_type = ? "
	    						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				
	    				preparedStatement.setString(1, this.getBillNumber().trim());
	    				preparedStatement.setString(2, this.getBillType().trim()); 
	    				preparedStatement.setString(3, crusherId.trim());
        				preparedStatement.setString(4, crusherCode.trim());
	    				
        				
        				resultSet = preparedStatement.executeQuery();
						
						 boolean isCloseingBalMaintained = false;
							
						if(resultSet.next()){
							String acc1CrditDebitId = resultSet.getString(1);
							String acc2CrditDebitId = resultSet.getString(2);
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							if(acc1CrditDebitId != null && !acc1CrditDebitId.equals("") )
							{
							sql = "SELECT "
									+ "entry_id,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
									
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc1CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							int m = 0;
							String paymentType = null;
							String entryDate1 = null;
							String accountId = null;
							Float amount = null;
							
							if(resultSet.next())
							{
								accountId = resultSet.getString(2);
							    paymentType = resultSet.getString(6);
								 entryDate1 = resultSet.getString(4);
								 amount = resultSet.getFloat(7);
								 
								PreparedStatement  insertIntoDeletedPSMT = null;
								
								String inertDeletedSQL = "INSERT "
										+ "INTO "
										+ "bank_account_credit_debit_deleted_entry_master "
										+ "("
										+ "entry_id,"
										+ "crusher_id,"
				        				+ "crusher_code,"
				        				+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details) "
										+ "VALUES "
										+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
								
								insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
								
								insertIntoDeletedPSMT.setString(1, acc1CrditDebitId);
								insertIntoDeletedPSMT.setString(2, crusherId);
								insertIntoDeletedPSMT.setString(3, crusherCode);
				        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
								insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
								insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
								insertIntoDeletedPSMT.setTime(7, time);
								insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
								insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
								insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
								insertIntoDeletedPSMT.setString(11, deletedBy);
								insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
								
								  m = insertIntoDeletedPSMT.executeUpdate();
								
								if(insertIntoDeletedPSMT != null)
								{
									insertIntoDeletedPSMT.close();
									insertIntoDeletedPSMT = null;
								}
								
							}
							
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(m>0)
							{
								

							
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc1CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(k>0  )
							{
								
								SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(entryDate1); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
								   
								    if (paymentType.equals("CREDIT")) {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, deletedBy, connection, this.getSessionMap());
								    } else {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, deletedBy, connection, this.getSessionMap());
								    }
								}
						
								
			    			}
			    		}
			    			}
							
	    			
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(acc2CrditDebitId != null && !acc2CrditDebitId.equals("") )
							{
								
							sql = "SELECT "
									+ "entry_id,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
									
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc2CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							int m = 0;
							String paymentType = null;
							String entryDate1 = null;
							String accountId = null;
							Float amount = null;
							
							if(resultSet.next())
							{
								accountId = resultSet.getString(2);
							    paymentType = resultSet.getString(6);
								 entryDate1 = resultSet.getString(4);
								 amount = resultSet.getFloat(7);
								 
								PreparedStatement  insertIntoDeletedPSMT = null;
								
								String inertDeletedSQL = "INSERT "
										+ "INTO "
										+ "bank_account_credit_debit_deleted_entry_master "
										+ "("
										+ "entry_id,"
										+ "crusher_id,"
				        				+ "crusher_code,"
				        				+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details) "
										+ "VALUES "
										+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
								
								insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
								
								insertIntoDeletedPSMT.setString(1, acc2CrditDebitId);
								insertIntoDeletedPSMT.setString(2, crusherId);
								insertIntoDeletedPSMT.setString(3, crusherCode);
				        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
								insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
								insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
								insertIntoDeletedPSMT.setTime(7, time);
								insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
								insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
								insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
								insertIntoDeletedPSMT.setString(11, deletedBy);
								insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
								
								  m = insertIntoDeletedPSMT.executeUpdate();
								
								if(insertIntoDeletedPSMT != null)
								{
									insertIntoDeletedPSMT.close();
									insertIntoDeletedPSMT = null;
								}
								
							}
							
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(m>0)
							{
								

							
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc2CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(k>0  )
							{
								
								SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(entryDate1); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
								   
								    if (paymentType.equals("CREDIT")) {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, deletedBy, connection, this.getSessionMap());
								    } else {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, deletedBy, connection, this.getSessionMap());
								    }
								}

							}
							}
							}
						}
						
						sql = "SELECT "
	    						+ "bill_number,"
	    						+ "bill_date,"
	    						+ "bill_time,"
	    						+ "payment_type,"
	    						+ "bill_type,"
	    						+ "customer_id,"
	    						+ "customer_name,"
	    						+ "transport_charges,"
	    						+ "comments,"
	    						+ "bill_total_amount,"
	    						+ "bill_amount_received,"
	    						+ "amount_return,"
	    						+ "billed_by,"
	    						+ "chalan_number,"
	    						+ "vehicle_id "
	    						+ "FROM "
	    						+ "crusher_rmc_billinfo "
	    						+ "WHERE "
	    						+ "bill_number = ? "
	    						+ "AND "
	    						+ "bill_type = ? "
	    						+ "AND "
        						+ "crusher_id = ? "
    							+ "AND "
    							+ "crusher_code = ?";
	    				
	    				preparedStatement = connection.prepareStatement(sql);
	    				
	    				preparedStatement.setString(1, this.getBillNumber().trim());
	    				preparedStatement.setString(2, this.getBillType().trim()); 
	    				preparedStatement.setString(3, crusherId.trim());
        				preparedStatement.setString(4, crusherCode.trim());
        				
	    				resultSet = preparedStatement.executeQuery();
	    				
	    				if(resultSet.next())
	    				{
	    					
	    					PreparedStatement insertIntoDeleteTbPSMT = null;
	    					String insertDeleteSQL = "INSERT INTO "
	    		        			+ "crusher_deleted_rmc_billinfo"
	    		        			+ "( "
	    		        			+ "bill_number,"
	    		        			+ "crusher_id,"
	    	        				+ "crusher_code,"
	    	        				+ "bill_date,"
	    		        			+ "bill_time,"
	    		        			+ "payment_type,"
	    		        			+ "bill_type,"
	    		        			+ "customer_id,"
	    		        			+ "customer_name,"
	    		        			+ "transport_charges,"
	    		        			+ "comments,"
	    		        			+ "bill_total_amount,"
	    		        			+ "bill_amount_received,"
	    		        			+ "amount_return,"	    		        			
	    		        			+ "billed_by,"
	    		        			+ "chalan_number,"
	    		        			+ "vehicle_id) "
	    	    					+ "VALUES "
	    	    					+ "(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
	    		        			
	    		        	
	    					insertIntoDeleteTbPSMT = connection.prepareStatement(insertDeleteSQL);
	    		        	
	    		        	String chalanNumber = "";
	    		        	
	    		        	insertIntoDeleteTbPSMT.setString(1,resultSet.getString(1));	    		        	
	    		        	insertIntoDeleteTbPSMT.setString(2, crusherId);
	    		        	insertIntoDeleteTbPSMT.setString(3, crusherCode);
	    	        		insertIntoDeleteTbPSMT.setDate(4,resultSet.getDate(2));
	    		        	insertIntoDeleteTbPSMT.setTime(5, resultSet.getTime(3));
	    		        	insertIntoDeleteTbPSMT.setString(6,resultSet.getString(4));
	    		        	insertIntoDeleteTbPSMT.setString(7,resultSet.getString(5));
	    		        	insertIntoDeleteTbPSMT.setString(8,resultSet.getString(6));
	    		        	insertIntoDeleteTbPSMT.setString(9,resultSet.getString(7));
	    		        	insertIntoDeleteTbPSMT.setString(10,resultSet.getString(8));
	    		        	insertIntoDeleteTbPSMT.setString(11,resultSet.getString(9));
	    		        	insertIntoDeleteTbPSMT.setFloat(12,resultSet.getFloat(10));
	    		        	insertIntoDeleteTbPSMT.setString(13,resultSet.getString(11));
	    		        	insertIntoDeleteTbPSMT.setString(14,resultSet.getString(12));
	    		        	insertIntoDeleteTbPSMT.setString(15,deletedBy);
	    		        	insertIntoDeleteTbPSMT.setString(16, resultSet.getString(14));
	    		        	insertIntoDeleteTbPSMT.setString(17, resultSet.getString(15));
	    		        	
	    		        	chalanNumber = resultSet.getString(14);
	    		        	int countBillInfoDeleted = insertIntoDeleteTbPSMT.executeUpdate();
	    		        	
	    		        	if(countBillInfoDeleted > 0)
	    		        	{
	    		        		
	    		        		 String deleteSql = "";
		    		        	 
	    		        		 deleteSql = "DELETE "
	    		        		 		+ "FROM "
	    		        		 		+ "crusher_rmc_productbillinfo "
	    		        		 		+ "WHERE "
			    		        		+ "bill_number = ? "
		 	    						+ "AND "
		 	    						+ "bill_type = ? "
		 	    						+ "AND "
	            						+ "crusher_id = ? "
	        							+ "AND "
	        							+ "crusher_code = ?";
	    		        		 
	    		        		 
	    		        		 PreparedStatement deleteProductPSMT = connection.prepareStatement(deleteSql);
	    		        		 deleteProductPSMT.setString(1, this.getBillNumber().trim());
	    		        		 deleteProductPSMT.setString(2, this.getBillType().trim());
	    		        		 deleteProductPSMT.setString(3, crusherId.trim());
	    		        		 deleteProductPSMT.setString(4, crusherCode.trim());
		            			
	    		        		 
	    		        		 int deleteProductCount = deleteProductPSMT.executeUpdate();
	    		        		 
	    		        		 if(deleteProductPSMT != null)
		    		        	 {
		    		        		 deleteProductPSMT.close();
		    		        		 deleteProductPSMT = null;
		    		        		 
		    		        	 }
	    		        		 
	    		        		 if(deleteProductCount > 0)
	    		        		 {
	    		        			 
	    		        			 deleteSql = "DELETE "
	    		        			 		+ "FROM "
	    		        			 		+ "crusher_rmc_vehicle_trip_master "
	    		        			 		+ "WHERE "
	    		        			 		+ "bill_number = ? "
			 	    						+ "AND "
			 	    						+ "bill_type = ? "
			 	    						+ "AND "
		            						+ "crusher_id = ? "
		        							+ "AND "
		        							+ "crusher_code = ?";
		    		        		 
		    		        		 
		    		        		 PreparedStatement deleteVehicleTripPSMT = connection.prepareStatement(deleteSql);
		    		        		 deleteVehicleTripPSMT.setString(1, this.getBillNumber().trim());
		    		        		 deleteVehicleTripPSMT.setString(2, this.getBillType().trim());
		    		        		 deleteVehicleTripPSMT.setString(3, crusherId.trim());
		    		        		 deleteVehicleTripPSMT.setString(4, crusherCode.trim());
			            			
		    		        		 
		    		        		 int deleteVehicleTripCount = deleteVehicleTripPSMT.executeUpdate();
		    		        		 
		    		        		 if(deleteVehicleTripPSMT != null)
			    		        	 {
		    		        			 deleteVehicleTripPSMT.close();
		    		        			 deleteVehicleTripPSMT = null;
			    		        		 
			    		        	 }
	    		        			 if(deleteVehicleTripCount > 0)
	    		        			 {
	    		        				 
	    		        				 
	    		        				 if(resultSet != null)
	    		        				 {
	    		        					 resultSet.close();
	    		        					 resultSet = null;
	    		        				 }
	    		        				 
	    		        				 if(preparedStatement != null)
	    		        				 {
	    		        					 preparedStatement.close();
	    		        					 preparedStatement = null;
	    		        				 }
	    		        				 
	    		        				 sql = "SELECT "
	    		        				 		+ "10mm,"
	    		        				 		+ "20mm,"
	    		        				 		+ "crushsand,"
	    		        				 		+ "washsand,"
	    		        				 		+ "water,"
	    		        				 		+ "addmixture,"
	    		        				 		+ "cementopc,"
	    		        				 		+ "cementppc "
	    		        				 		+ "FROM "
	    		        				 		+ "rmc_bill_ingredients_used_details_master "
	    		        				 		+ "WHERE "
	    		        				 		+ "rmc_bill_number = ? "
	    		        				 		+ "AND "
	    		        				 		+ "bill_type = ? "
				 	    						+ "AND "
			            						+ "crusher_id = ? "
			        							+ "AND "
			        							+ "crusher_code = ?";
	    		        				 
	    		        				 
	    		        				 preparedStatement = connection.prepareStatement(sql);
	    		        				 
	    		        				 preparedStatement.setString(1, this.getBillNumber().trim());
	    		        				 preparedStatement.setString(2, this.getBillType().trim());
	    		        				 preparedStatement.setString(3, crusherId.trim());
	    		        				 preparedStatement.setString(4, crusherCode.trim());
	    		        				 
	    		        				 resultSet = preparedStatement.executeQuery();
	    		        				 
	    		        				 if(resultSet.next())
	    		        				 {
	    		        						HashMap<String,String> productMappList = GetListResource.getRMCIngreProductMappList(this.getSessionMap(), connection);
	    	    					        	
	    		        						String tenmmProductIdName = productMappList.get("tenmm");
	    		        	        			String twentymmProdcutIdName = productMappList.get("twentymm");
	    		        	        			String crushsandProdcutIdName = productMappList.get("crushsand");
	    		        	        			String silicasandProductIdName = productMappList.get("washsand");
	    		        	        			
	    		        	        			String waterProductIdName = productMappList.get("water");
	    		        	        			String addMixtureProductIdName = productMappList.get("addmixture");
	    		        		        		
	    		        	        			String cementOPCProductIdName = productMappList.get("cementOPC");
	    		        	        			String cementPPCProductIdName = productMappList.get("cementPPC");
	    		        						
	    					        			
	    					        			
	    					        			boolean stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), tenmmProductIdName.split("#")[0], tenmmProductIdName.split("#")[1], resultSet.getFloat(1));
	    				        				
	    				        				if(stockAdded)
	    				        				{
	    				        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), twentymmProdcutIdName.split("#")[0], twentymmProdcutIdName.split("#")[1], resultSet.getFloat(2));
	    				        				}
	    				        				if(stockAdded)
	    				        				{
	    				        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), crushsandProdcutIdName.split("#")[0], crushsandProdcutIdName.split("#")[1], resultSet.getFloat(3));
	    				        				}
	    				        				
	    				        				if(stockAdded)
	    				        				{
	    				        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), silicasandProductIdName.split("#")[0], silicasandProductIdName.split("#")[1], resultSet.getFloat(4));
	    				        				}
	    				        				
	    				        				if(stockAdded)
	    				        				{
	    				        				 stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), waterProductIdName.split("#")[0], waterProductIdName.split("#")[1], resultSet.getFloat(5));
	    				        				}
	    				        				if(stockAdded)
	    				        				{
	    				        					stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), addMixtureProductIdName.split("#")[0], addMixtureProductIdName.split("#")[1], resultSet.getFloat(6));
	    				        				}
	    				        				if(stockAdded)
	    				        				{
	    				        					stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), cementOPCProductIdName.split("#")[0], cementOPCProductIdName.split("#")[1], resultSet.getFloat(7));
	    				        				}
	    				        				if(stockAdded)
	    				        				{
	    				        					stockAdded = com.stonecrusher.update.UpdateProductStockDetails.addStockToCurrentStock(connection, this.getSessionMap(), cementPPCProductIdName.split("#")[0], cementPPCProductIdName.split("#")[1], resultSet.getFloat(8));
	    				        				}
	    					        			
	    				        				
	    				        				if(stockAdded)
	    				        				{
	    				        					
	    				        					PreparedStatement deleteUsedMaterialPSMT = null;
	    				        					
	    				        					String usedMaterialEntrySQL = "DELETE FROM "
	    				        							+ "rmc_bill_ingredients_used_details_master "
	    				        							+ "WHERE "
	    				        							+ "rmc_bill_number = ? "
	    		    		        				 		+ "AND "
	    		    		        				 		+ "bill_type = ? "
	    					 	    						+ "AND "
	    				            						+ "crusher_id = ? "
	    				        							+ "AND "
	    				        							+ "crusher_code = ?";
	    				        					
	    				        					deleteUsedMaterialPSMT = connection.prepareStatement(usedMaterialEntrySQL);
	    				        					deleteUsedMaterialPSMT.setString(1, this.getBillNumber().trim());
	    				        					deleteUsedMaterialPSMT.setString(2, this.getBillType().trim());
	    				        					deleteUsedMaterialPSMT.setString(3, crusherId.trim());
	    				        					deleteUsedMaterialPSMT.setString(4, crusherCode.trim());
	    		    		        				 
	    				        					 int deleteUsedMaterialCount = deleteUsedMaterialPSMT.executeUpdate();
    				        						 
	    				        					   
    				        					 if(deleteUsedMaterialCount > 0)
    				        					 {  
    				        						   
    				        						 deleteSql = "DELETE "
	    					    	    						+ "FROM "
	    					    	    						+ "crusher_rmc_billinfo "
	    					    	    						+ "WHERE "
	    					    	    						+ "bill_number = ? "
	    					    	    						+ "AND "
	    					    	    						+ "bill_type = ? "
	    					    	    						+ "AND "
	    					            						+ "crusher_id = ? "
	    					        							+ "AND "
	    					        							+ "crusher_code = ?";
	    					    		        	 
	    					    		        	 PreparedStatement deletePSMT = connection.prepareStatement(deleteSql);
	    					    		        	 deletePSMT.setString(1, this.getBillNumber().trim());
	    					    		        	 deletePSMT.setString(2, this.getBillType().trim());
	    					    		        	 deletePSMT.setString(3, crusherId.trim());
	    					    		        	 deletePSMT.setString(4, crusherCode.trim());
	    					    		        	 

	    					    		        	 int deletedCount = deletePSMT.executeUpdate();
	    					    		       
	    					    		        	 if(deletePSMT != null)
	    					    		        	 {
	    					    		        		 deletePSMT.close();
	    					    		        		 deletePSMT = null;
	    					    		        	 }
	    					    		        	 
			    					    		        if(deletedCount > 0)
			    					    		        { 
			    				        					 result = "success";
			    				    		        		 connection.commit();
			    				    		        		 addActionMessage("Bill Number : "+this.getBillNumber()+"& Chalan Number : "+chalanNumber+" Deleted Successfully!");
			    					    		        
			    				        				} 
			    			    		        		 else
			    				    		        	 {
			    				    		        		 connection.rollback();
			    				    		        		 result = "error";
			    				    		        		 addActionError(this.getText("message.error.errorWhileDeletingActualProductInfo"));
			    				    		        	 }
	    				        					 }
	    				        					 else
	    				        					 {
	    				        						 connection.rollback();
		    				    		        		 result = "error";
		    				    		        		 addActionError("Error while deleting used material details!");
		    				    		 
	    				        					 }
	    					    		        		 
	    					    		        		
	    				        				} else
	   	    		        				 	{
	   	    		        					 connection.rollback();
	   				    		        		 result = "error";
	   				    		        		 addActionError("Error while deleting used items! Update Stock!");
	   			    		        
	   	    		        				 }
	    					        			
	    		        				 }
	    		        				 else
	    		        				 {
	    		        					 connection.rollback();
				    		        		 result = "error";
				    		        		 addActionError("Error while deleting used items!");
			    		        
	    		        				 }
	    		        				 
	    		        				 
		    		        		 }else
		    		        		 {
		    		        			 connection.rollback();
			    		        		 result = "error";
			    		        		 addActionError(this.getText("message.error.errorWhileDeletingActualVehicleTripDetails"));
		    		        		 }
		    		        	} 
	    		        		 else
		    		        	 {
		    		        		 connection.rollback();
		    		        		 result = "error";
		    		        		 addActionError(this.getText("message.error.errorWhileDeletingActualProductInfo"));
		    		        	 }
	    		        	
	    		        	 
	    		        	
	    		        	
	    		        		
	    		        	}
	    		        	else
	    		        	{
	    		        		connection.rollback();
	    		        		result = "error";
	    		        		addActionError(this.getText("message.error.errorWhileInsertingIntoBackupTable"));
	    		        	}
	    		        	
	    		        	
	    		        	if(insertIntoDeleteTbPSMT != null)
	    		        	{
	    		        		insertIntoDeleteTbPSMT.close();
	    		        		insertIntoDeleteTbPSMT = null;
	    		        	}
	    					
	    					
	    				}
	    				
	    				else
	    				{
	    					result = "error";
	    					connection.rollback();
	    					addActionError(this.getText("message.error.errorWhileFindingBillInformation"));
	    				}
	    				
	    			
	    				
	    			}
	    		}
	    		catch (SQLException e) {
	    			
	    			result = "error";
	    			//e.printStackTrace();
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.customerBillNotDeleted"));
	    		}
	    		catch (Exception e) {
	    			addActionError(e.getMessage() +" || "+this.getText("message.error.customerBillNotDeleted"));
				}finally {
	    			if(resultSet != null)
   				{
   					try {
   						resultSet.close(); resultSet = null;
   					} catch (SQLException e) {
   						
   					}
   				}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
       	
       	
       	
       	
       }
       return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getBillNumber() {
		return billNumber;
	}

	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public List<String> getTypeList() {
		return typeList;
	}

	public void setTypeList(List<String> typeList) {
		this.typeList = typeList;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getDownloadType() {
		return downloadType;
	}

	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}

	public String getCustMobile() {
		return custMobile;
	}

	public void setCustMobile(String custMobile) {
		this.custMobile = custMobile;
	}

	public String getCustName() {
		return custName;
	}

	public void setCustName(String custName) {
		this.custName = custName;
	}

	public List<String> getDownloadTypeList() {
		return downloadTypeList;
	}

	public void setDownloadTypeList(List<String> downloadTypeList) {
		this.downloadTypeList = downloadTypeList;
	}

	public String getCrusherAccount() {
		return crusherAccount;
	}

	public void setCrusherAccount(String crusherAccount) {
		this.crusherAccount = crusherAccount;
	}

	


	
	


}
