package com.stonecrusher.delete;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.DAO.BillInformationDAO;
import com.stonecrusher.DAO.BillProductInfoDAO;
import com.stonecrusher.DAO.BillVehicleInfoDAO;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.resource.GetListResource;
import com.stonecrusher.utils.GetAccountListForDrCr;
import com.stonecrusher.utils.GetTypeOfPaymentList;
import com.stonecrusher.utils.GetVehicleDetailsById;

public class DeleteEditProductFromList extends ActionSupport implements SessionAware{
	
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -5627177987932888576L;
	private HttpSession session;
	private String billDateTime;
	private String operator;
	private String paymentType;
	private String customerName;
	private String productName;
	private String productMarathiName;
	private String alias;
	private String salesUnit;
	private String taxPercentage;
	private Float salesRate;
	private Float quantity;
	private Float discountPercentage;
	private Float discountRupees;
	private Float amount;
	private String billType;
	private Float amountAfterDiscount;
	private String productNameForDelete;
	private Float transportCharge;
	private String comments;
	private String id;
	private String serialNumber;
	private Float amountPaid;
	private SessionMap<String,Object> sessionMap;
	
	private String billNumber;
	private Map<String,String> taxList = new LinkedHashMap<String,String>();
	private Map<String,String> unitList = new LinkedHashMap<String,String>();
	private Map<String,String> paymentTypeList = new  LinkedHashMap<String,String>();
	private Map<String,String> billTypeList = new  LinkedHashMap<String,String>();
	private List<BillProductInfoDAO> productInfoList ;
	private String defaultValue;
	private Map<String,String> vehicleList = new HashMap<String,String>();
	
	private Float totalAmount;
	private Float totalDiscount;
	private Float totalAmouAfterDisount;
	
	private Float returnAmount;
	
	private String addSideBarJs;

	private String tripDate;
	private String vehicleId;
	private String materialName;
	private Float materialVolume;
	private Float kmStart;
	private Float kmEnd;
	private Float totalKm;
	private String tripFrom;
	private String tripTo;
	private Integer totalTrips;
	private String chalanNumber;
	private BillInformationDAO billInfoDAO = null;

	private BillVehicleInfoDAO billVehicleInfoDAO = null;
	private boolean viewBill;
	private boolean generateBillForDc;
	
	

	private Map<String,String> accountList = new LinkedHashMap<String,String>();
	private List<String> paymentTypeList2 = new ArrayList<String>();
	
	
	private Map<String,String> rateTypeList = new  LinkedHashMap<String,String>();
	private String rateTyprDefaultValue;
	private String rateType;
	private Float royalty;
	private String keyVehicle;
	private Boolean isFromVehicleEntryDetails ;
	private Float vehicleEmptyWeight;
	private Float grossWeight;
    private String discountType;
	
	private Map<String,String> discountTypeList = new HashMap<String,String>();

	
	
	@SuppressWarnings("unchecked")
	public String execute() throws IOException{
		 
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "error";
	        }  
	        else{ 
	        	
	        	Connection connection = null;
    			PreparedStatement preparedStatement = null;
    			ResultSet resultSet = null;
    			String db = (String) this.getSessionMap().get("db");
			
	        	
	        	this.setAccountList(GetAccountListForDrCr.getAccountList((this.getSessionMap()))); 
	    		
	        	this.setPaymentTypeList2(GetTypeOfPaymentList.getPaymentTypeList());
	        	
	          	
	        	  discountTypeList.put("", "Select Discount Type");
			      discountTypeList.put("By Quantity", "By Quantity");
			      discountTypeList.put("By Percentage", "By Percentage");
			      discountTypeList.put("By Direct Amount", "By Direct Amount");
					
			      
			      
	    		this.getRateTypeList().put("INCLUDINGGST", "Including GST");
	        	this.getRateTypeList().put("EXCLUDINGGST", "Excluding GST");
	     	
	        	this.setAddSideBarJs("FALSE");
			
	        	productInfoList = (List<BillProductInfoDAO>) this.getSessionMap().get("productList");
	        	billInfoDAO = (BillInformationDAO) this.getSessionMap().get("billInformation");
	          	this.setBillVehicleInfoDAO((BillVehicleInfoDAO) this.getSessionMap().get("billvehicleinfo"));
				
	        	List<String> selection = (List<String>) this.getSessionMap().get("dcselected");
	 
	        	
	        	
    			try
    			{
    				connection = GetDBConnection.getDBConnection(db);
    				
    				this.setTripFrom(this.getBillVehicleInfoDAO().getTripFrom());
        			this.setTripTo(this.getBillVehicleInfoDAO().getTripTo());
        			this.setTotalTrips(this.getBillVehicleInfoDAO().getTotalTrips());
        			this.setTotalKm(this.getBillVehicleInfoDAO().getTotalKM());
        			this.setKmStart(this.getBillVehicleInfoDAO().getKmStart());
        			this.setKmEnd(this.getBillVehicleInfoDAO().getKmEnd());
        			
        			HashMap<String,String> vehicleDetails =  GetVehicleDetailsById.getVehicleDetailsById(this.getBillVehicleInfoDAO().getVehicleId(), this.getSessionMap(), connection);
            		
        			this.setVehicleId(this.getBillVehicleInfoDAO().getVehicleId()+"-"+vehicleDetails.get("VEHICLEMAKE")+"-"+vehicleDetails.get("REGISTRATIONNUMBER"));
        		
    				
    			
    			}catch (Exception e) {
    				//e.printStackTrace();
    				addActionError(this.getText("message.error.productNotRemovedFromList"));}
    			finally
    			{
    				
    				if(resultSet != null)
    				{
    					try
    					{resultSet.close(); resultSet = null;}catch(Exception e){}
    				}
    				if(preparedStatement != null)
    				{
    					try {
    						preparedStatement.close(); preparedStatement = null;
    					} catch (SQLException e) {
    						
    					}
    				}
    				
    				if(connection != null)
    				{
    					try {
    						connection.close(); connection = null;
    					} catch (SQLException e) {
    						
    					}
    				}
    				
    				
    			
        	}

	        	int removeIndexCount = 0;
	        	int i = 0;
	        	boolean isProductRemovedFromDB = true;
	        
					
    		
	        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
	        	{
	        		
	        		String pName = infoDAO.getProductName();
	        		
	        		if(this.getProductNameForDelete().equals(pName))
	        		{
	        			removeIndexCount = i;
	        		}
	        		i++;
	        		
	        	}
	        	
	        	if(billInfoDAO != null)
	        	{
	        		this.setBillNumber(billInfoDAO.getBillNumber());	        	
	        		this.setPaymentType(billInfoDAO.getPaymentType());
	        		this.setBillType(billInfoDAO.getBillType());
	        		this.setCustomerName(billInfoDAO.getCustomerName());	        		
	        		this.setComments(billInfoDAO.getComments());
	        		this.setDefaultValue(getPaymentType());
	        		this.setChalanNumber(billInfoDAO.getChalanNumber());
	        		this.setDiscountType(billInfoDAO.getDiscountType());
	        	
	        		
	        	}
	        	
	        	BillProductInfoDAO dao = productInfoList.get(removeIndexCount);
	        	
	        	this.setAlias(dao.getAlias());
	        	this.setProductName(dao.getProductId()+"-"+dao.getProductName());
	        	this.setProductMarathiName(dao.getProductNameMarathi());
	        	this.setSalesUnit(dao.getSalesUnit());
	        	this.setTaxPercentage(dao.getTaxId());
	        	this.setSalesRate(dao.getSalesRate());
	        	this.setQuantity(dao.getQuantity());
	        	this.setDiscountPercentage(dao.getDiscountPecentage());
	        	this.setDiscountRupees(dao.getDiscountRupees());
	        	this.setAmount(dao.getAmount());
	        	this.setAmountAfterDiscount(dao.getAmountAfterDiscount());
	        	this.setTransportCharge(dao.getTransportCharges());
	        	this.setRoyalty(dao.getRoyalty());
	        	this.setRateTyprDefaultValue(dao.getRateType());
	            this.setVehicleEmptyWeight(dao.getVehicleEmptyWeight());
	        	this.setGrossWeight(dao.getGrossWeight());
	       
	        		
	        	if(this.getRateTyprDefaultValue() == null)
	        	{
	        	    
		        	this.setRateTyprDefaultValue("INCLUDINGGST");
				    
		       
	        	}
			    
	        	
	        	this.setDefaultValue("CREDIT");
	     
	       
	        	  	int k = 0;   

		        	if(isProductRemovedFromDB && !billInfoDAO.isBillSaved())
	    			{
		        		billInfoDAO.setBillSaved(false);
		        		productInfoList.remove(removeIndexCount);
		        		addActionMessage(this.getText("message.success.productRemovedFromList"));
	    			}	        	
		        	else if(isProductRemovedFromDB && billInfoDAO.isBillSaved())
		        	{
		        	
	        		billInfoDAO.setBillSaved(false);
	        		productInfoList.remove(removeIndexCount);
	        		
	        	
        		
        			String sql = "";
        			
        			
        				        	}
	        	else
	        	{
	        		addActionError(this.getText("message.error.productNotRemovedFromList"));
	        	}
	        	float floatTotalAmount = 0.0F;
	        	float floatTotalDiscount = 0.0F;
	        	float floatTotalAmtAfterDiscount = 0.0F;
	        	
	        	
	        	
	        	
	        	
	        	for(BillProductInfoDAO infoDAO : this.getProductInfoList())
	        	{
	        		floatTotalAmount  = floatTotalAmount+ infoDAO.getAmount();
	        		floatTotalAmtAfterDiscount = floatTotalAmtAfterDiscount + infoDAO.getAmountAfterDiscount();
	        		
	        		
	        	}
	        	floatTotalDiscount = floatTotalAmount - floatTotalAmtAfterDiscount;
	        	
	        	setTotalAmount(floatTotalAmount);
	        	setTotalDiscount(floatTotalDiscount);
	        	setTotalAmouAfterDisount(floatTotalAmtAfterDiscount);
	        
	        	this.setBillDateTime(this.getBillInfoDAO().getBillDate());
	        	
	        	
	        	paymentTypeList.put("CASH","CASH");
	        	paymentTypeList.put("CREDIT","CREDIT");
	        	       	
	        	
	        	

	        	try {
	    			taxList = GetListResource.GetTaxList();
	    			
	    		} catch (IOException e) {
	    			
	    		}
	        	
	        	unitList = GetListResource.GetUnitList();
	        	billTypeList = GetListResource.GetBillTypeList();
	        	
	        	
	        	
	        	this.getSessionMap().put("productList", this.getProductInfoList());
	        	this.getSessionMap().put("billInformation", this.getBillInfoDAO());
	          	this.getSessionMap().put("billvehicleinfo", this.getBillVehicleInfoDAO());
			     
	
	        	if(selection != null)
	        	{
	        		this.getSessionMap().put("dcselected", selection);
	    	        
	        	}
	        	if(this.getPaymentType().equals("CASH"))
	        	{
	        		this.setAmountPaid(this.getTotalAmouAfterDisount());
	        		this.setReturnAmount(0.0F);
	        	}
	        	if(this.getPaymentType().equals("CREDIT")){
	        		this.setAmountPaid(0.0F);
	        		this.setReturnAmount(-this.getTotalAmouAfterDisount());
	        	}
	        	
	        	if(!hasActionErrors())
	        	{
	        		result = SUCCESS;
	        	}
	        	else
	        	{
	        		result = ERROR;
	        	}
	        }
	        
	        return result;
	}
	
	
	
	
	public HttpSession getSession() {
		return session;
	}
	public void setSession(HttpSession session) {
		this.session = session;
	}
	public String getBillDateTime() {
		return billDateTime;
	}
	public void setBillDateTime(String billDateTime) {
		this.billDateTime = billDateTime;
	}
	public String getOperator() {
		return operator;
	}
	public void setOperator(String operator) {
		this.operator = operator;
	}
	public String getPaymentType() {
		return paymentType;
	}
	public void setPaymentType(String paymentType) {
		this.paymentType = paymentType;
	}
	public String getCustomerName() {
		return customerName;
	}
	public void setCustomerName(String customerName) {
		this.customerName = customerName;
	}
	public String getProductName() {
		return productName;
	}
	public void setProductName(String productName) {
		this.productName = productName;
	}
	public String getProductMarathiName() {
		return productMarathiName;
	}
	public void setProductMarathiName(String productMarathiName) {
		this.productMarathiName = productMarathiName;
	}
	public String getAlias() {
		return alias;
	}
	public void setAlias(String alias) {
		this.alias = alias;
	}
	public String getSalesUnit() {
		return salesUnit;
	}
	public void setSalesUnit(String salesUnit) {
		this.salesUnit = salesUnit;
	}
	public String getTaxPercentage() {
		return taxPercentage;
	}
	public void setTaxPercentage(String taxPercentage) {
		this.taxPercentage = taxPercentage;
	}
	
	public String getBillType() {
		return billType;
	}
	public void setBillType(String billType) {
		this.billType = billType;
	}
	
	public Float getSalesRate() {
		return salesRate;
	}




	public void setSalesRate(Float salesRate) {
		this.salesRate = salesRate;
	}




	public Float getQuantity() {
		return quantity;
	}




	public void setQuantity(Float quantity) {
		this.quantity = quantity;
	}




	public Float getDiscountPercentage() {
		return discountPercentage;
	}




	public void setDiscountPercentage(Float discountPercentage) {
		this.discountPercentage = discountPercentage;
	}




	public Float getDiscountRupees() {
		return discountRupees;
	}




	public void setDiscountRupees(Float discountRupees) {
		this.discountRupees = discountRupees;
	}




	public Float getAmount() {
		return amount;
	}




	public void setAmount(Float amount) {
		this.amount = amount;
	}




	public Float getAmountAfterDiscount() {
		return amountAfterDiscount;
	}




	public void setAmountAfterDiscount(Float amountAfterDiscount) {
		this.amountAfterDiscount = amountAfterDiscount;
	}




	public String getBillNumber() {
		return billNumber;
	}
	public void setBillNumber(String billNumber) {
		this.billNumber = billNumber;
	}
	public Map<String, String> getTaxList() {
		return taxList;
	}
	public void setTaxList(Map<String, String> taxList) {
		this.taxList = taxList;
	}
	public Map<String, String> getUnitList() {
		return unitList;
	}
	public void setUnitList(Map<String, String> unitList) {
		this.unitList = unitList;
	}
	public Map<String, String> getPaymentTypeList() {
		return paymentTypeList;
	}
	public void setPaymentTypeList(Map<String, String> paymentTypeList) {
		this.paymentTypeList = paymentTypeList;
	}
	public Map<String, String> getBillTypeList() {
		return billTypeList;
	}
	public void setBillTypeList(Map<String, String> billTypeList) {
		this.billTypeList = billTypeList;
	}
	public List<BillProductInfoDAO> getProductInfoList() {
		return productInfoList;
	}
	public void setProductInfoList(List<BillProductInfoDAO> productInfoList) {
		this.productInfoList = productInfoList;
	}
	public String getDefaultValue() {
		return defaultValue;
	}
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}
	
	public Float getTotalAmount() {
		return totalAmount;
	}




	public void setTotalAmount(Float totalAmount) {
		this.totalAmount = totalAmount;
	}




	public Float getTotalDiscount() {
		return totalDiscount;
	}




	public void setTotalDiscount(Float totalDiscount) {
		this.totalDiscount = totalDiscount;
	}




	public Float getTotalAmouAfterDisount() {
		return totalAmouAfterDisount;
	}




	public void setTotalAmouAfterDisount(Float totalAmouAfterDisount) {
		this.totalAmouAfterDisount = totalAmouAfterDisount;
	}




	public String getProductNameForDelete() {
		return productNameForDelete;
	}




	public void setProductNameForDelete(String productNameForDelete) {
		this.productNameForDelete = productNameForDelete;
	}




	public BillInformationDAO getBillInfoDAO() {
		return billInfoDAO;
	}




	public void setBillInfoDAO(BillInformationDAO billInfoDAO) {
		this.billInfoDAO = billInfoDAO;
	}




	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}




	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}



	@Override  
	public void setSession(Map<String, Object> map) {  
	    sessionMap=(SessionMap<String, Object>)map;  
	}






	public Float getTransportCharge() {
		return transportCharge;
	}




	public void setTransportCharge(Float transportCharge) {
		this.transportCharge = transportCharge;
	}




	public static long getSerialversionuid() {
		return serialVersionUID;
	}




	public String getComments() {
		return comments;
	}




	public void setComments(String comments) {
		this.comments = comments;
	}






	public boolean isViewBill() {
		return viewBill;
	}




	public void setViewBill(boolean viewBill) {
		this.viewBill = viewBill;
	}




	public String getId() {
		return id;
	}




	public void setId(String id) {
		this.id = id;
	}




	public String getSerialNumber() {
		return serialNumber;
	}




	public void setSerialNumber(String serialNumber) {
		this.serialNumber = serialNumber;
	}




	public Float getAmountPaid() {
		return amountPaid;
	}




	public void setAmountPaid(Float amountPaid) {
		this.amountPaid = amountPaid;
	}




	public Float getReturnAmount() {
		return returnAmount;
	}




	public void setReturnAmount(Float returnAmount) {
		this.returnAmount = returnAmount;
	}




	public Map<String, String> getVehicleList() {
		return vehicleList;
	}




	public void setVehicleList(Map<String, String> vehicleList) {
		this.vehicleList = vehicleList;
	}




	public String getTripDate() {
		return tripDate;
	}




	public void setTripDate(String tripDate) {
		this.tripDate = tripDate;
	}




	public String getVehicleId() {
		return vehicleId;
	}




	public void setVehicleId(String vehicleId) {
		this.vehicleId = vehicleId;
	}




	public String getMaterialName() {
		return materialName;
	}




	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}




	public Float getMaterialVolume() {
		return materialVolume;
	}




	public void setMaterialVolume(Float materialVolume) {
		this.materialVolume = materialVolume;
	}




	public Float getKmStart() {
		return kmStart;
	}




	public void setKmStart(Float kmStart) {
		this.kmStart = kmStart;
	}




	public Float getKmEnd() {
		return kmEnd;
	}




	public void setKmEnd(Float kmEnd) {
		this.kmEnd = kmEnd;
	}




	public Float getTotalKm() {
		return totalKm;
	}




	public void setTotalKm(Float totalKm) {
		this.totalKm = totalKm;
	}




	public String getTripFrom() {
		return tripFrom;
	}




	public void setTripFrom(String tripFrom) {
		this.tripFrom = tripFrom;
	}




	public String getTripTo() {
		return tripTo;
	}




	public void setTripTo(String tripTo) {
		this.tripTo = tripTo;
	}




	public Integer getTotalTrips() {
		return totalTrips;
	}




	public void setTotalTrips(Integer totalTrips) {
		this.totalTrips = totalTrips;
	}




	public String getAddSideBarJs() {
		return addSideBarJs;
	}




	public void setAddSideBarJs(String addSideBarJs) {
		this.addSideBarJs = addSideBarJs;
	}




	public String getChalanNumber() {
		return chalanNumber;
	}




	public void setChalanNumber(String chalanNumber) {
		this.chalanNumber = chalanNumber;
	}




	public Map<String, String> getAccountList() {
		return accountList;
	}




	public void setAccountList(Map<String, String> accountList) {
		this.accountList = accountList;
	}




	public List<String> getPaymentTypeList2() {
		return paymentTypeList2;
	}




	public BillVehicleInfoDAO getBillVehicleInfoDAO() {
		return billVehicleInfoDAO;
	}




	public void setBillVehicleInfoDAO(BillVehicleInfoDAO billVehicleInfoDAO) {
		this.billVehicleInfoDAO = billVehicleInfoDAO;
	}




	public void setPaymentTypeList2(List<String> paymentTypeList2) {
		this.paymentTypeList2 = paymentTypeList2;
	}




	public Map<String, String> getRateTypeList() {
		return rateTypeList;
	}




	public void setRateTypeList(Map<String, String> rateTypeList) {
		this.rateTypeList = rateTypeList;
	}




	public String getRateTyprDefaultValue() {
		return rateTyprDefaultValue;
	}




	public void setRateTyprDefaultValue(String rateTyprDefaultValue) {
		this.rateTyprDefaultValue = rateTyprDefaultValue;
	}




	public String getRateType() {
		return rateType;
	}




	public void setRateType(String rateType) {
		this.rateType = rateType;
	}




	public Float getRoyalty() {
		return royalty;
	}




	public void setRoyalty(Float royalty) {
		this.royalty = royalty;
	}




	public Float getVehicleEmptyWeight() {
		return vehicleEmptyWeight;
	}




	public void setVehicleEmptyWeight(Float vehicleEmptyWeight) {
		this.vehicleEmptyWeight = vehicleEmptyWeight;
	}








	public Float getGrossWeight() {
		return grossWeight;
	}




	public void setGrossWeight(Float grossWeight) {
		this.grossWeight = grossWeight;
	}




	public String getKeyVehicle() {
		return keyVehicle;
	}




	public void setKeyVehicle(String keyVehicle) {
		this.keyVehicle = keyVehicle;
	}




	public Boolean getIsFromVehicleEntryDetails() {
		return isFromVehicleEntryDetails;
	}




	public void setIsFromVehicleEntryDetails(Boolean isFromVehicleEntryDetails) {
		this.isFromVehicleEntryDetails = isFromVehicleEntryDetails;
	}




	public boolean isGenerateBillForDc() {
		return generateBillForDc;
	}




	public void setGenerateBillForDc(boolean generateBillForDc) {
		this.generateBillForDc = generateBillForDc;
	}




	public String getDiscountType() {
		return discountType;
	}




	public void setDiscountType(String discountType) {
		this.discountType = discountType;
	}




	public Map<String, String> getDiscountTypeList() {
		return discountTypeList;
	}




	public void setDiscountTypeList(Map<String, String> discountTypeList) {
		this.discountTypeList = discountTypeList;
	}  
	
	
	
	
	
	
	

}
