package com.stonecrusher.delete;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.SessionMap;
import org.apache.struts2.interceptor.SessionAware;

import com.opensymphony.xwork2.ActionSupport;
import com.stonecrusher.db.GetDBConnection;
import com.stonecrusher.utils.MaintainCloseingBalUtil;

public class DeleteCustPaymentEntry extends ActionSupport implements SessionAware{

	/**
	 * 
	 */
	private static final long serialVersionUID = 2334557252632403550L;
	
	private HttpSession session;
	private String paymentId;
	private String fromDate;
	private String toDate;
	private String type;
	private String downloadType;
	private String custMobile;
	private String custName;
	private String key;
	
	private Map<String,String> customerSearchOptionList = new HashMap<String,String>();
	private String customerSearchOption;
	private String defaultValue;
	private SessionMap<String,Object> sessionMap;  
	private String crusherAccount;
	
	public String execute() throws Exception {
		String result = "login";
		session=ServletActionContext.getRequest().getSession(false); 
		 
	        if(session==null || session.getAttribute("login")==null){ 
	        	addActionMessage(this.getText("message.error.plzloginfirst"));
	        	result = "login";
	        }  
	        else{
	        	
	        	String crusherId = (String) session.getAttribute("crusherId");
	    		String crusherCode = (String) session.getAttribute("crusherCode");
	    		
	        	customerSearchOptionList.put("BYNAME", "BY NAME");
	        	customerSearchOptionList.put("BYMOBILE", "BY MOBILE");
	        	customerSearchOptionList.put("BYADDRESS","BY ADDRESS");
				setCustomerSearchOption("BYNAME");
				setDefaultValue("BYNAME");
	        
	        	Connection connection = null;
	    		PreparedStatement preparedStatement= null;
	    		ResultSet resultSet = null;
	    	 
	    		String sql = "";
	    		String db = (String) session.getAttribute("db");
	    		
	    		
	    		java.util.Date date = new java.util.Date();
	      	      long t = date.getTime();	        	     
	      	      java.sql.Time time = new java.sql.Time(t);
					
					String user = (String) this.getSessionMap().get("userFullName");
					String userName = "";
					
					try
					{
						userName = user.split(" ")[0];
					}catch(Exception e)
					{
						userName = user;
					}
						
					
					
	    		try
	    		{
	    			
	    			
					connection = GetDBConnection.getDBConnection(db);
					connection.setAutoCommit(false);
	    			if(this.getPaymentId() ==null || this.getPaymentId().equals("") || this.getPaymentId().length()>6)
	    			{
	    				addActionError(this.getText("message.error.urlTemeredPlzTryAgain"));
	    				result = "error";
	    			}
	    			if(!hasActionErrors())
	    			{
	    				
	    				sql = "SELECT "
								+ "account1_credit_debit_id,"
								+ "account2_credit_debit_id "
								+ "FROM "
								+ "crusher_customer_payment_details_master "
								+ "WHERE "
	    						+ "payement_entry_id = ? "
	    						+ "AND "
	    						+ "crusher_id = ? "
								+ "AND "
								+ "crusher_code = ? ";
						
						preparedStatement = connection.prepareStatement(sql);
						
						preparedStatement.setString(1, this.getPaymentId());
	    				preparedStatement.setString(2, crusherId);
	    				preparedStatement.setString(3, crusherCode);
	    				
						resultSet = preparedStatement.executeQuery();
						
						
						if(resultSet.next()){
							String acc1CrditDebitId = resultSet.getString(1);
							String acc2CrditDebitId = resultSet.getString(2);
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							boolean isCloseingBalMaintained = false;
						    
							if(acc1CrditDebitId != null && !acc1CrditDebitId.equals("") )
							{
								
							sql = "SELECT "
									+ "entry_id,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
									
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc1CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							int m = 0;
							String paymentType = null;
							String entryDate1 = null;
							String accountId = null;
							Float amount = null;
							
							if(resultSet.next())
							{
								accountId = resultSet.getString(2);
							    paymentType = resultSet.getString(6);
								 entryDate1 = resultSet.getString(4);
								 amount = resultSet.getFloat(7);
								 
								PreparedStatement  insertIntoDeletedPSMT = null;
								
								String inertDeletedSQL = "INSERT "
										+ "INTO "
										+ "bank_account_credit_debit_deleted_entry_master "
										+ "("
										+ "entry_id,"
										+ "crusher_id,"
				        				+ "crusher_code,"
				        				+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details) "
										+ "VALUES "
										+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
								
								insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
								
								insertIntoDeletedPSMT.setString(1, acc1CrditDebitId);
								insertIntoDeletedPSMT.setString(2, crusherId);
								insertIntoDeletedPSMT.setString(3, crusherCode);
				        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
								insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
								insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
								insertIntoDeletedPSMT.setTime(7, time);
								insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
								insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
								insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
								insertIntoDeletedPSMT.setString(11, userName);
								insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
								
								  m = insertIntoDeletedPSMT.executeUpdate();
								
								if(insertIntoDeletedPSMT != null)
								{
									insertIntoDeletedPSMT.close();
									insertIntoDeletedPSMT = null;
								}
								
							}
							
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(m>0)
							{
								

							
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc1CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(k>0  )
							{
								
								SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(entryDate1); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
								   
								    if (paymentType.equals("CREDIT")) {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, userName, connection, this.getSessionMap());
								    } else {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, userName, connection, this.getSessionMap());
								    }
								}

							}
							}
							}
						
							
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(acc2CrditDebitId != null && !acc2CrditDebitId.equals("") )
							{
								
							sql = "SELECT "
									+ "entry_id,"
									+ "account_id,"
									+ "account_number,"
									+ "entry_date,"
									+ "entry_time,"
									+ "entry_type,"
									+ "amount,"
									+ "payment_type,"
									+ "entry_by,"
									+ "entry_details "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
									
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc2CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							resultSet = preparedStatement.executeQuery();
							
							int m = 0;
							String paymentType = null;
							String entryDate1 = null;
							String accountId = null;
							Float amount = null;
							
							if(resultSet.next())
							{
								accountId = resultSet.getString(2);
							    paymentType = resultSet.getString(6);
								 entryDate1 = resultSet.getString(4);
								 amount = resultSet.getFloat(7);
								 
								PreparedStatement  insertIntoDeletedPSMT = null;
								
								String inertDeletedSQL = "INSERT "
										+ "INTO "
										+ "bank_account_credit_debit_deleted_entry_master "
										+ "("
										+ "entry_id,"
										+ "crusher_id,"
				        				+ "crusher_code,"
				        				+ "account_id,"
										+ "account_number,"
										+ "entry_date,"
										+ "entry_time,"
										+ "entry_type,"
										+ "amount,"
										+ "payment_type,"
										+ "entry_by,"
										+ "entry_details) "
										+ "VALUES "
										+ "(?,?,?,?,?,?,?,?,?,?,?,?)";
								
								insertIntoDeletedPSMT = connection.prepareStatement(inertDeletedSQL);
								
								insertIntoDeletedPSMT.setString(1, acc2CrditDebitId);
								insertIntoDeletedPSMT.setString(2, crusherId);
								insertIntoDeletedPSMT.setString(3, crusherCode);
				        		insertIntoDeletedPSMT.setString(4, resultSet.getString(2));
								insertIntoDeletedPSMT.setString(5, resultSet.getString(3));
								insertIntoDeletedPSMT.setString(6, resultSet.getString(4));
								insertIntoDeletedPSMT.setTime(7, time);
								insertIntoDeletedPSMT.setString(8, resultSet.getString(6));
								insertIntoDeletedPSMT.setFloat(9, resultSet.getFloat(7));
								insertIntoDeletedPSMT.setString(10, resultSet.getString(8));
								insertIntoDeletedPSMT.setString(11, userName);
								insertIntoDeletedPSMT.setString(12, resultSet.getString(10));
								
								  m = insertIntoDeletedPSMT.executeUpdate();
								
								if(insertIntoDeletedPSMT != null)
								{
									insertIntoDeletedPSMT.close();
									insertIntoDeletedPSMT = null;
								}
								
							}
							
							
							if(resultSet != null)
							{
								resultSet.close();
								resultSet = null;
							}
							if(preparedStatement != null)
							{
								preparedStatement.close();
								preparedStatement = null;
							}
							
							if(m>0)
							{
								

							
							sql = "DELETE "
									+ "FROM "
									+ "bank_account_credit_debit_master "
									+ "WHERE "
									+ "entry_id = ? "
									+ "AND "
									+ "crusher_id = ? "
									+ "AND "
									+ "crusher_code = ? ";
							
							preparedStatement = connection.prepareStatement(sql);
							preparedStatement.setString(1, acc2CrditDebitId);
							preparedStatement.setString(2, crusherId);
							preparedStatement.setString(3, crusherCode);
							
							int k = preparedStatement.executeUpdate();
							
							if(k>0  )
							{
								
								SimpleDateFormat inputDateFormat = new SimpleDateFormat("yyyy-MM-dd");
								Date parsedDate = null;

								try {
								    parsedDate = inputDateFormat.parse(entryDate1); 
								} catch (ParseException e) {
								    e.printStackTrace();  
								}

								if (parsedDate != null) {
								     SimpleDateFormat outputDateFormat = new SimpleDateFormat("dd-MM-yyyy");
								    String formattedDate = outputDateFormat.format(parsedDate); 
								   
								    if (paymentType.equals("CREDIT")) {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "DEBIT", formattedDate, amount, userName, connection, this.getSessionMap());
								    } else {
								    	isCloseingBalMaintained = MaintainCloseingBalUtil.maintainCloseingBal(accountId, "CREDIT", formattedDate, amount, userName, connection, this.getSessionMap());
								    }
								}

							}
							}
							}
							
							if(isCloseingBalMaintained)
							{
								
							
								sql ="DELETE "
			    						+ "FROM "
			    						+ "crusher_customer_payment_details_master "
			    						+ "WHERE "
			    						+ "payement_entry_id = ? "
			    						+ "AND "
		        						+ "crusher_id = ? "
		    							+ "AND "
		    							+ "crusher_code = ? ";
			    				
			    				preparedStatement = connection.prepareStatement(sql);
			    				preparedStatement.setString(1, this.getPaymentId());
			    				preparedStatement.setString(2, crusherId);
		        				preparedStatement.setString(3, crusherCode);
	        				
							
							int rowCount = preparedStatement.executeUpdate();
							
							if(rowCount > 0)
							{
								
								addActionMessage(this.getText("message.success.customerPaymentEntryDeletedSuccessfully"));
		    						connection.commit();
									
									result = SUCCESS;
								
							}
	    				else
	    				{
	    					connection.rollback();
	    					addActionError(this.getText("message.error.customerPaymentEntryNotDeleted"));
	    					result = "error";
	    				}
							}
	    			
						}
	    			
						
						}
					}
	    		
						
    						
    			
	    		catch (SQLException e) {
	    			e.printStackTrace();
	    			result = "error";
	    			
	    			addActionError(e.getErrorCode()+" || "+e.getMessage() +" || "+this.getText("message.error.customerPaymentEntryNotDeleted"));
	    		}
	    		catch (Exception e) {
	    			e.printStackTrace();
	    			addActionError(e.getMessage() +" || "+this.getText("message.error.customerPaymentEntryNotDeleted"));
				}finally {
					if(resultSet != null)
					{
						try {resultSet.close(); resultSet = null;} catch (SQLException e) {}
					}
	    			if(preparedStatement != null)
	    			{
	    				try {preparedStatement.close(); preparedStatement = null;} catch (SQLException e) {}
	    			}
	    			if(connection != null)
	    			{
	    				
	    				try {connection.close(); connection = null;}catch (SQLException e) {}
	    			}
	    			
	    		}
       	
       	
       	
       	
       }
       
       return result;
}

	public HttpSession getSession() {
		return session;
	}

	public void setSession(HttpSession session) {
		this.session = session;
	}

	public String getPaymentId() {
		return paymentId;
	}

	public void setPaymentId(String paymentId) {
		this.paymentId = paymentId;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	public Map<String, String> getCustomerSearchOptionList() {
		return customerSearchOptionList;
	}

	public void setCustomerSearchOptionList(Map<String, String> customerSearchOptionList) {
		this.customerSearchOptionList = customerSearchOptionList;
	}

	public String getCustomerSearchOption() {
		return customerSearchOption;
	}

	public void setCustomerSearchOption(String customerSearchOption) {
		this.customerSearchOption = customerSearchOption;
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	@Override
	public void setSession(Map<String, Object> arg0) {
		// TODO Auto-generated method stub
		sessionMap=(SessionMap<String, Object>)arg0;
	}

	public SessionMap<String, Object> getSessionMap() {
		return sessionMap;
	}

	public void setSessionMap(SessionMap<String, Object> sessionMap) {
		this.sessionMap = sessionMap;
	}

	public String getFromDate() {
		return fromDate;
	}

	public void setFromDate(String fromDate) {
		this.fromDate = fromDate;
	}

	public String getToDate() {
		return toDate;
	}

	public void setToDate(String toDate) {
		this.toDate = toDate;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getDownloadType() {
		return downloadType;
	}

	public void setDownloadType(String downloadType) {
		this.downloadType = downloadType;
	}

	public String getCustMobile() {
		return custMobile;
	}

	public void setCustMobile(String custMobile) {
		this.custMobile = custMobile;
	}

	public String getCustName() {
		return custName;
	}

	public void setCustName(String custName) {
		this.custName = custName;
	}

	public String getKey() {
		return key;
	}

	public void setKey(String key) {
		this.key = key;
	}

	public String getCrusherAccount() {
		return crusherAccount;
	}

	public void setCrusherAccount(String crusherAccount) {
		this.crusherAccount = crusherAccount;
	}

	
	
}
